/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.compile.sparql;

import java.util.HashMap;
import java.util.Map;
import org.aksw.commons.factory.Factory1;
import org.aksw.sparqlify.compile.sparql.DatatypeToString;
import org.aksw.sparqlify.core.SqlDatatype;

class DatatypeToStringPostgres
implements DatatypeToString {
    private Map<String, String> nameToPostgres = new HashMap<String, String>();

    public DatatypeToStringPostgres() {
        this.nameToPostgres.put("boolean", "boolean");
        this.nameToPostgres.put("float", "double precision");
        this.nameToPostgres.put("double", "double precision");
        this.nameToPostgres.put("integer", "integer");
        this.nameToPostgres.put("string", "text");
        this.nameToPostgres.put("geometry", "geometry");
        this.nameToPostgres.put("geography", "geography");
        this.nameToPostgres.put("int", "integer");
        this.nameToPostgres.put("long", "bigint");
        this.nameToPostgres.put("datetime", "date");
    }

    @Override
    public Factory1<String> asString(SqlDatatype datatype) {
        final String result = this.nameToPostgres.get(datatype.getName());
        if (result == null) {
            throw new RuntimeException("No string representation for " + datatype.getName());
        }
        return new Factory1<String>(){

            @Override
            public String create(String a) {
                return a + "::" + result;
            }
        };
    }

    public Factory1<String> formatString(SqlDatatype datatype) {
        if (datatype.getName().equals("geometry") || datatype.getName().equals("geography")) {
            return new Factory1<String>(){

                @Override
                public String create(String a) {
                    return "ST_AsText(" + a + ")";
                }
            };
        }
        final String result = this.nameToPostgres.get(datatype.getName());
        if (result == null) {
            throw new RuntimeException("No string representation for " + datatype.getName());
        }
        return new Factory1<String>(){

            @Override
            public String create(String a) {
                return a + "::" + result;
            }
        };
    }
}

