// $ANTLR 3.5 org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g 2015-09-13 23:20:14

    package org.aksw.sparqlify.config.lang;

    import com.hp.hpl.jena.sparql.expr.*;
    import org.apache.commons.lang.NotImplementedException;
    import com.hp.hpl.jena.graph.*;
    import com.hp.hpl.jena.vocabulary.*;
    import com.hp.hpl.jena.sparql.syntax.*;
    import com.hp.hpl.jena.shared.*;
    import org.aksw.sparqlify.config.syntax.*;
    import com.hp.hpl.jena.shared.impl.*;
    import com.hp.hpl.jena.sparql.core.*;
    import com.hp.hpl.jena.datatypes.*;
    import org.aksw.sparqlify.algebra.sparql.expr.*;
    import com.hp.hpl.jena.rdf.model.AnonId;
    import org.aksw.sparqlify.util.*;
    import org.aksw.jena_sparql_api.utils.*;

    import org.aksw.sparqlify.algebra.sql.nodes.*;
    import com.hp.hpl.jena.sdb.core.JoinType;

    import java.util.Collection;
    import java.util.List;
    import java.util.ArrayList;
    import java.util.Map;
    import java.util.AbstractMap;
    import java.util.HashMap;


    import org.slf4j.Logger;
    import org.slf4j.LoggerFactory;

    import com.hp.hpl.jena.shared.PrefixMapping;
    import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;


    import org.aksw.sparqlify.core.SparqlifyConstants;


import org.antlr.runtime.*;
import org.antlr.runtime.tree.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;

/**
 * @author Simone Tripodi   (simone.tripodi)
 * @author Michele Mostarda (michele.mostarda)
 * @author Juergen Pfundt   (Juergen.Pfundt)
 * @version $Id: Sparql.g 161 2011-05-23 22:14:39Z Juergen.Pfundt@web.de $
 */
@SuppressWarnings("all")
public class SparqlifyConfigTree extends TreeParser {
	public static final String[] tokenNames = new String[] {
		"<invalid>", "<EOR>", "<DOWN>", "<UP>", "A", "ABS", "ADD", "ALIASED_LOGICAL_TABLE", 
		"ALIASED_VAR", "ALL", "AND", "ANY", "ARG_LIST", "AS", "ASC", "ASK", "ASTERISK", 
		"AVG", "BASE", "BIND", "BINDINGS", "BINDING_VALUE", "BLANK_NODE", "BLANK_NODE_LABEL", 
		"BNODE", "BOUND", "BY", "CEIL", "CLEAR", "CLOSE_BRACE", "CLOSE_CURLY_BRACE", 
		"CLOSE_SQUARE_BRACKET", "COALESCE", "COLLECTION", "COMMA", "COMMENT", 
		"CONCAT", "CONSTRAIN", "CONSTRAINTS", "CONSTRUCT", "CONSTRUCT_QUADS", 
		"CONSTRUCT_TRIPLES", "CONSTRUCT_VIEW_DEFINITION", "CONTAINS", "COPY", 
		"COUNT", "CREATE", "DATA", "DATATYPE", "DAY", "DECIMAL", "DECIMAL_NEGATIVE", 
		"DECIMAL_POSITIVE", "DECLARE", "DEFAULT", "DEFINE", "DELETE", "DESC", 
		"DESCRIBE", "DIGIT", "DISTINCT", "DIVIDE", "DOT", "DOUBLE", "DOUBLE_NEGATIVE", 
		"DOUBLE_POSITIVE", "DROP", "ECHAR", "ENCODE_FOR_URI", "EOL", "EQUAL", 
		"EXISTS", "EXPONENT", "EXPRESSION_LIST", "FALSE", "FILTER", "FLOOR", "FROM", 
		"FULL_JOIN", "FUNCTION", "FUNCTION_DECLARATION", "FUNCTION_SIGNATURE", 
		"FUNCTION_TEMPLATE", "GRAPH", "GRAPH_TOKEN", "GREATER", "GREATER_EQUAL", 
		"GROUP", "GROUP_BY", "GROUP_CONCAT", "GROUP_GRAPH_PATTERN", "HAVING", 
		"HOURS", "IF", "IMPORT", "IN", "INSERT", "INTEGER", "INTEGER_NEGATIVE", 
		"INTEGER_POSITIVE", "INTO", "INVERSE", "IRI", "IRI_REF", "IRI_REF_CHARACTERS", 
		"ISBLANK", "ISIRI", "ISLITERAL", "ISNUMERIC", "ISURI", "JOIN_MEMBER", 
		"LANG", "LANGMATCHES", "LANGTAG", "LANGTAG_STR", "LCASE", "LESS", "LESS_EQUAL", 
		"LIMIT", "LOAD", "MACRO_DEF", "MAX", "MD5", "MIN", "MINUS", "MINUS_KEYWORD", 
		"MINUTES", "MODIFY", "MONTH", "MOVE", "NAME", "NAMED", "NAMED_VIEW_TEMPLATE_DEFINITION", 
		"NAME_SUFFIX", "NEGATION", "NESTED_ML_COMMENT", "NOT", "NOT_EQUAL", "NOT_EXISTS", 
		"NOW", "OBJECT", "OFFSET", "OPEN_BRACE", "OPEN_CURLY_BRACE", "OPEN_SQUARE_BRACKET", 
		"OPTIONAL", "OR", "ORDER", "ORDER_BY", "ORDER_CONDITION", "PARAM_TYPE", 
		"PARAM_TYPE_LIST", "PATH", "PATH_NEGATED", "PATH_PRIMARY", "PIPE", "PLAIN_LITERAL", 
		"PLUS", "PNAME_LN", "PNAME_NS", "PN_CHARS", "PN_CHARS_BASE", "PN_CHARS_U", 
		"PN_LOCAL", "PN_PREFIX", "PREDICATE", "PREFIX", "PREFIX_CONSTRAINT", "PREFIX_DECL", 
		"PROLOGUE", "PROPERTY_LIST", "QUERY", "QUESTION_MARK", "RAND", "REDUCED", 
		"REFERENCE", "REGEX", "REGEX_CONSTRAINT", "RELATION_REF", "ROUND", "SAMETERM", 
		"SAMPLE", "SECONDS", "SELECT", "SELECT_CLAUSE", "SEMICOLON", "SEPARATOR", 
		"SERVICE", "SET", "SHA1", "SHA224", "SHA256", "SHA384", "SHA512", "SIGN", 
		"SILENT", "SINGLE_LINE_COMMENT", "SQL_QUERY", "SQL_RELATION", "SQL_TABLE", 
		"STR", "STRDT", "STRENDS", "STRING_LIST", "STRING_LITERAL1", "STRING_LITERAL2", 
		"STRING_LITERAL_LONG1", "STRING_LITERAL_LONG2", "STRLANG", "STRLEN", "STRSTARTS", 
		"SUBJECT", "SUBSELECT", "SUBSTR", "SUM", "TEMPLATE", "TIMEZONE", "TO", 
		"TODO", "TRIPLE", "TRIPLES_BLOCK", "TRIPLES_TEMPLATE", "TRUE", "TYPED_LITERAL", 
		"TZ", "UCASE", "UNARY", "UNARY_MINUS", "UNARY_NOT", "UNARY_PLUS", "UNDEF", 
		"UNION", "UPDATE", "URI", "USING", "VAR", "VAR1", "VAR2", "VAR3", "VARNAME", 
		"VAR_BINDING", "VAR_BINDINGS", "VAR_HEAD", "VIEW", "VIEW_DEFINITION", 
		"VIEW_TEMPLATE_DEFINITION", "WHERE", "WHERE_CLAUSE", "WITH", "WS", "YEAR"
	};
	public static final int EOF=-1;
	public static final int A=4;
	public static final int ABS=5;
	public static final int ADD=6;
	public static final int ALIASED_LOGICAL_TABLE=7;
	public static final int ALIASED_VAR=8;
	public static final int ALL=9;
	public static final int AND=10;
	public static final int ANY=11;
	public static final int ARG_LIST=12;
	public static final int AS=13;
	public static final int ASC=14;
	public static final int ASK=15;
	public static final int ASTERISK=16;
	public static final int AVG=17;
	public static final int BASE=18;
	public static final int BIND=19;
	public static final int BINDINGS=20;
	public static final int BINDING_VALUE=21;
	public static final int BLANK_NODE=22;
	public static final int BLANK_NODE_LABEL=23;
	public static final int BNODE=24;
	public static final int BOUND=25;
	public static final int BY=26;
	public static final int CEIL=27;
	public static final int CLEAR=28;
	public static final int CLOSE_BRACE=29;
	public static final int CLOSE_CURLY_BRACE=30;
	public static final int CLOSE_SQUARE_BRACKET=31;
	public static final int COALESCE=32;
	public static final int COLLECTION=33;
	public static final int COMMA=34;
	public static final int COMMENT=35;
	public static final int CONCAT=36;
	public static final int CONSTRAIN=37;
	public static final int CONSTRAINTS=38;
	public static final int CONSTRUCT=39;
	public static final int CONSTRUCT_QUADS=40;
	public static final int CONSTRUCT_TRIPLES=41;
	public static final int CONSTRUCT_VIEW_DEFINITION=42;
	public static final int CONTAINS=43;
	public static final int COPY=44;
	public static final int COUNT=45;
	public static final int CREATE=46;
	public static final int DATA=47;
	public static final int DATATYPE=48;
	public static final int DAY=49;
	public static final int DECIMAL=50;
	public static final int DECIMAL_NEGATIVE=51;
	public static final int DECIMAL_POSITIVE=52;
	public static final int DECLARE=53;
	public static final int DEFAULT=54;
	public static final int DEFINE=55;
	public static final int DELETE=56;
	public static final int DESC=57;
	public static final int DESCRIBE=58;
	public static final int DIGIT=59;
	public static final int DISTINCT=60;
	public static final int DIVIDE=61;
	public static final int DOT=62;
	public static final int DOUBLE=63;
	public static final int DOUBLE_NEGATIVE=64;
	public static final int DOUBLE_POSITIVE=65;
	public static final int DROP=66;
	public static final int ECHAR=67;
	public static final int ENCODE_FOR_URI=68;
	public static final int EOL=69;
	public static final int EQUAL=70;
	public static final int EXISTS=71;
	public static final int EXPONENT=72;
	public static final int EXPRESSION_LIST=73;
	public static final int FALSE=74;
	public static final int FILTER=75;
	public static final int FLOOR=76;
	public static final int FROM=77;
	public static final int FULL_JOIN=78;
	public static final int FUNCTION=79;
	public static final int FUNCTION_DECLARATION=80;
	public static final int FUNCTION_SIGNATURE=81;
	public static final int FUNCTION_TEMPLATE=82;
	public static final int GRAPH=83;
	public static final int GRAPH_TOKEN=84;
	public static final int GREATER=85;
	public static final int GREATER_EQUAL=86;
	public static final int GROUP=87;
	public static final int GROUP_BY=88;
	public static final int GROUP_CONCAT=89;
	public static final int GROUP_GRAPH_PATTERN=90;
	public static final int HAVING=91;
	public static final int HOURS=92;
	public static final int IF=93;
	public static final int IMPORT=94;
	public static final int IN=95;
	public static final int INSERT=96;
	public static final int INTEGER=97;
	public static final int INTEGER_NEGATIVE=98;
	public static final int INTEGER_POSITIVE=99;
	public static final int INTO=100;
	public static final int INVERSE=101;
	public static final int IRI=102;
	public static final int IRI_REF=103;
	public static final int IRI_REF_CHARACTERS=104;
	public static final int ISBLANK=105;
	public static final int ISIRI=106;
	public static final int ISLITERAL=107;
	public static final int ISNUMERIC=108;
	public static final int ISURI=109;
	public static final int JOIN_MEMBER=110;
	public static final int LANG=111;
	public static final int LANGMATCHES=112;
	public static final int LANGTAG=113;
	public static final int LANGTAG_STR=114;
	public static final int LCASE=115;
	public static final int LESS=116;
	public static final int LESS_EQUAL=117;
	public static final int LIMIT=118;
	public static final int LOAD=119;
	public static final int MACRO_DEF=120;
	public static final int MAX=121;
	public static final int MD5=122;
	public static final int MIN=123;
	public static final int MINUS=124;
	public static final int MINUS_KEYWORD=125;
	public static final int MINUTES=126;
	public static final int MODIFY=127;
	public static final int MONTH=128;
	public static final int MOVE=129;
	public static final int NAME=130;
	public static final int NAMED=131;
	public static final int NAMED_VIEW_TEMPLATE_DEFINITION=132;
	public static final int NAME_SUFFIX=133;
	public static final int NEGATION=134;
	public static final int NESTED_ML_COMMENT=135;
	public static final int NOT=136;
	public static final int NOT_EQUAL=137;
	public static final int NOT_EXISTS=138;
	public static final int NOW=139;
	public static final int OBJECT=140;
	public static final int OFFSET=141;
	public static final int OPEN_BRACE=142;
	public static final int OPEN_CURLY_BRACE=143;
	public static final int OPEN_SQUARE_BRACKET=144;
	public static final int OPTIONAL=145;
	public static final int OR=146;
	public static final int ORDER=147;
	public static final int ORDER_BY=148;
	public static final int ORDER_CONDITION=149;
	public static final int PARAM_TYPE=150;
	public static final int PARAM_TYPE_LIST=151;
	public static final int PATH=152;
	public static final int PATH_NEGATED=153;
	public static final int PATH_PRIMARY=154;
	public static final int PIPE=155;
	public static final int PLAIN_LITERAL=156;
	public static final int PLUS=157;
	public static final int PNAME_LN=158;
	public static final int PNAME_NS=159;
	public static final int PN_CHARS=160;
	public static final int PN_CHARS_BASE=161;
	public static final int PN_CHARS_U=162;
	public static final int PN_LOCAL=163;
	public static final int PN_PREFIX=164;
	public static final int PREDICATE=165;
	public static final int PREFIX=166;
	public static final int PREFIX_CONSTRAINT=167;
	public static final int PREFIX_DECL=168;
	public static final int PROLOGUE=169;
	public static final int PROPERTY_LIST=170;
	public static final int QUERY=171;
	public static final int QUESTION_MARK=172;
	public static final int RAND=173;
	public static final int REDUCED=174;
	public static final int REFERENCE=175;
	public static final int REGEX=176;
	public static final int REGEX_CONSTRAINT=177;
	public static final int RELATION_REF=178;
	public static final int ROUND=179;
	public static final int SAMETERM=180;
	public static final int SAMPLE=181;
	public static final int SECONDS=182;
	public static final int SELECT=183;
	public static final int SELECT_CLAUSE=184;
	public static final int SEMICOLON=185;
	public static final int SEPARATOR=186;
	public static final int SERVICE=187;
	public static final int SET=188;
	public static final int SHA1=189;
	public static final int SHA224=190;
	public static final int SHA256=191;
	public static final int SHA384=192;
	public static final int SHA512=193;
	public static final int SIGN=194;
	public static final int SILENT=195;
	public static final int SINGLE_LINE_COMMENT=196;
	public static final int SQL_QUERY=197;
	public static final int SQL_RELATION=198;
	public static final int SQL_TABLE=199;
	public static final int STR=200;
	public static final int STRDT=201;
	public static final int STRENDS=202;
	public static final int STRING_LIST=203;
	public static final int STRING_LITERAL1=204;
	public static final int STRING_LITERAL2=205;
	public static final int STRING_LITERAL_LONG1=206;
	public static final int STRING_LITERAL_LONG2=207;
	public static final int STRLANG=208;
	public static final int STRLEN=209;
	public static final int STRSTARTS=210;
	public static final int SUBJECT=211;
	public static final int SUBSELECT=212;
	public static final int SUBSTR=213;
	public static final int SUM=214;
	public static final int TEMPLATE=215;
	public static final int TIMEZONE=216;
	public static final int TO=217;
	public static final int TODO=218;
	public static final int TRIPLE=219;
	public static final int TRIPLES_BLOCK=220;
	public static final int TRIPLES_TEMPLATE=221;
	public static final int TRUE=222;
	public static final int TYPED_LITERAL=223;
	public static final int TZ=224;
	public static final int UCASE=225;
	public static final int UNARY=226;
	public static final int UNARY_MINUS=227;
	public static final int UNARY_NOT=228;
	public static final int UNARY_PLUS=229;
	public static final int UNDEF=230;
	public static final int UNION=231;
	public static final int UPDATE=232;
	public static final int URI=233;
	public static final int USING=234;
	public static final int VAR=235;
	public static final int VAR1=236;
	public static final int VAR2=237;
	public static final int VAR3=238;
	public static final int VARNAME=239;
	public static final int VAR_BINDING=240;
	public static final int VAR_BINDINGS=241;
	public static final int VAR_HEAD=242;
	public static final int VIEW=243;
	public static final int VIEW_DEFINITION=244;
	public static final int VIEW_TEMPLATE_DEFINITION=245;
	public static final int WHERE=246;
	public static final int WHERE_CLAUSE=247;
	public static final int WITH=248;
	public static final int WS=249;
	public static final int YEAR=250;

	// delegates
	public TreeParser[] getDelegates() {
		return new TreeParser[] {};
	}

	// delegators


	public SparqlifyConfigTree(TreeNodeStream input) {
		this(input, new RecognizerSharedState());
	}
	public SparqlifyConfigTree(TreeNodeStream input, RecognizerSharedState state) {
		super(input, state);
	}

	@Override public String[] getTokenNames() { return SparqlifyConfigTree.tokenNames; }
	@Override public String getGrammarFileName() { return "org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g"; }


	    private static final Logger logger = LoggerFactory.getLogger("Parser");



	    private PrefixMapping prefixMapping = new PrefixMappingImpl();

	    private Map<String, String> options = new HashMap<String, String>();

	    public PrefixMapping getPrefixMapping() {
	        return prefixMapping;
	    }

	    public Map<String, String> getOptions() {
	        return options;
	    }


	    public Node getDefaultGraph() {
	        String value = options.get("defaultGraph");
	        if(value == null) {
	            value = "";
	        } else {
	            value = value.trim();
	        }


	        Node result;
	        if(value.isEmpty()) {
	            result = Quad.defaultGraphNodeGenerated;
	           }
	           else {
	               result = Node.createURI(value);
	           }

	        return result;
	    }


	    void registerPrefix(String prefix, String uri) {
	        registerPrefix(prefixMapping, new PrefixDecl(prefix, uri));
	    }

	/*
	    void registerPrefix(Config config, String prefix, String uri) {
	        registerPrefix(config.getPrefixMapping(), new PrefixDecl(prefix, uri));
	    }

	    void registerPrefix(TemplateConfig config, String prefix, String uri) {
	        registerPrefix(config.getPrefixMapping(), new PrefixDecl(prefix, uri));
	    }

	    void registerPrefix(ConstructConfig config, String prefix, String uri) {
	        registerPrefix(config.getPrefixMapping(), new PrefixDecl(prefix, uri));
	    }
	*/

	    void registerPrefix(PrefixMapping prefixMapping, PrefixDecl prefixDecl) {
	        // Warn if prefix gets re-registered
	        String uri = prefixMapping.getNsPrefixURI(prefixDecl.getPrefix());

	        if(uri != null) {
	            logger.warn("Prefix '" + prefixDecl.getPrefix() + "' remapped from <" + uri + "> to <" + prefixDecl.getUri() + ">");
	        }

	        prefixMapping.setNsPrefix(prefixDecl.getPrefix(), prefixDecl.getUri());
	    }


	    public String expandPrefix(String prefix) {
	        String result = prefixMapping.getNsPrefixMap().get(prefix);

	        if(result == null) {
	            logger.error("Namespace for prefix '" + prefix + "' not declared");
	            result = "http://sparqlify.org/resource/unresolvedNamespace/";
	        }

	        return result;
	    }


	    public String tryExpandUri(String uri) {
	        String result;

	        int index = uri.indexOf(':');
	        if(index < 0) {
	            result = uri;
	        } else {
	            result = expandUri(uri);
	        }

	        return result;
	    }

	    public String expandUri(String uri) {
	        int index = uri.indexOf(':');
	        if(index < 0) {
	            logger.error("Internal error: Expansion of '" + uri + "' requested although no symbol ':' found.");
	            return uri;
	        }

	        String prefix = uri.substring(0, index);
	        String namespace = expandPrefix(prefix);

	        String result = namespace + uri.substring(index + 1);

	        return result;
	    }

	    public String getErrorMessage(RecognitionException e,
	                                  String[] tokenNames)
	    {
	        List stack = getRuleInvocationStack(e, this.getClass().getName());
	        String msg = null;
	        String inputContext =
	            input.LT(-3) == null ? "" : ((Tree)input.LT(-3)).getText()+" "+
	            input.LT(-2) == null ? "" : ((Tree)input.LT(-2)).getText()+" "+
	            input.LT(-1) == null ? "" : ((Tree)input.LT(-1)).getText()+" >>>"+
	            ((Tree)input.LT(1)).getText()+"<<< "+
	            ((Tree)input.LT(2)).getText()+" "+
	            ((Tree)input.LT(3)).getText();
	        if ( e instanceof NoViableAltException ) {
	           NoViableAltException nvae = (NoViableAltException)e;
	           msg = " no viable alt; token="+e.token+
	              " (decision="+nvae.decisionNumber+
	              " state "+nvae.stateNumber+")"+
	              " decision=<<"+nvae.grammarDecisionDescription+">>";
	        }
	        else {
	           msg = super.getErrorMessage(e, tokenNames);
	        }
	        return stack+" "+msg+" context=..."+inputContext+"...";
	    }
	    public String getTokenErrorDisplay(Token t) {
	        return t.toString();
	    }

	/*
	    void addAsQuad(QuadPattern qp, Template template, Node g) {
	        if(g == null) {
	            g = Quad.defaultGraphNodeGenerated;
	        }

	        for(Triple t : template.getTriples()) {
	            Quad quad = new Quad(g, t);
	            qp.add(quad);
	        }
	    }
	*/

	    public E_Function createUriFunction(ExprList args) {
	        Expr arg;

	        if(args.size() == 1) {
	            arg = args.get(0);
	        } else {
	            arg = new E_StrConcatPermissive(args);
	        }

	        E_Function result = createFunction(SparqlifyConstants.uriLabel, arg);
	        return result;
	    }


	    public E_Function createFunction(String label, Expr ... args) {
	        ExprList exprs = new ExprList();
	        for(Expr arg : args) {
	            if(arg != null) {
	                exprs.add(arg);
	            }
	        }

	        return new E_Function(label, exprs);
	    }




	// $ANTLR start "templateConfig"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:250:1: templateConfig returns [TemplateConfig config] : ( templateConfigItem[config] )+ ;
	public final TemplateConfig templateConfig() throws RecognitionException {
		TemplateConfig config = null;


		 config = new TemplateConfig(); prefixMapping = config.getPrefixMapping(); 
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:252:5: ( ( templateConfigItem[config] )+ )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:252:7: ( templateConfigItem[config] )+
			{
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:252:7: ( templateConfigItem[config] )+
			int cnt1=0;
			loop1:
			while (true) {
				int alt1=2;
				int LA1_0 = input.LA(1);
				if ( (LA1_0==NAMED_VIEW_TEMPLATE_DEFINITION||LA1_0==PREFIX||LA1_0==SET) ) {
					alt1=1;
				}

				switch (alt1) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:252:7: templateConfigItem[config]
					{
					pushFollow(FOLLOW_templateConfigItem_in_templateConfig66);
					templateConfigItem(config);
					state._fsp--;

					}
					break;

				default :
					if ( cnt1 >= 1 ) break loop1;
					EarlyExitException eee = new EarlyExitException(1, input);
					throw eee;
				}
				cnt1++;
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return config;
	}
	// $ANTLR end "templateConfig"



	// $ANTLR start "templateConfigItem"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:255:1: templateConfigItem[TemplateConfig config] : (x= namedViewTemplateDefinition |a= prefixDecl |b= setStmt );
	public final void templateConfigItem(TemplateConfig config) throws RecognitionException {
		NamedViewTemplateDefinition x =null;
		TreeRuleReturnScope a =null;
		Map.Entry<String, String> b =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:256:5: (x= namedViewTemplateDefinition |a= prefixDecl |b= setStmt )
			int alt2=3;
			switch ( input.LA(1) ) {
			case NAMED_VIEW_TEMPLATE_DEFINITION:
				{
				alt2=1;
				}
				break;
			case PREFIX:
				{
				alt2=2;
				}
				break;
			case SET:
				{
				alt2=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 2, 0, input);
				throw nvae;
			}
			switch (alt2) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:256:7: x= namedViewTemplateDefinition
					{
					pushFollow(FOLLOW_namedViewTemplateDefinition_in_templateConfigItem88);
					x=namedViewTemplateDefinition();
					state._fsp--;

					config.getDefinitions().add(x);
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:257:7: a= prefixDecl
					{
					pushFollow(FOLLOW_prefixDecl_in_templateConfigItem100);
					a=prefixDecl();
					state._fsp--;

					registerPrefix((a!=null?((SparqlifyConfigTree.prefixDecl_return)a).prefix:null), (a!=null?((SparqlifyConfigTree.prefixDecl_return)a).uri:null));
					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:258:7: b= setStmt
					{
					pushFollow(FOLLOW_setStmt_in_templateConfigItem112);
					b=setStmt();
					state._fsp--;

					options.put(b.getKey(), b.getValue());
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "templateConfigItem"



	// $ANTLR start "setStmt"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:262:1: setStmt returns [Map.Entry<String, String> value] : ^( SET a= NAME b= string ) ;
	public final Map.Entry<String, String> setStmt() throws RecognitionException {
		Map.Entry<String, String> value = null;


		CommonTree a=null;
		String b =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:263:5: ( ^( SET a= NAME b= string ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:263:7: ^( SET a= NAME b= string )
			{
			match(input,SET,FOLLOW_SET_in_setStmt136); 
			match(input, Token.DOWN, null); 
			a=(CommonTree)match(input,NAME,FOLLOW_NAME_in_setStmt140); 
			pushFollow(FOLLOW_string_in_setStmt144);
			b=string();
			state._fsp--;

			match(input, Token.UP, null); 

			value = new AbstractMap.SimpleEntry<String, String>((a!=null?a.getText():null), b);
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "setStmt"



	// $ANTLR start "constructConfig"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:266:1: constructConfig returns [ConstructConfig config] : ( constructConfigItem[config] )+ ;
	public final ConstructConfig constructConfig() throws RecognitionException {
		ConstructConfig config = null;


		 config = new ConstructConfig(); prefixMapping = config.getPrefixMapping(); 
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:268:5: ( ( constructConfigItem[config] )+ )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:268:7: ( constructConfigItem[config] )+
			{
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:268:7: ( constructConfigItem[config] )+
			int cnt3=0;
			loop3:
			while (true) {
				int alt3=2;
				int LA3_0 = input.LA(1);
				if ( (LA3_0==CONSTRUCT_VIEW_DEFINITION||LA3_0==PREFIX||LA3_0==SET) ) {
					alt3=1;
				}

				switch (alt3) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:268:7: constructConfigItem[config]
					{
					pushFollow(FOLLOW_constructConfigItem_in_constructConfig176);
					constructConfigItem(config);
					state._fsp--;

					}
					break;

				default :
					if ( cnt3 >= 1 ) break loop3;
					EarlyExitException eee = new EarlyExitException(3, input);
					throw eee;
				}
				cnt3++;
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return config;
	}
	// $ANTLR end "constructConfig"



	// $ANTLR start "constructConfigItem"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:271:1: constructConfigItem[ConstructConfig config] : (x= constructViewDefinition[config] |a= prefixDecl |b= setStmt );
	public final void constructConfigItem(ConstructConfig config) throws RecognitionException {
		ConstructViewDefinition x =null;
		TreeRuleReturnScope a =null;
		Map.Entry<String, String> b =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:272:5: (x= constructViewDefinition[config] |a= prefixDecl |b= setStmt )
			int alt4=3;
			switch ( input.LA(1) ) {
			case CONSTRUCT_VIEW_DEFINITION:
				{
				alt4=1;
				}
				break;
			case PREFIX:
				{
				alt4=2;
				}
				break;
			case SET:
				{
				alt4=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 4, 0, input);
				throw nvae;
			}
			switch (alt4) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:272:7: x= constructViewDefinition[config]
					{
					pushFollow(FOLLOW_constructViewDefinition_in_constructConfigItem198);
					x=constructViewDefinition(config);
					state._fsp--;

					 config.getViewDefinitions().add(x); 
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:273:7: a= prefixDecl
					{
					pushFollow(FOLLOW_prefixDecl_in_constructConfigItem211);
					a=prefixDecl();
					state._fsp--;

					 registerPrefix((a!=null?((SparqlifyConfigTree.prefixDecl_return)a).prefix:null), (a!=null?((SparqlifyConfigTree.prefixDecl_return)a).uri:null)); 
					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:274:7: b= setStmt
					{
					pushFollow(FOLLOW_setStmt_in_constructConfigItem223);
					b=setStmt();
					state._fsp--;

					options.put(b.getKey(), b.getValue());
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "constructConfigItem"



	// $ANTLR start "constructViewDefinition"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:277:1: constructViewDefinition[ConstructConfig config] returns [ ConstructViewDefinition value ] : ^( CONSTRUCT_VIEW_DEFINITION a= NAME b= SQL_QUERY ) ;
	public final ConstructViewDefinition constructViewDefinition(ConstructConfig config) throws RecognitionException {
		ConstructViewDefinition value = null;


		CommonTree a=null;
		CommonTree b=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:278:5: ( ^( CONSTRUCT_VIEW_DEFINITION a= NAME b= SQL_QUERY ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:278:7: ^( CONSTRUCT_VIEW_DEFINITION a= NAME b= SQL_QUERY )
			{
			match(input,CONSTRUCT_VIEW_DEFINITION,FOLLOW_CONSTRUCT_VIEW_DEFINITION_in_constructViewDefinition248); 
			match(input, Token.DOWN, null); 
			a=(CommonTree)match(input,NAME,FOLLOW_NAME_in_constructViewDefinition252); 
			b=(CommonTree)match(input,SQL_QUERY,FOLLOW_SQL_QUERY_in_constructViewDefinition256); 
			match(input, Token.UP, null); 

			 value = new ConstructViewDefinition((a!=null?a.getText():null), (b!=null?b.getText():null), prefixMapping); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "constructViewDefinition"



	// $ANTLR start "sparqlifyConfig"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:284:1: sparqlifyConfig returns [Config config] : ( sparqlifyConfigItem[config] )+ ;
	public final Config sparqlifyConfig() throws RecognitionException {
		Config config = null;


		 config = new Config(); prefixMapping = config.getPrefixMapping(); 
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:286:5: ( ( sparqlifyConfigItem[config] )+ )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:286:7: ( sparqlifyConfigItem[config] )+
			{
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:286:7: ( sparqlifyConfigItem[config] )+
			int cnt5=0;
			loop5:
			while (true) {
				int alt5=2;
				int LA5_0 = input.LA(1);
				if ( (LA5_0==FUNCTION_DECLARATION||LA5_0==PREFIX||LA5_0==SET||LA5_0==VIEW_DEFINITION) ) {
					alt5=1;
				}

				switch (alt5) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:286:7: sparqlifyConfigItem[config]
					{
					pushFollow(FOLLOW_sparqlifyConfigItem_in_sparqlifyConfig291);
					sparqlifyConfigItem(config);
					state._fsp--;

					}
					break;

				default :
					if ( cnt5 >= 1 ) break loop5;
					EarlyExitException eee = new EarlyExitException(5, input);
					throw eee;
				}
				cnt5++;
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return config;
	}
	// $ANTLR end "sparqlifyConfig"



	// $ANTLR start "sparqlifyConfigItem"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:289:1: sparqlifyConfigItem[Config config] : (x= viewDefinition |a= prefixDecl |b= functionDeclaration |c= setStmt );
	public final void sparqlifyConfigItem(Config config) throws RecognitionException {
		ViewDefinition x =null;
		TreeRuleReturnScope a =null;
		FunctionDeclarationTemplate b =null;
		Map.Entry<String, String> c =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:290:5: (x= viewDefinition |a= prefixDecl |b= functionDeclaration |c= setStmt )
			int alt6=4;
			switch ( input.LA(1) ) {
			case VIEW_DEFINITION:
				{
				alt6=1;
				}
				break;
			case PREFIX:
				{
				alt6=2;
				}
				break;
			case FUNCTION_DECLARATION:
				{
				alt6=3;
				}
				break;
			case SET:
				{
				alt6=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 6, 0, input);
				throw nvae;
			}
			switch (alt6) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:290:7: x= viewDefinition
					{
					pushFollow(FOLLOW_viewDefinition_in_sparqlifyConfigItem313);
					x=viewDefinition();
					state._fsp--;

					config.getViewDefinitions().add(x);
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:291:7: a= prefixDecl
					{
					pushFollow(FOLLOW_prefixDecl_in_sparqlifyConfigItem330);
					a=prefixDecl();
					state._fsp--;

					registerPrefix((a!=null?((SparqlifyConfigTree.prefixDecl_return)a).prefix:null), (a!=null?((SparqlifyConfigTree.prefixDecl_return)a).uri:null));
					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:292:7: b= functionDeclaration
					{
					pushFollow(FOLLOW_functionDeclaration_in_sparqlifyConfigItem351);
					b=functionDeclaration();
					state._fsp--;

					config.getFunctionDeclarations().add(b);
					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:293:7: c= setStmt
					{
					pushFollow(FOLLOW_setStmt_in_sparqlifyConfigItem363);
					c=setStmt();
					state._fsp--;

					options.put(c.getKey(), c.getValue());
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "sparqlifyConfigItem"



	// $ANTLR start "functionDeclaration"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:298:1: functionDeclaration returns [FunctionDeclarationTemplate value] : ^( FUNCTION_DECLARATION a= functionSignature b= functionTemplate ) ;
	public final FunctionDeclarationTemplate functionDeclaration() throws RecognitionException {
		FunctionDeclarationTemplate value = null;


		FunctionSignature a =null;
		FunctionTemplate b =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:299:5: ( ^( FUNCTION_DECLARATION a= functionSignature b= functionTemplate ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:299:7: ^( FUNCTION_DECLARATION a= functionSignature b= functionTemplate )
			{
			match(input,FUNCTION_DECLARATION,FOLLOW_FUNCTION_DECLARATION_in_functionDeclaration389); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_functionSignature_in_functionDeclaration393);
			a=functionSignature();
			state._fsp--;

			pushFollow(FOLLOW_functionTemplate_in_functionDeclaration397);
			b=functionTemplate();
			state._fsp--;

			match(input, Token.UP, null); 

			value = new FunctionDeclarationTemplate(a, b);
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "functionDeclaration"



	// $ANTLR start "functionSignature"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:302:1: functionSignature returns [FunctionSignature value] : ^( FUNCTION_SIGNATURE a= NAME b= iriRef c= paramTypeList ) ;
	public final FunctionSignature functionSignature() throws RecognitionException {
		FunctionSignature value = null;


		CommonTree a=null;
		Node b =null;
		ParamTypeList c =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:303:5: ( ^( FUNCTION_SIGNATURE a= NAME b= iriRef c= paramTypeList ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:303:7: ^( FUNCTION_SIGNATURE a= NAME b= iriRef c= paramTypeList )
			{
			match(input,FUNCTION_SIGNATURE,FOLLOW_FUNCTION_SIGNATURE_in_functionSignature422); 
			match(input, Token.DOWN, null); 
			a=(CommonTree)match(input,NAME,FOLLOW_NAME_in_functionSignature426); 
			pushFollow(FOLLOW_iriRef_in_functionSignature430);
			b=iriRef();
			state._fsp--;

			pushFollow(FOLLOW_paramTypeList_in_functionSignature434);
			c=paramTypeList();
			state._fsp--;

			match(input, Token.UP, null); 

			value = new FunctionSignature(b.toString(), (a!=null?a.getText():null), c);
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "functionSignature"



	// $ANTLR start "paramTypeList"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:306:1: paramTypeList returns [ParamTypeList value] : ( ^( PARAM_TYPE_LIST (a= paramType )+ ) | ^( PARAM_TYPE_LIST nil ) );
	public final ParamTypeList paramTypeList() throws RecognitionException {
		ParamTypeList value = null;


		ParamType a =null;

		 value = new ParamTypeList(); 
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:308:5: ( ^( PARAM_TYPE_LIST (a= paramType )+ ) | ^( PARAM_TYPE_LIST nil ) )
			int alt8=2;
			int LA8_0 = input.LA(1);
			if ( (LA8_0==PARAM_TYPE_LIST) ) {
				int LA8_1 = input.LA(2);
				if ( (LA8_1==DOWN) ) {
					int LA8_2 = input.LA(3);
					if ( (LA8_2==PARAM_TYPE) ) {
						alt8=1;
					}
					else if ( (LA8_2==OPEN_BRACE) ) {
						alt8=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 8, 2, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 8, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 8, 0, input);
				throw nvae;
			}

			switch (alt8) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:308:7: ^( PARAM_TYPE_LIST (a= paramType )+ )
					{
					match(input,PARAM_TYPE_LIST,FOLLOW_PARAM_TYPE_LIST_in_paramTypeList468); 
					match(input, Token.DOWN, null); 
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:308:25: (a= paramType )+
					int cnt7=0;
					loop7:
					while (true) {
						int alt7=2;
						int LA7_0 = input.LA(1);
						if ( (LA7_0==PARAM_TYPE) ) {
							alt7=1;
						}

						switch (alt7) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:308:26: a= paramType
							{
							pushFollow(FOLLOW_paramType_in_paramTypeList473);
							a=paramType();
							state._fsp--;

							value.add(a);
							}
							break;

						default :
							if ( cnt7 >= 1 ) break loop7;
							EarlyExitException eee = new EarlyExitException(7, input);
							throw eee;
						}
						cnt7++;
					}

					match(input, Token.UP, null); 

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:309:7: ^( PARAM_TYPE_LIST nil )
					{
					match(input,PARAM_TYPE_LIST,FOLLOW_PARAM_TYPE_LIST_in_paramTypeList487); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_nil_in_paramTypeList489);
					nil();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "paramTypeList"



	// $ANTLR start "paramType"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:313:1: paramType returns [ParamType value] : ^( PARAM_TYPE a= NAME b= var ) ;
	public final ParamType paramType() throws RecognitionException {
		ParamType value = null;


		CommonTree a=null;
		Var b =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:314:5: ( ^( PARAM_TYPE a= NAME b= var ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:314:7: ^( PARAM_TYPE a= NAME b= var )
			{
			match(input,PARAM_TYPE,FOLLOW_PARAM_TYPE_in_paramType513); 
			match(input, Token.DOWN, null); 
			a=(CommonTree)match(input,NAME,FOLLOW_NAME_in_paramType517); 
			pushFollow(FOLLOW_var_in_paramType521);
			b=var();
			state._fsp--;

			match(input, Token.UP, null); 

			value = new ParamType((a!=null?a.getText():null), b);
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "paramType"



	// $ANTLR start "functionTemplate"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:318:1: functionTemplate returns [FunctionTemplate value] : ^( FUNCTION_TEMPLATE a= NAME b= expressionList ) ;
	public final FunctionTemplate functionTemplate() throws RecognitionException {
		FunctionTemplate value = null;


		CommonTree a=null;
		ExprList b =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:319:5: ( ^( FUNCTION_TEMPLATE a= NAME b= expressionList ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:319:7: ^( FUNCTION_TEMPLATE a= NAME b= expressionList )
			{
			match(input,FUNCTION_TEMPLATE,FOLLOW_FUNCTION_TEMPLATE_in_functionTemplate547); 
			match(input, Token.DOWN, null); 
			a=(CommonTree)match(input,NAME,FOLLOW_NAME_in_functionTemplate551); 
			pushFollow(FOLLOW_expressionList_in_functionTemplate555);
			b=expressionList();
			state._fsp--;

			match(input, Token.UP, null); 

			value = new FunctionTemplate((a!=null?a.getText():null), b);
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "functionTemplate"



	// $ANTLR start "namedViewTemplateDefinition"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:325:1: namedViewTemplateDefinition returns [NamedViewTemplateDefinition value] : ^( NAMED_VIEW_TEMPLATE_DEFINITION a= NAME b= viewTemplateDefinition ) ;
	public final NamedViewTemplateDefinition namedViewTemplateDefinition() throws RecognitionException {
		NamedViewTemplateDefinition value = null;


		CommonTree a=null;
		ViewTemplateDefinition b =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:326:5: ( ^( NAMED_VIEW_TEMPLATE_DEFINITION a= NAME b= viewTemplateDefinition ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:326:7: ^( NAMED_VIEW_TEMPLATE_DEFINITION a= NAME b= viewTemplateDefinition )
			{
			match(input,NAMED_VIEW_TEMPLATE_DEFINITION,FOLLOW_NAMED_VIEW_TEMPLATE_DEFINITION_in_namedViewTemplateDefinition583); 
			match(input, Token.DOWN, null); 
			a=(CommonTree)match(input,NAME,FOLLOW_NAME_in_namedViewTemplateDefinition587); 
			pushFollow(FOLLOW_viewTemplateDefinition_in_namedViewTemplateDefinition591);
			b=viewTemplateDefinition();
			state._fsp--;

			match(input, Token.UP, null); 

			value = new NamedViewTemplateDefinition((a!=null?a.getText():null), b);
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "namedViewTemplateDefinition"



	// $ANTLR start "viewTemplateDefinition"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:329:1: viewTemplateDefinition returns [ViewTemplateDefinition value] : ^( VIEW_TEMPLATE_DEFINITION a= constructTemplateQuads (b= varBindings )? ) ;
	public final ViewTemplateDefinition viewTemplateDefinition() throws RecognitionException {
		ViewTemplateDefinition value = null;


		QuadPattern a =null;
		List<Expr> b =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:330:5: ( ^( VIEW_TEMPLATE_DEFINITION a= constructTemplateQuads (b= varBindings )? ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:330:7: ^( VIEW_TEMPLATE_DEFINITION a= constructTemplateQuads (b= varBindings )? )
			{
			match(input,VIEW_TEMPLATE_DEFINITION,FOLLOW_VIEW_TEMPLATE_DEFINITION_in_viewTemplateDefinition616); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_constructTemplateQuads_in_viewTemplateDefinition620);
			a=constructTemplateQuads();
			state._fsp--;

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:330:60: (b= varBindings )?
			int alt9=2;
			int LA9_0 = input.LA(1);
			if ( (LA9_0==VAR_BINDINGS) ) {
				alt9=1;
			}
			switch (alt9) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:330:60: b= varBindings
					{
					pushFollow(FOLLOW_varBindings_in_viewTemplateDefinition624);
					b=varBindings();
					state._fsp--;

					}
					break;

			}

			match(input, Token.UP, null); 

			value = new ViewTemplateDefinition(a, b);
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "viewTemplateDefinition"



	// $ANTLR start "viewDefinition"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:333:1: viewDefinition returns [ ViewDefinition value ] : ^( VIEW_DEFINITION a= NAME b= viewTemplateDefinition (d= varConstraints )? (c= sqlRelation )? ) ;
	public final ViewDefinition viewDefinition() throws RecognitionException {
		ViewDefinition value = null;


		CommonTree a=null;
		ViewTemplateDefinition b =null;
		List<Constraint> d =null;
		SqlOp c =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:334:5: ( ^( VIEW_DEFINITION a= NAME b= viewTemplateDefinition (d= varConstraints )? (c= sqlRelation )? ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:334:7: ^( VIEW_DEFINITION a= NAME b= viewTemplateDefinition (d= varConstraints )? (c= sqlRelation )? )
			{
			match(input,VIEW_DEFINITION,FOLLOW_VIEW_DEFINITION_in_viewDefinition650); 
			match(input, Token.DOWN, null); 
			a=(CommonTree)match(input,NAME,FOLLOW_NAME_in_viewDefinition654); 
			pushFollow(FOLLOW_viewTemplateDefinition_in_viewDefinition658);
			b=viewTemplateDefinition();
			state._fsp--;

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:334:58: (d= varConstraints )?
			int alt10=2;
			int LA10_0 = input.LA(1);
			if ( (LA10_0==CONSTRAINTS) ) {
				alt10=1;
			}
			switch (alt10) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:334:58: d= varConstraints
					{
					pushFollow(FOLLOW_varConstraints_in_viewDefinition662);
					d=varConstraints();
					state._fsp--;

					}
					break;

			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:334:76: (c= sqlRelation )?
			int alt11=2;
			int LA11_0 = input.LA(1);
			if ( (LA11_0==RELATION_REF) ) {
				alt11=1;
			}
			switch (alt11) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:334:76: c= sqlRelation
					{
					pushFollow(FOLLOW_sqlRelation_in_viewDefinition667);
					c=sqlRelation();
					state._fsp--;

					}
					break;

			}

			match(input, Token.UP, null); 

			 value = new ViewDefinition((a!=null?a.getText():null), b, c, d); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "viewDefinition"



	// $ANTLR start "varBindings"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:337:1: varBindings returns [List<Expr> value] : ^( VAR_BINDINGS (a= varBinding )+ ) ;
	public final List<Expr> varBindings() throws RecognitionException {
		List<Expr> value = null;


		Expr a =null;

		value = new ArrayList<Expr>();
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:339:5: ( ^( VAR_BINDINGS (a= varBinding )+ ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:339:7: ^( VAR_BINDINGS (a= varBinding )+ )
			{
			match(input,VAR_BINDINGS,FOLLOW_VAR_BINDINGS_in_varBindings702); 
			match(input, Token.DOWN, null); 
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:339:22: (a= varBinding )+
			int cnt12=0;
			loop12:
			while (true) {
				int alt12=2;
				int LA12_0 = input.LA(1);
				if ( (LA12_0==VAR_BINDING) ) {
					alt12=1;
				}

				switch (alt12) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:339:23: a= varBinding
					{
					pushFollow(FOLLOW_varBinding_in_varBindings707);
					a=varBinding();
					state._fsp--;

					value.add(a);
					}
					break;

				default :
					if ( cnt12 >= 1 ) break loop12;
					EarlyExitException eee = new EarlyExitException(12, input);
					throw eee;
				}
				cnt12++;
			}

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "varBindings"



	// $ANTLR start "varBinding"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:343:1: varBinding returns [Expr value] : ^( VAR_BINDING a= var b= typeCtorExpression ) ;
	public final Expr varBinding() throws RecognitionException {
		Expr value = null;


		Var a =null;
		Expr b =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:344:5: ( ^( VAR_BINDING a= var b= typeCtorExpression ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:344:7: ^( VAR_BINDING a= var b= typeCtorExpression )
			{
			match(input,VAR_BINDING,FOLLOW_VAR_BINDING_in_varBinding735); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_var_in_varBinding739);
			a=var();
			state._fsp--;

			pushFollow(FOLLOW_typeCtorExpression_in_varBinding743);
			b=typeCtorExpression();
			state._fsp--;

			match(input, Token.UP, null); 

			value = new E_Equals(new ExprVar(a), b);
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "varBinding"



	// $ANTLR start "typeCtorExpression"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:347:1: typeCtorExpression returns [Expr value] : ( ^( BNODE a= expression ) | ^( URI c= expressionList ) | ^( PLAIN_LITERAL a= expression (b= expression )? ) | ^( TYPED_LITERAL a= expression (b= expression )? ) );
	public final Expr typeCtorExpression() throws RecognitionException {
		Expr value = null;


		Expr a =null;
		ExprList c =null;
		Expr b =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:348:5: ( ^( BNODE a= expression ) | ^( URI c= expressionList ) | ^( PLAIN_LITERAL a= expression (b= expression )? ) | ^( TYPED_LITERAL a= expression (b= expression )? ) )
			int alt15=4;
			switch ( input.LA(1) ) {
			case BNODE:
				{
				alt15=1;
				}
				break;
			case URI:
				{
				alt15=2;
				}
				break;
			case PLAIN_LITERAL:
				{
				alt15=3;
				}
				break;
			case TYPED_LITERAL:
				{
				alt15=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 15, 0, input);
				throw nvae;
			}
			switch (alt15) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:348:7: ^( BNODE a= expression )
					{
					match(input,BNODE,FOLLOW_BNODE_in_typeCtorExpression768); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_typeCtorExpression772);
					a=expression();
					state._fsp--;

					match(input, Token.UP, null); 

					value = createFunction(SparqlifyConstants.blankNodeLabel, a); 
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:349:7: ^( URI c= expressionList )
					{
					match(input,URI,FOLLOW_URI_in_typeCtorExpression784); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expressionList_in_typeCtorExpression788);
					c=expressionList();
					state._fsp--;

					match(input, Token.UP, null); 

					value = createUriFunction(c); 
					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:350:7: ^( PLAIN_LITERAL a= expression (b= expression )? )
					{
					match(input,PLAIN_LITERAL,FOLLOW_PLAIN_LITERAL_in_typeCtorExpression800); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_typeCtorExpression804);
					a=expression();
					state._fsp--;

					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:350:37: (b= expression )?
					int alt13=2;
					int LA13_0 = input.LA(1);
					if ( (LA13_0==AND||LA13_0==ASTERISK||LA13_0==DIVIDE||LA13_0==EQUAL||(LA13_0 >= GREATER && LA13_0 <= GREATER_EQUAL)||LA13_0==IN||(LA13_0 >= LESS && LA13_0 <= LESS_EQUAL)||LA13_0==MINUS||(LA13_0 >= NOT && LA13_0 <= NOT_EQUAL)||LA13_0==OR||LA13_0==PLUS||(LA13_0 >= UNARY && LA13_0 <= UNARY_PLUS)) ) {
						alt13=1;
					}
					switch (alt13) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:350:37: b= expression
							{
							pushFollow(FOLLOW_expression_in_typeCtorExpression808);
							b=expression();
							state._fsp--;

							}
							break;

					}

					match(input, Token.UP, null); 

					value = createFunction(SparqlifyConstants.plainLiteralLabel, a, b); 
					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:351:7: ^( TYPED_LITERAL a= expression (b= expression )? )
					{
					match(input,TYPED_LITERAL,FOLLOW_TYPED_LITERAL_in_typeCtorExpression821); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_typeCtorExpression825);
					a=expression();
					state._fsp--;

					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:351:37: (b= expression )?
					int alt14=2;
					int LA14_0 = input.LA(1);
					if ( (LA14_0==AND||LA14_0==ASTERISK||LA14_0==DIVIDE||LA14_0==EQUAL||(LA14_0 >= GREATER && LA14_0 <= GREATER_EQUAL)||LA14_0==IN||(LA14_0 >= LESS && LA14_0 <= LESS_EQUAL)||LA14_0==MINUS||(LA14_0 >= NOT && LA14_0 <= NOT_EQUAL)||LA14_0==OR||LA14_0==PLUS||(LA14_0 >= UNARY && LA14_0 <= UNARY_PLUS)) ) {
						alt14=1;
					}
					switch (alt14) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:351:37: b= expression
							{
							pushFollow(FOLLOW_expression_in_typeCtorExpression829);
							b=expression();
							state._fsp--;

							}
							break;

					}

					match(input, Token.UP, null); 

					value = createFunction(SparqlifyConstants.typedLiteralLabel, a, b); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "typeCtorExpression"



	// $ANTLR start "sqlRelationOld"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:354:1: sqlRelationOld returns [Relation value] : ( ^( SQL_RELATION a= SQL_QUERY ) | ^( SQL_RELATION a= SQL_TABLE ) );
	public final Relation sqlRelationOld() throws RecognitionException {
		Relation value = null;


		CommonTree a=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:355:5: ( ^( SQL_RELATION a= SQL_QUERY ) | ^( SQL_RELATION a= SQL_TABLE ) )
			int alt16=2;
			int LA16_0 = input.LA(1);
			if ( (LA16_0==SQL_RELATION) ) {
				int LA16_1 = input.LA(2);
				if ( (LA16_1==DOWN) ) {
					int LA16_2 = input.LA(3);
					if ( (LA16_2==SQL_QUERY) ) {
						alt16=1;
					}
					else if ( (LA16_2==SQL_TABLE) ) {
						alt16=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 16, 2, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 16, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 16, 0, input);
				throw nvae;
			}

			switch (alt16) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:355:7: ^( SQL_RELATION a= SQL_QUERY )
					{
					match(input,SQL_RELATION,FOLLOW_SQL_RELATION_in_sqlRelationOld855); 
					match(input, Token.DOWN, null); 
					a=(CommonTree)match(input,SQL_QUERY,FOLLOW_SQL_QUERY_in_sqlRelationOld859); 
					match(input, Token.UP, null); 

					value = new QueryString((a!=null?a.getText():null));
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:356:7: ^( SQL_RELATION a= SQL_TABLE )
					{
					match(input,SQL_RELATION,FOLLOW_SQL_RELATION_in_sqlRelationOld871); 
					match(input, Token.DOWN, null); 
					a=(CommonTree)match(input,SQL_TABLE,FOLLOW_SQL_TABLE_in_sqlRelationOld875); 
					match(input, Token.UP, null); 

					value = new RelationRef((a!=null?a.getText():null));
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "sqlRelationOld"



	// $ANTLR start "sqlRelation"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:361:1: sqlRelation returns [SqlOp value] : ^( RELATION_REF a= joinClause (b= expression )? ) ;
	public final SqlOp sqlRelation() throws RecognitionException {
		SqlOp value = null;


		SqlOp a =null;
		Expr b =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:362:5: ( ^( RELATION_REF a= joinClause (b= expression )? ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:362:7: ^( RELATION_REF a= joinClause (b= expression )? )
			{
			match(input,RELATION_REF,FOLLOW_RELATION_REF_in_sqlRelation902); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_joinClause_in_sqlRelation906);
			a=joinClause();
			state._fsp--;

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:362:36: (b= expression )?
			int alt17=2;
			int LA17_0 = input.LA(1);
			if ( (LA17_0==AND||LA17_0==ASTERISK||LA17_0==DIVIDE||LA17_0==EQUAL||(LA17_0 >= GREATER && LA17_0 <= GREATER_EQUAL)||LA17_0==IN||(LA17_0 >= LESS && LA17_0 <= LESS_EQUAL)||LA17_0==MINUS||(LA17_0 >= NOT && LA17_0 <= NOT_EQUAL)||LA17_0==OR||LA17_0==PLUS||(LA17_0 >= UNARY && LA17_0 <= UNARY_PLUS)) ) {
				alt17=1;
			}
			switch (alt17) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:362:36: b= expression
					{
					pushFollow(FOLLOW_expression_in_sqlRelation910);
					b=expression();
					state._fsp--;

					}
					break;

			}

			match(input, Token.UP, null); 

			value =(b == null) ? a : new SqlOpFilterExpr(null, a, b);
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "sqlRelation"



	// $ANTLR start "joinClause"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:365:1: joinClause returns [SqlOp value] : (a= joinClauseMember | ^( FULL_JOIN a= joinClauseMember b= joinClauseMember ) );
	public final SqlOp joinClause() throws RecognitionException {
		SqlOp value = null;


		SqlOp a =null;
		SqlOp b =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:366:5: (a= joinClauseMember | ^( FULL_JOIN a= joinClauseMember b= joinClauseMember ) )
			int alt18=2;
			int LA18_0 = input.LA(1);
			if ( (LA18_0==JOIN_MEMBER) ) {
				alt18=1;
			}
			else if ( (LA18_0==FULL_JOIN) ) {
				alt18=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 18, 0, input);
				throw nvae;
			}

			switch (alt18) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:366:7: a= joinClauseMember
					{
					pushFollow(FOLLOW_joinClauseMember_in_joinClause937);
					a=joinClauseMember();
					state._fsp--;

					value =a;
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:367:7: ^( FULL_JOIN a= joinClauseMember b= joinClauseMember )
					{
					match(input,FULL_JOIN,FOLLOW_FULL_JOIN_in_joinClause948); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_joinClauseMember_in_joinClause952);
					a=joinClauseMember();
					state._fsp--;

					pushFollow(FOLLOW_joinClauseMember_in_joinClause956);
					b=joinClauseMember();
					state._fsp--;

					match(input, Token.UP, null); 

					value =new SqlOpJoin(null, JoinType.INNER, a, b);
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "joinClause"



	// $ANTLR start "joinClauseMember"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:370:1: joinClauseMember returns [SqlOp value] : ^( JOIN_MEMBER a= sqlLogicalTable (b= NAME )? ) ;
	public final SqlOp joinClauseMember() throws RecognitionException {
		SqlOp value = null;


		CommonTree b=null;
		SqlOp a =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:371:5: ( ^( JOIN_MEMBER a= sqlLogicalTable (b= NAME )? ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:371:7: ^( JOIN_MEMBER a= sqlLogicalTable (b= NAME )? )
			{
			match(input,JOIN_MEMBER,FOLLOW_JOIN_MEMBER_in_joinClauseMember981); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_sqlLogicalTable_in_joinClauseMember985);
			a=sqlLogicalTable();
			state._fsp--;

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:371:40: (b= NAME )?
			int alt19=2;
			int LA19_0 = input.LA(1);
			if ( (LA19_0==NAME) ) {
				alt19=1;
			}
			switch (alt19) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:371:40: b= NAME
					{
					b=(CommonTree)match(input,NAME,FOLLOW_NAME_in_joinClauseMember989); 
					}
					break;

			}

			match(input, Token.UP, null); 

			value = a; ((SqlOpLeaf)value).setAliasName((b!=null?b.getText():null));
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "joinClauseMember"



	// $ANTLR start "sqlLogicalTable"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:374:1: sqlLogicalTable returns [SqlOp value] : ( ^( SQL_RELATION a= SQL_QUERY ) | ^( SQL_RELATION a= SQL_TABLE ) );
	public final SqlOp sqlLogicalTable() throws RecognitionException {
		SqlOp value = null;


		CommonTree a=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:375:5: ( ^( SQL_RELATION a= SQL_QUERY ) | ^( SQL_RELATION a= SQL_TABLE ) )
			int alt20=2;
			int LA20_0 = input.LA(1);
			if ( (LA20_0==SQL_RELATION) ) {
				int LA20_1 = input.LA(2);
				if ( (LA20_1==DOWN) ) {
					int LA20_2 = input.LA(3);
					if ( (LA20_2==SQL_QUERY) ) {
						alt20=1;
					}
					else if ( (LA20_2==SQL_TABLE) ) {
						alt20=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 20, 2, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 20, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 20, 0, input);
				throw nvae;
			}

			switch (alt20) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:375:7: ^( SQL_RELATION a= SQL_QUERY )
					{
					match(input,SQL_RELATION,FOLLOW_SQL_RELATION_in_sqlLogicalTable1015); 
					match(input, Token.DOWN, null); 
					a=(CommonTree)match(input,SQL_QUERY,FOLLOW_SQL_QUERY_in_sqlLogicalTable1019); 
					match(input, Token.UP, null); 

					value = new SqlOpQuery(null, (a!=null?a.getText():null));
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:376:7: ^( SQL_RELATION a= SQL_TABLE )
					{
					match(input,SQL_RELATION,FOLLOW_SQL_RELATION_in_sqlLogicalTable1031); 
					match(input, Token.DOWN, null); 
					a=(CommonTree)match(input,SQL_TABLE,FOLLOW_SQL_TABLE_in_sqlLogicalTable1035); 
					match(input, Token.UP, null); 

					value = new SqlOpTable(null, (a!=null?a.getText():null));
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "sqlLogicalTable"



	// $ANTLR start "varConstraints"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:380:1: varConstraints returns [List<Constraint> value] : ^( CONSTRAINTS (a= varConstraint )+ ) ;
	public final List<Constraint> varConstraints() throws RecognitionException {
		List<Constraint> value = null;


		Constraint a =null;

		value = new ArrayList<Constraint>();
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:382:5: ( ^( CONSTRAINTS (a= varConstraint )+ ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:382:7: ^( CONSTRAINTS (a= varConstraint )+ )
			{
			match(input,CONSTRAINTS,FOLLOW_CONSTRAINTS_in_varConstraints1070); 
			match(input, Token.DOWN, null); 
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:382:21: (a= varConstraint )+
			int cnt21=0;
			loop21:
			while (true) {
				int alt21=2;
				int LA21_0 = input.LA(1);
				if ( (LA21_0==PREFIX_CONSTRAINT||LA21_0==REGEX_CONSTRAINT) ) {
					alt21=1;
				}

				switch (alt21) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:382:22: a= varConstraint
					{
					pushFollow(FOLLOW_varConstraint_in_varConstraints1075);
					a=varConstraint();
					state._fsp--;

					value.add(a);
					}
					break;

				default :
					if ( cnt21 >= 1 ) break loop21;
					EarlyExitException eee = new EarlyExitException(21, input);
					throw eee;
				}
				cnt21++;
			}

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "varConstraints"



	// $ANTLR start "varConstraint"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:385:1: varConstraint returns [Constraint value] : ( (a= regexVarConstraint ) | (b= prefixVarConstraint ) );
	public final Constraint varConstraint() throws RecognitionException {
		Constraint value = null;


		RegexConstraint a =null;
		PrefixConstraint b =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:386:5: ( (a= regexVarConstraint ) | (b= prefixVarConstraint ) )
			int alt22=2;
			int LA22_0 = input.LA(1);
			if ( (LA22_0==REGEX_CONSTRAINT) ) {
				alt22=1;
			}
			else if ( (LA22_0==PREFIX_CONSTRAINT) ) {
				alt22=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 22, 0, input);
				throw nvae;
			}

			switch (alt22) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:386:7: (a= regexVarConstraint )
					{
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:386:7: (a= regexVarConstraint )
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:386:8: a= regexVarConstraint
					{
					pushFollow(FOLLOW_regexVarConstraint_in_varConstraint1103);
					a=regexVarConstraint();
					state._fsp--;

					}

					value = a;
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:387:7: (b= prefixVarConstraint )
					{
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:387:7: (b= prefixVarConstraint )
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:387:8: b= prefixVarConstraint
					{
					pushFollow(FOLLOW_prefixVarConstraint_in_varConstraint1117);
					b=prefixVarConstraint();
					state._fsp--;

					}

					value = b;
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "varConstraint"



	// $ANTLR start "regexVarConstraint"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:390:1: regexVarConstraint returns [RegexConstraint value] : ^( REGEX_CONSTRAINT a= var b= string ) ;
	public final RegexConstraint regexVarConstraint() throws RecognitionException {
		RegexConstraint value = null;


		Var a =null;
		String b =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:391:5: ( ^( REGEX_CONSTRAINT a= var b= string ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:391:7: ^( REGEX_CONSTRAINT a= var b= string )
			{
			match(input,REGEX_CONSTRAINT,FOLLOW_REGEX_CONSTRAINT_in_regexVarConstraint1142); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_var_in_regexVarConstraint1146);
			a=var();
			state._fsp--;

			pushFollow(FOLLOW_string_in_regexVarConstraint1150);
			b=string();
			state._fsp--;

			match(input, Token.UP, null); 

			value = new RegexConstraint(a, "value", b);
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "regexVarConstraint"



	// $ANTLR start "prefixVarConstraint"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:394:1: prefixVarConstraint returns [PrefixConstraint value] : ^( PREFIX_CONSTRAINT a= var b= stringList ) ;
	public final PrefixConstraint prefixVarConstraint() throws RecognitionException {
		PrefixConstraint value = null;


		Var a =null;
		List<String> b =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:395:5: ( ^( PREFIX_CONSTRAINT a= var b= stringList ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:395:7: ^( PREFIX_CONSTRAINT a= var b= stringList )
			{
			match(input,PREFIX_CONSTRAINT,FOLLOW_PREFIX_CONSTRAINT_in_prefixVarConstraint1175); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_var_in_prefixVarConstraint1179);
			a=var();
			state._fsp--;

			pushFollow(FOLLOW_stringList_in_prefixVarConstraint1183);
			b=stringList();
			state._fsp--;

			match(input, Token.UP, null); 

			value = new PrefixConstraint(a, "value", b);
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "prefixVarConstraint"



	// $ANTLR start "stringList"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:398:1: stringList returns [List<String> value] : ^( STRING_LIST (a= string )+ ) ;
	public final List<String> stringList() throws RecognitionException {
		List<String> value = null;


		String a =null;

		value = new ArrayList<String>();
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:400:5: ( ^( STRING_LIST (a= string )+ ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:400:7: ^( STRING_LIST (a= string )+ )
			{
			match(input,STRING_LIST,FOLLOW_STRING_LIST_in_stringList1217); 
			match(input, Token.DOWN, null); 
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:400:21: (a= string )+
			int cnt23=0;
			loop23:
			while (true) {
				int alt23=2;
				int LA23_0 = input.LA(1);
				if ( ((LA23_0 >= STRING_LITERAL1 && LA23_0 <= STRING_LITERAL_LONG2)) ) {
					alt23=1;
				}

				switch (alt23) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:400:22: a= string
					{
					pushFollow(FOLLOW_string_in_stringList1222);
					a=string();
					state._fsp--;

					value.add(a); 
					}
					break;

				default :
					if ( cnt23 >= 1 ) break loop23;
					EarlyExitException eee = new EarlyExitException(23, input);
					throw eee;
				}
				cnt23++;
			}

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "stringList"



	// $ANTLR start "query"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:404:1: query : ( ^( QUERY prologue ( selectQuery )* ( constructQuery )* ( describeQuery )* ( askQuery )* ) ( bindingsClause )* | ^( UPDATE ( update )+ ) );
	public final void query() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:405:5: ( ^( QUERY prologue ( selectQuery )* ( constructQuery )* ( describeQuery )* ( askQuery )* ) ( bindingsClause )* | ^( UPDATE ( update )+ ) )
			int alt30=2;
			int LA30_0 = input.LA(1);
			if ( (LA30_0==QUERY) ) {
				alt30=1;
			}
			else if ( (LA30_0==UPDATE) ) {
				alt30=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 30, 0, input);
				throw nvae;
			}

			switch (alt30) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:405:7: ^( QUERY prologue ( selectQuery )* ( constructQuery )* ( describeQuery )* ( askQuery )* ) ( bindingsClause )*
					{
					match(input,QUERY,FOLLOW_QUERY_in_query1246); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_prologue_in_query1248);
					prologue();
					state._fsp--;

					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:405:24: ( selectQuery )*
					loop24:
					while (true) {
						int alt24=2;
						int LA24_0 = input.LA(1);
						if ( (LA24_0==SELECT) ) {
							alt24=1;
						}

						switch (alt24) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:405:24: selectQuery
							{
							pushFollow(FOLLOW_selectQuery_in_query1250);
							selectQuery();
							state._fsp--;

							}
							break;

						default :
							break loop24;
						}
					}

					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:405:37: ( constructQuery )*
					loop25:
					while (true) {
						int alt25=2;
						int LA25_0 = input.LA(1);
						if ( (LA25_0==CONSTRUCT) ) {
							alt25=1;
						}

						switch (alt25) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:405:37: constructQuery
							{
							pushFollow(FOLLOW_constructQuery_in_query1253);
							constructQuery();
							state._fsp--;

							}
							break;

						default :
							break loop25;
						}
					}

					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:405:53: ( describeQuery )*
					loop26:
					while (true) {
						int alt26=2;
						int LA26_0 = input.LA(1);
						if ( (LA26_0==DESCRIBE) ) {
							alt26=1;
						}

						switch (alt26) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:405:53: describeQuery
							{
							pushFollow(FOLLOW_describeQuery_in_query1256);
							describeQuery();
							state._fsp--;

							}
							break;

						default :
							break loop26;
						}
					}

					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:405:68: ( askQuery )*
					loop27:
					while (true) {
						int alt27=2;
						int LA27_0 = input.LA(1);
						if ( (LA27_0==ASK) ) {
							alt27=1;
						}

						switch (alt27) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:405:68: askQuery
							{
							pushFollow(FOLLOW_askQuery_in_query1259);
							askQuery();
							state._fsp--;

							}
							break;

						default :
							break loop27;
						}
					}

					match(input, Token.UP, null); 

					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:405:79: ( bindingsClause )*
					loop28:
					while (true) {
						int alt28=2;
						int LA28_0 = input.LA(1);
						if ( (LA28_0==BINDINGS) ) {
							alt28=1;
						}

						switch (alt28) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:405:79: bindingsClause
							{
							pushFollow(FOLLOW_bindingsClause_in_query1263);
							bindingsClause();
							state._fsp--;

							}
							break;

						default :
							break loop28;
						}
					}

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:406:7: ^( UPDATE ( update )+ )
					{
					match(input,UPDATE,FOLLOW_UPDATE_in_query1273); 
					match(input, Token.DOWN, null); 
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:406:16: ( update )+
					int cnt29=0;
					loop29:
					while (true) {
						int alt29=2;
						int LA29_0 = input.LA(1);
						if ( (LA29_0==PROLOGUE) ) {
							alt29=1;
						}

						switch (alt29) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:406:16: update
							{
							pushFollow(FOLLOW_update_in_query1275);
							update();
							state._fsp--;

							}
							break;

						default :
							if ( cnt29 >= 1 ) break loop29;
							EarlyExitException eee = new EarlyExitException(29, input);
							throw eee;
						}
						cnt29++;
					}

					match(input, Token.UP, null); 

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "query"



	// $ANTLR start "prologue"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:409:1: prologue : ^( PROLOGUE ( baseDecl )* ( prefixDecl )* ) ;
	public final void prologue() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:410:5: ( ^( PROLOGUE ( baseDecl )* ( prefixDecl )* ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:410:7: ^( PROLOGUE ( baseDecl )* ( prefixDecl )* )
			{
			match(input,PROLOGUE,FOLLOW_PROLOGUE_in_prologue1295); 
			if ( input.LA(1)==Token.DOWN ) {
				match(input, Token.DOWN, null); 
				// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:410:18: ( baseDecl )*
				loop31:
				while (true) {
					int alt31=2;
					int LA31_0 = input.LA(1);
					if ( (LA31_0==BASE) ) {
						alt31=1;
					}

					switch (alt31) {
					case 1 :
						// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:410:18: baseDecl
						{
						pushFollow(FOLLOW_baseDecl_in_prologue1297);
						baseDecl();
						state._fsp--;

						}
						break;

					default :
						break loop31;
					}
				}

				// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:410:28: ( prefixDecl )*
				loop32:
				while (true) {
					int alt32=2;
					int LA32_0 = input.LA(1);
					if ( (LA32_0==PREFIX) ) {
						alt32=1;
					}

					switch (alt32) {
					case 1 :
						// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:410:28: prefixDecl
						{
						pushFollow(FOLLOW_prefixDecl_in_prologue1300);
						prefixDecl();
						state._fsp--;

						}
						break;

					default :
						break loop32;
					}
				}

				match(input, Token.UP, null); 
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "prologue"



	// $ANTLR start "baseDecl"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:413:1: baseDecl : ^( BASE IRI_REF ) ;
	public final void baseDecl() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:414:5: ( ^( BASE IRI_REF ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:414:7: ^( BASE IRI_REF )
			{
			match(input,BASE,FOLLOW_BASE_in_baseDecl1320); 
			match(input, Token.DOWN, null); 
			match(input,IRI_REF,FOLLOW_IRI_REF_in_baseDecl1322); 
			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "baseDecl"


	public static class prefixDecl_return extends TreeRuleReturnScope {
		public String prefix;
		public String uri;
	};


	// $ANTLR start "prefixDecl"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:417:1: prefixDecl returns [String prefix, String uri] : ^( PREFIX a= PNAME_NS b= IRI_REF ) ;
	public final SparqlifyConfigTree.prefixDecl_return prefixDecl() throws RecognitionException {
		SparqlifyConfigTree.prefixDecl_return retval = new SparqlifyConfigTree.prefixDecl_return();
		retval.start = input.LT(1);

		CommonTree a=null;
		CommonTree b=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:418:5: ( ^( PREFIX a= PNAME_NS b= IRI_REF ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:418:7: ^( PREFIX a= PNAME_NS b= IRI_REF )
			{
			match(input,PREFIX,FOLLOW_PREFIX_in_prefixDecl1345); 
			match(input, Token.DOWN, null); 
			a=(CommonTree)match(input,PNAME_NS,FOLLOW_PNAME_NS_in_prefixDecl1349); 
			b=(CommonTree)match(input,IRI_REF,FOLLOW_IRI_REF_in_prefixDecl1353); 
			match(input, Token.UP, null); 

			 retval.prefix =(a!=null?a.getText():null); retval.uri =(b!=null?b.getText():null); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "prefixDecl"



	// $ANTLR start "selectQuery"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:421:1: selectQuery : ^( SELECT selectClause ( datasetClause )* ( whereClause )* solutionModifier ) ;
	public final void selectQuery() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:422:5: ( ^( SELECT selectClause ( datasetClause )* ( whereClause )* solutionModifier ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:422:7: ^( SELECT selectClause ( datasetClause )* ( whereClause )* solutionModifier )
			{
			match(input,SELECT,FOLLOW_SELECT_in_selectQuery1374); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_selectClause_in_selectQuery1376);
			selectClause();
			state._fsp--;

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:422:29: ( datasetClause )*
			loop33:
			while (true) {
				int alt33=2;
				int LA33_0 = input.LA(1);
				if ( (LA33_0==FROM) ) {
					alt33=1;
				}

				switch (alt33) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:422:29: datasetClause
					{
					pushFollow(FOLLOW_datasetClause_in_selectQuery1378);
					datasetClause();
					state._fsp--;

					}
					break;

				default :
					break loop33;
				}
			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:422:44: ( whereClause )*
			loop34:
			while (true) {
				int alt34=2;
				int LA34_0 = input.LA(1);
				if ( (LA34_0==WHERE_CLAUSE) ) {
					alt34=1;
				}

				switch (alt34) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:422:44: whereClause
					{
					pushFollow(FOLLOW_whereClause_in_selectQuery1381);
					whereClause();
					state._fsp--;

					}
					break;

				default :
					break loop34;
				}
			}

			pushFollow(FOLLOW_solutionModifier_in_selectQuery1384);
			solutionModifier();
			state._fsp--;

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "selectQuery"



	// $ANTLR start "subSelect"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:425:1: subSelect : ^( SUBSELECT ( whereClause )* solutionModifier ) ;
	public final void subSelect() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:426:5: ( ^( SUBSELECT ( whereClause )* solutionModifier ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:426:7: ^( SUBSELECT ( whereClause )* solutionModifier )
			{
			match(input,SUBSELECT,FOLLOW_SUBSELECT_in_subSelect1403); 
			if ( input.LA(1)==Token.DOWN ) {
				match(input, Token.DOWN, null); 
				// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:426:19: ( whereClause )*
				loop35:
				while (true) {
					int alt35=2;
					int LA35_0 = input.LA(1);
					if ( (LA35_0==WHERE_CLAUSE) ) {
						alt35=1;
					}

					switch (alt35) {
					case 1 :
						// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:426:19: whereClause
						{
						pushFollow(FOLLOW_whereClause_in_subSelect1405);
						whereClause();
						state._fsp--;

						}
						break;

					default :
						break loop35;
					}
				}

				pushFollow(FOLLOW_solutionModifier_in_subSelect1408);
				solutionModifier();
				state._fsp--;

				match(input, Token.UP, null); 
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "subSelect"



	// $ANTLR start "selectClause"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:429:1: selectClause : ( ^( SELECT_CLAUSE ASTERISK ) | ^( SELECT_CLAUSE DISTINCT ASTERISK ) | ^( SELECT_CLAUSE REDUCED ASTERISK ) | ^( SELECT_CLAUSE ( selectVariables )* ) | ^( SELECT_CLAUSE DISTINCT ( selectVariables )* ) | ^( SELECT_CLAUSE REDUCED ( selectVariables )* ) );
	public final void selectClause() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:430:5: ( ^( SELECT_CLAUSE ASTERISK ) | ^( SELECT_CLAUSE DISTINCT ASTERISK ) | ^( SELECT_CLAUSE REDUCED ASTERISK ) | ^( SELECT_CLAUSE ( selectVariables )* ) | ^( SELECT_CLAUSE DISTINCT ( selectVariables )* ) | ^( SELECT_CLAUSE REDUCED ( selectVariables )* ) )
			int alt39=6;
			int LA39_0 = input.LA(1);
			if ( (LA39_0==SELECT_CLAUSE) ) {
				int LA39_1 = input.LA(2);
				if ( (LA39_1==DOWN) ) {
					switch ( input.LA(3) ) {
					case ASTERISK:
						{
						alt39=1;
						}
						break;
					case DISTINCT:
						{
						int LA39_4 = input.LA(4);
						if ( (LA39_4==ASTERISK) ) {
							alt39=2;
						}
						else if ( (LA39_4==UP||LA39_4==AS||LA39_4==VAR) ) {
							alt39=5;
						}

						else {
							int nvaeMark = input.mark();
							try {
								for (int nvaeConsume = 0; nvaeConsume < 4 - 1; nvaeConsume++) {
									input.consume();
								}
								NoViableAltException nvae =
									new NoViableAltException("", 39, 4, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

						}
						break;
					case REDUCED:
						{
						int LA39_5 = input.LA(4);
						if ( (LA39_5==ASTERISK) ) {
							alt39=3;
						}
						else if ( (LA39_5==UP||LA39_5==AS||LA39_5==VAR) ) {
							alt39=6;
						}

						else {
							int nvaeMark = input.mark();
							try {
								for (int nvaeConsume = 0; nvaeConsume < 4 - 1; nvaeConsume++) {
									input.consume();
								}
								NoViableAltException nvae =
									new NoViableAltException("", 39, 5, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

						}
						break;
					case UP:
					case AS:
					case VAR:
						{
						alt39=4;
						}
						break;
					default:
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 39, 2, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 39, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 39, 0, input);
				throw nvae;
			}

			switch (alt39) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:430:7: ^( SELECT_CLAUSE ASTERISK )
					{
					match(input,SELECT_CLAUSE,FOLLOW_SELECT_CLAUSE_in_selectClause1427); 
					match(input, Token.DOWN, null); 
					match(input,ASTERISK,FOLLOW_ASTERISK_in_selectClause1429); 
					match(input, Token.UP, null); 

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:431:7: ^( SELECT_CLAUSE DISTINCT ASTERISK )
					{
					match(input,SELECT_CLAUSE,FOLLOW_SELECT_CLAUSE_in_selectClause1439); 
					match(input, Token.DOWN, null); 
					match(input,DISTINCT,FOLLOW_DISTINCT_in_selectClause1441); 
					match(input,ASTERISK,FOLLOW_ASTERISK_in_selectClause1443); 
					match(input, Token.UP, null); 

					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:432:7: ^( SELECT_CLAUSE REDUCED ASTERISK )
					{
					match(input,SELECT_CLAUSE,FOLLOW_SELECT_CLAUSE_in_selectClause1453); 
					match(input, Token.DOWN, null); 
					match(input,REDUCED,FOLLOW_REDUCED_in_selectClause1455); 
					match(input,ASTERISK,FOLLOW_ASTERISK_in_selectClause1457); 
					match(input, Token.UP, null); 

					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:433:7: ^( SELECT_CLAUSE ( selectVariables )* )
					{
					match(input,SELECT_CLAUSE,FOLLOW_SELECT_CLAUSE_in_selectClause1467); 
					if ( input.LA(1)==Token.DOWN ) {
						match(input, Token.DOWN, null); 
						// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:433:23: ( selectVariables )*
						loop36:
						while (true) {
							int alt36=2;
							int LA36_0 = input.LA(1);
							if ( (LA36_0==AS||LA36_0==VAR) ) {
								alt36=1;
							}

							switch (alt36) {
							case 1 :
								// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:433:23: selectVariables
								{
								pushFollow(FOLLOW_selectVariables_in_selectClause1469);
								selectVariables();
								state._fsp--;

								}
								break;

							default :
								break loop36;
							}
						}

						match(input, Token.UP, null); 
					}

					}
					break;
				case 5 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:434:7: ^( SELECT_CLAUSE DISTINCT ( selectVariables )* )
					{
					match(input,SELECT_CLAUSE,FOLLOW_SELECT_CLAUSE_in_selectClause1480); 
					match(input, Token.DOWN, null); 
					match(input,DISTINCT,FOLLOW_DISTINCT_in_selectClause1482); 
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:434:32: ( selectVariables )*
					loop37:
					while (true) {
						int alt37=2;
						int LA37_0 = input.LA(1);
						if ( (LA37_0==AS||LA37_0==VAR) ) {
							alt37=1;
						}

						switch (alt37) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:434:32: selectVariables
							{
							pushFollow(FOLLOW_selectVariables_in_selectClause1484);
							selectVariables();
							state._fsp--;

							}
							break;

						default :
							break loop37;
						}
					}

					match(input, Token.UP, null); 

					}
					break;
				case 6 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:435:7: ^( SELECT_CLAUSE REDUCED ( selectVariables )* )
					{
					match(input,SELECT_CLAUSE,FOLLOW_SELECT_CLAUSE_in_selectClause1495); 
					match(input, Token.DOWN, null); 
					match(input,REDUCED,FOLLOW_REDUCED_in_selectClause1497); 
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:435:31: ( selectVariables )*
					loop38:
					while (true) {
						int alt38=2;
						int LA38_0 = input.LA(1);
						if ( (LA38_0==AS||LA38_0==VAR) ) {
							alt38=1;
						}

						switch (alt38) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:435:31: selectVariables
							{
							pushFollow(FOLLOW_selectVariables_in_selectClause1499);
							selectVariables();
							state._fsp--;

							}
							break;

						default :
							break loop38;
						}
					}

					match(input, Token.UP, null); 

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "selectClause"



	// $ANTLR start "selectVariables"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:438:1: selectVariables : ( ^( VAR var ) | ^( AS expression var ) );
	public final void selectVariables() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:439:5: ( ^( VAR var ) | ^( AS expression var ) )
			int alt40=2;
			int LA40_0 = input.LA(1);
			if ( (LA40_0==VAR) ) {
				alt40=1;
			}
			else if ( (LA40_0==AS) ) {
				alt40=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 40, 0, input);
				throw nvae;
			}

			switch (alt40) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:439:7: ^( VAR var )
					{
					match(input,VAR,FOLLOW_VAR_in_selectVariables1519); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_var_in_selectVariables1521);
					var();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:440:7: ^( AS expression var )
					{
					match(input,AS,FOLLOW_AS_in_selectVariables1531); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_selectVariables1533);
					expression();
					state._fsp--;

					pushFollow(FOLLOW_var_in_selectVariables1535);
					var();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "selectVariables"



	// $ANTLR start "constructQuery"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:443:1: constructQuery : ( ^( CONSTRUCT ( constructTemplate )* ( datasetClause )* ( whereClause )* solutionModifier ) | ^( CONSTRUCT ( datasetClause )* ^( WHERE ( triplesTemplate )* ) solutionModifier ) );
	public final void constructQuery() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:444:5: ( ^( CONSTRUCT ( constructTemplate )* ( datasetClause )* ( whereClause )* solutionModifier ) | ^( CONSTRUCT ( datasetClause )* ^( WHERE ( triplesTemplate )* ) solutionModifier ) )
			int alt46=2;
			alt46 = dfa46.predict(input);
			switch (alt46) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:444:7: ^( CONSTRUCT ( constructTemplate )* ( datasetClause )* ( whereClause )* solutionModifier )
					{
					match(input,CONSTRUCT,FOLLOW_CONSTRUCT_in_constructQuery1554); 
					if ( input.LA(1)==Token.DOWN ) {
						match(input, Token.DOWN, null); 
						// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:444:19: ( constructTemplate )*
						loop41:
						while (true) {
							int alt41=2;
							int LA41_0 = input.LA(1);
							if ( (LA41_0==CONSTRUCT_TRIPLES) ) {
								alt41=1;
							}

							switch (alt41) {
							case 1 :
								// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:444:19: constructTemplate
								{
								pushFollow(FOLLOW_constructTemplate_in_constructQuery1556);
								constructTemplate();
								state._fsp--;

								}
								break;

							default :
								break loop41;
							}
						}

						// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:444:38: ( datasetClause )*
						loop42:
						while (true) {
							int alt42=2;
							int LA42_0 = input.LA(1);
							if ( (LA42_0==FROM) ) {
								alt42=1;
							}

							switch (alt42) {
							case 1 :
								// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:444:38: datasetClause
								{
								pushFollow(FOLLOW_datasetClause_in_constructQuery1559);
								datasetClause();
								state._fsp--;

								}
								break;

							default :
								break loop42;
							}
						}

						// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:444:53: ( whereClause )*
						loop43:
						while (true) {
							int alt43=2;
							int LA43_0 = input.LA(1);
							if ( (LA43_0==WHERE_CLAUSE) ) {
								alt43=1;
							}

							switch (alt43) {
							case 1 :
								// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:444:53: whereClause
								{
								pushFollow(FOLLOW_whereClause_in_constructQuery1562);
								whereClause();
								state._fsp--;

								}
								break;

							default :
								break loop43;
							}
						}

						pushFollow(FOLLOW_solutionModifier_in_constructQuery1565);
						solutionModifier();
						state._fsp--;

						match(input, Token.UP, null); 
					}

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:445:7: ^( CONSTRUCT ( datasetClause )* ^( WHERE ( triplesTemplate )* ) solutionModifier )
					{
					match(input,CONSTRUCT,FOLLOW_CONSTRUCT_in_constructQuery1575); 
					match(input, Token.DOWN, null); 
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:445:19: ( datasetClause )*
					loop44:
					while (true) {
						int alt44=2;
						int LA44_0 = input.LA(1);
						if ( (LA44_0==FROM) ) {
							alt44=1;
						}

						switch (alt44) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:445:19: datasetClause
							{
							pushFollow(FOLLOW_datasetClause_in_constructQuery1577);
							datasetClause();
							state._fsp--;

							}
							break;

						default :
							break loop44;
						}
					}

					match(input,WHERE,FOLLOW_WHERE_in_constructQuery1581); 
					if ( input.LA(1)==Token.DOWN ) {
						match(input, Token.DOWN, null); 
						// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:445:42: ( triplesTemplate )*
						loop45:
						while (true) {
							int alt45=2;
							int LA45_0 = input.LA(1);
							if ( (LA45_0==TRIPLES_TEMPLATE) ) {
								alt45=1;
							}

							switch (alt45) {
							case 1 :
								// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:445:42: triplesTemplate
								{
								pushFollow(FOLLOW_triplesTemplate_in_constructQuery1583);
								triplesTemplate();
								state._fsp--;

								}
								break;

							default :
								break loop45;
							}
						}

						match(input, Token.UP, null); 
					}

					pushFollow(FOLLOW_solutionModifier_in_constructQuery1587);
					solutionModifier();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "constructQuery"



	// $ANTLR start "describeQuery"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:448:1: describeQuery : ^( DESCRIBE ( varOrIRIref )* ( ASTERISK )* ( datasetClause )* ( whereClause )? solutionModifier ) ;
	public final void describeQuery() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:449:5: ( ^( DESCRIBE ( varOrIRIref )* ( ASTERISK )* ( datasetClause )* ( whereClause )? solutionModifier ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:449:7: ^( DESCRIBE ( varOrIRIref )* ( ASTERISK )* ( datasetClause )* ( whereClause )? solutionModifier )
			{
			match(input,DESCRIBE,FOLLOW_DESCRIBE_in_describeQuery1606); 
			if ( input.LA(1)==Token.DOWN ) {
				match(input, Token.DOWN, null); 
				// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:449:18: ( varOrIRIref )*
				loop47:
				while (true) {
					int alt47=2;
					int LA47_0 = input.LA(1);
					if ( (LA47_0==IRI_REF||(LA47_0 >= PNAME_LN && LA47_0 <= PNAME_NS)||LA47_0==VAR) ) {
						alt47=1;
					}

					switch (alt47) {
					case 1 :
						// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:449:18: varOrIRIref
						{
						pushFollow(FOLLOW_varOrIRIref_in_describeQuery1608);
						varOrIRIref();
						state._fsp--;

						}
						break;

					default :
						break loop47;
					}
				}

				// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:449:31: ( ASTERISK )*
				loop48:
				while (true) {
					int alt48=2;
					int LA48_0 = input.LA(1);
					if ( (LA48_0==ASTERISK) ) {
						alt48=1;
					}

					switch (alt48) {
					case 1 :
						// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:449:31: ASTERISK
						{
						match(input,ASTERISK,FOLLOW_ASTERISK_in_describeQuery1611); 
						}
						break;

					default :
						break loop48;
					}
				}

				// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:449:41: ( datasetClause )*
				loop49:
				while (true) {
					int alt49=2;
					int LA49_0 = input.LA(1);
					if ( (LA49_0==FROM) ) {
						alt49=1;
					}

					switch (alt49) {
					case 1 :
						// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:449:41: datasetClause
						{
						pushFollow(FOLLOW_datasetClause_in_describeQuery1614);
						datasetClause();
						state._fsp--;

						}
						break;

					default :
						break loop49;
					}
				}

				// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:449:56: ( whereClause )?
				int alt50=2;
				int LA50_0 = input.LA(1);
				if ( (LA50_0==WHERE_CLAUSE) ) {
					alt50=1;
				}
				switch (alt50) {
					case 1 :
						// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:449:56: whereClause
						{
						pushFollow(FOLLOW_whereClause_in_describeQuery1617);
						whereClause();
						state._fsp--;

						}
						break;

				}

				pushFollow(FOLLOW_solutionModifier_in_describeQuery1620);
				solutionModifier();
				state._fsp--;

				match(input, Token.UP, null); 
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "describeQuery"



	// $ANTLR start "askQuery"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:452:1: askQuery : ^( ASK ( datasetClause )* whereClause ) ;
	public final void askQuery() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:453:5: ( ^( ASK ( datasetClause )* whereClause ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:453:7: ^( ASK ( datasetClause )* whereClause )
			{
			match(input,ASK,FOLLOW_ASK_in_askQuery1639); 
			match(input, Token.DOWN, null); 
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:453:13: ( datasetClause )*
			loop51:
			while (true) {
				int alt51=2;
				int LA51_0 = input.LA(1);
				if ( (LA51_0==FROM) ) {
					alt51=1;
				}

				switch (alt51) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:453:13: datasetClause
					{
					pushFollow(FOLLOW_datasetClause_in_askQuery1641);
					datasetClause();
					state._fsp--;

					}
					break;

				default :
					break loop51;
				}
			}

			pushFollow(FOLLOW_whereClause_in_askQuery1644);
			whereClause();
			state._fsp--;

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "askQuery"



	// $ANTLR start "datasetClause"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:456:1: datasetClause : ^( FROM ( NAMED )? iriRef ) ;
	public final void datasetClause() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:457:5: ( ^( FROM ( NAMED )? iriRef ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:457:7: ^( FROM ( NAMED )? iriRef )
			{
			match(input,FROM,FOLLOW_FROM_in_datasetClause1663); 
			match(input, Token.DOWN, null); 
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:457:14: ( NAMED )?
			int alt52=2;
			int LA52_0 = input.LA(1);
			if ( (LA52_0==NAMED) ) {
				alt52=1;
			}
			switch (alt52) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:457:14: NAMED
					{
					match(input,NAMED,FOLLOW_NAMED_in_datasetClause1665); 
					}
					break;

			}

			pushFollow(FOLLOW_iriRef_in_datasetClause1668);
			iriRef();
			state._fsp--;

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "datasetClause"



	// $ANTLR start "whereClause"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:460:1: whereClause : ^( WHERE_CLAUSE groupGraphPattern ) ;
	public final void whereClause() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:461:5: ( ^( WHERE_CLAUSE groupGraphPattern ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:461:7: ^( WHERE_CLAUSE groupGraphPattern )
			{
			match(input,WHERE_CLAUSE,FOLLOW_WHERE_CLAUSE_in_whereClause1687); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_groupGraphPattern_in_whereClause1689);
			groupGraphPattern();
			state._fsp--;

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "whereClause"



	// $ANTLR start "solutionModifier"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:464:1: solutionModifier : ( groupClause )? ( havingClause )? ( orderClause )? ( limitOffsetClauses )? ;
	public final void solutionModifier() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:465:5: ( ( groupClause )? ( havingClause )? ( orderClause )? ( limitOffsetClauses )? )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:465:7: ( groupClause )? ( havingClause )? ( orderClause )? ( limitOffsetClauses )?
			{
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:465:7: ( groupClause )?
			int alt53=2;
			int LA53_0 = input.LA(1);
			if ( (LA53_0==GROUP_BY) ) {
				alt53=1;
			}
			switch (alt53) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:465:7: groupClause
					{
					pushFollow(FOLLOW_groupClause_in_solutionModifier1707);
					groupClause();
					state._fsp--;

					}
					break;

			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:465:20: ( havingClause )?
			int alt54=2;
			int LA54_0 = input.LA(1);
			if ( (LA54_0==HAVING) ) {
				alt54=1;
			}
			switch (alt54) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:465:20: havingClause
					{
					pushFollow(FOLLOW_havingClause_in_solutionModifier1710);
					havingClause();
					state._fsp--;

					}
					break;

			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:465:34: ( orderClause )?
			int alt55=2;
			int LA55_0 = input.LA(1);
			if ( (LA55_0==ORDER_BY) ) {
				alt55=1;
			}
			switch (alt55) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:465:34: orderClause
					{
					pushFollow(FOLLOW_orderClause_in_solutionModifier1713);
					orderClause();
					state._fsp--;

					}
					break;

			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:465:47: ( limitOffsetClauses )?
			int alt56=2;
			int LA56_0 = input.LA(1);
			if ( (LA56_0==LIMIT||LA56_0==OFFSET) ) {
				alt56=1;
			}
			switch (alt56) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:465:47: limitOffsetClauses
					{
					pushFollow(FOLLOW_limitOffsetClauses_in_solutionModifier1716);
					limitOffsetClauses();
					state._fsp--;

					}
					break;

			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "solutionModifier"



	// $ANTLR start "groupClause"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:468:1: groupClause : ^( GROUP_BY ( groupCondition )+ ) ;
	public final void groupClause() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:469:5: ( ^( GROUP_BY ( groupCondition )+ ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:469:7: ^( GROUP_BY ( groupCondition )+ )
			{
			match(input,GROUP_BY,FOLLOW_GROUP_BY_in_groupClause1735); 
			match(input, Token.DOWN, null); 
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:469:18: ( groupCondition )+
			int cnt57=0;
			loop57:
			while (true) {
				int alt57=2;
				int LA57_0 = input.LA(1);
				if ( (LA57_0==ABS||LA57_0==AS||(LA57_0 >= BNODE && LA57_0 <= BOUND)||LA57_0==CEIL||LA57_0==COALESCE||LA57_0==CONCAT||LA57_0==CONTAINS||(LA57_0 >= DATATYPE && LA57_0 <= DAY)||LA57_0==ENCODE_FOR_URI||LA57_0==EXISTS||LA57_0==FLOOR||LA57_0==FUNCTION||(LA57_0 >= HOURS && LA57_0 <= IF)||LA57_0==IRI||(LA57_0 >= ISBLANK && LA57_0 <= ISURI)||(LA57_0 >= LANG && LA57_0 <= LANGMATCHES)||LA57_0==LCASE||LA57_0==MD5||LA57_0==MINUTES||LA57_0==MONTH||(LA57_0 >= NOT_EXISTS && LA57_0 <= NOW)||LA57_0==RAND||LA57_0==REGEX||(LA57_0 >= ROUND && LA57_0 <= SAMETERM)||LA57_0==SECONDS||(LA57_0 >= SHA1 && LA57_0 <= SHA512)||(LA57_0 >= STR && LA57_0 <= STRENDS)||(LA57_0 >= STRLANG && LA57_0 <= STRSTARTS)||LA57_0==SUBSTR||LA57_0==TIMEZONE||(LA57_0 >= TZ && LA57_0 <= UCASE)||LA57_0==URI||LA57_0==VAR||LA57_0==YEAR) ) {
					alt57=1;
				}

				switch (alt57) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:469:18: groupCondition
					{
					pushFollow(FOLLOW_groupCondition_in_groupClause1737);
					groupCondition();
					state._fsp--;

					}
					break;

				default :
					if ( cnt57 >= 1 ) break loop57;
					EarlyExitException eee = new EarlyExitException(57, input);
					throw eee;
				}
				cnt57++;
			}

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "groupClause"



	// $ANTLR start "groupCondition"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:472:1: groupCondition : ( builtInCall | functionCall | ^( AS expression ( var )* ) | var );
	public final void groupCondition() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:473:5: ( builtInCall | functionCall | ^( AS expression ( var )* ) | var )
			int alt59=4;
			switch ( input.LA(1) ) {
			case ABS:
			case BNODE:
			case BOUND:
			case CEIL:
			case COALESCE:
			case CONCAT:
			case CONTAINS:
			case DATATYPE:
			case DAY:
			case ENCODE_FOR_URI:
			case EXISTS:
			case FLOOR:
			case HOURS:
			case IF:
			case IRI:
			case ISBLANK:
			case ISIRI:
			case ISLITERAL:
			case ISNUMERIC:
			case ISURI:
			case LANG:
			case LANGMATCHES:
			case LCASE:
			case MD5:
			case MINUTES:
			case MONTH:
			case NOT_EXISTS:
			case NOW:
			case RAND:
			case REGEX:
			case ROUND:
			case SAMETERM:
			case SECONDS:
			case SHA1:
			case SHA224:
			case SHA256:
			case SHA384:
			case SHA512:
			case STR:
			case STRDT:
			case STRENDS:
			case STRLANG:
			case STRLEN:
			case STRSTARTS:
			case SUBSTR:
			case TIMEZONE:
			case TZ:
			case UCASE:
			case URI:
			case YEAR:
				{
				alt59=1;
				}
				break;
			case FUNCTION:
				{
				alt59=2;
				}
				break;
			case AS:
				{
				alt59=3;
				}
				break;
			case VAR:
				{
				alt59=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 59, 0, input);
				throw nvae;
			}
			switch (alt59) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:473:7: builtInCall
					{
					pushFollow(FOLLOW_builtInCall_in_groupCondition1756);
					builtInCall();
					state._fsp--;

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:474:7: functionCall
					{
					pushFollow(FOLLOW_functionCall_in_groupCondition1764);
					functionCall();
					state._fsp--;

					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:475:7: ^( AS expression ( var )* )
					{
					match(input,AS,FOLLOW_AS_in_groupCondition1773); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_groupCondition1775);
					expression();
					state._fsp--;

					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:475:23: ( var )*
					loop58:
					while (true) {
						int alt58=2;
						int LA58_0 = input.LA(1);
						if ( (LA58_0==VAR) ) {
							alt58=1;
						}

						switch (alt58) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:475:23: var
							{
							pushFollow(FOLLOW_var_in_groupCondition1777);
							var();
							state._fsp--;

							}
							break;

						default :
							break loop58;
						}
					}

					match(input, Token.UP, null); 

					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:476:7: var
					{
					pushFollow(FOLLOW_var_in_groupCondition1787);
					var();
					state._fsp--;

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "groupCondition"



	// $ANTLR start "havingClause"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:479:1: havingClause : ^( HAVING ( constraint )+ ) ;
	public final void havingClause() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:480:5: ( ^( HAVING ( constraint )+ ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:480:7: ^( HAVING ( constraint )+ )
			{
			match(input,HAVING,FOLLOW_HAVING_in_havingClause1805); 
			match(input, Token.DOWN, null); 
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:480:16: ( constraint )+
			int cnt60=0;
			loop60:
			while (true) {
				int alt60=2;
				int LA60_0 = input.LA(1);
				if ( (LA60_0==ABS||LA60_0==AND||LA60_0==ASTERISK||(LA60_0 >= BNODE && LA60_0 <= BOUND)||LA60_0==CEIL||LA60_0==COALESCE||LA60_0==CONCAT||LA60_0==CONTAINS||(LA60_0 >= DATATYPE && LA60_0 <= DAY)||LA60_0==DIVIDE||LA60_0==ENCODE_FOR_URI||(LA60_0 >= EQUAL && LA60_0 <= EXISTS)||LA60_0==FLOOR||LA60_0==FUNCTION||(LA60_0 >= GREATER && LA60_0 <= GREATER_EQUAL)||(LA60_0 >= HOURS && LA60_0 <= IF)||LA60_0==IN||LA60_0==IRI||(LA60_0 >= ISBLANK && LA60_0 <= ISURI)||(LA60_0 >= LANG && LA60_0 <= LANGMATCHES)||(LA60_0 >= LCASE && LA60_0 <= LESS_EQUAL)||LA60_0==MD5||LA60_0==MINUS||LA60_0==MINUTES||LA60_0==MONTH||(LA60_0 >= NOT && LA60_0 <= NOW)||LA60_0==OR||LA60_0==PLUS||LA60_0==RAND||LA60_0==REGEX||(LA60_0 >= ROUND && LA60_0 <= SAMETERM)||LA60_0==SECONDS||(LA60_0 >= SHA1 && LA60_0 <= SHA512)||(LA60_0 >= STR && LA60_0 <= STRENDS)||(LA60_0 >= STRLANG && LA60_0 <= STRSTARTS)||LA60_0==SUBSTR||LA60_0==TIMEZONE||(LA60_0 >= TZ && LA60_0 <= UNARY_PLUS)||LA60_0==URI||LA60_0==YEAR) ) {
					alt60=1;
				}

				switch (alt60) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:480:16: constraint
					{
					pushFollow(FOLLOW_constraint_in_havingClause1807);
					constraint();
					state._fsp--;

					}
					break;

				default :
					if ( cnt60 >= 1 ) break loop60;
					EarlyExitException eee = new EarlyExitException(60, input);
					throw eee;
				}
				cnt60++;
			}

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "havingClause"



	// $ANTLR start "orderClause"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:483:1: orderClause : ^( ORDER_BY ( orderCondition )+ ) ;
	public final void orderClause() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:484:5: ( ^( ORDER_BY ( orderCondition )+ ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:484:7: ^( ORDER_BY ( orderCondition )+ )
			{
			match(input,ORDER_BY,FOLLOW_ORDER_BY_in_orderClause1827); 
			match(input, Token.DOWN, null); 
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:484:18: ( orderCondition )+
			int cnt61=0;
			loop61:
			while (true) {
				int alt61=2;
				int LA61_0 = input.LA(1);
				if ( (LA61_0==ORDER_CONDITION) ) {
					alt61=1;
				}

				switch (alt61) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:484:18: orderCondition
					{
					pushFollow(FOLLOW_orderCondition_in_orderClause1829);
					orderCondition();
					state._fsp--;

					}
					break;

				default :
					if ( cnt61 >= 1 ) break loop61;
					EarlyExitException eee = new EarlyExitException(61, input);
					throw eee;
				}
				cnt61++;
			}

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "orderClause"



	// $ANTLR start "orderCondition"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:487:1: orderCondition : ( ^( ORDER_CONDITION ASC expression ) | ^( ORDER_CONDITION DESC expression ) | ^( ORDER_CONDITION constraint ) | ^( ORDER_CONDITION var ) );
	public final void orderCondition() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:488:5: ( ^( ORDER_CONDITION ASC expression ) | ^( ORDER_CONDITION DESC expression ) | ^( ORDER_CONDITION constraint ) | ^( ORDER_CONDITION var ) )
			int alt62=4;
			int LA62_0 = input.LA(1);
			if ( (LA62_0==ORDER_CONDITION) ) {
				int LA62_1 = input.LA(2);
				if ( (LA62_1==DOWN) ) {
					switch ( input.LA(3) ) {
					case ASC:
						{
						alt62=1;
						}
						break;
					case DESC:
						{
						alt62=2;
						}
						break;
					case ABS:
					case AND:
					case ASTERISK:
					case BNODE:
					case BOUND:
					case CEIL:
					case COALESCE:
					case CONCAT:
					case CONTAINS:
					case DATATYPE:
					case DAY:
					case DIVIDE:
					case ENCODE_FOR_URI:
					case EQUAL:
					case EXISTS:
					case FLOOR:
					case FUNCTION:
					case GREATER:
					case GREATER_EQUAL:
					case HOURS:
					case IF:
					case IN:
					case IRI:
					case ISBLANK:
					case ISIRI:
					case ISLITERAL:
					case ISNUMERIC:
					case ISURI:
					case LANG:
					case LANGMATCHES:
					case LCASE:
					case LESS:
					case LESS_EQUAL:
					case MD5:
					case MINUS:
					case MINUTES:
					case MONTH:
					case NOT:
					case NOT_EQUAL:
					case NOT_EXISTS:
					case NOW:
					case OR:
					case PLUS:
					case RAND:
					case REGEX:
					case ROUND:
					case SAMETERM:
					case SECONDS:
					case SHA1:
					case SHA224:
					case SHA256:
					case SHA384:
					case SHA512:
					case STR:
					case STRDT:
					case STRENDS:
					case STRLANG:
					case STRLEN:
					case STRSTARTS:
					case SUBSTR:
					case TIMEZONE:
					case TZ:
					case UCASE:
					case UNARY:
					case UNARY_MINUS:
					case UNARY_NOT:
					case UNARY_PLUS:
					case URI:
					case YEAR:
						{
						alt62=3;
						}
						break;
					case VAR:
						{
						alt62=4;
						}
						break;
					default:
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 62, 2, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 62, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 62, 0, input);
				throw nvae;
			}

			switch (alt62) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:488:7: ^( ORDER_CONDITION ASC expression )
					{
					match(input,ORDER_CONDITION,FOLLOW_ORDER_CONDITION_in_orderCondition1849); 
					match(input, Token.DOWN, null); 
					match(input,ASC,FOLLOW_ASC_in_orderCondition1851); 
					pushFollow(FOLLOW_expression_in_orderCondition1853);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:489:7: ^( ORDER_CONDITION DESC expression )
					{
					match(input,ORDER_CONDITION,FOLLOW_ORDER_CONDITION_in_orderCondition1863); 
					match(input, Token.DOWN, null); 
					match(input,DESC,FOLLOW_DESC_in_orderCondition1865); 
					pushFollow(FOLLOW_expression_in_orderCondition1867);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:490:7: ^( ORDER_CONDITION constraint )
					{
					match(input,ORDER_CONDITION,FOLLOW_ORDER_CONDITION_in_orderCondition1877); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_constraint_in_orderCondition1879);
					constraint();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:491:7: ^( ORDER_CONDITION var )
					{
					match(input,ORDER_CONDITION,FOLLOW_ORDER_CONDITION_in_orderCondition1889); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_var_in_orderCondition1891);
					var();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "orderCondition"



	// $ANTLR start "limitOffsetClauses"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:494:1: limitOffsetClauses : ( ^( LIMIT INTEGER ) ( ^( OFFSET INTEGER ) )* | ^( OFFSET INTEGER ) ( ^( LIMIT INTEGER ) )* );
	public final void limitOffsetClauses() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:495:5: ( ^( LIMIT INTEGER ) ( ^( OFFSET INTEGER ) )* | ^( OFFSET INTEGER ) ( ^( LIMIT INTEGER ) )* )
			int alt65=2;
			int LA65_0 = input.LA(1);
			if ( (LA65_0==LIMIT) ) {
				alt65=1;
			}
			else if ( (LA65_0==OFFSET) ) {
				alt65=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 65, 0, input);
				throw nvae;
			}

			switch (alt65) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:495:7: ^( LIMIT INTEGER ) ( ^( OFFSET INTEGER ) )*
					{
					match(input,LIMIT,FOLLOW_LIMIT_in_limitOffsetClauses1910); 
					match(input, Token.DOWN, null); 
					match(input,INTEGER,FOLLOW_INTEGER_in_limitOffsetClauses1912); 
					match(input, Token.UP, null); 

					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:495:24: ( ^( OFFSET INTEGER ) )*
					loop63:
					while (true) {
						int alt63=2;
						int LA63_0 = input.LA(1);
						if ( (LA63_0==OFFSET) ) {
							alt63=1;
						}

						switch (alt63) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:495:25: ^( OFFSET INTEGER )
							{
							match(input,OFFSET,FOLLOW_OFFSET_in_limitOffsetClauses1917); 
							match(input, Token.DOWN, null); 
							match(input,INTEGER,FOLLOW_INTEGER_in_limitOffsetClauses1919); 
							match(input, Token.UP, null); 

							}
							break;

						default :
							break loop63;
						}
					}

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:496:7: ^( OFFSET INTEGER ) ( ^( LIMIT INTEGER ) )*
					{
					match(input,OFFSET,FOLLOW_OFFSET_in_limitOffsetClauses1931); 
					match(input, Token.DOWN, null); 
					match(input,INTEGER,FOLLOW_INTEGER_in_limitOffsetClauses1933); 
					match(input, Token.UP, null); 

					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:496:25: ( ^( LIMIT INTEGER ) )*
					loop64:
					while (true) {
						int alt64=2;
						int LA64_0 = input.LA(1);
						if ( (LA64_0==LIMIT) ) {
							alt64=1;
						}

						switch (alt64) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:496:26: ^( LIMIT INTEGER )
							{
							match(input,LIMIT,FOLLOW_LIMIT_in_limitOffsetClauses1938); 
							match(input, Token.DOWN, null); 
							match(input,INTEGER,FOLLOW_INTEGER_in_limitOffsetClauses1940); 
							match(input, Token.UP, null); 

							}
							break;

						default :
							break loop64;
						}
					}

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "limitOffsetClauses"



	// $ANTLR start "bindingsClause"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:500:1: bindingsClause : ^( BINDINGS ( var )* ( bindingValueList )* ) ;
	public final void bindingsClause() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:501:5: ( ^( BINDINGS ( var )* ( bindingValueList )* ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:501:7: ^( BINDINGS ( var )* ( bindingValueList )* )
			{
			match(input,BINDINGS,FOLLOW_BINDINGS_in_bindingsClause1962); 
			if ( input.LA(1)==Token.DOWN ) {
				match(input, Token.DOWN, null); 
				// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:501:18: ( var )*
				loop66:
				while (true) {
					int alt66=2;
					int LA66_0 = input.LA(1);
					if ( (LA66_0==VAR) ) {
						alt66=1;
					}

					switch (alt66) {
					case 1 :
						// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:501:18: var
						{
						pushFollow(FOLLOW_var_in_bindingsClause1964);
						var();
						state._fsp--;

						}
						break;

					default :
						break loop66;
					}
				}

				// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:501:23: ( bindingValueList )*
				loop67:
				while (true) {
					int alt67=2;
					int LA67_0 = input.LA(1);
					if ( (LA67_0==BINDING_VALUE) ) {
						alt67=1;
					}

					switch (alt67) {
					case 1 :
						// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:501:23: bindingValueList
						{
						pushFollow(FOLLOW_bindingValueList_in_bindingsClause1967);
						bindingValueList();
						state._fsp--;

						}
						break;

					default :
						break loop67;
					}
				}

				match(input, Token.UP, null); 
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "bindingsClause"



	// $ANTLR start "bindingValueList"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:504:1: bindingValueList : ^( BINDING_VALUE ( bindingValue )* ) ;
	public final void bindingValueList() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:505:5: ( ^( BINDING_VALUE ( bindingValue )* ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:505:7: ^( BINDING_VALUE ( bindingValue )* )
			{
			match(input,BINDING_VALUE,FOLLOW_BINDING_VALUE_in_bindingValueList1987); 
			if ( input.LA(1)==Token.DOWN ) {
				match(input, Token.DOWN, null); 
				// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:505:23: ( bindingValue )*
				loop68:
				while (true) {
					int alt68=2;
					int LA68_0 = input.LA(1);
					if ( ((LA68_0 >= DECIMAL && LA68_0 <= DECIMAL_POSITIVE)||(LA68_0 >= DOUBLE && LA68_0 <= DOUBLE_POSITIVE)||LA68_0==FALSE||(LA68_0 >= INTEGER && LA68_0 <= INTEGER_POSITIVE)||LA68_0==IRI_REF||LA68_0==PLAIN_LITERAL||(LA68_0 >= PNAME_LN && LA68_0 <= PNAME_NS)||(LA68_0 >= TRUE && LA68_0 <= TYPED_LITERAL)||LA68_0==UNDEF) ) {
						alt68=1;
					}

					switch (alt68) {
					case 1 :
						// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:505:23: bindingValue
						{
						pushFollow(FOLLOW_bindingValue_in_bindingValueList1989);
						bindingValue();
						state._fsp--;

						}
						break;

					default :
						break loop68;
					}
				}

				match(input, Token.UP, null); 
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "bindingValueList"



	// $ANTLR start "bindingValue"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:508:1: bindingValue returns [Node value] : (a= iriRef |a= rdfLiteral | numericLiteral | booleanLiteral | UNDEF );
	public final Node bindingValue() throws RecognitionException {
		Node value = null;


		Node a =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:509:5: (a= iriRef |a= rdfLiteral | numericLiteral | booleanLiteral | UNDEF )
			int alt69=5;
			switch ( input.LA(1) ) {
			case IRI_REF:
			case PNAME_LN:
			case PNAME_NS:
				{
				alt69=1;
				}
				break;
			case PLAIN_LITERAL:
			case TYPED_LITERAL:
				{
				alt69=2;
				}
				break;
			case DECIMAL:
			case DECIMAL_NEGATIVE:
			case DECIMAL_POSITIVE:
			case DOUBLE:
			case DOUBLE_NEGATIVE:
			case DOUBLE_POSITIVE:
			case INTEGER:
			case INTEGER_NEGATIVE:
			case INTEGER_POSITIVE:
				{
				alt69=3;
				}
				break;
			case FALSE:
			case TRUE:
				{
				alt69=4;
				}
				break;
			case UNDEF:
				{
				alt69=5;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 69, 0, input);
				throw nvae;
			}
			switch (alt69) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:509:7: a= iriRef
					{
					pushFollow(FOLLOW_iriRef_in_bindingValue2014);
					a=iriRef();
					state._fsp--;

					value =a;
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:510:7: a= rdfLiteral
					{
					pushFollow(FOLLOW_rdfLiteral_in_bindingValue2026);
					a=rdfLiteral();
					state._fsp--;

					value =a;
					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:511:7: numericLiteral
					{
					pushFollow(FOLLOW_numericLiteral_in_bindingValue2036);
					numericLiteral();
					state._fsp--;

					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:512:7: booleanLiteral
					{
					pushFollow(FOLLOW_booleanLiteral_in_bindingValue2044);
					booleanLiteral();
					state._fsp--;

					}
					break;
				case 5 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:513:7: UNDEF
					{
					match(input,UNDEF,FOLLOW_UNDEF_in_bindingValue2052); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "bindingValue"



	// $ANTLR start "update"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:516:1: update : prologue ( load )* ( clear )* ( drop )* ( add )* ( move )* ( copy )* ( create )* ( insert )* ( delete )* ( modify )* ;
	public final void update() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:517:5: ( prologue ( load )* ( clear )* ( drop )* ( add )* ( move )* ( copy )* ( create )* ( insert )* ( delete )* ( modify )* )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:517:7: prologue ( load )* ( clear )* ( drop )* ( add )* ( move )* ( copy )* ( create )* ( insert )* ( delete )* ( modify )*
			{
			pushFollow(FOLLOW_prologue_in_update2069);
			prologue();
			state._fsp--;

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:517:16: ( load )*
			loop70:
			while (true) {
				int alt70=2;
				int LA70_0 = input.LA(1);
				if ( (LA70_0==LOAD) ) {
					alt70=1;
				}

				switch (alt70) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:517:16: load
					{
					pushFollow(FOLLOW_load_in_update2071);
					load();
					state._fsp--;

					}
					break;

				default :
					break loop70;
				}
			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:517:22: ( clear )*
			loop71:
			while (true) {
				int alt71=2;
				int LA71_0 = input.LA(1);
				if ( (LA71_0==CLEAR) ) {
					alt71=1;
				}

				switch (alt71) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:517:22: clear
					{
					pushFollow(FOLLOW_clear_in_update2074);
					clear();
					state._fsp--;

					}
					break;

				default :
					break loop71;
				}
			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:517:29: ( drop )*
			loop72:
			while (true) {
				int alt72=2;
				int LA72_0 = input.LA(1);
				if ( (LA72_0==DROP) ) {
					alt72=1;
				}

				switch (alt72) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:517:29: drop
					{
					pushFollow(FOLLOW_drop_in_update2077);
					drop();
					state._fsp--;

					}
					break;

				default :
					break loop72;
				}
			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:517:35: ( add )*
			loop73:
			while (true) {
				int alt73=2;
				int LA73_0 = input.LA(1);
				if ( (LA73_0==ADD) ) {
					alt73=1;
				}

				switch (alt73) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:517:35: add
					{
					pushFollow(FOLLOW_add_in_update2080);
					add();
					state._fsp--;

					}
					break;

				default :
					break loop73;
				}
			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:517:40: ( move )*
			loop74:
			while (true) {
				int alt74=2;
				int LA74_0 = input.LA(1);
				if ( (LA74_0==MOVE) ) {
					alt74=1;
				}

				switch (alt74) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:517:40: move
					{
					pushFollow(FOLLOW_move_in_update2083);
					move();
					state._fsp--;

					}
					break;

				default :
					break loop74;
				}
			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:517:46: ( copy )*
			loop75:
			while (true) {
				int alt75=2;
				int LA75_0 = input.LA(1);
				if ( (LA75_0==COPY) ) {
					alt75=1;
				}

				switch (alt75) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:517:46: copy
					{
					pushFollow(FOLLOW_copy_in_update2086);
					copy();
					state._fsp--;

					}
					break;

				default :
					break loop75;
				}
			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:517:52: ( create )*
			loop76:
			while (true) {
				int alt76=2;
				int LA76_0 = input.LA(1);
				if ( (LA76_0==CREATE) ) {
					alt76=1;
				}

				switch (alt76) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:517:52: create
					{
					pushFollow(FOLLOW_create_in_update2089);
					create();
					state._fsp--;

					}
					break;

				default :
					break loop76;
				}
			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:517:60: ( insert )*
			loop77:
			while (true) {
				int alt77=2;
				int LA77_0 = input.LA(1);
				if ( (LA77_0==INSERT) ) {
					alt77=1;
				}

				switch (alt77) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:517:60: insert
					{
					pushFollow(FOLLOW_insert_in_update2092);
					insert();
					state._fsp--;

					}
					break;

				default :
					break loop77;
				}
			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:517:68: ( delete )*
			loop78:
			while (true) {
				int alt78=2;
				int LA78_0 = input.LA(1);
				if ( (LA78_0==DELETE) ) {
					alt78=1;
				}

				switch (alt78) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:517:68: delete
					{
					pushFollow(FOLLOW_delete_in_update2095);
					delete();
					state._fsp--;

					}
					break;

				default :
					break loop78;
				}
			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:517:76: ( modify )*
			loop79:
			while (true) {
				int alt79=2;
				int LA79_0 = input.LA(1);
				if ( (LA79_0==MODIFY) ) {
					alt79=1;
				}

				switch (alt79) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:517:76: modify
					{
					pushFollow(FOLLOW_modify_in_update2098);
					modify();
					state._fsp--;

					}
					break;

				default :
					break loop79;
				}
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "update"



	// $ANTLR start "load"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:520:1: load : ^( LOAD ( SILENT )* iriRef ( graphRef )* ) ;
	public final void load() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:521:5: ( ^( LOAD ( SILENT )* iriRef ( graphRef )* ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:521:7: ^( LOAD ( SILENT )* iriRef ( graphRef )* )
			{
			match(input,LOAD,FOLLOW_LOAD_in_load2117); 
			match(input, Token.DOWN, null); 
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:521:14: ( SILENT )*
			loop80:
			while (true) {
				int alt80=2;
				int LA80_0 = input.LA(1);
				if ( (LA80_0==SILENT) ) {
					alt80=1;
				}

				switch (alt80) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:521:14: SILENT
					{
					match(input,SILENT,FOLLOW_SILENT_in_load2119); 
					}
					break;

				default :
					break loop80;
				}
			}

			pushFollow(FOLLOW_iriRef_in_load2122);
			iriRef();
			state._fsp--;

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:521:29: ( graphRef )*
			loop81:
			while (true) {
				int alt81=2;
				int LA81_0 = input.LA(1);
				if ( (LA81_0==GRAPH) ) {
					alt81=1;
				}

				switch (alt81) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:521:29: graphRef
					{
					pushFollow(FOLLOW_graphRef_in_load2124);
					graphRef();
					state._fsp--;

					}
					break;

				default :
					break loop81;
				}
			}

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "load"



	// $ANTLR start "clear"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:524:1: clear : ^( CLEAR ( SILENT )* graphRefAll ) ;
	public final void clear() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:525:5: ( ^( CLEAR ( SILENT )* graphRefAll ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:525:7: ^( CLEAR ( SILENT )* graphRefAll )
			{
			match(input,CLEAR,FOLLOW_CLEAR_in_clear2144); 
			match(input, Token.DOWN, null); 
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:525:15: ( SILENT )*
			loop82:
			while (true) {
				int alt82=2;
				int LA82_0 = input.LA(1);
				if ( (LA82_0==SILENT) ) {
					alt82=1;
				}

				switch (alt82) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:525:15: SILENT
					{
					match(input,SILENT,FOLLOW_SILENT_in_clear2146); 
					}
					break;

				default :
					break loop82;
				}
			}

			pushFollow(FOLLOW_graphRefAll_in_clear2149);
			graphRefAll();
			state._fsp--;

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "clear"



	// $ANTLR start "drop"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:528:1: drop : ^( DROP ( SILENT )* graphRefAll ) ;
	public final void drop() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:529:5: ( ^( DROP ( SILENT )* graphRefAll ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:529:7: ^( DROP ( SILENT )* graphRefAll )
			{
			match(input,DROP,FOLLOW_DROP_in_drop2168); 
			match(input, Token.DOWN, null); 
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:529:14: ( SILENT )*
			loop83:
			while (true) {
				int alt83=2;
				int LA83_0 = input.LA(1);
				if ( (LA83_0==SILENT) ) {
					alt83=1;
				}

				switch (alt83) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:529:14: SILENT
					{
					match(input,SILENT,FOLLOW_SILENT_in_drop2170); 
					}
					break;

				default :
					break loop83;
				}
			}

			pushFollow(FOLLOW_graphRefAll_in_drop2173);
			graphRefAll();
			state._fsp--;

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "drop"



	// $ANTLR start "create"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:532:1: create : ^( CREATE ( SILENT )* graphRef ) ;
	public final void create() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:533:5: ( ^( CREATE ( SILENT )* graphRef ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:533:7: ^( CREATE ( SILENT )* graphRef )
			{
			match(input,CREATE,FOLLOW_CREATE_in_create2192); 
			match(input, Token.DOWN, null); 
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:533:16: ( SILENT )*
			loop84:
			while (true) {
				int alt84=2;
				int LA84_0 = input.LA(1);
				if ( (LA84_0==SILENT) ) {
					alt84=1;
				}

				switch (alt84) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:533:16: SILENT
					{
					match(input,SILENT,FOLLOW_SILENT_in_create2194); 
					}
					break;

				default :
					break loop84;
				}
			}

			pushFollow(FOLLOW_graphRef_in_create2197);
			graphRef();
			state._fsp--;

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "create"



	// $ANTLR start "add"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:536:1: add : ^( ADD ( SILENT )* graphOrDefault graphOrDefault ) ;
	public final void add() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:537:5: ( ^( ADD ( SILENT )* graphOrDefault graphOrDefault ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:537:7: ^( ADD ( SILENT )* graphOrDefault graphOrDefault )
			{
			match(input,ADD,FOLLOW_ADD_in_add2216); 
			match(input, Token.DOWN, null); 
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:537:13: ( SILENT )*
			loop85:
			while (true) {
				int alt85=2;
				int LA85_0 = input.LA(1);
				if ( (LA85_0==SILENT) ) {
					alt85=1;
				}

				switch (alt85) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:537:13: SILENT
					{
					match(input,SILENT,FOLLOW_SILENT_in_add2218); 
					}
					break;

				default :
					break loop85;
				}
			}

			pushFollow(FOLLOW_graphOrDefault_in_add2221);
			graphOrDefault();
			state._fsp--;

			pushFollow(FOLLOW_graphOrDefault_in_add2223);
			graphOrDefault();
			state._fsp--;

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "add"



	// $ANTLR start "move"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:540:1: move : ^( MOVE ( SILENT )* graphOrDefault graphOrDefault ) ;
	public final void move() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:541:5: ( ^( MOVE ( SILENT )* graphOrDefault graphOrDefault ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:541:7: ^( MOVE ( SILENT )* graphOrDefault graphOrDefault )
			{
			match(input,MOVE,FOLLOW_MOVE_in_move2242); 
			match(input, Token.DOWN, null); 
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:541:14: ( SILENT )*
			loop86:
			while (true) {
				int alt86=2;
				int LA86_0 = input.LA(1);
				if ( (LA86_0==SILENT) ) {
					alt86=1;
				}

				switch (alt86) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:541:14: SILENT
					{
					match(input,SILENT,FOLLOW_SILENT_in_move2244); 
					}
					break;

				default :
					break loop86;
				}
			}

			pushFollow(FOLLOW_graphOrDefault_in_move2247);
			graphOrDefault();
			state._fsp--;

			pushFollow(FOLLOW_graphOrDefault_in_move2249);
			graphOrDefault();
			state._fsp--;

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "move"



	// $ANTLR start "copy"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:544:1: copy : ^( COPY ( SILENT )* graphOrDefault graphOrDefault ) ;
	public final void copy() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:545:5: ( ^( COPY ( SILENT )* graphOrDefault graphOrDefault ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:545:7: ^( COPY ( SILENT )* graphOrDefault graphOrDefault )
			{
			match(input,COPY,FOLLOW_COPY_in_copy2268); 
			match(input, Token.DOWN, null); 
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:545:14: ( SILENT )*
			loop87:
			while (true) {
				int alt87=2;
				int LA87_0 = input.LA(1);
				if ( (LA87_0==SILENT) ) {
					alt87=1;
				}

				switch (alt87) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:545:14: SILENT
					{
					match(input,SILENT,FOLLOW_SILENT_in_copy2270); 
					}
					break;

				default :
					break loop87;
				}
			}

			pushFollow(FOLLOW_graphOrDefault_in_copy2273);
			graphOrDefault();
			state._fsp--;

			pushFollow(FOLLOW_graphOrDefault_in_copy2275);
			graphOrDefault();
			state._fsp--;

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "copy"



	// $ANTLR start "insert"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:548:1: insert : ^( INSERT DATA quadPattern ) ;
	public final void insert() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:549:5: ( ^( INSERT DATA quadPattern ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:549:7: ^( INSERT DATA quadPattern )
			{
			match(input,INSERT,FOLLOW_INSERT_in_insert2294); 
			match(input, Token.DOWN, null); 
			match(input,DATA,FOLLOW_DATA_in_insert2296); 
			pushFollow(FOLLOW_quadPattern_in_insert2298);
			quadPattern();
			state._fsp--;

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "insert"



	// $ANTLR start "delete"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:552:1: delete : DELETE ( deleteData | deleteWhere ) ;
	public final void delete() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:553:5: ( DELETE ( deleteData | deleteWhere ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:553:7: DELETE ( deleteData | deleteWhere )
			{
			match(input,DELETE,FOLLOW_DELETE_in_delete2316); 
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:553:14: ( deleteData | deleteWhere )
			int alt88=2;
			int LA88_0 = input.LA(1);
			if ( (LA88_0==DELETE) ) {
				int LA88_1 = input.LA(2);
				if ( (LA88_1==DOWN) ) {
					int LA88_2 = input.LA(3);
					if ( (LA88_2==DATA) ) {
						alt88=1;
					}
					else if ( (LA88_2==WHERE) ) {
						alt88=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 88, 2, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 88, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 88, 0, input);
				throw nvae;
			}

			switch (alt88) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:553:16: deleteData
					{
					pushFollow(FOLLOW_deleteData_in_delete2320);
					deleteData();
					state._fsp--;

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:553:29: deleteWhere
					{
					pushFollow(FOLLOW_deleteWhere_in_delete2324);
					deleteWhere();
					state._fsp--;

					}
					break;

			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "delete"



	// $ANTLR start "deleteData"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:556:1: deleteData : ^( DELETE DATA quadPattern ) ;
	public final void deleteData() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:557:5: ( ^( DELETE DATA quadPattern ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:557:7: ^( DELETE DATA quadPattern )
			{
			match(input,DELETE,FOLLOW_DELETE_in_deleteData2344); 
			match(input, Token.DOWN, null); 
			match(input,DATA,FOLLOW_DATA_in_deleteData2346); 
			pushFollow(FOLLOW_quadPattern_in_deleteData2348);
			quadPattern();
			state._fsp--;

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "deleteData"



	// $ANTLR start "deleteWhere"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:560:1: deleteWhere : ^( DELETE WHERE quadPattern ) ;
	public final void deleteWhere() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:561:5: ( ^( DELETE WHERE quadPattern ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:561:7: ^( DELETE WHERE quadPattern )
			{
			match(input,DELETE,FOLLOW_DELETE_in_deleteWhere2367); 
			match(input, Token.DOWN, null); 
			match(input,WHERE,FOLLOW_WHERE_in_deleteWhere2369); 
			pushFollow(FOLLOW_quadPattern_in_deleteWhere2371);
			quadPattern();
			state._fsp--;

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "deleteWhere"



	// $ANTLR start "modify"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:564:1: modify : ( ^( MODIFY ^( WITH iriRef ) ( deleteClause )* ( insertClause )* ( usingClause )* ^( WHERE groupGraphPattern ) ) | ^( MODIFY ( deleteClause )* ( insertClause )* ( usingClause )* ^( WHERE groupGraphPattern ) ) );
	public final void modify() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:565:5: ( ^( MODIFY ^( WITH iriRef ) ( deleteClause )* ( insertClause )* ( usingClause )* ^( WHERE groupGraphPattern ) ) | ^( MODIFY ( deleteClause )* ( insertClause )* ( usingClause )* ^( WHERE groupGraphPattern ) ) )
			int alt95=2;
			int LA95_0 = input.LA(1);
			if ( (LA95_0==MODIFY) ) {
				int LA95_1 = input.LA(2);
				if ( (LA95_1==DOWN) ) {
					int LA95_2 = input.LA(3);
					if ( (LA95_2==WITH) ) {
						alt95=1;
					}
					else if ( (LA95_2==DELETE||LA95_2==INSERT||LA95_2==USING||LA95_2==WHERE) ) {
						alt95=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 95, 2, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 95, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 95, 0, input);
				throw nvae;
			}

			switch (alt95) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:565:7: ^( MODIFY ^( WITH iriRef ) ( deleteClause )* ( insertClause )* ( usingClause )* ^( WHERE groupGraphPattern ) )
					{
					match(input,MODIFY,FOLLOW_MODIFY_in_modify2390); 
					match(input, Token.DOWN, null); 
					match(input,WITH,FOLLOW_WITH_in_modify2393); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_iriRef_in_modify2395);
					iriRef();
					state._fsp--;

					match(input, Token.UP, null); 

					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:565:31: ( deleteClause )*
					loop89:
					while (true) {
						int alt89=2;
						int LA89_0 = input.LA(1);
						if ( (LA89_0==DELETE) ) {
							alt89=1;
						}

						switch (alt89) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:565:31: deleteClause
							{
							pushFollow(FOLLOW_deleteClause_in_modify2398);
							deleteClause();
							state._fsp--;

							}
							break;

						default :
							break loop89;
						}
					}

					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:565:45: ( insertClause )*
					loop90:
					while (true) {
						int alt90=2;
						int LA90_0 = input.LA(1);
						if ( (LA90_0==INSERT) ) {
							alt90=1;
						}

						switch (alt90) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:565:45: insertClause
							{
							pushFollow(FOLLOW_insertClause_in_modify2401);
							insertClause();
							state._fsp--;

							}
							break;

						default :
							break loop90;
						}
					}

					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:565:59: ( usingClause )*
					loop91:
					while (true) {
						int alt91=2;
						int LA91_0 = input.LA(1);
						if ( (LA91_0==USING) ) {
							alt91=1;
						}

						switch (alt91) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:565:59: usingClause
							{
							pushFollow(FOLLOW_usingClause_in_modify2404);
							usingClause();
							state._fsp--;

							}
							break;

						default :
							break loop91;
						}
					}

					match(input,WHERE,FOLLOW_WHERE_in_modify2408); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_groupGraphPattern_in_modify2410);
					groupGraphPattern();
					state._fsp--;

					match(input, Token.UP, null); 

					match(input, Token.UP, null); 

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:566:7: ^( MODIFY ( deleteClause )* ( insertClause )* ( usingClause )* ^( WHERE groupGraphPattern ) )
					{
					match(input,MODIFY,FOLLOW_MODIFY_in_modify2421); 
					match(input, Token.DOWN, null); 
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:566:16: ( deleteClause )*
					loop92:
					while (true) {
						int alt92=2;
						int LA92_0 = input.LA(1);
						if ( (LA92_0==DELETE) ) {
							alt92=1;
						}

						switch (alt92) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:566:16: deleteClause
							{
							pushFollow(FOLLOW_deleteClause_in_modify2423);
							deleteClause();
							state._fsp--;

							}
							break;

						default :
							break loop92;
						}
					}

					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:566:30: ( insertClause )*
					loop93:
					while (true) {
						int alt93=2;
						int LA93_0 = input.LA(1);
						if ( (LA93_0==INSERT) ) {
							alt93=1;
						}

						switch (alt93) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:566:30: insertClause
							{
							pushFollow(FOLLOW_insertClause_in_modify2426);
							insertClause();
							state._fsp--;

							}
							break;

						default :
							break loop93;
						}
					}

					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:566:44: ( usingClause )*
					loop94:
					while (true) {
						int alt94=2;
						int LA94_0 = input.LA(1);
						if ( (LA94_0==USING) ) {
							alt94=1;
						}

						switch (alt94) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:566:44: usingClause
							{
							pushFollow(FOLLOW_usingClause_in_modify2429);
							usingClause();
							state._fsp--;

							}
							break;

						default :
							break loop94;
						}
					}

					match(input,WHERE,FOLLOW_WHERE_in_modify2433); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_groupGraphPattern_in_modify2435);
					groupGraphPattern();
					state._fsp--;

					match(input, Token.UP, null); 

					match(input, Token.UP, null); 

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "modify"



	// $ANTLR start "deleteClause"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:569:1: deleteClause : DELETE quadPattern ;
	public final void deleteClause() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:570:5: ( DELETE quadPattern )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:570:7: DELETE quadPattern
			{
			match(input,DELETE,FOLLOW_DELETE_in_deleteClause2454); 
			pushFollow(FOLLOW_quadPattern_in_deleteClause2456);
			quadPattern();
			state._fsp--;

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "deleteClause"



	// $ANTLR start "insertClause"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:573:1: insertClause : INSERT quadPattern ;
	public final void insertClause() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:574:5: ( INSERT quadPattern )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:574:7: INSERT quadPattern
			{
			match(input,INSERT,FOLLOW_INSERT_in_insertClause2473); 
			pushFollow(FOLLOW_quadPattern_in_insertClause2475);
			quadPattern();
			state._fsp--;

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "insertClause"



	// $ANTLR start "usingClause"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:577:1: usingClause : ^( USING ( NAMED )? iriRef ) ;
	public final void usingClause() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:578:5: ( ^( USING ( NAMED )? iriRef ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:578:7: ^( USING ( NAMED )? iriRef )
			{
			match(input,USING,FOLLOW_USING_in_usingClause2493); 
			match(input, Token.DOWN, null); 
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:578:15: ( NAMED )?
			int alt96=2;
			int LA96_0 = input.LA(1);
			if ( (LA96_0==NAMED) ) {
				alt96=1;
			}
			switch (alt96) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:578:15: NAMED
					{
					match(input,NAMED,FOLLOW_NAMED_in_usingClause2495); 
					}
					break;

			}

			pushFollow(FOLLOW_iriRef_in_usingClause2498);
			iriRef();
			state._fsp--;

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "usingClause"



	// $ANTLR start "graphOrDefault"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:581:1: graphOrDefault : ( DEFAULT | ( GRAPH )? iriRef );
	public final void graphOrDefault() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:582:5: ( DEFAULT | ( GRAPH )? iriRef )
			int alt98=2;
			int LA98_0 = input.LA(1);
			if ( (LA98_0==DEFAULT) ) {
				alt98=1;
			}
			else if ( (LA98_0==GRAPH||LA98_0==IRI_REF||(LA98_0 >= PNAME_LN && LA98_0 <= PNAME_NS)) ) {
				alt98=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 98, 0, input);
				throw nvae;
			}

			switch (alt98) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:582:7: DEFAULT
					{
					match(input,DEFAULT,FOLLOW_DEFAULT_in_graphOrDefault2516); 
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:583:7: ( GRAPH )? iriRef
					{
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:583:7: ( GRAPH )?
					int alt97=2;
					int LA97_0 = input.LA(1);
					if ( (LA97_0==GRAPH) ) {
						alt97=1;
					}
					switch (alt97) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:583:7: GRAPH
							{
							match(input,GRAPH,FOLLOW_GRAPH_in_graphOrDefault2524); 
							}
							break;

					}

					pushFollow(FOLLOW_iriRef_in_graphOrDefault2527);
					iriRef();
					state._fsp--;

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "graphOrDefault"



	// $ANTLR start "graphRef"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:586:1: graphRef : GRAPH iriRef ;
	public final void graphRef() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:587:5: ( GRAPH iriRef )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:587:7: GRAPH iriRef
			{
			match(input,GRAPH,FOLLOW_GRAPH_in_graphRef2544); 
			pushFollow(FOLLOW_iriRef_in_graphRef2546);
			iriRef();
			state._fsp--;

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "graphRef"



	// $ANTLR start "graphRefAll"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:590:1: graphRefAll : ( graphRef | DEFAULT | NAMED | ALL );
	public final void graphRefAll() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:591:5: ( graphRef | DEFAULT | NAMED | ALL )
			int alt99=4;
			switch ( input.LA(1) ) {
			case GRAPH:
				{
				alt99=1;
				}
				break;
			case DEFAULT:
				{
				alt99=2;
				}
				break;
			case NAMED:
				{
				alt99=3;
				}
				break;
			case ALL:
				{
				alt99=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 99, 0, input);
				throw nvae;
			}
			switch (alt99) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:591:7: graphRef
					{
					pushFollow(FOLLOW_graphRef_in_graphRefAll2563);
					graphRef();
					state._fsp--;

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:591:18: DEFAULT
					{
					match(input,DEFAULT,FOLLOW_DEFAULT_in_graphRefAll2567); 
					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:591:28: NAMED
					{
					match(input,NAMED,FOLLOW_NAMED_in_graphRefAll2571); 
					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:591:36: ALL
					{
					match(input,ALL,FOLLOW_ALL_in_graphRefAll2575); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "graphRefAll"



	// $ANTLR start "quadPattern"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:594:1: quadPattern returns [QuadPattern value] : a= quads ;
	public final QuadPattern quadPattern() throws RecognitionException {
		QuadPattern value = null;


		QuadPattern a =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:595:5: (a= quads )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:595:7: a= quads
			{
			pushFollow(FOLLOW_quads_in_quadPattern2598);
			a=quads();
			state._fsp--;

			value = a;
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "quadPattern"



	// $ANTLR start "quads"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:598:1: quads returns [QuadPattern value] : (a= triplesTemplate )? ( quadsNotTriples[$value] (c= triplesTemplate )? )* ;
	public final QuadPattern quads() throws RecognitionException {
		QuadPattern value = null;


		BasicPattern a =null;
		BasicPattern c =null;

		value = new QuadPattern();
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:600:5: ( (a= triplesTemplate )? ( quadsNotTriples[$value] (c= triplesTemplate )? )* )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:600:7: (a= triplesTemplate )? ( quadsNotTriples[$value] (c= triplesTemplate )? )*
			{
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:600:7: (a= triplesTemplate )?
			int alt100=2;
			int LA100_0 = input.LA(1);
			if ( (LA100_0==TRIPLES_TEMPLATE) ) {
				alt100=1;
			}
			switch (alt100) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:600:8: a= triplesTemplate
					{
					pushFollow(FOLLOW_triplesTemplate_in_quads2631);
					a=triplesTemplate();
					state._fsp--;

					value.addAll(QuadPatternUtils.toQuadPattern(getDefaultGraph(), a));
					}
					break;

			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:600:106: ( quadsNotTriples[$value] (c= triplesTemplate )? )*
			loop102:
			while (true) {
				int alt102=2;
				int LA102_0 = input.LA(1);
				if ( (LA102_0==GRAPH_TOKEN) ) {
					alt102=1;
				}

				switch (alt102) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:600:108: quadsNotTriples[$value] (c= triplesTemplate )?
					{
					pushFollow(FOLLOW_quadsNotTriples_in_quads2639);
					quadsNotTriples(value);
					state._fsp--;

					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:600:132: (c= triplesTemplate )?
					int alt101=2;
					int LA101_0 = input.LA(1);
					if ( (LA101_0==TRIPLES_TEMPLATE) ) {
						alt101=1;
					}
					switch (alt101) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:600:133: c= triplesTemplate
							{
							pushFollow(FOLLOW_triplesTemplate_in_quads2645);
							c=triplesTemplate();
							state._fsp--;

							value.addAll(QuadPatternUtils.toQuadPattern(getDefaultGraph(), c));
							}
							break;

					}

					}
					break;

				default :
					break loop102;
				}
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "quads"



	// $ANTLR start "quadsNotTriples"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:603:1: quadsNotTriples[QuadPattern value] : ^( GRAPH_TOKEN a= varOrIRIref (b= triplesTemplate )? ) ;
	public final void quadsNotTriples(QuadPattern value) throws RecognitionException {
		Node a =null;
		BasicPattern b =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:605:5: ( ^( GRAPH_TOKEN a= varOrIRIref (b= triplesTemplate )? ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:605:7: ^( GRAPH_TOKEN a= varOrIRIref (b= triplesTemplate )? )
			{
			match(input,GRAPH_TOKEN,FOLLOW_GRAPH_TOKEN_in_quadsNotTriples2678); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_varOrIRIref_in_quadsNotTriples2682);
			a=varOrIRIref();
			state._fsp--;

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:605:36: (b= triplesTemplate )?
			int alt103=2;
			int LA103_0 = input.LA(1);
			if ( (LA103_0==TRIPLES_TEMPLATE) ) {
				alt103=1;
			}
			switch (alt103) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:605:36: b= triplesTemplate
					{
					pushFollow(FOLLOW_triplesTemplate_in_quadsNotTriples2686);
					b=triplesTemplate();
					state._fsp--;

					}
					break;

			}

			match(input, Token.UP, null); 

			value.addAll(QuadPatternUtils.toQuadPattern(a, b));
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "quadsNotTriples"



	// $ANTLR start "triplesTemplate"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:615:1: triplesTemplate returns [BasicPattern value] : ^( TRIPLES_TEMPLATE a= triples ) ;
	public final BasicPattern triplesTemplate() throws RecognitionException {
		BasicPattern value = null;


		BasicPattern a =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:616:5: ( ^( TRIPLES_TEMPLATE a= triples ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:616:7: ^( TRIPLES_TEMPLATE a= triples )
			{
			match(input,TRIPLES_TEMPLATE,FOLLOW_TRIPLES_TEMPLATE_in_triplesTemplate2715); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_triples_in_triplesTemplate2719);
			a=triples();
			state._fsp--;

			value = a;
			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "triplesTemplate"



	// $ANTLR start "groupGraphPattern"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:619:1: groupGraphPattern : ( ^( GROUP_GRAPH_PATTERN subSelect ) | ^( GROUP_GRAPH_PATTERN groupGraphPatternSub ) );
	public final void groupGraphPattern() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:620:5: ( ^( GROUP_GRAPH_PATTERN subSelect ) | ^( GROUP_GRAPH_PATTERN groupGraphPatternSub ) )
			int alt104=2;
			int LA104_0 = input.LA(1);
			if ( (LA104_0==GROUP_GRAPH_PATTERN) ) {
				int LA104_1 = input.LA(2);
				if ( (LA104_1==DOWN) ) {
					int LA104_2 = input.LA(3);
					if ( (LA104_2==SUBSELECT) ) {
						alt104=1;
					}
					else if ( (LA104_2==UP||LA104_2==BIND||LA104_2==FILTER||LA104_2==GRAPH||LA104_2==GROUP_GRAPH_PATTERN||LA104_2==MINUS_KEYWORD||LA104_2==OPTIONAL||LA104_2==SERVICE||LA104_2==TRIPLES_BLOCK||LA104_2==UNION) ) {
						alt104=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 104, 2, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 104, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 104, 0, input);
				throw nvae;
			}

			switch (alt104) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:620:7: ^( GROUP_GRAPH_PATTERN subSelect )
					{
					match(input,GROUP_GRAPH_PATTERN,FOLLOW_GROUP_GRAPH_PATTERN_in_groupGraphPattern2740); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_subSelect_in_groupGraphPattern2742);
					subSelect();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:621:7: ^( GROUP_GRAPH_PATTERN groupGraphPatternSub )
					{
					match(input,GROUP_GRAPH_PATTERN,FOLLOW_GROUP_GRAPH_PATTERN_in_groupGraphPattern2752); 
					if ( input.LA(1)==Token.DOWN ) {
						match(input, Token.DOWN, null); 
						pushFollow(FOLLOW_groupGraphPatternSub_in_groupGraphPattern2754);
						groupGraphPatternSub();
						state._fsp--;

						match(input, Token.UP, null); 
					}

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "groupGraphPattern"



	// $ANTLR start "groupGraphPatternSub"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:624:1: groupGraphPatternSub : ( triplesBlock )? ( groupGraphPatternSubCache )* ;
	public final void groupGraphPatternSub() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:625:5: ( ( triplesBlock )? ( groupGraphPatternSubCache )* )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:625:7: ( triplesBlock )? ( groupGraphPatternSubCache )*
			{
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:625:7: ( triplesBlock )?
			int alt105=2;
			int LA105_0 = input.LA(1);
			if ( (LA105_0==TRIPLES_BLOCK) ) {
				alt105=1;
			}
			switch (alt105) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:625:7: triplesBlock
					{
					pushFollow(FOLLOW_triplesBlock_in_groupGraphPatternSub2772);
					triplesBlock();
					state._fsp--;

					}
					break;

			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:625:21: ( groupGraphPatternSubCache )*
			loop106:
			while (true) {
				int alt106=2;
				int LA106_0 = input.LA(1);
				if ( (LA106_0==BIND||LA106_0==FILTER||LA106_0==GRAPH||LA106_0==GROUP_GRAPH_PATTERN||LA106_0==MINUS_KEYWORD||LA106_0==OPTIONAL||LA106_0==SERVICE||LA106_0==UNION) ) {
					alt106=1;
				}

				switch (alt106) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:625:21: groupGraphPatternSubCache
					{
					pushFollow(FOLLOW_groupGraphPatternSubCache_in_groupGraphPatternSub2775);
					groupGraphPatternSubCache();
					state._fsp--;

					}
					break;

				default :
					break loop106;
				}
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "groupGraphPatternSub"



	// $ANTLR start "groupGraphPatternSubCache"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:628:1: groupGraphPatternSubCache : graphPatternNotTriples ( triplesBlock )? ;
	public final void groupGraphPatternSubCache() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:629:5: ( graphPatternNotTriples ( triplesBlock )? )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:629:8: graphPatternNotTriples ( triplesBlock )?
			{
			pushFollow(FOLLOW_graphPatternNotTriples_in_groupGraphPatternSubCache2794);
			graphPatternNotTriples();
			state._fsp--;

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:629:31: ( triplesBlock )?
			int alt107=2;
			int LA107_0 = input.LA(1);
			if ( (LA107_0==TRIPLES_BLOCK) ) {
				alt107=1;
			}
			switch (alt107) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:629:31: triplesBlock
					{
					pushFollow(FOLLOW_triplesBlock_in_groupGraphPatternSubCache2796);
					triplesBlock();
					state._fsp--;

					}
					break;

			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "groupGraphPatternSubCache"



	// $ANTLR start "triplesBlock"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:632:1: triplesBlock : ^( TRIPLES_BLOCK ( triplesSameSubjectPath[null] )+ ) ;
	public final void triplesBlock() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:633:5: ( ^( TRIPLES_BLOCK ( triplesSameSubjectPath[null] )+ ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:633:7: ^( TRIPLES_BLOCK ( triplesSameSubjectPath[null] )+ )
			{
			match(input,TRIPLES_BLOCK,FOLLOW_TRIPLES_BLOCK_in_triplesBlock2815); 
			match(input, Token.DOWN, null); 
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:633:23: ( triplesSameSubjectPath[null] )+
			int cnt108=0;
			loop108:
			while (true) {
				int alt108=2;
				int LA108_0 = input.LA(1);
				if ( (LA108_0==TRIPLE) ) {
					alt108=1;
				}

				switch (alt108) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:633:23: triplesSameSubjectPath[null]
					{
					pushFollow(FOLLOW_triplesSameSubjectPath_in_triplesBlock2817);
					triplesSameSubjectPath(null);
					state._fsp--;

					}
					break;

				default :
					if ( cnt108 >= 1 ) break loop108;
					EarlyExitException eee = new EarlyExitException(108, input);
					throw eee;
				}
				cnt108++;
			}

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "triplesBlock"



	// $ANTLR start "graphPatternNotTriples"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:636:1: graphPatternNotTriples : ( groupOrUnionGraphPattern | optionalGraphPattern | minusGraphPattern | graphGraphPattern | serviceGraphPattern | filter | bind );
	public final void graphPatternNotTriples() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:637:5: ( groupOrUnionGraphPattern | optionalGraphPattern | minusGraphPattern | graphGraphPattern | serviceGraphPattern | filter | bind )
			int alt109=7;
			switch ( input.LA(1) ) {
			case GROUP_GRAPH_PATTERN:
			case UNION:
				{
				alt109=1;
				}
				break;
			case OPTIONAL:
				{
				alt109=2;
				}
				break;
			case MINUS_KEYWORD:
				{
				alt109=3;
				}
				break;
			case GRAPH:
				{
				alt109=4;
				}
				break;
			case SERVICE:
				{
				alt109=5;
				}
				break;
			case FILTER:
				{
				alt109=6;
				}
				break;
			case BIND:
				{
				alt109=7;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 109, 0, input);
				throw nvae;
			}
			switch (alt109) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:637:7: groupOrUnionGraphPattern
					{
					pushFollow(FOLLOW_groupOrUnionGraphPattern_in_graphPatternNotTriples2837);
					groupOrUnionGraphPattern();
					state._fsp--;

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:637:34: optionalGraphPattern
					{
					pushFollow(FOLLOW_optionalGraphPattern_in_graphPatternNotTriples2841);
					optionalGraphPattern();
					state._fsp--;

					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:637:57: minusGraphPattern
					{
					pushFollow(FOLLOW_minusGraphPattern_in_graphPatternNotTriples2845);
					minusGraphPattern();
					state._fsp--;

					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:637:77: graphGraphPattern
					{
					pushFollow(FOLLOW_graphGraphPattern_in_graphPatternNotTriples2849);
					graphGraphPattern();
					state._fsp--;

					}
					break;
				case 5 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:637:97: serviceGraphPattern
					{
					pushFollow(FOLLOW_serviceGraphPattern_in_graphPatternNotTriples2853);
					serviceGraphPattern();
					state._fsp--;

					}
					break;
				case 6 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:637:119: filter
					{
					pushFollow(FOLLOW_filter_in_graphPatternNotTriples2857);
					filter();
					state._fsp--;

					}
					break;
				case 7 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:637:128: bind
					{
					pushFollow(FOLLOW_bind_in_graphPatternNotTriples2861);
					bind();
					state._fsp--;

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "graphPatternNotTriples"



	// $ANTLR start "optionalGraphPattern"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:640:1: optionalGraphPattern : ^( OPTIONAL groupGraphPattern ) ;
	public final void optionalGraphPattern() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:641:5: ( ^( OPTIONAL groupGraphPattern ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:641:7: ^( OPTIONAL groupGraphPattern )
			{
			match(input,OPTIONAL,FOLLOW_OPTIONAL_in_optionalGraphPattern2879); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_groupGraphPattern_in_optionalGraphPattern2881);
			groupGraphPattern();
			state._fsp--;

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "optionalGraphPattern"



	// $ANTLR start "graphGraphPattern"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:644:1: graphGraphPattern : ^( GRAPH varOrIRIref groupGraphPattern ) ;
	public final void graphGraphPattern() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:645:5: ( ^( GRAPH varOrIRIref groupGraphPattern ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:645:7: ^( GRAPH varOrIRIref groupGraphPattern )
			{
			match(input,GRAPH,FOLLOW_GRAPH_in_graphGraphPattern2900); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_varOrIRIref_in_graphGraphPattern2902);
			varOrIRIref();
			state._fsp--;

			pushFollow(FOLLOW_groupGraphPattern_in_graphGraphPattern2904);
			groupGraphPattern();
			state._fsp--;

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "graphGraphPattern"



	// $ANTLR start "serviceGraphPattern"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:648:1: serviceGraphPattern : ^( SERVICE ( SILENT )? varOrIRIref groupGraphPattern ) ;
	public final void serviceGraphPattern() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:649:5: ( ^( SERVICE ( SILENT )? varOrIRIref groupGraphPattern ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:649:7: ^( SERVICE ( SILENT )? varOrIRIref groupGraphPattern )
			{
			match(input,SERVICE,FOLLOW_SERVICE_in_serviceGraphPattern2923); 
			match(input, Token.DOWN, null); 
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:649:17: ( SILENT )?
			int alt110=2;
			int LA110_0 = input.LA(1);
			if ( (LA110_0==SILENT) ) {
				alt110=1;
			}
			switch (alt110) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:649:17: SILENT
					{
					match(input,SILENT,FOLLOW_SILENT_in_serviceGraphPattern2925); 
					}
					break;

			}

			pushFollow(FOLLOW_varOrIRIref_in_serviceGraphPattern2928);
			varOrIRIref();
			state._fsp--;

			pushFollow(FOLLOW_groupGraphPattern_in_serviceGraphPattern2930);
			groupGraphPattern();
			state._fsp--;

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "serviceGraphPattern"



	// $ANTLR start "bind"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:652:1: bind : ^( BIND expression ^( AS var ) ) ;
	public final void bind() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:653:5: ( ^( BIND expression ^( AS var ) ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:653:7: ^( BIND expression ^( AS var ) )
			{
			match(input,BIND,FOLLOW_BIND_in_bind2949); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_expression_in_bind2951);
			expression();
			state._fsp--;

			match(input,AS,FOLLOW_AS_in_bind2954); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_var_in_bind2956);
			var();
			state._fsp--;

			match(input, Token.UP, null); 

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "bind"



	// $ANTLR start "minusGraphPattern"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:656:1: minusGraphPattern : ^( MINUS_KEYWORD groupGraphPattern ) ;
	public final void minusGraphPattern() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:657:5: ( ^( MINUS_KEYWORD groupGraphPattern ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:657:7: ^( MINUS_KEYWORD groupGraphPattern )
			{
			match(input,MINUS_KEYWORD,FOLLOW_MINUS_KEYWORD_in_minusGraphPattern2976); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_groupGraphPattern_in_minusGraphPattern2978);
			groupGraphPattern();
			state._fsp--;

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "minusGraphPattern"



	// $ANTLR start "groupOrUnionGraphPattern"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:660:1: groupOrUnionGraphPattern : ( ^( UNION groupGraphPattern groupGraphPattern ) | groupGraphPattern );
	public final void groupOrUnionGraphPattern() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:661:5: ( ^( UNION groupGraphPattern groupGraphPattern ) | groupGraphPattern )
			int alt111=2;
			int LA111_0 = input.LA(1);
			if ( (LA111_0==UNION) ) {
				alt111=1;
			}
			else if ( (LA111_0==GROUP_GRAPH_PATTERN) ) {
				alt111=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 111, 0, input);
				throw nvae;
			}

			switch (alt111) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:661:7: ^( UNION groupGraphPattern groupGraphPattern )
					{
					match(input,UNION,FOLLOW_UNION_in_groupOrUnionGraphPattern2997); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_groupGraphPattern_in_groupOrUnionGraphPattern2999);
					groupGraphPattern();
					state._fsp--;

					pushFollow(FOLLOW_groupGraphPattern_in_groupOrUnionGraphPattern3001);
					groupGraphPattern();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:662:7: groupGraphPattern
					{
					pushFollow(FOLLOW_groupGraphPattern_in_groupOrUnionGraphPattern3010);
					groupGraphPattern();
					state._fsp--;

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "groupOrUnionGraphPattern"



	// $ANTLR start "filter"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:665:1: filter : ^( FILTER constraint ) ;
	public final void filter() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:666:5: ( ^( FILTER constraint ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:666:7: ^( FILTER constraint )
			{
			match(input,FILTER,FOLLOW_FILTER_in_filter3028); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_constraint_in_filter3030);
			constraint();
			state._fsp--;

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "filter"



	// $ANTLR start "constraint"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:669:1: constraint : ( expression | builtInCall | functionCall );
	public final void constraint() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:670:5: ( expression | builtInCall | functionCall )
			int alt112=3;
			switch ( input.LA(1) ) {
			case AND:
			case ASTERISK:
			case DIVIDE:
			case EQUAL:
			case GREATER:
			case GREATER_EQUAL:
			case IN:
			case LESS:
			case LESS_EQUAL:
			case MINUS:
			case NOT:
			case NOT_EQUAL:
			case OR:
			case PLUS:
			case UNARY:
			case UNARY_MINUS:
			case UNARY_NOT:
			case UNARY_PLUS:
				{
				alt112=1;
				}
				break;
			case ABS:
			case BNODE:
			case BOUND:
			case CEIL:
			case COALESCE:
			case CONCAT:
			case CONTAINS:
			case DATATYPE:
			case DAY:
			case ENCODE_FOR_URI:
			case EXISTS:
			case FLOOR:
			case HOURS:
			case IF:
			case IRI:
			case ISBLANK:
			case ISIRI:
			case ISLITERAL:
			case ISNUMERIC:
			case ISURI:
			case LANG:
			case LANGMATCHES:
			case LCASE:
			case MD5:
			case MINUTES:
			case MONTH:
			case NOT_EXISTS:
			case NOW:
			case RAND:
			case REGEX:
			case ROUND:
			case SAMETERM:
			case SECONDS:
			case SHA1:
			case SHA224:
			case SHA256:
			case SHA384:
			case SHA512:
			case STR:
			case STRDT:
			case STRENDS:
			case STRLANG:
			case STRLEN:
			case STRSTARTS:
			case SUBSTR:
			case TIMEZONE:
			case TZ:
			case UCASE:
			case URI:
			case YEAR:
				{
				alt112=2;
				}
				break;
			case FUNCTION:
				{
				alt112=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 112, 0, input);
				throw nvae;
			}
			switch (alt112) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:670:7: expression
					{
					pushFollow(FOLLOW_expression_in_constraint3048);
					expression();
					state._fsp--;

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:671:7: builtInCall
					{
					pushFollow(FOLLOW_builtInCall_in_constraint3056);
					builtInCall();
					state._fsp--;

					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:672:7: functionCall
					{
					pushFollow(FOLLOW_functionCall_in_constraint3064);
					functionCall();
					state._fsp--;

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "constraint"



	// $ANTLR start "functionCall"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:675:1: functionCall returns [Expr value] : ^( FUNCTION a= iriRef ^( ARG_LIST b= argList ) ) ;
	public final Expr functionCall() throws RecognitionException {
		Expr value = null;


		Node a =null;
		ExprList b =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:676:5: ( ^( FUNCTION a= iriRef ^( ARG_LIST b= argList ) ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:676:7: ^( FUNCTION a= iriRef ^( ARG_LIST b= argList ) )
			{
			match(input,FUNCTION,FOLLOW_FUNCTION_in_functionCall3086); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_iriRef_in_functionCall3090);
			a=iriRef();
			state._fsp--;

			match(input,ARG_LIST,FOLLOW_ARG_LIST_in_functionCall3093); 
			if ( input.LA(1)==Token.DOWN ) {
				match(input, Token.DOWN, null); 
				pushFollow(FOLLOW_argList_in_functionCall3097);
				b=argList();
				state._fsp--;

				match(input, Token.UP, null); 
			}

			match(input, Token.UP, null); 

			 value = new E_Function(a.toString(), b); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "functionCall"



	// $ANTLR start "argList"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:680:1: argList returns [ExprList value] : ( nil | ( DISTINCT )? (a= expression )* );
	public final ExprList argList() throws RecognitionException {
		ExprList value = null;


		Expr a =null;

		 value = new ExprList(); 
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:682:5: ( nil | ( DISTINCT )? (a= expression )* )
			int alt115=2;
			int LA115_0 = input.LA(1);
			if ( (LA115_0==OPEN_BRACE) ) {
				alt115=1;
			}
			else if ( (LA115_0==UP||LA115_0==AND||LA115_0==ASTERISK||(LA115_0 >= DISTINCT && LA115_0 <= DIVIDE)||LA115_0==EQUAL||(LA115_0 >= GREATER && LA115_0 <= GREATER_EQUAL)||LA115_0==IN||(LA115_0 >= LESS && LA115_0 <= LESS_EQUAL)||LA115_0==MINUS||(LA115_0 >= NOT && LA115_0 <= NOT_EQUAL)||LA115_0==OR||LA115_0==PLUS||(LA115_0 >= UNARY && LA115_0 <= UNARY_PLUS)) ) {
				alt115=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 115, 0, input);
				throw nvae;
			}

			switch (alt115) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:682:7: nil
					{
					pushFollow(FOLLOW_nil_in_argList3132);
					nil();
					state._fsp--;

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:683:7: ( DISTINCT )? (a= expression )*
					{
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:683:7: ( DISTINCT )?
					int alt113=2;
					int LA113_0 = input.LA(1);
					if ( (LA113_0==DISTINCT) ) {
						alt113=1;
					}
					switch (alt113) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:683:7: DISTINCT
							{
							match(input,DISTINCT,FOLLOW_DISTINCT_in_argList3140); 
							}
							break;

					}

					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:683:17: (a= expression )*
					loop114:
					while (true) {
						int alt114=2;
						int LA114_0 = input.LA(1);
						if ( (LA114_0==AND||LA114_0==ASTERISK||LA114_0==DIVIDE||LA114_0==EQUAL||(LA114_0 >= GREATER && LA114_0 <= GREATER_EQUAL)||LA114_0==IN||(LA114_0 >= LESS && LA114_0 <= LESS_EQUAL)||LA114_0==MINUS||(LA114_0 >= NOT && LA114_0 <= NOT_EQUAL)||LA114_0==OR||LA114_0==PLUS||(LA114_0 >= UNARY && LA114_0 <= UNARY_PLUS)) ) {
							alt114=1;
						}

						switch (alt114) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:683:18: a= expression
							{
							pushFollow(FOLLOW_expression_in_argList3146);
							a=expression();
							state._fsp--;

							value.add(a);
							}
							break;

						default :
							break loop114;
						}
					}

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "argList"



	// $ANTLR start "expressionList"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:686:1: expressionList returns [ExprList value] : ( ^( EXPRESSION_LIST (a= expression )+ ) | ^( EXPRESSION_LIST nil ) );
	public final ExprList expressionList() throws RecognitionException {
		ExprList value = null;


		Expr a =null;

		 value = new ExprList(); 
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:688:5: ( ^( EXPRESSION_LIST (a= expression )+ ) | ^( EXPRESSION_LIST nil ) )
			int alt117=2;
			int LA117_0 = input.LA(1);
			if ( (LA117_0==EXPRESSION_LIST) ) {
				int LA117_1 = input.LA(2);
				if ( (LA117_1==DOWN) ) {
					int LA117_2 = input.LA(3);
					if ( (LA117_2==AND||LA117_2==ASTERISK||LA117_2==DIVIDE||LA117_2==EQUAL||(LA117_2 >= GREATER && LA117_2 <= GREATER_EQUAL)||LA117_2==IN||(LA117_2 >= LESS && LA117_2 <= LESS_EQUAL)||LA117_2==MINUS||(LA117_2 >= NOT && LA117_2 <= NOT_EQUAL)||LA117_2==OR||LA117_2==PLUS||(LA117_2 >= UNARY && LA117_2 <= UNARY_PLUS)) ) {
						alt117=1;
					}
					else if ( (LA117_2==OPEN_BRACE) ) {
						alt117=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 117, 2, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 117, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 117, 0, input);
				throw nvae;
			}

			switch (alt117) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:688:7: ^( EXPRESSION_LIST (a= expression )+ )
					{
					match(input,EXPRESSION_LIST,FOLLOW_EXPRESSION_LIST_in_expressionList3181); 
					match(input, Token.DOWN, null); 
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:688:25: (a= expression )+
					int cnt116=0;
					loop116:
					while (true) {
						int alt116=2;
						int LA116_0 = input.LA(1);
						if ( (LA116_0==AND||LA116_0==ASTERISK||LA116_0==DIVIDE||LA116_0==EQUAL||(LA116_0 >= GREATER && LA116_0 <= GREATER_EQUAL)||LA116_0==IN||(LA116_0 >= LESS && LA116_0 <= LESS_EQUAL)||LA116_0==MINUS||(LA116_0 >= NOT && LA116_0 <= NOT_EQUAL)||LA116_0==OR||LA116_0==PLUS||(LA116_0 >= UNARY && LA116_0 <= UNARY_PLUS)) ) {
							alt116=1;
						}

						switch (alt116) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:688:26: a= expression
							{
							pushFollow(FOLLOW_expression_in_expressionList3186);
							a=expression();
							state._fsp--;

							value.add(a); 
							}
							break;

						default :
							if ( cnt116 >= 1 ) break loop116;
							EarlyExitException eee = new EarlyExitException(116, input);
							throw eee;
						}
						cnt116++;
					}

					match(input, Token.UP, null); 

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:689:7: ^( EXPRESSION_LIST nil )
					{
					match(input,EXPRESSION_LIST,FOLLOW_EXPRESSION_LIST_in_expressionList3200); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_nil_in_expressionList3202);
					nil();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "expressionList"



	// $ANTLR start "constructTemplateQuads"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:701:1: constructTemplateQuads returns [QuadPattern value] : ^( CONSTRUCT_QUADS a= quadPattern ) ;
	public final QuadPattern constructTemplateQuads() throws RecognitionException {
		QuadPattern value = null;


		QuadPattern a =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:702:5: ( ^( CONSTRUCT_QUADS a= quadPattern ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:702:7: ^( CONSTRUCT_QUADS a= quadPattern )
			{
			match(input,CONSTRUCT_QUADS,FOLLOW_CONSTRUCT_QUADS_in_constructTemplateQuads3228); 
			if ( input.LA(1)==Token.DOWN ) {
				match(input, Token.DOWN, null); 
				pushFollow(FOLLOW_quadPattern_in_constructTemplateQuads3232);
				a=quadPattern();
				state._fsp--;

				match(input, Token.UP, null); 
			}

			value = a;
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "constructTemplateQuads"



	// $ANTLR start "constructTemplate"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:706:1: constructTemplate returns [Template value] : ^( CONSTRUCT_TRIPLES a= constructTriples ) ;
	public final Template constructTemplate() throws RecognitionException {
		Template value = null;


		BasicPattern a =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:708:5: ( ^( CONSTRUCT_TRIPLES a= constructTriples ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:708:7: ^( CONSTRUCT_TRIPLES a= constructTriples )
			{
			match(input,CONSTRUCT_TRIPLES,FOLLOW_CONSTRUCT_TRIPLES_in_constructTemplate3262); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_constructTriples_in_constructTemplate3266);
			a=constructTriples();
			state._fsp--;

			match(input, Token.UP, null); 

			value = new Template(a);
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "constructTemplate"



	// $ANTLR start "constructTriples"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:712:1: constructTriples returns [BasicPattern value] : a= triples ;
	public final BasicPattern constructTriples() throws RecognitionException {
		BasicPattern value = null;


		BasicPattern a =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:713:5: (a= triples )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:713:7: a= triples
			{
			pushFollow(FOLLOW_triples_in_constructTriples3293);
			a=triples();
			state._fsp--;

			value = a;
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "constructTriples"



	// $ANTLR start "triples"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:718:1: triples returns [BasicPattern value] : ( triple[value] )+ ;
	public final BasicPattern triples() throws RecognitionException {
		BasicPattern value = null;


		value = new BasicPattern();
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:720:5: ( ( triple[value] )+ )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:720:7: ( triple[value] )+
			{
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:720:7: ( triple[value] )+
			int cnt118=0;
			loop118:
			while (true) {
				int alt118=2;
				int LA118_0 = input.LA(1);
				if ( (LA118_0==TRIPLE) ) {
					alt118=1;
				}

				switch (alt118) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:720:7: triple[value]
					{
					pushFollow(FOLLOW_triple_in_triples3327);
					triple(value);
					state._fsp--;

					}
					break;

				default :
					if ( cnt118 >= 1 ) break loop118;
					EarlyExitException eee = new EarlyExitException(118, input);
					throw eee;
				}
				cnt118++;
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "triples"



	// $ANTLR start "triple"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:723:1: triple[BasicPattern triples] : ^( TRIPLE ^( SUBJECT a= varOrTerm ) ^( PREDICATE b= verb ) ^( OBJECT c= graphNode[triples] ) ) ;
	public final void triple(BasicPattern triples) throws RecognitionException {
		Node a =null;
		Node b =null;
		Node c =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:724:5: ( ^( TRIPLE ^( SUBJECT a= varOrTerm ) ^( PREDICATE b= verb ) ^( OBJECT c= graphNode[triples] ) ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:724:7: ^( TRIPLE ^( SUBJECT a= varOrTerm ) ^( PREDICATE b= verb ) ^( OBJECT c= graphNode[triples] ) )
			{
			match(input,TRIPLE,FOLLOW_TRIPLE_in_triple3348); 
			match(input, Token.DOWN, null); 
			match(input,SUBJECT,FOLLOW_SUBJECT_in_triple3351); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_varOrTerm_in_triple3355);
			a=varOrTerm();
			state._fsp--;

			match(input, Token.UP, null); 

			match(input,PREDICATE,FOLLOW_PREDICATE_in_triple3359); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_verb_in_triple3363);
			b=verb();
			state._fsp--;

			match(input, Token.UP, null); 

			match(input,OBJECT,FOLLOW_OBJECT_in_triple3367); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_graphNode_in_triple3371);
			c=graphNode(triples);
			state._fsp--;

			match(input, Token.UP, null); 

			match(input, Token.UP, null); 

			triples.add(new Triple(a, b, c)); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "triple"



	// $ANTLR start "triplesSameSubject"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:729:1: triplesSameSubject[BasicPattern value] : TODO ;
	public final void triplesSameSubject(BasicPattern value) throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:730:5: ( TODO )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:730:7: TODO
			{
			match(input,TODO,FOLLOW_TODO_in_triplesSameSubject3396); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "triplesSameSubject"



	// $ANTLR start "objectList"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:737:1: objectList[BasicPattern triples] : ^( SUBJECT a= varOrTerm ) ^( PREDICATE b= verb ) ^( OBJECT c= graphNode[triples] ) ;
	public final void objectList(BasicPattern triples) throws RecognitionException {
		Node a =null;
		Node b =null;
		Node c =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:738:5: ( ^( SUBJECT a= varOrTerm ) ^( PREDICATE b= verb ) ^( OBJECT c= graphNode[triples] ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:738:7: ^( SUBJECT a= varOrTerm ) ^( PREDICATE b= verb ) ^( OBJECT c= graphNode[triples] )
			{
			match(input,SUBJECT,FOLLOW_SUBJECT_in_objectList3420); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_varOrTerm_in_objectList3424);
			a=varOrTerm();
			state._fsp--;

			match(input, Token.UP, null); 

			match(input,PREDICATE,FOLLOW_PREDICATE_in_objectList3428); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_verb_in_objectList3432);
			b=verb();
			state._fsp--;

			match(input, Token.UP, null); 

			match(input,OBJECT,FOLLOW_OBJECT_in_objectList3436); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_graphNode_in_objectList3440);
			c=graphNode(triples);
			state._fsp--;

			match(input, Token.UP, null); 

			triples.add(new Triple(a, b, c)); System.out.println("Created triple: " + triples); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "objectList"



	// $ANTLR start "verb"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:768:1: verb returns [ Node value ] : (a= varOrIRIref | A | path );
	public final Node verb() throws RecognitionException {
		Node value = null;


		Node a =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:769:5: (a= varOrIRIref | A | path )
			int alt119=3;
			switch ( input.LA(1) ) {
			case IRI_REF:
			case PNAME_LN:
			case PNAME_NS:
			case VAR:
				{
				alt119=1;
				}
				break;
			case A:
				{
				alt119=2;
				}
				break;
			case PATH:
				{
				alt119=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 119, 0, input);
				throw nvae;
			}
			switch (alt119) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:769:7: a= varOrIRIref
					{
					pushFollow(FOLLOW_varOrIRIref_in_verb3474);
					a=varOrIRIref();
					state._fsp--;

					 value = a; 
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:770:7: A
					{
					match(input,A,FOLLOW_A_in_verb3484); 
					 value = RDF.type.asNode(); 
					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:771:7: path
					{
					pushFollow(FOLLOW_path_in_verb3504);
					path();
					state._fsp--;

					 if(true) { throw new NotImplementedException(); } 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "verb"



	// $ANTLR start "triplesSameSubjectPath"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:774:1: triplesSameSubjectPath[BasicPattern value] : ( ^( TRIPLE objectList[value] ) | ^( TRIPLE triplesSameSubjectPath[value] ) );
	public final void triplesSameSubjectPath(BasicPattern value) throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:775:5: ( ^( TRIPLE objectList[value] ) | ^( TRIPLE triplesSameSubjectPath[value] ) )
			int alt120=2;
			int LA120_0 = input.LA(1);
			if ( (LA120_0==TRIPLE) ) {
				int LA120_1 = input.LA(2);
				if ( (LA120_1==DOWN) ) {
					int LA120_2 = input.LA(3);
					if ( (LA120_2==SUBJECT) ) {
						alt120=1;
					}
					else if ( (LA120_2==TRIPLE) ) {
						alt120=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 120, 2, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 120, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 120, 0, input);
				throw nvae;
			}

			switch (alt120) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:775:7: ^( TRIPLE objectList[value] )
					{
					match(input,TRIPLE,FOLLOW_TRIPLE_in_triplesSameSubjectPath3529); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_objectList_in_triplesSameSubjectPath3531);
					objectList(value);
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:776:7: ^( TRIPLE triplesSameSubjectPath[value] )
					{
					match(input,TRIPLE,FOLLOW_TRIPLE_in_triplesSameSubjectPath3542); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_triplesSameSubjectPath_in_triplesSameSubjectPath3544);
					triplesSameSubjectPath(value);
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "triplesSameSubjectPath"



	// $ANTLR start "path"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:779:1: path : PATH pathSequence ( PIPE pathSequence )* ;
	public final void path() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:780:5: ( PATH pathSequence ( PIPE pathSequence )* )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:780:7: PATH pathSequence ( PIPE pathSequence )*
			{
			match(input,PATH,FOLLOW_PATH_in_path3563); 
			pushFollow(FOLLOW_pathSequence_in_path3565);
			pathSequence();
			state._fsp--;

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:780:25: ( PIPE pathSequence )*
			loop121:
			while (true) {
				int alt121=2;
				int LA121_0 = input.LA(1);
				if ( (LA121_0==PIPE) ) {
					alt121=1;
				}

				switch (alt121) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:780:27: PIPE pathSequence
					{
					match(input,PIPE,FOLLOW_PIPE_in_path3569); 
					pushFollow(FOLLOW_pathSequence_in_path3571);
					pathSequence();
					state._fsp--;

					}
					break;

				default :
					break loop121;
				}
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "path"



	// $ANTLR start "pathSequence"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:783:1: pathSequence : pathEltOrInverse ( DIVIDE pathEltOrInverse )* ;
	public final void pathSequence() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:784:5: ( pathEltOrInverse ( DIVIDE pathEltOrInverse )* )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:784:7: pathEltOrInverse ( DIVIDE pathEltOrInverse )*
			{
			pushFollow(FOLLOW_pathEltOrInverse_in_pathSequence3591);
			pathEltOrInverse();
			state._fsp--;

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:784:24: ( DIVIDE pathEltOrInverse )*
			loop122:
			while (true) {
				int alt122=2;
				int LA122_0 = input.LA(1);
				if ( (LA122_0==DIVIDE) ) {
					alt122=1;
				}

				switch (alt122) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:784:26: DIVIDE pathEltOrInverse
					{
					match(input,DIVIDE,FOLLOW_DIVIDE_in_pathSequence3595); 
					pushFollow(FOLLOW_pathEltOrInverse_in_pathSequence3597);
					pathEltOrInverse();
					state._fsp--;

					}
					break;

				default :
					break loop122;
				}
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "pathSequence"



	// $ANTLR start "pathElt"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:787:1: pathElt : pathPrimary ( pathMod )? ;
	public final void pathElt() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:788:5: ( pathPrimary ( pathMod )? )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:788:7: pathPrimary ( pathMod )?
			{
			pushFollow(FOLLOW_pathPrimary_in_pathElt3617);
			pathPrimary();
			state._fsp--;

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:788:19: ( pathMod )?
			int alt123=2;
			int LA123_0 = input.LA(1);
			if ( (LA123_0==ASTERISK||LA123_0==OPEN_CURLY_BRACE||LA123_0==PLUS||LA123_0==QUESTION_MARK) ) {
				alt123=1;
			}
			switch (alt123) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:788:19: pathMod
					{
					pushFollow(FOLLOW_pathMod_in_pathElt3619);
					pathMod();
					state._fsp--;

					}
					break;

			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "pathElt"



	// $ANTLR start "pathEltOrInverse"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:791:1: pathEltOrInverse : ( pathElt | INVERSE pathElt );
	public final void pathEltOrInverse() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:792:5: ( pathElt | INVERSE pathElt )
			int alt124=2;
			int LA124_0 = input.LA(1);
			if ( (LA124_0==PATH_PRIMARY) ) {
				alt124=1;
			}
			else if ( (LA124_0==INVERSE) ) {
				alt124=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 124, 0, input);
				throw nvae;
			}

			switch (alt124) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:792:7: pathElt
					{
					pushFollow(FOLLOW_pathElt_in_pathEltOrInverse3637);
					pathElt();
					state._fsp--;

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:792:17: INVERSE pathElt
					{
					match(input,INVERSE,FOLLOW_INVERSE_in_pathEltOrInverse3641); 
					pushFollow(FOLLOW_pathElt_in_pathEltOrInverse3643);
					pathElt();
					state._fsp--;

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "pathEltOrInverse"



	// $ANTLR start "pathMod"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:795:1: pathMod : ( ASTERISK | QUESTION_MARK | PLUS | OPEN_CURLY_BRACE ( INTEGER ( COMMA ( CLOSE_CURLY_BRACE | INTEGER CLOSE_CURLY_BRACE ) | CLOSE_CURLY_BRACE ) | COMMA INTEGER CLOSE_CURLY_BRACE ) ) ;
	public final void pathMod() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:796:5: ( ( ASTERISK | QUESTION_MARK | PLUS | OPEN_CURLY_BRACE ( INTEGER ( COMMA ( CLOSE_CURLY_BRACE | INTEGER CLOSE_CURLY_BRACE ) | CLOSE_CURLY_BRACE ) | COMMA INTEGER CLOSE_CURLY_BRACE ) ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:796:7: ( ASTERISK | QUESTION_MARK | PLUS | OPEN_CURLY_BRACE ( INTEGER ( COMMA ( CLOSE_CURLY_BRACE | INTEGER CLOSE_CURLY_BRACE ) | CLOSE_CURLY_BRACE ) | COMMA INTEGER CLOSE_CURLY_BRACE ) )
			{
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:796:7: ( ASTERISK | QUESTION_MARK | PLUS | OPEN_CURLY_BRACE ( INTEGER ( COMMA ( CLOSE_CURLY_BRACE | INTEGER CLOSE_CURLY_BRACE ) | CLOSE_CURLY_BRACE ) | COMMA INTEGER CLOSE_CURLY_BRACE ) )
			int alt128=4;
			switch ( input.LA(1) ) {
			case ASTERISK:
				{
				alt128=1;
				}
				break;
			case QUESTION_MARK:
				{
				alt128=2;
				}
				break;
			case PLUS:
				{
				alt128=3;
				}
				break;
			case OPEN_CURLY_BRACE:
				{
				alt128=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 128, 0, input);
				throw nvae;
			}
			switch (alt128) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:796:9: ASTERISK
					{
					match(input,ASTERISK,FOLLOW_ASTERISK_in_pathMod3662); 
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:796:20: QUESTION_MARK
					{
					match(input,QUESTION_MARK,FOLLOW_QUESTION_MARK_in_pathMod3666); 
					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:796:36: PLUS
					{
					match(input,PLUS,FOLLOW_PLUS_in_pathMod3670); 
					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:796:43: OPEN_CURLY_BRACE ( INTEGER ( COMMA ( CLOSE_CURLY_BRACE | INTEGER CLOSE_CURLY_BRACE ) | CLOSE_CURLY_BRACE ) | COMMA INTEGER CLOSE_CURLY_BRACE )
					{
					match(input,OPEN_CURLY_BRACE,FOLLOW_OPEN_CURLY_BRACE_in_pathMod3674); 
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:796:60: ( INTEGER ( COMMA ( CLOSE_CURLY_BRACE | INTEGER CLOSE_CURLY_BRACE ) | CLOSE_CURLY_BRACE ) | COMMA INTEGER CLOSE_CURLY_BRACE )
					int alt127=2;
					int LA127_0 = input.LA(1);
					if ( (LA127_0==INTEGER) ) {
						alt127=1;
					}
					else if ( (LA127_0==COMMA) ) {
						alt127=2;
					}

					else {
						NoViableAltException nvae =
							new NoViableAltException("", 127, 0, input);
						throw nvae;
					}

					switch (alt127) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:796:62: INTEGER ( COMMA ( CLOSE_CURLY_BRACE | INTEGER CLOSE_CURLY_BRACE ) | CLOSE_CURLY_BRACE )
							{
							match(input,INTEGER,FOLLOW_INTEGER_in_pathMod3678); 
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:796:70: ( COMMA ( CLOSE_CURLY_BRACE | INTEGER CLOSE_CURLY_BRACE ) | CLOSE_CURLY_BRACE )
							int alt126=2;
							int LA126_0 = input.LA(1);
							if ( (LA126_0==COMMA) ) {
								alt126=1;
							}
							else if ( (LA126_0==CLOSE_CURLY_BRACE) ) {
								alt126=2;
							}

							else {
								NoViableAltException nvae =
									new NoViableAltException("", 126, 0, input);
								throw nvae;
							}

							switch (alt126) {
								case 1 :
									// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:796:72: COMMA ( CLOSE_CURLY_BRACE | INTEGER CLOSE_CURLY_BRACE )
									{
									match(input,COMMA,FOLLOW_COMMA_in_pathMod3682); 
									// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:796:78: ( CLOSE_CURLY_BRACE | INTEGER CLOSE_CURLY_BRACE )
									int alt125=2;
									int LA125_0 = input.LA(1);
									if ( (LA125_0==CLOSE_CURLY_BRACE) ) {
										alt125=1;
									}
									else if ( (LA125_0==INTEGER) ) {
										alt125=2;
									}

									else {
										NoViableAltException nvae =
											new NoViableAltException("", 125, 0, input);
										throw nvae;
									}

									switch (alt125) {
										case 1 :
											// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:796:80: CLOSE_CURLY_BRACE
											{
											match(input,CLOSE_CURLY_BRACE,FOLLOW_CLOSE_CURLY_BRACE_in_pathMod3686); 
											}
											break;
										case 2 :
											// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:796:100: INTEGER CLOSE_CURLY_BRACE
											{
											match(input,INTEGER,FOLLOW_INTEGER_in_pathMod3690); 
											match(input,CLOSE_CURLY_BRACE,FOLLOW_CLOSE_CURLY_BRACE_in_pathMod3692); 
											}
											break;

									}

									}
									break;
								case 2 :
									// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:796:130: CLOSE_CURLY_BRACE
									{
									match(input,CLOSE_CURLY_BRACE,FOLLOW_CLOSE_CURLY_BRACE_in_pathMod3698); 
									}
									break;

							}

							}
							break;
						case 2 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:796:152: COMMA INTEGER CLOSE_CURLY_BRACE
							{
							match(input,COMMA,FOLLOW_COMMA_in_pathMod3704); 
							match(input,INTEGER,FOLLOW_INTEGER_in_pathMod3706); 
							match(input,CLOSE_CURLY_BRACE,FOLLOW_CLOSE_CURLY_BRACE_in_pathMod3708); 
							}
							break;

					}

					}
					break;

			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "pathMod"



	// $ANTLR start "pathPrimary"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:799:1: pathPrimary : ( ^( PATH_PRIMARY iriRef ) | ^( PATH_PRIMARY A ) | ^( PATH_PRIMARY NEGATION pathNegatedPropertySet ) | ^( PATH_PRIMARY path ) );
	public final void pathPrimary() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:800:5: ( ^( PATH_PRIMARY iriRef ) | ^( PATH_PRIMARY A ) | ^( PATH_PRIMARY NEGATION pathNegatedPropertySet ) | ^( PATH_PRIMARY path ) )
			int alt129=4;
			int LA129_0 = input.LA(1);
			if ( (LA129_0==PATH_PRIMARY) ) {
				int LA129_1 = input.LA(2);
				if ( (LA129_1==DOWN) ) {
					switch ( input.LA(3) ) {
					case A:
						{
						alt129=2;
						}
						break;
					case NEGATION:
						{
						alt129=3;
						}
						break;
					case IRI_REF:
					case PNAME_LN:
					case PNAME_NS:
						{
						alt129=1;
						}
						break;
					case PATH:
						{
						alt129=4;
						}
						break;
					default:
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 129, 2, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 129, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 129, 0, input);
				throw nvae;
			}

			switch (alt129) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:800:7: ^( PATH_PRIMARY iriRef )
					{
					match(input,PATH_PRIMARY,FOLLOW_PATH_PRIMARY_in_pathPrimary3730); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_iriRef_in_pathPrimary3732);
					iriRef();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:801:7: ^( PATH_PRIMARY A )
					{
					match(input,PATH_PRIMARY,FOLLOW_PATH_PRIMARY_in_pathPrimary3742); 
					match(input, Token.DOWN, null); 
					match(input,A,FOLLOW_A_in_pathPrimary3744); 
					match(input, Token.UP, null); 

					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:802:7: ^( PATH_PRIMARY NEGATION pathNegatedPropertySet )
					{
					match(input,PATH_PRIMARY,FOLLOW_PATH_PRIMARY_in_pathPrimary3754); 
					match(input, Token.DOWN, null); 
					match(input,NEGATION,FOLLOW_NEGATION_in_pathPrimary3756); 
					pushFollow(FOLLOW_pathNegatedPropertySet_in_pathPrimary3758);
					pathNegatedPropertySet();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:803:7: ^( PATH_PRIMARY path )
					{
					match(input,PATH_PRIMARY,FOLLOW_PATH_PRIMARY_in_pathPrimary3768); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_path_in_pathPrimary3770);
					path();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "pathPrimary"



	// $ANTLR start "pathNegatedPropertySet"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:806:1: pathNegatedPropertySet : ^( PATH_NEGATED ( pathOneInPropertySet )+ ) ;
	public final void pathNegatedPropertySet() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:807:5: ( ^( PATH_NEGATED ( pathOneInPropertySet )+ ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:807:7: ^( PATH_NEGATED ( pathOneInPropertySet )+ )
			{
			match(input,PATH_NEGATED,FOLLOW_PATH_NEGATED_in_pathNegatedPropertySet3789); 
			match(input, Token.DOWN, null); 
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:807:22: ( pathOneInPropertySet )+
			int cnt130=0;
			loop130:
			while (true) {
				int alt130=2;
				int LA130_0 = input.LA(1);
				if ( (LA130_0==A||LA130_0==INVERSE||LA130_0==IRI_REF||(LA130_0 >= PNAME_LN && LA130_0 <= PNAME_NS)) ) {
					alt130=1;
				}

				switch (alt130) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:807:22: pathOneInPropertySet
					{
					pushFollow(FOLLOW_pathOneInPropertySet_in_pathNegatedPropertySet3791);
					pathOneInPropertySet();
					state._fsp--;

					}
					break;

				default :
					if ( cnt130 >= 1 ) break loop130;
					EarlyExitException eee = new EarlyExitException(130, input);
					throw eee;
				}
				cnt130++;
			}

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "pathNegatedPropertySet"



	// $ANTLR start "pathOneInPropertySet"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:810:1: pathOneInPropertySet : ( INVERSE )? ( iriRef | A ) ;
	public final void pathOneInPropertySet() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:811:5: ( ( INVERSE )? ( iriRef | A ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:811:7: ( INVERSE )? ( iriRef | A )
			{
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:811:7: ( INVERSE )?
			int alt131=2;
			int LA131_0 = input.LA(1);
			if ( (LA131_0==INVERSE) ) {
				alt131=1;
			}
			switch (alt131) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:811:7: INVERSE
					{
					match(input,INVERSE,FOLLOW_INVERSE_in_pathOneInPropertySet3810); 
					}
					break;

			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:811:16: ( iriRef | A )
			int alt132=2;
			int LA132_0 = input.LA(1);
			if ( (LA132_0==IRI_REF||(LA132_0 >= PNAME_LN && LA132_0 <= PNAME_NS)) ) {
				alt132=1;
			}
			else if ( (LA132_0==A) ) {
				alt132=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 132, 0, input);
				throw nvae;
			}

			switch (alt132) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:811:18: iriRef
					{
					pushFollow(FOLLOW_iriRef_in_pathOneInPropertySet3815);
					iriRef();
					state._fsp--;

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:811:27: A
					{
					match(input,A,FOLLOW_A_in_pathOneInPropertySet3819); 
					}
					break;

			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "pathOneInPropertySet"



	// $ANTLR start "triplesNode"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:814:1: triplesNode[BasicPattern triples] returns [Node value] : ( ^( COLLECTION ( graphNode[triples] )+ ) | ^( TRIPLE objectList[triples] ) );
	public final Node triplesNode(BasicPattern triples) throws RecognitionException {
		Node value = null;


		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:815:5: ( ^( COLLECTION ( graphNode[triples] )+ ) | ^( TRIPLE objectList[triples] ) )
			int alt134=2;
			int LA134_0 = input.LA(1);
			if ( (LA134_0==COLLECTION) ) {
				alt134=1;
			}
			else if ( (LA134_0==TRIPLE) ) {
				alt134=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 134, 0, input);
				throw nvae;
			}

			switch (alt134) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:815:7: ^( COLLECTION ( graphNode[triples] )+ )
					{
					match(input,COLLECTION,FOLLOW_COLLECTION_in_triplesNode3844); 
					match(input, Token.DOWN, null); 
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:815:20: ( graphNode[triples] )+
					int cnt133=0;
					loop133:
					while (true) {
						int alt133=2;
						int LA133_0 = input.LA(1);
						if ( (LA133_0==BLANK_NODE_LABEL||LA133_0==COLLECTION||(LA133_0 >= DECIMAL && LA133_0 <= DECIMAL_POSITIVE)||(LA133_0 >= DOUBLE && LA133_0 <= DOUBLE_POSITIVE)||LA133_0==FALSE||(LA133_0 >= INTEGER && LA133_0 <= INTEGER_POSITIVE)||LA133_0==IRI_REF||LA133_0==OPEN_BRACE||LA133_0==OPEN_SQUARE_BRACKET||LA133_0==PLAIN_LITERAL||(LA133_0 >= PNAME_LN && LA133_0 <= PNAME_NS)||LA133_0==TRIPLE||(LA133_0 >= TRUE && LA133_0 <= TYPED_LITERAL)||LA133_0==VAR) ) {
							alt133=1;
						}

						switch (alt133) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:815:20: graphNode[triples]
							{
							pushFollow(FOLLOW_graphNode_in_triplesNode3846);
							graphNode(triples);
							state._fsp--;

							}
							break;

						default :
							if ( cnt133 >= 1 ) break loop133;
							EarlyExitException eee = new EarlyExitException(133, input);
							throw eee;
						}
						cnt133++;
					}

					match(input, Token.UP, null); 

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:816:7: ^( TRIPLE objectList[triples] )
					{
					match(input,TRIPLE,FOLLOW_TRIPLE_in_triplesNode3858); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_objectList_in_triplesNode3860);
					objectList(triples);
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "triplesNode"



	// $ANTLR start "graphNode"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:819:1: graphNode[BasicPattern triples] returns [Node value] : (a= varOrTerm | triplesNode[triples] );
	public final Node graphNode(BasicPattern triples) throws RecognitionException {
		Node value = null;


		Node a =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:820:5: (a= varOrTerm | triplesNode[triples] )
			int alt135=2;
			int LA135_0 = input.LA(1);
			if ( (LA135_0==BLANK_NODE_LABEL||(LA135_0 >= DECIMAL && LA135_0 <= DECIMAL_POSITIVE)||(LA135_0 >= DOUBLE && LA135_0 <= DOUBLE_POSITIVE)||LA135_0==FALSE||(LA135_0 >= INTEGER && LA135_0 <= INTEGER_POSITIVE)||LA135_0==IRI_REF||LA135_0==OPEN_BRACE||LA135_0==OPEN_SQUARE_BRACKET||LA135_0==PLAIN_LITERAL||(LA135_0 >= PNAME_LN && LA135_0 <= PNAME_NS)||(LA135_0 >= TRUE && LA135_0 <= TYPED_LITERAL)||LA135_0==VAR) ) {
				alt135=1;
			}
			else if ( (LA135_0==COLLECTION||LA135_0==TRIPLE) ) {
				alt135=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 135, 0, input);
				throw nvae;
			}

			switch (alt135) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:820:7: a= varOrTerm
					{
					pushFollow(FOLLOW_varOrTerm_in_graphNode3888);
					a=varOrTerm();
					state._fsp--;

					value = a;
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:821:7: triplesNode[triples]
					{
					pushFollow(FOLLOW_triplesNode_in_graphNode3898);
					triplesNode(triples);
					state._fsp--;

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "graphNode"



	// $ANTLR start "varOrTerm"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:824:1: varOrTerm returns [Node value] : (a= var |a= graphTerm );
	public final Node varOrTerm() throws RecognitionException {
		Node value = null;


		Node a =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:825:5: (a= var |a= graphTerm )
			int alt136=2;
			int LA136_0 = input.LA(1);
			if ( (LA136_0==VAR) ) {
				alt136=1;
			}
			else if ( (LA136_0==BLANK_NODE_LABEL||(LA136_0 >= DECIMAL && LA136_0 <= DECIMAL_POSITIVE)||(LA136_0 >= DOUBLE && LA136_0 <= DOUBLE_POSITIVE)||LA136_0==FALSE||(LA136_0 >= INTEGER && LA136_0 <= INTEGER_POSITIVE)||LA136_0==IRI_REF||LA136_0==OPEN_BRACE||LA136_0==OPEN_SQUARE_BRACKET||LA136_0==PLAIN_LITERAL||(LA136_0 >= PNAME_LN && LA136_0 <= PNAME_NS)||(LA136_0 >= TRUE && LA136_0 <= TYPED_LITERAL)) ) {
				alt136=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 136, 0, input);
				throw nvae;
			}

			switch (alt136) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:825:7: a= var
					{
					pushFollow(FOLLOW_var_in_varOrTerm3922);
					a=var();
					state._fsp--;

					value = a;
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:826:7: a= graphTerm
					{
					pushFollow(FOLLOW_graphTerm_in_varOrTerm3940);
					a=graphTerm();
					state._fsp--;

					value = a;
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "varOrTerm"



	// $ANTLR start "varOrIRIref"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:829:1: varOrIRIref returns [Node value] : (a= var |a= iriRef );
	public final Node varOrIRIref() throws RecognitionException {
		Node value = null;


		Node a =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:830:5: (a= var |a= iriRef )
			int alt137=2;
			int LA137_0 = input.LA(1);
			if ( (LA137_0==VAR) ) {
				alt137=1;
			}
			else if ( (LA137_0==IRI_REF||(LA137_0 >= PNAME_LN && LA137_0 <= PNAME_NS)) ) {
				alt137=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 137, 0, input);
				throw nvae;
			}

			switch (alt137) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:830:7: a= var
					{
					pushFollow(FOLLOW_var_in_varOrIRIref3965);
					a=var();
					state._fsp--;

					value = a;
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:831:7: a= iriRef
					{
					pushFollow(FOLLOW_iriRef_in_varOrIRIref3980);
					a=iriRef();
					state._fsp--;

					value = a;
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "varOrIRIref"



	// $ANTLR start "var"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:834:1: var returns [Var value] : a= VAR ;
	public final Var var() throws RecognitionException {
		Var value = null;


		CommonTree a=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:835:5: (a= VAR )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:835:7: a= VAR
			{
			a=(CommonTree)match(input,VAR,FOLLOW_VAR_in_var4005); 
			value = Var.alloc((a!=null?a.getText():null));
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "var"



	// $ANTLR start "graphTerm"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:838:1: graphTerm returns [Node value] : (a= iriRef |a= rdfLiteral |b= numericLiteral |b= booleanLiteral |a= blankNode | nil );
	public final Node graphTerm() throws RecognitionException {
		Node value = null;


		Node a =null;
		NodeValue b =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:839:5: (a= iriRef |a= rdfLiteral |b= numericLiteral |b= booleanLiteral |a= blankNode | nil )
			int alt138=6;
			switch ( input.LA(1) ) {
			case IRI_REF:
			case PNAME_LN:
			case PNAME_NS:
				{
				alt138=1;
				}
				break;
			case PLAIN_LITERAL:
			case TYPED_LITERAL:
				{
				alt138=2;
				}
				break;
			case DECIMAL:
			case DECIMAL_NEGATIVE:
			case DECIMAL_POSITIVE:
			case DOUBLE:
			case DOUBLE_NEGATIVE:
			case DOUBLE_POSITIVE:
			case INTEGER:
			case INTEGER_NEGATIVE:
			case INTEGER_POSITIVE:
				{
				alt138=3;
				}
				break;
			case FALSE:
			case TRUE:
				{
				alt138=4;
				}
				break;
			case BLANK_NODE_LABEL:
			case OPEN_SQUARE_BRACKET:
				{
				alt138=5;
				}
				break;
			case OPEN_BRACE:
				{
				alt138=6;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 138, 0, input);
				throw nvae;
			}
			switch (alt138) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:839:7: a= iriRef
					{
					pushFollow(FOLLOW_iriRef_in_graphTerm4030);
					a=iriRef();
					state._fsp--;

					value = a;
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:840:7: a= rdfLiteral
					{
					pushFollow(FOLLOW_rdfLiteral_in_graphTerm4050);
					a=rdfLiteral();
					state._fsp--;

					value = a;
					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:841:7: b= numericLiteral
					{
					pushFollow(FOLLOW_numericLiteral_in_graphTerm4068);
					b=numericLiteral();
					state._fsp--;

					value = b.asNode();
					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:842:7: b= booleanLiteral
					{
					pushFollow(FOLLOW_booleanLiteral_in_graphTerm4080);
					b=booleanLiteral();
					state._fsp--;

					value = b.asNode();
					}
					break;
				case 5 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:843:7: a= blankNode
					{
					pushFollow(FOLLOW_blankNode_in_graphTerm4092);
					a=blankNode();
					state._fsp--;

					value = a;
					}
					break;
				case 6 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:844:7: nil
					{
					pushFollow(FOLLOW_nil_in_graphTerm4107);
					nil();
					state._fsp--;

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "graphTerm"



	// $ANTLR start "nil"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:847:1: nil : OPEN_BRACE CLOSE_BRACE ;
	public final void nil() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:848:5: ( OPEN_BRACE CLOSE_BRACE )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:848:7: OPEN_BRACE CLOSE_BRACE
			{
			match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_nil4124); 
			match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_nil4126); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "nil"



	// $ANTLR start "expression"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:851:1: expression returns [ Expr value ] : ( ^( OR a= expression b= expression ) | ^( AND a= expression b= expression ) | ^( EQUAL a= expression b= expression ) | ^( NOT_EQUAL a= expression b= expression ) | ^( LESS a= expression b= expression ) | ^( GREATER a= expression b= expression ) | ^( LESS_EQUAL a= expression b= expression ) | ^( GREATER_EQUAL a= expression b= expression ) | ^( IN a= expression b= expression ) | ^( NOT IN a= expression b= expression ) | ^( PLUS a= expression b= expression ) | ^( MINUS a= expression b= expression ) | ^( ASTERISK a= expression b= expression ) | ^( DIVIDE a= expression b= expression ) |a= unaryExpression );
	public final Expr expression() throws RecognitionException {
		Expr value = null;


		Expr a =null;
		Expr b =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:852:5: ( ^( OR a= expression b= expression ) | ^( AND a= expression b= expression ) | ^( EQUAL a= expression b= expression ) | ^( NOT_EQUAL a= expression b= expression ) | ^( LESS a= expression b= expression ) | ^( GREATER a= expression b= expression ) | ^( LESS_EQUAL a= expression b= expression ) | ^( GREATER_EQUAL a= expression b= expression ) | ^( IN a= expression b= expression ) | ^( NOT IN a= expression b= expression ) | ^( PLUS a= expression b= expression ) | ^( MINUS a= expression b= expression ) | ^( ASTERISK a= expression b= expression ) | ^( DIVIDE a= expression b= expression ) |a= unaryExpression )
			int alt139=15;
			switch ( input.LA(1) ) {
			case OR:
				{
				alt139=1;
				}
				break;
			case AND:
				{
				alt139=2;
				}
				break;
			case EQUAL:
				{
				alt139=3;
				}
				break;
			case NOT_EQUAL:
				{
				alt139=4;
				}
				break;
			case LESS:
				{
				alt139=5;
				}
				break;
			case GREATER:
				{
				alt139=6;
				}
				break;
			case LESS_EQUAL:
				{
				alt139=7;
				}
				break;
			case GREATER_EQUAL:
				{
				alt139=8;
				}
				break;
			case IN:
				{
				alt139=9;
				}
				break;
			case NOT:
				{
				alt139=10;
				}
				break;
			case PLUS:
				{
				alt139=11;
				}
				break;
			case MINUS:
				{
				alt139=12;
				}
				break;
			case ASTERISK:
				{
				alt139=13;
				}
				break;
			case DIVIDE:
				{
				alt139=14;
				}
				break;
			case UNARY:
			case UNARY_MINUS:
			case UNARY_NOT:
			case UNARY_PLUS:
				{
				alt139=15;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 139, 0, input);
				throw nvae;
			}
			switch (alt139) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:852:7: ^( OR a= expression b= expression )
					{
					match(input,OR,FOLLOW_OR_in_expression4148); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_expression4152);
					a=expression();
					state._fsp--;

					pushFollow(FOLLOW_expression_in_expression4156);
					b=expression();
					state._fsp--;

					match(input, Token.UP, null); 

					 value = new E_LogicalOr         (a, b); 
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:853:7: ^( AND a= expression b= expression )
					{
					match(input,AND,FOLLOW_AND_in_expression4179); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_expression4183);
					a=expression();
					state._fsp--;

					pushFollow(FOLLOW_expression_in_expression4187);
					b=expression();
					state._fsp--;

					match(input, Token.UP, null); 

					 value = new E_LogicalAnd        (a, b); 
					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:854:7: ^( EQUAL a= expression b= expression )
					{
					match(input,EQUAL,FOLLOW_EQUAL_in_expression4209); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_expression4213);
					a=expression();
					state._fsp--;

					pushFollow(FOLLOW_expression_in_expression4217);
					b=expression();
					state._fsp--;

					match(input, Token.UP, null); 

					 value = new E_Equals            (a, b); 
					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:855:7: ^( NOT_EQUAL a= expression b= expression )
					{
					match(input,NOT_EQUAL,FOLLOW_NOT_EQUAL_in_expression4237); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_expression4241);
					a=expression();
					state._fsp--;

					pushFollow(FOLLOW_expression_in_expression4245);
					b=expression();
					state._fsp--;

					match(input, Token.UP, null); 

					 value = new E_NotEquals         (a, b); 
					}
					break;
				case 5 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:856:7: ^( LESS a= expression b= expression )
					{
					match(input,LESS,FOLLOW_LESS_in_expression4261); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_expression4265);
					a=expression();
					state._fsp--;

					pushFollow(FOLLOW_expression_in_expression4269);
					b=expression();
					state._fsp--;

					match(input, Token.UP, null); 

					 value = new E_LessThan          (a, b); 
					}
					break;
				case 6 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:857:7: ^( GREATER a= expression b= expression )
					{
					match(input,GREATER,FOLLOW_GREATER_in_expression4290); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_expression4294);
					a=expression();
					state._fsp--;

					pushFollow(FOLLOW_expression_in_expression4298);
					b=expression();
					state._fsp--;

					match(input, Token.UP, null); 

					 value = new E_GreaterThan       (a, b); 
					}
					break;
				case 7 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:858:7: ^( LESS_EQUAL a= expression b= expression )
					{
					match(input,LESS_EQUAL,FOLLOW_LESS_EQUAL_in_expression4316); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_expression4320);
					a=expression();
					state._fsp--;

					pushFollow(FOLLOW_expression_in_expression4324);
					b=expression();
					state._fsp--;

					match(input, Token.UP, null); 

					 value = new E_LessThanOrEqual   (a, b); 
					}
					break;
				case 8 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:859:7: ^( GREATER_EQUAL a= expression b= expression )
					{
					match(input,GREATER_EQUAL,FOLLOW_GREATER_EQUAL_in_expression4339); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_expression4343);
					a=expression();
					state._fsp--;

					pushFollow(FOLLOW_expression_in_expression4347);
					b=expression();
					state._fsp--;

					match(input, Token.UP, null); 

					 value = new E_GreaterThanOrEqual(a, b); 
					}
					break;
				case 9 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:860:7: ^( IN a= expression b= expression )
					{
					match(input,IN,FOLLOW_IN_in_expression4359); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_expression4363);
					a=expression();
					state._fsp--;

					pushFollow(FOLLOW_expression_in_expression4367);
					b=expression();
					state._fsp--;

					match(input, Token.UP, null); 

					 if(true) { throw new NotImplementedException(); } 
					}
					break;
				case 10 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:861:7: ^( NOT IN a= expression b= expression )
					{
					match(input,NOT,FOLLOW_NOT_in_expression4390); 
					match(input, Token.DOWN, null); 
					match(input,IN,FOLLOW_IN_in_expression4392); 
					pushFollow(FOLLOW_expression_in_expression4396);
					a=expression();
					state._fsp--;

					pushFollow(FOLLOW_expression_in_expression4400);
					b=expression();
					state._fsp--;

					match(input, Token.UP, null); 

					 if(true) { throw new NotImplementedException(); } 
					}
					break;
				case 11 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:862:7: ^( PLUS a= expression b= expression )
					{
					match(input,PLUS,FOLLOW_PLUS_in_expression4419); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_expression4423);
					a=expression();
					state._fsp--;

					pushFollow(FOLLOW_expression_in_expression4427);
					b=expression();
					state._fsp--;

					match(input, Token.UP, null); 

					 value = new E_Add               (a, b); 
					}
					break;
				case 12 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:863:7: ^( MINUS a= expression b= expression )
					{
					match(input,MINUS,FOLLOW_MINUS_in_expression4448); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_expression4452);
					a=expression();
					state._fsp--;

					pushFollow(FOLLOW_expression_in_expression4456);
					b=expression();
					state._fsp--;

					match(input, Token.UP, null); 

					 value = new E_Subtract          (a, b); 
					}
					break;
				case 13 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:864:7: ^( ASTERISK a= expression b= expression )
					{
					match(input,ASTERISK,FOLLOW_ASTERISK_in_expression4476); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_expression4480);
					a=expression();
					state._fsp--;

					pushFollow(FOLLOW_expression_in_expression4484);
					b=expression();
					state._fsp--;

					match(input, Token.UP, null); 

					 value = new E_Multiply          (a, b); 
					}
					break;
				case 14 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:865:7: ^( DIVIDE a= expression b= expression )
					{
					match(input,DIVIDE,FOLLOW_DIVIDE_in_expression4501); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_expression4505);
					a=expression();
					state._fsp--;

					pushFollow(FOLLOW_expression_in_expression4509);
					b=expression();
					state._fsp--;

					match(input, Token.UP, null); 

					 value = new E_Divide            (a, b); 
					}
					break;
				case 15 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:866:7: a= unaryExpression
					{
					pushFollow(FOLLOW_unaryExpression_in_expression4529);
					a=unaryExpression();
					state._fsp--;

					 value = a; 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "expression"



	// $ANTLR start "unaryExpression"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:869:1: unaryExpression returns [ Expr value ] : ( ^( UNARY_NOT a= primaryExpression ) | ^( UNARY_PLUS a= primaryExpression ) | ^( UNARY_MINUS a= primaryExpression ) | ^( UNARY a= primaryExpression ) );
	public final Expr unaryExpression() throws RecognitionException {
		Expr value = null;


		Expr a =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:870:5: ( ^( UNARY_NOT a= primaryExpression ) | ^( UNARY_PLUS a= primaryExpression ) | ^( UNARY_MINUS a= primaryExpression ) | ^( UNARY a= primaryExpression ) )
			int alt140=4;
			switch ( input.LA(1) ) {
			case UNARY_NOT:
				{
				alt140=1;
				}
				break;
			case UNARY_PLUS:
				{
				alt140=2;
				}
				break;
			case UNARY_MINUS:
				{
				alt140=3;
				}
				break;
			case UNARY:
				{
				alt140=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 140, 0, input);
				throw nvae;
			}
			switch (alt140) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:870:7: ^( UNARY_NOT a= primaryExpression )
					{
					match(input,UNARY_NOT,FOLLOW_UNARY_NOT_in_unaryExpression4578); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_primaryExpression_in_unaryExpression4582);
					a=primaryExpression();
					state._fsp--;

					match(input, Token.UP, null); 

					 value = new E_LogicalNot(a); 
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:871:7: ^( UNARY_PLUS a= primaryExpression )
					{
					match(input,UNARY_PLUS,FOLLOW_UNARY_PLUS_in_unaryExpression4602); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_primaryExpression_in_unaryExpression4606);
					a=primaryExpression();
					state._fsp--;

					match(input, Token.UP, null); 

					 value = new E_UnaryPlus (a); 
					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:872:7: ^( UNARY_MINUS a= primaryExpression )
					{
					match(input,UNARY_MINUS,FOLLOW_UNARY_MINUS_in_unaryExpression4625); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_primaryExpression_in_unaryExpression4629);
					a=primaryExpression();
					state._fsp--;

					match(input, Token.UP, null); 

					 value = new E_UnaryMinus(a); 
					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:873:7: ^( UNARY a= primaryExpression )
					{
					match(input,UNARY,FOLLOW_UNARY_in_unaryExpression4647); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_primaryExpression_in_unaryExpression4651);
					a=primaryExpression();
					state._fsp--;

					match(input, Token.UP, null); 

					 value = a; 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "unaryExpression"



	// $ANTLR start "primaryExpression"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:876:1: primaryExpression returns [Expr value] : (e= builtInCall |e= iriRefOrFunction |e= expression |n= rdfLiteral |nv= numericLiteral |nv= booleanLiteral |v= var | aggregate );
	public final Expr primaryExpression() throws RecognitionException {
		Expr value = null;


		Expr e =null;
		Node n =null;
		NodeValue nv =null;
		Var v =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:877:5: (e= builtInCall |e= iriRefOrFunction |e= expression |n= rdfLiteral |nv= numericLiteral |nv= booleanLiteral |v= var | aggregate )
			int alt141=8;
			switch ( input.LA(1) ) {
			case ABS:
			case BNODE:
			case BOUND:
			case CEIL:
			case COALESCE:
			case CONCAT:
			case CONTAINS:
			case DATATYPE:
			case DAY:
			case ENCODE_FOR_URI:
			case EXISTS:
			case FLOOR:
			case HOURS:
			case IF:
			case IRI:
			case ISBLANK:
			case ISIRI:
			case ISLITERAL:
			case ISNUMERIC:
			case ISURI:
			case LANG:
			case LANGMATCHES:
			case LCASE:
			case MD5:
			case MINUTES:
			case MONTH:
			case NOT_EXISTS:
			case NOW:
			case RAND:
			case REGEX:
			case ROUND:
			case SAMETERM:
			case SECONDS:
			case SHA1:
			case SHA224:
			case SHA256:
			case SHA384:
			case SHA512:
			case STR:
			case STRDT:
			case STRENDS:
			case STRLANG:
			case STRLEN:
			case STRSTARTS:
			case SUBSTR:
			case TIMEZONE:
			case TZ:
			case UCASE:
			case URI:
			case YEAR:
				{
				alt141=1;
				}
				break;
			case FUNCTION:
			case IRI_REF:
			case PNAME_LN:
			case PNAME_NS:
				{
				alt141=2;
				}
				break;
			case AND:
			case ASTERISK:
			case DIVIDE:
			case EQUAL:
			case GREATER:
			case GREATER_EQUAL:
			case IN:
			case LESS:
			case LESS_EQUAL:
			case MINUS:
			case NOT:
			case NOT_EQUAL:
			case OR:
			case PLUS:
			case UNARY:
			case UNARY_MINUS:
			case UNARY_NOT:
			case UNARY_PLUS:
				{
				alt141=3;
				}
				break;
			case PLAIN_LITERAL:
			case TYPED_LITERAL:
				{
				alt141=4;
				}
				break;
			case DECIMAL:
			case DECIMAL_NEGATIVE:
			case DECIMAL_POSITIVE:
			case DOUBLE:
			case DOUBLE_NEGATIVE:
			case DOUBLE_POSITIVE:
			case INTEGER:
			case INTEGER_NEGATIVE:
			case INTEGER_POSITIVE:
				{
				alt141=5;
				}
				break;
			case FALSE:
			case TRUE:
				{
				alt141=6;
				}
				break;
			case VAR:
				{
				alt141=7;
				}
				break;
			case AVG:
			case COUNT:
			case GROUP_CONCAT:
			case MAX:
			case MIN:
			case SAMPLE:
			case SUM:
				{
				alt141=8;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 141, 0, input);
				throw nvae;
			}
			switch (alt141) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:877:7: e= builtInCall
					{
					pushFollow(FOLLOW_builtInCall_in_primaryExpression4689);
					e=builtInCall();
					state._fsp--;

					value = e;
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:878:7: e= iriRefOrFunction
					{
					pushFollow(FOLLOW_iriRefOrFunction_in_primaryExpression4707);
					e=iriRefOrFunction();
					state._fsp--;

					value = e;
					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:879:7: e= expression
					{
					pushFollow(FOLLOW_expression_in_primaryExpression4720);
					e=expression();
					state._fsp--;

					value = e;
					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:880:7: n= rdfLiteral
					{
					pushFollow(FOLLOW_rdfLiteral_in_primaryExpression4740);
					n=rdfLiteral();
					state._fsp--;

					value = NodeValue.makeNode(n);
					}
					break;
				case 5 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:881:7: nv= numericLiteral
					{
					pushFollow(FOLLOW_numericLiteral_in_primaryExpression4759);
					nv=numericLiteral();
					state._fsp--;

					value = nv;
					}
					break;
				case 6 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:882:7: nv= booleanLiteral
					{
					pushFollow(FOLLOW_booleanLiteral_in_primaryExpression4774);
					nv=booleanLiteral();
					state._fsp--;

					value = nv;
					}
					break;
				case 7 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:883:7: v= var
					{
					pushFollow(FOLLOW_var_in_primaryExpression4789);
					v=var();
					state._fsp--;

					value = new ExprVar(v);
					}
					break;
				case 8 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:884:7: aggregate
					{
					pushFollow(FOLLOW_aggregate_in_primaryExpression4813);
					aggregate();
					state._fsp--;

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "primaryExpression"



	// $ANTLR start "builtInCall"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:887:1: builtInCall returns [Expr value] : ( ^( STR a= expression ) | ^( LANG a= expression ) | ^( LANGMATCHES a= expression b= expression ) | ^( DATATYPE a= expression ) | ^( BOUND n= var ) | ^( IRI a= expression ) | ^( URI a= expression ) | ^( BNODE expression ) | RAND | ^( ABS a= expression ) | ^( CEIL a= expression ) | ^( FLOOR a= expression ) | ^( ROUND expression ) | ^( CONCAT l= expressionList ) | subStringExpression | ^( STRLEN expression ) | ^( UCASE expression ) | ^( LCASE expression ) | ^( ENCODE_FOR_URI expression ) | ^( CONTAINS expression ) | ^( STRSTARTS expression ) | ^( STRENDS expression ) | ^( YEAR expression ) | ^( MONTH expression ) | ^( DAY expression ) | ^( HOURS expression ) | ^( MINUTES expression ) | ^( SECONDS expression ) | ^( TIMEZONE expression ) | ^( TZ expression ) | NOW | ^( MD5 expression ) | ^( SHA1 expression ) | ^( SHA224 expression ) | ^( SHA256 expression ) | ^( SHA384 expression ) | ^( SHA512 expression ) | ^( COALESCE expressionList ) | ^( IF expression expression expression ) | ^( STRLANG expression expression ) | ^( STRDT expression expression ) | ^( SAMETERM expression expression ) | ^( ISIRI expression ) | ^( ISURI expression ) | ^( ISBLANK expression ) | ^( ISLITERAL expression ) | ^( ISNUMERIC expression ) | regexExpression | existsFunction | notExistsFunction );
	public final Expr builtInCall() throws RecognitionException {
		Expr value = null;


		Expr a =null;
		Expr b =null;
		Var n =null;
		ExprList l =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:888:5: ( ^( STR a= expression ) | ^( LANG a= expression ) | ^( LANGMATCHES a= expression b= expression ) | ^( DATATYPE a= expression ) | ^( BOUND n= var ) | ^( IRI a= expression ) | ^( URI a= expression ) | ^( BNODE expression ) | RAND | ^( ABS a= expression ) | ^( CEIL a= expression ) | ^( FLOOR a= expression ) | ^( ROUND expression ) | ^( CONCAT l= expressionList ) | subStringExpression | ^( STRLEN expression ) | ^( UCASE expression ) | ^( LCASE expression ) | ^( ENCODE_FOR_URI expression ) | ^( CONTAINS expression ) | ^( STRSTARTS expression ) | ^( STRENDS expression ) | ^( YEAR expression ) | ^( MONTH expression ) | ^( DAY expression ) | ^( HOURS expression ) | ^( MINUTES expression ) | ^( SECONDS expression ) | ^( TIMEZONE expression ) | ^( TZ expression ) | NOW | ^( MD5 expression ) | ^( SHA1 expression ) | ^( SHA224 expression ) | ^( SHA256 expression ) | ^( SHA384 expression ) | ^( SHA512 expression ) | ^( COALESCE expressionList ) | ^( IF expression expression expression ) | ^( STRLANG expression expression ) | ^( STRDT expression expression ) | ^( SAMETERM expression expression ) | ^( ISIRI expression ) | ^( ISURI expression ) | ^( ISBLANK expression ) | ^( ISLITERAL expression ) | ^( ISNUMERIC expression ) | regexExpression | existsFunction | notExistsFunction )
			int alt142=50;
			switch ( input.LA(1) ) {
			case STR:
				{
				alt142=1;
				}
				break;
			case LANG:
				{
				alt142=2;
				}
				break;
			case LANGMATCHES:
				{
				alt142=3;
				}
				break;
			case DATATYPE:
				{
				alt142=4;
				}
				break;
			case BOUND:
				{
				alt142=5;
				}
				break;
			case IRI:
				{
				alt142=6;
				}
				break;
			case URI:
				{
				alt142=7;
				}
				break;
			case BNODE:
				{
				alt142=8;
				}
				break;
			case RAND:
				{
				alt142=9;
				}
				break;
			case ABS:
				{
				alt142=10;
				}
				break;
			case CEIL:
				{
				alt142=11;
				}
				break;
			case FLOOR:
				{
				alt142=12;
				}
				break;
			case ROUND:
				{
				alt142=13;
				}
				break;
			case CONCAT:
				{
				alt142=14;
				}
				break;
			case SUBSTR:
				{
				alt142=15;
				}
				break;
			case STRLEN:
				{
				alt142=16;
				}
				break;
			case UCASE:
				{
				alt142=17;
				}
				break;
			case LCASE:
				{
				alt142=18;
				}
				break;
			case ENCODE_FOR_URI:
				{
				alt142=19;
				}
				break;
			case CONTAINS:
				{
				alt142=20;
				}
				break;
			case STRSTARTS:
				{
				alt142=21;
				}
				break;
			case STRENDS:
				{
				alt142=22;
				}
				break;
			case YEAR:
				{
				alt142=23;
				}
				break;
			case MONTH:
				{
				alt142=24;
				}
				break;
			case DAY:
				{
				alt142=25;
				}
				break;
			case HOURS:
				{
				alt142=26;
				}
				break;
			case MINUTES:
				{
				alt142=27;
				}
				break;
			case SECONDS:
				{
				alt142=28;
				}
				break;
			case TIMEZONE:
				{
				alt142=29;
				}
				break;
			case TZ:
				{
				alt142=30;
				}
				break;
			case NOW:
				{
				alt142=31;
				}
				break;
			case MD5:
				{
				alt142=32;
				}
				break;
			case SHA1:
				{
				alt142=33;
				}
				break;
			case SHA224:
				{
				alt142=34;
				}
				break;
			case SHA256:
				{
				alt142=35;
				}
				break;
			case SHA384:
				{
				alt142=36;
				}
				break;
			case SHA512:
				{
				alt142=37;
				}
				break;
			case COALESCE:
				{
				alt142=38;
				}
				break;
			case IF:
				{
				alt142=39;
				}
				break;
			case STRLANG:
				{
				alt142=40;
				}
				break;
			case STRDT:
				{
				alt142=41;
				}
				break;
			case SAMETERM:
				{
				alt142=42;
				}
				break;
			case ISIRI:
				{
				alt142=43;
				}
				break;
			case ISURI:
				{
				alt142=44;
				}
				break;
			case ISBLANK:
				{
				alt142=45;
				}
				break;
			case ISLITERAL:
				{
				alt142=46;
				}
				break;
			case ISNUMERIC:
				{
				alt142=47;
				}
				break;
			case REGEX:
				{
				alt142=48;
				}
				break;
			case EXISTS:
				{
				alt142=49;
				}
				break;
			case NOT_EXISTS:
				{
				alt142=50;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 142, 0, input);
				throw nvae;
			}
			switch (alt142) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:888:7: ^( STR a= expression )
					{
					match(input,STR,FOLLOW_STR_in_builtInCall4835); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall4839);
					a=expression();
					state._fsp--;

					match(input, Token.UP, null); 

					value = new E_Str(a);
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:889:7: ^( LANG a= expression )
					{
					match(input,LANG,FOLLOW_LANG_in_builtInCall4863); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall4867);
					a=expression();
					state._fsp--;

					match(input, Token.UP, null); 

					value = new E_Lang(a);
					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:890:7: ^( LANGMATCHES a= expression b= expression )
					{
					match(input,LANGMATCHES,FOLLOW_LANGMATCHES_in_builtInCall4890); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall4894);
					a=expression();
					state._fsp--;

					pushFollow(FOLLOW_expression_in_builtInCall4898);
					b=expression();
					state._fsp--;

					match(input, Token.UP, null); 

					value = new E_LangMatches(a, b);
					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:891:7: ^( DATATYPE a= expression )
					{
					match(input,DATATYPE,FOLLOW_DATATYPE_in_builtInCall4913); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall4917);
					a=expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 5 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:892:7: ^( BOUND n= var )
					{
					match(input,BOUND,FOLLOW_BOUND_in_builtInCall4927); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_var_in_builtInCall4931);
					n=var();
					state._fsp--;

					match(input, Token.UP, null); 

					value = new E_Bound(new ExprVar(n));
					}
					break;
				case 6 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:893:7: ^( IRI a= expression )
					{
					match(input,IRI,FOLLOW_IRI_in_builtInCall4960); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall4964);
					a=expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 7 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:894:7: ^( URI a= expression )
					{
					match(input,URI,FOLLOW_URI_in_builtInCall4974); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall4978);
					a=expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 8 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:895:7: ^( BNODE expression )
					{
					match(input,BNODE,FOLLOW_BNODE_in_builtInCall4988); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall4990);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 9 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:896:7: RAND
					{
					match(input,RAND,FOLLOW_RAND_in_builtInCall4999); 
					}
					break;
				case 10 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:897:7: ^( ABS a= expression )
					{
					match(input,ABS,FOLLOW_ABS_in_builtInCall5008); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5012);
					a=expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 11 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:898:7: ^( CEIL a= expression )
					{
					match(input,CEIL,FOLLOW_CEIL_in_builtInCall5022); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5026);
					a=expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 12 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:899:7: ^( FLOOR a= expression )
					{
					match(input,FLOOR,FOLLOW_FLOOR_in_builtInCall5036); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5040);
					a=expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 13 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:900:7: ^( ROUND expression )
					{
					match(input,ROUND,FOLLOW_ROUND_in_builtInCall5050); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5052);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 14 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:901:7: ^( CONCAT l= expressionList )
					{
					match(input,CONCAT,FOLLOW_CONCAT_in_builtInCall5062); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expressionList_in_builtInCall5066);
					l=expressionList();
					state._fsp--;

					match(input, Token.UP, null); 

					value = new E_StrConcatPermissive(l);
					}
					break;
				case 15 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:902:7: subStringExpression
					{
					pushFollow(FOLLOW_subStringExpression_in_builtInCall5082);
					subStringExpression();
					state._fsp--;

					}
					break;
				case 16 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:903:7: ^( STRLEN expression )
					{
					match(input,STRLEN,FOLLOW_STRLEN_in_builtInCall5091); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5093);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 17 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:904:7: ^( UCASE expression )
					{
					match(input,UCASE,FOLLOW_UCASE_in_builtInCall5103); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5105);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 18 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:905:7: ^( LCASE expression )
					{
					match(input,LCASE,FOLLOW_LCASE_in_builtInCall5115); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5117);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 19 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:906:7: ^( ENCODE_FOR_URI expression )
					{
					match(input,ENCODE_FOR_URI,FOLLOW_ENCODE_FOR_URI_in_builtInCall5127); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5129);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 20 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:907:7: ^( CONTAINS expression )
					{
					match(input,CONTAINS,FOLLOW_CONTAINS_in_builtInCall5139); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5141);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 21 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:908:7: ^( STRSTARTS expression )
					{
					match(input,STRSTARTS,FOLLOW_STRSTARTS_in_builtInCall5151); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5153);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 22 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:909:7: ^( STRENDS expression )
					{
					match(input,STRENDS,FOLLOW_STRENDS_in_builtInCall5163); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5165);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 23 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:910:7: ^( YEAR expression )
					{
					match(input,YEAR,FOLLOW_YEAR_in_builtInCall5175); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5177);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 24 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:911:7: ^( MONTH expression )
					{
					match(input,MONTH,FOLLOW_MONTH_in_builtInCall5187); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5189);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 25 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:912:7: ^( DAY expression )
					{
					match(input,DAY,FOLLOW_DAY_in_builtInCall5199); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5201);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 26 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:913:7: ^( HOURS expression )
					{
					match(input,HOURS,FOLLOW_HOURS_in_builtInCall5211); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5213);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 27 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:914:7: ^( MINUTES expression )
					{
					match(input,MINUTES,FOLLOW_MINUTES_in_builtInCall5223); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5225);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 28 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:915:7: ^( SECONDS expression )
					{
					match(input,SECONDS,FOLLOW_SECONDS_in_builtInCall5235); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5237);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 29 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:916:7: ^( TIMEZONE expression )
					{
					match(input,TIMEZONE,FOLLOW_TIMEZONE_in_builtInCall5247); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5249);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 30 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:917:7: ^( TZ expression )
					{
					match(input,TZ,FOLLOW_TZ_in_builtInCall5259); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5261);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 31 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:918:7: NOW
					{
					match(input,NOW,FOLLOW_NOW_in_builtInCall5270); 
					}
					break;
				case 32 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:919:7: ^( MD5 expression )
					{
					match(input,MD5,FOLLOW_MD5_in_builtInCall5279); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5281);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 33 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:920:7: ^( SHA1 expression )
					{
					match(input,SHA1,FOLLOW_SHA1_in_builtInCall5291); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5293);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 34 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:921:7: ^( SHA224 expression )
					{
					match(input,SHA224,FOLLOW_SHA224_in_builtInCall5303); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5305);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 35 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:922:7: ^( SHA256 expression )
					{
					match(input,SHA256,FOLLOW_SHA256_in_builtInCall5315); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5317);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 36 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:923:7: ^( SHA384 expression )
					{
					match(input,SHA384,FOLLOW_SHA384_in_builtInCall5327); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5329);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 37 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:924:7: ^( SHA512 expression )
					{
					match(input,SHA512,FOLLOW_SHA512_in_builtInCall5339); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5341);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 38 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:925:7: ^( COALESCE expressionList )
					{
					match(input,COALESCE,FOLLOW_COALESCE_in_builtInCall5351); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expressionList_in_builtInCall5353);
					expressionList();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 39 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:926:7: ^( IF expression expression expression )
					{
					match(input,IF,FOLLOW_IF_in_builtInCall5363); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5365);
					expression();
					state._fsp--;

					pushFollow(FOLLOW_expression_in_builtInCall5367);
					expression();
					state._fsp--;

					pushFollow(FOLLOW_expression_in_builtInCall5369);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 40 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:927:7: ^( STRLANG expression expression )
					{
					match(input,STRLANG,FOLLOW_STRLANG_in_builtInCall5379); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5381);
					expression();
					state._fsp--;

					pushFollow(FOLLOW_expression_in_builtInCall5383);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 41 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:928:7: ^( STRDT expression expression )
					{
					match(input,STRDT,FOLLOW_STRDT_in_builtInCall5393); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5395);
					expression();
					state._fsp--;

					pushFollow(FOLLOW_expression_in_builtInCall5397);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 42 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:929:7: ^( SAMETERM expression expression )
					{
					match(input,SAMETERM,FOLLOW_SAMETERM_in_builtInCall5407); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5409);
					expression();
					state._fsp--;

					pushFollow(FOLLOW_expression_in_builtInCall5411);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 43 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:930:7: ^( ISIRI expression )
					{
					match(input,ISIRI,FOLLOW_ISIRI_in_builtInCall5421); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5423);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 44 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:931:7: ^( ISURI expression )
					{
					match(input,ISURI,FOLLOW_ISURI_in_builtInCall5433); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5435);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 45 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:932:7: ^( ISBLANK expression )
					{
					match(input,ISBLANK,FOLLOW_ISBLANK_in_builtInCall5445); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5447);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 46 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:933:7: ^( ISLITERAL expression )
					{
					match(input,ISLITERAL,FOLLOW_ISLITERAL_in_builtInCall5457); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5459);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 47 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:934:7: ^( ISNUMERIC expression )
					{
					match(input,ISNUMERIC,FOLLOW_ISNUMERIC_in_builtInCall5469); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5471);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 48 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:935:7: regexExpression
					{
					pushFollow(FOLLOW_regexExpression_in_builtInCall5480);
					regexExpression();
					state._fsp--;

					}
					break;
				case 49 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:936:7: existsFunction
					{
					pushFollow(FOLLOW_existsFunction_in_builtInCall5488);
					existsFunction();
					state._fsp--;

					}
					break;
				case 50 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:937:7: notExistsFunction
					{
					pushFollow(FOLLOW_notExistsFunction_in_builtInCall5496);
					notExistsFunction();
					state._fsp--;

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "builtInCall"



	// $ANTLR start "regexExpression"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:940:1: regexExpression : ^( REGEX ( expression )+ ) ;
	public final void regexExpression() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:941:5: ( ^( REGEX ( expression )+ ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:941:7: ^( REGEX ( expression )+ )
			{
			match(input,REGEX,FOLLOW_REGEX_in_regexExpression5514); 
			match(input, Token.DOWN, null); 
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:941:15: ( expression )+
			int cnt143=0;
			loop143:
			while (true) {
				int alt143=2;
				int LA143_0 = input.LA(1);
				if ( (LA143_0==AND||LA143_0==ASTERISK||LA143_0==DIVIDE||LA143_0==EQUAL||(LA143_0 >= GREATER && LA143_0 <= GREATER_EQUAL)||LA143_0==IN||(LA143_0 >= LESS && LA143_0 <= LESS_EQUAL)||LA143_0==MINUS||(LA143_0 >= NOT && LA143_0 <= NOT_EQUAL)||LA143_0==OR||LA143_0==PLUS||(LA143_0 >= UNARY && LA143_0 <= UNARY_PLUS)) ) {
					alt143=1;
				}

				switch (alt143) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:941:15: expression
					{
					pushFollow(FOLLOW_expression_in_regexExpression5516);
					expression();
					state._fsp--;

					}
					break;

				default :
					if ( cnt143 >= 1 ) break loop143;
					EarlyExitException eee = new EarlyExitException(143, input);
					throw eee;
				}
				cnt143++;
			}

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "regexExpression"



	// $ANTLR start "subStringExpression"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:944:1: subStringExpression : ^( SUBSTR ( expression )+ ) ;
	public final void subStringExpression() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:945:5: ( ^( SUBSTR ( expression )+ ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:945:7: ^( SUBSTR ( expression )+ )
			{
			match(input,SUBSTR,FOLLOW_SUBSTR_in_subStringExpression5536); 
			match(input, Token.DOWN, null); 
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:945:16: ( expression )+
			int cnt144=0;
			loop144:
			while (true) {
				int alt144=2;
				int LA144_0 = input.LA(1);
				if ( (LA144_0==AND||LA144_0==ASTERISK||LA144_0==DIVIDE||LA144_0==EQUAL||(LA144_0 >= GREATER && LA144_0 <= GREATER_EQUAL)||LA144_0==IN||(LA144_0 >= LESS && LA144_0 <= LESS_EQUAL)||LA144_0==MINUS||(LA144_0 >= NOT && LA144_0 <= NOT_EQUAL)||LA144_0==OR||LA144_0==PLUS||(LA144_0 >= UNARY && LA144_0 <= UNARY_PLUS)) ) {
					alt144=1;
				}

				switch (alt144) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:945:16: expression
					{
					pushFollow(FOLLOW_expression_in_subStringExpression5538);
					expression();
					state._fsp--;

					}
					break;

				default :
					if ( cnt144 >= 1 ) break loop144;
					EarlyExitException eee = new EarlyExitException(144, input);
					throw eee;
				}
				cnt144++;
			}

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "subStringExpression"



	// $ANTLR start "existsFunction"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:948:1: existsFunction : ^( EXISTS groupGraphPattern ) ;
	public final void existsFunction() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:949:5: ( ^( EXISTS groupGraphPattern ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:949:7: ^( EXISTS groupGraphPattern )
			{
			match(input,EXISTS,FOLLOW_EXISTS_in_existsFunction5558); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_groupGraphPattern_in_existsFunction5560);
			groupGraphPattern();
			state._fsp--;

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "existsFunction"



	// $ANTLR start "notExistsFunction"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:952:1: notExistsFunction : ^( NOT_EXISTS groupGraphPattern ) ;
	public final void notExistsFunction() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:953:5: ( ^( NOT_EXISTS groupGraphPattern ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:953:7: ^( NOT_EXISTS groupGraphPattern )
			{
			match(input,NOT_EXISTS,FOLLOW_NOT_EXISTS_in_notExistsFunction5579); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_groupGraphPattern_in_notExistsFunction5581);
			groupGraphPattern();
			state._fsp--;

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "notExistsFunction"



	// $ANTLR start "aggregate"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:956:1: aggregate : ( ^( COUNT ( DISTINCT )* ( ASTERISK )* ( expression )* ) | ^( SUM ( DISTINCT )* expression ) | ^( MIN ( DISTINCT )* expression ) | ^( MAX ( DISTINCT )* expression ) | ^( AVG ( DISTINCT )* expression ) | ^( SAMPLE ( DISTINCT )? expression ) | ^( GROUP_CONCAT ( DISTINCT )* expression ( string )? ) );
	public final void aggregate() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:957:5: ( ^( COUNT ( DISTINCT )* ( ASTERISK )* ( expression )* ) | ^( SUM ( DISTINCT )* expression ) | ^( MIN ( DISTINCT )* expression ) | ^( MAX ( DISTINCT )* expression ) | ^( AVG ( DISTINCT )* expression ) | ^( SAMPLE ( DISTINCT )? expression ) | ^( GROUP_CONCAT ( DISTINCT )* expression ( string )? ) )
			int alt155=7;
			switch ( input.LA(1) ) {
			case COUNT:
				{
				alt155=1;
				}
				break;
			case SUM:
				{
				alt155=2;
				}
				break;
			case MIN:
				{
				alt155=3;
				}
				break;
			case MAX:
				{
				alt155=4;
				}
				break;
			case AVG:
				{
				alt155=5;
				}
				break;
			case SAMPLE:
				{
				alt155=6;
				}
				break;
			case GROUP_CONCAT:
				{
				alt155=7;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 155, 0, input);
				throw nvae;
			}
			switch (alt155) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:957:7: ^( COUNT ( DISTINCT )* ( ASTERISK )* ( expression )* )
					{
					match(input,COUNT,FOLLOW_COUNT_in_aggregate5600); 
					if ( input.LA(1)==Token.DOWN ) {
						match(input, Token.DOWN, null); 
						// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:957:15: ( DISTINCT )*
						loop145:
						while (true) {
							int alt145=2;
							int LA145_0 = input.LA(1);
							if ( (LA145_0==DISTINCT) ) {
								alt145=1;
							}

							switch (alt145) {
							case 1 :
								// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:957:15: DISTINCT
								{
								match(input,DISTINCT,FOLLOW_DISTINCT_in_aggregate5602); 
								}
								break;

							default :
								break loop145;
							}
						}

						// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:957:25: ( ASTERISK )*
						loop146:
						while (true) {
							int alt146=2;
							int LA146_0 = input.LA(1);
							if ( (LA146_0==ASTERISK) ) {
								int LA146_2 = input.LA(2);
								if ( (LA146_2==UP||LA146_2==AND||LA146_2==ASTERISK||LA146_2==DIVIDE||LA146_2==EQUAL||(LA146_2 >= GREATER && LA146_2 <= GREATER_EQUAL)||LA146_2==IN||(LA146_2 >= LESS && LA146_2 <= LESS_EQUAL)||LA146_2==MINUS||(LA146_2 >= NOT && LA146_2 <= NOT_EQUAL)||LA146_2==OR||LA146_2==PLUS||(LA146_2 >= UNARY && LA146_2 <= UNARY_PLUS)) ) {
									alt146=1;
								}

							}

							switch (alt146) {
							case 1 :
								// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:957:25: ASTERISK
								{
								match(input,ASTERISK,FOLLOW_ASTERISK_in_aggregate5605); 
								}
								break;

							default :
								break loop146;
							}
						}

						// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:957:35: ( expression )*
						loop147:
						while (true) {
							int alt147=2;
							int LA147_0 = input.LA(1);
							if ( (LA147_0==AND||LA147_0==ASTERISK||LA147_0==DIVIDE||LA147_0==EQUAL||(LA147_0 >= GREATER && LA147_0 <= GREATER_EQUAL)||LA147_0==IN||(LA147_0 >= LESS && LA147_0 <= LESS_EQUAL)||LA147_0==MINUS||(LA147_0 >= NOT && LA147_0 <= NOT_EQUAL)||LA147_0==OR||LA147_0==PLUS||(LA147_0 >= UNARY && LA147_0 <= UNARY_PLUS)) ) {
								alt147=1;
							}

							switch (alt147) {
							case 1 :
								// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:957:35: expression
								{
								pushFollow(FOLLOW_expression_in_aggregate5608);
								expression();
								state._fsp--;

								}
								break;

							default :
								break loop147;
							}
						}

						match(input, Token.UP, null); 
					}

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:958:7: ^( SUM ( DISTINCT )* expression )
					{
					match(input,SUM,FOLLOW_SUM_in_aggregate5619); 
					match(input, Token.DOWN, null); 
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:958:13: ( DISTINCT )*
					loop148:
					while (true) {
						int alt148=2;
						int LA148_0 = input.LA(1);
						if ( (LA148_0==DISTINCT) ) {
							alt148=1;
						}

						switch (alt148) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:958:13: DISTINCT
							{
							match(input,DISTINCT,FOLLOW_DISTINCT_in_aggregate5621); 
							}
							break;

						default :
							break loop148;
						}
					}

					pushFollow(FOLLOW_expression_in_aggregate5624);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:959:7: ^( MIN ( DISTINCT )* expression )
					{
					match(input,MIN,FOLLOW_MIN_in_aggregate5634); 
					match(input, Token.DOWN, null); 
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:959:13: ( DISTINCT )*
					loop149:
					while (true) {
						int alt149=2;
						int LA149_0 = input.LA(1);
						if ( (LA149_0==DISTINCT) ) {
							alt149=1;
						}

						switch (alt149) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:959:13: DISTINCT
							{
							match(input,DISTINCT,FOLLOW_DISTINCT_in_aggregate5636); 
							}
							break;

						default :
							break loop149;
						}
					}

					pushFollow(FOLLOW_expression_in_aggregate5639);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:960:7: ^( MAX ( DISTINCT )* expression )
					{
					match(input,MAX,FOLLOW_MAX_in_aggregate5649); 
					match(input, Token.DOWN, null); 
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:960:13: ( DISTINCT )*
					loop150:
					while (true) {
						int alt150=2;
						int LA150_0 = input.LA(1);
						if ( (LA150_0==DISTINCT) ) {
							alt150=1;
						}

						switch (alt150) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:960:13: DISTINCT
							{
							match(input,DISTINCT,FOLLOW_DISTINCT_in_aggregate5651); 
							}
							break;

						default :
							break loop150;
						}
					}

					pushFollow(FOLLOW_expression_in_aggregate5654);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 5 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:961:7: ^( AVG ( DISTINCT )* expression )
					{
					match(input,AVG,FOLLOW_AVG_in_aggregate5664); 
					match(input, Token.DOWN, null); 
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:961:13: ( DISTINCT )*
					loop151:
					while (true) {
						int alt151=2;
						int LA151_0 = input.LA(1);
						if ( (LA151_0==DISTINCT) ) {
							alt151=1;
						}

						switch (alt151) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:961:13: DISTINCT
							{
							match(input,DISTINCT,FOLLOW_DISTINCT_in_aggregate5666); 
							}
							break;

						default :
							break loop151;
						}
					}

					pushFollow(FOLLOW_expression_in_aggregate5669);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 6 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:962:7: ^( SAMPLE ( DISTINCT )? expression )
					{
					match(input,SAMPLE,FOLLOW_SAMPLE_in_aggregate5679); 
					match(input, Token.DOWN, null); 
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:962:16: ( DISTINCT )?
					int alt152=2;
					int LA152_0 = input.LA(1);
					if ( (LA152_0==DISTINCT) ) {
						alt152=1;
					}
					switch (alt152) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:962:16: DISTINCT
							{
							match(input,DISTINCT,FOLLOW_DISTINCT_in_aggregate5681); 
							}
							break;

					}

					pushFollow(FOLLOW_expression_in_aggregate5684);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 7 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:963:7: ^( GROUP_CONCAT ( DISTINCT )* expression ( string )? )
					{
					match(input,GROUP_CONCAT,FOLLOW_GROUP_CONCAT_in_aggregate5694); 
					match(input, Token.DOWN, null); 
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:963:22: ( DISTINCT )*
					loop153:
					while (true) {
						int alt153=2;
						int LA153_0 = input.LA(1);
						if ( (LA153_0==DISTINCT) ) {
							alt153=1;
						}

						switch (alt153) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:963:22: DISTINCT
							{
							match(input,DISTINCT,FOLLOW_DISTINCT_in_aggregate5696); 
							}
							break;

						default :
							break loop153;
						}
					}

					pushFollow(FOLLOW_expression_in_aggregate5699);
					expression();
					state._fsp--;

					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:963:43: ( string )?
					int alt154=2;
					int LA154_0 = input.LA(1);
					if ( ((LA154_0 >= STRING_LITERAL1 && LA154_0 <= STRING_LITERAL_LONG2)) ) {
						alt154=1;
					}
					switch (alt154) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:963:43: string
							{
							pushFollow(FOLLOW_string_in_aggregate5701);
							string();
							state._fsp--;

							}
							break;

					}

					match(input, Token.UP, null); 

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "aggregate"



	// $ANTLR start "iriRefOrFunction"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:966:1: iriRefOrFunction returns [Expr value] : (a= iriRef | ^( FUNCTION a= iriRef ^( ARG_LIST b= argList ) ) );
	public final Expr iriRefOrFunction() throws RecognitionException {
		Expr value = null;


		Node a =null;
		ExprList b =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:967:5: (a= iriRef | ^( FUNCTION a= iriRef ^( ARG_LIST b= argList ) ) )
			int alt156=2;
			int LA156_0 = input.LA(1);
			if ( (LA156_0==IRI_REF||(LA156_0 >= PNAME_LN && LA156_0 <= PNAME_NS)) ) {
				alt156=1;
			}
			else if ( (LA156_0==FUNCTION) ) {
				alt156=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 156, 0, input);
				throw nvae;
			}

			switch (alt156) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:967:7: a= iriRef
					{
					pushFollow(FOLLOW_iriRef_in_iriRefOrFunction5726);
					a=iriRef();
					state._fsp--;

					value = NodeValue.makeNode(a);
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:968:7: ^( FUNCTION a= iriRef ^( ARG_LIST b= argList ) )
					{
					match(input,FUNCTION,FOLLOW_FUNCTION_in_iriRefOrFunction5771); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_iriRef_in_iriRefOrFunction5775);
					a=iriRef();
					state._fsp--;

					match(input,ARG_LIST,FOLLOW_ARG_LIST_in_iriRefOrFunction5778); 
					if ( input.LA(1)==Token.DOWN ) {
						match(input, Token.DOWN, null); 
						pushFollow(FOLLOW_argList_in_iriRefOrFunction5782);
						b=argList();
						state._fsp--;

						match(input, Token.UP, null); 
					}

					match(input, Token.UP, null); 

					value = new E_Function(a.toString(), b);
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "iriRefOrFunction"



	// $ANTLR start "rdfLiteral"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:971:1: rdfLiteral returns [Node value] : ( ^( PLAIN_LITERAL a= string (b= LANGTAG )? ) | ^( TYPED_LITERAL a= string c= iriRef ) );
	public final Node rdfLiteral() throws RecognitionException {
		Node value = null;


		CommonTree b=null;
		String a =null;
		Node c =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:972:5: ( ^( PLAIN_LITERAL a= string (b= LANGTAG )? ) | ^( TYPED_LITERAL a= string c= iriRef ) )
			int alt158=2;
			int LA158_0 = input.LA(1);
			if ( (LA158_0==PLAIN_LITERAL) ) {
				alt158=1;
			}
			else if ( (LA158_0==TYPED_LITERAL) ) {
				alt158=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 158, 0, input);
				throw nvae;
			}

			switch (alt158) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:972:7: ^( PLAIN_LITERAL a= string (b= LANGTAG )? )
					{
					match(input,PLAIN_LITERAL,FOLLOW_PLAIN_LITERAL_in_rdfLiteral5808); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_string_in_rdfLiteral5812);
					a=string();
					state._fsp--;

					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:972:33: (b= LANGTAG )?
					int alt157=2;
					int LA157_0 = input.LA(1);
					if ( (LA157_0==LANGTAG) ) {
						alt157=1;
					}
					switch (alt157) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:972:33: b= LANGTAG
							{
							b=(CommonTree)match(input,LANGTAG,FOLLOW_LANGTAG_in_rdfLiteral5816); 
							}
							break;

					}

					match(input, Token.UP, null); 

					value = Node.createLiteral(a, (b!=null?b.getText():null), null);
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:973:7: ^( TYPED_LITERAL a= string c= iriRef )
					{
					match(input,TYPED_LITERAL,FOLLOW_TYPED_LITERAL_in_rdfLiteral5829); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_string_in_rdfLiteral5833);
					a=string();
					state._fsp--;

					pushFollow(FOLLOW_iriRef_in_rdfLiteral5837);
					c=iriRef();
					state._fsp--;

					match(input, Token.UP, null); 

					value = Node.createLiteral(a, null, TypeMapper.getInstance().getSafeTypeByName(c == null ? null : c.toString()));
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "rdfLiteral"



	// $ANTLR start "numericLiteral"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:978:1: numericLiteral returns [ NodeValue value ] : (a= numericLiteralUnsigned |a= numericLiteralPositive |a= numericLiteralNegative );
	public final NodeValue numericLiteral() throws RecognitionException {
		NodeValue value = null;


		NodeValue a =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:979:5: (a= numericLiteralUnsigned |a= numericLiteralPositive |a= numericLiteralNegative )
			int alt159=3;
			switch ( input.LA(1) ) {
			case DECIMAL:
			case DOUBLE:
			case INTEGER:
				{
				alt159=1;
				}
				break;
			case DECIMAL_POSITIVE:
			case DOUBLE_POSITIVE:
			case INTEGER_POSITIVE:
				{
				alt159=2;
				}
				break;
			case DECIMAL_NEGATIVE:
			case DOUBLE_NEGATIVE:
			case INTEGER_NEGATIVE:
				{
				alt159=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 159, 0, input);
				throw nvae;
			}
			switch (alt159) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:979:7: a= numericLiteralUnsigned
					{
					pushFollow(FOLLOW_numericLiteralUnsigned_in_numericLiteral5869);
					a=numericLiteralUnsigned();
					state._fsp--;

					 value = a; 
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:980:7: a= numericLiteralPositive
					{
					pushFollow(FOLLOW_numericLiteralPositive_in_numericLiteral5881);
					a=numericLiteralPositive();
					state._fsp--;

					 value = a; 
					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:981:7: a= numericLiteralNegative
					{
					pushFollow(FOLLOW_numericLiteralNegative_in_numericLiteral5893);
					a=numericLiteralNegative();
					state._fsp--;

					 value = a; 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "numericLiteral"



	// $ANTLR start "numericLiteralUnsigned"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:984:1: numericLiteralUnsigned returns [ NodeValue value ] : (a= INTEGER |a= DECIMAL |a= DOUBLE );
	public final NodeValue numericLiteralUnsigned() throws RecognitionException {
		NodeValue value = null;


		CommonTree a=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:985:5: (a= INTEGER |a= DECIMAL |a= DOUBLE )
			int alt160=3;
			switch ( input.LA(1) ) {
			case INTEGER:
				{
				alt160=1;
				}
				break;
			case DECIMAL:
				{
				alt160=2;
				}
				break;
			case DOUBLE:
				{
				alt160=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 160, 0, input);
				throw nvae;
			}
			switch (alt160) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:985:7: a= INTEGER
					{
					a=(CommonTree)match(input,INTEGER,FOLLOW_INTEGER_in_numericLiteralUnsigned5918); 
					 value =NodeValue.makeInteger((a!=null?a.getText():null)); 
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:986:7: a= DECIMAL
					{
					a=(CommonTree)match(input,DECIMAL,FOLLOW_DECIMAL_in_numericLiteralUnsigned5930); 
					 value =NodeValue.makeDecimal((a!=null?a.getText():null)); 
					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:987:7: a= DOUBLE
					{
					a=(CommonTree)match(input,DOUBLE,FOLLOW_DOUBLE_in_numericLiteralUnsigned5942); 
					 value =NodeValue.makeDouble(Double.parseDouble((a!=null?a.getText():null))); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "numericLiteralUnsigned"



	// $ANTLR start "numericLiteralPositive"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:990:1: numericLiteralPositive returns [ NodeValue value ] : (a= INTEGER_POSITIVE |a= DECIMAL_POSITIVE |a= DOUBLE_POSITIVE );
	public final NodeValue numericLiteralPositive() throws RecognitionException {
		NodeValue value = null;


		CommonTree a=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:991:5: (a= INTEGER_POSITIVE |a= DECIMAL_POSITIVE |a= DOUBLE_POSITIVE )
			int alt161=3;
			switch ( input.LA(1) ) {
			case INTEGER_POSITIVE:
				{
				alt161=1;
				}
				break;
			case DECIMAL_POSITIVE:
				{
				alt161=2;
				}
				break;
			case DOUBLE_POSITIVE:
				{
				alt161=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 161, 0, input);
				throw nvae;
			}
			switch (alt161) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:991:7: a= INTEGER_POSITIVE
					{
					a=(CommonTree)match(input,INTEGER_POSITIVE,FOLLOW_INTEGER_POSITIVE_in_numericLiteralPositive5968); 
					 value =NodeValue.makeInteger((a!=null?a.getText():null)); 
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:992:7: a= DECIMAL_POSITIVE
					{
					a=(CommonTree)match(input,DECIMAL_POSITIVE,FOLLOW_DECIMAL_POSITIVE_in_numericLiteralPositive5980); 
					 value =NodeValue.makeDecimal((a!=null?a.getText():null)); 
					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:993:7: a= DOUBLE_POSITIVE
					{
					a=(CommonTree)match(input,DOUBLE_POSITIVE,FOLLOW_DOUBLE_POSITIVE_in_numericLiteralPositive5992); 
					 value =NodeValue.makeDouble(Double.parseDouble((a!=null?a.getText():null))); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "numericLiteralPositive"



	// $ANTLR start "numericLiteralNegative"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:996:1: numericLiteralNegative returns [ NodeValue value ] : (a= INTEGER_NEGATIVE |a= DECIMAL_NEGATIVE |a= DOUBLE_NEGATIVE );
	public final NodeValue numericLiteralNegative() throws RecognitionException {
		NodeValue value = null;


		CommonTree a=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:997:5: (a= INTEGER_NEGATIVE |a= DECIMAL_NEGATIVE |a= DOUBLE_NEGATIVE )
			int alt162=3;
			switch ( input.LA(1) ) {
			case INTEGER_NEGATIVE:
				{
				alt162=1;
				}
				break;
			case DECIMAL_NEGATIVE:
				{
				alt162=2;
				}
				break;
			case DOUBLE_NEGATIVE:
				{
				alt162=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 162, 0, input);
				throw nvae;
			}
			switch (alt162) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:997:7: a= INTEGER_NEGATIVE
					{
					a=(CommonTree)match(input,INTEGER_NEGATIVE,FOLLOW_INTEGER_NEGATIVE_in_numericLiteralNegative6018); 
					 value =NodeValue.makeInteger((a!=null?a.getText():null)); 
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:998:7: a= DECIMAL_NEGATIVE
					{
					a=(CommonTree)match(input,DECIMAL_NEGATIVE,FOLLOW_DECIMAL_NEGATIVE_in_numericLiteralNegative6030); 
					 value =NodeValue.makeDecimal((a!=null?a.getText():null)); 
					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:999:7: a= DOUBLE_NEGATIVE
					{
					a=(CommonTree)match(input,DOUBLE_NEGATIVE,FOLLOW_DOUBLE_NEGATIVE_in_numericLiteralNegative6042); 
					 value =NodeValue.makeDouble(Double.parseDouble((a!=null?a.getText():null))); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "numericLiteralNegative"



	// $ANTLR start "booleanLiteral"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:1002:1: booleanLiteral returns [ NodeValue value ] : ( TRUE | FALSE );
	public final NodeValue booleanLiteral() throws RecognitionException {
		NodeValue value = null;


		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:1003:5: ( TRUE | FALSE )
			int alt163=2;
			int LA163_0 = input.LA(1);
			if ( (LA163_0==TRUE) ) {
				alt163=1;
			}
			else if ( (LA163_0==FALSE) ) {
				alt163=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 163, 0, input);
				throw nvae;
			}

			switch (alt163) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:1003:7: TRUE
					{
					match(input,TRUE,FOLLOW_TRUE_in_booleanLiteral6066); 
					 value = NodeValue.TRUE; 
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:1004:7: FALSE
					{
					match(input,FALSE,FOLLOW_FALSE_in_booleanLiteral6077); 
					 value = NodeValue.FALSE; 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "booleanLiteral"



	// $ANTLR start "string"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:1007:1: string returns [String value] : (a= STRING_LITERAL1 |a= STRING_LITERAL2 |a= STRING_LITERAL_LONG1 |a= STRING_LITERAL_LONG2 );
	public final String string() throws RecognitionException {
		String value = null;


		CommonTree a=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:1008:5: (a= STRING_LITERAL1 |a= STRING_LITERAL2 |a= STRING_LITERAL_LONG1 |a= STRING_LITERAL_LONG2 )
			int alt164=4;
			switch ( input.LA(1) ) {
			case STRING_LITERAL1:
				{
				alt164=1;
				}
				break;
			case STRING_LITERAL2:
				{
				alt164=2;
				}
				break;
			case STRING_LITERAL_LONG1:
				{
				alt164=3;
				}
				break;
			case STRING_LITERAL_LONG2:
				{
				alt164=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 164, 0, input);
				throw nvae;
			}
			switch (alt164) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:1008:7: a= STRING_LITERAL1
					{
					a=(CommonTree)match(input,STRING_LITERAL1,FOLLOW_STRING_LITERAL1_in_string6102); 
					value = (a!=null?a.getText():null);
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:1009:7: a= STRING_LITERAL2
					{
					a=(CommonTree)match(input,STRING_LITERAL2,FOLLOW_STRING_LITERAL2_in_string6119); 
					value = (a!=null?a.getText():null);
					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:1010:7: a= STRING_LITERAL_LONG1
					{
					a=(CommonTree)match(input,STRING_LITERAL_LONG1,FOLLOW_STRING_LITERAL_LONG1_in_string6136); 
					value = (a!=null?a.getText():null);
					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:1011:7: a= STRING_LITERAL_LONG2
					{
					a=(CommonTree)match(input,STRING_LITERAL_LONG2,FOLLOW_STRING_LITERAL_LONG2_in_string6148); 
					value = (a!=null?a.getText():null);
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "string"



	// $ANTLR start "iriRef"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:1014:1: iriRef returns [Node value] : (a= IRI_REF |b= prefixedName );
	public final Node iriRef() throws RecognitionException {
		Node value = null;


		CommonTree a=null;
		Node b =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:1015:5: (a= IRI_REF |b= prefixedName )
			int alt165=2;
			int LA165_0 = input.LA(1);
			if ( (LA165_0==IRI_REF) ) {
				alt165=1;
			}
			else if ( ((LA165_0 >= PNAME_LN && LA165_0 <= PNAME_NS)) ) {
				alt165=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 165, 0, input);
				throw nvae;
			}

			switch (alt165) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:1015:7: a= IRI_REF
					{
					a=(CommonTree)match(input,IRI_REF,FOLLOW_IRI_REF_in_iriRef6173); 
					value = Node.createURI((a!=null?a.getText():null));
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:1016:7: b= prefixedName
					{
					pushFollow(FOLLOW_prefixedName_in_iriRef6190);
					b=prefixedName();
					state._fsp--;

					value = b;
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "iriRef"



	// $ANTLR start "prefixedName"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:1019:1: prefixedName returns [Node value] : (a= PNAME_LN |a= PNAME_NS );
	public final Node prefixedName() throws RecognitionException {
		Node value = null;


		CommonTree a=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:1020:5: (a= PNAME_LN |a= PNAME_NS )
			int alt166=2;
			int LA166_0 = input.LA(1);
			if ( (LA166_0==PNAME_LN) ) {
				alt166=1;
			}
			else if ( (LA166_0==PNAME_NS) ) {
				alt166=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 166, 0, input);
				throw nvae;
			}

			switch (alt166) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:1020:7: a= PNAME_LN
					{
					a=(CommonTree)match(input,PNAME_LN,FOLLOW_PNAME_LN_in_prefixedName6215); 
					value = Node.createURI(expandUri((a!=null?a.getText():null)));
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:1021:7: a= PNAME_NS
					{
					a=(CommonTree)match(input,PNAME_NS,FOLLOW_PNAME_NS_in_prefixedName6228); 
					value = Node.createURI(expandPrefix((a!=null?a.getText():null)));
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "prefixedName"



	// $ANTLR start "blankNode"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:1024:1: blankNode returns [Node value] : (a= BLANK_NODE_LABEL | anon );
	public final Node blankNode() throws RecognitionException {
		Node value = null;


		CommonTree a=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:1025:5: (a= BLANK_NODE_LABEL | anon )
			int alt167=2;
			int LA167_0 = input.LA(1);
			if ( (LA167_0==BLANK_NODE_LABEL) ) {
				alt167=1;
			}
			else if ( (LA167_0==OPEN_SQUARE_BRACKET) ) {
				alt167=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 167, 0, input);
				throw nvae;
			}

			switch (alt167) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:1025:7: a= BLANK_NODE_LABEL
					{
					a=(CommonTree)match(input,BLANK_NODE_LABEL,FOLLOW_BLANK_NODE_LABEL_in_blankNode6254); 
					value = Node.createAnon(new AnonId((a!=null?a.getText():null)));
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:1026:7: anon
					{
					pushFollow(FOLLOW_anon_in_blankNode6264);
					anon();
					state._fsp--;

					value = Node.createAnon();
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "blankNode"



	// $ANTLR start "anon"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:1029:1: anon : OPEN_SQUARE_BRACKET CLOSE_SQUARE_BRACKET ;
	public final void anon() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:1030:5: ( OPEN_SQUARE_BRACKET CLOSE_SQUARE_BRACKET )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:1030:7: OPEN_SQUARE_BRACKET CLOSE_SQUARE_BRACKET
			{
			match(input,OPEN_SQUARE_BRACKET,FOLLOW_OPEN_SQUARE_BRACKET_in_anon6283); 
			match(input,CLOSE_SQUARE_BRACKET,FOLLOW_CLOSE_SQUARE_BRACKET_in_anon6285); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "anon"

	// Delegated rules


	protected DFA46 dfa46 = new DFA46(this);
	static final String DFA46_eotS =
		"\14\uffff";
	static final String DFA46_eofS =
		"\14\uffff";
	static final String DFA46_minS =
		"\1\47\1\2\1\3\1\uffff\1\2\1\uffff\2\147\4\3";
	static final String DFA46_maxS =
		"\1\47\1\2\1\u00f7\1\uffff\1\2\1\uffff\2\u009f\3\3\1\u00f7";
	static final String DFA46_acceptS =
		"\3\uffff\1\1\1\uffff\1\2\6\uffff";
	static final String DFA46_specialS =
		"\14\uffff}>";
	static final String[] DFA46_transitionS = {
			"\1\1",
			"\1\2",
			"\1\3\45\uffff\1\3\43\uffff\1\4\12\uffff\1\3\2\uffff\1\3\32\uffff\1\3"+
			"\26\uffff\1\3\6\uffff\1\3\141\uffff\1\5\1\3",
			"",
			"\1\6",
			"",
			"\1\10\33\uffff\1\7\32\uffff\1\11\1\12",
			"\1\10\66\uffff\1\11\1\12",
			"\1\13",
			"\1\13",
			"\1\13",
			"\1\3\111\uffff\1\4\12\uffff\1\3\2\uffff\1\3\32\uffff\1\3\26\uffff\1"+
			"\3\6\uffff\1\3\141\uffff\1\5\1\3"
	};

	static final short[] DFA46_eot = DFA.unpackEncodedString(DFA46_eotS);
	static final short[] DFA46_eof = DFA.unpackEncodedString(DFA46_eofS);
	static final char[] DFA46_min = DFA.unpackEncodedStringToUnsignedChars(DFA46_minS);
	static final char[] DFA46_max = DFA.unpackEncodedStringToUnsignedChars(DFA46_maxS);
	static final short[] DFA46_accept = DFA.unpackEncodedString(DFA46_acceptS);
	static final short[] DFA46_special = DFA.unpackEncodedString(DFA46_specialS);
	static final short[][] DFA46_transition;

	static {
		int numStates = DFA46_transitionS.length;
		DFA46_transition = new short[numStates][];
		for (int i=0; i<numStates; i++) {
			DFA46_transition[i] = DFA.unpackEncodedString(DFA46_transitionS[i]);
		}
	}

	protected class DFA46 extends DFA {

		public DFA46(BaseRecognizer recognizer) {
			this.recognizer = recognizer;
			this.decisionNumber = 46;
			this.eot = DFA46_eot;
			this.eof = DFA46_eof;
			this.min = DFA46_min;
			this.max = DFA46_max;
			this.accept = DFA46_accept;
			this.special = DFA46_special;
			this.transition = DFA46_transition;
		}
		@Override
		public String getDescription() {
			return "443:1: constructQuery : ( ^( CONSTRUCT ( constructTemplate )* ( datasetClause )* ( whereClause )* solutionModifier ) | ^( CONSTRUCT ( datasetClause )* ^( WHERE ( triplesTemplate )* ) solutionModifier ) );";
		}
	}

	public static final BitSet FOLLOW_templateConfigItem_in_templateConfig66 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x1000004000000010L});
	public static final BitSet FOLLOW_namedViewTemplateDefinition_in_templateConfigItem88 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_prefixDecl_in_templateConfigItem100 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_setStmt_in_templateConfigItem112 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SET_in_setStmt136 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_NAME_in_setStmt140 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x000000000000F000L});
	public static final BitSet FOLLOW_string_in_setStmt144 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_constructConfigItem_in_constructConfig176 = new BitSet(new long[]{0x0000040000000002L,0x0000000000000000L,0x1000004000000000L});
	public static final BitSet FOLLOW_constructViewDefinition_in_constructConfigItem198 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_prefixDecl_in_constructConfigItem211 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_setStmt_in_constructConfigItem223 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CONSTRUCT_VIEW_DEFINITION_in_constructViewDefinition248 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_NAME_in_constructViewDefinition252 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000000020L});
	public static final BitSet FOLLOW_SQL_QUERY_in_constructViewDefinition256 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_sparqlifyConfigItem_in_sparqlifyConfig291 = new BitSet(new long[]{0x0000000000000002L,0x0000000000010000L,0x1000004000000000L,0x0010000000000000L});
	public static final BitSet FOLLOW_viewDefinition_in_sparqlifyConfigItem313 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_prefixDecl_in_sparqlifyConfigItem330 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_functionDeclaration_in_sparqlifyConfigItem351 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_setStmt_in_sparqlifyConfigItem363 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_FUNCTION_DECLARATION_in_functionDeclaration389 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_functionSignature_in_functionDeclaration393 = new BitSet(new long[]{0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_functionTemplate_in_functionDeclaration397 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_FUNCTION_SIGNATURE_in_functionSignature422 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_NAME_in_functionSignature426 = new BitSet(new long[]{0x0000000000000000L,0x0000008000000000L,0x00000000C0000000L});
	public static final BitSet FOLLOW_iriRef_in_functionSignature430 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000800000L});
	public static final BitSet FOLLOW_paramTypeList_in_functionSignature434 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_PARAM_TYPE_LIST_in_paramTypeList468 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_paramType_in_paramTypeList473 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0000000000400000L});
	public static final BitSet FOLLOW_PARAM_TYPE_LIST_in_paramTypeList487 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_nil_in_paramTypeList489 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_PARAM_TYPE_in_paramType513 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_NAME_in_paramType517 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_var_in_paramType521 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_FUNCTION_TEMPLATE_in_functionTemplate547 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_NAME_in_functionTemplate551 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000200L});
	public static final BitSet FOLLOW_expressionList_in_functionTemplate555 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_NAMED_VIEW_TEMPLATE_DEFINITION_in_namedViewTemplateDefinition583 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_NAME_in_namedViewTemplateDefinition587 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0020000000000000L});
	public static final BitSet FOLLOW_viewTemplateDefinition_in_namedViewTemplateDefinition591 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_VIEW_TEMPLATE_DEFINITION_in_viewTemplateDefinition616 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_constructTemplateQuads_in_viewTemplateDefinition620 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0000000000000000L,0x0002000000000000L});
	public static final BitSet FOLLOW_varBindings_in_viewTemplateDefinition624 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_VIEW_DEFINITION_in_viewDefinition650 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_NAME_in_viewDefinition654 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0020000000000000L});
	public static final BitSet FOLLOW_viewTemplateDefinition_in_viewDefinition658 = new BitSet(new long[]{0x0000004000000008L,0x0000000000000000L,0x0004000000000000L});
	public static final BitSet FOLLOW_varConstraints_in_viewDefinition662 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0004000000000000L});
	public static final BitSet FOLLOW_sqlRelation_in_viewDefinition667 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_VAR_BINDINGS_in_varBindings702 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_varBinding_in_varBindings707 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0000000000000000L,0x0001000000000000L});
	public static final BitSet FOLLOW_VAR_BINDING_in_varBinding735 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_var_in_varBinding739 = new BitSet(new long[]{0x0000000001000000L,0x0000000000000000L,0x0000000010000000L,0x0000020080000000L});
	public static final BitSet FOLLOW_typeCtorExpression_in_varBinding743 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_BNODE_in_typeCtorExpression768 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_typeCtorExpression772 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_URI_in_typeCtorExpression784 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expressionList_in_typeCtorExpression788 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_PLAIN_LITERAL_in_typeCtorExpression800 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_typeCtorExpression804 = new BitSet(new long[]{0x2000000000010408L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_expression_in_typeCtorExpression808 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_TYPED_LITERAL_in_typeCtorExpression821 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_typeCtorExpression825 = new BitSet(new long[]{0x2000000000010408L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_expression_in_typeCtorExpression829 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_SQL_RELATION_in_sqlRelationOld855 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_SQL_QUERY_in_sqlRelationOld859 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_SQL_RELATION_in_sqlRelationOld871 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_SQL_TABLE_in_sqlRelationOld875 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_RELATION_REF_in_sqlRelation902 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_joinClause_in_sqlRelation906 = new BitSet(new long[]{0x2000000000010408L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_expression_in_sqlRelation910 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_joinClauseMember_in_joinClause937 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_FULL_JOIN_in_joinClause948 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_joinClauseMember_in_joinClause952 = new BitSet(new long[]{0x0000000000000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_joinClauseMember_in_joinClause956 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_JOIN_MEMBER_in_joinClauseMember981 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_sqlLogicalTable_in_joinClauseMember985 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_NAME_in_joinClauseMember989 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_SQL_RELATION_in_sqlLogicalTable1015 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_SQL_QUERY_in_sqlLogicalTable1019 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_SQL_RELATION_in_sqlLogicalTable1031 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_SQL_TABLE_in_sqlLogicalTable1035 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_CONSTRAINTS_in_varConstraints1070 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_varConstraint_in_varConstraints1075 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0002008000000000L});
	public static final BitSet FOLLOW_regexVarConstraint_in_varConstraint1103 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_prefixVarConstraint_in_varConstraint1117 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_REGEX_CONSTRAINT_in_regexVarConstraint1142 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_var_in_regexVarConstraint1146 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x000000000000F000L});
	public static final BitSet FOLLOW_string_in_regexVarConstraint1150 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_PREFIX_CONSTRAINT_in_prefixVarConstraint1175 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_var_in_prefixVarConstraint1179 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_stringList_in_prefixVarConstraint1183 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_STRING_LIST_in_stringList1217 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_string_in_stringList1222 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0000000000000000L,0x000000000000F000L});
	public static final BitSet FOLLOW_QUERY_in_query1246 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_prologue_in_query1248 = new BitSet(new long[]{0x0400008000008008L,0x0000000000000000L,0x0080000000000000L});
	public static final BitSet FOLLOW_selectQuery_in_query1250 = new BitSet(new long[]{0x0400008000008008L,0x0000000000000000L,0x0080000000000000L});
	public static final BitSet FOLLOW_constructQuery_in_query1253 = new BitSet(new long[]{0x0400008000008008L});
	public static final BitSet FOLLOW_describeQuery_in_query1256 = new BitSet(new long[]{0x0400000000008008L});
	public static final BitSet FOLLOW_askQuery_in_query1259 = new BitSet(new long[]{0x0000000000008008L});
	public static final BitSet FOLLOW_bindingsClause_in_query1263 = new BitSet(new long[]{0x0000000000100002L});
	public static final BitSet FOLLOW_UPDATE_in_query1273 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_update_in_query1275 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0000020000000000L});
	public static final BitSet FOLLOW_PROLOGUE_in_prologue1295 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_baseDecl_in_prologue1297 = new BitSet(new long[]{0x0000000000040008L,0x0000000000000000L,0x0000004000000000L});
	public static final BitSet FOLLOW_prefixDecl_in_prologue1300 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0000004000000000L});
	public static final BitSet FOLLOW_BASE_in_baseDecl1320 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_IRI_REF_in_baseDecl1322 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_PREFIX_in_prefixDecl1345 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_PNAME_NS_in_prefixDecl1349 = new BitSet(new long[]{0x0000000000000000L,0x0000008000000000L});
	public static final BitSet FOLLOW_IRI_REF_in_prefixDecl1353 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_SELECT_in_selectQuery1374 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_selectClause_in_selectQuery1376 = new BitSet(new long[]{0x0000000000000008L,0x0040000009002000L,0x0000000000102000L,0x0080000000000000L});
	public static final BitSet FOLLOW_datasetClause_in_selectQuery1378 = new BitSet(new long[]{0x0000000000000008L,0x0040000009002000L,0x0000000000102000L,0x0080000000000000L});
	public static final BitSet FOLLOW_whereClause_in_selectQuery1381 = new BitSet(new long[]{0x0000000000000008L,0x0040000009000000L,0x0000000000102000L,0x0080000000000000L});
	public static final BitSet FOLLOW_solutionModifier_in_selectQuery1384 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_SUBSELECT_in_subSelect1403 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_whereClause_in_subSelect1405 = new BitSet(new long[]{0x0000000000000008L,0x0040000009000000L,0x0000000000102000L,0x0080000000000000L});
	public static final BitSet FOLLOW_solutionModifier_in_subSelect1408 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_SELECT_CLAUSE_in_selectClause1427 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_ASTERISK_in_selectClause1429 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_SELECT_CLAUSE_in_selectClause1439 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_DISTINCT_in_selectClause1441 = new BitSet(new long[]{0x0000000000010000L});
	public static final BitSet FOLLOW_ASTERISK_in_selectClause1443 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_SELECT_CLAUSE_in_selectClause1453 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_REDUCED_in_selectClause1455 = new BitSet(new long[]{0x0000000000010000L});
	public static final BitSet FOLLOW_ASTERISK_in_selectClause1457 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_SELECT_CLAUSE_in_selectClause1467 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_selectVariables_in_selectClause1469 = new BitSet(new long[]{0x0000000000002008L,0x0000000000000000L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_SELECT_CLAUSE_in_selectClause1480 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_DISTINCT_in_selectClause1482 = new BitSet(new long[]{0x0000000000002008L,0x0000000000000000L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_selectVariables_in_selectClause1484 = new BitSet(new long[]{0x0000000000002008L,0x0000000000000000L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_SELECT_CLAUSE_in_selectClause1495 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_REDUCED_in_selectClause1497 = new BitSet(new long[]{0x0000000000002008L,0x0000000000000000L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_selectVariables_in_selectClause1499 = new BitSet(new long[]{0x0000000000002008L,0x0000000000000000L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_VAR_in_selectVariables1519 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_var_in_selectVariables1521 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_AS_in_selectVariables1531 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_selectVariables1533 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_var_in_selectVariables1535 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_CONSTRUCT_in_constructQuery1554 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_constructTemplate_in_constructQuery1556 = new BitSet(new long[]{0x0000020000000008L,0x0040000009002000L,0x0000000000102000L,0x0080000000000000L});
	public static final BitSet FOLLOW_datasetClause_in_constructQuery1559 = new BitSet(new long[]{0x0000000000000008L,0x0040000009002000L,0x0000000000102000L,0x0080000000000000L});
	public static final BitSet FOLLOW_whereClause_in_constructQuery1562 = new BitSet(new long[]{0x0000000000000008L,0x0040000009000000L,0x0000000000102000L,0x0080000000000000L});
	public static final BitSet FOLLOW_solutionModifier_in_constructQuery1565 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_CONSTRUCT_in_constructQuery1575 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_datasetClause_in_constructQuery1577 = new BitSet(new long[]{0x0000000000000000L,0x0000000000002000L,0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_WHERE_in_constructQuery1581 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_triplesTemplate_in_constructQuery1583 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0000000000000000L,0x0000000020000000L});
	public static final BitSet FOLLOW_solutionModifier_in_constructQuery1587 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_DESCRIBE_in_describeQuery1606 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_varOrIRIref_in_describeQuery1608 = new BitSet(new long[]{0x0000000000010008L,0x0040008009002000L,0x00000000C0102000L,0x0080080000000000L});
	public static final BitSet FOLLOW_ASTERISK_in_describeQuery1611 = new BitSet(new long[]{0x0000000000010008L,0x0040000009002000L,0x0000000000102000L,0x0080000000000000L});
	public static final BitSet FOLLOW_datasetClause_in_describeQuery1614 = new BitSet(new long[]{0x0000000000000008L,0x0040000009002000L,0x0000000000102000L,0x0080000000000000L});
	public static final BitSet FOLLOW_whereClause_in_describeQuery1617 = new BitSet(new long[]{0x0000000000000008L,0x0040000009000000L,0x0000000000102000L});
	public static final BitSet FOLLOW_solutionModifier_in_describeQuery1620 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_ASK_in_askQuery1639 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_datasetClause_in_askQuery1641 = new BitSet(new long[]{0x0000000000000000L,0x0000000000002000L,0x0000000000000000L,0x0080000000000000L});
	public static final BitSet FOLLOW_whereClause_in_askQuery1644 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_FROM_in_datasetClause1663 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_NAMED_in_datasetClause1665 = new BitSet(new long[]{0x0000000000000000L,0x0000008000000000L,0x00000000C0000000L});
	public static final BitSet FOLLOW_iriRef_in_datasetClause1668 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_WHERE_CLAUSE_in_whereClause1687 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_groupGraphPattern_in_whereClause1689 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_groupClause_in_solutionModifier1707 = new BitSet(new long[]{0x0000000000000002L,0x0040000008000000L,0x0000000000102000L});
	public static final BitSet FOLLOW_havingClause_in_solutionModifier1710 = new BitSet(new long[]{0x0000000000000002L,0x0040000000000000L,0x0000000000102000L});
	public static final BitSet FOLLOW_orderClause_in_solutionModifier1713 = new BitSet(new long[]{0x0000000000000002L,0x0040000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_limitOffsetClauses_in_solutionModifier1716 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_GROUP_BY_in_groupClause1735 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_groupCondition_in_groupClause1737 = new BitSet(new long[]{0x000308110B002028L,0x4409BE4030009090L,0xE059200000000C01L,0x04000A0301270703L});
	public static final BitSet FOLLOW_builtInCall_in_groupCondition1756 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_functionCall_in_groupCondition1764 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_AS_in_groupCondition1773 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_groupCondition1775 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_var_in_groupCondition1777 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_var_in_groupCondition1787 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_HAVING_in_havingClause1805 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_constraint_in_havingClause1807 = new BitSet(new long[]{0x200308110B010428L,0x5439BE40B06090D0L,0xE059200020040F01L,0x0400023F01270703L});
	public static final BitSet FOLLOW_ORDER_BY_in_orderClause1827 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_orderCondition_in_orderClause1829 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_ORDER_CONDITION_in_orderCondition1849 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_ASC_in_orderCondition1851 = new BitSet(new long[]{0x2000000000010400L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_expression_in_orderCondition1853 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_ORDER_CONDITION_in_orderCondition1863 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_DESC_in_orderCondition1865 = new BitSet(new long[]{0x2000000000010400L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_expression_in_orderCondition1867 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_ORDER_CONDITION_in_orderCondition1877 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_constraint_in_orderCondition1879 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_ORDER_CONDITION_in_orderCondition1889 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_var_in_orderCondition1891 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_LIMIT_in_limitOffsetClauses1910 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_INTEGER_in_limitOffsetClauses1912 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_OFFSET_in_limitOffsetClauses1917 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_INTEGER_in_limitOffsetClauses1919 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_OFFSET_in_limitOffsetClauses1931 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_INTEGER_in_limitOffsetClauses1933 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_LIMIT_in_limitOffsetClauses1938 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_INTEGER_in_limitOffsetClauses1940 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_BINDINGS_in_bindingsClause1962 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_var_in_bindingsClause1964 = new BitSet(new long[]{0x0000000000200008L,0x0000000000000000L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_bindingValueList_in_bindingsClause1967 = new BitSet(new long[]{0x0000000000200008L});
	public static final BitSet FOLLOW_BINDING_VALUE_in_bindingValueList1987 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_bindingValue_in_bindingValueList1989 = new BitSet(new long[]{0x801C000000000008L,0x0000008E00000403L,0x00000000D0000000L,0x00000040C0000000L});
	public static final BitSet FOLLOW_iriRef_in_bindingValue2014 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_rdfLiteral_in_bindingValue2026 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_numericLiteral_in_bindingValue2036 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_booleanLiteral_in_bindingValue2044 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_UNDEF_in_bindingValue2052 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_prologue_in_update2069 = new BitSet(new long[]{0x0100500010000042L,0x8080000100000004L,0x0000000000000002L});
	public static final BitSet FOLLOW_load_in_update2071 = new BitSet(new long[]{0x0100500010000042L,0x8080000100000004L,0x0000000000000002L});
	public static final BitSet FOLLOW_clear_in_update2074 = new BitSet(new long[]{0x0100500010000042L,0x8000000100000004L,0x0000000000000002L});
	public static final BitSet FOLLOW_drop_in_update2077 = new BitSet(new long[]{0x0100500000000042L,0x8000000100000004L,0x0000000000000002L});
	public static final BitSet FOLLOW_add_in_update2080 = new BitSet(new long[]{0x0100500000000042L,0x8000000100000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_move_in_update2083 = new BitSet(new long[]{0x0100500000000002L,0x8000000100000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_copy_in_update2086 = new BitSet(new long[]{0x0100500000000002L,0x8000000100000000L});
	public static final BitSet FOLLOW_create_in_update2089 = new BitSet(new long[]{0x0100400000000002L,0x8000000100000000L});
	public static final BitSet FOLLOW_insert_in_update2092 = new BitSet(new long[]{0x0100000000000002L,0x8000000100000000L});
	public static final BitSet FOLLOW_delete_in_update2095 = new BitSet(new long[]{0x0100000000000002L,0x8000000000000000L});
	public static final BitSet FOLLOW_modify_in_update2098 = new BitSet(new long[]{0x0000000000000002L,0x8000000000000000L});
	public static final BitSet FOLLOW_LOAD_in_load2117 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_SILENT_in_load2119 = new BitSet(new long[]{0x0000000000000000L,0x0000008000000000L,0x00000000C0000000L,0x0000000000000008L});
	public static final BitSet FOLLOW_iriRef_in_load2122 = new BitSet(new long[]{0x0000000000000008L,0x0000000000080000L});
	public static final BitSet FOLLOW_graphRef_in_load2124 = new BitSet(new long[]{0x0000000000000008L,0x0000000000080000L});
	public static final BitSet FOLLOW_CLEAR_in_clear2144 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_SILENT_in_clear2146 = new BitSet(new long[]{0x0040000000000200L,0x0000000000080000L,0x0000000000000008L,0x0000000000000008L});
	public static final BitSet FOLLOW_graphRefAll_in_clear2149 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_DROP_in_drop2168 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_SILENT_in_drop2170 = new BitSet(new long[]{0x0040000000000200L,0x0000000000080000L,0x0000000000000008L,0x0000000000000008L});
	public static final BitSet FOLLOW_graphRefAll_in_drop2173 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_CREATE_in_create2192 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_SILENT_in_create2194 = new BitSet(new long[]{0x0000000000000000L,0x0000000000080000L,0x0000000000000000L,0x0000000000000008L});
	public static final BitSet FOLLOW_graphRef_in_create2197 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_ADD_in_add2216 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_SILENT_in_add2218 = new BitSet(new long[]{0x0040000000000000L,0x0000008000080000L,0x00000000C0000000L,0x0000000000000008L});
	public static final BitSet FOLLOW_graphOrDefault_in_add2221 = new BitSet(new long[]{0x0040000000000000L,0x0000008000080000L,0x00000000C0000000L});
	public static final BitSet FOLLOW_graphOrDefault_in_add2223 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_MOVE_in_move2242 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_SILENT_in_move2244 = new BitSet(new long[]{0x0040000000000000L,0x0000008000080000L,0x00000000C0000000L,0x0000000000000008L});
	public static final BitSet FOLLOW_graphOrDefault_in_move2247 = new BitSet(new long[]{0x0040000000000000L,0x0000008000080000L,0x00000000C0000000L});
	public static final BitSet FOLLOW_graphOrDefault_in_move2249 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_COPY_in_copy2268 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_SILENT_in_copy2270 = new BitSet(new long[]{0x0040000000000000L,0x0000008000080000L,0x00000000C0000000L,0x0000000000000008L});
	public static final BitSet FOLLOW_graphOrDefault_in_copy2273 = new BitSet(new long[]{0x0040000000000000L,0x0000008000080000L,0x00000000C0000000L});
	public static final BitSet FOLLOW_graphOrDefault_in_copy2275 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_INSERT_in_insert2294 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_DATA_in_insert2296 = new BitSet(new long[]{0x0000000000000000L,0x0000000000100000L,0x0000000000000000L,0x0000000020000000L});
	public static final BitSet FOLLOW_quadPattern_in_insert2298 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_DELETE_in_delete2316 = new BitSet(new long[]{0x0100000000000000L});
	public static final BitSet FOLLOW_deleteData_in_delete2320 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_deleteWhere_in_delete2324 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DELETE_in_deleteData2344 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_DATA_in_deleteData2346 = new BitSet(new long[]{0x0000000000000000L,0x0000000000100000L,0x0000000000000000L,0x0000000020000000L});
	public static final BitSet FOLLOW_quadPattern_in_deleteData2348 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_DELETE_in_deleteWhere2367 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_WHERE_in_deleteWhere2369 = new BitSet(new long[]{0x0000000000000000L,0x0000000000100000L,0x0000000000000000L,0x0000000020000000L});
	public static final BitSet FOLLOW_quadPattern_in_deleteWhere2371 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_MODIFY_in_modify2390 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_WITH_in_modify2393 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_iriRef_in_modify2395 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_deleteClause_in_modify2398 = new BitSet(new long[]{0x0100000000000000L,0x0000000100000000L,0x0000000000000000L,0x0040040000000000L});
	public static final BitSet FOLLOW_insertClause_in_modify2401 = new BitSet(new long[]{0x0000000000000000L,0x0000000100000000L,0x0000000000000000L,0x0040040000000000L});
	public static final BitSet FOLLOW_usingClause_in_modify2404 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0040040000000000L});
	public static final BitSet FOLLOW_WHERE_in_modify2408 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_groupGraphPattern_in_modify2410 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_MODIFY_in_modify2421 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_deleteClause_in_modify2423 = new BitSet(new long[]{0x0100000000000000L,0x0000000100000000L,0x0000000000000000L,0x0040040000000000L});
	public static final BitSet FOLLOW_insertClause_in_modify2426 = new BitSet(new long[]{0x0000000000000000L,0x0000000100000000L,0x0000000000000000L,0x0040040000000000L});
	public static final BitSet FOLLOW_usingClause_in_modify2429 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0040040000000000L});
	public static final BitSet FOLLOW_WHERE_in_modify2433 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_groupGraphPattern_in_modify2435 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_DELETE_in_deleteClause2454 = new BitSet(new long[]{0x0000000000000000L,0x0000000000100000L,0x0000000000000000L,0x0000000020000000L});
	public static final BitSet FOLLOW_quadPattern_in_deleteClause2456 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_INSERT_in_insertClause2473 = new BitSet(new long[]{0x0000000000000000L,0x0000000000100000L,0x0000000000000000L,0x0000000020000000L});
	public static final BitSet FOLLOW_quadPattern_in_insertClause2475 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_USING_in_usingClause2493 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_NAMED_in_usingClause2495 = new BitSet(new long[]{0x0000000000000000L,0x0000008000000000L,0x00000000C0000000L});
	public static final BitSet FOLLOW_iriRef_in_usingClause2498 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_DEFAULT_in_graphOrDefault2516 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_GRAPH_in_graphOrDefault2524 = new BitSet(new long[]{0x0000000000000000L,0x0000008000000000L,0x00000000C0000000L});
	public static final BitSet FOLLOW_iriRef_in_graphOrDefault2527 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_GRAPH_in_graphRef2544 = new BitSet(new long[]{0x0000000000000000L,0x0000008000000000L,0x00000000C0000000L});
	public static final BitSet FOLLOW_iriRef_in_graphRef2546 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_graphRef_in_graphRefAll2563 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DEFAULT_in_graphRefAll2567 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NAMED_in_graphRefAll2571 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ALL_in_graphRefAll2575 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_quads_in_quadPattern2598 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_triplesTemplate_in_quads2631 = new BitSet(new long[]{0x0000000000000002L,0x0000000000100000L});
	public static final BitSet FOLLOW_quadsNotTriples_in_quads2639 = new BitSet(new long[]{0x0000000000000002L,0x0000000000100000L,0x0000000000000000L,0x0000000020000000L});
	public static final BitSet FOLLOW_triplesTemplate_in_quads2645 = new BitSet(new long[]{0x0000000000000002L,0x0000000000100000L});
	public static final BitSet FOLLOW_GRAPH_TOKEN_in_quadsNotTriples2678 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_varOrIRIref_in_quadsNotTriples2682 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0000000000000000L,0x0000000020000000L});
	public static final BitSet FOLLOW_triplesTemplate_in_quadsNotTriples2686 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_TRIPLES_TEMPLATE_in_triplesTemplate2715 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_triples_in_triplesTemplate2719 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_GROUP_GRAPH_PATTERN_in_groupGraphPattern2740 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_subSelect_in_groupGraphPattern2742 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_GROUP_GRAPH_PATTERN_in_groupGraphPattern2752 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_groupGraphPatternSub_in_groupGraphPattern2754 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_triplesBlock_in_groupGraphPatternSub2772 = new BitSet(new long[]{0x0000000000080002L,0x2000000004080800L,0x0800000000020000L,0x0000008000000000L});
	public static final BitSet FOLLOW_groupGraphPatternSubCache_in_groupGraphPatternSub2775 = new BitSet(new long[]{0x0000000000080002L,0x2000000004080800L,0x0800000000020000L,0x0000008000000000L});
	public static final BitSet FOLLOW_graphPatternNotTriples_in_groupGraphPatternSubCache2794 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000000L,0x0000000010000000L});
	public static final BitSet FOLLOW_triplesBlock_in_groupGraphPatternSubCache2796 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_TRIPLES_BLOCK_in_triplesBlock2815 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_triplesSameSubjectPath_in_triplesBlock2817 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_groupOrUnionGraphPattern_in_graphPatternNotTriples2837 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_optionalGraphPattern_in_graphPatternNotTriples2841 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_minusGraphPattern_in_graphPatternNotTriples2845 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_graphGraphPattern_in_graphPatternNotTriples2849 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_serviceGraphPattern_in_graphPatternNotTriples2853 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_filter_in_graphPatternNotTriples2857 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_bind_in_graphPatternNotTriples2861 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OPTIONAL_in_optionalGraphPattern2879 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_groupGraphPattern_in_optionalGraphPattern2881 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_GRAPH_in_graphGraphPattern2900 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_varOrIRIref_in_graphGraphPattern2902 = new BitSet(new long[]{0x0000000000000000L,0x0000000004000000L});
	public static final BitSet FOLLOW_groupGraphPattern_in_graphGraphPattern2904 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_SERVICE_in_serviceGraphPattern2923 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_SILENT_in_serviceGraphPattern2925 = new BitSet(new long[]{0x0000000000000000L,0x0000008000000000L,0x00000000C0000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_varOrIRIref_in_serviceGraphPattern2928 = new BitSet(new long[]{0x0000000000000000L,0x0000000004000000L});
	public static final BitSet FOLLOW_groupGraphPattern_in_serviceGraphPattern2930 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_BIND_in_bind2949 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_bind2951 = new BitSet(new long[]{0x0000000000002000L});
	public static final BitSet FOLLOW_AS_in_bind2954 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_var_in_bind2956 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_MINUS_KEYWORD_in_minusGraphPattern2976 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_groupGraphPattern_in_minusGraphPattern2978 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_UNION_in_groupOrUnionGraphPattern2997 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_groupGraphPattern_in_groupOrUnionGraphPattern2999 = new BitSet(new long[]{0x0000000000000000L,0x0000000004000000L});
	public static final BitSet FOLLOW_groupGraphPattern_in_groupOrUnionGraphPattern3001 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_groupGraphPattern_in_groupOrUnionGraphPattern3010 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_FILTER_in_filter3028 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_constraint_in_filter3030 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_expression_in_constraint3048 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_builtInCall_in_constraint3056 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_functionCall_in_constraint3064 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_FUNCTION_in_functionCall3086 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_iriRef_in_functionCall3090 = new BitSet(new long[]{0x0000000000001000L});
	public static final BitSet FOLLOW_ARG_LIST_in_functionCall3093 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_argList_in_functionCall3097 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_nil_in_argList3132 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DISTINCT_in_argList3140 = new BitSet(new long[]{0x2000000000010402L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_expression_in_argList3146 = new BitSet(new long[]{0x2000000000010402L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_EXPRESSION_LIST_in_expressionList3181 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_expressionList3186 = new BitSet(new long[]{0x2000000000010408L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_EXPRESSION_LIST_in_expressionList3200 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_nil_in_expressionList3202 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_CONSTRUCT_QUADS_in_constructTemplateQuads3228 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_quadPattern_in_constructTemplateQuads3232 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_CONSTRUCT_TRIPLES_in_constructTemplate3262 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_constructTriples_in_constructTemplate3266 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_triples_in_constructTriples3293 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_triple_in_triples3327 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_TRIPLE_in_triple3348 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_SUBJECT_in_triple3351 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_varOrTerm_in_triple3355 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_PREDICATE_in_triple3359 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_verb_in_triple3363 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_OBJECT_in_triple3367 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_graphNode_in_triple3371 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_TODO_in_triplesSameSubject3396 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SUBJECT_in_objectList3420 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_varOrTerm_in_objectList3424 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_PREDICATE_in_objectList3428 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_verb_in_objectList3432 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_OBJECT_in_objectList3436 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_graphNode_in_objectList3440 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_varOrIRIref_in_verb3474 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_A_in_verb3484 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_path_in_verb3504 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_TRIPLE_in_triplesSameSubjectPath3529 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_objectList_in_triplesSameSubjectPath3531 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_TRIPLE_in_triplesSameSubjectPath3542 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_triplesSameSubjectPath_in_triplesSameSubjectPath3544 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_PATH_in_path3563 = new BitSet(new long[]{0x0000000000000000L,0x0000002000000000L,0x0000000004000000L});
	public static final BitSet FOLLOW_pathSequence_in_path3565 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_PIPE_in_path3569 = new BitSet(new long[]{0x0000000000000000L,0x0000002000000000L,0x0000000004000000L});
	public static final BitSet FOLLOW_pathSequence_in_path3571 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_pathEltOrInverse_in_pathSequence3591 = new BitSet(new long[]{0x2000000000000002L});
	public static final BitSet FOLLOW_DIVIDE_in_pathSequence3595 = new BitSet(new long[]{0x0000000000000000L,0x0000002000000000L,0x0000000004000000L});
	public static final BitSet FOLLOW_pathEltOrInverse_in_pathSequence3597 = new BitSet(new long[]{0x2000000000000002L});
	public static final BitSet FOLLOW_pathPrimary_in_pathElt3617 = new BitSet(new long[]{0x0000000000010002L,0x0000000000000000L,0x0000100020008000L});
	public static final BitSet FOLLOW_pathMod_in_pathElt3619 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_pathElt_in_pathEltOrInverse3637 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_INVERSE_in_pathEltOrInverse3641 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000004000000L});
	public static final BitSet FOLLOW_pathElt_in_pathEltOrInverse3643 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ASTERISK_in_pathMod3662 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QUESTION_MARK_in_pathMod3666 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_PLUS_in_pathMod3670 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OPEN_CURLY_BRACE_in_pathMod3674 = new BitSet(new long[]{0x0000000400000000L,0x0000000200000000L});
	public static final BitSet FOLLOW_INTEGER_in_pathMod3678 = new BitSet(new long[]{0x0000000440000000L});
	public static final BitSet FOLLOW_COMMA_in_pathMod3682 = new BitSet(new long[]{0x0000000040000000L,0x0000000200000000L});
	public static final BitSet FOLLOW_CLOSE_CURLY_BRACE_in_pathMod3686 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_INTEGER_in_pathMod3690 = new BitSet(new long[]{0x0000000040000000L});
	public static final BitSet FOLLOW_CLOSE_CURLY_BRACE_in_pathMod3692 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CLOSE_CURLY_BRACE_in_pathMod3698 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_COMMA_in_pathMod3704 = new BitSet(new long[]{0x0000000000000000L,0x0000000200000000L});
	public static final BitSet FOLLOW_INTEGER_in_pathMod3706 = new BitSet(new long[]{0x0000000040000000L});
	public static final BitSet FOLLOW_CLOSE_CURLY_BRACE_in_pathMod3708 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_PATH_PRIMARY_in_pathPrimary3730 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_iriRef_in_pathPrimary3732 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_PATH_PRIMARY_in_pathPrimary3742 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_A_in_pathPrimary3744 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_PATH_PRIMARY_in_pathPrimary3754 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_NEGATION_in_pathPrimary3756 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000002000000L});
	public static final BitSet FOLLOW_pathNegatedPropertySet_in_pathPrimary3758 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_PATH_PRIMARY_in_pathPrimary3768 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_path_in_pathPrimary3770 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_PATH_NEGATED_in_pathNegatedPropertySet3789 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_pathOneInPropertySet_in_pathNegatedPropertySet3791 = new BitSet(new long[]{0x0000000000000018L,0x000000A000000000L,0x00000000C0000000L});
	public static final BitSet FOLLOW_INVERSE_in_pathOneInPropertySet3810 = new BitSet(new long[]{0x0000000000000010L,0x0000008000000000L,0x00000000C0000000L});
	public static final BitSet FOLLOW_iriRef_in_pathOneInPropertySet3815 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_A_in_pathOneInPropertySet3819 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_COLLECTION_in_triplesNode3844 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_graphNode_in_triplesNode3846 = new BitSet(new long[]{0x801C000200800008L,0x0000008E00000403L,0x00000000D0014000L,0x00000800C8000000L});
	public static final BitSet FOLLOW_TRIPLE_in_triplesNode3858 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_objectList_in_triplesNode3860 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_varOrTerm_in_graphNode3888 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_triplesNode_in_graphNode3898 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_var_in_varOrTerm3922 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_graphTerm_in_varOrTerm3940 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_var_in_varOrIRIref3965 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_iriRef_in_varOrIRIref3980 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_VAR_in_var4005 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_iriRef_in_graphTerm4030 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_rdfLiteral_in_graphTerm4050 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_numericLiteral_in_graphTerm4068 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_booleanLiteral_in_graphTerm4080 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_blankNode_in_graphTerm4092 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_nil_in_graphTerm4107 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_nil4124 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_nil4126 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OR_in_expression4148 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_expression4152 = new BitSet(new long[]{0x2000000000010400L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_expression_in_expression4156 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_AND_in_expression4179 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_expression4183 = new BitSet(new long[]{0x2000000000010400L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_expression_in_expression4187 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_EQUAL_in_expression4209 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_expression4213 = new BitSet(new long[]{0x2000000000010400L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_expression_in_expression4217 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_NOT_EQUAL_in_expression4237 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_expression4241 = new BitSet(new long[]{0x2000000000010400L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_expression_in_expression4245 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_LESS_in_expression4261 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_expression4265 = new BitSet(new long[]{0x2000000000010400L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_expression_in_expression4269 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_GREATER_in_expression4290 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_expression4294 = new BitSet(new long[]{0x2000000000010400L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_expression_in_expression4298 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_LESS_EQUAL_in_expression4316 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_expression4320 = new BitSet(new long[]{0x2000000000010400L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_expression_in_expression4324 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_GREATER_EQUAL_in_expression4339 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_expression4343 = new BitSet(new long[]{0x2000000000010400L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_expression_in_expression4347 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_IN_in_expression4359 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_expression4363 = new BitSet(new long[]{0x2000000000010400L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_expression_in_expression4367 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_NOT_in_expression4390 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_IN_in_expression4392 = new BitSet(new long[]{0x2000000000010400L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_expression_in_expression4396 = new BitSet(new long[]{0x2000000000010400L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_expression_in_expression4400 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_PLUS_in_expression4419 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_expression4423 = new BitSet(new long[]{0x2000000000010400L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_expression_in_expression4427 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_MINUS_in_expression4448 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_expression4452 = new BitSet(new long[]{0x2000000000010400L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_expression_in_expression4456 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_ASTERISK_in_expression4476 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_expression4480 = new BitSet(new long[]{0x2000000000010400L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_expression_in_expression4484 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_DIVIDE_in_expression4501 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_expression4505 = new BitSet(new long[]{0x2000000000010400L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_expression_in_expression4509 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_unaryExpression_in_expression4529 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_UNARY_NOT_in_unaryExpression4578 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_primaryExpression_in_unaryExpression4582 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_UNARY_PLUS_in_unaryExpression4602 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_primaryExpression_in_unaryExpression4606 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_UNARY_MINUS_in_unaryExpression4625 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_primaryExpression_in_unaryExpression4629 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_UNARY_in_unaryExpression4647 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_primaryExpression_in_unaryExpression4651 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_builtInCall_in_primaryExpression4689 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_iriRefOrFunction_in_primaryExpression4707 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_expression_in_primaryExpression4720 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_rdfLiteral_in_primaryExpression4740 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_numericLiteral_in_primaryExpression4759 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_booleanLiteral_in_primaryExpression4774 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_var_in_primaryExpression4789 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_aggregate_in_primaryExpression4813 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STR_in_builtInCall4835 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall4839 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_LANG_in_builtInCall4863 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall4867 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_LANGMATCHES_in_builtInCall4890 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall4894 = new BitSet(new long[]{0x2000000000010400L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_expression_in_builtInCall4898 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_DATATYPE_in_builtInCall4913 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall4917 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_BOUND_in_builtInCall4927 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_var_in_builtInCall4931 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_IRI_in_builtInCall4960 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall4964 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_URI_in_builtInCall4974 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall4978 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_BNODE_in_builtInCall4988 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall4990 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_RAND_in_builtInCall4999 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ABS_in_builtInCall5008 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5012 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_CEIL_in_builtInCall5022 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5026 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_FLOOR_in_builtInCall5036 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5040 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_ROUND_in_builtInCall5050 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5052 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_CONCAT_in_builtInCall5062 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expressionList_in_builtInCall5066 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_subStringExpression_in_builtInCall5082 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRLEN_in_builtInCall5091 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5093 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_UCASE_in_builtInCall5103 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5105 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_LCASE_in_builtInCall5115 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5117 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_ENCODE_FOR_URI_in_builtInCall5127 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5129 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_CONTAINS_in_builtInCall5139 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5141 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_STRSTARTS_in_builtInCall5151 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5153 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_STRENDS_in_builtInCall5163 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5165 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_YEAR_in_builtInCall5175 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5177 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_MONTH_in_builtInCall5187 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5189 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_DAY_in_builtInCall5199 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5201 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_HOURS_in_builtInCall5211 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5213 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_MINUTES_in_builtInCall5223 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5225 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_SECONDS_in_builtInCall5235 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5237 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_TIMEZONE_in_builtInCall5247 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5249 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_TZ_in_builtInCall5259 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5261 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_NOW_in_builtInCall5270 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_MD5_in_builtInCall5279 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5281 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_SHA1_in_builtInCall5291 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5293 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_SHA224_in_builtInCall5303 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5305 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_SHA256_in_builtInCall5315 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5317 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_SHA384_in_builtInCall5327 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5329 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_SHA512_in_builtInCall5339 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5341 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_COALESCE_in_builtInCall5351 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expressionList_in_builtInCall5353 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_IF_in_builtInCall5363 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5365 = new BitSet(new long[]{0x2000000000010400L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_expression_in_builtInCall5367 = new BitSet(new long[]{0x2000000000010400L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_expression_in_builtInCall5369 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_STRLANG_in_builtInCall5379 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5381 = new BitSet(new long[]{0x2000000000010400L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_expression_in_builtInCall5383 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_STRDT_in_builtInCall5393 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5395 = new BitSet(new long[]{0x2000000000010400L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_expression_in_builtInCall5397 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_SAMETERM_in_builtInCall5407 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5409 = new BitSet(new long[]{0x2000000000010400L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_expression_in_builtInCall5411 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_ISIRI_in_builtInCall5421 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5423 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_ISURI_in_builtInCall5433 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5435 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_ISBLANK_in_builtInCall5445 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5447 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_ISLITERAL_in_builtInCall5457 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5459 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_ISNUMERIC_in_builtInCall5469 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5471 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_regexExpression_in_builtInCall5480 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_existsFunction_in_builtInCall5488 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_notExistsFunction_in_builtInCall5496 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_REGEX_in_regexExpression5514 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_regexExpression5516 = new BitSet(new long[]{0x2000000000010408L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_SUBSTR_in_subStringExpression5536 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_subStringExpression5538 = new BitSet(new long[]{0x2000000000010408L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_EXISTS_in_existsFunction5558 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_groupGraphPattern_in_existsFunction5560 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_NOT_EXISTS_in_notExistsFunction5579 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_groupGraphPattern_in_notExistsFunction5581 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_COUNT_in_aggregate5600 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_DISTINCT_in_aggregate5602 = new BitSet(new long[]{0x3000000000010408L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_ASTERISK_in_aggregate5605 = new BitSet(new long[]{0x2000000000010408L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_expression_in_aggregate5608 = new BitSet(new long[]{0x2000000000010408L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_SUM_in_aggregate5619 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_DISTINCT_in_aggregate5621 = new BitSet(new long[]{0x3000000000010400L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_expression_in_aggregate5624 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_MIN_in_aggregate5634 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_DISTINCT_in_aggregate5636 = new BitSet(new long[]{0x3000000000010400L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_expression_in_aggregate5639 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_MAX_in_aggregate5649 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_DISTINCT_in_aggregate5651 = new BitSet(new long[]{0x3000000000010400L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_expression_in_aggregate5654 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_AVG_in_aggregate5664 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_DISTINCT_in_aggregate5666 = new BitSet(new long[]{0x3000000000010400L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_expression_in_aggregate5669 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_SAMPLE_in_aggregate5679 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_DISTINCT_in_aggregate5681 = new BitSet(new long[]{0x2000000000010400L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_expression_in_aggregate5684 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_GROUP_CONCAT_in_aggregate5694 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_DISTINCT_in_aggregate5696 = new BitSet(new long[]{0x3000000000010400L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_expression_in_aggregate5699 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0000000000000000L,0x000000000000F000L});
	public static final BitSet FOLLOW_string_in_aggregate5701 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_iriRef_in_iriRefOrFunction5726 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_FUNCTION_in_iriRefOrFunction5771 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_iriRef_in_iriRefOrFunction5775 = new BitSet(new long[]{0x0000000000001000L});
	public static final BitSet FOLLOW_ARG_LIST_in_iriRefOrFunction5778 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_argList_in_iriRefOrFunction5782 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_PLAIN_LITERAL_in_rdfLiteral5808 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_string_in_rdfLiteral5812 = new BitSet(new long[]{0x0000000000000008L,0x0002000000000000L});
	public static final BitSet FOLLOW_LANGTAG_in_rdfLiteral5816 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_TYPED_LITERAL_in_rdfLiteral5829 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_string_in_rdfLiteral5833 = new BitSet(new long[]{0x0000000000000000L,0x0000008000000000L,0x00000000C0000000L});
	public static final BitSet FOLLOW_iriRef_in_rdfLiteral5837 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_numericLiteralUnsigned_in_numericLiteral5869 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_numericLiteralPositive_in_numericLiteral5881 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_numericLiteralNegative_in_numericLiteral5893 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_INTEGER_in_numericLiteralUnsigned5918 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DECIMAL_in_numericLiteralUnsigned5930 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DOUBLE_in_numericLiteralUnsigned5942 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_INTEGER_POSITIVE_in_numericLiteralPositive5968 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DECIMAL_POSITIVE_in_numericLiteralPositive5980 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DOUBLE_POSITIVE_in_numericLiteralPositive5992 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_INTEGER_NEGATIVE_in_numericLiteralNegative6018 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DECIMAL_NEGATIVE_in_numericLiteralNegative6030 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DOUBLE_NEGATIVE_in_numericLiteralNegative6042 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_TRUE_in_booleanLiteral6066 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_FALSE_in_booleanLiteral6077 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRING_LITERAL1_in_string6102 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRING_LITERAL2_in_string6119 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRING_LITERAL_LONG1_in_string6136 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRING_LITERAL_LONG2_in_string6148 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IRI_REF_in_iriRef6173 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_prefixedName_in_iriRef6190 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_PNAME_LN_in_prefixedName6215 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_PNAME_NS_in_prefixedName6228 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_BLANK_NODE_LABEL_in_blankNode6254 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_anon_in_blankNode6264 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OPEN_SQUARE_BRACKET_in_anon6283 = new BitSet(new long[]{0x0000000080000000L});
	public static final BitSet FOLLOW_CLOSE_SQUARE_BRACKET_in_anon6285 = new BitSet(new long[]{0x0000000000000002L});
}
