/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.views.transform;

import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.expr.E_Equals;
import com.hp.hpl.jena.sparql.expr.E_LogicalAnd;
import com.hp.hpl.jena.sparql.expr.E_LogicalNot;
import com.hp.hpl.jena.sparql.expr.E_LogicalOr;
import com.hp.hpl.jena.sparql.expr.E_Regex;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprFunction;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.expr.ExprVar;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import java.util.Arrays;
import org.aksw.commons.util.reflect.MultiMethod;
import org.aksw.sparqlify.algebra.sparql.expr.E_StrConcatPermissive;
import org.aksw.sparqlify.algebra.sql.exprs.S_Concat;
import org.aksw.sparqlify.algebra.sql.exprs.S_Equals;
import org.aksw.sparqlify.algebra.sql.exprs.S_LogicalAnd;
import org.aksw.sparqlify.algebra.sql.exprs.S_LogicalNot;
import org.aksw.sparqlify.algebra.sql.exprs.S_LogicalOr;
import org.aksw.sparqlify.algebra.sql.exprs.S_Regex;
import org.aksw.sparqlify.algebra.sql.exprs.SqlExpr;
import org.aksw.sparqlify.algebra.sql.exprs.SqlExprColumn;
import org.aksw.sparqlify.algebra.sql.exprs.SqlExprValue;
import org.aksw.sparqlify.core.MakeNodeValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlExprToExpr {
    public static final NodeValue UNKNOWN = NodeValue.makeString((String)"//maybe//");
    private static final Logger logger = LoggerFactory.getLogger(SqlExprToExpr.class);

    public static Expr convert(SqlExpr expr) {
        Expr result = (Expr)MultiMethod.invokeStatic(SqlExprToExpr.class, (String)"_convert", (Object[])new Object[]{expr});
        if (SqlExprToExpr.checkUnknown(result)) {
            return UNKNOWN;
        }
        return result;
    }

    public static boolean checkUnknown(Expr expr) {
        if (expr.equals(UNKNOWN)) {
            return true;
        }
        if (expr.isFunction()) {
            ExprFunction func = expr.getFunction();
            for (Expr arg : func.getArgs()) {
                if (!arg.equals(UNKNOWN)) continue;
                return true;
            }
        }
        return false;
    }

    public static Expr _convert(SqlExpr expr) {
        logger.warn("Unknown satisfiability: " + expr.getClass());
        return UNKNOWN;
    }

    public static ExprList evalArgs(SqlExpr ... args) {
        return SqlExprToExpr.evalArgs(Arrays.asList(args));
    }

    public static ExprList evalArgs(Iterable<SqlExpr> args) {
        ExprList result = new ExprList();
        for (SqlExpr arg : args) {
            Expr expr = SqlExprToExpr.convert(arg);
            result.add(expr);
        }
        return result;
    }

    public static Expr _convert(S_Equals expr) {
        return new E_Equals(SqlExprToExpr.convert(expr.getLeft()), SqlExprToExpr.convert(expr.getRight()));
    }

    public static Expr _convert(S_Concat expr) {
        return new E_StrConcatPermissive(SqlExprToExpr.evalArgs(expr.getArgs()));
    }

    public int exprToStrength(Expr e) {
        if (NodeValue.TRUE.equals((Object)e)) {
            return 0;
        }
        if (UNKNOWN.equals((Object)e)) {
            return 1;
        }
        if (NodeValue.FALSE.equals((Object)e)) {
            return 2;
        }
        return 1;
    }

    public static Expr _convert(S_LogicalAnd expr) {
        Expr a = SqlExprToExpr.convert(expr.getLeft());
        Expr b = SqlExprToExpr.convert(expr.getRight());
        return new E_LogicalAnd(a, b);
    }

    public static Expr _convert(S_LogicalOr expr) {
        return new E_LogicalOr(SqlExprToExpr.convert(expr.getLeft()), SqlExprToExpr.convert(expr.getRight()));
    }

    public static Expr _convert(S_LogicalNot expr) {
        return new E_LogicalNot(SqlExprToExpr.convert(expr.getExpr()));
    }

    public static Expr _convert(S_Regex expr) {
        return new E_Regex(SqlExprToExpr.convert(expr.getExpr()), expr.getPattern(), expr.getFlags());
    }

    public static Expr _convert(SqlExprValue expr) {
        return MakeNodeValue.makeNodeValue(expr.getObject());
    }

    public static Expr _convert(SqlExprColumn expr) {
        Var var = Var.alloc((String)("sql" + expr.getFullColumnName()));
        return new ExprVar(var);
    }
}

