/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.sparqlview;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import com.hp.hpl.jena.sparql.algebra.Algebra;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.core.QuadPattern;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingHashMap;
import com.hp.hpl.jena.sparql.expr.E_Equals;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.graph.NodeTransform;
import com.hp.hpl.jena.sparql.graph.NodeTransformLib;
import com.hp.hpl.jena.sparql.modify.request.UpdateModify;
import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.util.ExprUtils;
import com.hp.hpl.jena.update.UpdateFactory;
import com.hp.hpl.jena.update.UpdateRequest;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.XSD;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.jena_sparql_api.utils.QuadPatternUtils;
import org.aksw.jena_sparql_api.utils.QuadUtils;
import org.aksw.sparqlify.algebra.sparql.transform.SparqlSubstitute;
import org.aksw.sparqlify.algebra.sql.nodes.SqlNodeBase0;
import org.aksw.sparqlify.algebra.sql.nodes.SqlQuery;
import org.aksw.sparqlify.algebra.sql.nodes.SqlTable;
import org.aksw.sparqlify.config.lang.Constraint;
import org.aksw.sparqlify.core.domain.input.RestrictedExpr;
import org.aksw.sparqlify.core.domain.input.VarDefinition;
import org.aksw.sparqlify.core.interfaces.IViewDef;
import org.aksw.sparqlify.restriction.RestrictionManagerImpl;
import org.aksw.sparqlify.trash.RenamerNodes;
import org.aksw.sparqlify.views.transform.GetVarsMentioned;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sparql.FilterUtils;
import sparql.PatternUtils;

public class SparqlView
implements IViewDef {
    private static final Logger logger = LoggerFactory.getLogger(SparqlView.class);
    private String name;
    private QuadPattern template;
    private VarDefinition varDefinition;
    private ExprList constraints;
    private RestrictionManagerImpl restrictions;
    private Op op;
    private RestrictionManagerImpl varRestrictions = new RestrictionManagerImpl();

    public RestrictionManagerImpl getRestrictions() {
        return this.restrictions;
    }

    public void setRestrictions(RestrictionManagerImpl restrictions) {
        this.restrictions = restrictions;
    }

    public Set<Var> getVarsMentioned() {
        HashSet<Var> result = new HashSet<Var>();
        result.addAll(QuadUtils.getVarsMentioned((Iterable)this.template));
        result.addAll(GetVarsMentioned.getVarsMentioned(this.op));
        return result;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static SparqlView create(String str) {
        HashMap<String, String> defaultPrefixes = new HashMap<String, String>();
        defaultPrefixes.put("bif", "http://bif/");
        defaultPrefixes.put("rdf", RDF.getURI());
        defaultPrefixes.put("rdfs", RDFS.getURI());
        defaultPrefixes.put("geo", "http://ex.org/");
        defaultPrefixes.put("xsd", XSD.getURI());
        defaultPrefixes.put("spy", "http://aksw.org/sparqlify/");
        defaultPrefixes.put("wso", "http://aksw.org/wortschatz/ontology/");
        defaultPrefixes.put("rdf", RDF.getURI());
        defaultPrefixes.put("owl", OWL.getURI());
        return SparqlView.create("unnamed", str, defaultPrefixes);
    }

    public static SparqlView create(String name, String viewDefStr) {
        String str = viewDefStr.replaceAll("Construct", "Insert ");
        System.out.println("Hack replacement: " + str);
        UpdateRequest request = new UpdateRequest();
        UpdateFactory.parse((UpdateRequest)request, (String)str);
        UpdateModify update = (UpdateModify)request.getOperations().get(0);
        List quads = update.getInsertQuads();
        Element element = update.getWherePattern();
        QuadPattern quadPattern = QuadPatternUtils.create((Iterable)quads);
        SparqlView result = SparqlView.create(name, quadPattern, element);
        return result;
    }

    public static SparqlView create(String name, QuadPattern quadPattern, Element element) {
        Op tmp = Algebra.compile((Element)element);
        Op op = Algebra.toQuadForm((Op)tmp);
        SparqlView result = SparqlView.create(name, quadPattern, op);
        return result;
    }

    public static SparqlView create(String name, QuadPattern quadPattern, Op op) {
        SparqlView result = new SparqlView(name, quadPattern, new ExprList(), new VarDefinition(), op);
        return result;
    }

    public static SparqlView create(String name, Query query) {
        if (!query.isConstructType()) {
            throw new RuntimeException("Query must be a construct query");
        }
        Op tmp = Algebra.compile((Element)query.getQueryPattern());
        Op op = Algebra.toQuadForm((Op)tmp);
        QuadPattern quadPattern = QuadPatternUtils.toQuadPattern((Node)Quad.defaultGraphNodeGenerated, (BasicPattern)query.getConstructTemplate().getBGP());
        SparqlView result = SparqlView.create(name, quadPattern, op);
        return result;
    }

    public static SparqlView create(String name, QuadPattern template, ExprList filters, List<Expr> bindings, List<Constraint> rawConstraints, Op op) {
        if (bindings == null) {
            bindings = new ArrayList<Expr>();
        }
        VarDefinition varDefinition = new VarDefinition();
        for (Expr expr : bindings) {
            if (!(expr instanceof E_Equals)) {
                throw new RuntimeException("Binding expr must have form ?var = ... --- instead got: " + expr);
            }
            Expr definition = expr.getFunction().getArg(2);
            definition = SparqlSubstitute.substituteExpr(definition);
            RestrictedExpr restExpr = new RestrictedExpr(definition);
            Var var = expr.getFunction().getArg(1).asVar();
            varDefinition.getMap().put((Object)var, (Object)restExpr);
        }
        if (rawConstraints == null) {
            rawConstraints = Collections.emptyList();
        }
        ExprList constraints = new ExprList();
        logger.warn("Derivation of restrictions from expressions currently not implemented");
        return new SparqlView(name, template, constraints, varDefinition, op);
    }

    public static SparqlView create(String name, String str, Map<String, String> defaultPrefixes) {
        PrefixMappingImpl defaultPrefixMapping = new PrefixMappingImpl();
        defaultPrefixMapping.setNsPrefixes(defaultPrefixes);
        String[] parts1 = str.split("\\swith\\s", 2);
        String[] parts2 = parts1[1].split(";");
        String sqlStr = parts2[parts2.length - 1].trim();
        String queryStr = "Select * " + parts1[0];
        String[] bindingStrs = Arrays.copyOf(parts2, parts2.length - 1);
        Query query = new Query();
        query.setPrefixMapping((PrefixMapping)defaultPrefixMapping);
        QueryFactory.parse((Query)query, (String)queryStr, null, (Syntax)Syntax.syntaxSPARQL);
        Op op = Algebra.compile((Query)query);
        op = Algebra.toQuadForm((Op)op);
        QuadPattern quadPattern = new QuadPattern();
        for (Quad quad : PatternUtils.collectQuads(op)) {
            quadPattern.add(quad);
        }
        VarDefinition varDefinition = new VarDefinition();
        for (String bindingStr : bindingStrs) {
            Expr expr = ExprUtils.parse((String)bindingStr, (PrefixMapping)defaultPrefixMapping);
            if (!(expr instanceof E_Equals)) {
                throw new RuntimeException("Binding expr must have form ?var = ... --- instead got: " + bindingStr);
            }
            Expr definition = expr.getFunction().getArg(2);
            definition = SparqlSubstitute.substituteExpr(definition);
            RestrictedExpr restExpr = new RestrictedExpr(definition);
            Var var = expr.getFunction().getArg(1).asVar();
            varDefinition.getMap().put((Object)var, (Object)restExpr);
        }
        SqlNodeBase0 sqlExpr = sqlStr.startsWith("select") ? new SqlQuery(null, sqlStr) : new SqlTable(sqlStr);
        ExprList constraints = FilterUtils.collectExprs(op, new ExprList());
        return new SparqlView(name, quadPattern, constraints, varDefinition, op);
    }

    public SparqlView(String name, QuadPattern template, ExprList constraints, VarDefinition varDefinition, Op op) {
        this.name = name;
        this.template = template;
        this.varDefinition = varDefinition;
        this.constraints = constraints;
        this.op = op;
    }

    @Deprecated
    public QuadPattern getQuadPattern() {
        return this.template;
    }

    @Deprecated
    public Map<Node, Expr> getBinding() {
        throw new RuntimeException("deprecated and removed");
    }

    public Op getOp() {
        return this.op;
    }

    public ExprList getConstraints() {
        return this.constraints;
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SparqlView other = (SparqlView)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    @Override
    public QuadPattern getTemplate() {
        return this.template;
    }

    @Override
    public RestrictionManagerImpl getVarRestrictions() {
        return this.varRestrictions;
    }

    @Override
    public VarDefinition getVarDefinition() {
        return this.varDefinition;
    }

    @Deprecated
    public SparqlView copySubstitute(Map<Node, Node> renamer) {
        throw new RuntimeException("not there anymore");
    }

    @Override
    public SparqlView copyRenameVars(Map<Var, Var> oldToNew) {
        HashMap<Node, Node> map = new HashMap<Node, Node>();
        for (Map.Entry<Var, Var> entry : oldToNew.entrySet()) {
            map.put((Node)entry.getKey(), (Node)entry.getValue());
        }
        ExprList tmpFilter = new ExprList();
        RenamerNodes rename = new RenamerNodes(map);
        for (Expr expr : this.constraints) {
            tmpFilter.add(expr.applyNodeTransform((NodeTransform)rename));
        }
        BindingHashMap bindingMap = new BindingHashMap();
        for (Map.Entry entry : map.entrySet()) {
            bindingMap.add((Var)entry.getKey(), (Node)entry.getValue());
        }
        RenamerNodes renamer = new RenamerNodes(map);
        Op renamedOp = NodeTransformLib.transform((NodeTransform)renamer, (Op)this.op);
        SparqlView result = new SparqlView(this.name, QuadUtils.copySubstitute((QuadPattern)this.template, map), this.constraints.copySubstitute((Binding)bindingMap), null, renamedOp);
        return result;
    }
}

