/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.sparql;

import com.google.common.collect.Multimap;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterNullIterator;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.aksw.jena_sparql_api.core.QueryExecutionAdapter;
import org.aksw.sparqlify.core.domain.input.SparqlSqlStringRewrite;
import org.aksw.sparqlify.core.interfaces.SparqlSqlStringRewriter;
import org.aksw.sparqlify.core.sparql.ResultSetFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryExecutionSelect
extends QueryExecutionAdapter {
    private static final Logger logger = LoggerFactory.getLogger(QueryExecutionSelect.class);
    private SparqlSqlStringRewriter rewriter;
    private final Connection conn;
    private boolean closeConnWhenDone;
    private Query query;
    private Statement stmt;
    private ResultSet rs;

    public QueryExecutionSelect(SparqlSqlStringRewriter rewriter, Connection conn, Query query, boolean closeConnWhenDone) {
        this.rewriter = rewriter;
        this.conn = conn;
        this.query = query;
        this.closeConnWhenDone = closeConnWhenDone;
    }

    public ResultSet execSelect() {
        try {
            return this._execSelect();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public static void write(PrintStream out, Map<?, ?> map) {
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            out.println(entry.getKey() + ": " + entry.getValue());
        }
    }

    public static String spaces(int n) {
        String result = "";
        for (int i = 0; i < n; ++i) {
            result = result + " ";
        }
        return result;
    }

    public static <K, V> void write(PrintStream out, Multimap<K, V> map) {
        for (Map.Entry entry : map.asMap().entrySet()) {
            boolean keyPrint = false;
            String key = entry.getKey() == null ? "(null)" : entry.getKey().toString();
            String sp = QueryExecutionSelect.spaces(key.length());
            for (Object value : (Collection)entry.getValue()) {
                if (!keyPrint) {
                    out.println(key + ": " + value);
                    keyPrint = true;
                    continue;
                }
                out.println(sp + "  " + value);
            }
            if (keyPrint) continue;
            out.println(key + ": (empty)");
        }
    }

    public static Statement createStatement(Connection conn) throws SQLException {
        Statement stmt = conn.createStatement();
        stmt.setFetchSize(50000);
        return stmt;
    }

    private ResultSet createEmptyResultSet() {
        ArrayList<String> vars = new ArrayList<String>();
        for (Var v : this.query.getProjectVars()) {
            vars.add(v.getName());
        }
        return com.hp.hpl.jena.query.ResultSetFactory.create((QueryIterator)new QueryIterNullIterator(null), vars);
    }

    public ResultSet _execSelect() throws SQLException {
        SparqlSqlStringRewrite rewrite = this.rewriter.rewrite(this.query);
        this.stmt = QueryExecutionSelect.createStatement(this.conn);
        logger.debug("My connection: " + this.conn + " Query is " + this.query);
        String queryString = rewrite.isEmptyResult() ? null : rewrite.getSqlQueryString();
        this.rs = ResultSetFactory.create(this.conn, this.stmt, queryString, rewrite.getVarDefinition().getMap(), rewrite.getProjectionOrder());
        return this.rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        QueryExecutionSelect queryExecutionSelect = this;
        synchronized (queryExecutionSelect) {
            if (this.stmt != null) {
                try {
                    this.stmt.cancel();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        QueryExecutionSelect queryExecutionSelect = this;
        synchronized (queryExecutionSelect) {
            if (this.closeConnWhenDone) {
                try {
                    this.conn.close();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            if (this.stmt != null) {
                try {
                    this.stmt.close();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

