/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.datatypes;

import org.aksw.sparqlify.algebra.sql.exprs2.S_Constant;
import org.aksw.sparqlify.algebra.sql.exprs2.SqlExpr;
import org.aksw.sparqlify.core.TypeToken;

public class SqlExprOps {
    public static final SqlExpr O = S_Constant.FALSE;
    public static final SqlExpr l = S_Constant.TRUE;
    public static final SqlExpr e = S_Constant.TYPE_ERROR;
    public static final SqlExpr n = new S_Constant(TypeToken.Boolean);
    public static final SqlExpr a = new S_Constant(TypeToken.Special, "firstArg");
    public static final SqlExpr b = new S_Constant(TypeToken.Special, "secondArg");
    public static final SqlExpr c = new S_Constant(TypeToken.Special, "originalArgs");
    public static final SqlExpr[][] tableLogicalAnd = new SqlExpr[][]{{O, O, O, O, O}, {O, l, e, n, b}, {O, e, e, e, c}, {O, n, e, n, c}, {O, a, c, c, c}};
    public static final SqlExpr[][] tableLogicalOr = new SqlExpr[][]{{O, l, e, n, b}, {l, l, l, l, l}, {e, l, e, e, c}, {n, l, e, n, c}, {a, l, c, c, c}};
    public static final SqlExpr[] tableLogicalNot = new SqlExpr[]{l, O, e, n, a};

    public static int exprToTruthValue(SqlExpr a) {
        int result = !a.isConstant() ? 4 : (a.equals(S_Constant.FALSE) ? 0 : (a.equals(S_Constant.TRUE) ? 1 : (a.equals(S_Constant.TYPE_ERROR) ? 2 : (a.asConstant().getValue() == null ? 3 : 2))));
        return result;
    }

    public static SqlExpr interpretResult(SqlExpr tmp, SqlExpr x, SqlExpr y) {
        SqlExpr result;
        if (tmp == a) {
            result = x;
        } else {
            if (tmp == b) {
                return y;
            }
            if (tmp == c) {
                return null;
            }
            result = tmp;
        }
        return result;
    }

    public static SqlExpr logicalAnd(SqlExpr x, SqlExpr y) {
        int ix = SqlExprOps.exprToTruthValue(x);
        int iy = SqlExprOps.exprToTruthValue(y);
        SqlExpr tmp = tableLogicalAnd[ix][iy];
        SqlExpr result = SqlExprOps.interpretResult(tmp, x, y);
        return result;
    }

    public static SqlExpr logicalOr(SqlExpr x, SqlExpr y) {
        int ix = SqlExprOps.exprToTruthValue(x);
        int iy = SqlExprOps.exprToTruthValue(y);
        SqlExpr tmp = tableLogicalOr[ix][iy];
        SqlExpr result = SqlExprOps.interpretResult(tmp, x, y);
        return result;
    }

    public static SqlExpr logicalNot(SqlExpr x) {
        int ix = SqlExprOps.exprToTruthValue(x);
        SqlExpr tmp = tableLogicalNot[ix];
        if (tmp == a) {
            return null;
        }
        SqlExpr result = SqlExprOps.interpretResult(tmp, x, null);
        return result;
    }
}

