/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.cast;

import java.util.HashMap;
import java.util.Map;
import org.aksw.sparqlify.core.TypeToken;
import org.aksw.sparqlify.core.cast.CoercionSystem;
import org.aksw.sparqlify.core.cast.SqlValueTransformer;
import org.aksw.sparqlify.core.cast.TypeSystem;

public class CoercionSystemImpl3
implements CoercionSystem<TypeToken, SqlValueTransformer> {
    private TypeSystem typeSystem;
    private Map<TypeToken, Map<TypeToken, SqlValueTransformer>> sourceToTargetToTransform = new HashMap<TypeToken, Map<TypeToken, SqlValueTransformer>>();

    public CoercionSystemImpl3(TypeSystem typeSystem) {
        this.typeSystem = typeSystem;
    }

    @Override
    public SqlValueTransformer lookup(TypeToken sourceTypeName, TypeToken targetTypeName) {
        Map<TypeToken, SqlValueTransformer> targetToDecl = this.sourceToTargetToTransform.get(sourceTypeName);
        if (targetToDecl == null) {
            return null;
        }
        SqlValueTransformer result = targetToDecl.get(targetTypeName);
        return result;
    }

    public void registerCoercion(TypeToken sourceTypeName, TypeToken targetTypeName, SqlValueTransformer transformer) {
        if (this.typeSystem.isSuperClassOf(targetTypeName, sourceTypeName)) {
            throw new RuntimeException("The return type must not be a subtype of the argument.");
        }
        Map<TypeToken, SqlValueTransformer> targetToDecl = this.sourceToTargetToTransform.get(sourceTypeName);
        SqlValueTransformer priorDecl = null;
        if (targetToDecl == null) {
            targetToDecl = new HashMap<TypeToken, SqlValueTransformer>();
            this.sourceToTargetToTransform.put(sourceTypeName, targetToDecl);
        } else {
            priorDecl = targetToDecl.get(targetTypeName);
        }
        if (priorDecl != null) {
            throw new RuntimeException("Coercion " + transformer + " from " + sourceTypeName + " to " + targetTypeName + " already defined with " + priorDecl);
        }
        targetToDecl.put(targetTypeName, transformer);
    }
}

