/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.algorithms;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.Sets;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.Var;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.commons.collections.multimaps.IBiSetMultimap;
import org.aksw.sparqlify.core.algorithms.VarBinding;
import org.aksw.sparqlify.core.algorithms.ViewInstance;
import org.aksw.sparqlify.core.algorithms.ViewInstanceJoin;

public class SelfJoinEliminator {
    public static ViewInstance merge(ViewInstance a, ViewInstance b) {
        if (a.getViewDefinition() != b.getViewDefinition()) {
            System.out.println(a.getViewDefinition());
            System.out.println(b.getViewDefinition());
            return null;
        }
        IBiSetMultimap<Var, Var> backA = a.getBinding().getViewVarToQueryVars();
        IBiSetMultimap<Var, Var> backB = b.getBinding().getViewVarToQueryVars();
        if (backB.keySet().size() > backA.keySet().size()) {
            ViewInstance t = a;
            a = b;
            b = t;
            IBiSetMultimap<Var, Var> backT = backA;
            backA = backB;
            backB = backT;
        }
        for (Var varA : backA.keySet()) {
            Set varsA = backA.get((Object)varA);
            Set varsB = backB.get((Object)varA);
            if (varsB.isEmpty() || !Sets.intersection((Set)varsA, (Set)varsB).isEmpty()) continue;
            return null;
        }
        Map<Var, Node> a_queryToConst = a.getBinding().getQueryVarToConstant();
        Map<Var, Node> b_queryToConst = b.getBinding().getQueryVarToConstant();
        for (Map.Entry<Var, Node> entry : a_queryToConst.entrySet()) {
            Var a_queryVar;
            Var b_queryVar = a_queryVar = entry.getKey();
            Node a_value = entry.getValue();
            Node b_value = b_queryToConst.get(b_queryVar);
            if (b_value == null || a_value.equals((Object)b_value)) continue;
            return null;
        }
        VarBinding mergedBinding = new VarBinding();
        mergedBinding.putAll(a.getBinding());
        mergedBinding.putAll(b.getBinding());
        ViewInstance result = new ViewInstance(a.getViewDefinition(), mergedBinding);
        return result;
    }

    public static void merge(ViewInstanceJoin conjunction) {
        ListMultimap nameToInstance = conjunction.getInstancesGroupedByParent();
        for (Map.Entry entry : nameToInstance.asMap().entrySet()) {
            List list = (List)entry.getValue();
            SelfJoinEliminator.eliminateSelfJoins(list);
        }
    }

    public static void eliminateSelfJoins(List<ViewInstance> viewInstances) {
        for (int i = 0; i < viewInstances.size(); ++i) {
            ViewInstance a = viewInstances.get(i);
            for (int j = i + 1; j < viewInstances.size(); ++j) {
                ViewInstance b = viewInstances.get(j);
                ViewInstance view = SelfJoinEliminator.merge(a, b);
                if (view == null) continue;
                a = view;
                viewInstances.set(i, view);
                viewInstances.remove(j);
                --j;
            }
        }
    }
}

