/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.algorithms;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprFunction;
import com.hp.hpl.jena.sparql.expr.ExprVar;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.vocabulary.XSD;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.aksw.sparqlify.core.TypeToken;
import org.aksw.sparqlify.trash.ExprCopy;

public class ExprDatatypeNorm {
    public Expr normalize(Expr expr, Map<String, TypeToken> typeMap) {
        NodeValue result;
        if (expr == null) {
            result = NodeValue.nvNothing;
        } else if (expr.isVariable()) {
            result = this.normalize(expr.getExprVar(), typeMap);
        } else if (expr.isConstant()) {
            result = this.normalize(expr.getConstant(), typeMap);
        } else if (expr.isFunction()) {
            result = this.normalize(expr.getFunction(), typeMap);
        } else {
            throw new RuntimeException("Unknown expression type: " + expr);
        }
        return result;
    }

    public List<Expr> normalizeArgs(Iterable<Expr> exprs, Map<String, TypeToken> columnToDatatype) {
        ArrayList<Expr> result = new ArrayList<Expr>();
        for (Expr expr : exprs) {
            Expr e = this.normalize(expr, columnToDatatype);
            result.add(e);
        }
        return result;
    }

    public Expr normalize(ExprFunction expr, Map<String, TypeToken> typeMap) {
        List<Expr> newArgs = this.normalizeArgs(expr.getArgs(), typeMap);
        return ExprCopy.getInstance().copy(expr, newArgs);
    }

    public ExprVar normalize(ExprVar expr, Map<String, TypeToken> typeMap) {
        TypeToken datatype = typeMap.get(expr.getVarName());
        if (datatype == null) {
            throw new RuntimeException("No datatype information for column " + expr.getVarName() + "; typeMap=" + typeMap);
        }
        return new ExprVar(datatype.getName());
    }

    public Expr normalize(NodeValue expr, Map<String, TypeToken> typeMap) {
        NodeValue result = null;
        Node node = expr.asNode();
        if (node.isLiteral()) {
            String datatypeUri = node.getLiteralDatatypeURI();
            result = datatypeUri == null ? NodeValue.makeString((String)XSD.xstring.getURI()) : NodeValue.makeString((String)datatypeUri);
        } else if (node.isURI()) {
            result = NodeValue.makeString((String)XSD.xstring.getURI());
        }
        if (result == null) {
            throw new RuntimeException("Null datatype for: " + expr);
        }
        return result;
    }
}

