/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.algebra.sql.nodes;

import java.util.List;
import java.util.Map;
import org.aksw.sparqlify.algebra.sql.nodes.Schema;
import org.aksw.sparqlify.algebra.sql.nodes.SchemaImpl;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOp;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOpBase1;
import org.aksw.sparqlify.core.TypeToken;
import org.apache.jena.atlas.io.IndentedWriter;

public class SqlOpProject
extends SqlOpBase1 {
    private List<String> columnNames;

    public SqlOpProject(Schema schema, SqlOp subOp, List<String> columnNames) {
        super(schema, subOp);
        this.columnNames = columnNames;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public static SqlOpProject create(SqlOp subOp, List<String> columnNames) {
        Map<String, TypeToken> typeMap = subOp.getSchema().getTypeMap();
        SchemaImpl newSchema = new SchemaImpl();
        assert (subOp.getSchema().getColumnNames().containsAll(columnNames)) : "Projection must not reference undefined columns; referenced: " + columnNames + ", defined: " + subOp.getSchema().getColumnNames();
        for (String name : columnNames) {
            newSchema.getColumnNames().add(name);
            TypeToken type = typeMap.get(name);
            newSchema.getTypeMap().put(name, type);
        }
        SqlOpProject result = new SqlOpProject(newSchema, subOp, columnNames);
        return result;
    }

    @Override
    public void write(IndentedWriter writer) {
        writer.println("SqlOpProject" + this.columnNames + "(");
        writer.incIndent();
        this.subOp.write(writer);
        writer.println();
        writer.decIndent();
        writer.print(")");
    }
}

