/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.algebra.sql.nodes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.sparqlify.algebra.sql.nodes.Schema;
import org.aksw.sparqlify.core.TypeToken;

public class SchemaImpl
implements Schema {
    private List<String> names;
    private Map<String, TypeToken> nameToType;
    private Set<String> nullableNames;

    public SchemaImpl() {
        this(new ArrayList<String>(), new HashMap<String, TypeToken>(), new HashSet<String>());
    }

    public SchemaImpl(List<String> names, Map<String, TypeToken> nameToType) {
        this(names, nameToType, new HashSet<String>());
    }

    public SchemaImpl(List<String> names, Map<String, TypeToken> nameToType, Set<String> nullableNames) {
        SchemaImpl.validateNames(names);
        this.names = names;
        this.nameToType = nameToType;
        this.nullableNames = nullableNames;
    }

    public static void validateNames(List<String> names) {
        HashSet<String> dups = new HashSet<String>();
        HashSet<String> visited = new HashSet<String>();
        for (String name : names) {
            if (visited.contains(name)) {
                dups.add(name);
            }
            visited.add(name);
        }
        if (!dups.isEmpty()) {
            throw new RuntimeException("Multiple column names: " + dups);
        }
    }

    public static SchemaImpl create(List<String> names, Map<String, TypeToken> nameToType) {
        SchemaImpl.validateNames(names);
        return new SchemaImpl(names, nameToType);
    }

    @Override
    public int getColumnCount() {
        return this.names.size();
    }

    @Override
    public String getColumnName(int index) {
        return this.names.get(index);
    }

    @Override
    public TypeToken getColumnType(int index) {
        String name = this.names.get(index);
        TypeToken result = this.nameToType.get(name);
        return result;
    }

    @Override
    public List<String> getColumnNames() {
        return this.names;
    }

    @Override
    public TypeToken getColumnType(String name) {
        TypeToken result = this.nameToType.get(name);
        return result;
    }

    @Override
    public Map<String, TypeToken> getTypeMap() {
        return this.nameToType;
    }

    public String toString() {
        String result = "[";
        boolean isFirst = true;
        for (String name : this.names) {
            TypeToken type = this.nameToType.get(name);
            if (isFirst) {
                isFirst = false;
            } else {
                result = result + ", ";
            }
            result = result + name + ": " + type;
        }
        result = result + "]";
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.nameToType == null ? 0 : this.nameToType.hashCode());
        result = 31 * result + (this.names == null ? 0 : this.names.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SchemaImpl other = (SchemaImpl)obj;
        if (this.nameToType == null ? other.nameToType != null : !this.nameToType.equals(other.nameToType)) {
            return false;
        }
        return !(this.names == null ? other.names != null : !this.names.equals(other.names));
    }

    @Override
    public boolean isNullable(String columnName) {
        boolean result = this.nullableNames.contains(columnName);
        return result;
    }

    @Override
    public Schema createSubSchema(List<String> columnNames) {
        HashMap<String, TypeToken> tm = new HashMap<String, TypeToken>();
        HashSet<String> nulls = new HashSet<String>();
        for (String colName : columnNames) {
            TypeToken type = this.nameToType.get(colName);
            if (type == null) {
                throw new RuntimeException("Column " + colName + " does not exist.");
            }
            tm.put(colName, type);
            if (!this.isNullable(colName)) continue;
            nulls.add(colName);
        }
        SchemaImpl result = new SchemaImpl(columnNames, tm, nulls);
        return result;
    }
}

