/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.algebra.sparql.transform;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprAggregator;
import com.hp.hpl.jena.sparql.expr.ExprFunction;
import com.hp.hpl.jena.sparql.expr.ExprFunctionOp;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.expr.ExprVar;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.aggregate.Aggregator;
import java.util.HashMap;
import java.util.Map;
import org.aksw.commons.util.reflect.MultiMethod;
import org.aksw.sparqlify.trash.ExprCopy;
import org.apache.commons.lang.NotImplementedException;

public class NodeExprSubstitutor {
    private Map<? extends Node, ? extends Expr> map;

    public static NodeExprSubstitutor create(Map<String, Expr> varNameToExpr) {
        HashMap<Var, Expr> tmp = new HashMap<Var, Expr>();
        for (Map.Entry<String, Expr> entry : varNameToExpr.entrySet()) {
            tmp.put(Var.alloc((String)entry.getKey()), entry.getValue());
        }
        NodeExprSubstitutor result = new NodeExprSubstitutor(tmp);
        return result;
    }

    public NodeExprSubstitutor(Map<? extends Node, ? extends Expr> map) {
        this.map = map;
    }

    public Expr transformMM(Expr expr) {
        return expr == null ? null : (Expr)MultiMethod.invoke((Object)this, (String)"_transform", (Object[])new Object[]{expr});
    }

    public Expr _transform(ExprFunction expr) {
        ExprList args = this.transformList(expr.getArgs());
        Expr result = ExprCopy.getInstance().copy((Expr)expr, args);
        return result;
    }

    public ExprList transformList(Iterable<Expr> exprs) {
        ExprList result = new ExprList();
        for (Expr expr : exprs) {
            result.add(this.transformMM(expr));
        }
        return result;
    }

    public Expr _transform(ExprFunctionOp funcOp, ExprList args, Op opArg) {
        throw new NotImplementedException();
    }

    public Expr _transform(NodeValue nv) {
        return nv;
    }

    public Expr _transform(ExprVar nv) {
        Expr tmp = this.map.get(nv.asVar());
        return tmp != null ? tmp : nv;
    }

    public Expr _transform(ExprAggregator eAgg) {
        Expr newAggExpr = this.transformMM(eAgg.getAggregator().getExpr());
        Aggregator newAgg = eAgg.getAggregator().copy(newAggExpr);
        Expr newAggVar = this.transformMM((Expr)eAgg.getAggVar());
        ExprAggregator result = new ExprAggregator(newAggVar.asVar(), newAgg);
        return result;
    }
}

