/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.web;

import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.sun.jersey.spi.container.servlet.ServletContainer;
import java.io.OutputStream;
import java.sql.Connection;
import java.util.Iterator;
import java.util.Map;
import javax.sql.DataSource;
import org.aksw.commons.util.MapReader;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.core.utils.QueryExecutionUtils;
import org.aksw.sparqlify.config.syntax.Config;
import org.aksw.sparqlify.config.v0_2.bridge.ConfiguratorCandidateSelector;
import org.aksw.sparqlify.config.v0_2.bridge.SchemaProviderImpl;
import org.aksw.sparqlify.config.v0_2.bridge.SyntaxBridge;
import org.aksw.sparqlify.core.RdfViewSystemOld;
import org.aksw.sparqlify.core.algorithms.CandidateViewSelectorImpl;
import org.aksw.sparqlify.core.algorithms.OpMappingRewriterImpl;
import org.aksw.sparqlify.core.algorithms.ViewDefinitionNormalizerImpl;
import org.aksw.sparqlify.core.cast.TypeSystem;
import org.aksw.sparqlify.core.interfaces.MappingOps;
import org.aksw.sparqlify.core.sparql.QueryEx;
import org.aksw.sparqlify.core.sparql.QueryExecutionFactoryEx;
import org.aksw.sparqlify.core.sparql.QueryFactoryEx;
import org.aksw.sparqlify.util.ExprRewriteSystem;
import org.aksw.sparqlify.util.SparqlifyUtils;
import org.aksw.sparqlify.validation.LoggerCount;
import org.aksw.sparqlify.web.HttpSparqlEndpoint;
import org.aksw.sparqlify.web.SparqlFormatterUtils;
import org.aksw.sparqlify.web.SparqlifyCliHelper;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.jena.riot.out.NQuadsWriter;
import org.apache.jena.riot.out.NTriplesWriter;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final Logger logger = LoggerFactory.getLogger(HttpSparqlEndpoint.class);
    private static final Options cliOptions = new Options();

    public static void onErrorPrintHelpAndExit(Options cliOptions, LoggerCount loggerCount, int exitCode) {
        if (loggerCount.getErrorCount() != 0) {
            Main.printHelpAndExit(cliOptions, exitCode);
            throw new RuntimeException("Encountered " + loggerCount.getErrorCount() + " errors that need to be fixed first.");
        }
    }

    public static void printHelpAndExit(Options cliOptions, int exitCode) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(HttpSparqlEndpoint.class.getName(), cliOptions);
        System.exit(exitCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        String maxQueryExecutionTimeStr;
        boolean isQuery;
        LoggerCount loggerCount = new LoggerCount(logger);
        Class.forName("org.postgresql.Driver");
        GnuParser cliParser = new GnuParser();
        cliOptions.addOption("P", "port", true, "Server port");
        cliOptions.addOption("C", "context", true, "Context e.g. /sparqlify");
        cliOptions.addOption("B", "backlog", true, "Maximum number of connections");
        SparqlifyCliHelper.addDatabaseOptions(cliOptions);
        cliOptions.addOption("Q", "query", true, "");
        cliOptions.addOption("D", "dump", false, "");
        cliOptions.addOption("m", "mapping", true, "Sparqlify mapping file (can be specified multiple times)");
        cliOptions.addOption("t", "timeout", true, "Maximum query execution timeout in seconds");
        cliOptions.addOption("n", "resultsetsize", true, "Maximum result set size");
        cliOptions.addOption("o", "format", true, "Output format; currently only applies to dump (-D). Values: ntriples, nquads");
        CommandLine commandLine = cliParser.parse(cliOptions, args);
        String portStr = commandLine.getOptionValue("P", "7531");
        int port = Integer.parseInt(portStr);
        String outputFormat = commandLine.getOptionValue("o", "default");
        boolean isDump = commandLine.hasOption("D");
        String queryString = commandLine.getOptionValue("Q", "");
        boolean bl = isQuery = !queryString.isEmpty();
        if (!isQuery) {
            queryString = null;
        }
        if (isDump && isQuery) {
            loggerCount.error("Options D and Q are mutually exclusive");
        }
        Integer maxQueryExecutionTime = (maxQueryExecutionTimeStr = commandLine.getOptionValue("t", null)) == null ? null : Integer.valueOf(Integer.parseInt(maxQueryExecutionTimeStr));
        String maxResultSetSizeStr = commandLine.getOptionValue("n", null);
        Long maxResultSetSize = maxResultSetSizeStr == null ? null : Long.valueOf(Long.parseLong(maxResultSetSizeStr));
        Config config = SparqlifyCliHelper.parseSmlConfigs(commandLine, (Logger)loggerCount);
        Main.onErrorPrintHelpAndExit(cliOptions, loggerCount, -1);
        DataSource dataSource = SparqlifyCliHelper.parseDataSource(commandLine, (Logger)loggerCount);
        Main.onErrorPrintHelpAndExit(cliOptions, loggerCount, -1);
        RdfViewSystemOld.initSparqlifyFunctions();
        ExprRewriteSystem ers = SparqlifyUtils.createExprRewriteSystem();
        TypeSystem typeSystem = ers.getTypeSystem();
        Map typeAlias = MapReader.readFromResource((String)"/type-map.h2.tsv");
        Connection conn = dataSource.getConnection();
        try {
            SchemaProviderImpl schemaProvider = new SchemaProviderImpl(conn, typeSystem, typeAlias);
            SyntaxBridge syntaxBridge = new SyntaxBridge(schemaProvider);
            MappingOps mappingOps = SparqlifyUtils.createDefaultMappingOps(ers);
            OpMappingRewriterImpl opMappingRewriter = new OpMappingRewriterImpl(mappingOps);
            CandidateViewSelectorImpl candidateViewSelector = new CandidateViewSelectorImpl(mappingOps, new ViewDefinitionNormalizerImpl());
            ConfiguratorCandidateSelector.configure(config, syntaxBridge, candidateViewSelector, (Logger)loggerCount);
        }
        finally {
            conn.close();
        }
        logger.info("Errors: " + loggerCount.getErrorCount() + ", Warnings: " + loggerCount.getWarningCount());
        if (loggerCount.getErrorCount() > 0) {
            throw new RuntimeException("Encountered " + loggerCount.getErrorCount() + " errors that need to be fixed first.");
        }
        QueryExecutionFactoryEx qef = SparqlifyUtils.createDefaultSparqlifyEngine(dataSource, config, maxResultSetSize, maxQueryExecutionTime);
        if (isDump) {
            if (outputFormat.equals("nquads")) {
                Iterator itQuad = QueryExecutionUtils.createIteratorDumpQuads((QueryExecutionFactory)qef);
                NQuadsWriter.write((OutputStream)System.out, (Iterator)itQuad);
            } else {
                Iterator itTriple = QueryExecutionUtils.createIteratorDumpTriples((QueryExecutionFactory)qef);
                NTriplesWriter.write((OutputStream)System.out, (Iterator)itTriple);
            }
            return;
        }
        if (queryString != null) {
            QueryExecution qe;
            QueryEx queryEx = QueryFactoryEx.create(queryString);
            if (queryEx.isSelectType()) {
                qe = qef.createQueryExecution(queryEx);
                ResultSet rs = qe.execSelect();
                System.out.println(ResultSetFormatter.asText((ResultSet)rs));
            } else if (queryEx.isConstructType()) {
                qe = qef.createQueryExecution(queryString);
                Iterator it = qe.execConstructTriples();
                SparqlFormatterUtils.writeText((OutputStream)System.out, it);
            } else {
                throw new RuntimeException("Query type not supported: " + queryString);
            }
            return;
        }
        Server server = Main.createSparqlEndpoint(qef, port);
        server.start();
    }

    public static Server createSparqlEndpoint(QueryExecutionFactoryEx qef, int port) throws Exception {
        HttpSparqlEndpoint.sparqler = qef;
        ServletHolder sh = new ServletHolder(ServletContainer.class);
        sh.setInitParameter("com.sun.jersey.config.property.resourceConfigClass", "com.sun.jersey.api.core.PackagesResourceConfig");
        sh.setInitParameter("com.sun.jersey.config.property.packages", "org.aksw.sparqlify.web");
        Server server = new Server(port);
        ServletContextHandler context = new ServletContextHandler((HandlerContainer)server, "/", 1);
        context.getServletContext().setAttribute("queryExecutionFactory", (Object)qef);
        context.addServlet(sh, "/*");
        return server;
    }
}

