/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.aksw.sparqlify.util.CollectionFactory;
import org.aksw.sparqlify.util.CollectionFactoryArrayList;
import org.aksw.sparqlify.util.ExprAccessor;

public class CnfTransformer<T> {
    private ExprAccessor<T> accessor;

    public CnfTransformer(ExprAccessor<T> accessor) {
        this.accessor = accessor;
    }

    public T eval(T expr) {
        T result = CnfTransformer.eval(expr, this.accessor);
        return result;
    }

    public static <T> T eval(T expr, ExprAccessor<T> accessor) {
        Object result;
        if (accessor.isLogicalNot(expr)) {
            T newExpr;
            T child = accessor.getArg(expr);
            if (accessor.isLogicalAnd(child)) {
                newExpr = accessor.createLogicalOr(CnfTransformer.eval(accessor.createLogicalNot(accessor.getArg1(child)), accessor), CnfTransformer.eval(accessor.createLogicalNot(accessor.getArg2(child)), accessor));
            } else if (accessor.isLogicalOr(child)) {
                newExpr = accessor.createLogicalAnd(CnfTransformer.eval(accessor.createLogicalNot(accessor.getArg(child)), accessor), CnfTransformer.eval(accessor.createLogicalNot(accessor.getArg(child)), accessor));
            } else if (accessor.isLogicalNot(child)) {
                newExpr = CnfTransformer.eval(accessor.getArg(child), accessor);
            } else {
                return expr;
            }
            result = CnfTransformer.eval(newExpr, accessor);
        } else if (accessor.isLogicalAnd(expr)) {
            result = accessor.createLogicalAnd(CnfTransformer.eval(accessor.getArg1(expr), accessor), CnfTransformer.eval(accessor.getArg2(expr), accessor));
        } else if (accessor.isLogicalOr(expr)) {
            T aa = CnfTransformer.eval(accessor.getArg1(expr), accessor);
            T bb = CnfTransformer.eval(accessor.getArg2(expr), accessor);
            Object a = null;
            Object b = null;
            if (accessor.isLogicalAnd(aa)) {
                a = aa;
                b = bb;
            } else if (accessor.isLogicalAnd(bb)) {
                a = bb;
                b = aa;
            }
            result = a == null ? accessor.createLogicalOr(aa, bb) : accessor.createLogicalAnd(CnfTransformer.eval(accessor.createLogicalOr(accessor.getArg1(a), b), accessor), CnfTransformer.eval(accessor.createLogicalOr(accessor.getArg2(a), b), accessor));
        } else {
            result = expr;
        }
        return result;
    }

    public static <T> List<Collection<T>> toCnf(T expr, ExprAccessor<T> accessor) {
        List<Collection<T>> result = CnfTransformer.toCnf(Collections.singleton(expr), accessor);
        return result;
    }

    public static <T> List<Collection<T>> toCnf(Iterable<T> exprs, ExprAccessor<T> accessor) {
        ArrayList<Collection<T>> result = new ArrayList<Collection<T>>();
        CollectionFactoryArrayList clauseFactory = new CollectionFactoryArrayList();
        for (T expr : exprs) {
            T tmp = CnfTransformer.eval(expr, accessor);
            CnfTransformer.collectAnd(tmp, result, accessor, clauseFactory);
        }
        return result;
    }

    public static <T> List<Collection<T>> cnfToClauses(Iterable<T> exprs, ExprAccessor<T> accessor) {
        ArrayList<Collection<T>> result = new ArrayList<Collection<T>>();
        CollectionFactoryArrayList clauseFactory = new CollectionFactoryArrayList();
        for (T expr : exprs) {
            CnfTransformer.collectAnd(expr, result, accessor, clauseFactory);
        }
        return result;
    }

    public static <T> void collectAnd(T expr, Collection<Collection<T>> clauses, ExprAccessor<T> accessor, CollectionFactory<T> clauseFactory) {
        if (accessor.isLogicalAnd(expr)) {
            CnfTransformer.collectAnd(accessor.getArg1(expr), clauses, accessor, clauseFactory);
            CnfTransformer.collectAnd(accessor.getArg2(expr), clauses, accessor, clauseFactory);
        } else if (accessor.isLogicalOr(expr)) {
            Collection<T> ors = clauseFactory.newCollection();
            CnfTransformer.collectOr(expr, ors, accessor);
            clauses.add(ors);
        } else {
            Collection<T> ors = clauseFactory.newCollection();
            ors.add(expr);
            clauses.add(ors);
        }
    }

    public static <T> void collectOr(T expr, Collection<T> clause, ExprAccessor<T> accessor) {
        if (accessor.isLogicalOr(expr)) {
            CnfTransformer.collectOr(accessor.getArg1(expr), clause, accessor);
            CnfTransformer.collectOr(accessor.getArg2(expr), clause, accessor);
        } else {
            clause.add(expr);
        }
    }
}

