/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.database;

import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpVisitor;
import com.hp.hpl.jena.sparql.algebra.Transform;
import com.hp.hpl.jena.sparql.algebra.op.Op1;
import com.hp.hpl.jena.sparql.util.NodeIsomorphismMap;
import org.aksw.sparqlify.database.OpExtFilterIndexed;
import org.aksw.sparqlify.restriction.RestrictionManagerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpFilterIndexed
extends Op1 {
    private static final Logger logger = LoggerFactory.getLogger(OpFilterIndexed.class);
    protected RestrictionManagerImpl restrictions;
    private static boolean hackWarningDisplayed = false;

    public RestrictionManagerImpl getRestrictions() {
        return this.restrictions;
    }

    public OpFilterIndexed(Op subOp, RestrictionManagerImpl restrictions) {
        super(subOp);
        this.restrictions = restrictions;
    }

    public void visit(OpVisitor opVisitor) {
        if (!hackWarningDisplayed) {
            logger.warn("[HACK] Replace OpFilterIndexed with OpExtFilterIndexed");
            hackWarningDisplayed = true;
        }
        OpExtFilterIndexed tmp = new OpExtFilterIndexed(this.getSubOp(), this.getRestrictions());
        tmp.visit(opVisitor);
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public Op apply(Transform transform, Op subOp) {
        return null;
    }

    public Op1 copy(Op subOp) {
        return OpFilterIndexed.filter(new RestrictionManagerImpl(this.restrictions), subOp);
    }

    public int hashCode() {
        return 17 * this.getSubOp().hashCode() + 13 * this.restrictions.hashCode();
    }

    public boolean equalTo(Op other, NodeIsomorphismMap labelMap) {
        if (!(other instanceof OpFilterIndexed)) {
            return false;
        }
        OpFilterIndexed opFilter = (OpFilterIndexed)other;
        if (!this.restrictions.equals(opFilter.restrictions)) {
            return false;
        }
        return this.getSubOp().equalTo(opFilter.getSubOp(), labelMap);
    }

    public static OpFilterIndexed filter(RestrictionManagerImpl restrictions, Op subOp) {
        return new OpFilterIndexed(subOp, restrictions);
    }
}

