/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.database;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.sparqlify.database.Column;
import org.aksw.sparqlify.database.Constraint;
import org.aksw.sparqlify.database.Index;
import org.aksw.sparqlify.database.IndexCandidate;
import org.aksw.sparqlify.database.IndexMap;
import org.aksw.sparqlify.database.IndexMetaNode;
import org.aksw.sparqlify.database.MapStoreAccessor;
import org.aksw.sparqlify.database.RowRechecker;

public class IndexCollection<T>
extends AbstractCollection<Index<T>> {
    private List<Index<T>> indexes = new ArrayList<Index<T>>();

    @Override
    public boolean add(Index<T> index) {
        return this.indexes.add(index);
    }

    public void getRows(Map<String, Constraint> constraints, IndexMetaNode node, List<Integer> path) {
    }

    public Collection<List<Object>> get(Map<String, Constraint> constraints, IndexMap<String, Column> columns) {
        Index<T> bestMatch = null;
        IndexCandidate bestCandidate = null;
        for (Index<T> index : this.indexes) {
            IndexCandidate candidate = this.get(Collections.singletonList(index.getRoot()), 0, 0, constraints);
            if (candidate == null || bestCandidate != null && candidate.columnDepth <= bestCandidate.columnDepth && (candidate.columnDepth != bestCandidate.columnDepth || candidate.nodeDepth >= bestCandidate.nodeDepth)) continue;
            bestCandidate = candidate;
            bestMatch = index;
        }
        HashMap<String, Constraint> recheck = new HashMap<String, Constraint>(constraints);
        IndexCandidate node = bestCandidate;
        while (node != null) {
            for (String columnName : node.node.getColumnNames()) {
                recheck.remove(columnName);
            }
            node = node.child;
        }
        RowRechecker rechecker = null;
        if (!recheck.isEmpty()) {
            HashMap<Integer, Constraint> recheckIndex = new HashMap<Integer, Constraint>();
            for (Map.Entry entry : recheck.entrySet()) {
                int index = columns.getIndex((String)entry.getKey());
                recheckIndex.put(index, (Constraint)entry.getValue());
            }
            rechecker = new RowRechecker(recheckIndex);
        }
        if (bestMatch == null) {
            if (this.indexes.isEmpty()) {
                throw new RuntimeException("No store or index found for lookup.");
            }
            bestMatch = this.indexes.iterator().next();
        }
        Collection<List<Object>> result = this.execute(bestMatch, bestCandidate, rechecker);
        return result;
    }

    public Collection<List<Object>> execute(Index index, IndexCandidate pathNode, RowRechecker rechecker) {
        HashSet<List<Object>> result = new HashSet<List<Object>>();
        if (pathNode == null) {
            this.collectRows(index.getStore(), Collections.singleton(index.getRoot()), result, rechecker);
        } else {
            this._execute(index.getStore(), pathNode, result, rechecker);
        }
        return result;
    }

    public void _execute(Object store, IndexCandidate pathNode, Collection<List<Object>> result, RowRechecker rechecker) {
        IndexMetaNode node = pathNode.node;
        MapStoreAccessor accessor = node.getFactory();
        Collection<Object> values = accessor.lookup(store, pathNode.constraints.iterator().next());
        if (pathNode.child == null) {
            for (Object value : values) {
                this.collectRows(value, node.getChildren(), result, rechecker);
            }
        } else {
            switch (node.getChildren().size()) {
                case 0: {
                    for (Object value : values) {
                        List rows = (List)value;
                        if (rows == null) continue;
                        result.addAll(rows);
                    }
                    break;
                }
                case 1: {
                    for (Object value : values) {
                        this._execute(value, pathNode.child, result, rechecker);
                    }
                    break;
                }
                default: {
                    for (Object value : values) {
                        List stores = (List)value;
                        this._execute(stores.get(pathNode.childIndex), pathNode.child, result, rechecker);
                    }
                    break;
                }
            }
        }
    }

    private void collectRows(Object store, Collection<IndexMetaNode> nodes, Collection<List<Object>> result, RowRechecker rechecker) {
        switch (nodes.size()) {
            case 0: {
                Collection rows = (Collection)store;
                if (rows == null) break;
                if (rechecker == null) {
                    result.addAll(rows);
                    break;
                }
                for (List row : rows) {
                    if (!rechecker.isAccepted(row)) continue;
                    result.add(row);
                }
                break;
            }
            case 1: {
                IndexMetaNode subNode = nodes.iterator().next();
                Collection<Object> values = subNode.getFactory().list(store);
                for (Object value : values) {
                    this.collectRows(value, subNode.getChildren(), result, rechecker);
                }
                break;
            }
            default: {
                List stores = (List)store;
                IndexMetaNode subNodeN = nodes.iterator().next();
                Collection<Object> valuesN = subNodeN.getFactory().list(stores.get(0));
                for (Object value : valuesN) {
                    this.collectRows(value, subNodeN.getChildren(), result, rechecker);
                }
            }
        }
    }

    public IndexCandidate get(List<IndexMetaNode> nodes, int baseNodeDepth, int baseColumnDepth, Map<String, Constraint> constraints) {
        Set<String> columnNames = constraints.keySet();
        IndexCandidate bestCandidate = null;
        int childIndex = 0;
        for (IndexMetaNode node : nodes) {
            IndexCandidate bestChild;
            int columnDepth = baseNodeDepth;
            int nodeDepth = baseColumnDepth;
            List<String> idxColNames = node.getColumnNames();
            if (!columnNames.containsAll(idxColNames)) continue;
            HashSet requiredConstraintClasses = new HashSet();
            for (String idxColName : idxColNames) {
                requiredConstraintClasses.add(constraints.get(idxColName).getClass());
            }
            if (!node.getFactory().getSupportedConstraintClasses().containsAll(requiredConstraintClasses)) continue;
            ArrayList<Constraint> cs = new ArrayList<Constraint>(idxColNames.size());
            for (String idxColName : idxColNames) {
                cs.add(constraints.get(idxColName));
            }
            IndexCandidate thisCandidate = new IndexCandidate(node, columnDepth += idxColNames.size(), ++nodeDepth, childIndex, cs);
            if (!node.getChildren().isEmpty() && (bestChild = this.get(node.getChildren(), nodeDepth, columnDepth, constraints)) != null) {
                thisCandidate.columnDepth = bestChild.columnDepth;
                thisCandidate.nodeDepth = bestChild.nodeDepth;
                thisCandidate.child = bestChild;
            }
            if (bestCandidate == null || thisCandidate.columnDepth > bestCandidate.columnDepth || thisCandidate.columnDepth == bestCandidate.columnDepth && thisCandidate.nodeDepth < bestCandidate.nodeDepth) {
                bestCandidate = thisCandidate;
            }
            ++childIndex;
        }
        return bestCandidate;
    }

    @Override
    public Iterator<Index<T>> iterator() {
        return this.indexes.iterator();
    }

    @Override
    public int size() {
        return this.indexes.size();
    }
}

