/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.database;

import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.expr.Expr;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import org.aksw.commons.collections.CartesianProduct;
import org.aksw.commons.collections.FlatMapView;
import org.aksw.sparqlify.database.Clause;
import org.aksw.sparqlify.database.Dnf;
import sparql.DnfUtils;

public class ExprIndex {
    private ExprIndex parent;
    private Set<Clause> effectiveClauses;
    private NavigableMap<Integer, Set<Dnf>> dnfGroups = new TreeMap<Integer, Set<Dnf>>();
    private Collection<Dnf> dnfs = new FlatMapView(this.dnfGroups.values());
    private Set<Var> varsMentioned = new HashSet<Var>();

    public void getEffectiveDnf(Collection<Var> vars) {
    }

    public void calcEffectiveClauses(List<Dnf> dnfs, int index, Set<Clause> blacklist, Clause parentClause, Set<Clause> result) {
        if (index >= dnfs.size()) {
            if (parentClause != null) {
                result.add(parentClause);
            }
            return;
        }
        Dnf dnf = dnfs.get(index);
        for (Clause clause : dnf.getClauses()) {
            Clause merged;
            if (blacklist.contains(clause)) continue;
            if (parentClause == null) {
                merged = parentClause;
                continue;
            }
            HashSet<Expr> exprs = new HashSet<Expr>(parentClause.getExprs());
            exprs.addAll(clause.getExprs());
            merged = new Clause(exprs);
            this.calcEffectiveClauses(dnfs, index + 1, blacklist, merged, result);
        }
    }

    public Set<Clause> calcEffectiveClauses() {
        HashSet<Clause> result = new HashSet<Clause>();
        ArrayList<Collection<Clause>> tmp = new ArrayList<Collection<Clause>>();
        for (Dnf dnf : this.dnfs) {
            tmp.add(dnf.getClauses());
        }
        CartesianProduct cartesian = CartesianProduct.create(tmp);
        for (List list : cartesian) {
            HashSet<Expr> exprs = new HashSet<Expr>();
            for (Clause c : list) {
                exprs.addAll(c.getExprs());
            }
            result.add(new Clause(exprs));
        }
        return result;
    }

    public Set<Clause> getEffectiveClauses() {
        return this.effectiveClauses;
    }

    public ExprIndex() {
    }

    public ExprIndex(ExprIndex parent) {
        this.parent = parent;
    }

    public ExprIndex(ExprIndex parent, Iterable<Expr> exprs) {
        this.parent = parent;
        this.addAll(exprs);
    }

    public ExprIndex(Set<Dnf> dnfs) {
        this.addAll((Collection<Dnf>)dnfs);
    }

    public ExprIndex getParent() {
        return this.parent;
    }

    public Collection<Dnf> getDnf() {
        return this.dnfs;
    }

    public Set<Var> getVarsMentioned() {
        return this.varsMentioned;
    }

    void add(Dnf dnf) {
        int n = dnf.getClauses().size();
        HashSet<Dnf> set = (HashSet<Dnf>)this.dnfGroups.get(n);
        if (set == null) {
            set = new HashSet<Dnf>();
            this.dnfGroups.put(n, set);
        }
        set.add(dnf);
        this.varsMentioned.addAll(dnf.getVarsMentioned());
        this.effectiveClauses = this.calcEffectiveClauses();
    }

    void addAll(Collection<Dnf> dnfs) {
        for (Dnf dnf : dnfs) {
            this.add(dnf);
        }
    }

    void add(Expr expr) {
        Dnf dnf = DnfUtils.toDnf(expr);
        this.add(dnf);
    }

    public Set<Clause> getAllClausesWith(Var var) {
        HashSet<Clause> result = new HashSet<Clause>();
        for (Set dnfGroup : this.dnfGroups.values()) {
            for (Dnf dnf : dnfGroup) {
                Collection<Clause> clauses = dnf.get(var);
                result.addAll(clauses);
            }
        }
        return result;
    }

    public Set<Clause> getAllSingleVarExprs(Var var) {
        HashSet<Clause> result = new HashSet<Clause>();
        for (Set dnfGroup : this.dnfGroups.values()) {
            for (Dnf dnf : dnfGroup) {
                Set<Clause> clauses = dnf.get(Collections.singleton(var));
                result.addAll(clauses);
            }
        }
        return result;
    }

    public void addAll(Iterable<Expr> exprs) {
        for (Expr expr : exprs) {
            this.add(expr);
        }
    }

    public String toString() {
        return this.dnfs.toString();
    }

    public ExprIndex filterByVars(Set<Var> requiredVars) {
        ExprIndex result = new ExprIndex();
        for (Set dnfGroup : this.dnfGroups.values()) {
            for (Dnf dnf : dnfGroup) {
                Set<Clause> clauses = dnf.filterByVars(requiredVars);
                Dnf filteredDnf = new Dnf(clauses);
                result.add(filteredDnf);
            }
        }
        return result;
    }
}

