/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.datatypes;

import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.expr.Expr;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.sparqlify.algebra.sparql.transform.NodeExprSubstitutor;

public class SparqlSqlFunction {
    private List<Var> paramVars;
    private Expr expr;

    public SparqlSqlFunction(List<Var> paramVars, Expr expr) {
        this.paramVars = paramVars;
        this.expr = expr;
        assert (SparqlSqlFunction.isValid(paramVars, expr)) : "paramVars must be a subset of expr vars";
    }

    public List<Var> getParamVars() {
        return this.paramVars;
    }

    public Expr getExpr() {
        return this.expr;
    }

    public static boolean isValid(List<Var> paramVars, Expr expr) {
        Set exprVars = expr.getVarsMentioned();
        boolean result = exprVars.containsAll(paramVars);
        return result;
    }

    public Expr instanciate(List<Expr> args) {
        if (args.size() != this.paramVars.size()) {
            throw new IllegalArgumentException("Invalid number of args. Expected: " + this.paramVars + ", got: " + args);
        }
        HashMap<Var, Expr> binding = new HashMap<Var, Expr>();
        for (int i = 0; i < this.paramVars.size(); ++i) {
            Var var = this.paramVars.get(i);
            Expr arg = args.get(i);
            binding.put(var, arg);
        }
        Expr result = this.instanciate(binding);
        return result;
    }

    public Expr instanciate(Map<Var, Expr> binding) {
        NodeExprSubstitutor substitutor = new NodeExprSubstitutor(binding);
        Expr result = substitutor.transformMM(this.expr);
        return result;
    }
}

