/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.algorithms;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.aksw.commons.factory.Factory1;
import org.aksw.sparqlify.algebra.sql.exprs2.SqlExpr;
import org.aksw.sparqlify.algebra.sql.exprs2.SqlExprFunction;

public class SqlExprSubstitutor2 {
    public static List<Collection<SqlExpr>> substitute(List<Collection<SqlExpr>> nf, Factory1<SqlExpr> postTraversalTransformer) {
        ArrayList<Collection<SqlExpr>> result = new ArrayList<Collection<SqlExpr>>();
        for (Collection<SqlExpr> clause : nf) {
            List<SqlExpr> newClause = SqlExprSubstitutor2.substitute(clause, postTraversalTransformer);
            result.add(newClause);
        }
        return result;
    }

    public static List<SqlExpr> substitute(Collection<SqlExpr> exprs, Factory1<SqlExpr> postTraversalTransformer) {
        ArrayList<SqlExpr> result = new ArrayList<SqlExpr>(exprs.size());
        for (SqlExpr expr : exprs) {
            SqlExpr newExpr = SqlExprSubstitutor2.substitute(expr, postTraversalTransformer);
            result.add(newExpr);
        }
        return result;
    }

    public static SqlExpr substitute(SqlExpr expr, Factory1<SqlExpr> postTraversalTransformer) {
        SqlExpr result;
        if (expr == null) {
            System.out.println("Null expr");
        }
        assert (expr != null) : "Expr must not be null";
        assert (expr.getType() != null) : "Type of exprs must not be null";
        switch (expr.getType()) {
            case Constant: {
                result = postTraversalTransformer.create(expr);
                break;
            }
            case Function: {
                SqlExprFunction fn = expr.asFunction();
                List<SqlExpr> args = fn.getArgs();
                assert (!Iterables.contains(args, null)) : "Null argument in expr: " + fn;
                List<SqlExpr> newArgs = SqlExprSubstitutor2.substitute(args, postTraversalTransformer);
                SqlExprFunction tmp = fn.copy(newArgs);
                result = postTraversalTransformer.create(tmp);
                break;
            }
            case Variable: {
                result = postTraversalTransformer.create(expr);
                break;
            }
            default: {
                throw new RuntimeException("Should not happen");
            }
        }
        return result;
    }
}

