/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.algorithms;

import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprFunction;
import java.util.ArrayList;
import java.util.List;
import org.aksw.sparqlify.core.algorithms.ExprTransformer;
import org.aksw.sparqlify.trash.ExprCopy;

public abstract class ExprTransformerBase
implements ExprTransformer {
    @Override
    public Expr transform(ExprFunction fn) {
        List args = fn.getArgs();
        ArrayList<Expr> newArgs = new ArrayList<Expr>(args.size());
        for (Expr arg : args) {
            Expr newArg = this.transformArg(arg);
            newArgs.add(newArg);
        }
        Expr result = this.buildExpr(fn, newArgs);
        return result;
    }

    protected Expr transformArg(Expr expr) {
        return expr;
    }

    protected Expr buildExpr(ExprFunction originalExpr, List<Expr> newArgs) {
        Expr result = ExprCopy.getInstance().copy(originalExpr, newArgs);
        return result;
    }
}

