/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.algorithms;

import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprFunction2;
import java.util.HashMap;
import java.util.Map;
import org.aksw.commons.factory.Factory2;
import org.aksw.sparqlify.core.algorithms.ExprFactory_Copy2;
import org.aksw.sparqlify.core.algorithms.ExprFactory_GreaterThan;
import org.aksw.sparqlify.core.algorithms.ExprFactory_GreaterThanOrEqual;
import org.aksw.sparqlify.core.algorithms.ExprFactory_LessThan;
import org.aksw.sparqlify.core.algorithms.ExprFactory_LessThanOrEqual;
import org.aksw.sparqlify.core.algorithms.ExprFactory_LogicalAnd;
import org.aksw.sparqlify.core.algorithms.ExprFactory_LogicalOr;

public class ExprFactoryUtils {
    private static final Map<String, Factory2<Expr>> binaryFactories = new HashMap<String, Factory2<Expr>>();
    public static final Factory2<Expr> factoryLogicalAnd = new ExprFactory_LogicalAnd();
    public static final Factory2<Expr> factoryLogicalOr = new ExprFactory_LogicalOr();
    public static final Factory2<Expr> factoryLessThan = new ExprFactory_LessThan();
    public static final Factory2<Expr> factoryLessThanOrEqual = new ExprFactory_LessThanOrEqual();
    public static final Factory2<Expr> factoryGreaterThanOrEqual = new ExprFactory_GreaterThanOrEqual();
    public static final Factory2<Expr> factoryGreaterThan = new ExprFactory_GreaterThan();

    public static Factory2<Expr> getFactory2(String tag) {
        Factory2<Expr> result = binaryFactories.get(tag);
        return result;
    }

    public static Factory2<Expr> createCopyFactory2(ExprFunction2 prototype) {
        ExprFactory_Copy2 result = new ExprFactory_Copy2(prototype);
        return result;
    }

    static {
        binaryFactories.put("<", factoryLessThan);
        binaryFactories.put("<=", factoryLessThanOrEqual);
        binaryFactories.put(">=", factoryGreaterThanOrEqual);
        binaryFactories.put(">", factoryGreaterThan);
    }
}

