/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.batch;

import com.google.common.collect.Multimap;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.core.QuadPattern;
import com.hp.hpl.jena.sparql.core.Var;
import java.util.List;
import javax.sql.DataSource;
import org.aksw.commons.util.strings.StringUtils;
import org.aksw.jena_sparql_api.utils.TripleUtils;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOp;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOpQuery;
import org.aksw.sparqlify.batch.RowMapperSparqlify;
import org.aksw.sparqlify.core.domain.input.Mapping;
import org.aksw.sparqlify.core.domain.input.RestrictedExpr;
import org.aksw.sparqlify.core.domain.input.ViewDefinition;
import org.aksw.sparqlify.core.interfaces.SqlOpSelectBlockCollector;
import org.aksw.sparqlify.core.interfaces.SqlOpSerializer;
import org.aksw.sparqlify.core.sparql.RowMapperSparqlifyCombined;
import org.springframework.batch.core.step.item.ChunkOrientedTasklet;
import org.springframework.batch.core.step.item.ChunkProcessor;
import org.springframework.batch.core.step.item.ChunkProvider;
import org.springframework.batch.core.step.item.SimpleChunkProcessor;
import org.springframework.batch.core.step.item.SimpleChunkProvider;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.item.database.JdbcCursorItemReader;
import org.springframework.batch.item.file.FlatFileItemWriter;
import org.springframework.batch.item.file.transform.LineAggregator;
import org.springframework.batch.item.file.transform.PassThroughLineAggregator;
import org.springframework.batch.repeat.CompletionPolicy;
import org.springframework.batch.repeat.RepeatOperations;
import org.springframework.batch.repeat.policy.SimpleCompletionPolicy;
import org.springframework.batch.repeat.support.RepeatTemplate;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.core.RowMapper;

class TaskletFactoryDump {
    private DataSource dataSource;
    private SqlOpSelectBlockCollector sqlOpSelectBlockCollector;
    private SqlOpSerializer sqlOpSerializer;
    private String outBaseDir = "/tmp/";

    public TaskletFactoryDump(DataSource dataSource, SqlOpSelectBlockCollector sqlOpSelectBlockCollector, SqlOpSerializer sqlOpSerializer, String outBaseDir, List<ViewDefinition> viewDefinitions) {
        this.dataSource = dataSource;
        this.sqlOpSelectBlockCollector = sqlOpSelectBlockCollector;
        this.sqlOpSerializer = sqlOpSerializer;
        this.outBaseDir = outBaseDir;
    }

    public Tasklet createTasklet(ViewDefinition viewDefinition) {
        QuadPattern template = viewDefinition.getTemplate();
        Mapping mapping = viewDefinition.getMapping();
        SqlOp sqlOp = mapping.getSqlOp();
        Multimap<Var, RestrictedExpr> sparqlVarMap = viewDefinition.getVarDefinition().getMap();
        SqlOp tmp = sqlOp instanceof SqlOpQuery ? sqlOp : this.sqlOpSelectBlockCollector.transform(sqlOp);
        String sqlStr = this.sqlOpSerializer.serialize(tmp);
        System.out.println(sqlStr);
        String baseName = StringUtils.urlEncode((String)viewDefinition.getName());
        String outFileName = this.outBaseDir + baseName + ".nt";
        FileSystemResource outResource = new FileSystemResource(this.outBaseDir + outFileName);
        System.out.println(outFileName);
        Tasklet result = TaskletFactoryDump.createTasklet(this.dataSource, template, sparqlVarMap, sqlStr, (Resource)outResource);
        return result;
    }

    public static Tasklet createTasklet(DataSource dataSource, QuadPattern template, Multimap<Var, RestrictedExpr> sparqlVarMap, String sqlStr, Resource outResource) {
        Tasklet result;
        try {
            result = TaskletFactoryDump._createTasklet(dataSource, template, sparqlVarMap, sqlStr, outResource);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public static Tasklet _createTasklet(DataSource dataSource, QuadPattern template, Multimap<Var, RestrictedExpr> sparqlVarMap, String sqlStr, Resource outResource) throws Exception {
        RowMapperSparqlifyCombined coreRowMapper = new RowMapperSparqlifyCombined(sparqlVarMap);
        RowMapperSparqlify rowMapper = new RowMapperSparqlify(coreRowMapper, template);
        JdbcCursorItemReader itemReader = new JdbcCursorItemReader();
        itemReader.setSql(sqlStr);
        itemReader.setDataSource(dataSource);
        itemReader.setRowMapper((RowMapper)rowMapper);
        itemReader.afterPropertiesSet();
        ExecutionContext executionContext = new ExecutionContext();
        itemReader.open(executionContext);
        FlatFileItemWriter itemWriter = new FlatFileItemWriter();
        itemWriter.setLineAggregator((LineAggregator)new PassThroughLineAggregator());
        itemWriter.setResource(outResource);
        itemWriter.afterPropertiesSet();
        itemWriter.open(executionContext);
        int commitInterval = 50000;
        SimpleCompletionPolicy completionPolicy = new SimpleCompletionPolicy(commitInterval);
        RepeatTemplate repeatTemplate = new RepeatTemplate();
        repeatTemplate.setCompletionPolicy((CompletionPolicy)completionPolicy);
        RepeatTemplate repeatOperations = repeatTemplate;
        SimpleChunkProvider chunkProvider = new SimpleChunkProvider((ItemReader)itemReader, (RepeatOperations)repeatOperations);
        ItemProcessor<QuadPattern, String> itemProcessor = new ItemProcessor<QuadPattern, String>(){

            public String process(QuadPattern quadPattern) throws Exception {
                String result = "";
                for (Quad quad : quadPattern.getList()) {
                    Triple triple = quad.asTriple();
                    String tmp = TripleUtils.toNTripleString((Triple)triple);
                    if (!result.isEmpty()) {
                        result = result + "\n";
                    }
                    result = result + tmp;
                }
                return result;
            }
        };
        SimpleChunkProcessor chunkProcessor = new SimpleChunkProcessor((ItemProcessor)itemProcessor, (ItemWriter)itemWriter);
        ChunkOrientedTasklet tasklet = new ChunkOrientedTasklet((ChunkProvider)chunkProvider, (ChunkProcessor)chunkProcessor);
        return tasklet;
    }
}

