/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.algebra.sql.nodes;

import com.hp.hpl.jena.sdb.core.JoinType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.aksw.sparqlify.algebra.sql.exprs2.SqlExpr;
import org.aksw.sparqlify.algebra.sql.nodes.Schema;
import org.aksw.sparqlify.algebra.sql.nodes.SchemaImpl;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOp;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOpBase2;
import org.aksw.sparqlify.core.TypeToken;
import org.apache.jena.atlas.io.IndentedWriter;

public class SqlOpJoin
extends SqlOpBase2 {
    private JoinType joinType;
    private List<SqlExpr> conditions;

    public SqlOpJoin(Schema schema, JoinType joinType, SqlOp left, SqlOp right) {
        this(schema, joinType, left, right, new ArrayList<SqlExpr>());
    }

    public SqlOpJoin(Schema schema, JoinType joinType, SqlOp left, SqlOp right, List<SqlExpr> conditions) {
        super(schema, left, right);
        this.joinType = joinType;
        this.conditions = conditions;
    }

    public JoinType getJoinType() {
        return this.joinType;
    }

    public List<SqlExpr> getConditions() {
        return this.conditions;
    }

    public static Schema createJoinSchema(Schema a, Schema b) {
        ArrayList<String> names = new ArrayList<String>();
        names.addAll(a.getColumnNames());
        names.addAll(b.getColumnNames());
        HashMap<String, TypeToken> typeMap = new HashMap<String, TypeToken>();
        typeMap.putAll(a.getTypeMap());
        typeMap.putAll(b.getTypeMap());
        SchemaImpl result = new SchemaImpl(names, typeMap);
        return result;
    }

    public static SqlOpJoin create(JoinType joinType, SqlOp a, SqlOp b) {
        SqlOpJoin result = SqlOpJoin.create(joinType, a, b, new ArrayList<SqlExpr>());
        return result;
    }

    public static SqlOpJoin create(JoinType joinType, SqlOp a, SqlOp b, List<SqlExpr> conditions) {
        Schema newSchema = SqlOpJoin.createJoinSchema(a.getSchema(), b.getSchema());
        SqlOpJoin result = new SqlOpJoin(newSchema, joinType, a, b, conditions);
        return result;
    }

    @Override
    public void write(IndentedWriter writer) {
        writer.println("SqlOpJoin " + this.joinType + "(");
        writer.incIndent();
        this.left.write(writer);
        writer.println(",");
        this.right.write(writer);
        writer.println();
        writer.decIndent();
        writer.print(")");
    }

    @Override
    public boolean isEmpty() {
        boolean result;
        switch (this.joinType) {
            case INNER: {
                boolean a = this.left.isEmpty();
                boolean b = this.right.isEmpty();
                result = a || b;
                break;
            }
            case LEFT: {
                result = this.left.isEmpty();
                break;
            }
            default: {
                throw new RuntimeException("Should not happen");
            }
        }
        return result;
    }
}

