/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.algebra.sql.exprs2;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import org.aksw.sparqlify.algebra.sql.exprs.SqlExprColumn;
import org.aksw.sparqlify.algebra.sql.exprs2.SqlExpr;
import org.aksw.sparqlify.algebra.sql.exprs2.SqlExprConstant;
import org.aksw.sparqlify.algebra.sql.exprs2.SqlExprFunction;
import org.aksw.sparqlify.algebra.sql.exprs2.SqlExprType;
import org.aksw.sparqlify.algebra.sql.exprs2.SqlExprVar;
import org.aksw.sparqlify.core.TypeToken;
import org.apache.jena.atlas.io.IndentedWriter;

public abstract class SqlExprBase
implements SqlExpr {
    protected final TypeToken datatype;

    public SqlExprBase(TypeToken datatype) {
        this.datatype = datatype;
        if (datatype == null) {
            throw new NullPointerException();
        }
    }

    @Override
    public boolean isVariable() {
        return SqlExprType.Variable.equals((Object)this.getType());
    }

    @Override
    public boolean isFunction() {
        return SqlExprType.Function.equals((Object)this.getType());
    }

    @Override
    public SqlExprFunction asFunction() {
        return (SqlExprFunction)((Object)this);
    }

    @Override
    public SqlExprConstant asConstant() {
        return (SqlExprConstant)((Object)this);
    }

    @Override
    public SqlExprVar asVariable() {
        return (SqlExprVar)((Object)this);
    }

    @Override
    public boolean isConstant() {
        return SqlExprType.Constant.equals((Object)this.getType());
    }

    @Override
    public TypeToken getDatatype() {
        return this.datatype;
    }

    public String toString() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IndentedWriter writer = new IndentedWriter((OutputStream)out);
        this.asString(writer);
        writer.flush();
        writer.close();
        return out.toString();
    }

    public static Set<SqlExprColumn> getColumnsMentioned(SqlExpr expr) {
        HashSet<SqlExprColumn> result = new HashSet<SqlExprColumn>();
        SqlExprBase._getColumnsMentioned(result, expr);
        return result;
    }

    public static void _getColumnsMentioned(Set<SqlExprColumn> result, SqlExpr expr) {
        if (expr instanceof SqlExprColumn) {
            result.add((SqlExprColumn)((Object)expr));
            return;
        }
        for (SqlExpr arg : expr.getArgs()) {
            SqlExprBase._getColumnsMentioned(result, arg);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.datatype == null ? 0 : this.datatype.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SqlExprBase other = (SqlExprBase)obj;
        return !(this.datatype == null ? other.datatype != null : !this.datatype.equals(other.datatype));
    }
}

