/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.algebra.sql.exprs2;

import java.util.List;
import org.aksw.sparqlify.algebra.sql.exprs2.SqlAggregator;
import org.aksw.sparqlify.algebra.sql.exprs2.SqlExpr;
import org.aksw.sparqlify.algebra.sql.exprs2.SqlExprFunction;
import org.aksw.sparqlify.core.TypeToken;
import org.aksw.sparqlify.expr.util.SqlExprUtils;
import org.apache.jena.atlas.io.IndentedWriter;

public class SqlAggFunction
implements SqlAggregator {
    private SqlExprFunction fn;

    public SqlAggFunction(SqlExprFunction fn) {
        this.fn = fn;
        if (fn.getArgs().size() > 1) {
            throw new RuntimeException("Aggregators may at most have 1 argument, got: " + fn.getArgs());
        }
    }

    @Override
    public SqlExpr getExpr() {
        List<SqlExpr> args = this.fn.getArgs();
        SqlExpr result = args.isEmpty() ? null : args.get(0);
        return result;
    }

    @Override
    public TypeToken getDatatype() {
        return this.fn.getDatatype();
    }

    public String toString() {
        return this.fn.toString();
    }

    @Override
    public void asString(IndentedWriter writer) {
        String str = this.toString();
        writer.print(str);
    }

    @Override
    public SqlAggFunction copy(SqlExpr arg) {
        SqlExprFunction cp = this.fn.copy(SqlExprUtils.exprToList(arg));
        SqlAggFunction result = new SqlAggFunction(cp);
        return result;
    }
}

