/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections.iterators;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.aksw.commons.collections.iterators.Descender;

public class DescenderIterator<T>
implements Iterator<List<T>> {
    private List<Collection<? extends T>> collections = new ArrayList<Collection<? extends T>>();
    private List<Iterator<? extends T>> iterators;
    private List<T> current;
    private List<T> result;
    private List<T> resultView;
    private Descender<T> descender;
    private boolean hasNext = true;

    public DescenderIterator(T base, Descender<T> descender) {
        this.descender = descender;
        Collection<T> collection = descender.getDescendCollection(base);
        if (collection == null || collection.isEmpty()) {
            this.hasNext = false;
            return;
        }
        this.collections.add(collection);
        this.init();
    }

    private void init() {
        this.iterators = new ArrayList<Iterator<? extends T>>();
        this.current = new ArrayList<T>();
        this.result = new ArrayList<T>();
        this.addIterator(this.collections.get(0).iterator());
        this.resultView = Collections.unmodifiableList(this.result);
    }

    public static <T> List<Integer> getIndexesOfEmptySubIterables(List<? extends Iterable<? extends T>> iterables) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = 0; i < iterables.size(); ++i) {
            Iterable<? extends T> iterable = iterables.get(i);
            if (!Iterables.isEmpty(iterable)) continue;
            result.add(i);
        }
        return result;
    }

    public boolean canDescend() {
        return this.iterators.size() < this.collections.size();
    }

    public void descend() {
        int index = this.iterators.size();
        if (index >= this.collections.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + " Size: " + this.collections.size());
        }
        Iterator<? extends T> it = this.collections.get(index).iterator();
        this.addIterator(it);
    }

    public void addIterator(Iterator<? extends T> it) {
        this.iterators.add(it);
        T item = it.next();
        this.current.add(item);
        Collection<T> collection = this.descender.getDescendCollection(item);
        if (collection != null && !collection.isEmpty()) {
            this.collections.add(collection);
        }
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    public List<T> peek() {
        this.adjustResultSize();
        for (int i = 0; i < this.current.size(); ++i) {
            this.result.set(i, this.current.get(i));
        }
        return this.result;
    }

    private void adjustResultSize() {
        while (this.result.size() < this.current.size()) {
            this.result.add(null);
        }
        while (this.result.size() > this.current.size()) {
            this.result.remove(this.result.size() - 1);
        }
    }

    @Override
    public List<T> next() {
        int i;
        if (!this.hasNext) {
            return null;
        }
        this.adjustResultSize();
        for (i = 0; i < this.current.size(); ++i) {
            this.result.set(i, this.current.get(i));
        }
        for (i = this.iterators.size() - 1; i >= 0; --i) {
            Iterator<T> it = this.iterators.get(i);
            if (!it.hasNext()) {
                if (i == 0) {
                    this.hasNext = false;
                    break;
                }
            } else {
                T item = it.next();
                this.current.set(i, item);
                Collection<T> collection = this.descender.getDescendCollection(item);
                if (collection == null || collection.isEmpty()) break;
                this.collections.add(collection);
                break;
            }
            this.iterators.remove(i);
            this.current.remove(i);
        }
        return this.resultView;
    }

    @Override
    public void remove() {
        throw new RuntimeException("Operation not supported");
    }
}

