/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.changesets;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.aksw.commons.collections.diff.Diff;
import org.aksw.commons.collections.diff.IDiff;
import org.aksw.commons.util.numbers.NumberChunker;

public class ChangesetRepository {
    private long minimumId = -1L;
    private File repositoryRoot;
    private long nextId;
    private List<Long> layout = new ArrayList<Long>();
    private Object formatter;

    public ChangesetRepository(File repositoryRoot) {
        this.layout.add(1000L);
        this.layout.add(1000L);
        this.repositoryRoot = repositoryRoot;
        this.load();
    }

    public long setNextId() {
        return this.nextId;
    }

    private void load() {
        Map.Entry<Long, File> next;
        File base = this.repositoryRoot;
        ArrayList<Long> chunks = new ArrayList<Long>();
        while ((next = ChangesetRepository.getDirectories(base).firstEntry()) != null) {
            chunks.add(next.getKey());
            base = next.getValue();
        }
        Map.Entry<Long, IDiff<File>> entry = ChangesetRepository.getFiles(base).firstEntry();
        if (entry == null) {
            throw new RuntimeException("Could not find a file in the repo. Make sure you do not have empty directories.");
        }
        chunks.add(entry.getKey());
        this.minimumId = ChangesetRepository.generateId(chunks, this.layout);
    }

    public static long generateId(List<Long> values, List<Long> layout) {
        if (values.size() != layout.size() && values.size() != layout.size() + 1) {
            throw new RuntimeException("Sizes are different");
        }
        long result = 0L;
        long base = 1L;
        for (int i = 0; i < values.size(); ++i) {
            result += values.get(i) * base;
            if (i >= layout.size()) continue;
            base *= layout.get(i).longValue();
        }
        return result;
    }

    public static Long getIdFromDirectory(File dir) {
        Long result = null;
        try {
            result = Long.parseLong(dir.getName());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return result;
    }

    public static Long getIdFromFile(File file) {
        Long result = null;
        String name = file.getName();
        int dotIndex = name.indexOf(46);
        if (dotIndex > 0) {
            String part = name.substring(0, dotIndex);
            try {
                result = Long.parseLong(part);
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        return result;
    }

    public static NavigableMap<Long, File> getDirectories(File dir) {
        TreeMap<Long, File> result = new TreeMap<Long, File>();
        for (File file : dir.listFiles()) {
            Long id;
            if (!file.isDirectory() || (id = ChangesetRepository.getIdFromDirectory(file)) == null) continue;
            result.put(id, file);
        }
        return result;
    }

    public static <T> IDiff<T> setAdded(IDiff<T> diff, T added) {
        if (diff.getAdded() != null) {
            throw new RuntimeException("Conflict between '" + diff.getAdded() + "' and '" + added + "'");
        }
        return new Diff(added, diff.getRemoved(), diff.getRetained());
    }

    public static <T> IDiff<T> setRemoved(IDiff<T> diff, T removed) {
        if (diff.getAdded() != null) {
            throw new RuntimeException("Conflict between '" + diff.getRemoved() + "' and '" + removed + "'");
        }
        return new Diff(removed, diff.getRemoved(), diff.getRetained());
    }

    public static NavigableMap<Long, IDiff<File>> getFiles(File dir) {
        TreeMap<Long, IDiff<File>> result = new TreeMap<Long, IDiff<File>>();
        for (File file : dir.listFiles()) {
            Long id;
            if (!file.isFile() || (id = ChangesetRepository.getIdFromFile(file)) == null) continue;
            IDiff diff = (IDiff)result.get(id);
            File added = null;
            File removed = null;
            if (file.getName().contains("added")) {
                added = file;
            } else {
                if (!file.getName().contains("removed")) continue;
                removed = file;
            }
            if (diff == null) {
                diff = new Diff((Object)added, (Object)removed, null);
            } else if (added != null) {
                if (diff.getAdded() != null) {
                    throw new RuntimeException("Conflict between '" + diff.getAdded() + "' and '" + added + "'");
                }
                diff = new Diff((Object)added, diff.getRemoved(), diff.getRetained());
            } else if (removed != null) {
                if (diff.getRemoved() != null) {
                    throw new RuntimeException("Conflict between '" + diff.getRemoved() + "' and '" + removed + "'");
                }
                diff = new Diff(diff.getAdded(), (Object)removed, diff.getRetained());
            } else {
                throw new RuntimeException("Should not happen");
            }
            result.put(id, (IDiff<File>)diff);
        }
        return result;
    }

    public long getMinimumId() {
        return this.minimumId;
    }

    public void getNextId() {
    }

    private String format(long id) {
        String result = Long.toString(id);
        if (id < 100L) {
            result = "0" + result;
        }
        if (id < 10L) {
            result = "0" + result;
        }
        return result;
    }

    String getFragment(long id) {
        List parts = NumberChunker.chunkValue((long)id, (long[])new long[]{1000L, 1000L});
        String fragment = "";
        for (Long part : parts) {
            fragment = fragment + "/" + this.format(part);
        }
        return fragment;
    }
}

