// $ANTLR 3.5 org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g 2015-01-14 00:14:39

    package org.aksw.sparqlify.config.lang;

    import com.hp.hpl.jena.sparql.expr.*;
    import org.apache.commons.lang.NotImplementedException;
    import com.hp.hpl.jena.graph.*;
    import com.hp.hpl.jena.vocabulary.*;
    import com.hp.hpl.jena.sparql.syntax.*;
    import com.hp.hpl.jena.shared.*;
    import org.aksw.sparqlify.config.syntax.*;
    import com.hp.hpl.jena.shared.impl.*;
    import com.hp.hpl.jena.sparql.core.*;
    import com.hp.hpl.jena.datatypes.*;
    import org.aksw.sparqlify.algebra.sparql.expr.*;
    import com.hp.hpl.jena.rdf.model.AnonId;
    import org.aksw.sparqlify.util.*;
    import org.aksw.jena_sparql_api.utils.*;

    import org.aksw.sparqlify.algebra.sql.nodes.*;
    import com.hp.hpl.jena.sdb.core.JoinType;

    import java.util.Collection;
    import java.util.List;
    import java.util.ArrayList;
    import java.util.Map;
    import java.util.AbstractMap;
    import java.util.HashMap;


    import org.slf4j.Logger;
    import org.slf4j.LoggerFactory;

    import com.hp.hpl.jena.shared.PrefixMapping;
    import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;


    import org.aksw.sparqlify.core.SparqlifyConstants;


import org.antlr.runtime.*;
import org.antlr.runtime.tree.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;

/**
 * @author Simone Tripodi   (simone.tripodi)
 * @author Michele Mostarda (michele.mostarda)
 * @author Juergen Pfundt   (Juergen.Pfundt)
 * @version $Id: Sparql.g 161 2011-05-23 22:14:39Z Juergen.Pfundt@web.de $
 */
@SuppressWarnings("all")
public class SparqlifyConfigTree extends TreeParser {
	public static final String[] tokenNames = new String[] {
		"<invalid>", "<EOR>", "<DOWN>", "<UP>", "A", "ABS", "ADD", "ALIASED_LOGICAL_TABLE", 
		"ALIASED_VAR", "ALL", "AND", "ANY", "ARG_LIST", "AS", "ASC", "ASK", "ASTERISK", 
		"AVG", "BASE", "BIND", "BINDINGS", "BINDING_VALUE", "BLANK_NODE", "BLANK_NODE_LABEL", 
		"BNODE", "BOUND", "BY", "CEIL", "CLEAR", "CLOSE_BRACE", "CLOSE_CURLY_BRACE", 
		"CLOSE_SQUARE_BRACKET", "COALESCE", "COLLECTION", "COMMA", "COMMENT", 
		"CONCAT", "CONSTRAIN", "CONSTRAINTS", "CONSTRUCT", "CONSTRUCT_QUADS", 
		"CONSTRUCT_TRIPLES", "CONSTRUCT_VIEW_DEFINITION", "CONTAINS", "COPY", 
		"COUNT", "CREATE", "DATA", "DATATYPE", "DAY", "DECIMAL", "DECIMAL_NEGATIVE", 
		"DECIMAL_POSITIVE", "DECLARE", "DEFAULT", "DEFINE", "DELETE", "DESC", 
		"DESCRIBE", "DIGIT", "DISTINCT", "DIVIDE", "DOT", "DOUBLE", "DOUBLE_NEGATIVE", 
		"DOUBLE_POSITIVE", "DROP", "ECHAR", "ENCODE_FOR_URI", "EOL", "EQUAL", 
		"EXISTS", "EXPONENT", "EXPRESSION_LIST", "FALSE", "FILTER", "FLOOR", "FROM", 
		"FULL_JOIN", "FUNCTION", "FUNCTION_DECLARATION", "FUNCTION_SIGNATURE", 
		"FUNCTION_TEMPLATE", "GRAPH", "GRAPH_TOKEN", "GREATER", "GREATER_EQUAL", 
		"GROUP", "GROUP_BY", "GROUP_CONCAT", "GROUP_GRAPH_PATTERN", "HAVING", 
		"HOURS", "IF", "IMPORT", "IN", "INSERT", "INTEGER", "INTEGER_NEGATIVE", 
		"INTEGER_POSITIVE", "INTO", "INVERSE", "IRI", "IRI_REF", "IRI_REF_CHARACTERS", 
		"ISBLANK", "ISIRI", "ISLITERAL", "ISNUMERIC", "ISURI", "JOIN_MEMBER", 
		"LANG", "LANGMATCHES", "LANGTAG", "LANGTAG_STR", "LCASE", "LESS", "LESS_EQUAL", 
		"LIMIT", "LOAD", "MACRO_DEF", "MAX", "MD5", "MIN", "MINUS", "MINUS_KEYWORD", 
		"MINUTES", "MODIFY", "MONTH", "MOVE", "NAME", "NAMED", "NAMED_VIEW_TEMPLATE_DEFINITION", 
		"NAME_SUFFIX", "NEGATION", "NESTED_ML_COMMENT", "NOT", "NOT_EQUAL", "NOT_EXISTS", 
		"NOW", "OBJECT", "OFFSET", "OPEN_BRACE", "OPEN_CURLY_BRACE", "OPEN_SQUARE_BRACKET", 
		"OPTIONAL", "OR", "ORDER", "ORDER_BY", "ORDER_CONDITION", "PARAM_TYPE", 
		"PARAM_TYPE_LIST", "PATH", "PATH_NEGATED", "PATH_PRIMARY", "PIPE", "PLAIN_LITERAL", 
		"PLUS", "PNAME_LN", "PNAME_NS", "PN_CHARS", "PN_CHARS_BASE", "PN_CHARS_U", 
		"PN_LOCAL", "PN_PREFIX", "PREDICATE", "PREFIX", "PREFIX_CONSTRAINT", "PREFIX_DECL", 
		"PROLOGUE", "PROPERTY_LIST", "QUERY", "QUESTION_MARK", "RAND", "REDUCED", 
		"REFERENCE", "REGEX", "REGEX_CONSTRAINT", "RELATION_REF", "ROUND", "SAMETERM", 
		"SAMPLE", "SECONDS", "SELECT", "SELECT_CLAUSE", "SEMICOLON", "SEPARATOR", 
		"SERVICE", "SET", "SHA1", "SHA224", "SHA256", "SHA384", "SHA512", "SIGN", 
		"SILENT", "SINGLE_LINE_COMMENT", "SQL_QUERY", "SQL_RELATION", "SQL_TABLE", 
		"STR", "STRDT", "STRENDS", "STRING_LIST", "STRING_LITERAL1", "STRING_LITERAL2", 
		"STRING_LITERAL_LONG1", "STRING_LITERAL_LONG2", "STRLANG", "STRLEN", "STRSTARTS", 
		"SUBJECT", "SUBSELECT", "SUBSTR", "SUM", "TEMPLATE", "TIMEZONE", "TO", 
		"TODO", "TRIPLE", "TRIPLES_BLOCK", "TRIPLES_TEMPLATE", "TRUE", "TYPED_LITERAL", 
		"TZ", "UCASE", "UNARY", "UNARY_MINUS", "UNARY_NOT", "UNARY_PLUS", "UNDEF", 
		"UNION", "UPDATE", "URI", "USING", "VAR", "VAR1", "VAR2", "VAR3", "VARNAME", 
		"VAR_BINDING", "VAR_BINDINGS", "VAR_HEAD", "VIEW", "VIEW_DEFINITION", 
		"VIEW_TEMPLATE_DEFINITION", "WHERE", "WHERE_CLAUSE", "WITH", "WS", "YEAR"
	};
	public static final int EOF=-1;
	public static final int A=4;
	public static final int ABS=5;
	public static final int ADD=6;
	public static final int ALIASED_LOGICAL_TABLE=7;
	public static final int ALIASED_VAR=8;
	public static final int ALL=9;
	public static final int AND=10;
	public static final int ANY=11;
	public static final int ARG_LIST=12;
	public static final int AS=13;
	public static final int ASC=14;
	public static final int ASK=15;
	public static final int ASTERISK=16;
	public static final int AVG=17;
	public static final int BASE=18;
	public static final int BIND=19;
	public static final int BINDINGS=20;
	public static final int BINDING_VALUE=21;
	public static final int BLANK_NODE=22;
	public static final int BLANK_NODE_LABEL=23;
	public static final int BNODE=24;
	public static final int BOUND=25;
	public static final int BY=26;
	public static final int CEIL=27;
	public static final int CLEAR=28;
	public static final int CLOSE_BRACE=29;
	public static final int CLOSE_CURLY_BRACE=30;
	public static final int CLOSE_SQUARE_BRACKET=31;
	public static final int COALESCE=32;
	public static final int COLLECTION=33;
	public static final int COMMA=34;
	public static final int COMMENT=35;
	public static final int CONCAT=36;
	public static final int CONSTRAIN=37;
	public static final int CONSTRAINTS=38;
	public static final int CONSTRUCT=39;
	public static final int CONSTRUCT_QUADS=40;
	public static final int CONSTRUCT_TRIPLES=41;
	public static final int CONSTRUCT_VIEW_DEFINITION=42;
	public static final int CONTAINS=43;
	public static final int COPY=44;
	public static final int COUNT=45;
	public static final int CREATE=46;
	public static final int DATA=47;
	public static final int DATATYPE=48;
	public static final int DAY=49;
	public static final int DECIMAL=50;
	public static final int DECIMAL_NEGATIVE=51;
	public static final int DECIMAL_POSITIVE=52;
	public static final int DECLARE=53;
	public static final int DEFAULT=54;
	public static final int DEFINE=55;
	public static final int DELETE=56;
	public static final int DESC=57;
	public static final int DESCRIBE=58;
	public static final int DIGIT=59;
	public static final int DISTINCT=60;
	public static final int DIVIDE=61;
	public static final int DOT=62;
	public static final int DOUBLE=63;
	public static final int DOUBLE_NEGATIVE=64;
	public static final int DOUBLE_POSITIVE=65;
	public static final int DROP=66;
	public static final int ECHAR=67;
	public static final int ENCODE_FOR_URI=68;
	public static final int EOL=69;
	public static final int EQUAL=70;
	public static final int EXISTS=71;
	public static final int EXPONENT=72;
	public static final int EXPRESSION_LIST=73;
	public static final int FALSE=74;
	public static final int FILTER=75;
	public static final int FLOOR=76;
	public static final int FROM=77;
	public static final int FULL_JOIN=78;
	public static final int FUNCTION=79;
	public static final int FUNCTION_DECLARATION=80;
	public static final int FUNCTION_SIGNATURE=81;
	public static final int FUNCTION_TEMPLATE=82;
	public static final int GRAPH=83;
	public static final int GRAPH_TOKEN=84;
	public static final int GREATER=85;
	public static final int GREATER_EQUAL=86;
	public static final int GROUP=87;
	public static final int GROUP_BY=88;
	public static final int GROUP_CONCAT=89;
	public static final int GROUP_GRAPH_PATTERN=90;
	public static final int HAVING=91;
	public static final int HOURS=92;
	public static final int IF=93;
	public static final int IMPORT=94;
	public static final int IN=95;
	public static final int INSERT=96;
	public static final int INTEGER=97;
	public static final int INTEGER_NEGATIVE=98;
	public static final int INTEGER_POSITIVE=99;
	public static final int INTO=100;
	public static final int INVERSE=101;
	public static final int IRI=102;
	public static final int IRI_REF=103;
	public static final int IRI_REF_CHARACTERS=104;
	public static final int ISBLANK=105;
	public static final int ISIRI=106;
	public static final int ISLITERAL=107;
	public static final int ISNUMERIC=108;
	public static final int ISURI=109;
	public static final int JOIN_MEMBER=110;
	public static final int LANG=111;
	public static final int LANGMATCHES=112;
	public static final int LANGTAG=113;
	public static final int LANGTAG_STR=114;
	public static final int LCASE=115;
	public static final int LESS=116;
	public static final int LESS_EQUAL=117;
	public static final int LIMIT=118;
	public static final int LOAD=119;
	public static final int MACRO_DEF=120;
	public static final int MAX=121;
	public static final int MD5=122;
	public static final int MIN=123;
	public static final int MINUS=124;
	public static final int MINUS_KEYWORD=125;
	public static final int MINUTES=126;
	public static final int MODIFY=127;
	public static final int MONTH=128;
	public static final int MOVE=129;
	public static final int NAME=130;
	public static final int NAMED=131;
	public static final int NAMED_VIEW_TEMPLATE_DEFINITION=132;
	public static final int NAME_SUFFIX=133;
	public static final int NEGATION=134;
	public static final int NESTED_ML_COMMENT=135;
	public static final int NOT=136;
	public static final int NOT_EQUAL=137;
	public static final int NOT_EXISTS=138;
	public static final int NOW=139;
	public static final int OBJECT=140;
	public static final int OFFSET=141;
	public static final int OPEN_BRACE=142;
	public static final int OPEN_CURLY_BRACE=143;
	public static final int OPEN_SQUARE_BRACKET=144;
	public static final int OPTIONAL=145;
	public static final int OR=146;
	public static final int ORDER=147;
	public static final int ORDER_BY=148;
	public static final int ORDER_CONDITION=149;
	public static final int PARAM_TYPE=150;
	public static final int PARAM_TYPE_LIST=151;
	public static final int PATH=152;
	public static final int PATH_NEGATED=153;
	public static final int PATH_PRIMARY=154;
	public static final int PIPE=155;
	public static final int PLAIN_LITERAL=156;
	public static final int PLUS=157;
	public static final int PNAME_LN=158;
	public static final int PNAME_NS=159;
	public static final int PN_CHARS=160;
	public static final int PN_CHARS_BASE=161;
	public static final int PN_CHARS_U=162;
	public static final int PN_LOCAL=163;
	public static final int PN_PREFIX=164;
	public static final int PREDICATE=165;
	public static final int PREFIX=166;
	public static final int PREFIX_CONSTRAINT=167;
	public static final int PREFIX_DECL=168;
	public static final int PROLOGUE=169;
	public static final int PROPERTY_LIST=170;
	public static final int QUERY=171;
	public static final int QUESTION_MARK=172;
	public static final int RAND=173;
	public static final int REDUCED=174;
	public static final int REFERENCE=175;
	public static final int REGEX=176;
	public static final int REGEX_CONSTRAINT=177;
	public static final int RELATION_REF=178;
	public static final int ROUND=179;
	public static final int SAMETERM=180;
	public static final int SAMPLE=181;
	public static final int SECONDS=182;
	public static final int SELECT=183;
	public static final int SELECT_CLAUSE=184;
	public static final int SEMICOLON=185;
	public static final int SEPARATOR=186;
	public static final int SERVICE=187;
	public static final int SET=188;
	public static final int SHA1=189;
	public static final int SHA224=190;
	public static final int SHA256=191;
	public static final int SHA384=192;
	public static final int SHA512=193;
	public static final int SIGN=194;
	public static final int SILENT=195;
	public static final int SINGLE_LINE_COMMENT=196;
	public static final int SQL_QUERY=197;
	public static final int SQL_RELATION=198;
	public static final int SQL_TABLE=199;
	public static final int STR=200;
	public static final int STRDT=201;
	public static final int STRENDS=202;
	public static final int STRING_LIST=203;
	public static final int STRING_LITERAL1=204;
	public static final int STRING_LITERAL2=205;
	public static final int STRING_LITERAL_LONG1=206;
	public static final int STRING_LITERAL_LONG2=207;
	public static final int STRLANG=208;
	public static final int STRLEN=209;
	public static final int STRSTARTS=210;
	public static final int SUBJECT=211;
	public static final int SUBSELECT=212;
	public static final int SUBSTR=213;
	public static final int SUM=214;
	public static final int TEMPLATE=215;
	public static final int TIMEZONE=216;
	public static final int TO=217;
	public static final int TODO=218;
	public static final int TRIPLE=219;
	public static final int TRIPLES_BLOCK=220;
	public static final int TRIPLES_TEMPLATE=221;
	public static final int TRUE=222;
	public static final int TYPED_LITERAL=223;
	public static final int TZ=224;
	public static final int UCASE=225;
	public static final int UNARY=226;
	public static final int UNARY_MINUS=227;
	public static final int UNARY_NOT=228;
	public static final int UNARY_PLUS=229;
	public static final int UNDEF=230;
	public static final int UNION=231;
	public static final int UPDATE=232;
	public static final int URI=233;
	public static final int USING=234;
	public static final int VAR=235;
	public static final int VAR1=236;
	public static final int VAR2=237;
	public static final int VAR3=238;
	public static final int VARNAME=239;
	public static final int VAR_BINDING=240;
	public static final int VAR_BINDINGS=241;
	public static final int VAR_HEAD=242;
	public static final int VIEW=243;
	public static final int VIEW_DEFINITION=244;
	public static final int VIEW_TEMPLATE_DEFINITION=245;
	public static final int WHERE=246;
	public static final int WHERE_CLAUSE=247;
	public static final int WITH=248;
	public static final int WS=249;
	public static final int YEAR=250;

	// delegates
	public TreeParser[] getDelegates() {
		return new TreeParser[] {};
	}

	// delegators


	public SparqlifyConfigTree(TreeNodeStream input) {
		this(input, new RecognizerSharedState());
	}
	public SparqlifyConfigTree(TreeNodeStream input, RecognizerSharedState state) {
		super(input, state);
	}

	@Override public String[] getTokenNames() { return SparqlifyConfigTree.tokenNames; }
	@Override public String getGrammarFileName() { return "org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g"; }


	    private static final Logger logger = LoggerFactory.getLogger("Parser");



	    private PrefixMapping prefixMapping = new PrefixMappingImpl();

	    private Map<String, String> options = new HashMap<String, String>();

	    public PrefixMapping getPrefixMapping() {
	        return prefixMapping;
	    }

	    public Map<String, String> getOptions() {
	        return options;
	    }


	    public Node getDefaultGraph() {
	        String value = options.get("defaultGraph");
	        if(value == null) {
	            value = "";
	        } else {
	            value = value.trim();
	        }


	        Node result;
	        if(value.isEmpty()) {
	            result = Quad.defaultGraphNodeGenerated;
	           }
	           else {
	               result = Node.createURI(value);
	           }

	        return result;
	    }


	    void registerPrefix(String prefix, String uri) {
	        registerPrefix(prefixMapping, new PrefixDecl(prefix, uri));
	    }

	/*
	    void registerPrefix(Config config, String prefix, String uri) {
	        registerPrefix(config.getPrefixMapping(), new PrefixDecl(prefix, uri));
	    }

	    void registerPrefix(TemplateConfig config, String prefix, String uri) {
	        registerPrefix(config.getPrefixMapping(), new PrefixDecl(prefix, uri));
	    }

	    void registerPrefix(ConstructConfig config, String prefix, String uri) {
	        registerPrefix(config.getPrefixMapping(), new PrefixDecl(prefix, uri));
	    }
	*/

	    void registerPrefix(PrefixMapping prefixMapping, PrefixDecl prefixDecl) {
	        // Warn if prefix gets re-registered
	        String uri = prefixMapping.getNsPrefixURI(prefixDecl.getPrefix());

	        if(uri != null) {
	            logger.warn("Prefix '" + prefixDecl.getPrefix() + "' remapped from <" + uri + "> to <" + prefixDecl.getUri() + ">");
	        }

	        prefixMapping.setNsPrefix(prefixDecl.getPrefix(), prefixDecl.getUri());
	    }


	    public String expandPrefix(String prefix) {
	        String result = prefixMapping.getNsPrefixMap().get(prefix);

	        if(result == null) {
	            logger.error("Namespace for prefix '" + prefix + "' not declared");
	            result = "http://sparqlify.org/resource/unresolvedNamespace/";
	        }

	        return result;
	    }


	    public String tryExpandUri(String uri) {
	        String result;

	        int index = uri.indexOf(':');
	        if(index < 0) {
	            result = uri;
	        } else {
	            result = expandUri(uri);
	        }

	        return result;
	    }

	    public String expandUri(String uri) {
	        int index = uri.indexOf(':');
	        if(index < 0) {
	            logger.error("Internal error: Expansion of '" + uri + "' requested although no symbol ':' found.");
	            return uri;
	        }

	        String prefix = uri.substring(0, index);
	        String namespace = expandPrefix(prefix);

	        String result = namespace + uri.substring(index + 1);

	        return result;
	    }

	    public String getErrorMessage(RecognitionException e,
	                                  String[] tokenNames)
	    {
	        List stack = getRuleInvocationStack(e, this.getClass().getName());
	        String msg = null;
	        String inputContext =
	            input.LT(-3) == null ? "" : ((Tree)input.LT(-3)).getText()+" "+
	            input.LT(-2) == null ? "" : ((Tree)input.LT(-2)).getText()+" "+
	            input.LT(-1) == null ? "" : ((Tree)input.LT(-1)).getText()+" >>>"+
	            ((Tree)input.LT(1)).getText()+"<<< "+
	            ((Tree)input.LT(2)).getText()+" "+
	            ((Tree)input.LT(3)).getText();
	        if ( e instanceof NoViableAltException ) {
	           NoViableAltException nvae = (NoViableAltException)e;
	           msg = " no viable alt; token="+e.token+
	              " (decision="+nvae.decisionNumber+
	              " state "+nvae.stateNumber+")"+
	              " decision=<<"+nvae.grammarDecisionDescription+">>";
	        }
	        else {
	           msg = super.getErrorMessage(e, tokenNames);
	        }
	        return stack+" "+msg+" context=..."+inputContext+"...";
	    }
	    public String getTokenErrorDisplay(Token t) {
	        return t.toString();
	    }

	/*
	    void addAsQuad(QuadPattern qp, Template template, Node g) {
	        if(g == null) {
	            g = Quad.defaultGraphNodeGenerated;
	        }

	        for(Triple t : template.getTriples()) {
	            Quad quad = new Quad(g, t);
	            qp.add(quad);
	        }
	    }
	*/

	    public E_Function createUriFunction(ExprList args) {
	        Expr arg;

	        if(args.size() == 1) {
	            arg = args.get(0);
	        } else {
	            arg = new E_StrConcatPermissive(args);
	        }

	        E_Function result = createFunction(SparqlifyConstants.uriLabel, arg);
	        return result;
	    }


	    public E_Function createFunction(String label, Expr ... args) {
	        ExprList exprs = new ExprList();
	        for(Expr arg : args) {
	            if(arg != null) {
	                exprs.add(arg);
	            }
	        }

	        return new E_Function(label, exprs);
	    }




	// $ANTLR start "templateConfig"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:250:1: templateConfig returns [TemplateConfig config] : ( templateConfigItem[config] )+ ;
	public final TemplateConfig templateConfig() throws RecognitionException {
		TemplateConfig config = null;


		 config = new TemplateConfig(); prefixMapping = config.getPrefixMapping(); 
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:252:5: ( ( templateConfigItem[config] )+ )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:252:7: ( templateConfigItem[config] )+
			{
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:252:7: ( templateConfigItem[config] )+
			int cnt1=0;
			loop1:
			while (true) {
				int alt1=2;
				int LA1_0 = input.LA(1);
				if ( (LA1_0==NAMED_VIEW_TEMPLATE_DEFINITION||LA1_0==PREFIX||LA1_0==SET) ) {
					alt1=1;
				}

				switch (alt1) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:252:7: templateConfigItem[config]
					{
					pushFollow(FOLLOW_templateConfigItem_in_templateConfig66);
					templateConfigItem(config);
					state._fsp--;

					}
					break;

				default :
					if ( cnt1 >= 1 ) break loop1;
					EarlyExitException eee = new EarlyExitException(1, input);
					throw eee;
				}
				cnt1++;
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return config;
	}
	// $ANTLR end "templateConfig"



	// $ANTLR start "templateConfigItem"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:255:1: templateConfigItem[TemplateConfig config] : (x= namedViewTemplateDefinition |a= prefixDecl |b= setStmt );
	public final void templateConfigItem(TemplateConfig config) throws RecognitionException {
		NamedViewTemplateDefinition x =null;
		TreeRuleReturnScope a =null;
		Map.Entry<String, String> b =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:256:5: (x= namedViewTemplateDefinition |a= prefixDecl |b= setStmt )
			int alt2=3;
			switch ( input.LA(1) ) {
			case NAMED_VIEW_TEMPLATE_DEFINITION:
				{
				alt2=1;
				}
				break;
			case PREFIX:
				{
				alt2=2;
				}
				break;
			case SET:
				{
				alt2=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 2, 0, input);
				throw nvae;
			}
			switch (alt2) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:256:7: x= namedViewTemplateDefinition
					{
					pushFollow(FOLLOW_namedViewTemplateDefinition_in_templateConfigItem88);
					x=namedViewTemplateDefinition();
					state._fsp--;

					config.getDefinitions().add(x);
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:257:7: a= prefixDecl
					{
					pushFollow(FOLLOW_prefixDecl_in_templateConfigItem100);
					a=prefixDecl();
					state._fsp--;

					registerPrefix((a!=null?((SparqlifyConfigTree.prefixDecl_return)a).prefix:null), (a!=null?((SparqlifyConfigTree.prefixDecl_return)a).uri:null));
					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:258:7: b= setStmt
					{
					pushFollow(FOLLOW_setStmt_in_templateConfigItem112);
					b=setStmt();
					state._fsp--;

					options.put(b.getKey(), b.getValue());
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "templateConfigItem"



	// $ANTLR start "setStmt"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:262:1: setStmt returns [Map.Entry<String, String> value] : ^( SET a= NAME b= string ) ;
	public final Map.Entry<String, String> setStmt() throws RecognitionException {
		Map.Entry<String, String> value = null;


		CommonTree a=null;
		String b =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:263:5: ( ^( SET a= NAME b= string ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:263:7: ^( SET a= NAME b= string )
			{
			match(input,SET,FOLLOW_SET_in_setStmt136); 
			match(input, Token.DOWN, null); 
			a=(CommonTree)match(input,NAME,FOLLOW_NAME_in_setStmt140); 
			pushFollow(FOLLOW_string_in_setStmt144);
			b=string();
			state._fsp--;

			match(input, Token.UP, null); 

			value = new AbstractMap.SimpleEntry<String, String>((a!=null?a.getText():null), b);
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "setStmt"



	// $ANTLR start "constructConfig"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:266:1: constructConfig returns [ConstructConfig config] : ( constructConfigItem[config] )+ ;
	public final ConstructConfig constructConfig() throws RecognitionException {
		ConstructConfig config = null;


		 config = new ConstructConfig(); prefixMapping = config.getPrefixMapping(); 
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:268:5: ( ( constructConfigItem[config] )+ )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:268:7: ( constructConfigItem[config] )+
			{
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:268:7: ( constructConfigItem[config] )+
			int cnt3=0;
			loop3:
			while (true) {
				int alt3=2;
				int LA3_0 = input.LA(1);
				if ( (LA3_0==CONSTRUCT_VIEW_DEFINITION||LA3_0==PREFIX||LA3_0==SET) ) {
					alt3=1;
				}

				switch (alt3) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:268:7: constructConfigItem[config]
					{
					pushFollow(FOLLOW_constructConfigItem_in_constructConfig176);
					constructConfigItem(config);
					state._fsp--;

					}
					break;

				default :
					if ( cnt3 >= 1 ) break loop3;
					EarlyExitException eee = new EarlyExitException(3, input);
					throw eee;
				}
				cnt3++;
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return config;
	}
	// $ANTLR end "constructConfig"



	// $ANTLR start "constructConfigItem"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:271:1: constructConfigItem[ConstructConfig config] : (x= constructViewDefinition[config] |a= prefixDecl |b= setStmt );
	public final void constructConfigItem(ConstructConfig config) throws RecognitionException {
		ConstructViewDefinition x =null;
		TreeRuleReturnScope a =null;
		Map.Entry<String, String> b =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:272:5: (x= constructViewDefinition[config] |a= prefixDecl |b= setStmt )
			int alt4=3;
			switch ( input.LA(1) ) {
			case CONSTRUCT_VIEW_DEFINITION:
				{
				alt4=1;
				}
				break;
			case PREFIX:
				{
				alt4=2;
				}
				break;
			case SET:
				{
				alt4=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 4, 0, input);
				throw nvae;
			}
			switch (alt4) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:272:7: x= constructViewDefinition[config]
					{
					pushFollow(FOLLOW_constructViewDefinition_in_constructConfigItem198);
					x=constructViewDefinition(config);
					state._fsp--;

					 config.getViewDefinitions().add(x); 
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:273:7: a= prefixDecl
					{
					pushFollow(FOLLOW_prefixDecl_in_constructConfigItem211);
					a=prefixDecl();
					state._fsp--;

					 registerPrefix((a!=null?((SparqlifyConfigTree.prefixDecl_return)a).prefix:null), (a!=null?((SparqlifyConfigTree.prefixDecl_return)a).uri:null)); 
					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:274:7: b= setStmt
					{
					pushFollow(FOLLOW_setStmt_in_constructConfigItem223);
					b=setStmt();
					state._fsp--;

					options.put(b.getKey(), b.getValue());
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "constructConfigItem"



	// $ANTLR start "constructViewDefinition"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:277:1: constructViewDefinition[ConstructConfig config] returns [ ConstructViewDefinition value ] : ^( CONSTRUCT_VIEW_DEFINITION a= NAME b= SQL_QUERY ) ;
	public final ConstructViewDefinition constructViewDefinition(ConstructConfig config) throws RecognitionException {
		ConstructViewDefinition value = null;


		CommonTree a=null;
		CommonTree b=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:278:5: ( ^( CONSTRUCT_VIEW_DEFINITION a= NAME b= SQL_QUERY ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:278:7: ^( CONSTRUCT_VIEW_DEFINITION a= NAME b= SQL_QUERY )
			{
			match(input,CONSTRUCT_VIEW_DEFINITION,FOLLOW_CONSTRUCT_VIEW_DEFINITION_in_constructViewDefinition248); 
			match(input, Token.DOWN, null); 
			a=(CommonTree)match(input,NAME,FOLLOW_NAME_in_constructViewDefinition252); 
			b=(CommonTree)match(input,SQL_QUERY,FOLLOW_SQL_QUERY_in_constructViewDefinition256); 
			match(input, Token.UP, null); 

			 value = new ConstructViewDefinition((a!=null?a.getText():null), (b!=null?b.getText():null), prefixMapping); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "constructViewDefinition"



	// $ANTLR start "sparqlifyConfig"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:284:1: sparqlifyConfig returns [Config config] : ( sparqlifyConfigItem[config] )+ ;
	public final Config sparqlifyConfig() throws RecognitionException {
		Config config = null;


		 config = new Config(); prefixMapping = config.getPrefixMapping(); 
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:286:5: ( ( sparqlifyConfigItem[config] )+ )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:286:7: ( sparqlifyConfigItem[config] )+
			{
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:286:7: ( sparqlifyConfigItem[config] )+
			int cnt5=0;
			loop5:
			while (true) {
				int alt5=2;
				int LA5_0 = input.LA(1);
				if ( (LA5_0==FUNCTION_DECLARATION||LA5_0==PREFIX||LA5_0==SET||LA5_0==VIEW_DEFINITION) ) {
					alt5=1;
				}

				switch (alt5) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:286:7: sparqlifyConfigItem[config]
					{
					pushFollow(FOLLOW_sparqlifyConfigItem_in_sparqlifyConfig291);
					sparqlifyConfigItem(config);
					state._fsp--;

					}
					break;

				default :
					if ( cnt5 >= 1 ) break loop5;
					EarlyExitException eee = new EarlyExitException(5, input);
					throw eee;
				}
				cnt5++;
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return config;
	}
	// $ANTLR end "sparqlifyConfig"



	// $ANTLR start "sparqlifyConfigItem"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:289:1: sparqlifyConfigItem[Config config] : (x= viewDefinition |a= prefixDecl |b= functionDeclaration |c= setStmt );
	public final void sparqlifyConfigItem(Config config) throws RecognitionException {
		ViewDefinition x =null;
		TreeRuleReturnScope a =null;
		FunctionDeclarationTemplate b =null;
		Map.Entry<String, String> c =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:290:5: (x= viewDefinition |a= prefixDecl |b= functionDeclaration |c= setStmt )
			int alt6=4;
			switch ( input.LA(1) ) {
			case VIEW_DEFINITION:
				{
				alt6=1;
				}
				break;
			case PREFIX:
				{
				alt6=2;
				}
				break;
			case FUNCTION_DECLARATION:
				{
				alt6=3;
				}
				break;
			case SET:
				{
				alt6=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 6, 0, input);
				throw nvae;
			}
			switch (alt6) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:290:7: x= viewDefinition
					{
					pushFollow(FOLLOW_viewDefinition_in_sparqlifyConfigItem313);
					x=viewDefinition();
					state._fsp--;

					config.getViewDefinitions().add(x);
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:291:7: a= prefixDecl
					{
					pushFollow(FOLLOW_prefixDecl_in_sparqlifyConfigItem330);
					a=prefixDecl();
					state._fsp--;

					registerPrefix((a!=null?((SparqlifyConfigTree.prefixDecl_return)a).prefix:null), (a!=null?((SparqlifyConfigTree.prefixDecl_return)a).uri:null));
					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:292:7: b= functionDeclaration
					{
					pushFollow(FOLLOW_functionDeclaration_in_sparqlifyConfigItem351);
					b=functionDeclaration();
					state._fsp--;

					config.getFunctionDeclarations().add(b);
					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:293:7: c= setStmt
					{
					pushFollow(FOLLOW_setStmt_in_sparqlifyConfigItem363);
					c=setStmt();
					state._fsp--;

					options.put(c.getKey(), c.getValue());
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "sparqlifyConfigItem"



	// $ANTLR start "functionDeclaration"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:298:1: functionDeclaration returns [FunctionDeclarationTemplate value] : ^( FUNCTION_DECLARATION a= functionSignature b= functionTemplate ) ;
	public final FunctionDeclarationTemplate functionDeclaration() throws RecognitionException {
		FunctionDeclarationTemplate value = null;


		FunctionSignature a =null;
		FunctionTemplate b =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:299:5: ( ^( FUNCTION_DECLARATION a= functionSignature b= functionTemplate ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:299:7: ^( FUNCTION_DECLARATION a= functionSignature b= functionTemplate )
			{
			match(input,FUNCTION_DECLARATION,FOLLOW_FUNCTION_DECLARATION_in_functionDeclaration389); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_functionSignature_in_functionDeclaration393);
			a=functionSignature();
			state._fsp--;

			pushFollow(FOLLOW_functionTemplate_in_functionDeclaration397);
			b=functionTemplate();
			state._fsp--;

			match(input, Token.UP, null); 

			value = new FunctionDeclarationTemplate(a, b);
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "functionDeclaration"



	// $ANTLR start "functionSignature"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:302:1: functionSignature returns [FunctionSignature value] : ^( FUNCTION_SIGNATURE a= NAME b= iriRef c= paramTypeList ) ;
	public final FunctionSignature functionSignature() throws RecognitionException {
		FunctionSignature value = null;


		CommonTree a=null;
		Node b =null;
		ParamTypeList c =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:303:5: ( ^( FUNCTION_SIGNATURE a= NAME b= iriRef c= paramTypeList ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:303:7: ^( FUNCTION_SIGNATURE a= NAME b= iriRef c= paramTypeList )
			{
			match(input,FUNCTION_SIGNATURE,FOLLOW_FUNCTION_SIGNATURE_in_functionSignature422); 
			match(input, Token.DOWN, null); 
			a=(CommonTree)match(input,NAME,FOLLOW_NAME_in_functionSignature426); 
			pushFollow(FOLLOW_iriRef_in_functionSignature430);
			b=iriRef();
			state._fsp--;

			pushFollow(FOLLOW_paramTypeList_in_functionSignature434);
			c=paramTypeList();
			state._fsp--;

			match(input, Token.UP, null); 

			value = new FunctionSignature(b.toString(), (a!=null?a.getText():null), c);
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "functionSignature"



	// $ANTLR start "paramTypeList"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:306:1: paramTypeList returns [ParamTypeList value] : ( ^( PARAM_TYPE_LIST (a= paramType )+ ) | ^( PARAM_TYPE_LIST nil ) );
	public final ParamTypeList paramTypeList() throws RecognitionException {
		ParamTypeList value = null;


		ParamType a =null;

		 value = new ParamTypeList(); 
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:308:5: ( ^( PARAM_TYPE_LIST (a= paramType )+ ) | ^( PARAM_TYPE_LIST nil ) )
			int alt8=2;
			int LA8_0 = input.LA(1);
			if ( (LA8_0==PARAM_TYPE_LIST) ) {
				int LA8_1 = input.LA(2);
				if ( (LA8_1==DOWN) ) {
					int LA8_2 = input.LA(3);
					if ( (LA8_2==PARAM_TYPE) ) {
						alt8=1;
					}
					else if ( (LA8_2==OPEN_BRACE) ) {
						alt8=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 8, 2, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 8, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 8, 0, input);
				throw nvae;
			}

			switch (alt8) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:308:7: ^( PARAM_TYPE_LIST (a= paramType )+ )
					{
					match(input,PARAM_TYPE_LIST,FOLLOW_PARAM_TYPE_LIST_in_paramTypeList468); 
					match(input, Token.DOWN, null); 
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:308:25: (a= paramType )+
					int cnt7=0;
					loop7:
					while (true) {
						int alt7=2;
						int LA7_0 = input.LA(1);
						if ( (LA7_0==PARAM_TYPE) ) {
							alt7=1;
						}

						switch (alt7) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:308:26: a= paramType
							{
							pushFollow(FOLLOW_paramType_in_paramTypeList473);
							a=paramType();
							state._fsp--;

							value.add(a);
							}
							break;

						default :
							if ( cnt7 >= 1 ) break loop7;
							EarlyExitException eee = new EarlyExitException(7, input);
							throw eee;
						}
						cnt7++;
					}

					match(input, Token.UP, null); 

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:309:7: ^( PARAM_TYPE_LIST nil )
					{
					match(input,PARAM_TYPE_LIST,FOLLOW_PARAM_TYPE_LIST_in_paramTypeList487); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_nil_in_paramTypeList489);
					nil();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "paramTypeList"



	// $ANTLR start "paramType"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:313:1: paramType returns [ParamType value] : ^( PARAM_TYPE a= NAME b= var ) ;
	public final ParamType paramType() throws RecognitionException {
		ParamType value = null;


		CommonTree a=null;
		Var b =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:314:5: ( ^( PARAM_TYPE a= NAME b= var ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:314:7: ^( PARAM_TYPE a= NAME b= var )
			{
			match(input,PARAM_TYPE,FOLLOW_PARAM_TYPE_in_paramType513); 
			match(input, Token.DOWN, null); 
			a=(CommonTree)match(input,NAME,FOLLOW_NAME_in_paramType517); 
			pushFollow(FOLLOW_var_in_paramType521);
			b=var();
			state._fsp--;

			match(input, Token.UP, null); 

			value = new ParamType((a!=null?a.getText():null), b);
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "paramType"



	// $ANTLR start "functionTemplate"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:318:1: functionTemplate returns [FunctionTemplate value] : ^( FUNCTION_TEMPLATE a= NAME b= expressionList ) ;
	public final FunctionTemplate functionTemplate() throws RecognitionException {
		FunctionTemplate value = null;


		CommonTree a=null;
		ExprList b =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:319:5: ( ^( FUNCTION_TEMPLATE a= NAME b= expressionList ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:319:7: ^( FUNCTION_TEMPLATE a= NAME b= expressionList )
			{
			match(input,FUNCTION_TEMPLATE,FOLLOW_FUNCTION_TEMPLATE_in_functionTemplate547); 
			match(input, Token.DOWN, null); 
			a=(CommonTree)match(input,NAME,FOLLOW_NAME_in_functionTemplate551); 
			pushFollow(FOLLOW_expressionList_in_functionTemplate555);
			b=expressionList();
			state._fsp--;

			match(input, Token.UP, null); 

			value = new FunctionTemplate((a!=null?a.getText():null), b);
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "functionTemplate"



	// $ANTLR start "namedViewTemplateDefinition"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:325:1: namedViewTemplateDefinition returns [NamedViewTemplateDefinition value] : ^( NAMED_VIEW_TEMPLATE_DEFINITION a= NAME b= viewTemplateDefinition ) ;
	public final NamedViewTemplateDefinition namedViewTemplateDefinition() throws RecognitionException {
		NamedViewTemplateDefinition value = null;


		CommonTree a=null;
		ViewTemplateDefinition b =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:326:5: ( ^( NAMED_VIEW_TEMPLATE_DEFINITION a= NAME b= viewTemplateDefinition ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:326:7: ^( NAMED_VIEW_TEMPLATE_DEFINITION a= NAME b= viewTemplateDefinition )
			{
			match(input,NAMED_VIEW_TEMPLATE_DEFINITION,FOLLOW_NAMED_VIEW_TEMPLATE_DEFINITION_in_namedViewTemplateDefinition583); 
			match(input, Token.DOWN, null); 
			a=(CommonTree)match(input,NAME,FOLLOW_NAME_in_namedViewTemplateDefinition587); 
			pushFollow(FOLLOW_viewTemplateDefinition_in_namedViewTemplateDefinition591);
			b=viewTemplateDefinition();
			state._fsp--;

			match(input, Token.UP, null); 

			value = new NamedViewTemplateDefinition((a!=null?a.getText():null), b);
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "namedViewTemplateDefinition"



	// $ANTLR start "viewTemplateDefinition"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:329:1: viewTemplateDefinition returns [ViewTemplateDefinition value] : ^( VIEW_TEMPLATE_DEFINITION a= constructTemplateQuads (b= varBindings )? ) ;
	public final ViewTemplateDefinition viewTemplateDefinition() throws RecognitionException {
		ViewTemplateDefinition value = null;


		QuadPattern a =null;
		List<Expr> b =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:330:5: ( ^( VIEW_TEMPLATE_DEFINITION a= constructTemplateQuads (b= varBindings )? ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:330:7: ^( VIEW_TEMPLATE_DEFINITION a= constructTemplateQuads (b= varBindings )? )
			{
			match(input,VIEW_TEMPLATE_DEFINITION,FOLLOW_VIEW_TEMPLATE_DEFINITION_in_viewTemplateDefinition616); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_constructTemplateQuads_in_viewTemplateDefinition620);
			a=constructTemplateQuads();
			state._fsp--;

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:330:60: (b= varBindings )?
			int alt9=2;
			int LA9_0 = input.LA(1);
			if ( (LA9_0==VAR_BINDINGS) ) {
				alt9=1;
			}
			switch (alt9) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:330:60: b= varBindings
					{
					pushFollow(FOLLOW_varBindings_in_viewTemplateDefinition624);
					b=varBindings();
					state._fsp--;

					}
					break;

			}

			match(input, Token.UP, null); 

			value = new ViewTemplateDefinition(a, b);
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "viewTemplateDefinition"



	// $ANTLR start "viewDefinition"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:333:1: viewDefinition returns [ ViewDefinition value ] : ^( VIEW_DEFINITION a= NAME b= viewTemplateDefinition (d= varConstraints )? (c= sqlRelation )? ) ;
	public final ViewDefinition viewDefinition() throws RecognitionException {
		ViewDefinition value = null;


		CommonTree a=null;
		ViewTemplateDefinition b =null;
		List<Constraint> d =null;
		SqlOp c =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:334:5: ( ^( VIEW_DEFINITION a= NAME b= viewTemplateDefinition (d= varConstraints )? (c= sqlRelation )? ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:334:7: ^( VIEW_DEFINITION a= NAME b= viewTemplateDefinition (d= varConstraints )? (c= sqlRelation )? )
			{
			match(input,VIEW_DEFINITION,FOLLOW_VIEW_DEFINITION_in_viewDefinition650); 
			match(input, Token.DOWN, null); 
			a=(CommonTree)match(input,NAME,FOLLOW_NAME_in_viewDefinition654); 
			pushFollow(FOLLOW_viewTemplateDefinition_in_viewDefinition658);
			b=viewTemplateDefinition();
			state._fsp--;

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:334:58: (d= varConstraints )?
			int alt10=2;
			int LA10_0 = input.LA(1);
			if ( (LA10_0==CONSTRAINTS) ) {
				alt10=1;
			}
			switch (alt10) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:334:58: d= varConstraints
					{
					pushFollow(FOLLOW_varConstraints_in_viewDefinition662);
					d=varConstraints();
					state._fsp--;

					}
					break;

			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:334:76: (c= sqlRelation )?
			int alt11=2;
			int LA11_0 = input.LA(1);
			if ( (LA11_0==RELATION_REF) ) {
				alt11=1;
			}
			switch (alt11) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:334:76: c= sqlRelation
					{
					pushFollow(FOLLOW_sqlRelation_in_viewDefinition667);
					c=sqlRelation();
					state._fsp--;

					}
					break;

			}

			match(input, Token.UP, null); 

			 value = new ViewDefinition((a!=null?a.getText():null), b, c, d); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "viewDefinition"



	// $ANTLR start "varBindings"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:337:1: varBindings returns [List<Expr> value] : ^( VAR_BINDINGS (a= varBinding )+ ) ;
	public final List<Expr> varBindings() throws RecognitionException {
		List<Expr> value = null;


		Expr a =null;

		value = new ArrayList<Expr>();
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:339:5: ( ^( VAR_BINDINGS (a= varBinding )+ ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:339:7: ^( VAR_BINDINGS (a= varBinding )+ )
			{
			match(input,VAR_BINDINGS,FOLLOW_VAR_BINDINGS_in_varBindings702); 
			match(input, Token.DOWN, null); 
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:339:22: (a= varBinding )+
			int cnt12=0;
			loop12:
			while (true) {
				int alt12=2;
				int LA12_0 = input.LA(1);
				if ( (LA12_0==VAR_BINDING) ) {
					alt12=1;
				}

				switch (alt12) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:339:23: a= varBinding
					{
					pushFollow(FOLLOW_varBinding_in_varBindings707);
					a=varBinding();
					state._fsp--;

					value.add(a);
					}
					break;

				default :
					if ( cnt12 >= 1 ) break loop12;
					EarlyExitException eee = new EarlyExitException(12, input);
					throw eee;
				}
				cnt12++;
			}

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "varBindings"



	// $ANTLR start "varBinding"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:343:1: varBinding returns [Expr value] : ^( VAR_BINDING a= var b= typeCtorExpression ) ;
	public final Expr varBinding() throws RecognitionException {
		Expr value = null;


		Var a =null;
		Expr b =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:344:5: ( ^( VAR_BINDING a= var b= typeCtorExpression ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:344:7: ^( VAR_BINDING a= var b= typeCtorExpression )
			{
			match(input,VAR_BINDING,FOLLOW_VAR_BINDING_in_varBinding735); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_var_in_varBinding739);
			a=var();
			state._fsp--;

			pushFollow(FOLLOW_typeCtorExpression_in_varBinding743);
			b=typeCtorExpression();
			state._fsp--;

			match(input, Token.UP, null); 

			value = new E_Equals(new ExprVar(a), b);
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "varBinding"



	// $ANTLR start "typeCtorExpression"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:347:1: typeCtorExpression returns [Expr value] : ( ^( BNODE a= expression ) | ^( URI c= expressionList ) | ^( PLAIN_LITERAL a= expression (b= expression )? ) | ^( TYPED_LITERAL a= expression b= expression ) );
	public final Expr typeCtorExpression() throws RecognitionException {
		Expr value = null;


		Expr a =null;
		ExprList c =null;
		Expr b =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:348:5: ( ^( BNODE a= expression ) | ^( URI c= expressionList ) | ^( PLAIN_LITERAL a= expression (b= expression )? ) | ^( TYPED_LITERAL a= expression b= expression ) )
			int alt14=4;
			switch ( input.LA(1) ) {
			case BNODE:
				{
				alt14=1;
				}
				break;
			case URI:
				{
				alt14=2;
				}
				break;
			case PLAIN_LITERAL:
				{
				alt14=3;
				}
				break;
			case TYPED_LITERAL:
				{
				alt14=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 14, 0, input);
				throw nvae;
			}
			switch (alt14) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:348:7: ^( BNODE a= expression )
					{
					match(input,BNODE,FOLLOW_BNODE_in_typeCtorExpression768); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_typeCtorExpression772);
					a=expression();
					state._fsp--;

					match(input, Token.UP, null); 

					value = createFunction(SparqlifyConstants.blankNodeLabel, a); 
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:349:7: ^( URI c= expressionList )
					{
					match(input,URI,FOLLOW_URI_in_typeCtorExpression784); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expressionList_in_typeCtorExpression788);
					c=expressionList();
					state._fsp--;

					match(input, Token.UP, null); 

					value = createUriFunction(c); 
					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:350:7: ^( PLAIN_LITERAL a= expression (b= expression )? )
					{
					match(input,PLAIN_LITERAL,FOLLOW_PLAIN_LITERAL_in_typeCtorExpression800); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_typeCtorExpression804);
					a=expression();
					state._fsp--;

					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:350:37: (b= expression )?
					int alt13=2;
					int LA13_0 = input.LA(1);
					if ( (LA13_0==AND||LA13_0==ASTERISK||LA13_0==DIVIDE||LA13_0==EQUAL||(LA13_0 >= GREATER && LA13_0 <= GREATER_EQUAL)||LA13_0==IN||(LA13_0 >= LESS && LA13_0 <= LESS_EQUAL)||LA13_0==MINUS||(LA13_0 >= NOT && LA13_0 <= NOT_EQUAL)||LA13_0==OR||LA13_0==PLUS||(LA13_0 >= UNARY && LA13_0 <= UNARY_PLUS)) ) {
						alt13=1;
					}
					switch (alt13) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:350:37: b= expression
							{
							pushFollow(FOLLOW_expression_in_typeCtorExpression808);
							b=expression();
							state._fsp--;

							}
							break;

					}

					match(input, Token.UP, null); 

					value = createFunction(SparqlifyConstants.plainLiteralLabel, a, b); 
					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:351:7: ^( TYPED_LITERAL a= expression b= expression )
					{
					match(input,TYPED_LITERAL,FOLLOW_TYPED_LITERAL_in_typeCtorExpression821); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_typeCtorExpression825);
					a=expression();
					state._fsp--;

					pushFollow(FOLLOW_expression_in_typeCtorExpression829);
					b=expression();
					state._fsp--;

					match(input, Token.UP, null); 

					value = createFunction(SparqlifyConstants.typedLiteralLabel, a, b); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "typeCtorExpression"



	// $ANTLR start "sqlRelationOld"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:354:1: sqlRelationOld returns [Relation value] : ( ^( SQL_RELATION a= SQL_QUERY ) | ^( SQL_RELATION a= SQL_TABLE ) );
	public final Relation sqlRelationOld() throws RecognitionException {
		Relation value = null;


		CommonTree a=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:355:5: ( ^( SQL_RELATION a= SQL_QUERY ) | ^( SQL_RELATION a= SQL_TABLE ) )
			int alt15=2;
			int LA15_0 = input.LA(1);
			if ( (LA15_0==SQL_RELATION) ) {
				int LA15_1 = input.LA(2);
				if ( (LA15_1==DOWN) ) {
					int LA15_2 = input.LA(3);
					if ( (LA15_2==SQL_QUERY) ) {
						alt15=1;
					}
					else if ( (LA15_2==SQL_TABLE) ) {
						alt15=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 15, 2, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 15, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 15, 0, input);
				throw nvae;
			}

			switch (alt15) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:355:7: ^( SQL_RELATION a= SQL_QUERY )
					{
					match(input,SQL_RELATION,FOLLOW_SQL_RELATION_in_sqlRelationOld854); 
					match(input, Token.DOWN, null); 
					a=(CommonTree)match(input,SQL_QUERY,FOLLOW_SQL_QUERY_in_sqlRelationOld858); 
					match(input, Token.UP, null); 

					value = new QueryString((a!=null?a.getText():null));
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:356:7: ^( SQL_RELATION a= SQL_TABLE )
					{
					match(input,SQL_RELATION,FOLLOW_SQL_RELATION_in_sqlRelationOld870); 
					match(input, Token.DOWN, null); 
					a=(CommonTree)match(input,SQL_TABLE,FOLLOW_SQL_TABLE_in_sqlRelationOld874); 
					match(input, Token.UP, null); 

					value = new RelationRef((a!=null?a.getText():null));
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "sqlRelationOld"



	// $ANTLR start "sqlRelation"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:361:1: sqlRelation returns [SqlOp value] : ^( RELATION_REF a= joinClause (b= expression )? ) ;
	public final SqlOp sqlRelation() throws RecognitionException {
		SqlOp value = null;


		SqlOp a =null;
		Expr b =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:362:5: ( ^( RELATION_REF a= joinClause (b= expression )? ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:362:7: ^( RELATION_REF a= joinClause (b= expression )? )
			{
			match(input,RELATION_REF,FOLLOW_RELATION_REF_in_sqlRelation901); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_joinClause_in_sqlRelation905);
			a=joinClause();
			state._fsp--;

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:362:36: (b= expression )?
			int alt16=2;
			int LA16_0 = input.LA(1);
			if ( (LA16_0==AND||LA16_0==ASTERISK||LA16_0==DIVIDE||LA16_0==EQUAL||(LA16_0 >= GREATER && LA16_0 <= GREATER_EQUAL)||LA16_0==IN||(LA16_0 >= LESS && LA16_0 <= LESS_EQUAL)||LA16_0==MINUS||(LA16_0 >= NOT && LA16_0 <= NOT_EQUAL)||LA16_0==OR||LA16_0==PLUS||(LA16_0 >= UNARY && LA16_0 <= UNARY_PLUS)) ) {
				alt16=1;
			}
			switch (alt16) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:362:36: b= expression
					{
					pushFollow(FOLLOW_expression_in_sqlRelation909);
					b=expression();
					state._fsp--;

					}
					break;

			}

			match(input, Token.UP, null); 

			value =(b == null) ? a : new SqlOpFilterExpr(null, a, b);
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "sqlRelation"



	// $ANTLR start "joinClause"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:365:1: joinClause returns [SqlOp value] : (a= joinClauseMember | ^( FULL_JOIN a= joinClauseMember b= joinClauseMember ) );
	public final SqlOp joinClause() throws RecognitionException {
		SqlOp value = null;


		SqlOp a =null;
		SqlOp b =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:366:5: (a= joinClauseMember | ^( FULL_JOIN a= joinClauseMember b= joinClauseMember ) )
			int alt17=2;
			int LA17_0 = input.LA(1);
			if ( (LA17_0==JOIN_MEMBER) ) {
				alt17=1;
			}
			else if ( (LA17_0==FULL_JOIN) ) {
				alt17=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 17, 0, input);
				throw nvae;
			}

			switch (alt17) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:366:7: a= joinClauseMember
					{
					pushFollow(FOLLOW_joinClauseMember_in_joinClause936);
					a=joinClauseMember();
					state._fsp--;

					value =a;
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:367:7: ^( FULL_JOIN a= joinClauseMember b= joinClauseMember )
					{
					match(input,FULL_JOIN,FOLLOW_FULL_JOIN_in_joinClause947); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_joinClauseMember_in_joinClause951);
					a=joinClauseMember();
					state._fsp--;

					pushFollow(FOLLOW_joinClauseMember_in_joinClause955);
					b=joinClauseMember();
					state._fsp--;

					match(input, Token.UP, null); 

					value =new SqlOpJoin(null, JoinType.INNER, a, b);
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "joinClause"



	// $ANTLR start "joinClauseMember"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:370:1: joinClauseMember returns [SqlOp value] : ^( JOIN_MEMBER a= sqlLogicalTable (b= NAME )? ) ;
	public final SqlOp joinClauseMember() throws RecognitionException {
		SqlOp value = null;


		CommonTree b=null;
		SqlOp a =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:371:5: ( ^( JOIN_MEMBER a= sqlLogicalTable (b= NAME )? ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:371:7: ^( JOIN_MEMBER a= sqlLogicalTable (b= NAME )? )
			{
			match(input,JOIN_MEMBER,FOLLOW_JOIN_MEMBER_in_joinClauseMember980); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_sqlLogicalTable_in_joinClauseMember984);
			a=sqlLogicalTable();
			state._fsp--;

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:371:40: (b= NAME )?
			int alt18=2;
			int LA18_0 = input.LA(1);
			if ( (LA18_0==NAME) ) {
				alt18=1;
			}
			switch (alt18) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:371:40: b= NAME
					{
					b=(CommonTree)match(input,NAME,FOLLOW_NAME_in_joinClauseMember988); 
					}
					break;

			}

			match(input, Token.UP, null); 

			value = a; ((SqlOpLeaf)value).setAliasName((b!=null?b.getText():null));
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "joinClauseMember"



	// $ANTLR start "sqlLogicalTable"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:374:1: sqlLogicalTable returns [SqlOp value] : ( ^( SQL_RELATION a= SQL_QUERY ) | ^( SQL_RELATION a= SQL_TABLE ) );
	public final SqlOp sqlLogicalTable() throws RecognitionException {
		SqlOp value = null;


		CommonTree a=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:375:5: ( ^( SQL_RELATION a= SQL_QUERY ) | ^( SQL_RELATION a= SQL_TABLE ) )
			int alt19=2;
			int LA19_0 = input.LA(1);
			if ( (LA19_0==SQL_RELATION) ) {
				int LA19_1 = input.LA(2);
				if ( (LA19_1==DOWN) ) {
					int LA19_2 = input.LA(3);
					if ( (LA19_2==SQL_QUERY) ) {
						alt19=1;
					}
					else if ( (LA19_2==SQL_TABLE) ) {
						alt19=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 19, 2, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 19, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 19, 0, input);
				throw nvae;
			}

			switch (alt19) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:375:7: ^( SQL_RELATION a= SQL_QUERY )
					{
					match(input,SQL_RELATION,FOLLOW_SQL_RELATION_in_sqlLogicalTable1014); 
					match(input, Token.DOWN, null); 
					a=(CommonTree)match(input,SQL_QUERY,FOLLOW_SQL_QUERY_in_sqlLogicalTable1018); 
					match(input, Token.UP, null); 

					value = new SqlOpQuery(null, (a!=null?a.getText():null));
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:376:7: ^( SQL_RELATION a= SQL_TABLE )
					{
					match(input,SQL_RELATION,FOLLOW_SQL_RELATION_in_sqlLogicalTable1030); 
					match(input, Token.DOWN, null); 
					a=(CommonTree)match(input,SQL_TABLE,FOLLOW_SQL_TABLE_in_sqlLogicalTable1034); 
					match(input, Token.UP, null); 

					value = new SqlOpTable(null, (a!=null?a.getText():null));
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "sqlLogicalTable"



	// $ANTLR start "varConstraints"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:380:1: varConstraints returns [List<Constraint> value] : ^( CONSTRAINTS (a= varConstraint )+ ) ;
	public final List<Constraint> varConstraints() throws RecognitionException {
		List<Constraint> value = null;


		Constraint a =null;

		value = new ArrayList<Constraint>();
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:382:5: ( ^( CONSTRAINTS (a= varConstraint )+ ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:382:7: ^( CONSTRAINTS (a= varConstraint )+ )
			{
			match(input,CONSTRAINTS,FOLLOW_CONSTRAINTS_in_varConstraints1069); 
			match(input, Token.DOWN, null); 
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:382:21: (a= varConstraint )+
			int cnt20=0;
			loop20:
			while (true) {
				int alt20=2;
				int LA20_0 = input.LA(1);
				if ( (LA20_0==PREFIX_CONSTRAINT||LA20_0==REGEX_CONSTRAINT) ) {
					alt20=1;
				}

				switch (alt20) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:382:22: a= varConstraint
					{
					pushFollow(FOLLOW_varConstraint_in_varConstraints1074);
					a=varConstraint();
					state._fsp--;

					value.add(a);
					}
					break;

				default :
					if ( cnt20 >= 1 ) break loop20;
					EarlyExitException eee = new EarlyExitException(20, input);
					throw eee;
				}
				cnt20++;
			}

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "varConstraints"



	// $ANTLR start "varConstraint"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:385:1: varConstraint returns [Constraint value] : ( (a= regexVarConstraint ) | (b= prefixVarConstraint ) );
	public final Constraint varConstraint() throws RecognitionException {
		Constraint value = null;


		RegexConstraint a =null;
		PrefixConstraint b =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:386:5: ( (a= regexVarConstraint ) | (b= prefixVarConstraint ) )
			int alt21=2;
			int LA21_0 = input.LA(1);
			if ( (LA21_0==REGEX_CONSTRAINT) ) {
				alt21=1;
			}
			else if ( (LA21_0==PREFIX_CONSTRAINT) ) {
				alt21=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 21, 0, input);
				throw nvae;
			}

			switch (alt21) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:386:7: (a= regexVarConstraint )
					{
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:386:7: (a= regexVarConstraint )
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:386:8: a= regexVarConstraint
					{
					pushFollow(FOLLOW_regexVarConstraint_in_varConstraint1102);
					a=regexVarConstraint();
					state._fsp--;

					}

					value = a;
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:387:7: (b= prefixVarConstraint )
					{
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:387:7: (b= prefixVarConstraint )
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:387:8: b= prefixVarConstraint
					{
					pushFollow(FOLLOW_prefixVarConstraint_in_varConstraint1116);
					b=prefixVarConstraint();
					state._fsp--;

					}

					value = b;
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "varConstraint"



	// $ANTLR start "regexVarConstraint"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:390:1: regexVarConstraint returns [RegexConstraint value] : ^( REGEX_CONSTRAINT a= var b= string ) ;
	public final RegexConstraint regexVarConstraint() throws RecognitionException {
		RegexConstraint value = null;


		Var a =null;
		String b =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:391:5: ( ^( REGEX_CONSTRAINT a= var b= string ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:391:7: ^( REGEX_CONSTRAINT a= var b= string )
			{
			match(input,REGEX_CONSTRAINT,FOLLOW_REGEX_CONSTRAINT_in_regexVarConstraint1141); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_var_in_regexVarConstraint1145);
			a=var();
			state._fsp--;

			pushFollow(FOLLOW_string_in_regexVarConstraint1149);
			b=string();
			state._fsp--;

			match(input, Token.UP, null); 

			value = new RegexConstraint(a, "value", b);
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "regexVarConstraint"



	// $ANTLR start "prefixVarConstraint"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:394:1: prefixVarConstraint returns [PrefixConstraint value] : ^( PREFIX_CONSTRAINT a= var b= stringList ) ;
	public final PrefixConstraint prefixVarConstraint() throws RecognitionException {
		PrefixConstraint value = null;


		Var a =null;
		List<String> b =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:395:5: ( ^( PREFIX_CONSTRAINT a= var b= stringList ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:395:7: ^( PREFIX_CONSTRAINT a= var b= stringList )
			{
			match(input,PREFIX_CONSTRAINT,FOLLOW_PREFIX_CONSTRAINT_in_prefixVarConstraint1174); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_var_in_prefixVarConstraint1178);
			a=var();
			state._fsp--;

			pushFollow(FOLLOW_stringList_in_prefixVarConstraint1182);
			b=stringList();
			state._fsp--;

			match(input, Token.UP, null); 

			value = new PrefixConstraint(a, "value", b);
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "prefixVarConstraint"



	// $ANTLR start "stringList"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:398:1: stringList returns [List<String> value] : ^( STRING_LIST (a= string )+ ) ;
	public final List<String> stringList() throws RecognitionException {
		List<String> value = null;


		String a =null;

		value = new ArrayList<String>();
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:400:5: ( ^( STRING_LIST (a= string )+ ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:400:7: ^( STRING_LIST (a= string )+ )
			{
			match(input,STRING_LIST,FOLLOW_STRING_LIST_in_stringList1216); 
			match(input, Token.DOWN, null); 
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:400:21: (a= string )+
			int cnt22=0;
			loop22:
			while (true) {
				int alt22=2;
				int LA22_0 = input.LA(1);
				if ( ((LA22_0 >= STRING_LITERAL1 && LA22_0 <= STRING_LITERAL_LONG2)) ) {
					alt22=1;
				}

				switch (alt22) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:400:22: a= string
					{
					pushFollow(FOLLOW_string_in_stringList1221);
					a=string();
					state._fsp--;

					value.add(a); 
					}
					break;

				default :
					if ( cnt22 >= 1 ) break loop22;
					EarlyExitException eee = new EarlyExitException(22, input);
					throw eee;
				}
				cnt22++;
			}

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "stringList"



	// $ANTLR start "query"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:404:1: query : ( ^( QUERY prologue ( selectQuery )* ( constructQuery )* ( describeQuery )* ( askQuery )* ) ( bindingsClause )* | ^( UPDATE ( update )+ ) );
	public final void query() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:405:5: ( ^( QUERY prologue ( selectQuery )* ( constructQuery )* ( describeQuery )* ( askQuery )* ) ( bindingsClause )* | ^( UPDATE ( update )+ ) )
			int alt29=2;
			int LA29_0 = input.LA(1);
			if ( (LA29_0==QUERY) ) {
				alt29=1;
			}
			else if ( (LA29_0==UPDATE) ) {
				alt29=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 29, 0, input);
				throw nvae;
			}

			switch (alt29) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:405:7: ^( QUERY prologue ( selectQuery )* ( constructQuery )* ( describeQuery )* ( askQuery )* ) ( bindingsClause )*
					{
					match(input,QUERY,FOLLOW_QUERY_in_query1245); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_prologue_in_query1247);
					prologue();
					state._fsp--;

					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:405:24: ( selectQuery )*
					loop23:
					while (true) {
						int alt23=2;
						int LA23_0 = input.LA(1);
						if ( (LA23_0==SELECT) ) {
							alt23=1;
						}

						switch (alt23) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:405:24: selectQuery
							{
							pushFollow(FOLLOW_selectQuery_in_query1249);
							selectQuery();
							state._fsp--;

							}
							break;

						default :
							break loop23;
						}
					}

					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:405:37: ( constructQuery )*
					loop24:
					while (true) {
						int alt24=2;
						int LA24_0 = input.LA(1);
						if ( (LA24_0==CONSTRUCT) ) {
							alt24=1;
						}

						switch (alt24) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:405:37: constructQuery
							{
							pushFollow(FOLLOW_constructQuery_in_query1252);
							constructQuery();
							state._fsp--;

							}
							break;

						default :
							break loop24;
						}
					}

					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:405:53: ( describeQuery )*
					loop25:
					while (true) {
						int alt25=2;
						int LA25_0 = input.LA(1);
						if ( (LA25_0==DESCRIBE) ) {
							alt25=1;
						}

						switch (alt25) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:405:53: describeQuery
							{
							pushFollow(FOLLOW_describeQuery_in_query1255);
							describeQuery();
							state._fsp--;

							}
							break;

						default :
							break loop25;
						}
					}

					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:405:68: ( askQuery )*
					loop26:
					while (true) {
						int alt26=2;
						int LA26_0 = input.LA(1);
						if ( (LA26_0==ASK) ) {
							alt26=1;
						}

						switch (alt26) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:405:68: askQuery
							{
							pushFollow(FOLLOW_askQuery_in_query1258);
							askQuery();
							state._fsp--;

							}
							break;

						default :
							break loop26;
						}
					}

					match(input, Token.UP, null); 

					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:405:79: ( bindingsClause )*
					loop27:
					while (true) {
						int alt27=2;
						int LA27_0 = input.LA(1);
						if ( (LA27_0==BINDINGS) ) {
							alt27=1;
						}

						switch (alt27) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:405:79: bindingsClause
							{
							pushFollow(FOLLOW_bindingsClause_in_query1262);
							bindingsClause();
							state._fsp--;

							}
							break;

						default :
							break loop27;
						}
					}

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:406:7: ^( UPDATE ( update )+ )
					{
					match(input,UPDATE,FOLLOW_UPDATE_in_query1272); 
					match(input, Token.DOWN, null); 
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:406:16: ( update )+
					int cnt28=0;
					loop28:
					while (true) {
						int alt28=2;
						int LA28_0 = input.LA(1);
						if ( (LA28_0==PROLOGUE) ) {
							alt28=1;
						}

						switch (alt28) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:406:16: update
							{
							pushFollow(FOLLOW_update_in_query1274);
							update();
							state._fsp--;

							}
							break;

						default :
							if ( cnt28 >= 1 ) break loop28;
							EarlyExitException eee = new EarlyExitException(28, input);
							throw eee;
						}
						cnt28++;
					}

					match(input, Token.UP, null); 

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "query"



	// $ANTLR start "prologue"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:409:1: prologue : ^( PROLOGUE ( baseDecl )* ( prefixDecl )* ) ;
	public final void prologue() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:410:5: ( ^( PROLOGUE ( baseDecl )* ( prefixDecl )* ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:410:7: ^( PROLOGUE ( baseDecl )* ( prefixDecl )* )
			{
			match(input,PROLOGUE,FOLLOW_PROLOGUE_in_prologue1294); 
			if ( input.LA(1)==Token.DOWN ) {
				match(input, Token.DOWN, null); 
				// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:410:18: ( baseDecl )*
				loop30:
				while (true) {
					int alt30=2;
					int LA30_0 = input.LA(1);
					if ( (LA30_0==BASE) ) {
						alt30=1;
					}

					switch (alt30) {
					case 1 :
						// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:410:18: baseDecl
						{
						pushFollow(FOLLOW_baseDecl_in_prologue1296);
						baseDecl();
						state._fsp--;

						}
						break;

					default :
						break loop30;
					}
				}

				// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:410:28: ( prefixDecl )*
				loop31:
				while (true) {
					int alt31=2;
					int LA31_0 = input.LA(1);
					if ( (LA31_0==PREFIX) ) {
						alt31=1;
					}

					switch (alt31) {
					case 1 :
						// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:410:28: prefixDecl
						{
						pushFollow(FOLLOW_prefixDecl_in_prologue1299);
						prefixDecl();
						state._fsp--;

						}
						break;

					default :
						break loop31;
					}
				}

				match(input, Token.UP, null); 
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "prologue"



	// $ANTLR start "baseDecl"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:413:1: baseDecl : ^( BASE IRI_REF ) ;
	public final void baseDecl() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:414:5: ( ^( BASE IRI_REF ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:414:7: ^( BASE IRI_REF )
			{
			match(input,BASE,FOLLOW_BASE_in_baseDecl1319); 
			match(input, Token.DOWN, null); 
			match(input,IRI_REF,FOLLOW_IRI_REF_in_baseDecl1321); 
			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "baseDecl"


	public static class prefixDecl_return extends TreeRuleReturnScope {
		public String prefix;
		public String uri;
	};


	// $ANTLR start "prefixDecl"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:417:1: prefixDecl returns [String prefix, String uri] : ^( PREFIX a= PNAME_NS b= IRI_REF ) ;
	public final SparqlifyConfigTree.prefixDecl_return prefixDecl() throws RecognitionException {
		SparqlifyConfigTree.prefixDecl_return retval = new SparqlifyConfigTree.prefixDecl_return();
		retval.start = input.LT(1);

		CommonTree a=null;
		CommonTree b=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:418:5: ( ^( PREFIX a= PNAME_NS b= IRI_REF ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:418:7: ^( PREFIX a= PNAME_NS b= IRI_REF )
			{
			match(input,PREFIX,FOLLOW_PREFIX_in_prefixDecl1344); 
			match(input, Token.DOWN, null); 
			a=(CommonTree)match(input,PNAME_NS,FOLLOW_PNAME_NS_in_prefixDecl1348); 
			b=(CommonTree)match(input,IRI_REF,FOLLOW_IRI_REF_in_prefixDecl1352); 
			match(input, Token.UP, null); 

			 retval.prefix =(a!=null?a.getText():null); retval.uri =(b!=null?b.getText():null); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "prefixDecl"



	// $ANTLR start "selectQuery"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:421:1: selectQuery : ^( SELECT selectClause ( datasetClause )* ( whereClause )* solutionModifier ) ;
	public final void selectQuery() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:422:5: ( ^( SELECT selectClause ( datasetClause )* ( whereClause )* solutionModifier ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:422:7: ^( SELECT selectClause ( datasetClause )* ( whereClause )* solutionModifier )
			{
			match(input,SELECT,FOLLOW_SELECT_in_selectQuery1373); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_selectClause_in_selectQuery1375);
			selectClause();
			state._fsp--;

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:422:29: ( datasetClause )*
			loop32:
			while (true) {
				int alt32=2;
				int LA32_0 = input.LA(1);
				if ( (LA32_0==FROM) ) {
					alt32=1;
				}

				switch (alt32) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:422:29: datasetClause
					{
					pushFollow(FOLLOW_datasetClause_in_selectQuery1377);
					datasetClause();
					state._fsp--;

					}
					break;

				default :
					break loop32;
				}
			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:422:44: ( whereClause )*
			loop33:
			while (true) {
				int alt33=2;
				int LA33_0 = input.LA(1);
				if ( (LA33_0==WHERE_CLAUSE) ) {
					alt33=1;
				}

				switch (alt33) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:422:44: whereClause
					{
					pushFollow(FOLLOW_whereClause_in_selectQuery1380);
					whereClause();
					state._fsp--;

					}
					break;

				default :
					break loop33;
				}
			}

			pushFollow(FOLLOW_solutionModifier_in_selectQuery1383);
			solutionModifier();
			state._fsp--;

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "selectQuery"



	// $ANTLR start "subSelect"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:425:1: subSelect : ^( SUBSELECT ( whereClause )* solutionModifier ) ;
	public final void subSelect() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:426:5: ( ^( SUBSELECT ( whereClause )* solutionModifier ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:426:7: ^( SUBSELECT ( whereClause )* solutionModifier )
			{
			match(input,SUBSELECT,FOLLOW_SUBSELECT_in_subSelect1402); 
			if ( input.LA(1)==Token.DOWN ) {
				match(input, Token.DOWN, null); 
				// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:426:19: ( whereClause )*
				loop34:
				while (true) {
					int alt34=2;
					int LA34_0 = input.LA(1);
					if ( (LA34_0==WHERE_CLAUSE) ) {
						alt34=1;
					}

					switch (alt34) {
					case 1 :
						// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:426:19: whereClause
						{
						pushFollow(FOLLOW_whereClause_in_subSelect1404);
						whereClause();
						state._fsp--;

						}
						break;

					default :
						break loop34;
					}
				}

				pushFollow(FOLLOW_solutionModifier_in_subSelect1407);
				solutionModifier();
				state._fsp--;

				match(input, Token.UP, null); 
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "subSelect"



	// $ANTLR start "selectClause"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:429:1: selectClause : ( ^( SELECT_CLAUSE ASTERISK ) | ^( SELECT_CLAUSE DISTINCT ASTERISK ) | ^( SELECT_CLAUSE REDUCED ASTERISK ) | ^( SELECT_CLAUSE ( selectVariables )* ) | ^( SELECT_CLAUSE DISTINCT ( selectVariables )* ) | ^( SELECT_CLAUSE REDUCED ( selectVariables )* ) );
	public final void selectClause() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:430:5: ( ^( SELECT_CLAUSE ASTERISK ) | ^( SELECT_CLAUSE DISTINCT ASTERISK ) | ^( SELECT_CLAUSE REDUCED ASTERISK ) | ^( SELECT_CLAUSE ( selectVariables )* ) | ^( SELECT_CLAUSE DISTINCT ( selectVariables )* ) | ^( SELECT_CLAUSE REDUCED ( selectVariables )* ) )
			int alt38=6;
			int LA38_0 = input.LA(1);
			if ( (LA38_0==SELECT_CLAUSE) ) {
				int LA38_1 = input.LA(2);
				if ( (LA38_1==DOWN) ) {
					switch ( input.LA(3) ) {
					case ASTERISK:
						{
						alt38=1;
						}
						break;
					case DISTINCT:
						{
						int LA38_4 = input.LA(4);
						if ( (LA38_4==ASTERISK) ) {
							alt38=2;
						}
						else if ( (LA38_4==UP||LA38_4==AS||LA38_4==VAR) ) {
							alt38=5;
						}

						else {
							int nvaeMark = input.mark();
							try {
								for (int nvaeConsume = 0; nvaeConsume < 4 - 1; nvaeConsume++) {
									input.consume();
								}
								NoViableAltException nvae =
									new NoViableAltException("", 38, 4, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

						}
						break;
					case REDUCED:
						{
						int LA38_5 = input.LA(4);
						if ( (LA38_5==ASTERISK) ) {
							alt38=3;
						}
						else if ( (LA38_5==UP||LA38_5==AS||LA38_5==VAR) ) {
							alt38=6;
						}

						else {
							int nvaeMark = input.mark();
							try {
								for (int nvaeConsume = 0; nvaeConsume < 4 - 1; nvaeConsume++) {
									input.consume();
								}
								NoViableAltException nvae =
									new NoViableAltException("", 38, 5, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

						}
						break;
					case UP:
					case AS:
					case VAR:
						{
						alt38=4;
						}
						break;
					default:
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 38, 2, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 38, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 38, 0, input);
				throw nvae;
			}

			switch (alt38) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:430:7: ^( SELECT_CLAUSE ASTERISK )
					{
					match(input,SELECT_CLAUSE,FOLLOW_SELECT_CLAUSE_in_selectClause1426); 
					match(input, Token.DOWN, null); 
					match(input,ASTERISK,FOLLOW_ASTERISK_in_selectClause1428); 
					match(input, Token.UP, null); 

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:431:7: ^( SELECT_CLAUSE DISTINCT ASTERISK )
					{
					match(input,SELECT_CLAUSE,FOLLOW_SELECT_CLAUSE_in_selectClause1438); 
					match(input, Token.DOWN, null); 
					match(input,DISTINCT,FOLLOW_DISTINCT_in_selectClause1440); 
					match(input,ASTERISK,FOLLOW_ASTERISK_in_selectClause1442); 
					match(input, Token.UP, null); 

					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:432:7: ^( SELECT_CLAUSE REDUCED ASTERISK )
					{
					match(input,SELECT_CLAUSE,FOLLOW_SELECT_CLAUSE_in_selectClause1452); 
					match(input, Token.DOWN, null); 
					match(input,REDUCED,FOLLOW_REDUCED_in_selectClause1454); 
					match(input,ASTERISK,FOLLOW_ASTERISK_in_selectClause1456); 
					match(input, Token.UP, null); 

					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:433:7: ^( SELECT_CLAUSE ( selectVariables )* )
					{
					match(input,SELECT_CLAUSE,FOLLOW_SELECT_CLAUSE_in_selectClause1466); 
					if ( input.LA(1)==Token.DOWN ) {
						match(input, Token.DOWN, null); 
						// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:433:23: ( selectVariables )*
						loop35:
						while (true) {
							int alt35=2;
							int LA35_0 = input.LA(1);
							if ( (LA35_0==AS||LA35_0==VAR) ) {
								alt35=1;
							}

							switch (alt35) {
							case 1 :
								// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:433:23: selectVariables
								{
								pushFollow(FOLLOW_selectVariables_in_selectClause1468);
								selectVariables();
								state._fsp--;

								}
								break;

							default :
								break loop35;
							}
						}

						match(input, Token.UP, null); 
					}

					}
					break;
				case 5 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:434:7: ^( SELECT_CLAUSE DISTINCT ( selectVariables )* )
					{
					match(input,SELECT_CLAUSE,FOLLOW_SELECT_CLAUSE_in_selectClause1479); 
					match(input, Token.DOWN, null); 
					match(input,DISTINCT,FOLLOW_DISTINCT_in_selectClause1481); 
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:434:32: ( selectVariables )*
					loop36:
					while (true) {
						int alt36=2;
						int LA36_0 = input.LA(1);
						if ( (LA36_0==AS||LA36_0==VAR) ) {
							alt36=1;
						}

						switch (alt36) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:434:32: selectVariables
							{
							pushFollow(FOLLOW_selectVariables_in_selectClause1483);
							selectVariables();
							state._fsp--;

							}
							break;

						default :
							break loop36;
						}
					}

					match(input, Token.UP, null); 

					}
					break;
				case 6 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:435:7: ^( SELECT_CLAUSE REDUCED ( selectVariables )* )
					{
					match(input,SELECT_CLAUSE,FOLLOW_SELECT_CLAUSE_in_selectClause1494); 
					match(input, Token.DOWN, null); 
					match(input,REDUCED,FOLLOW_REDUCED_in_selectClause1496); 
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:435:31: ( selectVariables )*
					loop37:
					while (true) {
						int alt37=2;
						int LA37_0 = input.LA(1);
						if ( (LA37_0==AS||LA37_0==VAR) ) {
							alt37=1;
						}

						switch (alt37) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:435:31: selectVariables
							{
							pushFollow(FOLLOW_selectVariables_in_selectClause1498);
							selectVariables();
							state._fsp--;

							}
							break;

						default :
							break loop37;
						}
					}

					match(input, Token.UP, null); 

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "selectClause"



	// $ANTLR start "selectVariables"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:438:1: selectVariables : ( ^( VAR var ) | ^( AS expression var ) );
	public final void selectVariables() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:439:5: ( ^( VAR var ) | ^( AS expression var ) )
			int alt39=2;
			int LA39_0 = input.LA(1);
			if ( (LA39_0==VAR) ) {
				alt39=1;
			}
			else if ( (LA39_0==AS) ) {
				alt39=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 39, 0, input);
				throw nvae;
			}

			switch (alt39) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:439:7: ^( VAR var )
					{
					match(input,VAR,FOLLOW_VAR_in_selectVariables1518); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_var_in_selectVariables1520);
					var();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:440:7: ^( AS expression var )
					{
					match(input,AS,FOLLOW_AS_in_selectVariables1530); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_selectVariables1532);
					expression();
					state._fsp--;

					pushFollow(FOLLOW_var_in_selectVariables1534);
					var();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "selectVariables"



	// $ANTLR start "constructQuery"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:443:1: constructQuery : ( ^( CONSTRUCT ( constructTemplate )* ( datasetClause )* ( whereClause )* solutionModifier ) | ^( CONSTRUCT ( datasetClause )* ^( WHERE ( triplesTemplate )* ) solutionModifier ) );
	public final void constructQuery() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:444:5: ( ^( CONSTRUCT ( constructTemplate )* ( datasetClause )* ( whereClause )* solutionModifier ) | ^( CONSTRUCT ( datasetClause )* ^( WHERE ( triplesTemplate )* ) solutionModifier ) )
			int alt45=2;
			alt45 = dfa45.predict(input);
			switch (alt45) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:444:7: ^( CONSTRUCT ( constructTemplate )* ( datasetClause )* ( whereClause )* solutionModifier )
					{
					match(input,CONSTRUCT,FOLLOW_CONSTRUCT_in_constructQuery1553); 
					if ( input.LA(1)==Token.DOWN ) {
						match(input, Token.DOWN, null); 
						// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:444:19: ( constructTemplate )*
						loop40:
						while (true) {
							int alt40=2;
							int LA40_0 = input.LA(1);
							if ( (LA40_0==CONSTRUCT_TRIPLES) ) {
								alt40=1;
							}

							switch (alt40) {
							case 1 :
								// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:444:19: constructTemplate
								{
								pushFollow(FOLLOW_constructTemplate_in_constructQuery1555);
								constructTemplate();
								state._fsp--;

								}
								break;

							default :
								break loop40;
							}
						}

						// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:444:38: ( datasetClause )*
						loop41:
						while (true) {
							int alt41=2;
							int LA41_0 = input.LA(1);
							if ( (LA41_0==FROM) ) {
								alt41=1;
							}

							switch (alt41) {
							case 1 :
								// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:444:38: datasetClause
								{
								pushFollow(FOLLOW_datasetClause_in_constructQuery1558);
								datasetClause();
								state._fsp--;

								}
								break;

							default :
								break loop41;
							}
						}

						// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:444:53: ( whereClause )*
						loop42:
						while (true) {
							int alt42=2;
							int LA42_0 = input.LA(1);
							if ( (LA42_0==WHERE_CLAUSE) ) {
								alt42=1;
							}

							switch (alt42) {
							case 1 :
								// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:444:53: whereClause
								{
								pushFollow(FOLLOW_whereClause_in_constructQuery1561);
								whereClause();
								state._fsp--;

								}
								break;

							default :
								break loop42;
							}
						}

						pushFollow(FOLLOW_solutionModifier_in_constructQuery1564);
						solutionModifier();
						state._fsp--;

						match(input, Token.UP, null); 
					}

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:445:7: ^( CONSTRUCT ( datasetClause )* ^( WHERE ( triplesTemplate )* ) solutionModifier )
					{
					match(input,CONSTRUCT,FOLLOW_CONSTRUCT_in_constructQuery1574); 
					match(input, Token.DOWN, null); 
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:445:19: ( datasetClause )*
					loop43:
					while (true) {
						int alt43=2;
						int LA43_0 = input.LA(1);
						if ( (LA43_0==FROM) ) {
							alt43=1;
						}

						switch (alt43) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:445:19: datasetClause
							{
							pushFollow(FOLLOW_datasetClause_in_constructQuery1576);
							datasetClause();
							state._fsp--;

							}
							break;

						default :
							break loop43;
						}
					}

					match(input,WHERE,FOLLOW_WHERE_in_constructQuery1580); 
					if ( input.LA(1)==Token.DOWN ) {
						match(input, Token.DOWN, null); 
						// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:445:42: ( triplesTemplate )*
						loop44:
						while (true) {
							int alt44=2;
							int LA44_0 = input.LA(1);
							if ( (LA44_0==TRIPLES_TEMPLATE) ) {
								alt44=1;
							}

							switch (alt44) {
							case 1 :
								// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:445:42: triplesTemplate
								{
								pushFollow(FOLLOW_triplesTemplate_in_constructQuery1582);
								triplesTemplate();
								state._fsp--;

								}
								break;

							default :
								break loop44;
							}
						}

						match(input, Token.UP, null); 
					}

					pushFollow(FOLLOW_solutionModifier_in_constructQuery1586);
					solutionModifier();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "constructQuery"



	// $ANTLR start "describeQuery"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:448:1: describeQuery : ^( DESCRIBE ( varOrIRIref )* ( ASTERISK )* ( datasetClause )* ( whereClause )? solutionModifier ) ;
	public final void describeQuery() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:449:5: ( ^( DESCRIBE ( varOrIRIref )* ( ASTERISK )* ( datasetClause )* ( whereClause )? solutionModifier ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:449:7: ^( DESCRIBE ( varOrIRIref )* ( ASTERISK )* ( datasetClause )* ( whereClause )? solutionModifier )
			{
			match(input,DESCRIBE,FOLLOW_DESCRIBE_in_describeQuery1605); 
			if ( input.LA(1)==Token.DOWN ) {
				match(input, Token.DOWN, null); 
				// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:449:18: ( varOrIRIref )*
				loop46:
				while (true) {
					int alt46=2;
					int LA46_0 = input.LA(1);
					if ( (LA46_0==IRI_REF||(LA46_0 >= PNAME_LN && LA46_0 <= PNAME_NS)||LA46_0==VAR) ) {
						alt46=1;
					}

					switch (alt46) {
					case 1 :
						// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:449:18: varOrIRIref
						{
						pushFollow(FOLLOW_varOrIRIref_in_describeQuery1607);
						varOrIRIref();
						state._fsp--;

						}
						break;

					default :
						break loop46;
					}
				}

				// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:449:31: ( ASTERISK )*
				loop47:
				while (true) {
					int alt47=2;
					int LA47_0 = input.LA(1);
					if ( (LA47_0==ASTERISK) ) {
						alt47=1;
					}

					switch (alt47) {
					case 1 :
						// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:449:31: ASTERISK
						{
						match(input,ASTERISK,FOLLOW_ASTERISK_in_describeQuery1610); 
						}
						break;

					default :
						break loop47;
					}
				}

				// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:449:41: ( datasetClause )*
				loop48:
				while (true) {
					int alt48=2;
					int LA48_0 = input.LA(1);
					if ( (LA48_0==FROM) ) {
						alt48=1;
					}

					switch (alt48) {
					case 1 :
						// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:449:41: datasetClause
						{
						pushFollow(FOLLOW_datasetClause_in_describeQuery1613);
						datasetClause();
						state._fsp--;

						}
						break;

					default :
						break loop48;
					}
				}

				// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:449:56: ( whereClause )?
				int alt49=2;
				int LA49_0 = input.LA(1);
				if ( (LA49_0==WHERE_CLAUSE) ) {
					alt49=1;
				}
				switch (alt49) {
					case 1 :
						// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:449:56: whereClause
						{
						pushFollow(FOLLOW_whereClause_in_describeQuery1616);
						whereClause();
						state._fsp--;

						}
						break;

				}

				pushFollow(FOLLOW_solutionModifier_in_describeQuery1619);
				solutionModifier();
				state._fsp--;

				match(input, Token.UP, null); 
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "describeQuery"



	// $ANTLR start "askQuery"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:452:1: askQuery : ^( ASK ( datasetClause )* whereClause ) ;
	public final void askQuery() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:453:5: ( ^( ASK ( datasetClause )* whereClause ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:453:7: ^( ASK ( datasetClause )* whereClause )
			{
			match(input,ASK,FOLLOW_ASK_in_askQuery1638); 
			match(input, Token.DOWN, null); 
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:453:13: ( datasetClause )*
			loop50:
			while (true) {
				int alt50=2;
				int LA50_0 = input.LA(1);
				if ( (LA50_0==FROM) ) {
					alt50=1;
				}

				switch (alt50) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:453:13: datasetClause
					{
					pushFollow(FOLLOW_datasetClause_in_askQuery1640);
					datasetClause();
					state._fsp--;

					}
					break;

				default :
					break loop50;
				}
			}

			pushFollow(FOLLOW_whereClause_in_askQuery1643);
			whereClause();
			state._fsp--;

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "askQuery"



	// $ANTLR start "datasetClause"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:456:1: datasetClause : ^( FROM ( NAMED )? iriRef ) ;
	public final void datasetClause() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:457:5: ( ^( FROM ( NAMED )? iriRef ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:457:7: ^( FROM ( NAMED )? iriRef )
			{
			match(input,FROM,FOLLOW_FROM_in_datasetClause1662); 
			match(input, Token.DOWN, null); 
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:457:14: ( NAMED )?
			int alt51=2;
			int LA51_0 = input.LA(1);
			if ( (LA51_0==NAMED) ) {
				alt51=1;
			}
			switch (alt51) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:457:14: NAMED
					{
					match(input,NAMED,FOLLOW_NAMED_in_datasetClause1664); 
					}
					break;

			}

			pushFollow(FOLLOW_iriRef_in_datasetClause1667);
			iriRef();
			state._fsp--;

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "datasetClause"



	// $ANTLR start "whereClause"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:460:1: whereClause : ^( WHERE_CLAUSE groupGraphPattern ) ;
	public final void whereClause() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:461:5: ( ^( WHERE_CLAUSE groupGraphPattern ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:461:7: ^( WHERE_CLAUSE groupGraphPattern )
			{
			match(input,WHERE_CLAUSE,FOLLOW_WHERE_CLAUSE_in_whereClause1686); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_groupGraphPattern_in_whereClause1688);
			groupGraphPattern();
			state._fsp--;

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "whereClause"



	// $ANTLR start "solutionModifier"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:464:1: solutionModifier : ( groupClause )? ( havingClause )? ( orderClause )? ( limitOffsetClauses )? ;
	public final void solutionModifier() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:465:5: ( ( groupClause )? ( havingClause )? ( orderClause )? ( limitOffsetClauses )? )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:465:7: ( groupClause )? ( havingClause )? ( orderClause )? ( limitOffsetClauses )?
			{
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:465:7: ( groupClause )?
			int alt52=2;
			int LA52_0 = input.LA(1);
			if ( (LA52_0==GROUP_BY) ) {
				alt52=1;
			}
			switch (alt52) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:465:7: groupClause
					{
					pushFollow(FOLLOW_groupClause_in_solutionModifier1706);
					groupClause();
					state._fsp--;

					}
					break;

			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:465:20: ( havingClause )?
			int alt53=2;
			int LA53_0 = input.LA(1);
			if ( (LA53_0==HAVING) ) {
				alt53=1;
			}
			switch (alt53) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:465:20: havingClause
					{
					pushFollow(FOLLOW_havingClause_in_solutionModifier1709);
					havingClause();
					state._fsp--;

					}
					break;

			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:465:34: ( orderClause )?
			int alt54=2;
			int LA54_0 = input.LA(1);
			if ( (LA54_0==ORDER_BY) ) {
				alt54=1;
			}
			switch (alt54) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:465:34: orderClause
					{
					pushFollow(FOLLOW_orderClause_in_solutionModifier1712);
					orderClause();
					state._fsp--;

					}
					break;

			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:465:47: ( limitOffsetClauses )?
			int alt55=2;
			int LA55_0 = input.LA(1);
			if ( (LA55_0==LIMIT||LA55_0==OFFSET) ) {
				alt55=1;
			}
			switch (alt55) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:465:47: limitOffsetClauses
					{
					pushFollow(FOLLOW_limitOffsetClauses_in_solutionModifier1715);
					limitOffsetClauses();
					state._fsp--;

					}
					break;

			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "solutionModifier"



	// $ANTLR start "groupClause"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:468:1: groupClause : ^( GROUP_BY ( groupCondition )+ ) ;
	public final void groupClause() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:469:5: ( ^( GROUP_BY ( groupCondition )+ ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:469:7: ^( GROUP_BY ( groupCondition )+ )
			{
			match(input,GROUP_BY,FOLLOW_GROUP_BY_in_groupClause1734); 
			match(input, Token.DOWN, null); 
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:469:18: ( groupCondition )+
			int cnt56=0;
			loop56:
			while (true) {
				int alt56=2;
				int LA56_0 = input.LA(1);
				if ( (LA56_0==ABS||LA56_0==AS||(LA56_0 >= BNODE && LA56_0 <= BOUND)||LA56_0==CEIL||LA56_0==COALESCE||LA56_0==CONCAT||LA56_0==CONTAINS||(LA56_0 >= DATATYPE && LA56_0 <= DAY)||LA56_0==ENCODE_FOR_URI||LA56_0==EXISTS||LA56_0==FLOOR||LA56_0==FUNCTION||(LA56_0 >= HOURS && LA56_0 <= IF)||LA56_0==IRI||(LA56_0 >= ISBLANK && LA56_0 <= ISURI)||(LA56_0 >= LANG && LA56_0 <= LANGMATCHES)||LA56_0==LCASE||LA56_0==MD5||LA56_0==MINUTES||LA56_0==MONTH||(LA56_0 >= NOT_EXISTS && LA56_0 <= NOW)||LA56_0==RAND||LA56_0==REGEX||(LA56_0 >= ROUND && LA56_0 <= SAMETERM)||LA56_0==SECONDS||(LA56_0 >= SHA1 && LA56_0 <= SHA512)||(LA56_0 >= STR && LA56_0 <= STRENDS)||(LA56_0 >= STRLANG && LA56_0 <= STRSTARTS)||LA56_0==SUBSTR||LA56_0==TIMEZONE||(LA56_0 >= TZ && LA56_0 <= UCASE)||LA56_0==URI||LA56_0==VAR||LA56_0==YEAR) ) {
					alt56=1;
				}

				switch (alt56) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:469:18: groupCondition
					{
					pushFollow(FOLLOW_groupCondition_in_groupClause1736);
					groupCondition();
					state._fsp--;

					}
					break;

				default :
					if ( cnt56 >= 1 ) break loop56;
					EarlyExitException eee = new EarlyExitException(56, input);
					throw eee;
				}
				cnt56++;
			}

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "groupClause"



	// $ANTLR start "groupCondition"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:472:1: groupCondition : ( builtInCall | functionCall | ^( AS expression ( var )* ) | var );
	public final void groupCondition() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:473:5: ( builtInCall | functionCall | ^( AS expression ( var )* ) | var )
			int alt58=4;
			switch ( input.LA(1) ) {
			case ABS:
			case BNODE:
			case BOUND:
			case CEIL:
			case COALESCE:
			case CONCAT:
			case CONTAINS:
			case DATATYPE:
			case DAY:
			case ENCODE_FOR_URI:
			case EXISTS:
			case FLOOR:
			case HOURS:
			case IF:
			case IRI:
			case ISBLANK:
			case ISIRI:
			case ISLITERAL:
			case ISNUMERIC:
			case ISURI:
			case LANG:
			case LANGMATCHES:
			case LCASE:
			case MD5:
			case MINUTES:
			case MONTH:
			case NOT_EXISTS:
			case NOW:
			case RAND:
			case REGEX:
			case ROUND:
			case SAMETERM:
			case SECONDS:
			case SHA1:
			case SHA224:
			case SHA256:
			case SHA384:
			case SHA512:
			case STR:
			case STRDT:
			case STRENDS:
			case STRLANG:
			case STRLEN:
			case STRSTARTS:
			case SUBSTR:
			case TIMEZONE:
			case TZ:
			case UCASE:
			case URI:
			case YEAR:
				{
				alt58=1;
				}
				break;
			case FUNCTION:
				{
				alt58=2;
				}
				break;
			case AS:
				{
				alt58=3;
				}
				break;
			case VAR:
				{
				alt58=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 58, 0, input);
				throw nvae;
			}
			switch (alt58) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:473:7: builtInCall
					{
					pushFollow(FOLLOW_builtInCall_in_groupCondition1755);
					builtInCall();
					state._fsp--;

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:474:7: functionCall
					{
					pushFollow(FOLLOW_functionCall_in_groupCondition1763);
					functionCall();
					state._fsp--;

					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:475:7: ^( AS expression ( var )* )
					{
					match(input,AS,FOLLOW_AS_in_groupCondition1772); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_groupCondition1774);
					expression();
					state._fsp--;

					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:475:23: ( var )*
					loop57:
					while (true) {
						int alt57=2;
						int LA57_0 = input.LA(1);
						if ( (LA57_0==VAR) ) {
							alt57=1;
						}

						switch (alt57) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:475:23: var
							{
							pushFollow(FOLLOW_var_in_groupCondition1776);
							var();
							state._fsp--;

							}
							break;

						default :
							break loop57;
						}
					}

					match(input, Token.UP, null); 

					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:476:7: var
					{
					pushFollow(FOLLOW_var_in_groupCondition1786);
					var();
					state._fsp--;

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "groupCondition"



	// $ANTLR start "havingClause"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:479:1: havingClause : ^( HAVING ( constraint )+ ) ;
	public final void havingClause() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:480:5: ( ^( HAVING ( constraint )+ ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:480:7: ^( HAVING ( constraint )+ )
			{
			match(input,HAVING,FOLLOW_HAVING_in_havingClause1804); 
			match(input, Token.DOWN, null); 
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:480:16: ( constraint )+
			int cnt59=0;
			loop59:
			while (true) {
				int alt59=2;
				int LA59_0 = input.LA(1);
				if ( (LA59_0==ABS||LA59_0==AND||LA59_0==ASTERISK||(LA59_0 >= BNODE && LA59_0 <= BOUND)||LA59_0==CEIL||LA59_0==COALESCE||LA59_0==CONCAT||LA59_0==CONTAINS||(LA59_0 >= DATATYPE && LA59_0 <= DAY)||LA59_0==DIVIDE||LA59_0==ENCODE_FOR_URI||(LA59_0 >= EQUAL && LA59_0 <= EXISTS)||LA59_0==FLOOR||LA59_0==FUNCTION||(LA59_0 >= GREATER && LA59_0 <= GREATER_EQUAL)||(LA59_0 >= HOURS && LA59_0 <= IF)||LA59_0==IN||LA59_0==IRI||(LA59_0 >= ISBLANK && LA59_0 <= ISURI)||(LA59_0 >= LANG && LA59_0 <= LANGMATCHES)||(LA59_0 >= LCASE && LA59_0 <= LESS_EQUAL)||LA59_0==MD5||LA59_0==MINUS||LA59_0==MINUTES||LA59_0==MONTH||(LA59_0 >= NOT && LA59_0 <= NOW)||LA59_0==OR||LA59_0==PLUS||LA59_0==RAND||LA59_0==REGEX||(LA59_0 >= ROUND && LA59_0 <= SAMETERM)||LA59_0==SECONDS||(LA59_0 >= SHA1 && LA59_0 <= SHA512)||(LA59_0 >= STR && LA59_0 <= STRENDS)||(LA59_0 >= STRLANG && LA59_0 <= STRSTARTS)||LA59_0==SUBSTR||LA59_0==TIMEZONE||(LA59_0 >= TZ && LA59_0 <= UNARY_PLUS)||LA59_0==URI||LA59_0==YEAR) ) {
					alt59=1;
				}

				switch (alt59) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:480:16: constraint
					{
					pushFollow(FOLLOW_constraint_in_havingClause1806);
					constraint();
					state._fsp--;

					}
					break;

				default :
					if ( cnt59 >= 1 ) break loop59;
					EarlyExitException eee = new EarlyExitException(59, input);
					throw eee;
				}
				cnt59++;
			}

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "havingClause"



	// $ANTLR start "orderClause"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:483:1: orderClause : ^( ORDER_BY ( orderCondition )+ ) ;
	public final void orderClause() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:484:5: ( ^( ORDER_BY ( orderCondition )+ ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:484:7: ^( ORDER_BY ( orderCondition )+ )
			{
			match(input,ORDER_BY,FOLLOW_ORDER_BY_in_orderClause1826); 
			match(input, Token.DOWN, null); 
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:484:18: ( orderCondition )+
			int cnt60=0;
			loop60:
			while (true) {
				int alt60=2;
				int LA60_0 = input.LA(1);
				if ( (LA60_0==ORDER_CONDITION) ) {
					alt60=1;
				}

				switch (alt60) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:484:18: orderCondition
					{
					pushFollow(FOLLOW_orderCondition_in_orderClause1828);
					orderCondition();
					state._fsp--;

					}
					break;

				default :
					if ( cnt60 >= 1 ) break loop60;
					EarlyExitException eee = new EarlyExitException(60, input);
					throw eee;
				}
				cnt60++;
			}

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "orderClause"



	// $ANTLR start "orderCondition"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:487:1: orderCondition : ( ^( ORDER_CONDITION ASC expression ) | ^( ORDER_CONDITION DESC expression ) | ^( ORDER_CONDITION constraint ) | ^( ORDER_CONDITION var ) );
	public final void orderCondition() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:488:5: ( ^( ORDER_CONDITION ASC expression ) | ^( ORDER_CONDITION DESC expression ) | ^( ORDER_CONDITION constraint ) | ^( ORDER_CONDITION var ) )
			int alt61=4;
			int LA61_0 = input.LA(1);
			if ( (LA61_0==ORDER_CONDITION) ) {
				int LA61_1 = input.LA(2);
				if ( (LA61_1==DOWN) ) {
					switch ( input.LA(3) ) {
					case ASC:
						{
						alt61=1;
						}
						break;
					case DESC:
						{
						alt61=2;
						}
						break;
					case ABS:
					case AND:
					case ASTERISK:
					case BNODE:
					case BOUND:
					case CEIL:
					case COALESCE:
					case CONCAT:
					case CONTAINS:
					case DATATYPE:
					case DAY:
					case DIVIDE:
					case ENCODE_FOR_URI:
					case EQUAL:
					case EXISTS:
					case FLOOR:
					case FUNCTION:
					case GREATER:
					case GREATER_EQUAL:
					case HOURS:
					case IF:
					case IN:
					case IRI:
					case ISBLANK:
					case ISIRI:
					case ISLITERAL:
					case ISNUMERIC:
					case ISURI:
					case LANG:
					case LANGMATCHES:
					case LCASE:
					case LESS:
					case LESS_EQUAL:
					case MD5:
					case MINUS:
					case MINUTES:
					case MONTH:
					case NOT:
					case NOT_EQUAL:
					case NOT_EXISTS:
					case NOW:
					case OR:
					case PLUS:
					case RAND:
					case REGEX:
					case ROUND:
					case SAMETERM:
					case SECONDS:
					case SHA1:
					case SHA224:
					case SHA256:
					case SHA384:
					case SHA512:
					case STR:
					case STRDT:
					case STRENDS:
					case STRLANG:
					case STRLEN:
					case STRSTARTS:
					case SUBSTR:
					case TIMEZONE:
					case TZ:
					case UCASE:
					case UNARY:
					case UNARY_MINUS:
					case UNARY_NOT:
					case UNARY_PLUS:
					case URI:
					case YEAR:
						{
						alt61=3;
						}
						break;
					case VAR:
						{
						alt61=4;
						}
						break;
					default:
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 61, 2, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 61, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 61, 0, input);
				throw nvae;
			}

			switch (alt61) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:488:7: ^( ORDER_CONDITION ASC expression )
					{
					match(input,ORDER_CONDITION,FOLLOW_ORDER_CONDITION_in_orderCondition1848); 
					match(input, Token.DOWN, null); 
					match(input,ASC,FOLLOW_ASC_in_orderCondition1850); 
					pushFollow(FOLLOW_expression_in_orderCondition1852);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:489:7: ^( ORDER_CONDITION DESC expression )
					{
					match(input,ORDER_CONDITION,FOLLOW_ORDER_CONDITION_in_orderCondition1862); 
					match(input, Token.DOWN, null); 
					match(input,DESC,FOLLOW_DESC_in_orderCondition1864); 
					pushFollow(FOLLOW_expression_in_orderCondition1866);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:490:7: ^( ORDER_CONDITION constraint )
					{
					match(input,ORDER_CONDITION,FOLLOW_ORDER_CONDITION_in_orderCondition1876); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_constraint_in_orderCondition1878);
					constraint();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:491:7: ^( ORDER_CONDITION var )
					{
					match(input,ORDER_CONDITION,FOLLOW_ORDER_CONDITION_in_orderCondition1888); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_var_in_orderCondition1890);
					var();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "orderCondition"



	// $ANTLR start "limitOffsetClauses"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:494:1: limitOffsetClauses : ( ^( LIMIT INTEGER ) ( ^( OFFSET INTEGER ) )* | ^( OFFSET INTEGER ) ( ^( LIMIT INTEGER ) )* );
	public final void limitOffsetClauses() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:495:5: ( ^( LIMIT INTEGER ) ( ^( OFFSET INTEGER ) )* | ^( OFFSET INTEGER ) ( ^( LIMIT INTEGER ) )* )
			int alt64=2;
			int LA64_0 = input.LA(1);
			if ( (LA64_0==LIMIT) ) {
				alt64=1;
			}
			else if ( (LA64_0==OFFSET) ) {
				alt64=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 64, 0, input);
				throw nvae;
			}

			switch (alt64) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:495:7: ^( LIMIT INTEGER ) ( ^( OFFSET INTEGER ) )*
					{
					match(input,LIMIT,FOLLOW_LIMIT_in_limitOffsetClauses1909); 
					match(input, Token.DOWN, null); 
					match(input,INTEGER,FOLLOW_INTEGER_in_limitOffsetClauses1911); 
					match(input, Token.UP, null); 

					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:495:24: ( ^( OFFSET INTEGER ) )*
					loop62:
					while (true) {
						int alt62=2;
						int LA62_0 = input.LA(1);
						if ( (LA62_0==OFFSET) ) {
							alt62=1;
						}

						switch (alt62) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:495:25: ^( OFFSET INTEGER )
							{
							match(input,OFFSET,FOLLOW_OFFSET_in_limitOffsetClauses1916); 
							match(input, Token.DOWN, null); 
							match(input,INTEGER,FOLLOW_INTEGER_in_limitOffsetClauses1918); 
							match(input, Token.UP, null); 

							}
							break;

						default :
							break loop62;
						}
					}

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:496:7: ^( OFFSET INTEGER ) ( ^( LIMIT INTEGER ) )*
					{
					match(input,OFFSET,FOLLOW_OFFSET_in_limitOffsetClauses1930); 
					match(input, Token.DOWN, null); 
					match(input,INTEGER,FOLLOW_INTEGER_in_limitOffsetClauses1932); 
					match(input, Token.UP, null); 

					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:496:25: ( ^( LIMIT INTEGER ) )*
					loop63:
					while (true) {
						int alt63=2;
						int LA63_0 = input.LA(1);
						if ( (LA63_0==LIMIT) ) {
							alt63=1;
						}

						switch (alt63) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:496:26: ^( LIMIT INTEGER )
							{
							match(input,LIMIT,FOLLOW_LIMIT_in_limitOffsetClauses1937); 
							match(input, Token.DOWN, null); 
							match(input,INTEGER,FOLLOW_INTEGER_in_limitOffsetClauses1939); 
							match(input, Token.UP, null); 

							}
							break;

						default :
							break loop63;
						}
					}

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "limitOffsetClauses"



	// $ANTLR start "bindingsClause"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:500:1: bindingsClause : ^( BINDINGS ( var )* ( bindingValueList )* ) ;
	public final void bindingsClause() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:501:5: ( ^( BINDINGS ( var )* ( bindingValueList )* ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:501:7: ^( BINDINGS ( var )* ( bindingValueList )* )
			{
			match(input,BINDINGS,FOLLOW_BINDINGS_in_bindingsClause1961); 
			if ( input.LA(1)==Token.DOWN ) {
				match(input, Token.DOWN, null); 
				// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:501:18: ( var )*
				loop65:
				while (true) {
					int alt65=2;
					int LA65_0 = input.LA(1);
					if ( (LA65_0==VAR) ) {
						alt65=1;
					}

					switch (alt65) {
					case 1 :
						// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:501:18: var
						{
						pushFollow(FOLLOW_var_in_bindingsClause1963);
						var();
						state._fsp--;

						}
						break;

					default :
						break loop65;
					}
				}

				// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:501:23: ( bindingValueList )*
				loop66:
				while (true) {
					int alt66=2;
					int LA66_0 = input.LA(1);
					if ( (LA66_0==BINDING_VALUE) ) {
						alt66=1;
					}

					switch (alt66) {
					case 1 :
						// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:501:23: bindingValueList
						{
						pushFollow(FOLLOW_bindingValueList_in_bindingsClause1966);
						bindingValueList();
						state._fsp--;

						}
						break;

					default :
						break loop66;
					}
				}

				match(input, Token.UP, null); 
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "bindingsClause"



	// $ANTLR start "bindingValueList"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:504:1: bindingValueList : ^( BINDING_VALUE ( bindingValue )* ) ;
	public final void bindingValueList() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:505:5: ( ^( BINDING_VALUE ( bindingValue )* ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:505:7: ^( BINDING_VALUE ( bindingValue )* )
			{
			match(input,BINDING_VALUE,FOLLOW_BINDING_VALUE_in_bindingValueList1986); 
			if ( input.LA(1)==Token.DOWN ) {
				match(input, Token.DOWN, null); 
				// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:505:23: ( bindingValue )*
				loop67:
				while (true) {
					int alt67=2;
					int LA67_0 = input.LA(1);
					if ( ((LA67_0 >= DECIMAL && LA67_0 <= DECIMAL_POSITIVE)||(LA67_0 >= DOUBLE && LA67_0 <= DOUBLE_POSITIVE)||LA67_0==FALSE||(LA67_0 >= INTEGER && LA67_0 <= INTEGER_POSITIVE)||LA67_0==IRI_REF||LA67_0==PLAIN_LITERAL||(LA67_0 >= PNAME_LN && LA67_0 <= PNAME_NS)||(LA67_0 >= TRUE && LA67_0 <= TYPED_LITERAL)||LA67_0==UNDEF) ) {
						alt67=1;
					}

					switch (alt67) {
					case 1 :
						// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:505:23: bindingValue
						{
						pushFollow(FOLLOW_bindingValue_in_bindingValueList1988);
						bindingValue();
						state._fsp--;

						}
						break;

					default :
						break loop67;
					}
				}

				match(input, Token.UP, null); 
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "bindingValueList"



	// $ANTLR start "bindingValue"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:508:1: bindingValue returns [Node value] : (a= iriRef |a= rdfLiteral | numericLiteral | booleanLiteral | UNDEF );
	public final Node bindingValue() throws RecognitionException {
		Node value = null;


		Node a =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:509:5: (a= iriRef |a= rdfLiteral | numericLiteral | booleanLiteral | UNDEF )
			int alt68=5;
			switch ( input.LA(1) ) {
			case IRI_REF:
			case PNAME_LN:
			case PNAME_NS:
				{
				alt68=1;
				}
				break;
			case PLAIN_LITERAL:
			case TYPED_LITERAL:
				{
				alt68=2;
				}
				break;
			case DECIMAL:
			case DECIMAL_NEGATIVE:
			case DECIMAL_POSITIVE:
			case DOUBLE:
			case DOUBLE_NEGATIVE:
			case DOUBLE_POSITIVE:
			case INTEGER:
			case INTEGER_NEGATIVE:
			case INTEGER_POSITIVE:
				{
				alt68=3;
				}
				break;
			case FALSE:
			case TRUE:
				{
				alt68=4;
				}
				break;
			case UNDEF:
				{
				alt68=5;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 68, 0, input);
				throw nvae;
			}
			switch (alt68) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:509:7: a= iriRef
					{
					pushFollow(FOLLOW_iriRef_in_bindingValue2013);
					a=iriRef();
					state._fsp--;

					value =a;
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:510:7: a= rdfLiteral
					{
					pushFollow(FOLLOW_rdfLiteral_in_bindingValue2025);
					a=rdfLiteral();
					state._fsp--;

					value =a;
					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:511:7: numericLiteral
					{
					pushFollow(FOLLOW_numericLiteral_in_bindingValue2035);
					numericLiteral();
					state._fsp--;

					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:512:7: booleanLiteral
					{
					pushFollow(FOLLOW_booleanLiteral_in_bindingValue2043);
					booleanLiteral();
					state._fsp--;

					}
					break;
				case 5 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:513:7: UNDEF
					{
					match(input,UNDEF,FOLLOW_UNDEF_in_bindingValue2051); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "bindingValue"



	// $ANTLR start "update"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:516:1: update : prologue ( load )* ( clear )* ( drop )* ( add )* ( move )* ( copy )* ( create )* ( insert )* ( delete )* ( modify )* ;
	public final void update() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:517:5: ( prologue ( load )* ( clear )* ( drop )* ( add )* ( move )* ( copy )* ( create )* ( insert )* ( delete )* ( modify )* )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:517:7: prologue ( load )* ( clear )* ( drop )* ( add )* ( move )* ( copy )* ( create )* ( insert )* ( delete )* ( modify )*
			{
			pushFollow(FOLLOW_prologue_in_update2068);
			prologue();
			state._fsp--;

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:517:16: ( load )*
			loop69:
			while (true) {
				int alt69=2;
				int LA69_0 = input.LA(1);
				if ( (LA69_0==LOAD) ) {
					alt69=1;
				}

				switch (alt69) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:517:16: load
					{
					pushFollow(FOLLOW_load_in_update2070);
					load();
					state._fsp--;

					}
					break;

				default :
					break loop69;
				}
			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:517:22: ( clear )*
			loop70:
			while (true) {
				int alt70=2;
				int LA70_0 = input.LA(1);
				if ( (LA70_0==CLEAR) ) {
					alt70=1;
				}

				switch (alt70) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:517:22: clear
					{
					pushFollow(FOLLOW_clear_in_update2073);
					clear();
					state._fsp--;

					}
					break;

				default :
					break loop70;
				}
			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:517:29: ( drop )*
			loop71:
			while (true) {
				int alt71=2;
				int LA71_0 = input.LA(1);
				if ( (LA71_0==DROP) ) {
					alt71=1;
				}

				switch (alt71) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:517:29: drop
					{
					pushFollow(FOLLOW_drop_in_update2076);
					drop();
					state._fsp--;

					}
					break;

				default :
					break loop71;
				}
			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:517:35: ( add )*
			loop72:
			while (true) {
				int alt72=2;
				int LA72_0 = input.LA(1);
				if ( (LA72_0==ADD) ) {
					alt72=1;
				}

				switch (alt72) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:517:35: add
					{
					pushFollow(FOLLOW_add_in_update2079);
					add();
					state._fsp--;

					}
					break;

				default :
					break loop72;
				}
			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:517:40: ( move )*
			loop73:
			while (true) {
				int alt73=2;
				int LA73_0 = input.LA(1);
				if ( (LA73_0==MOVE) ) {
					alt73=1;
				}

				switch (alt73) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:517:40: move
					{
					pushFollow(FOLLOW_move_in_update2082);
					move();
					state._fsp--;

					}
					break;

				default :
					break loop73;
				}
			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:517:46: ( copy )*
			loop74:
			while (true) {
				int alt74=2;
				int LA74_0 = input.LA(1);
				if ( (LA74_0==COPY) ) {
					alt74=1;
				}

				switch (alt74) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:517:46: copy
					{
					pushFollow(FOLLOW_copy_in_update2085);
					copy();
					state._fsp--;

					}
					break;

				default :
					break loop74;
				}
			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:517:52: ( create )*
			loop75:
			while (true) {
				int alt75=2;
				int LA75_0 = input.LA(1);
				if ( (LA75_0==CREATE) ) {
					alt75=1;
				}

				switch (alt75) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:517:52: create
					{
					pushFollow(FOLLOW_create_in_update2088);
					create();
					state._fsp--;

					}
					break;

				default :
					break loop75;
				}
			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:517:60: ( insert )*
			loop76:
			while (true) {
				int alt76=2;
				int LA76_0 = input.LA(1);
				if ( (LA76_0==INSERT) ) {
					alt76=1;
				}

				switch (alt76) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:517:60: insert
					{
					pushFollow(FOLLOW_insert_in_update2091);
					insert();
					state._fsp--;

					}
					break;

				default :
					break loop76;
				}
			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:517:68: ( delete )*
			loop77:
			while (true) {
				int alt77=2;
				int LA77_0 = input.LA(1);
				if ( (LA77_0==DELETE) ) {
					alt77=1;
				}

				switch (alt77) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:517:68: delete
					{
					pushFollow(FOLLOW_delete_in_update2094);
					delete();
					state._fsp--;

					}
					break;

				default :
					break loop77;
				}
			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:517:76: ( modify )*
			loop78:
			while (true) {
				int alt78=2;
				int LA78_0 = input.LA(1);
				if ( (LA78_0==MODIFY) ) {
					alt78=1;
				}

				switch (alt78) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:517:76: modify
					{
					pushFollow(FOLLOW_modify_in_update2097);
					modify();
					state._fsp--;

					}
					break;

				default :
					break loop78;
				}
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "update"



	// $ANTLR start "load"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:520:1: load : ^( LOAD ( SILENT )* iriRef ( graphRef )* ) ;
	public final void load() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:521:5: ( ^( LOAD ( SILENT )* iriRef ( graphRef )* ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:521:7: ^( LOAD ( SILENT )* iriRef ( graphRef )* )
			{
			match(input,LOAD,FOLLOW_LOAD_in_load2116); 
			match(input, Token.DOWN, null); 
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:521:14: ( SILENT )*
			loop79:
			while (true) {
				int alt79=2;
				int LA79_0 = input.LA(1);
				if ( (LA79_0==SILENT) ) {
					alt79=1;
				}

				switch (alt79) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:521:14: SILENT
					{
					match(input,SILENT,FOLLOW_SILENT_in_load2118); 
					}
					break;

				default :
					break loop79;
				}
			}

			pushFollow(FOLLOW_iriRef_in_load2121);
			iriRef();
			state._fsp--;

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:521:29: ( graphRef )*
			loop80:
			while (true) {
				int alt80=2;
				int LA80_0 = input.LA(1);
				if ( (LA80_0==GRAPH) ) {
					alt80=1;
				}

				switch (alt80) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:521:29: graphRef
					{
					pushFollow(FOLLOW_graphRef_in_load2123);
					graphRef();
					state._fsp--;

					}
					break;

				default :
					break loop80;
				}
			}

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "load"



	// $ANTLR start "clear"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:524:1: clear : ^( CLEAR ( SILENT )* graphRefAll ) ;
	public final void clear() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:525:5: ( ^( CLEAR ( SILENT )* graphRefAll ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:525:7: ^( CLEAR ( SILENT )* graphRefAll )
			{
			match(input,CLEAR,FOLLOW_CLEAR_in_clear2143); 
			match(input, Token.DOWN, null); 
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:525:15: ( SILENT )*
			loop81:
			while (true) {
				int alt81=2;
				int LA81_0 = input.LA(1);
				if ( (LA81_0==SILENT) ) {
					alt81=1;
				}

				switch (alt81) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:525:15: SILENT
					{
					match(input,SILENT,FOLLOW_SILENT_in_clear2145); 
					}
					break;

				default :
					break loop81;
				}
			}

			pushFollow(FOLLOW_graphRefAll_in_clear2148);
			graphRefAll();
			state._fsp--;

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "clear"



	// $ANTLR start "drop"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:528:1: drop : ^( DROP ( SILENT )* graphRefAll ) ;
	public final void drop() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:529:5: ( ^( DROP ( SILENT )* graphRefAll ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:529:7: ^( DROP ( SILENT )* graphRefAll )
			{
			match(input,DROP,FOLLOW_DROP_in_drop2167); 
			match(input, Token.DOWN, null); 
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:529:14: ( SILENT )*
			loop82:
			while (true) {
				int alt82=2;
				int LA82_0 = input.LA(1);
				if ( (LA82_0==SILENT) ) {
					alt82=1;
				}

				switch (alt82) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:529:14: SILENT
					{
					match(input,SILENT,FOLLOW_SILENT_in_drop2169); 
					}
					break;

				default :
					break loop82;
				}
			}

			pushFollow(FOLLOW_graphRefAll_in_drop2172);
			graphRefAll();
			state._fsp--;

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "drop"



	// $ANTLR start "create"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:532:1: create : ^( CREATE ( SILENT )* graphRef ) ;
	public final void create() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:533:5: ( ^( CREATE ( SILENT )* graphRef ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:533:7: ^( CREATE ( SILENT )* graphRef )
			{
			match(input,CREATE,FOLLOW_CREATE_in_create2191); 
			match(input, Token.DOWN, null); 
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:533:16: ( SILENT )*
			loop83:
			while (true) {
				int alt83=2;
				int LA83_0 = input.LA(1);
				if ( (LA83_0==SILENT) ) {
					alt83=1;
				}

				switch (alt83) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:533:16: SILENT
					{
					match(input,SILENT,FOLLOW_SILENT_in_create2193); 
					}
					break;

				default :
					break loop83;
				}
			}

			pushFollow(FOLLOW_graphRef_in_create2196);
			graphRef();
			state._fsp--;

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "create"



	// $ANTLR start "add"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:536:1: add : ^( ADD ( SILENT )* graphOrDefault graphOrDefault ) ;
	public final void add() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:537:5: ( ^( ADD ( SILENT )* graphOrDefault graphOrDefault ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:537:7: ^( ADD ( SILENT )* graphOrDefault graphOrDefault )
			{
			match(input,ADD,FOLLOW_ADD_in_add2215); 
			match(input, Token.DOWN, null); 
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:537:13: ( SILENT )*
			loop84:
			while (true) {
				int alt84=2;
				int LA84_0 = input.LA(1);
				if ( (LA84_0==SILENT) ) {
					alt84=1;
				}

				switch (alt84) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:537:13: SILENT
					{
					match(input,SILENT,FOLLOW_SILENT_in_add2217); 
					}
					break;

				default :
					break loop84;
				}
			}

			pushFollow(FOLLOW_graphOrDefault_in_add2220);
			graphOrDefault();
			state._fsp--;

			pushFollow(FOLLOW_graphOrDefault_in_add2222);
			graphOrDefault();
			state._fsp--;

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "add"



	// $ANTLR start "move"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:540:1: move : ^( MOVE ( SILENT )* graphOrDefault graphOrDefault ) ;
	public final void move() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:541:5: ( ^( MOVE ( SILENT )* graphOrDefault graphOrDefault ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:541:7: ^( MOVE ( SILENT )* graphOrDefault graphOrDefault )
			{
			match(input,MOVE,FOLLOW_MOVE_in_move2241); 
			match(input, Token.DOWN, null); 
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:541:14: ( SILENT )*
			loop85:
			while (true) {
				int alt85=2;
				int LA85_0 = input.LA(1);
				if ( (LA85_0==SILENT) ) {
					alt85=1;
				}

				switch (alt85) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:541:14: SILENT
					{
					match(input,SILENT,FOLLOW_SILENT_in_move2243); 
					}
					break;

				default :
					break loop85;
				}
			}

			pushFollow(FOLLOW_graphOrDefault_in_move2246);
			graphOrDefault();
			state._fsp--;

			pushFollow(FOLLOW_graphOrDefault_in_move2248);
			graphOrDefault();
			state._fsp--;

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "move"



	// $ANTLR start "copy"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:544:1: copy : ^( COPY ( SILENT )* graphOrDefault graphOrDefault ) ;
	public final void copy() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:545:5: ( ^( COPY ( SILENT )* graphOrDefault graphOrDefault ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:545:7: ^( COPY ( SILENT )* graphOrDefault graphOrDefault )
			{
			match(input,COPY,FOLLOW_COPY_in_copy2267); 
			match(input, Token.DOWN, null); 
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:545:14: ( SILENT )*
			loop86:
			while (true) {
				int alt86=2;
				int LA86_0 = input.LA(1);
				if ( (LA86_0==SILENT) ) {
					alt86=1;
				}

				switch (alt86) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:545:14: SILENT
					{
					match(input,SILENT,FOLLOW_SILENT_in_copy2269); 
					}
					break;

				default :
					break loop86;
				}
			}

			pushFollow(FOLLOW_graphOrDefault_in_copy2272);
			graphOrDefault();
			state._fsp--;

			pushFollow(FOLLOW_graphOrDefault_in_copy2274);
			graphOrDefault();
			state._fsp--;

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "copy"



	// $ANTLR start "insert"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:548:1: insert : ^( INSERT DATA quadPattern ) ;
	public final void insert() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:549:5: ( ^( INSERT DATA quadPattern ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:549:7: ^( INSERT DATA quadPattern )
			{
			match(input,INSERT,FOLLOW_INSERT_in_insert2293); 
			match(input, Token.DOWN, null); 
			match(input,DATA,FOLLOW_DATA_in_insert2295); 
			pushFollow(FOLLOW_quadPattern_in_insert2297);
			quadPattern();
			state._fsp--;

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "insert"



	// $ANTLR start "delete"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:552:1: delete : DELETE ( deleteData | deleteWhere ) ;
	public final void delete() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:553:5: ( DELETE ( deleteData | deleteWhere ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:553:7: DELETE ( deleteData | deleteWhere )
			{
			match(input,DELETE,FOLLOW_DELETE_in_delete2315); 
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:553:14: ( deleteData | deleteWhere )
			int alt87=2;
			int LA87_0 = input.LA(1);
			if ( (LA87_0==DELETE) ) {
				int LA87_1 = input.LA(2);
				if ( (LA87_1==DOWN) ) {
					int LA87_2 = input.LA(3);
					if ( (LA87_2==DATA) ) {
						alt87=1;
					}
					else if ( (LA87_2==WHERE) ) {
						alt87=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 87, 2, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 87, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 87, 0, input);
				throw nvae;
			}

			switch (alt87) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:553:16: deleteData
					{
					pushFollow(FOLLOW_deleteData_in_delete2319);
					deleteData();
					state._fsp--;

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:553:29: deleteWhere
					{
					pushFollow(FOLLOW_deleteWhere_in_delete2323);
					deleteWhere();
					state._fsp--;

					}
					break;

			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "delete"



	// $ANTLR start "deleteData"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:556:1: deleteData : ^( DELETE DATA quadPattern ) ;
	public final void deleteData() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:557:5: ( ^( DELETE DATA quadPattern ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:557:7: ^( DELETE DATA quadPattern )
			{
			match(input,DELETE,FOLLOW_DELETE_in_deleteData2343); 
			match(input, Token.DOWN, null); 
			match(input,DATA,FOLLOW_DATA_in_deleteData2345); 
			pushFollow(FOLLOW_quadPattern_in_deleteData2347);
			quadPattern();
			state._fsp--;

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "deleteData"



	// $ANTLR start "deleteWhere"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:560:1: deleteWhere : ^( DELETE WHERE quadPattern ) ;
	public final void deleteWhere() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:561:5: ( ^( DELETE WHERE quadPattern ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:561:7: ^( DELETE WHERE quadPattern )
			{
			match(input,DELETE,FOLLOW_DELETE_in_deleteWhere2366); 
			match(input, Token.DOWN, null); 
			match(input,WHERE,FOLLOW_WHERE_in_deleteWhere2368); 
			pushFollow(FOLLOW_quadPattern_in_deleteWhere2370);
			quadPattern();
			state._fsp--;

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "deleteWhere"



	// $ANTLR start "modify"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:564:1: modify : ( ^( MODIFY ^( WITH iriRef ) ( deleteClause )* ( insertClause )* ( usingClause )* ^( WHERE groupGraphPattern ) ) | ^( MODIFY ( deleteClause )* ( insertClause )* ( usingClause )* ^( WHERE groupGraphPattern ) ) );
	public final void modify() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:565:5: ( ^( MODIFY ^( WITH iriRef ) ( deleteClause )* ( insertClause )* ( usingClause )* ^( WHERE groupGraphPattern ) ) | ^( MODIFY ( deleteClause )* ( insertClause )* ( usingClause )* ^( WHERE groupGraphPattern ) ) )
			int alt94=2;
			int LA94_0 = input.LA(1);
			if ( (LA94_0==MODIFY) ) {
				int LA94_1 = input.LA(2);
				if ( (LA94_1==DOWN) ) {
					int LA94_2 = input.LA(3);
					if ( (LA94_2==WITH) ) {
						alt94=1;
					}
					else if ( (LA94_2==DELETE||LA94_2==INSERT||LA94_2==USING||LA94_2==WHERE) ) {
						alt94=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 94, 2, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 94, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 94, 0, input);
				throw nvae;
			}

			switch (alt94) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:565:7: ^( MODIFY ^( WITH iriRef ) ( deleteClause )* ( insertClause )* ( usingClause )* ^( WHERE groupGraphPattern ) )
					{
					match(input,MODIFY,FOLLOW_MODIFY_in_modify2389); 
					match(input, Token.DOWN, null); 
					match(input,WITH,FOLLOW_WITH_in_modify2392); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_iriRef_in_modify2394);
					iriRef();
					state._fsp--;

					match(input, Token.UP, null); 

					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:565:31: ( deleteClause )*
					loop88:
					while (true) {
						int alt88=2;
						int LA88_0 = input.LA(1);
						if ( (LA88_0==DELETE) ) {
							alt88=1;
						}

						switch (alt88) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:565:31: deleteClause
							{
							pushFollow(FOLLOW_deleteClause_in_modify2397);
							deleteClause();
							state._fsp--;

							}
							break;

						default :
							break loop88;
						}
					}

					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:565:45: ( insertClause )*
					loop89:
					while (true) {
						int alt89=2;
						int LA89_0 = input.LA(1);
						if ( (LA89_0==INSERT) ) {
							alt89=1;
						}

						switch (alt89) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:565:45: insertClause
							{
							pushFollow(FOLLOW_insertClause_in_modify2400);
							insertClause();
							state._fsp--;

							}
							break;

						default :
							break loop89;
						}
					}

					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:565:59: ( usingClause )*
					loop90:
					while (true) {
						int alt90=2;
						int LA90_0 = input.LA(1);
						if ( (LA90_0==USING) ) {
							alt90=1;
						}

						switch (alt90) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:565:59: usingClause
							{
							pushFollow(FOLLOW_usingClause_in_modify2403);
							usingClause();
							state._fsp--;

							}
							break;

						default :
							break loop90;
						}
					}

					match(input,WHERE,FOLLOW_WHERE_in_modify2407); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_groupGraphPattern_in_modify2409);
					groupGraphPattern();
					state._fsp--;

					match(input, Token.UP, null); 

					match(input, Token.UP, null); 

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:566:7: ^( MODIFY ( deleteClause )* ( insertClause )* ( usingClause )* ^( WHERE groupGraphPattern ) )
					{
					match(input,MODIFY,FOLLOW_MODIFY_in_modify2420); 
					match(input, Token.DOWN, null); 
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:566:16: ( deleteClause )*
					loop91:
					while (true) {
						int alt91=2;
						int LA91_0 = input.LA(1);
						if ( (LA91_0==DELETE) ) {
							alt91=1;
						}

						switch (alt91) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:566:16: deleteClause
							{
							pushFollow(FOLLOW_deleteClause_in_modify2422);
							deleteClause();
							state._fsp--;

							}
							break;

						default :
							break loop91;
						}
					}

					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:566:30: ( insertClause )*
					loop92:
					while (true) {
						int alt92=2;
						int LA92_0 = input.LA(1);
						if ( (LA92_0==INSERT) ) {
							alt92=1;
						}

						switch (alt92) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:566:30: insertClause
							{
							pushFollow(FOLLOW_insertClause_in_modify2425);
							insertClause();
							state._fsp--;

							}
							break;

						default :
							break loop92;
						}
					}

					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:566:44: ( usingClause )*
					loop93:
					while (true) {
						int alt93=2;
						int LA93_0 = input.LA(1);
						if ( (LA93_0==USING) ) {
							alt93=1;
						}

						switch (alt93) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:566:44: usingClause
							{
							pushFollow(FOLLOW_usingClause_in_modify2428);
							usingClause();
							state._fsp--;

							}
							break;

						default :
							break loop93;
						}
					}

					match(input,WHERE,FOLLOW_WHERE_in_modify2432); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_groupGraphPattern_in_modify2434);
					groupGraphPattern();
					state._fsp--;

					match(input, Token.UP, null); 

					match(input, Token.UP, null); 

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "modify"



	// $ANTLR start "deleteClause"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:569:1: deleteClause : DELETE quadPattern ;
	public final void deleteClause() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:570:5: ( DELETE quadPattern )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:570:7: DELETE quadPattern
			{
			match(input,DELETE,FOLLOW_DELETE_in_deleteClause2453); 
			pushFollow(FOLLOW_quadPattern_in_deleteClause2455);
			quadPattern();
			state._fsp--;

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "deleteClause"



	// $ANTLR start "insertClause"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:573:1: insertClause : INSERT quadPattern ;
	public final void insertClause() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:574:5: ( INSERT quadPattern )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:574:7: INSERT quadPattern
			{
			match(input,INSERT,FOLLOW_INSERT_in_insertClause2472); 
			pushFollow(FOLLOW_quadPattern_in_insertClause2474);
			quadPattern();
			state._fsp--;

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "insertClause"



	// $ANTLR start "usingClause"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:577:1: usingClause : ^( USING ( NAMED )? iriRef ) ;
	public final void usingClause() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:578:5: ( ^( USING ( NAMED )? iriRef ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:578:7: ^( USING ( NAMED )? iriRef )
			{
			match(input,USING,FOLLOW_USING_in_usingClause2492); 
			match(input, Token.DOWN, null); 
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:578:15: ( NAMED )?
			int alt95=2;
			int LA95_0 = input.LA(1);
			if ( (LA95_0==NAMED) ) {
				alt95=1;
			}
			switch (alt95) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:578:15: NAMED
					{
					match(input,NAMED,FOLLOW_NAMED_in_usingClause2494); 
					}
					break;

			}

			pushFollow(FOLLOW_iriRef_in_usingClause2497);
			iriRef();
			state._fsp--;

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "usingClause"



	// $ANTLR start "graphOrDefault"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:581:1: graphOrDefault : ( DEFAULT | ( GRAPH )? iriRef );
	public final void graphOrDefault() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:582:5: ( DEFAULT | ( GRAPH )? iriRef )
			int alt97=2;
			int LA97_0 = input.LA(1);
			if ( (LA97_0==DEFAULT) ) {
				alt97=1;
			}
			else if ( (LA97_0==GRAPH||LA97_0==IRI_REF||(LA97_0 >= PNAME_LN && LA97_0 <= PNAME_NS)) ) {
				alt97=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 97, 0, input);
				throw nvae;
			}

			switch (alt97) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:582:7: DEFAULT
					{
					match(input,DEFAULT,FOLLOW_DEFAULT_in_graphOrDefault2515); 
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:583:7: ( GRAPH )? iriRef
					{
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:583:7: ( GRAPH )?
					int alt96=2;
					int LA96_0 = input.LA(1);
					if ( (LA96_0==GRAPH) ) {
						alt96=1;
					}
					switch (alt96) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:583:7: GRAPH
							{
							match(input,GRAPH,FOLLOW_GRAPH_in_graphOrDefault2523); 
							}
							break;

					}

					pushFollow(FOLLOW_iriRef_in_graphOrDefault2526);
					iriRef();
					state._fsp--;

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "graphOrDefault"



	// $ANTLR start "graphRef"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:586:1: graphRef : GRAPH iriRef ;
	public final void graphRef() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:587:5: ( GRAPH iriRef )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:587:7: GRAPH iriRef
			{
			match(input,GRAPH,FOLLOW_GRAPH_in_graphRef2543); 
			pushFollow(FOLLOW_iriRef_in_graphRef2545);
			iriRef();
			state._fsp--;

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "graphRef"



	// $ANTLR start "graphRefAll"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:590:1: graphRefAll : ( graphRef | DEFAULT | NAMED | ALL );
	public final void graphRefAll() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:591:5: ( graphRef | DEFAULT | NAMED | ALL )
			int alt98=4;
			switch ( input.LA(1) ) {
			case GRAPH:
				{
				alt98=1;
				}
				break;
			case DEFAULT:
				{
				alt98=2;
				}
				break;
			case NAMED:
				{
				alt98=3;
				}
				break;
			case ALL:
				{
				alt98=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 98, 0, input);
				throw nvae;
			}
			switch (alt98) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:591:7: graphRef
					{
					pushFollow(FOLLOW_graphRef_in_graphRefAll2562);
					graphRef();
					state._fsp--;

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:591:18: DEFAULT
					{
					match(input,DEFAULT,FOLLOW_DEFAULT_in_graphRefAll2566); 
					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:591:28: NAMED
					{
					match(input,NAMED,FOLLOW_NAMED_in_graphRefAll2570); 
					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:591:36: ALL
					{
					match(input,ALL,FOLLOW_ALL_in_graphRefAll2574); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "graphRefAll"



	// $ANTLR start "quadPattern"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:594:1: quadPattern returns [QuadPattern value] : a= quads ;
	public final QuadPattern quadPattern() throws RecognitionException {
		QuadPattern value = null;


		QuadPattern a =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:595:5: (a= quads )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:595:7: a= quads
			{
			pushFollow(FOLLOW_quads_in_quadPattern2597);
			a=quads();
			state._fsp--;

			value = a;
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "quadPattern"



	// $ANTLR start "quads"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:598:1: quads returns [QuadPattern value] : (a= triplesTemplate )? ( quadsNotTriples[$value] (c= triplesTemplate )? )* ;
	public final QuadPattern quads() throws RecognitionException {
		QuadPattern value = null;


		BasicPattern a =null;
		BasicPattern c =null;

		value = new QuadPattern();
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:600:5: ( (a= triplesTemplate )? ( quadsNotTriples[$value] (c= triplesTemplate )? )* )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:600:7: (a= triplesTemplate )? ( quadsNotTriples[$value] (c= triplesTemplate )? )*
			{
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:600:7: (a= triplesTemplate )?
			int alt99=2;
			int LA99_0 = input.LA(1);
			if ( (LA99_0==TRIPLES_TEMPLATE) ) {
				alt99=1;
			}
			switch (alt99) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:600:8: a= triplesTemplate
					{
					pushFollow(FOLLOW_triplesTemplate_in_quads2630);
					a=triplesTemplate();
					state._fsp--;

					value.addAll(QuadPatternUtils.toQuadPattern(getDefaultGraph(), a));
					}
					break;

			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:600:106: ( quadsNotTriples[$value] (c= triplesTemplate )? )*
			loop101:
			while (true) {
				int alt101=2;
				int LA101_0 = input.LA(1);
				if ( (LA101_0==GRAPH_TOKEN) ) {
					alt101=1;
				}

				switch (alt101) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:600:108: quadsNotTriples[$value] (c= triplesTemplate )?
					{
					pushFollow(FOLLOW_quadsNotTriples_in_quads2638);
					quadsNotTriples(value);
					state._fsp--;

					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:600:132: (c= triplesTemplate )?
					int alt100=2;
					int LA100_0 = input.LA(1);
					if ( (LA100_0==TRIPLES_TEMPLATE) ) {
						alt100=1;
					}
					switch (alt100) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:600:133: c= triplesTemplate
							{
							pushFollow(FOLLOW_triplesTemplate_in_quads2644);
							c=triplesTemplate();
							state._fsp--;

							value.addAll(QuadPatternUtils.toQuadPattern(getDefaultGraph(), c));
							}
							break;

					}

					}
					break;

				default :
					break loop101;
				}
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "quads"



	// $ANTLR start "quadsNotTriples"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:603:1: quadsNotTriples[QuadPattern value] : ^( GRAPH_TOKEN a= varOrIRIref (b= triplesTemplate )? ) ;
	public final void quadsNotTriples(QuadPattern value) throws RecognitionException {
		Node a =null;
		BasicPattern b =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:605:5: ( ^( GRAPH_TOKEN a= varOrIRIref (b= triplesTemplate )? ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:605:7: ^( GRAPH_TOKEN a= varOrIRIref (b= triplesTemplate )? )
			{
			match(input,GRAPH_TOKEN,FOLLOW_GRAPH_TOKEN_in_quadsNotTriples2677); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_varOrIRIref_in_quadsNotTriples2681);
			a=varOrIRIref();
			state._fsp--;

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:605:36: (b= triplesTemplate )?
			int alt102=2;
			int LA102_0 = input.LA(1);
			if ( (LA102_0==TRIPLES_TEMPLATE) ) {
				alt102=1;
			}
			switch (alt102) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:605:36: b= triplesTemplate
					{
					pushFollow(FOLLOW_triplesTemplate_in_quadsNotTriples2685);
					b=triplesTemplate();
					state._fsp--;

					}
					break;

			}

			match(input, Token.UP, null); 

			value.addAll(QuadPatternUtils.toQuadPattern(a, b));
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "quadsNotTriples"



	// $ANTLR start "triplesTemplate"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:615:1: triplesTemplate returns [BasicPattern value] : ^( TRIPLES_TEMPLATE a= triples ) ;
	public final BasicPattern triplesTemplate() throws RecognitionException {
		BasicPattern value = null;


		BasicPattern a =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:616:5: ( ^( TRIPLES_TEMPLATE a= triples ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:616:7: ^( TRIPLES_TEMPLATE a= triples )
			{
			match(input,TRIPLES_TEMPLATE,FOLLOW_TRIPLES_TEMPLATE_in_triplesTemplate2714); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_triples_in_triplesTemplate2718);
			a=triples();
			state._fsp--;

			value = a;
			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "triplesTemplate"



	// $ANTLR start "groupGraphPattern"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:619:1: groupGraphPattern : ( ^( GROUP_GRAPH_PATTERN subSelect ) | ^( GROUP_GRAPH_PATTERN groupGraphPatternSub ) );
	public final void groupGraphPattern() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:620:5: ( ^( GROUP_GRAPH_PATTERN subSelect ) | ^( GROUP_GRAPH_PATTERN groupGraphPatternSub ) )
			int alt103=2;
			int LA103_0 = input.LA(1);
			if ( (LA103_0==GROUP_GRAPH_PATTERN) ) {
				int LA103_1 = input.LA(2);
				if ( (LA103_1==DOWN) ) {
					int LA103_2 = input.LA(3);
					if ( (LA103_2==SUBSELECT) ) {
						alt103=1;
					}
					else if ( (LA103_2==UP||LA103_2==BIND||LA103_2==FILTER||LA103_2==GRAPH||LA103_2==GROUP_GRAPH_PATTERN||LA103_2==MINUS_KEYWORD||LA103_2==OPTIONAL||LA103_2==SERVICE||LA103_2==TRIPLES_BLOCK||LA103_2==UNION) ) {
						alt103=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 103, 2, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 103, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 103, 0, input);
				throw nvae;
			}

			switch (alt103) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:620:7: ^( GROUP_GRAPH_PATTERN subSelect )
					{
					match(input,GROUP_GRAPH_PATTERN,FOLLOW_GROUP_GRAPH_PATTERN_in_groupGraphPattern2739); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_subSelect_in_groupGraphPattern2741);
					subSelect();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:621:7: ^( GROUP_GRAPH_PATTERN groupGraphPatternSub )
					{
					match(input,GROUP_GRAPH_PATTERN,FOLLOW_GROUP_GRAPH_PATTERN_in_groupGraphPattern2751); 
					if ( input.LA(1)==Token.DOWN ) {
						match(input, Token.DOWN, null); 
						pushFollow(FOLLOW_groupGraphPatternSub_in_groupGraphPattern2753);
						groupGraphPatternSub();
						state._fsp--;

						match(input, Token.UP, null); 
					}

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "groupGraphPattern"



	// $ANTLR start "groupGraphPatternSub"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:624:1: groupGraphPatternSub : ( triplesBlock )? ( groupGraphPatternSubCache )* ;
	public final void groupGraphPatternSub() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:625:5: ( ( triplesBlock )? ( groupGraphPatternSubCache )* )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:625:7: ( triplesBlock )? ( groupGraphPatternSubCache )*
			{
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:625:7: ( triplesBlock )?
			int alt104=2;
			int LA104_0 = input.LA(1);
			if ( (LA104_0==TRIPLES_BLOCK) ) {
				alt104=1;
			}
			switch (alt104) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:625:7: triplesBlock
					{
					pushFollow(FOLLOW_triplesBlock_in_groupGraphPatternSub2771);
					triplesBlock();
					state._fsp--;

					}
					break;

			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:625:21: ( groupGraphPatternSubCache )*
			loop105:
			while (true) {
				int alt105=2;
				int LA105_0 = input.LA(1);
				if ( (LA105_0==BIND||LA105_0==FILTER||LA105_0==GRAPH||LA105_0==GROUP_GRAPH_PATTERN||LA105_0==MINUS_KEYWORD||LA105_0==OPTIONAL||LA105_0==SERVICE||LA105_0==UNION) ) {
					alt105=1;
				}

				switch (alt105) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:625:21: groupGraphPatternSubCache
					{
					pushFollow(FOLLOW_groupGraphPatternSubCache_in_groupGraphPatternSub2774);
					groupGraphPatternSubCache();
					state._fsp--;

					}
					break;

				default :
					break loop105;
				}
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "groupGraphPatternSub"



	// $ANTLR start "groupGraphPatternSubCache"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:628:1: groupGraphPatternSubCache : graphPatternNotTriples ( triplesBlock )? ;
	public final void groupGraphPatternSubCache() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:629:5: ( graphPatternNotTriples ( triplesBlock )? )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:629:8: graphPatternNotTriples ( triplesBlock )?
			{
			pushFollow(FOLLOW_graphPatternNotTriples_in_groupGraphPatternSubCache2793);
			graphPatternNotTriples();
			state._fsp--;

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:629:31: ( triplesBlock )?
			int alt106=2;
			int LA106_0 = input.LA(1);
			if ( (LA106_0==TRIPLES_BLOCK) ) {
				alt106=1;
			}
			switch (alt106) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:629:31: triplesBlock
					{
					pushFollow(FOLLOW_triplesBlock_in_groupGraphPatternSubCache2795);
					triplesBlock();
					state._fsp--;

					}
					break;

			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "groupGraphPatternSubCache"



	// $ANTLR start "triplesBlock"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:632:1: triplesBlock : ^( TRIPLES_BLOCK ( triplesSameSubjectPath[null] )+ ) ;
	public final void triplesBlock() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:633:5: ( ^( TRIPLES_BLOCK ( triplesSameSubjectPath[null] )+ ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:633:7: ^( TRIPLES_BLOCK ( triplesSameSubjectPath[null] )+ )
			{
			match(input,TRIPLES_BLOCK,FOLLOW_TRIPLES_BLOCK_in_triplesBlock2814); 
			match(input, Token.DOWN, null); 
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:633:23: ( triplesSameSubjectPath[null] )+
			int cnt107=0;
			loop107:
			while (true) {
				int alt107=2;
				int LA107_0 = input.LA(1);
				if ( (LA107_0==TRIPLE) ) {
					alt107=1;
				}

				switch (alt107) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:633:23: triplesSameSubjectPath[null]
					{
					pushFollow(FOLLOW_triplesSameSubjectPath_in_triplesBlock2816);
					triplesSameSubjectPath(null);
					state._fsp--;

					}
					break;

				default :
					if ( cnt107 >= 1 ) break loop107;
					EarlyExitException eee = new EarlyExitException(107, input);
					throw eee;
				}
				cnt107++;
			}

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "triplesBlock"



	// $ANTLR start "graphPatternNotTriples"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:636:1: graphPatternNotTriples : ( groupOrUnionGraphPattern | optionalGraphPattern | minusGraphPattern | graphGraphPattern | serviceGraphPattern | filter | bind );
	public final void graphPatternNotTriples() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:637:5: ( groupOrUnionGraphPattern | optionalGraphPattern | minusGraphPattern | graphGraphPattern | serviceGraphPattern | filter | bind )
			int alt108=7;
			switch ( input.LA(1) ) {
			case GROUP_GRAPH_PATTERN:
			case UNION:
				{
				alt108=1;
				}
				break;
			case OPTIONAL:
				{
				alt108=2;
				}
				break;
			case MINUS_KEYWORD:
				{
				alt108=3;
				}
				break;
			case GRAPH:
				{
				alt108=4;
				}
				break;
			case SERVICE:
				{
				alt108=5;
				}
				break;
			case FILTER:
				{
				alt108=6;
				}
				break;
			case BIND:
				{
				alt108=7;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 108, 0, input);
				throw nvae;
			}
			switch (alt108) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:637:7: groupOrUnionGraphPattern
					{
					pushFollow(FOLLOW_groupOrUnionGraphPattern_in_graphPatternNotTriples2836);
					groupOrUnionGraphPattern();
					state._fsp--;

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:637:34: optionalGraphPattern
					{
					pushFollow(FOLLOW_optionalGraphPattern_in_graphPatternNotTriples2840);
					optionalGraphPattern();
					state._fsp--;

					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:637:57: minusGraphPattern
					{
					pushFollow(FOLLOW_minusGraphPattern_in_graphPatternNotTriples2844);
					minusGraphPattern();
					state._fsp--;

					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:637:77: graphGraphPattern
					{
					pushFollow(FOLLOW_graphGraphPattern_in_graphPatternNotTriples2848);
					graphGraphPattern();
					state._fsp--;

					}
					break;
				case 5 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:637:97: serviceGraphPattern
					{
					pushFollow(FOLLOW_serviceGraphPattern_in_graphPatternNotTriples2852);
					serviceGraphPattern();
					state._fsp--;

					}
					break;
				case 6 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:637:119: filter
					{
					pushFollow(FOLLOW_filter_in_graphPatternNotTriples2856);
					filter();
					state._fsp--;

					}
					break;
				case 7 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:637:128: bind
					{
					pushFollow(FOLLOW_bind_in_graphPatternNotTriples2860);
					bind();
					state._fsp--;

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "graphPatternNotTriples"



	// $ANTLR start "optionalGraphPattern"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:640:1: optionalGraphPattern : ^( OPTIONAL groupGraphPattern ) ;
	public final void optionalGraphPattern() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:641:5: ( ^( OPTIONAL groupGraphPattern ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:641:7: ^( OPTIONAL groupGraphPattern )
			{
			match(input,OPTIONAL,FOLLOW_OPTIONAL_in_optionalGraphPattern2878); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_groupGraphPattern_in_optionalGraphPattern2880);
			groupGraphPattern();
			state._fsp--;

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "optionalGraphPattern"



	// $ANTLR start "graphGraphPattern"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:644:1: graphGraphPattern : ^( GRAPH varOrIRIref groupGraphPattern ) ;
	public final void graphGraphPattern() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:645:5: ( ^( GRAPH varOrIRIref groupGraphPattern ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:645:7: ^( GRAPH varOrIRIref groupGraphPattern )
			{
			match(input,GRAPH,FOLLOW_GRAPH_in_graphGraphPattern2899); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_varOrIRIref_in_graphGraphPattern2901);
			varOrIRIref();
			state._fsp--;

			pushFollow(FOLLOW_groupGraphPattern_in_graphGraphPattern2903);
			groupGraphPattern();
			state._fsp--;

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "graphGraphPattern"



	// $ANTLR start "serviceGraphPattern"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:648:1: serviceGraphPattern : ^( SERVICE ( SILENT )? varOrIRIref groupGraphPattern ) ;
	public final void serviceGraphPattern() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:649:5: ( ^( SERVICE ( SILENT )? varOrIRIref groupGraphPattern ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:649:7: ^( SERVICE ( SILENT )? varOrIRIref groupGraphPattern )
			{
			match(input,SERVICE,FOLLOW_SERVICE_in_serviceGraphPattern2922); 
			match(input, Token.DOWN, null); 
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:649:17: ( SILENT )?
			int alt109=2;
			int LA109_0 = input.LA(1);
			if ( (LA109_0==SILENT) ) {
				alt109=1;
			}
			switch (alt109) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:649:17: SILENT
					{
					match(input,SILENT,FOLLOW_SILENT_in_serviceGraphPattern2924); 
					}
					break;

			}

			pushFollow(FOLLOW_varOrIRIref_in_serviceGraphPattern2927);
			varOrIRIref();
			state._fsp--;

			pushFollow(FOLLOW_groupGraphPattern_in_serviceGraphPattern2929);
			groupGraphPattern();
			state._fsp--;

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "serviceGraphPattern"



	// $ANTLR start "bind"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:652:1: bind : ^( BIND expression ^( AS var ) ) ;
	public final void bind() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:653:5: ( ^( BIND expression ^( AS var ) ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:653:7: ^( BIND expression ^( AS var ) )
			{
			match(input,BIND,FOLLOW_BIND_in_bind2948); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_expression_in_bind2950);
			expression();
			state._fsp--;

			match(input,AS,FOLLOW_AS_in_bind2953); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_var_in_bind2955);
			var();
			state._fsp--;

			match(input, Token.UP, null); 

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "bind"



	// $ANTLR start "minusGraphPattern"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:656:1: minusGraphPattern : ^( MINUS_KEYWORD groupGraphPattern ) ;
	public final void minusGraphPattern() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:657:5: ( ^( MINUS_KEYWORD groupGraphPattern ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:657:7: ^( MINUS_KEYWORD groupGraphPattern )
			{
			match(input,MINUS_KEYWORD,FOLLOW_MINUS_KEYWORD_in_minusGraphPattern2975); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_groupGraphPattern_in_minusGraphPattern2977);
			groupGraphPattern();
			state._fsp--;

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "minusGraphPattern"



	// $ANTLR start "groupOrUnionGraphPattern"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:660:1: groupOrUnionGraphPattern : ( ^( UNION groupGraphPattern groupGraphPattern ) | groupGraphPattern );
	public final void groupOrUnionGraphPattern() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:661:5: ( ^( UNION groupGraphPattern groupGraphPattern ) | groupGraphPattern )
			int alt110=2;
			int LA110_0 = input.LA(1);
			if ( (LA110_0==UNION) ) {
				alt110=1;
			}
			else if ( (LA110_0==GROUP_GRAPH_PATTERN) ) {
				alt110=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 110, 0, input);
				throw nvae;
			}

			switch (alt110) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:661:7: ^( UNION groupGraphPattern groupGraphPattern )
					{
					match(input,UNION,FOLLOW_UNION_in_groupOrUnionGraphPattern2996); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_groupGraphPattern_in_groupOrUnionGraphPattern2998);
					groupGraphPattern();
					state._fsp--;

					pushFollow(FOLLOW_groupGraphPattern_in_groupOrUnionGraphPattern3000);
					groupGraphPattern();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:662:7: groupGraphPattern
					{
					pushFollow(FOLLOW_groupGraphPattern_in_groupOrUnionGraphPattern3009);
					groupGraphPattern();
					state._fsp--;

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "groupOrUnionGraphPattern"



	// $ANTLR start "filter"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:665:1: filter : ^( FILTER constraint ) ;
	public final void filter() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:666:5: ( ^( FILTER constraint ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:666:7: ^( FILTER constraint )
			{
			match(input,FILTER,FOLLOW_FILTER_in_filter3027); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_constraint_in_filter3029);
			constraint();
			state._fsp--;

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "filter"



	// $ANTLR start "constraint"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:669:1: constraint : ( expression | builtInCall | functionCall );
	public final void constraint() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:670:5: ( expression | builtInCall | functionCall )
			int alt111=3;
			switch ( input.LA(1) ) {
			case AND:
			case ASTERISK:
			case DIVIDE:
			case EQUAL:
			case GREATER:
			case GREATER_EQUAL:
			case IN:
			case LESS:
			case LESS_EQUAL:
			case MINUS:
			case NOT:
			case NOT_EQUAL:
			case OR:
			case PLUS:
			case UNARY:
			case UNARY_MINUS:
			case UNARY_NOT:
			case UNARY_PLUS:
				{
				alt111=1;
				}
				break;
			case ABS:
			case BNODE:
			case BOUND:
			case CEIL:
			case COALESCE:
			case CONCAT:
			case CONTAINS:
			case DATATYPE:
			case DAY:
			case ENCODE_FOR_URI:
			case EXISTS:
			case FLOOR:
			case HOURS:
			case IF:
			case IRI:
			case ISBLANK:
			case ISIRI:
			case ISLITERAL:
			case ISNUMERIC:
			case ISURI:
			case LANG:
			case LANGMATCHES:
			case LCASE:
			case MD5:
			case MINUTES:
			case MONTH:
			case NOT_EXISTS:
			case NOW:
			case RAND:
			case REGEX:
			case ROUND:
			case SAMETERM:
			case SECONDS:
			case SHA1:
			case SHA224:
			case SHA256:
			case SHA384:
			case SHA512:
			case STR:
			case STRDT:
			case STRENDS:
			case STRLANG:
			case STRLEN:
			case STRSTARTS:
			case SUBSTR:
			case TIMEZONE:
			case TZ:
			case UCASE:
			case URI:
			case YEAR:
				{
				alt111=2;
				}
				break;
			case FUNCTION:
				{
				alt111=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 111, 0, input);
				throw nvae;
			}
			switch (alt111) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:670:7: expression
					{
					pushFollow(FOLLOW_expression_in_constraint3047);
					expression();
					state._fsp--;

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:671:7: builtInCall
					{
					pushFollow(FOLLOW_builtInCall_in_constraint3055);
					builtInCall();
					state._fsp--;

					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:672:7: functionCall
					{
					pushFollow(FOLLOW_functionCall_in_constraint3063);
					functionCall();
					state._fsp--;

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "constraint"



	// $ANTLR start "functionCall"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:675:1: functionCall returns [Expr value] : ^( FUNCTION a= iriRef ^( ARG_LIST b= argList ) ) ;
	public final Expr functionCall() throws RecognitionException {
		Expr value = null;


		Node a =null;
		ExprList b =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:676:5: ( ^( FUNCTION a= iriRef ^( ARG_LIST b= argList ) ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:676:7: ^( FUNCTION a= iriRef ^( ARG_LIST b= argList ) )
			{
			match(input,FUNCTION,FOLLOW_FUNCTION_in_functionCall3085); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_iriRef_in_functionCall3089);
			a=iriRef();
			state._fsp--;

			match(input,ARG_LIST,FOLLOW_ARG_LIST_in_functionCall3092); 
			if ( input.LA(1)==Token.DOWN ) {
				match(input, Token.DOWN, null); 
				pushFollow(FOLLOW_argList_in_functionCall3096);
				b=argList();
				state._fsp--;

				match(input, Token.UP, null); 
			}

			match(input, Token.UP, null); 

			 value = new E_Function(a.toString(), b); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "functionCall"



	// $ANTLR start "argList"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:680:1: argList returns [ExprList value] : ( nil | ( DISTINCT )? (a= expression )* );
	public final ExprList argList() throws RecognitionException {
		ExprList value = null;


		Expr a =null;

		 value = new ExprList(); 
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:682:5: ( nil | ( DISTINCT )? (a= expression )* )
			int alt114=2;
			int LA114_0 = input.LA(1);
			if ( (LA114_0==OPEN_BRACE) ) {
				alt114=1;
			}
			else if ( (LA114_0==UP||LA114_0==AND||LA114_0==ASTERISK||(LA114_0 >= DISTINCT && LA114_0 <= DIVIDE)||LA114_0==EQUAL||(LA114_0 >= GREATER && LA114_0 <= GREATER_EQUAL)||LA114_0==IN||(LA114_0 >= LESS && LA114_0 <= LESS_EQUAL)||LA114_0==MINUS||(LA114_0 >= NOT && LA114_0 <= NOT_EQUAL)||LA114_0==OR||LA114_0==PLUS||(LA114_0 >= UNARY && LA114_0 <= UNARY_PLUS)) ) {
				alt114=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 114, 0, input);
				throw nvae;
			}

			switch (alt114) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:682:7: nil
					{
					pushFollow(FOLLOW_nil_in_argList3131);
					nil();
					state._fsp--;

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:683:7: ( DISTINCT )? (a= expression )*
					{
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:683:7: ( DISTINCT )?
					int alt112=2;
					int LA112_0 = input.LA(1);
					if ( (LA112_0==DISTINCT) ) {
						alt112=1;
					}
					switch (alt112) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:683:7: DISTINCT
							{
							match(input,DISTINCT,FOLLOW_DISTINCT_in_argList3139); 
							}
							break;

					}

					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:683:17: (a= expression )*
					loop113:
					while (true) {
						int alt113=2;
						int LA113_0 = input.LA(1);
						if ( (LA113_0==AND||LA113_0==ASTERISK||LA113_0==DIVIDE||LA113_0==EQUAL||(LA113_0 >= GREATER && LA113_0 <= GREATER_EQUAL)||LA113_0==IN||(LA113_0 >= LESS && LA113_0 <= LESS_EQUAL)||LA113_0==MINUS||(LA113_0 >= NOT && LA113_0 <= NOT_EQUAL)||LA113_0==OR||LA113_0==PLUS||(LA113_0 >= UNARY && LA113_0 <= UNARY_PLUS)) ) {
							alt113=1;
						}

						switch (alt113) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:683:18: a= expression
							{
							pushFollow(FOLLOW_expression_in_argList3145);
							a=expression();
							state._fsp--;

							value.add(a);
							}
							break;

						default :
							break loop113;
						}
					}

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "argList"



	// $ANTLR start "expressionList"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:686:1: expressionList returns [ExprList value] : ( ^( EXPRESSION_LIST (a= expression )+ ) | ^( EXPRESSION_LIST nil ) );
	public final ExprList expressionList() throws RecognitionException {
		ExprList value = null;


		Expr a =null;

		 value = new ExprList(); 
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:688:5: ( ^( EXPRESSION_LIST (a= expression )+ ) | ^( EXPRESSION_LIST nil ) )
			int alt116=2;
			int LA116_0 = input.LA(1);
			if ( (LA116_0==EXPRESSION_LIST) ) {
				int LA116_1 = input.LA(2);
				if ( (LA116_1==DOWN) ) {
					int LA116_2 = input.LA(3);
					if ( (LA116_2==AND||LA116_2==ASTERISK||LA116_2==DIVIDE||LA116_2==EQUAL||(LA116_2 >= GREATER && LA116_2 <= GREATER_EQUAL)||LA116_2==IN||(LA116_2 >= LESS && LA116_2 <= LESS_EQUAL)||LA116_2==MINUS||(LA116_2 >= NOT && LA116_2 <= NOT_EQUAL)||LA116_2==OR||LA116_2==PLUS||(LA116_2 >= UNARY && LA116_2 <= UNARY_PLUS)) ) {
						alt116=1;
					}
					else if ( (LA116_2==OPEN_BRACE) ) {
						alt116=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 116, 2, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 116, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 116, 0, input);
				throw nvae;
			}

			switch (alt116) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:688:7: ^( EXPRESSION_LIST (a= expression )+ )
					{
					match(input,EXPRESSION_LIST,FOLLOW_EXPRESSION_LIST_in_expressionList3180); 
					match(input, Token.DOWN, null); 
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:688:25: (a= expression )+
					int cnt115=0;
					loop115:
					while (true) {
						int alt115=2;
						int LA115_0 = input.LA(1);
						if ( (LA115_0==AND||LA115_0==ASTERISK||LA115_0==DIVIDE||LA115_0==EQUAL||(LA115_0 >= GREATER && LA115_0 <= GREATER_EQUAL)||LA115_0==IN||(LA115_0 >= LESS && LA115_0 <= LESS_EQUAL)||LA115_0==MINUS||(LA115_0 >= NOT && LA115_0 <= NOT_EQUAL)||LA115_0==OR||LA115_0==PLUS||(LA115_0 >= UNARY && LA115_0 <= UNARY_PLUS)) ) {
							alt115=1;
						}

						switch (alt115) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:688:26: a= expression
							{
							pushFollow(FOLLOW_expression_in_expressionList3185);
							a=expression();
							state._fsp--;

							value.add(a); 
							}
							break;

						default :
							if ( cnt115 >= 1 ) break loop115;
							EarlyExitException eee = new EarlyExitException(115, input);
							throw eee;
						}
						cnt115++;
					}

					match(input, Token.UP, null); 

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:689:7: ^( EXPRESSION_LIST nil )
					{
					match(input,EXPRESSION_LIST,FOLLOW_EXPRESSION_LIST_in_expressionList3199); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_nil_in_expressionList3201);
					nil();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "expressionList"



	// $ANTLR start "constructTemplateQuads"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:701:1: constructTemplateQuads returns [QuadPattern value] : ^( CONSTRUCT_QUADS a= quadPattern ) ;
	public final QuadPattern constructTemplateQuads() throws RecognitionException {
		QuadPattern value = null;


		QuadPattern a =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:702:5: ( ^( CONSTRUCT_QUADS a= quadPattern ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:702:7: ^( CONSTRUCT_QUADS a= quadPattern )
			{
			match(input,CONSTRUCT_QUADS,FOLLOW_CONSTRUCT_QUADS_in_constructTemplateQuads3227); 
			if ( input.LA(1)==Token.DOWN ) {
				match(input, Token.DOWN, null); 
				pushFollow(FOLLOW_quadPattern_in_constructTemplateQuads3231);
				a=quadPattern();
				state._fsp--;

				match(input, Token.UP, null); 
			}

			value = a;
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "constructTemplateQuads"



	// $ANTLR start "constructTemplate"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:706:1: constructTemplate returns [Template value] : ^( CONSTRUCT_TRIPLES a= constructTriples ) ;
	public final Template constructTemplate() throws RecognitionException {
		Template value = null;


		BasicPattern a =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:708:5: ( ^( CONSTRUCT_TRIPLES a= constructTriples ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:708:7: ^( CONSTRUCT_TRIPLES a= constructTriples )
			{
			match(input,CONSTRUCT_TRIPLES,FOLLOW_CONSTRUCT_TRIPLES_in_constructTemplate3261); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_constructTriples_in_constructTemplate3265);
			a=constructTriples();
			state._fsp--;

			match(input, Token.UP, null); 

			value = new Template(a);
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "constructTemplate"



	// $ANTLR start "constructTriples"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:712:1: constructTriples returns [BasicPattern value] : a= triples ;
	public final BasicPattern constructTriples() throws RecognitionException {
		BasicPattern value = null;


		BasicPattern a =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:713:5: (a= triples )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:713:7: a= triples
			{
			pushFollow(FOLLOW_triples_in_constructTriples3292);
			a=triples();
			state._fsp--;

			value = a;
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "constructTriples"



	// $ANTLR start "triples"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:718:1: triples returns [BasicPattern value] : ( triple[value] )+ ;
	public final BasicPattern triples() throws RecognitionException {
		BasicPattern value = null;


		value = new BasicPattern();
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:720:5: ( ( triple[value] )+ )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:720:7: ( triple[value] )+
			{
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:720:7: ( triple[value] )+
			int cnt117=0;
			loop117:
			while (true) {
				int alt117=2;
				int LA117_0 = input.LA(1);
				if ( (LA117_0==TRIPLE) ) {
					alt117=1;
				}

				switch (alt117) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:720:7: triple[value]
					{
					pushFollow(FOLLOW_triple_in_triples3326);
					triple(value);
					state._fsp--;

					}
					break;

				default :
					if ( cnt117 >= 1 ) break loop117;
					EarlyExitException eee = new EarlyExitException(117, input);
					throw eee;
				}
				cnt117++;
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "triples"



	// $ANTLR start "triple"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:723:1: triple[BasicPattern triples] : ^( TRIPLE ^( SUBJECT a= varOrTerm ) ^( PREDICATE b= verb ) ^( OBJECT c= graphNode[triples] ) ) ;
	public final void triple(BasicPattern triples) throws RecognitionException {
		Node a =null;
		Node b =null;
		Node c =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:724:5: ( ^( TRIPLE ^( SUBJECT a= varOrTerm ) ^( PREDICATE b= verb ) ^( OBJECT c= graphNode[triples] ) ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:724:7: ^( TRIPLE ^( SUBJECT a= varOrTerm ) ^( PREDICATE b= verb ) ^( OBJECT c= graphNode[triples] ) )
			{
			match(input,TRIPLE,FOLLOW_TRIPLE_in_triple3347); 
			match(input, Token.DOWN, null); 
			match(input,SUBJECT,FOLLOW_SUBJECT_in_triple3350); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_varOrTerm_in_triple3354);
			a=varOrTerm();
			state._fsp--;

			match(input, Token.UP, null); 

			match(input,PREDICATE,FOLLOW_PREDICATE_in_triple3358); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_verb_in_triple3362);
			b=verb();
			state._fsp--;

			match(input, Token.UP, null); 

			match(input,OBJECT,FOLLOW_OBJECT_in_triple3366); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_graphNode_in_triple3370);
			c=graphNode(triples);
			state._fsp--;

			match(input, Token.UP, null); 

			match(input, Token.UP, null); 

			triples.add(new Triple(a, b, c)); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "triple"



	// $ANTLR start "triplesSameSubject"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:729:1: triplesSameSubject[BasicPattern value] : TODO ;
	public final void triplesSameSubject(BasicPattern value) throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:730:5: ( TODO )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:730:7: TODO
			{
			match(input,TODO,FOLLOW_TODO_in_triplesSameSubject3395); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "triplesSameSubject"



	// $ANTLR start "objectList"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:737:1: objectList[BasicPattern triples] : ^( SUBJECT a= varOrTerm ) ^( PREDICATE b= verb ) ^( OBJECT c= graphNode[triples] ) ;
	public final void objectList(BasicPattern triples) throws RecognitionException {
		Node a =null;
		Node b =null;
		Node c =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:738:5: ( ^( SUBJECT a= varOrTerm ) ^( PREDICATE b= verb ) ^( OBJECT c= graphNode[triples] ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:738:7: ^( SUBJECT a= varOrTerm ) ^( PREDICATE b= verb ) ^( OBJECT c= graphNode[triples] )
			{
			match(input,SUBJECT,FOLLOW_SUBJECT_in_objectList3419); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_varOrTerm_in_objectList3423);
			a=varOrTerm();
			state._fsp--;

			match(input, Token.UP, null); 

			match(input,PREDICATE,FOLLOW_PREDICATE_in_objectList3427); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_verb_in_objectList3431);
			b=verb();
			state._fsp--;

			match(input, Token.UP, null); 

			match(input,OBJECT,FOLLOW_OBJECT_in_objectList3435); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_graphNode_in_objectList3439);
			c=graphNode(triples);
			state._fsp--;

			match(input, Token.UP, null); 

			triples.add(new Triple(a, b, c)); System.out.println("Created triple: " + triples); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "objectList"



	// $ANTLR start "verb"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:768:1: verb returns [ Node value ] : (a= varOrIRIref | A | path );
	public final Node verb() throws RecognitionException {
		Node value = null;


		Node a =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:769:5: (a= varOrIRIref | A | path )
			int alt118=3;
			switch ( input.LA(1) ) {
			case IRI_REF:
			case PNAME_LN:
			case PNAME_NS:
			case VAR:
				{
				alt118=1;
				}
				break;
			case A:
				{
				alt118=2;
				}
				break;
			case PATH:
				{
				alt118=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 118, 0, input);
				throw nvae;
			}
			switch (alt118) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:769:7: a= varOrIRIref
					{
					pushFollow(FOLLOW_varOrIRIref_in_verb3473);
					a=varOrIRIref();
					state._fsp--;

					 value = a; 
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:770:7: A
					{
					match(input,A,FOLLOW_A_in_verb3483); 
					 value = RDF.type.asNode(); 
					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:771:7: path
					{
					pushFollow(FOLLOW_path_in_verb3503);
					path();
					state._fsp--;

					 if(true) { throw new NotImplementedException(); } 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "verb"



	// $ANTLR start "triplesSameSubjectPath"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:774:1: triplesSameSubjectPath[BasicPattern value] : ( ^( TRIPLE objectList[value] ) | ^( TRIPLE triplesSameSubjectPath[value] ) );
	public final void triplesSameSubjectPath(BasicPattern value) throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:775:5: ( ^( TRIPLE objectList[value] ) | ^( TRIPLE triplesSameSubjectPath[value] ) )
			int alt119=2;
			int LA119_0 = input.LA(1);
			if ( (LA119_0==TRIPLE) ) {
				int LA119_1 = input.LA(2);
				if ( (LA119_1==DOWN) ) {
					int LA119_2 = input.LA(3);
					if ( (LA119_2==SUBJECT) ) {
						alt119=1;
					}
					else if ( (LA119_2==TRIPLE) ) {
						alt119=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 119, 2, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 119, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 119, 0, input);
				throw nvae;
			}

			switch (alt119) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:775:7: ^( TRIPLE objectList[value] )
					{
					match(input,TRIPLE,FOLLOW_TRIPLE_in_triplesSameSubjectPath3528); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_objectList_in_triplesSameSubjectPath3530);
					objectList(value);
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:776:7: ^( TRIPLE triplesSameSubjectPath[value] )
					{
					match(input,TRIPLE,FOLLOW_TRIPLE_in_triplesSameSubjectPath3541); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_triplesSameSubjectPath_in_triplesSameSubjectPath3543);
					triplesSameSubjectPath(value);
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "triplesSameSubjectPath"



	// $ANTLR start "path"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:779:1: path : PATH pathSequence ( PIPE pathSequence )* ;
	public final void path() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:780:5: ( PATH pathSequence ( PIPE pathSequence )* )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:780:7: PATH pathSequence ( PIPE pathSequence )*
			{
			match(input,PATH,FOLLOW_PATH_in_path3562); 
			pushFollow(FOLLOW_pathSequence_in_path3564);
			pathSequence();
			state._fsp--;

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:780:25: ( PIPE pathSequence )*
			loop120:
			while (true) {
				int alt120=2;
				int LA120_0 = input.LA(1);
				if ( (LA120_0==PIPE) ) {
					alt120=1;
				}

				switch (alt120) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:780:27: PIPE pathSequence
					{
					match(input,PIPE,FOLLOW_PIPE_in_path3568); 
					pushFollow(FOLLOW_pathSequence_in_path3570);
					pathSequence();
					state._fsp--;

					}
					break;

				default :
					break loop120;
				}
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "path"



	// $ANTLR start "pathSequence"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:783:1: pathSequence : pathEltOrInverse ( DIVIDE pathEltOrInverse )* ;
	public final void pathSequence() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:784:5: ( pathEltOrInverse ( DIVIDE pathEltOrInverse )* )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:784:7: pathEltOrInverse ( DIVIDE pathEltOrInverse )*
			{
			pushFollow(FOLLOW_pathEltOrInverse_in_pathSequence3590);
			pathEltOrInverse();
			state._fsp--;

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:784:24: ( DIVIDE pathEltOrInverse )*
			loop121:
			while (true) {
				int alt121=2;
				int LA121_0 = input.LA(1);
				if ( (LA121_0==DIVIDE) ) {
					alt121=1;
				}

				switch (alt121) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:784:26: DIVIDE pathEltOrInverse
					{
					match(input,DIVIDE,FOLLOW_DIVIDE_in_pathSequence3594); 
					pushFollow(FOLLOW_pathEltOrInverse_in_pathSequence3596);
					pathEltOrInverse();
					state._fsp--;

					}
					break;

				default :
					break loop121;
				}
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "pathSequence"



	// $ANTLR start "pathElt"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:787:1: pathElt : pathPrimary ( pathMod )? ;
	public final void pathElt() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:788:5: ( pathPrimary ( pathMod )? )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:788:7: pathPrimary ( pathMod )?
			{
			pushFollow(FOLLOW_pathPrimary_in_pathElt3616);
			pathPrimary();
			state._fsp--;

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:788:19: ( pathMod )?
			int alt122=2;
			int LA122_0 = input.LA(1);
			if ( (LA122_0==ASTERISK||LA122_0==OPEN_CURLY_BRACE||LA122_0==PLUS||LA122_0==QUESTION_MARK) ) {
				alt122=1;
			}
			switch (alt122) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:788:19: pathMod
					{
					pushFollow(FOLLOW_pathMod_in_pathElt3618);
					pathMod();
					state._fsp--;

					}
					break;

			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "pathElt"



	// $ANTLR start "pathEltOrInverse"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:791:1: pathEltOrInverse : ( pathElt | INVERSE pathElt );
	public final void pathEltOrInverse() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:792:5: ( pathElt | INVERSE pathElt )
			int alt123=2;
			int LA123_0 = input.LA(1);
			if ( (LA123_0==PATH_PRIMARY) ) {
				alt123=1;
			}
			else if ( (LA123_0==INVERSE) ) {
				alt123=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 123, 0, input);
				throw nvae;
			}

			switch (alt123) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:792:7: pathElt
					{
					pushFollow(FOLLOW_pathElt_in_pathEltOrInverse3636);
					pathElt();
					state._fsp--;

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:792:17: INVERSE pathElt
					{
					match(input,INVERSE,FOLLOW_INVERSE_in_pathEltOrInverse3640); 
					pushFollow(FOLLOW_pathElt_in_pathEltOrInverse3642);
					pathElt();
					state._fsp--;

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "pathEltOrInverse"



	// $ANTLR start "pathMod"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:795:1: pathMod : ( ASTERISK | QUESTION_MARK | PLUS | OPEN_CURLY_BRACE ( INTEGER ( COMMA ( CLOSE_CURLY_BRACE | INTEGER CLOSE_CURLY_BRACE ) | CLOSE_CURLY_BRACE ) | COMMA INTEGER CLOSE_CURLY_BRACE ) ) ;
	public final void pathMod() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:796:5: ( ( ASTERISK | QUESTION_MARK | PLUS | OPEN_CURLY_BRACE ( INTEGER ( COMMA ( CLOSE_CURLY_BRACE | INTEGER CLOSE_CURLY_BRACE ) | CLOSE_CURLY_BRACE ) | COMMA INTEGER CLOSE_CURLY_BRACE ) ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:796:7: ( ASTERISK | QUESTION_MARK | PLUS | OPEN_CURLY_BRACE ( INTEGER ( COMMA ( CLOSE_CURLY_BRACE | INTEGER CLOSE_CURLY_BRACE ) | CLOSE_CURLY_BRACE ) | COMMA INTEGER CLOSE_CURLY_BRACE ) )
			{
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:796:7: ( ASTERISK | QUESTION_MARK | PLUS | OPEN_CURLY_BRACE ( INTEGER ( COMMA ( CLOSE_CURLY_BRACE | INTEGER CLOSE_CURLY_BRACE ) | CLOSE_CURLY_BRACE ) | COMMA INTEGER CLOSE_CURLY_BRACE ) )
			int alt127=4;
			switch ( input.LA(1) ) {
			case ASTERISK:
				{
				alt127=1;
				}
				break;
			case QUESTION_MARK:
				{
				alt127=2;
				}
				break;
			case PLUS:
				{
				alt127=3;
				}
				break;
			case OPEN_CURLY_BRACE:
				{
				alt127=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 127, 0, input);
				throw nvae;
			}
			switch (alt127) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:796:9: ASTERISK
					{
					match(input,ASTERISK,FOLLOW_ASTERISK_in_pathMod3661); 
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:796:20: QUESTION_MARK
					{
					match(input,QUESTION_MARK,FOLLOW_QUESTION_MARK_in_pathMod3665); 
					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:796:36: PLUS
					{
					match(input,PLUS,FOLLOW_PLUS_in_pathMod3669); 
					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:796:43: OPEN_CURLY_BRACE ( INTEGER ( COMMA ( CLOSE_CURLY_BRACE | INTEGER CLOSE_CURLY_BRACE ) | CLOSE_CURLY_BRACE ) | COMMA INTEGER CLOSE_CURLY_BRACE )
					{
					match(input,OPEN_CURLY_BRACE,FOLLOW_OPEN_CURLY_BRACE_in_pathMod3673); 
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:796:60: ( INTEGER ( COMMA ( CLOSE_CURLY_BRACE | INTEGER CLOSE_CURLY_BRACE ) | CLOSE_CURLY_BRACE ) | COMMA INTEGER CLOSE_CURLY_BRACE )
					int alt126=2;
					int LA126_0 = input.LA(1);
					if ( (LA126_0==INTEGER) ) {
						alt126=1;
					}
					else if ( (LA126_0==COMMA) ) {
						alt126=2;
					}

					else {
						NoViableAltException nvae =
							new NoViableAltException("", 126, 0, input);
						throw nvae;
					}

					switch (alt126) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:796:62: INTEGER ( COMMA ( CLOSE_CURLY_BRACE | INTEGER CLOSE_CURLY_BRACE ) | CLOSE_CURLY_BRACE )
							{
							match(input,INTEGER,FOLLOW_INTEGER_in_pathMod3677); 
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:796:70: ( COMMA ( CLOSE_CURLY_BRACE | INTEGER CLOSE_CURLY_BRACE ) | CLOSE_CURLY_BRACE )
							int alt125=2;
							int LA125_0 = input.LA(1);
							if ( (LA125_0==COMMA) ) {
								alt125=1;
							}
							else if ( (LA125_0==CLOSE_CURLY_BRACE) ) {
								alt125=2;
							}

							else {
								NoViableAltException nvae =
									new NoViableAltException("", 125, 0, input);
								throw nvae;
							}

							switch (alt125) {
								case 1 :
									// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:796:72: COMMA ( CLOSE_CURLY_BRACE | INTEGER CLOSE_CURLY_BRACE )
									{
									match(input,COMMA,FOLLOW_COMMA_in_pathMod3681); 
									// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:796:78: ( CLOSE_CURLY_BRACE | INTEGER CLOSE_CURLY_BRACE )
									int alt124=2;
									int LA124_0 = input.LA(1);
									if ( (LA124_0==CLOSE_CURLY_BRACE) ) {
										alt124=1;
									}
									else if ( (LA124_0==INTEGER) ) {
										alt124=2;
									}

									else {
										NoViableAltException nvae =
											new NoViableAltException("", 124, 0, input);
										throw nvae;
									}

									switch (alt124) {
										case 1 :
											// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:796:80: CLOSE_CURLY_BRACE
											{
											match(input,CLOSE_CURLY_BRACE,FOLLOW_CLOSE_CURLY_BRACE_in_pathMod3685); 
											}
											break;
										case 2 :
											// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:796:100: INTEGER CLOSE_CURLY_BRACE
											{
											match(input,INTEGER,FOLLOW_INTEGER_in_pathMod3689); 
											match(input,CLOSE_CURLY_BRACE,FOLLOW_CLOSE_CURLY_BRACE_in_pathMod3691); 
											}
											break;

									}

									}
									break;
								case 2 :
									// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:796:130: CLOSE_CURLY_BRACE
									{
									match(input,CLOSE_CURLY_BRACE,FOLLOW_CLOSE_CURLY_BRACE_in_pathMod3697); 
									}
									break;

							}

							}
							break;
						case 2 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:796:152: COMMA INTEGER CLOSE_CURLY_BRACE
							{
							match(input,COMMA,FOLLOW_COMMA_in_pathMod3703); 
							match(input,INTEGER,FOLLOW_INTEGER_in_pathMod3705); 
							match(input,CLOSE_CURLY_BRACE,FOLLOW_CLOSE_CURLY_BRACE_in_pathMod3707); 
							}
							break;

					}

					}
					break;

			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "pathMod"



	// $ANTLR start "pathPrimary"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:799:1: pathPrimary : ( ^( PATH_PRIMARY iriRef ) | ^( PATH_PRIMARY A ) | ^( PATH_PRIMARY NEGATION pathNegatedPropertySet ) | ^( PATH_PRIMARY path ) );
	public final void pathPrimary() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:800:5: ( ^( PATH_PRIMARY iriRef ) | ^( PATH_PRIMARY A ) | ^( PATH_PRIMARY NEGATION pathNegatedPropertySet ) | ^( PATH_PRIMARY path ) )
			int alt128=4;
			int LA128_0 = input.LA(1);
			if ( (LA128_0==PATH_PRIMARY) ) {
				int LA128_1 = input.LA(2);
				if ( (LA128_1==DOWN) ) {
					switch ( input.LA(3) ) {
					case A:
						{
						alt128=2;
						}
						break;
					case NEGATION:
						{
						alt128=3;
						}
						break;
					case IRI_REF:
					case PNAME_LN:
					case PNAME_NS:
						{
						alt128=1;
						}
						break;
					case PATH:
						{
						alt128=4;
						}
						break;
					default:
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 128, 2, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 128, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 128, 0, input);
				throw nvae;
			}

			switch (alt128) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:800:7: ^( PATH_PRIMARY iriRef )
					{
					match(input,PATH_PRIMARY,FOLLOW_PATH_PRIMARY_in_pathPrimary3729); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_iriRef_in_pathPrimary3731);
					iriRef();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:801:7: ^( PATH_PRIMARY A )
					{
					match(input,PATH_PRIMARY,FOLLOW_PATH_PRIMARY_in_pathPrimary3741); 
					match(input, Token.DOWN, null); 
					match(input,A,FOLLOW_A_in_pathPrimary3743); 
					match(input, Token.UP, null); 

					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:802:7: ^( PATH_PRIMARY NEGATION pathNegatedPropertySet )
					{
					match(input,PATH_PRIMARY,FOLLOW_PATH_PRIMARY_in_pathPrimary3753); 
					match(input, Token.DOWN, null); 
					match(input,NEGATION,FOLLOW_NEGATION_in_pathPrimary3755); 
					pushFollow(FOLLOW_pathNegatedPropertySet_in_pathPrimary3757);
					pathNegatedPropertySet();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:803:7: ^( PATH_PRIMARY path )
					{
					match(input,PATH_PRIMARY,FOLLOW_PATH_PRIMARY_in_pathPrimary3767); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_path_in_pathPrimary3769);
					path();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "pathPrimary"



	// $ANTLR start "pathNegatedPropertySet"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:806:1: pathNegatedPropertySet : ^( PATH_NEGATED ( pathOneInPropertySet )+ ) ;
	public final void pathNegatedPropertySet() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:807:5: ( ^( PATH_NEGATED ( pathOneInPropertySet )+ ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:807:7: ^( PATH_NEGATED ( pathOneInPropertySet )+ )
			{
			match(input,PATH_NEGATED,FOLLOW_PATH_NEGATED_in_pathNegatedPropertySet3788); 
			match(input, Token.DOWN, null); 
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:807:22: ( pathOneInPropertySet )+
			int cnt129=0;
			loop129:
			while (true) {
				int alt129=2;
				int LA129_0 = input.LA(1);
				if ( (LA129_0==A||LA129_0==INVERSE||LA129_0==IRI_REF||(LA129_0 >= PNAME_LN && LA129_0 <= PNAME_NS)) ) {
					alt129=1;
				}

				switch (alt129) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:807:22: pathOneInPropertySet
					{
					pushFollow(FOLLOW_pathOneInPropertySet_in_pathNegatedPropertySet3790);
					pathOneInPropertySet();
					state._fsp--;

					}
					break;

				default :
					if ( cnt129 >= 1 ) break loop129;
					EarlyExitException eee = new EarlyExitException(129, input);
					throw eee;
				}
				cnt129++;
			}

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "pathNegatedPropertySet"



	// $ANTLR start "pathOneInPropertySet"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:810:1: pathOneInPropertySet : ( INVERSE )? ( iriRef | A ) ;
	public final void pathOneInPropertySet() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:811:5: ( ( INVERSE )? ( iriRef | A ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:811:7: ( INVERSE )? ( iriRef | A )
			{
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:811:7: ( INVERSE )?
			int alt130=2;
			int LA130_0 = input.LA(1);
			if ( (LA130_0==INVERSE) ) {
				alt130=1;
			}
			switch (alt130) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:811:7: INVERSE
					{
					match(input,INVERSE,FOLLOW_INVERSE_in_pathOneInPropertySet3809); 
					}
					break;

			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:811:16: ( iriRef | A )
			int alt131=2;
			int LA131_0 = input.LA(1);
			if ( (LA131_0==IRI_REF||(LA131_0 >= PNAME_LN && LA131_0 <= PNAME_NS)) ) {
				alt131=1;
			}
			else if ( (LA131_0==A) ) {
				alt131=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 131, 0, input);
				throw nvae;
			}

			switch (alt131) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:811:18: iriRef
					{
					pushFollow(FOLLOW_iriRef_in_pathOneInPropertySet3814);
					iriRef();
					state._fsp--;

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:811:27: A
					{
					match(input,A,FOLLOW_A_in_pathOneInPropertySet3818); 
					}
					break;

			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "pathOneInPropertySet"



	// $ANTLR start "triplesNode"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:814:1: triplesNode[BasicPattern triples] returns [Node value] : ( ^( COLLECTION ( graphNode[triples] )+ ) | ^( TRIPLE objectList[triples] ) );
	public final Node triplesNode(BasicPattern triples) throws RecognitionException {
		Node value = null;


		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:815:5: ( ^( COLLECTION ( graphNode[triples] )+ ) | ^( TRIPLE objectList[triples] ) )
			int alt133=2;
			int LA133_0 = input.LA(1);
			if ( (LA133_0==COLLECTION) ) {
				alt133=1;
			}
			else if ( (LA133_0==TRIPLE) ) {
				alt133=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 133, 0, input);
				throw nvae;
			}

			switch (alt133) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:815:7: ^( COLLECTION ( graphNode[triples] )+ )
					{
					match(input,COLLECTION,FOLLOW_COLLECTION_in_triplesNode3843); 
					match(input, Token.DOWN, null); 
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:815:20: ( graphNode[triples] )+
					int cnt132=0;
					loop132:
					while (true) {
						int alt132=2;
						int LA132_0 = input.LA(1);
						if ( (LA132_0==BLANK_NODE_LABEL||LA132_0==COLLECTION||(LA132_0 >= DECIMAL && LA132_0 <= DECIMAL_POSITIVE)||(LA132_0 >= DOUBLE && LA132_0 <= DOUBLE_POSITIVE)||LA132_0==FALSE||(LA132_0 >= INTEGER && LA132_0 <= INTEGER_POSITIVE)||LA132_0==IRI_REF||LA132_0==OPEN_BRACE||LA132_0==OPEN_SQUARE_BRACKET||LA132_0==PLAIN_LITERAL||(LA132_0 >= PNAME_LN && LA132_0 <= PNAME_NS)||LA132_0==TRIPLE||(LA132_0 >= TRUE && LA132_0 <= TYPED_LITERAL)||LA132_0==VAR) ) {
							alt132=1;
						}

						switch (alt132) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:815:20: graphNode[triples]
							{
							pushFollow(FOLLOW_graphNode_in_triplesNode3845);
							graphNode(triples);
							state._fsp--;

							}
							break;

						default :
							if ( cnt132 >= 1 ) break loop132;
							EarlyExitException eee = new EarlyExitException(132, input);
							throw eee;
						}
						cnt132++;
					}

					match(input, Token.UP, null); 

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:816:7: ^( TRIPLE objectList[triples] )
					{
					match(input,TRIPLE,FOLLOW_TRIPLE_in_triplesNode3857); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_objectList_in_triplesNode3859);
					objectList(triples);
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "triplesNode"



	// $ANTLR start "graphNode"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:819:1: graphNode[BasicPattern triples] returns [Node value] : (a= varOrTerm | triplesNode[triples] );
	public final Node graphNode(BasicPattern triples) throws RecognitionException {
		Node value = null;


		Node a =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:820:5: (a= varOrTerm | triplesNode[triples] )
			int alt134=2;
			int LA134_0 = input.LA(1);
			if ( (LA134_0==BLANK_NODE_LABEL||(LA134_0 >= DECIMAL && LA134_0 <= DECIMAL_POSITIVE)||(LA134_0 >= DOUBLE && LA134_0 <= DOUBLE_POSITIVE)||LA134_0==FALSE||(LA134_0 >= INTEGER && LA134_0 <= INTEGER_POSITIVE)||LA134_0==IRI_REF||LA134_0==OPEN_BRACE||LA134_0==OPEN_SQUARE_BRACKET||LA134_0==PLAIN_LITERAL||(LA134_0 >= PNAME_LN && LA134_0 <= PNAME_NS)||(LA134_0 >= TRUE && LA134_0 <= TYPED_LITERAL)||LA134_0==VAR) ) {
				alt134=1;
			}
			else if ( (LA134_0==COLLECTION||LA134_0==TRIPLE) ) {
				alt134=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 134, 0, input);
				throw nvae;
			}

			switch (alt134) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:820:7: a= varOrTerm
					{
					pushFollow(FOLLOW_varOrTerm_in_graphNode3887);
					a=varOrTerm();
					state._fsp--;

					value = a;
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:821:7: triplesNode[triples]
					{
					pushFollow(FOLLOW_triplesNode_in_graphNode3897);
					triplesNode(triples);
					state._fsp--;

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "graphNode"



	// $ANTLR start "varOrTerm"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:824:1: varOrTerm returns [Node value] : (a= var |a= graphTerm );
	public final Node varOrTerm() throws RecognitionException {
		Node value = null;


		Node a =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:825:5: (a= var |a= graphTerm )
			int alt135=2;
			int LA135_0 = input.LA(1);
			if ( (LA135_0==VAR) ) {
				alt135=1;
			}
			else if ( (LA135_0==BLANK_NODE_LABEL||(LA135_0 >= DECIMAL && LA135_0 <= DECIMAL_POSITIVE)||(LA135_0 >= DOUBLE && LA135_0 <= DOUBLE_POSITIVE)||LA135_0==FALSE||(LA135_0 >= INTEGER && LA135_0 <= INTEGER_POSITIVE)||LA135_0==IRI_REF||LA135_0==OPEN_BRACE||LA135_0==OPEN_SQUARE_BRACKET||LA135_0==PLAIN_LITERAL||(LA135_0 >= PNAME_LN && LA135_0 <= PNAME_NS)||(LA135_0 >= TRUE && LA135_0 <= TYPED_LITERAL)) ) {
				alt135=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 135, 0, input);
				throw nvae;
			}

			switch (alt135) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:825:7: a= var
					{
					pushFollow(FOLLOW_var_in_varOrTerm3921);
					a=var();
					state._fsp--;

					value = a;
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:826:7: a= graphTerm
					{
					pushFollow(FOLLOW_graphTerm_in_varOrTerm3939);
					a=graphTerm();
					state._fsp--;

					value = a;
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "varOrTerm"



	// $ANTLR start "varOrIRIref"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:829:1: varOrIRIref returns [Node value] : (a= var |a= iriRef );
	public final Node varOrIRIref() throws RecognitionException {
		Node value = null;


		Node a =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:830:5: (a= var |a= iriRef )
			int alt136=2;
			int LA136_0 = input.LA(1);
			if ( (LA136_0==VAR) ) {
				alt136=1;
			}
			else if ( (LA136_0==IRI_REF||(LA136_0 >= PNAME_LN && LA136_0 <= PNAME_NS)) ) {
				alt136=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 136, 0, input);
				throw nvae;
			}

			switch (alt136) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:830:7: a= var
					{
					pushFollow(FOLLOW_var_in_varOrIRIref3964);
					a=var();
					state._fsp--;

					value = a;
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:831:7: a= iriRef
					{
					pushFollow(FOLLOW_iriRef_in_varOrIRIref3979);
					a=iriRef();
					state._fsp--;

					value = a;
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "varOrIRIref"



	// $ANTLR start "var"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:834:1: var returns [Var value] : a= VAR ;
	public final Var var() throws RecognitionException {
		Var value = null;


		CommonTree a=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:835:5: (a= VAR )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:835:7: a= VAR
			{
			a=(CommonTree)match(input,VAR,FOLLOW_VAR_in_var4004); 
			value = Var.alloc((a!=null?a.getText():null));
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "var"



	// $ANTLR start "graphTerm"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:838:1: graphTerm returns [Node value] : (a= iriRef |a= rdfLiteral |b= numericLiteral |b= booleanLiteral |a= blankNode | nil );
	public final Node graphTerm() throws RecognitionException {
		Node value = null;


		Node a =null;
		NodeValue b =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:839:5: (a= iriRef |a= rdfLiteral |b= numericLiteral |b= booleanLiteral |a= blankNode | nil )
			int alt137=6;
			switch ( input.LA(1) ) {
			case IRI_REF:
			case PNAME_LN:
			case PNAME_NS:
				{
				alt137=1;
				}
				break;
			case PLAIN_LITERAL:
			case TYPED_LITERAL:
				{
				alt137=2;
				}
				break;
			case DECIMAL:
			case DECIMAL_NEGATIVE:
			case DECIMAL_POSITIVE:
			case DOUBLE:
			case DOUBLE_NEGATIVE:
			case DOUBLE_POSITIVE:
			case INTEGER:
			case INTEGER_NEGATIVE:
			case INTEGER_POSITIVE:
				{
				alt137=3;
				}
				break;
			case FALSE:
			case TRUE:
				{
				alt137=4;
				}
				break;
			case BLANK_NODE_LABEL:
			case OPEN_SQUARE_BRACKET:
				{
				alt137=5;
				}
				break;
			case OPEN_BRACE:
				{
				alt137=6;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 137, 0, input);
				throw nvae;
			}
			switch (alt137) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:839:7: a= iriRef
					{
					pushFollow(FOLLOW_iriRef_in_graphTerm4029);
					a=iriRef();
					state._fsp--;

					value = a;
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:840:7: a= rdfLiteral
					{
					pushFollow(FOLLOW_rdfLiteral_in_graphTerm4049);
					a=rdfLiteral();
					state._fsp--;

					value = a;
					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:841:7: b= numericLiteral
					{
					pushFollow(FOLLOW_numericLiteral_in_graphTerm4067);
					b=numericLiteral();
					state._fsp--;

					value = b.asNode();
					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:842:7: b= booleanLiteral
					{
					pushFollow(FOLLOW_booleanLiteral_in_graphTerm4079);
					b=booleanLiteral();
					state._fsp--;

					value = b.asNode();
					}
					break;
				case 5 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:843:7: a= blankNode
					{
					pushFollow(FOLLOW_blankNode_in_graphTerm4091);
					a=blankNode();
					state._fsp--;

					value = a;
					}
					break;
				case 6 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:844:7: nil
					{
					pushFollow(FOLLOW_nil_in_graphTerm4106);
					nil();
					state._fsp--;

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "graphTerm"



	// $ANTLR start "nil"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:847:1: nil : OPEN_BRACE CLOSE_BRACE ;
	public final void nil() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:848:5: ( OPEN_BRACE CLOSE_BRACE )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:848:7: OPEN_BRACE CLOSE_BRACE
			{
			match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_nil4123); 
			match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_nil4125); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "nil"



	// $ANTLR start "expression"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:851:1: expression returns [ Expr value ] : ( ^( OR a= expression b= expression ) | ^( AND a= expression b= expression ) | ^( EQUAL a= expression b= expression ) | ^( NOT_EQUAL a= expression b= expression ) | ^( LESS a= expression b= expression ) | ^( GREATER a= expression b= expression ) | ^( LESS_EQUAL a= expression b= expression ) | ^( GREATER_EQUAL a= expression b= expression ) | ^( IN a= expression b= expression ) | ^( NOT IN a= expression b= expression ) | ^( PLUS a= expression b= expression ) | ^( MINUS a= expression b= expression ) | ^( ASTERISK a= expression b= expression ) | ^( DIVIDE a= expression b= expression ) |a= unaryExpression );
	public final Expr expression() throws RecognitionException {
		Expr value = null;


		Expr a =null;
		Expr b =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:852:5: ( ^( OR a= expression b= expression ) | ^( AND a= expression b= expression ) | ^( EQUAL a= expression b= expression ) | ^( NOT_EQUAL a= expression b= expression ) | ^( LESS a= expression b= expression ) | ^( GREATER a= expression b= expression ) | ^( LESS_EQUAL a= expression b= expression ) | ^( GREATER_EQUAL a= expression b= expression ) | ^( IN a= expression b= expression ) | ^( NOT IN a= expression b= expression ) | ^( PLUS a= expression b= expression ) | ^( MINUS a= expression b= expression ) | ^( ASTERISK a= expression b= expression ) | ^( DIVIDE a= expression b= expression ) |a= unaryExpression )
			int alt138=15;
			switch ( input.LA(1) ) {
			case OR:
				{
				alt138=1;
				}
				break;
			case AND:
				{
				alt138=2;
				}
				break;
			case EQUAL:
				{
				alt138=3;
				}
				break;
			case NOT_EQUAL:
				{
				alt138=4;
				}
				break;
			case LESS:
				{
				alt138=5;
				}
				break;
			case GREATER:
				{
				alt138=6;
				}
				break;
			case LESS_EQUAL:
				{
				alt138=7;
				}
				break;
			case GREATER_EQUAL:
				{
				alt138=8;
				}
				break;
			case IN:
				{
				alt138=9;
				}
				break;
			case NOT:
				{
				alt138=10;
				}
				break;
			case PLUS:
				{
				alt138=11;
				}
				break;
			case MINUS:
				{
				alt138=12;
				}
				break;
			case ASTERISK:
				{
				alt138=13;
				}
				break;
			case DIVIDE:
				{
				alt138=14;
				}
				break;
			case UNARY:
			case UNARY_MINUS:
			case UNARY_NOT:
			case UNARY_PLUS:
				{
				alt138=15;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 138, 0, input);
				throw nvae;
			}
			switch (alt138) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:852:7: ^( OR a= expression b= expression )
					{
					match(input,OR,FOLLOW_OR_in_expression4147); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_expression4151);
					a=expression();
					state._fsp--;

					pushFollow(FOLLOW_expression_in_expression4155);
					b=expression();
					state._fsp--;

					match(input, Token.UP, null); 

					 value = new E_LogicalOr         (a, b); 
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:853:7: ^( AND a= expression b= expression )
					{
					match(input,AND,FOLLOW_AND_in_expression4178); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_expression4182);
					a=expression();
					state._fsp--;

					pushFollow(FOLLOW_expression_in_expression4186);
					b=expression();
					state._fsp--;

					match(input, Token.UP, null); 

					 value = new E_LogicalAnd        (a, b); 
					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:854:7: ^( EQUAL a= expression b= expression )
					{
					match(input,EQUAL,FOLLOW_EQUAL_in_expression4208); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_expression4212);
					a=expression();
					state._fsp--;

					pushFollow(FOLLOW_expression_in_expression4216);
					b=expression();
					state._fsp--;

					match(input, Token.UP, null); 

					 value = new E_Equals            (a, b); 
					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:855:7: ^( NOT_EQUAL a= expression b= expression )
					{
					match(input,NOT_EQUAL,FOLLOW_NOT_EQUAL_in_expression4236); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_expression4240);
					a=expression();
					state._fsp--;

					pushFollow(FOLLOW_expression_in_expression4244);
					b=expression();
					state._fsp--;

					match(input, Token.UP, null); 

					 value = new E_NotEquals         (a, b); 
					}
					break;
				case 5 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:856:7: ^( LESS a= expression b= expression )
					{
					match(input,LESS,FOLLOW_LESS_in_expression4260); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_expression4264);
					a=expression();
					state._fsp--;

					pushFollow(FOLLOW_expression_in_expression4268);
					b=expression();
					state._fsp--;

					match(input, Token.UP, null); 

					 value = new E_LessThan          (a, b); 
					}
					break;
				case 6 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:857:7: ^( GREATER a= expression b= expression )
					{
					match(input,GREATER,FOLLOW_GREATER_in_expression4289); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_expression4293);
					a=expression();
					state._fsp--;

					pushFollow(FOLLOW_expression_in_expression4297);
					b=expression();
					state._fsp--;

					match(input, Token.UP, null); 

					 value = new E_GreaterThan       (a, b); 
					}
					break;
				case 7 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:858:7: ^( LESS_EQUAL a= expression b= expression )
					{
					match(input,LESS_EQUAL,FOLLOW_LESS_EQUAL_in_expression4315); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_expression4319);
					a=expression();
					state._fsp--;

					pushFollow(FOLLOW_expression_in_expression4323);
					b=expression();
					state._fsp--;

					match(input, Token.UP, null); 

					 value = new E_LessThanOrEqual   (a, b); 
					}
					break;
				case 8 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:859:7: ^( GREATER_EQUAL a= expression b= expression )
					{
					match(input,GREATER_EQUAL,FOLLOW_GREATER_EQUAL_in_expression4338); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_expression4342);
					a=expression();
					state._fsp--;

					pushFollow(FOLLOW_expression_in_expression4346);
					b=expression();
					state._fsp--;

					match(input, Token.UP, null); 

					 value = new E_GreaterThanOrEqual(a, b); 
					}
					break;
				case 9 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:860:7: ^( IN a= expression b= expression )
					{
					match(input,IN,FOLLOW_IN_in_expression4358); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_expression4362);
					a=expression();
					state._fsp--;

					pushFollow(FOLLOW_expression_in_expression4366);
					b=expression();
					state._fsp--;

					match(input, Token.UP, null); 

					 if(true) { throw new NotImplementedException(); } 
					}
					break;
				case 10 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:861:7: ^( NOT IN a= expression b= expression )
					{
					match(input,NOT,FOLLOW_NOT_in_expression4389); 
					match(input, Token.DOWN, null); 
					match(input,IN,FOLLOW_IN_in_expression4391); 
					pushFollow(FOLLOW_expression_in_expression4395);
					a=expression();
					state._fsp--;

					pushFollow(FOLLOW_expression_in_expression4399);
					b=expression();
					state._fsp--;

					match(input, Token.UP, null); 

					 if(true) { throw new NotImplementedException(); } 
					}
					break;
				case 11 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:862:7: ^( PLUS a= expression b= expression )
					{
					match(input,PLUS,FOLLOW_PLUS_in_expression4418); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_expression4422);
					a=expression();
					state._fsp--;

					pushFollow(FOLLOW_expression_in_expression4426);
					b=expression();
					state._fsp--;

					match(input, Token.UP, null); 

					 value = new E_Add               (a, b); 
					}
					break;
				case 12 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:863:7: ^( MINUS a= expression b= expression )
					{
					match(input,MINUS,FOLLOW_MINUS_in_expression4447); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_expression4451);
					a=expression();
					state._fsp--;

					pushFollow(FOLLOW_expression_in_expression4455);
					b=expression();
					state._fsp--;

					match(input, Token.UP, null); 

					 value = new E_Subtract          (a, b); 
					}
					break;
				case 13 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:864:7: ^( ASTERISK a= expression b= expression )
					{
					match(input,ASTERISK,FOLLOW_ASTERISK_in_expression4475); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_expression4479);
					a=expression();
					state._fsp--;

					pushFollow(FOLLOW_expression_in_expression4483);
					b=expression();
					state._fsp--;

					match(input, Token.UP, null); 

					 value = new E_Multiply          (a, b); 
					}
					break;
				case 14 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:865:7: ^( DIVIDE a= expression b= expression )
					{
					match(input,DIVIDE,FOLLOW_DIVIDE_in_expression4500); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_expression4504);
					a=expression();
					state._fsp--;

					pushFollow(FOLLOW_expression_in_expression4508);
					b=expression();
					state._fsp--;

					match(input, Token.UP, null); 

					 value = new E_Divide            (a, b); 
					}
					break;
				case 15 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:866:7: a= unaryExpression
					{
					pushFollow(FOLLOW_unaryExpression_in_expression4528);
					a=unaryExpression();
					state._fsp--;

					 value = a; 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "expression"



	// $ANTLR start "unaryExpression"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:869:1: unaryExpression returns [ Expr value ] : ( ^( UNARY_NOT a= primaryExpression ) | ^( UNARY_PLUS a= primaryExpression ) | ^( UNARY_MINUS a= primaryExpression ) | ^( UNARY a= primaryExpression ) );
	public final Expr unaryExpression() throws RecognitionException {
		Expr value = null;


		Expr a =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:870:5: ( ^( UNARY_NOT a= primaryExpression ) | ^( UNARY_PLUS a= primaryExpression ) | ^( UNARY_MINUS a= primaryExpression ) | ^( UNARY a= primaryExpression ) )
			int alt139=4;
			switch ( input.LA(1) ) {
			case UNARY_NOT:
				{
				alt139=1;
				}
				break;
			case UNARY_PLUS:
				{
				alt139=2;
				}
				break;
			case UNARY_MINUS:
				{
				alt139=3;
				}
				break;
			case UNARY:
				{
				alt139=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 139, 0, input);
				throw nvae;
			}
			switch (alt139) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:870:7: ^( UNARY_NOT a= primaryExpression )
					{
					match(input,UNARY_NOT,FOLLOW_UNARY_NOT_in_unaryExpression4577); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_primaryExpression_in_unaryExpression4581);
					a=primaryExpression();
					state._fsp--;

					match(input, Token.UP, null); 

					 value = new E_LogicalNot(a); 
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:871:7: ^( UNARY_PLUS a= primaryExpression )
					{
					match(input,UNARY_PLUS,FOLLOW_UNARY_PLUS_in_unaryExpression4601); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_primaryExpression_in_unaryExpression4605);
					a=primaryExpression();
					state._fsp--;

					match(input, Token.UP, null); 

					 value = new E_UnaryPlus (a); 
					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:872:7: ^( UNARY_MINUS a= primaryExpression )
					{
					match(input,UNARY_MINUS,FOLLOW_UNARY_MINUS_in_unaryExpression4624); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_primaryExpression_in_unaryExpression4628);
					a=primaryExpression();
					state._fsp--;

					match(input, Token.UP, null); 

					 value = new E_UnaryMinus(a); 
					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:873:7: ^( UNARY a= primaryExpression )
					{
					match(input,UNARY,FOLLOW_UNARY_in_unaryExpression4646); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_primaryExpression_in_unaryExpression4650);
					a=primaryExpression();
					state._fsp--;

					match(input, Token.UP, null); 

					 value = a; 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "unaryExpression"



	// $ANTLR start "primaryExpression"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:876:1: primaryExpression returns [Expr value] : (e= builtInCall |e= iriRefOrFunction |e= expression |n= rdfLiteral |nv= numericLiteral |nv= booleanLiteral |v= var | aggregate );
	public final Expr primaryExpression() throws RecognitionException {
		Expr value = null;


		Expr e =null;
		Node n =null;
		NodeValue nv =null;
		Var v =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:877:5: (e= builtInCall |e= iriRefOrFunction |e= expression |n= rdfLiteral |nv= numericLiteral |nv= booleanLiteral |v= var | aggregate )
			int alt140=8;
			switch ( input.LA(1) ) {
			case ABS:
			case BNODE:
			case BOUND:
			case CEIL:
			case COALESCE:
			case CONCAT:
			case CONTAINS:
			case DATATYPE:
			case DAY:
			case ENCODE_FOR_URI:
			case EXISTS:
			case FLOOR:
			case HOURS:
			case IF:
			case IRI:
			case ISBLANK:
			case ISIRI:
			case ISLITERAL:
			case ISNUMERIC:
			case ISURI:
			case LANG:
			case LANGMATCHES:
			case LCASE:
			case MD5:
			case MINUTES:
			case MONTH:
			case NOT_EXISTS:
			case NOW:
			case RAND:
			case REGEX:
			case ROUND:
			case SAMETERM:
			case SECONDS:
			case SHA1:
			case SHA224:
			case SHA256:
			case SHA384:
			case SHA512:
			case STR:
			case STRDT:
			case STRENDS:
			case STRLANG:
			case STRLEN:
			case STRSTARTS:
			case SUBSTR:
			case TIMEZONE:
			case TZ:
			case UCASE:
			case URI:
			case YEAR:
				{
				alt140=1;
				}
				break;
			case FUNCTION:
			case IRI_REF:
			case PNAME_LN:
			case PNAME_NS:
				{
				alt140=2;
				}
				break;
			case AND:
			case ASTERISK:
			case DIVIDE:
			case EQUAL:
			case GREATER:
			case GREATER_EQUAL:
			case IN:
			case LESS:
			case LESS_EQUAL:
			case MINUS:
			case NOT:
			case NOT_EQUAL:
			case OR:
			case PLUS:
			case UNARY:
			case UNARY_MINUS:
			case UNARY_NOT:
			case UNARY_PLUS:
				{
				alt140=3;
				}
				break;
			case PLAIN_LITERAL:
			case TYPED_LITERAL:
				{
				alt140=4;
				}
				break;
			case DECIMAL:
			case DECIMAL_NEGATIVE:
			case DECIMAL_POSITIVE:
			case DOUBLE:
			case DOUBLE_NEGATIVE:
			case DOUBLE_POSITIVE:
			case INTEGER:
			case INTEGER_NEGATIVE:
			case INTEGER_POSITIVE:
				{
				alt140=5;
				}
				break;
			case FALSE:
			case TRUE:
				{
				alt140=6;
				}
				break;
			case VAR:
				{
				alt140=7;
				}
				break;
			case AVG:
			case COUNT:
			case GROUP_CONCAT:
			case MAX:
			case MIN:
			case SAMPLE:
			case SUM:
				{
				alt140=8;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 140, 0, input);
				throw nvae;
			}
			switch (alt140) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:877:7: e= builtInCall
					{
					pushFollow(FOLLOW_builtInCall_in_primaryExpression4688);
					e=builtInCall();
					state._fsp--;

					value = e;
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:878:7: e= iriRefOrFunction
					{
					pushFollow(FOLLOW_iriRefOrFunction_in_primaryExpression4706);
					e=iriRefOrFunction();
					state._fsp--;

					value = e;
					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:879:7: e= expression
					{
					pushFollow(FOLLOW_expression_in_primaryExpression4719);
					e=expression();
					state._fsp--;

					value = e;
					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:880:7: n= rdfLiteral
					{
					pushFollow(FOLLOW_rdfLiteral_in_primaryExpression4739);
					n=rdfLiteral();
					state._fsp--;

					value = NodeValue.makeNode(n);
					}
					break;
				case 5 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:881:7: nv= numericLiteral
					{
					pushFollow(FOLLOW_numericLiteral_in_primaryExpression4758);
					nv=numericLiteral();
					state._fsp--;

					value = nv;
					}
					break;
				case 6 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:882:7: nv= booleanLiteral
					{
					pushFollow(FOLLOW_booleanLiteral_in_primaryExpression4773);
					nv=booleanLiteral();
					state._fsp--;

					value = nv;
					}
					break;
				case 7 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:883:7: v= var
					{
					pushFollow(FOLLOW_var_in_primaryExpression4788);
					v=var();
					state._fsp--;

					value = new ExprVar(v);
					}
					break;
				case 8 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:884:7: aggregate
					{
					pushFollow(FOLLOW_aggregate_in_primaryExpression4812);
					aggregate();
					state._fsp--;

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "primaryExpression"



	// $ANTLR start "builtInCall"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:887:1: builtInCall returns [Expr value] : ( ^( STR a= expression ) | ^( LANG a= expression ) | ^( LANGMATCHES a= expression b= expression ) | ^( DATATYPE a= expression ) | ^( BOUND n= var ) | ^( IRI a= expression ) | ^( URI a= expression ) | ^( BNODE expression ) | RAND | ^( ABS a= expression ) | ^( CEIL a= expression ) | ^( FLOOR a= expression ) | ^( ROUND expression ) | ^( CONCAT l= expressionList ) | subStringExpression | ^( STRLEN expression ) | ^( UCASE expression ) | ^( LCASE expression ) | ^( ENCODE_FOR_URI expression ) | ^( CONTAINS expression ) | ^( STRSTARTS expression ) | ^( STRENDS expression ) | ^( YEAR expression ) | ^( MONTH expression ) | ^( DAY expression ) | ^( HOURS expression ) | ^( MINUTES expression ) | ^( SECONDS expression ) | ^( TIMEZONE expression ) | ^( TZ expression ) | NOW | ^( MD5 expression ) | ^( SHA1 expression ) | ^( SHA224 expression ) | ^( SHA256 expression ) | ^( SHA384 expression ) | ^( SHA512 expression ) | ^( COALESCE expressionList ) | ^( IF expression expression expression ) | ^( STRLANG expression expression ) | ^( STRDT expression expression ) | ^( SAMETERM expression expression ) | ^( ISIRI expression ) | ^( ISURI expression ) | ^( ISBLANK expression ) | ^( ISLITERAL expression ) | ^( ISNUMERIC expression ) | regexExpression | existsFunction | notExistsFunction );
	public final Expr builtInCall() throws RecognitionException {
		Expr value = null;


		Expr a =null;
		Expr b =null;
		Var n =null;
		ExprList l =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:888:5: ( ^( STR a= expression ) | ^( LANG a= expression ) | ^( LANGMATCHES a= expression b= expression ) | ^( DATATYPE a= expression ) | ^( BOUND n= var ) | ^( IRI a= expression ) | ^( URI a= expression ) | ^( BNODE expression ) | RAND | ^( ABS a= expression ) | ^( CEIL a= expression ) | ^( FLOOR a= expression ) | ^( ROUND expression ) | ^( CONCAT l= expressionList ) | subStringExpression | ^( STRLEN expression ) | ^( UCASE expression ) | ^( LCASE expression ) | ^( ENCODE_FOR_URI expression ) | ^( CONTAINS expression ) | ^( STRSTARTS expression ) | ^( STRENDS expression ) | ^( YEAR expression ) | ^( MONTH expression ) | ^( DAY expression ) | ^( HOURS expression ) | ^( MINUTES expression ) | ^( SECONDS expression ) | ^( TIMEZONE expression ) | ^( TZ expression ) | NOW | ^( MD5 expression ) | ^( SHA1 expression ) | ^( SHA224 expression ) | ^( SHA256 expression ) | ^( SHA384 expression ) | ^( SHA512 expression ) | ^( COALESCE expressionList ) | ^( IF expression expression expression ) | ^( STRLANG expression expression ) | ^( STRDT expression expression ) | ^( SAMETERM expression expression ) | ^( ISIRI expression ) | ^( ISURI expression ) | ^( ISBLANK expression ) | ^( ISLITERAL expression ) | ^( ISNUMERIC expression ) | regexExpression | existsFunction | notExistsFunction )
			int alt141=50;
			switch ( input.LA(1) ) {
			case STR:
				{
				alt141=1;
				}
				break;
			case LANG:
				{
				alt141=2;
				}
				break;
			case LANGMATCHES:
				{
				alt141=3;
				}
				break;
			case DATATYPE:
				{
				alt141=4;
				}
				break;
			case BOUND:
				{
				alt141=5;
				}
				break;
			case IRI:
				{
				alt141=6;
				}
				break;
			case URI:
				{
				alt141=7;
				}
				break;
			case BNODE:
				{
				alt141=8;
				}
				break;
			case RAND:
				{
				alt141=9;
				}
				break;
			case ABS:
				{
				alt141=10;
				}
				break;
			case CEIL:
				{
				alt141=11;
				}
				break;
			case FLOOR:
				{
				alt141=12;
				}
				break;
			case ROUND:
				{
				alt141=13;
				}
				break;
			case CONCAT:
				{
				alt141=14;
				}
				break;
			case SUBSTR:
				{
				alt141=15;
				}
				break;
			case STRLEN:
				{
				alt141=16;
				}
				break;
			case UCASE:
				{
				alt141=17;
				}
				break;
			case LCASE:
				{
				alt141=18;
				}
				break;
			case ENCODE_FOR_URI:
				{
				alt141=19;
				}
				break;
			case CONTAINS:
				{
				alt141=20;
				}
				break;
			case STRSTARTS:
				{
				alt141=21;
				}
				break;
			case STRENDS:
				{
				alt141=22;
				}
				break;
			case YEAR:
				{
				alt141=23;
				}
				break;
			case MONTH:
				{
				alt141=24;
				}
				break;
			case DAY:
				{
				alt141=25;
				}
				break;
			case HOURS:
				{
				alt141=26;
				}
				break;
			case MINUTES:
				{
				alt141=27;
				}
				break;
			case SECONDS:
				{
				alt141=28;
				}
				break;
			case TIMEZONE:
				{
				alt141=29;
				}
				break;
			case TZ:
				{
				alt141=30;
				}
				break;
			case NOW:
				{
				alt141=31;
				}
				break;
			case MD5:
				{
				alt141=32;
				}
				break;
			case SHA1:
				{
				alt141=33;
				}
				break;
			case SHA224:
				{
				alt141=34;
				}
				break;
			case SHA256:
				{
				alt141=35;
				}
				break;
			case SHA384:
				{
				alt141=36;
				}
				break;
			case SHA512:
				{
				alt141=37;
				}
				break;
			case COALESCE:
				{
				alt141=38;
				}
				break;
			case IF:
				{
				alt141=39;
				}
				break;
			case STRLANG:
				{
				alt141=40;
				}
				break;
			case STRDT:
				{
				alt141=41;
				}
				break;
			case SAMETERM:
				{
				alt141=42;
				}
				break;
			case ISIRI:
				{
				alt141=43;
				}
				break;
			case ISURI:
				{
				alt141=44;
				}
				break;
			case ISBLANK:
				{
				alt141=45;
				}
				break;
			case ISLITERAL:
				{
				alt141=46;
				}
				break;
			case ISNUMERIC:
				{
				alt141=47;
				}
				break;
			case REGEX:
				{
				alt141=48;
				}
				break;
			case EXISTS:
				{
				alt141=49;
				}
				break;
			case NOT_EXISTS:
				{
				alt141=50;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 141, 0, input);
				throw nvae;
			}
			switch (alt141) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:888:7: ^( STR a= expression )
					{
					match(input,STR,FOLLOW_STR_in_builtInCall4834); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall4838);
					a=expression();
					state._fsp--;

					match(input, Token.UP, null); 

					value = new E_Str(a);
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:889:7: ^( LANG a= expression )
					{
					match(input,LANG,FOLLOW_LANG_in_builtInCall4862); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall4866);
					a=expression();
					state._fsp--;

					match(input, Token.UP, null); 

					value = new E_Lang(a);
					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:890:7: ^( LANGMATCHES a= expression b= expression )
					{
					match(input,LANGMATCHES,FOLLOW_LANGMATCHES_in_builtInCall4889); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall4893);
					a=expression();
					state._fsp--;

					pushFollow(FOLLOW_expression_in_builtInCall4897);
					b=expression();
					state._fsp--;

					match(input, Token.UP, null); 

					value = new E_LangMatches(a, b);
					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:891:7: ^( DATATYPE a= expression )
					{
					match(input,DATATYPE,FOLLOW_DATATYPE_in_builtInCall4912); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall4916);
					a=expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 5 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:892:7: ^( BOUND n= var )
					{
					match(input,BOUND,FOLLOW_BOUND_in_builtInCall4926); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_var_in_builtInCall4930);
					n=var();
					state._fsp--;

					match(input, Token.UP, null); 

					value = new E_Bound(new ExprVar(n));
					}
					break;
				case 6 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:893:7: ^( IRI a= expression )
					{
					match(input,IRI,FOLLOW_IRI_in_builtInCall4959); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall4963);
					a=expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 7 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:894:7: ^( URI a= expression )
					{
					match(input,URI,FOLLOW_URI_in_builtInCall4973); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall4977);
					a=expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 8 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:895:7: ^( BNODE expression )
					{
					match(input,BNODE,FOLLOW_BNODE_in_builtInCall4987); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall4989);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 9 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:896:7: RAND
					{
					match(input,RAND,FOLLOW_RAND_in_builtInCall4998); 
					}
					break;
				case 10 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:897:7: ^( ABS a= expression )
					{
					match(input,ABS,FOLLOW_ABS_in_builtInCall5007); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5011);
					a=expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 11 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:898:7: ^( CEIL a= expression )
					{
					match(input,CEIL,FOLLOW_CEIL_in_builtInCall5021); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5025);
					a=expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 12 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:899:7: ^( FLOOR a= expression )
					{
					match(input,FLOOR,FOLLOW_FLOOR_in_builtInCall5035); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5039);
					a=expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 13 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:900:7: ^( ROUND expression )
					{
					match(input,ROUND,FOLLOW_ROUND_in_builtInCall5049); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5051);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 14 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:901:7: ^( CONCAT l= expressionList )
					{
					match(input,CONCAT,FOLLOW_CONCAT_in_builtInCall5061); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expressionList_in_builtInCall5065);
					l=expressionList();
					state._fsp--;

					match(input, Token.UP, null); 

					value = new E_StrConcatPermissive(l);
					}
					break;
				case 15 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:902:7: subStringExpression
					{
					pushFollow(FOLLOW_subStringExpression_in_builtInCall5081);
					subStringExpression();
					state._fsp--;

					}
					break;
				case 16 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:903:7: ^( STRLEN expression )
					{
					match(input,STRLEN,FOLLOW_STRLEN_in_builtInCall5090); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5092);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 17 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:904:7: ^( UCASE expression )
					{
					match(input,UCASE,FOLLOW_UCASE_in_builtInCall5102); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5104);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 18 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:905:7: ^( LCASE expression )
					{
					match(input,LCASE,FOLLOW_LCASE_in_builtInCall5114); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5116);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 19 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:906:7: ^( ENCODE_FOR_URI expression )
					{
					match(input,ENCODE_FOR_URI,FOLLOW_ENCODE_FOR_URI_in_builtInCall5126); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5128);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 20 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:907:7: ^( CONTAINS expression )
					{
					match(input,CONTAINS,FOLLOW_CONTAINS_in_builtInCall5138); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5140);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 21 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:908:7: ^( STRSTARTS expression )
					{
					match(input,STRSTARTS,FOLLOW_STRSTARTS_in_builtInCall5150); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5152);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 22 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:909:7: ^( STRENDS expression )
					{
					match(input,STRENDS,FOLLOW_STRENDS_in_builtInCall5162); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5164);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 23 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:910:7: ^( YEAR expression )
					{
					match(input,YEAR,FOLLOW_YEAR_in_builtInCall5174); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5176);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 24 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:911:7: ^( MONTH expression )
					{
					match(input,MONTH,FOLLOW_MONTH_in_builtInCall5186); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5188);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 25 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:912:7: ^( DAY expression )
					{
					match(input,DAY,FOLLOW_DAY_in_builtInCall5198); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5200);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 26 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:913:7: ^( HOURS expression )
					{
					match(input,HOURS,FOLLOW_HOURS_in_builtInCall5210); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5212);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 27 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:914:7: ^( MINUTES expression )
					{
					match(input,MINUTES,FOLLOW_MINUTES_in_builtInCall5222); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5224);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 28 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:915:7: ^( SECONDS expression )
					{
					match(input,SECONDS,FOLLOW_SECONDS_in_builtInCall5234); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5236);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 29 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:916:7: ^( TIMEZONE expression )
					{
					match(input,TIMEZONE,FOLLOW_TIMEZONE_in_builtInCall5246); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5248);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 30 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:917:7: ^( TZ expression )
					{
					match(input,TZ,FOLLOW_TZ_in_builtInCall5258); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5260);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 31 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:918:7: NOW
					{
					match(input,NOW,FOLLOW_NOW_in_builtInCall5269); 
					}
					break;
				case 32 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:919:7: ^( MD5 expression )
					{
					match(input,MD5,FOLLOW_MD5_in_builtInCall5278); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5280);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 33 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:920:7: ^( SHA1 expression )
					{
					match(input,SHA1,FOLLOW_SHA1_in_builtInCall5290); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5292);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 34 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:921:7: ^( SHA224 expression )
					{
					match(input,SHA224,FOLLOW_SHA224_in_builtInCall5302); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5304);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 35 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:922:7: ^( SHA256 expression )
					{
					match(input,SHA256,FOLLOW_SHA256_in_builtInCall5314); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5316);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 36 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:923:7: ^( SHA384 expression )
					{
					match(input,SHA384,FOLLOW_SHA384_in_builtInCall5326); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5328);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 37 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:924:7: ^( SHA512 expression )
					{
					match(input,SHA512,FOLLOW_SHA512_in_builtInCall5338); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5340);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 38 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:925:7: ^( COALESCE expressionList )
					{
					match(input,COALESCE,FOLLOW_COALESCE_in_builtInCall5350); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expressionList_in_builtInCall5352);
					expressionList();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 39 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:926:7: ^( IF expression expression expression )
					{
					match(input,IF,FOLLOW_IF_in_builtInCall5362); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5364);
					expression();
					state._fsp--;

					pushFollow(FOLLOW_expression_in_builtInCall5366);
					expression();
					state._fsp--;

					pushFollow(FOLLOW_expression_in_builtInCall5368);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 40 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:927:7: ^( STRLANG expression expression )
					{
					match(input,STRLANG,FOLLOW_STRLANG_in_builtInCall5378); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5380);
					expression();
					state._fsp--;

					pushFollow(FOLLOW_expression_in_builtInCall5382);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 41 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:928:7: ^( STRDT expression expression )
					{
					match(input,STRDT,FOLLOW_STRDT_in_builtInCall5392); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5394);
					expression();
					state._fsp--;

					pushFollow(FOLLOW_expression_in_builtInCall5396);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 42 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:929:7: ^( SAMETERM expression expression )
					{
					match(input,SAMETERM,FOLLOW_SAMETERM_in_builtInCall5406); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5408);
					expression();
					state._fsp--;

					pushFollow(FOLLOW_expression_in_builtInCall5410);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 43 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:930:7: ^( ISIRI expression )
					{
					match(input,ISIRI,FOLLOW_ISIRI_in_builtInCall5420); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5422);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 44 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:931:7: ^( ISURI expression )
					{
					match(input,ISURI,FOLLOW_ISURI_in_builtInCall5432); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5434);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 45 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:932:7: ^( ISBLANK expression )
					{
					match(input,ISBLANK,FOLLOW_ISBLANK_in_builtInCall5444); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5446);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 46 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:933:7: ^( ISLITERAL expression )
					{
					match(input,ISLITERAL,FOLLOW_ISLITERAL_in_builtInCall5456); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5458);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 47 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:934:7: ^( ISNUMERIC expression )
					{
					match(input,ISNUMERIC,FOLLOW_ISNUMERIC_in_builtInCall5468); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_expression_in_builtInCall5470);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 48 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:935:7: regexExpression
					{
					pushFollow(FOLLOW_regexExpression_in_builtInCall5479);
					regexExpression();
					state._fsp--;

					}
					break;
				case 49 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:936:7: existsFunction
					{
					pushFollow(FOLLOW_existsFunction_in_builtInCall5487);
					existsFunction();
					state._fsp--;

					}
					break;
				case 50 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:937:7: notExistsFunction
					{
					pushFollow(FOLLOW_notExistsFunction_in_builtInCall5495);
					notExistsFunction();
					state._fsp--;

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "builtInCall"



	// $ANTLR start "regexExpression"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:940:1: regexExpression : ^( REGEX ( expression )+ ) ;
	public final void regexExpression() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:941:5: ( ^( REGEX ( expression )+ ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:941:7: ^( REGEX ( expression )+ )
			{
			match(input,REGEX,FOLLOW_REGEX_in_regexExpression5513); 
			match(input, Token.DOWN, null); 
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:941:15: ( expression )+
			int cnt142=0;
			loop142:
			while (true) {
				int alt142=2;
				int LA142_0 = input.LA(1);
				if ( (LA142_0==AND||LA142_0==ASTERISK||LA142_0==DIVIDE||LA142_0==EQUAL||(LA142_0 >= GREATER && LA142_0 <= GREATER_EQUAL)||LA142_0==IN||(LA142_0 >= LESS && LA142_0 <= LESS_EQUAL)||LA142_0==MINUS||(LA142_0 >= NOT && LA142_0 <= NOT_EQUAL)||LA142_0==OR||LA142_0==PLUS||(LA142_0 >= UNARY && LA142_0 <= UNARY_PLUS)) ) {
					alt142=1;
				}

				switch (alt142) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:941:15: expression
					{
					pushFollow(FOLLOW_expression_in_regexExpression5515);
					expression();
					state._fsp--;

					}
					break;

				default :
					if ( cnt142 >= 1 ) break loop142;
					EarlyExitException eee = new EarlyExitException(142, input);
					throw eee;
				}
				cnt142++;
			}

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "regexExpression"



	// $ANTLR start "subStringExpression"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:944:1: subStringExpression : ^( SUBSTR ( expression )+ ) ;
	public final void subStringExpression() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:945:5: ( ^( SUBSTR ( expression )+ ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:945:7: ^( SUBSTR ( expression )+ )
			{
			match(input,SUBSTR,FOLLOW_SUBSTR_in_subStringExpression5535); 
			match(input, Token.DOWN, null); 
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:945:16: ( expression )+
			int cnt143=0;
			loop143:
			while (true) {
				int alt143=2;
				int LA143_0 = input.LA(1);
				if ( (LA143_0==AND||LA143_0==ASTERISK||LA143_0==DIVIDE||LA143_0==EQUAL||(LA143_0 >= GREATER && LA143_0 <= GREATER_EQUAL)||LA143_0==IN||(LA143_0 >= LESS && LA143_0 <= LESS_EQUAL)||LA143_0==MINUS||(LA143_0 >= NOT && LA143_0 <= NOT_EQUAL)||LA143_0==OR||LA143_0==PLUS||(LA143_0 >= UNARY && LA143_0 <= UNARY_PLUS)) ) {
					alt143=1;
				}

				switch (alt143) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:945:16: expression
					{
					pushFollow(FOLLOW_expression_in_subStringExpression5537);
					expression();
					state._fsp--;

					}
					break;

				default :
					if ( cnt143 >= 1 ) break loop143;
					EarlyExitException eee = new EarlyExitException(143, input);
					throw eee;
				}
				cnt143++;
			}

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "subStringExpression"



	// $ANTLR start "existsFunction"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:948:1: existsFunction : ^( EXISTS groupGraphPattern ) ;
	public final void existsFunction() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:949:5: ( ^( EXISTS groupGraphPattern ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:949:7: ^( EXISTS groupGraphPattern )
			{
			match(input,EXISTS,FOLLOW_EXISTS_in_existsFunction5557); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_groupGraphPattern_in_existsFunction5559);
			groupGraphPattern();
			state._fsp--;

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "existsFunction"



	// $ANTLR start "notExistsFunction"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:952:1: notExistsFunction : ^( NOT_EXISTS groupGraphPattern ) ;
	public final void notExistsFunction() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:953:5: ( ^( NOT_EXISTS groupGraphPattern ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:953:7: ^( NOT_EXISTS groupGraphPattern )
			{
			match(input,NOT_EXISTS,FOLLOW_NOT_EXISTS_in_notExistsFunction5578); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_groupGraphPattern_in_notExistsFunction5580);
			groupGraphPattern();
			state._fsp--;

			match(input, Token.UP, null); 

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "notExistsFunction"



	// $ANTLR start "aggregate"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:956:1: aggregate : ( ^( COUNT ( DISTINCT )* ( ASTERISK )* ( expression )* ) | ^( SUM ( DISTINCT )* expression ) | ^( MIN ( DISTINCT )* expression ) | ^( MAX ( DISTINCT )* expression ) | ^( AVG ( DISTINCT )* expression ) | ^( SAMPLE ( DISTINCT )? expression ) | ^( GROUP_CONCAT ( DISTINCT )* expression ( string )? ) );
	public final void aggregate() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:957:5: ( ^( COUNT ( DISTINCT )* ( ASTERISK )* ( expression )* ) | ^( SUM ( DISTINCT )* expression ) | ^( MIN ( DISTINCT )* expression ) | ^( MAX ( DISTINCT )* expression ) | ^( AVG ( DISTINCT )* expression ) | ^( SAMPLE ( DISTINCT )? expression ) | ^( GROUP_CONCAT ( DISTINCT )* expression ( string )? ) )
			int alt154=7;
			switch ( input.LA(1) ) {
			case COUNT:
				{
				alt154=1;
				}
				break;
			case SUM:
				{
				alt154=2;
				}
				break;
			case MIN:
				{
				alt154=3;
				}
				break;
			case MAX:
				{
				alt154=4;
				}
				break;
			case AVG:
				{
				alt154=5;
				}
				break;
			case SAMPLE:
				{
				alt154=6;
				}
				break;
			case GROUP_CONCAT:
				{
				alt154=7;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 154, 0, input);
				throw nvae;
			}
			switch (alt154) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:957:7: ^( COUNT ( DISTINCT )* ( ASTERISK )* ( expression )* )
					{
					match(input,COUNT,FOLLOW_COUNT_in_aggregate5599); 
					if ( input.LA(1)==Token.DOWN ) {
						match(input, Token.DOWN, null); 
						// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:957:15: ( DISTINCT )*
						loop144:
						while (true) {
							int alt144=2;
							int LA144_0 = input.LA(1);
							if ( (LA144_0==DISTINCT) ) {
								alt144=1;
							}

							switch (alt144) {
							case 1 :
								// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:957:15: DISTINCT
								{
								match(input,DISTINCT,FOLLOW_DISTINCT_in_aggregate5601); 
								}
								break;

							default :
								break loop144;
							}
						}

						// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:957:25: ( ASTERISK )*
						loop145:
						while (true) {
							int alt145=2;
							int LA145_0 = input.LA(1);
							if ( (LA145_0==ASTERISK) ) {
								int LA145_2 = input.LA(2);
								if ( (LA145_2==UP||LA145_2==AND||LA145_2==ASTERISK||LA145_2==DIVIDE||LA145_2==EQUAL||(LA145_2 >= GREATER && LA145_2 <= GREATER_EQUAL)||LA145_2==IN||(LA145_2 >= LESS && LA145_2 <= LESS_EQUAL)||LA145_2==MINUS||(LA145_2 >= NOT && LA145_2 <= NOT_EQUAL)||LA145_2==OR||LA145_2==PLUS||(LA145_2 >= UNARY && LA145_2 <= UNARY_PLUS)) ) {
									alt145=1;
								}

							}

							switch (alt145) {
							case 1 :
								// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:957:25: ASTERISK
								{
								match(input,ASTERISK,FOLLOW_ASTERISK_in_aggregate5604); 
								}
								break;

							default :
								break loop145;
							}
						}

						// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:957:35: ( expression )*
						loop146:
						while (true) {
							int alt146=2;
							int LA146_0 = input.LA(1);
							if ( (LA146_0==AND||LA146_0==ASTERISK||LA146_0==DIVIDE||LA146_0==EQUAL||(LA146_0 >= GREATER && LA146_0 <= GREATER_EQUAL)||LA146_0==IN||(LA146_0 >= LESS && LA146_0 <= LESS_EQUAL)||LA146_0==MINUS||(LA146_0 >= NOT && LA146_0 <= NOT_EQUAL)||LA146_0==OR||LA146_0==PLUS||(LA146_0 >= UNARY && LA146_0 <= UNARY_PLUS)) ) {
								alt146=1;
							}

							switch (alt146) {
							case 1 :
								// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:957:35: expression
								{
								pushFollow(FOLLOW_expression_in_aggregate5607);
								expression();
								state._fsp--;

								}
								break;

							default :
								break loop146;
							}
						}

						match(input, Token.UP, null); 
					}

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:958:7: ^( SUM ( DISTINCT )* expression )
					{
					match(input,SUM,FOLLOW_SUM_in_aggregate5618); 
					match(input, Token.DOWN, null); 
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:958:13: ( DISTINCT )*
					loop147:
					while (true) {
						int alt147=2;
						int LA147_0 = input.LA(1);
						if ( (LA147_0==DISTINCT) ) {
							alt147=1;
						}

						switch (alt147) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:958:13: DISTINCT
							{
							match(input,DISTINCT,FOLLOW_DISTINCT_in_aggregate5620); 
							}
							break;

						default :
							break loop147;
						}
					}

					pushFollow(FOLLOW_expression_in_aggregate5623);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:959:7: ^( MIN ( DISTINCT )* expression )
					{
					match(input,MIN,FOLLOW_MIN_in_aggregate5633); 
					match(input, Token.DOWN, null); 
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:959:13: ( DISTINCT )*
					loop148:
					while (true) {
						int alt148=2;
						int LA148_0 = input.LA(1);
						if ( (LA148_0==DISTINCT) ) {
							alt148=1;
						}

						switch (alt148) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:959:13: DISTINCT
							{
							match(input,DISTINCT,FOLLOW_DISTINCT_in_aggregate5635); 
							}
							break;

						default :
							break loop148;
						}
					}

					pushFollow(FOLLOW_expression_in_aggregate5638);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:960:7: ^( MAX ( DISTINCT )* expression )
					{
					match(input,MAX,FOLLOW_MAX_in_aggregate5648); 
					match(input, Token.DOWN, null); 
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:960:13: ( DISTINCT )*
					loop149:
					while (true) {
						int alt149=2;
						int LA149_0 = input.LA(1);
						if ( (LA149_0==DISTINCT) ) {
							alt149=1;
						}

						switch (alt149) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:960:13: DISTINCT
							{
							match(input,DISTINCT,FOLLOW_DISTINCT_in_aggregate5650); 
							}
							break;

						default :
							break loop149;
						}
					}

					pushFollow(FOLLOW_expression_in_aggregate5653);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 5 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:961:7: ^( AVG ( DISTINCT )* expression )
					{
					match(input,AVG,FOLLOW_AVG_in_aggregate5663); 
					match(input, Token.DOWN, null); 
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:961:13: ( DISTINCT )*
					loop150:
					while (true) {
						int alt150=2;
						int LA150_0 = input.LA(1);
						if ( (LA150_0==DISTINCT) ) {
							alt150=1;
						}

						switch (alt150) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:961:13: DISTINCT
							{
							match(input,DISTINCT,FOLLOW_DISTINCT_in_aggregate5665); 
							}
							break;

						default :
							break loop150;
						}
					}

					pushFollow(FOLLOW_expression_in_aggregate5668);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 6 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:962:7: ^( SAMPLE ( DISTINCT )? expression )
					{
					match(input,SAMPLE,FOLLOW_SAMPLE_in_aggregate5678); 
					match(input, Token.DOWN, null); 
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:962:16: ( DISTINCT )?
					int alt151=2;
					int LA151_0 = input.LA(1);
					if ( (LA151_0==DISTINCT) ) {
						alt151=1;
					}
					switch (alt151) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:962:16: DISTINCT
							{
							match(input,DISTINCT,FOLLOW_DISTINCT_in_aggregate5680); 
							}
							break;

					}

					pushFollow(FOLLOW_expression_in_aggregate5683);
					expression();
					state._fsp--;

					match(input, Token.UP, null); 

					}
					break;
				case 7 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:963:7: ^( GROUP_CONCAT ( DISTINCT )* expression ( string )? )
					{
					match(input,GROUP_CONCAT,FOLLOW_GROUP_CONCAT_in_aggregate5693); 
					match(input, Token.DOWN, null); 
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:963:22: ( DISTINCT )*
					loop152:
					while (true) {
						int alt152=2;
						int LA152_0 = input.LA(1);
						if ( (LA152_0==DISTINCT) ) {
							alt152=1;
						}

						switch (alt152) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:963:22: DISTINCT
							{
							match(input,DISTINCT,FOLLOW_DISTINCT_in_aggregate5695); 
							}
							break;

						default :
							break loop152;
						}
					}

					pushFollow(FOLLOW_expression_in_aggregate5698);
					expression();
					state._fsp--;

					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:963:43: ( string )?
					int alt153=2;
					int LA153_0 = input.LA(1);
					if ( ((LA153_0 >= STRING_LITERAL1 && LA153_0 <= STRING_LITERAL_LONG2)) ) {
						alt153=1;
					}
					switch (alt153) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:963:43: string
							{
							pushFollow(FOLLOW_string_in_aggregate5700);
							string();
							state._fsp--;

							}
							break;

					}

					match(input, Token.UP, null); 

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "aggregate"



	// $ANTLR start "iriRefOrFunction"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:966:1: iriRefOrFunction returns [Expr value] : (a= iriRef | ^( FUNCTION a= iriRef ^( ARG_LIST b= argList ) ) );
	public final Expr iriRefOrFunction() throws RecognitionException {
		Expr value = null;


		Node a =null;
		ExprList b =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:967:5: (a= iriRef | ^( FUNCTION a= iriRef ^( ARG_LIST b= argList ) ) )
			int alt155=2;
			int LA155_0 = input.LA(1);
			if ( (LA155_0==IRI_REF||(LA155_0 >= PNAME_LN && LA155_0 <= PNAME_NS)) ) {
				alt155=1;
			}
			else if ( (LA155_0==FUNCTION) ) {
				alt155=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 155, 0, input);
				throw nvae;
			}

			switch (alt155) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:967:7: a= iriRef
					{
					pushFollow(FOLLOW_iriRef_in_iriRefOrFunction5725);
					a=iriRef();
					state._fsp--;

					value = NodeValue.makeNode(a);
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:968:7: ^( FUNCTION a= iriRef ^( ARG_LIST b= argList ) )
					{
					match(input,FUNCTION,FOLLOW_FUNCTION_in_iriRefOrFunction5770); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_iriRef_in_iriRefOrFunction5774);
					a=iriRef();
					state._fsp--;

					match(input,ARG_LIST,FOLLOW_ARG_LIST_in_iriRefOrFunction5777); 
					if ( input.LA(1)==Token.DOWN ) {
						match(input, Token.DOWN, null); 
						pushFollow(FOLLOW_argList_in_iriRefOrFunction5781);
						b=argList();
						state._fsp--;

						match(input, Token.UP, null); 
					}

					match(input, Token.UP, null); 

					value = new E_Function(a.toString(), b);
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "iriRefOrFunction"



	// $ANTLR start "rdfLiteral"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:971:1: rdfLiteral returns [Node value] : ( ^( PLAIN_LITERAL a= string (b= LANGTAG )? ) | ^( TYPED_LITERAL a= string c= iriRef ) );
	public final Node rdfLiteral() throws RecognitionException {
		Node value = null;


		CommonTree b=null;
		String a =null;
		Node c =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:972:5: ( ^( PLAIN_LITERAL a= string (b= LANGTAG )? ) | ^( TYPED_LITERAL a= string c= iriRef ) )
			int alt157=2;
			int LA157_0 = input.LA(1);
			if ( (LA157_0==PLAIN_LITERAL) ) {
				alt157=1;
			}
			else if ( (LA157_0==TYPED_LITERAL) ) {
				alt157=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 157, 0, input);
				throw nvae;
			}

			switch (alt157) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:972:7: ^( PLAIN_LITERAL a= string (b= LANGTAG )? )
					{
					match(input,PLAIN_LITERAL,FOLLOW_PLAIN_LITERAL_in_rdfLiteral5807); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_string_in_rdfLiteral5811);
					a=string();
					state._fsp--;

					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:972:33: (b= LANGTAG )?
					int alt156=2;
					int LA156_0 = input.LA(1);
					if ( (LA156_0==LANGTAG) ) {
						alt156=1;
					}
					switch (alt156) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:972:33: b= LANGTAG
							{
							b=(CommonTree)match(input,LANGTAG,FOLLOW_LANGTAG_in_rdfLiteral5815); 
							}
							break;

					}

					match(input, Token.UP, null); 

					value = Node.createLiteral(a, (b!=null?b.getText():null), null);
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:973:7: ^( TYPED_LITERAL a= string c= iriRef )
					{
					match(input,TYPED_LITERAL,FOLLOW_TYPED_LITERAL_in_rdfLiteral5828); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_string_in_rdfLiteral5832);
					a=string();
					state._fsp--;

					pushFollow(FOLLOW_iriRef_in_rdfLiteral5836);
					c=iriRef();
					state._fsp--;

					match(input, Token.UP, null); 

					value = Node.createLiteral(a, null, TypeMapper.getInstance().getSafeTypeByName(c == null ? null : c.toString()));
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "rdfLiteral"



	// $ANTLR start "numericLiteral"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:978:1: numericLiteral returns [ NodeValue value ] : (a= numericLiteralUnsigned |a= numericLiteralPositive |a= numericLiteralNegative );
	public final NodeValue numericLiteral() throws RecognitionException {
		NodeValue value = null;


		NodeValue a =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:979:5: (a= numericLiteralUnsigned |a= numericLiteralPositive |a= numericLiteralNegative )
			int alt158=3;
			switch ( input.LA(1) ) {
			case DECIMAL:
			case DOUBLE:
			case INTEGER:
				{
				alt158=1;
				}
				break;
			case DECIMAL_POSITIVE:
			case DOUBLE_POSITIVE:
			case INTEGER_POSITIVE:
				{
				alt158=2;
				}
				break;
			case DECIMAL_NEGATIVE:
			case DOUBLE_NEGATIVE:
			case INTEGER_NEGATIVE:
				{
				alt158=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 158, 0, input);
				throw nvae;
			}
			switch (alt158) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:979:7: a= numericLiteralUnsigned
					{
					pushFollow(FOLLOW_numericLiteralUnsigned_in_numericLiteral5868);
					a=numericLiteralUnsigned();
					state._fsp--;

					 value = a; 
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:980:7: a= numericLiteralPositive
					{
					pushFollow(FOLLOW_numericLiteralPositive_in_numericLiteral5880);
					a=numericLiteralPositive();
					state._fsp--;

					 value = a; 
					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:981:7: a= numericLiteralNegative
					{
					pushFollow(FOLLOW_numericLiteralNegative_in_numericLiteral5892);
					a=numericLiteralNegative();
					state._fsp--;

					 value = a; 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "numericLiteral"



	// $ANTLR start "numericLiteralUnsigned"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:984:1: numericLiteralUnsigned returns [ NodeValue value ] : (a= INTEGER |a= DECIMAL |a= DOUBLE );
	public final NodeValue numericLiteralUnsigned() throws RecognitionException {
		NodeValue value = null;


		CommonTree a=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:985:5: (a= INTEGER |a= DECIMAL |a= DOUBLE )
			int alt159=3;
			switch ( input.LA(1) ) {
			case INTEGER:
				{
				alt159=1;
				}
				break;
			case DECIMAL:
				{
				alt159=2;
				}
				break;
			case DOUBLE:
				{
				alt159=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 159, 0, input);
				throw nvae;
			}
			switch (alt159) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:985:7: a= INTEGER
					{
					a=(CommonTree)match(input,INTEGER,FOLLOW_INTEGER_in_numericLiteralUnsigned5917); 
					 value =NodeValue.makeInteger((a!=null?a.getText():null)); 
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:986:7: a= DECIMAL
					{
					a=(CommonTree)match(input,DECIMAL,FOLLOW_DECIMAL_in_numericLiteralUnsigned5929); 
					 value =NodeValue.makeDecimal((a!=null?a.getText():null)); 
					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:987:7: a= DOUBLE
					{
					a=(CommonTree)match(input,DOUBLE,FOLLOW_DOUBLE_in_numericLiteralUnsigned5941); 
					 value =NodeValue.makeDouble(Double.parseDouble((a!=null?a.getText():null))); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "numericLiteralUnsigned"



	// $ANTLR start "numericLiteralPositive"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:990:1: numericLiteralPositive returns [ NodeValue value ] : (a= INTEGER_POSITIVE |a= DECIMAL_POSITIVE |a= DOUBLE_POSITIVE );
	public final NodeValue numericLiteralPositive() throws RecognitionException {
		NodeValue value = null;


		CommonTree a=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:991:5: (a= INTEGER_POSITIVE |a= DECIMAL_POSITIVE |a= DOUBLE_POSITIVE )
			int alt160=3;
			switch ( input.LA(1) ) {
			case INTEGER_POSITIVE:
				{
				alt160=1;
				}
				break;
			case DECIMAL_POSITIVE:
				{
				alt160=2;
				}
				break;
			case DOUBLE_POSITIVE:
				{
				alt160=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 160, 0, input);
				throw nvae;
			}
			switch (alt160) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:991:7: a= INTEGER_POSITIVE
					{
					a=(CommonTree)match(input,INTEGER_POSITIVE,FOLLOW_INTEGER_POSITIVE_in_numericLiteralPositive5967); 
					 value =NodeValue.makeInteger((a!=null?a.getText():null)); 
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:992:7: a= DECIMAL_POSITIVE
					{
					a=(CommonTree)match(input,DECIMAL_POSITIVE,FOLLOW_DECIMAL_POSITIVE_in_numericLiteralPositive5979); 
					 value =NodeValue.makeDecimal((a!=null?a.getText():null)); 
					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:993:7: a= DOUBLE_POSITIVE
					{
					a=(CommonTree)match(input,DOUBLE_POSITIVE,FOLLOW_DOUBLE_POSITIVE_in_numericLiteralPositive5991); 
					 value =NodeValue.makeDouble(Double.parseDouble((a!=null?a.getText():null))); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "numericLiteralPositive"



	// $ANTLR start "numericLiteralNegative"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:996:1: numericLiteralNegative returns [ NodeValue value ] : (a= INTEGER_NEGATIVE |a= DECIMAL_NEGATIVE |a= DOUBLE_NEGATIVE );
	public final NodeValue numericLiteralNegative() throws RecognitionException {
		NodeValue value = null;


		CommonTree a=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:997:5: (a= INTEGER_NEGATIVE |a= DECIMAL_NEGATIVE |a= DOUBLE_NEGATIVE )
			int alt161=3;
			switch ( input.LA(1) ) {
			case INTEGER_NEGATIVE:
				{
				alt161=1;
				}
				break;
			case DECIMAL_NEGATIVE:
				{
				alt161=2;
				}
				break;
			case DOUBLE_NEGATIVE:
				{
				alt161=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 161, 0, input);
				throw nvae;
			}
			switch (alt161) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:997:7: a= INTEGER_NEGATIVE
					{
					a=(CommonTree)match(input,INTEGER_NEGATIVE,FOLLOW_INTEGER_NEGATIVE_in_numericLiteralNegative6017); 
					 value =NodeValue.makeInteger((a!=null?a.getText():null)); 
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:998:7: a= DECIMAL_NEGATIVE
					{
					a=(CommonTree)match(input,DECIMAL_NEGATIVE,FOLLOW_DECIMAL_NEGATIVE_in_numericLiteralNegative6029); 
					 value =NodeValue.makeDecimal((a!=null?a.getText():null)); 
					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:999:7: a= DOUBLE_NEGATIVE
					{
					a=(CommonTree)match(input,DOUBLE_NEGATIVE,FOLLOW_DOUBLE_NEGATIVE_in_numericLiteralNegative6041); 
					 value =NodeValue.makeDouble(Double.parseDouble((a!=null?a.getText():null))); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "numericLiteralNegative"



	// $ANTLR start "booleanLiteral"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:1002:1: booleanLiteral returns [ NodeValue value ] : ( TRUE | FALSE );
	public final NodeValue booleanLiteral() throws RecognitionException {
		NodeValue value = null;


		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:1003:5: ( TRUE | FALSE )
			int alt162=2;
			int LA162_0 = input.LA(1);
			if ( (LA162_0==TRUE) ) {
				alt162=1;
			}
			else if ( (LA162_0==FALSE) ) {
				alt162=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 162, 0, input);
				throw nvae;
			}

			switch (alt162) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:1003:7: TRUE
					{
					match(input,TRUE,FOLLOW_TRUE_in_booleanLiteral6065); 
					 value = NodeValue.TRUE; 
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:1004:7: FALSE
					{
					match(input,FALSE,FOLLOW_FALSE_in_booleanLiteral6076); 
					 value = NodeValue.FALSE; 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "booleanLiteral"



	// $ANTLR start "string"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:1007:1: string returns [String value] : (a= STRING_LITERAL1 |a= STRING_LITERAL2 |a= STRING_LITERAL_LONG1 |a= STRING_LITERAL_LONG2 );
	public final String string() throws RecognitionException {
		String value = null;


		CommonTree a=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:1008:5: (a= STRING_LITERAL1 |a= STRING_LITERAL2 |a= STRING_LITERAL_LONG1 |a= STRING_LITERAL_LONG2 )
			int alt163=4;
			switch ( input.LA(1) ) {
			case STRING_LITERAL1:
				{
				alt163=1;
				}
				break;
			case STRING_LITERAL2:
				{
				alt163=2;
				}
				break;
			case STRING_LITERAL_LONG1:
				{
				alt163=3;
				}
				break;
			case STRING_LITERAL_LONG2:
				{
				alt163=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 163, 0, input);
				throw nvae;
			}
			switch (alt163) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:1008:7: a= STRING_LITERAL1
					{
					a=(CommonTree)match(input,STRING_LITERAL1,FOLLOW_STRING_LITERAL1_in_string6101); 
					value = (a!=null?a.getText():null);
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:1009:7: a= STRING_LITERAL2
					{
					a=(CommonTree)match(input,STRING_LITERAL2,FOLLOW_STRING_LITERAL2_in_string6118); 
					value = (a!=null?a.getText():null);
					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:1010:7: a= STRING_LITERAL_LONG1
					{
					a=(CommonTree)match(input,STRING_LITERAL_LONG1,FOLLOW_STRING_LITERAL_LONG1_in_string6135); 
					value = (a!=null?a.getText():null);
					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:1011:7: a= STRING_LITERAL_LONG2
					{
					a=(CommonTree)match(input,STRING_LITERAL_LONG2,FOLLOW_STRING_LITERAL_LONG2_in_string6147); 
					value = (a!=null?a.getText():null);
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "string"



	// $ANTLR start "iriRef"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:1014:1: iriRef returns [Node value] : (a= IRI_REF |b= prefixedName );
	public final Node iriRef() throws RecognitionException {
		Node value = null;


		CommonTree a=null;
		Node b =null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:1015:5: (a= IRI_REF |b= prefixedName )
			int alt164=2;
			int LA164_0 = input.LA(1);
			if ( (LA164_0==IRI_REF) ) {
				alt164=1;
			}
			else if ( ((LA164_0 >= PNAME_LN && LA164_0 <= PNAME_NS)) ) {
				alt164=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 164, 0, input);
				throw nvae;
			}

			switch (alt164) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:1015:7: a= IRI_REF
					{
					a=(CommonTree)match(input,IRI_REF,FOLLOW_IRI_REF_in_iriRef6172); 
					value = Node.createURI((a!=null?a.getText():null));
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:1016:7: b= prefixedName
					{
					pushFollow(FOLLOW_prefixedName_in_iriRef6189);
					b=prefixedName();
					state._fsp--;

					value = b;
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "iriRef"



	// $ANTLR start "prefixedName"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:1019:1: prefixedName returns [Node value] : (a= PNAME_LN |a= PNAME_NS );
	public final Node prefixedName() throws RecognitionException {
		Node value = null;


		CommonTree a=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:1020:5: (a= PNAME_LN |a= PNAME_NS )
			int alt165=2;
			int LA165_0 = input.LA(1);
			if ( (LA165_0==PNAME_LN) ) {
				alt165=1;
			}
			else if ( (LA165_0==PNAME_NS) ) {
				alt165=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 165, 0, input);
				throw nvae;
			}

			switch (alt165) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:1020:7: a= PNAME_LN
					{
					a=(CommonTree)match(input,PNAME_LN,FOLLOW_PNAME_LN_in_prefixedName6214); 
					value = Node.createURI(expandUri((a!=null?a.getText():null)));
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:1021:7: a= PNAME_NS
					{
					a=(CommonTree)match(input,PNAME_NS,FOLLOW_PNAME_NS_in_prefixedName6227); 
					value = Node.createURI(expandPrefix((a!=null?a.getText():null)));
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "prefixedName"



	// $ANTLR start "blankNode"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:1024:1: blankNode returns [Node value] : (a= BLANK_NODE_LABEL | anon );
	public final Node blankNode() throws RecognitionException {
		Node value = null;


		CommonTree a=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:1025:5: (a= BLANK_NODE_LABEL | anon )
			int alt166=2;
			int LA166_0 = input.LA(1);
			if ( (LA166_0==BLANK_NODE_LABEL) ) {
				alt166=1;
			}
			else if ( (LA166_0==OPEN_SQUARE_BRACKET) ) {
				alt166=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 166, 0, input);
				throw nvae;
			}

			switch (alt166) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:1025:7: a= BLANK_NODE_LABEL
					{
					a=(CommonTree)match(input,BLANK_NODE_LABEL,FOLLOW_BLANK_NODE_LABEL_in_blankNode6253); 
					value = Node.createAnon(new AnonId((a!=null?a.getText():null)));
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:1026:7: anon
					{
					pushFollow(FOLLOW_anon_in_blankNode6263);
					anon();
					state._fsp--;

					value = Node.createAnon();
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "blankNode"



	// $ANTLR start "anon"
	// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:1029:1: anon : OPEN_SQUARE_BRACKET CLOSE_SQUARE_BRACKET ;
	public final void anon() throws RecognitionException {
		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:1030:5: ( OPEN_SQUARE_BRACKET CLOSE_SQUARE_BRACKET )
			// org/aksw/sparqlify/config/lang/SparqlifyConfigTree.g:1030:7: OPEN_SQUARE_BRACKET CLOSE_SQUARE_BRACKET
			{
			match(input,OPEN_SQUARE_BRACKET,FOLLOW_OPEN_SQUARE_BRACKET_in_anon6282); 
			match(input,CLOSE_SQUARE_BRACKET,FOLLOW_CLOSE_SQUARE_BRACKET_in_anon6284); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "anon"

	// Delegated rules


	protected DFA45 dfa45 = new DFA45(this);
	static final String DFA45_eotS =
		"\14\uffff";
	static final String DFA45_eofS =
		"\14\uffff";
	static final String DFA45_minS =
		"\1\47\1\2\1\3\1\uffff\1\2\1\uffff\2\147\4\3";
	static final String DFA45_maxS =
		"\1\47\1\2\1\u00f7\1\uffff\1\2\1\uffff\2\u009f\3\3\1\u00f7";
	static final String DFA45_acceptS =
		"\3\uffff\1\1\1\uffff\1\2\6\uffff";
	static final String DFA45_specialS =
		"\14\uffff}>";
	static final String[] DFA45_transitionS = {
			"\1\1",
			"\1\2",
			"\1\3\45\uffff\1\3\43\uffff\1\4\12\uffff\1\3\2\uffff\1\3\32\uffff\1\3"+
			"\26\uffff\1\3\6\uffff\1\3\141\uffff\1\5\1\3",
			"",
			"\1\6",
			"",
			"\1\10\33\uffff\1\7\32\uffff\1\11\1\12",
			"\1\10\66\uffff\1\11\1\12",
			"\1\13",
			"\1\13",
			"\1\13",
			"\1\3\111\uffff\1\4\12\uffff\1\3\2\uffff\1\3\32\uffff\1\3\26\uffff\1"+
			"\3\6\uffff\1\3\141\uffff\1\5\1\3"
	};

	static final short[] DFA45_eot = DFA.unpackEncodedString(DFA45_eotS);
	static final short[] DFA45_eof = DFA.unpackEncodedString(DFA45_eofS);
	static final char[] DFA45_min = DFA.unpackEncodedStringToUnsignedChars(DFA45_minS);
	static final char[] DFA45_max = DFA.unpackEncodedStringToUnsignedChars(DFA45_maxS);
	static final short[] DFA45_accept = DFA.unpackEncodedString(DFA45_acceptS);
	static final short[] DFA45_special = DFA.unpackEncodedString(DFA45_specialS);
	static final short[][] DFA45_transition;

	static {
		int numStates = DFA45_transitionS.length;
		DFA45_transition = new short[numStates][];
		for (int i=0; i<numStates; i++) {
			DFA45_transition[i] = DFA.unpackEncodedString(DFA45_transitionS[i]);
		}
	}

	protected class DFA45 extends DFA {

		public DFA45(BaseRecognizer recognizer) {
			this.recognizer = recognizer;
			this.decisionNumber = 45;
			this.eot = DFA45_eot;
			this.eof = DFA45_eof;
			this.min = DFA45_min;
			this.max = DFA45_max;
			this.accept = DFA45_accept;
			this.special = DFA45_special;
			this.transition = DFA45_transition;
		}
		@Override
		public String getDescription() {
			return "443:1: constructQuery : ( ^( CONSTRUCT ( constructTemplate )* ( datasetClause )* ( whereClause )* solutionModifier ) | ^( CONSTRUCT ( datasetClause )* ^( WHERE ( triplesTemplate )* ) solutionModifier ) );";
		}
	}

	public static final BitSet FOLLOW_templateConfigItem_in_templateConfig66 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x1000004000000010L});
	public static final BitSet FOLLOW_namedViewTemplateDefinition_in_templateConfigItem88 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_prefixDecl_in_templateConfigItem100 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_setStmt_in_templateConfigItem112 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SET_in_setStmt136 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_NAME_in_setStmt140 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x000000000000F000L});
	public static final BitSet FOLLOW_string_in_setStmt144 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_constructConfigItem_in_constructConfig176 = new BitSet(new long[]{0x0000040000000002L,0x0000000000000000L,0x1000004000000000L});
	public static final BitSet FOLLOW_constructViewDefinition_in_constructConfigItem198 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_prefixDecl_in_constructConfigItem211 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_setStmt_in_constructConfigItem223 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CONSTRUCT_VIEW_DEFINITION_in_constructViewDefinition248 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_NAME_in_constructViewDefinition252 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000000020L});
	public static final BitSet FOLLOW_SQL_QUERY_in_constructViewDefinition256 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_sparqlifyConfigItem_in_sparqlifyConfig291 = new BitSet(new long[]{0x0000000000000002L,0x0000000000010000L,0x1000004000000000L,0x0010000000000000L});
	public static final BitSet FOLLOW_viewDefinition_in_sparqlifyConfigItem313 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_prefixDecl_in_sparqlifyConfigItem330 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_functionDeclaration_in_sparqlifyConfigItem351 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_setStmt_in_sparqlifyConfigItem363 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_FUNCTION_DECLARATION_in_functionDeclaration389 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_functionSignature_in_functionDeclaration393 = new BitSet(new long[]{0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_functionTemplate_in_functionDeclaration397 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_FUNCTION_SIGNATURE_in_functionSignature422 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_NAME_in_functionSignature426 = new BitSet(new long[]{0x0000000000000000L,0x0000008000000000L,0x00000000C0000000L});
	public static final BitSet FOLLOW_iriRef_in_functionSignature430 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000800000L});
	public static final BitSet FOLLOW_paramTypeList_in_functionSignature434 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_PARAM_TYPE_LIST_in_paramTypeList468 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_paramType_in_paramTypeList473 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0000000000400000L});
	public static final BitSet FOLLOW_PARAM_TYPE_LIST_in_paramTypeList487 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_nil_in_paramTypeList489 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_PARAM_TYPE_in_paramType513 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_NAME_in_paramType517 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_var_in_paramType521 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_FUNCTION_TEMPLATE_in_functionTemplate547 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_NAME_in_functionTemplate551 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000200L});
	public static final BitSet FOLLOW_expressionList_in_functionTemplate555 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_NAMED_VIEW_TEMPLATE_DEFINITION_in_namedViewTemplateDefinition583 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_NAME_in_namedViewTemplateDefinition587 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0020000000000000L});
	public static final BitSet FOLLOW_viewTemplateDefinition_in_namedViewTemplateDefinition591 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_VIEW_TEMPLATE_DEFINITION_in_viewTemplateDefinition616 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_constructTemplateQuads_in_viewTemplateDefinition620 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0000000000000000L,0x0002000000000000L});
	public static final BitSet FOLLOW_varBindings_in_viewTemplateDefinition624 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_VIEW_DEFINITION_in_viewDefinition650 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_NAME_in_viewDefinition654 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0020000000000000L});
	public static final BitSet FOLLOW_viewTemplateDefinition_in_viewDefinition658 = new BitSet(new long[]{0x0000004000000008L,0x0000000000000000L,0x0004000000000000L});
	public static final BitSet FOLLOW_varConstraints_in_viewDefinition662 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0004000000000000L});
	public static final BitSet FOLLOW_sqlRelation_in_viewDefinition667 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_VAR_BINDINGS_in_varBindings702 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_varBinding_in_varBindings707 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0000000000000000L,0x0001000000000000L});
	public static final BitSet FOLLOW_VAR_BINDING_in_varBinding735 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_var_in_varBinding739 = new BitSet(new long[]{0x0000000001000000L,0x0000000000000000L,0x0000000010000000L,0x0000020080000000L});
	public static final BitSet FOLLOW_typeCtorExpression_in_varBinding743 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_BNODE_in_typeCtorExpression768 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_typeCtorExpression772 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_URI_in_typeCtorExpression784 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expressionList_in_typeCtorExpression788 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_PLAIN_LITERAL_in_typeCtorExpression800 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_typeCtorExpression804 = new BitSet(new long[]{0x2000000000010408L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_expression_in_typeCtorExpression808 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_TYPED_LITERAL_in_typeCtorExpression821 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_typeCtorExpression825 = new BitSet(new long[]{0x2000000000010400L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_expression_in_typeCtorExpression829 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_SQL_RELATION_in_sqlRelationOld854 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_SQL_QUERY_in_sqlRelationOld858 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_SQL_RELATION_in_sqlRelationOld870 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_SQL_TABLE_in_sqlRelationOld874 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_RELATION_REF_in_sqlRelation901 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_joinClause_in_sqlRelation905 = new BitSet(new long[]{0x2000000000010408L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_expression_in_sqlRelation909 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_joinClauseMember_in_joinClause936 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_FULL_JOIN_in_joinClause947 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_joinClauseMember_in_joinClause951 = new BitSet(new long[]{0x0000000000000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_joinClauseMember_in_joinClause955 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_JOIN_MEMBER_in_joinClauseMember980 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_sqlLogicalTable_in_joinClauseMember984 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_NAME_in_joinClauseMember988 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_SQL_RELATION_in_sqlLogicalTable1014 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_SQL_QUERY_in_sqlLogicalTable1018 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_SQL_RELATION_in_sqlLogicalTable1030 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_SQL_TABLE_in_sqlLogicalTable1034 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_CONSTRAINTS_in_varConstraints1069 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_varConstraint_in_varConstraints1074 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0002008000000000L});
	public static final BitSet FOLLOW_regexVarConstraint_in_varConstraint1102 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_prefixVarConstraint_in_varConstraint1116 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_REGEX_CONSTRAINT_in_regexVarConstraint1141 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_var_in_regexVarConstraint1145 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x000000000000F000L});
	public static final BitSet FOLLOW_string_in_regexVarConstraint1149 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_PREFIX_CONSTRAINT_in_prefixVarConstraint1174 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_var_in_prefixVarConstraint1178 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_stringList_in_prefixVarConstraint1182 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_STRING_LIST_in_stringList1216 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_string_in_stringList1221 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0000000000000000L,0x000000000000F000L});
	public static final BitSet FOLLOW_QUERY_in_query1245 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_prologue_in_query1247 = new BitSet(new long[]{0x0400008000008008L,0x0000000000000000L,0x0080000000000000L});
	public static final BitSet FOLLOW_selectQuery_in_query1249 = new BitSet(new long[]{0x0400008000008008L,0x0000000000000000L,0x0080000000000000L});
	public static final BitSet FOLLOW_constructQuery_in_query1252 = new BitSet(new long[]{0x0400008000008008L});
	public static final BitSet FOLLOW_describeQuery_in_query1255 = new BitSet(new long[]{0x0400000000008008L});
	public static final BitSet FOLLOW_askQuery_in_query1258 = new BitSet(new long[]{0x0000000000008008L});
	public static final BitSet FOLLOW_bindingsClause_in_query1262 = new BitSet(new long[]{0x0000000000100002L});
	public static final BitSet FOLLOW_UPDATE_in_query1272 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_update_in_query1274 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0000020000000000L});
	public static final BitSet FOLLOW_PROLOGUE_in_prologue1294 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_baseDecl_in_prologue1296 = new BitSet(new long[]{0x0000000000040008L,0x0000000000000000L,0x0000004000000000L});
	public static final BitSet FOLLOW_prefixDecl_in_prologue1299 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0000004000000000L});
	public static final BitSet FOLLOW_BASE_in_baseDecl1319 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_IRI_REF_in_baseDecl1321 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_PREFIX_in_prefixDecl1344 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_PNAME_NS_in_prefixDecl1348 = new BitSet(new long[]{0x0000000000000000L,0x0000008000000000L});
	public static final BitSet FOLLOW_IRI_REF_in_prefixDecl1352 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_SELECT_in_selectQuery1373 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_selectClause_in_selectQuery1375 = new BitSet(new long[]{0x0000000000000008L,0x0040000009002000L,0x0000000000102000L,0x0080000000000000L});
	public static final BitSet FOLLOW_datasetClause_in_selectQuery1377 = new BitSet(new long[]{0x0000000000000008L,0x0040000009002000L,0x0000000000102000L,0x0080000000000000L});
	public static final BitSet FOLLOW_whereClause_in_selectQuery1380 = new BitSet(new long[]{0x0000000000000008L,0x0040000009000000L,0x0000000000102000L,0x0080000000000000L});
	public static final BitSet FOLLOW_solutionModifier_in_selectQuery1383 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_SUBSELECT_in_subSelect1402 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_whereClause_in_subSelect1404 = new BitSet(new long[]{0x0000000000000008L,0x0040000009000000L,0x0000000000102000L,0x0080000000000000L});
	public static final BitSet FOLLOW_solutionModifier_in_subSelect1407 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_SELECT_CLAUSE_in_selectClause1426 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_ASTERISK_in_selectClause1428 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_SELECT_CLAUSE_in_selectClause1438 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_DISTINCT_in_selectClause1440 = new BitSet(new long[]{0x0000000000010000L});
	public static final BitSet FOLLOW_ASTERISK_in_selectClause1442 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_SELECT_CLAUSE_in_selectClause1452 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_REDUCED_in_selectClause1454 = new BitSet(new long[]{0x0000000000010000L});
	public static final BitSet FOLLOW_ASTERISK_in_selectClause1456 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_SELECT_CLAUSE_in_selectClause1466 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_selectVariables_in_selectClause1468 = new BitSet(new long[]{0x0000000000002008L,0x0000000000000000L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_SELECT_CLAUSE_in_selectClause1479 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_DISTINCT_in_selectClause1481 = new BitSet(new long[]{0x0000000000002008L,0x0000000000000000L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_selectVariables_in_selectClause1483 = new BitSet(new long[]{0x0000000000002008L,0x0000000000000000L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_SELECT_CLAUSE_in_selectClause1494 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_REDUCED_in_selectClause1496 = new BitSet(new long[]{0x0000000000002008L,0x0000000000000000L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_selectVariables_in_selectClause1498 = new BitSet(new long[]{0x0000000000002008L,0x0000000000000000L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_VAR_in_selectVariables1518 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_var_in_selectVariables1520 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_AS_in_selectVariables1530 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_selectVariables1532 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_var_in_selectVariables1534 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_CONSTRUCT_in_constructQuery1553 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_constructTemplate_in_constructQuery1555 = new BitSet(new long[]{0x0000020000000008L,0x0040000009002000L,0x0000000000102000L,0x0080000000000000L});
	public static final BitSet FOLLOW_datasetClause_in_constructQuery1558 = new BitSet(new long[]{0x0000000000000008L,0x0040000009002000L,0x0000000000102000L,0x0080000000000000L});
	public static final BitSet FOLLOW_whereClause_in_constructQuery1561 = new BitSet(new long[]{0x0000000000000008L,0x0040000009000000L,0x0000000000102000L,0x0080000000000000L});
	public static final BitSet FOLLOW_solutionModifier_in_constructQuery1564 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_CONSTRUCT_in_constructQuery1574 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_datasetClause_in_constructQuery1576 = new BitSet(new long[]{0x0000000000000000L,0x0000000000002000L,0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_WHERE_in_constructQuery1580 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_triplesTemplate_in_constructQuery1582 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0000000000000000L,0x0000000020000000L});
	public static final BitSet FOLLOW_solutionModifier_in_constructQuery1586 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_DESCRIBE_in_describeQuery1605 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_varOrIRIref_in_describeQuery1607 = new BitSet(new long[]{0x0000000000010008L,0x0040008009002000L,0x00000000C0102000L,0x0080080000000000L});
	public static final BitSet FOLLOW_ASTERISK_in_describeQuery1610 = new BitSet(new long[]{0x0000000000010008L,0x0040000009002000L,0x0000000000102000L,0x0080000000000000L});
	public static final BitSet FOLLOW_datasetClause_in_describeQuery1613 = new BitSet(new long[]{0x0000000000000008L,0x0040000009002000L,0x0000000000102000L,0x0080000000000000L});
	public static final BitSet FOLLOW_whereClause_in_describeQuery1616 = new BitSet(new long[]{0x0000000000000008L,0x0040000009000000L,0x0000000000102000L});
	public static final BitSet FOLLOW_solutionModifier_in_describeQuery1619 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_ASK_in_askQuery1638 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_datasetClause_in_askQuery1640 = new BitSet(new long[]{0x0000000000000000L,0x0000000000002000L,0x0000000000000000L,0x0080000000000000L});
	public static final BitSet FOLLOW_whereClause_in_askQuery1643 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_FROM_in_datasetClause1662 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_NAMED_in_datasetClause1664 = new BitSet(new long[]{0x0000000000000000L,0x0000008000000000L,0x00000000C0000000L});
	public static final BitSet FOLLOW_iriRef_in_datasetClause1667 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_WHERE_CLAUSE_in_whereClause1686 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_groupGraphPattern_in_whereClause1688 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_groupClause_in_solutionModifier1706 = new BitSet(new long[]{0x0000000000000002L,0x0040000008000000L,0x0000000000102000L});
	public static final BitSet FOLLOW_havingClause_in_solutionModifier1709 = new BitSet(new long[]{0x0000000000000002L,0x0040000000000000L,0x0000000000102000L});
	public static final BitSet FOLLOW_orderClause_in_solutionModifier1712 = new BitSet(new long[]{0x0000000000000002L,0x0040000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_limitOffsetClauses_in_solutionModifier1715 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_GROUP_BY_in_groupClause1734 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_groupCondition_in_groupClause1736 = new BitSet(new long[]{0x000308110B002028L,0x4409BE4030009090L,0xE059200000000C01L,0x04000A0301270703L});
	public static final BitSet FOLLOW_builtInCall_in_groupCondition1755 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_functionCall_in_groupCondition1763 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_AS_in_groupCondition1772 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_groupCondition1774 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_var_in_groupCondition1776 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_var_in_groupCondition1786 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_HAVING_in_havingClause1804 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_constraint_in_havingClause1806 = new BitSet(new long[]{0x200308110B010428L,0x5439BE40B06090D0L,0xE059200020040F01L,0x0400023F01270703L});
	public static final BitSet FOLLOW_ORDER_BY_in_orderClause1826 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_orderCondition_in_orderClause1828 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_ORDER_CONDITION_in_orderCondition1848 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_ASC_in_orderCondition1850 = new BitSet(new long[]{0x2000000000010400L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_expression_in_orderCondition1852 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_ORDER_CONDITION_in_orderCondition1862 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_DESC_in_orderCondition1864 = new BitSet(new long[]{0x2000000000010400L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_expression_in_orderCondition1866 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_ORDER_CONDITION_in_orderCondition1876 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_constraint_in_orderCondition1878 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_ORDER_CONDITION_in_orderCondition1888 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_var_in_orderCondition1890 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_LIMIT_in_limitOffsetClauses1909 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_INTEGER_in_limitOffsetClauses1911 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_OFFSET_in_limitOffsetClauses1916 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_INTEGER_in_limitOffsetClauses1918 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_OFFSET_in_limitOffsetClauses1930 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_INTEGER_in_limitOffsetClauses1932 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_LIMIT_in_limitOffsetClauses1937 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_INTEGER_in_limitOffsetClauses1939 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_BINDINGS_in_bindingsClause1961 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_var_in_bindingsClause1963 = new BitSet(new long[]{0x0000000000200008L,0x0000000000000000L,0x0000000000000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_bindingValueList_in_bindingsClause1966 = new BitSet(new long[]{0x0000000000200008L});
	public static final BitSet FOLLOW_BINDING_VALUE_in_bindingValueList1986 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_bindingValue_in_bindingValueList1988 = new BitSet(new long[]{0x801C000000000008L,0x0000008E00000403L,0x00000000D0000000L,0x00000040C0000000L});
	public static final BitSet FOLLOW_iriRef_in_bindingValue2013 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_rdfLiteral_in_bindingValue2025 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_numericLiteral_in_bindingValue2035 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_booleanLiteral_in_bindingValue2043 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_UNDEF_in_bindingValue2051 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_prologue_in_update2068 = new BitSet(new long[]{0x0100500010000042L,0x8080000100000004L,0x0000000000000002L});
	public static final BitSet FOLLOW_load_in_update2070 = new BitSet(new long[]{0x0100500010000042L,0x8080000100000004L,0x0000000000000002L});
	public static final BitSet FOLLOW_clear_in_update2073 = new BitSet(new long[]{0x0100500010000042L,0x8000000100000004L,0x0000000000000002L});
	public static final BitSet FOLLOW_drop_in_update2076 = new BitSet(new long[]{0x0100500000000042L,0x8000000100000004L,0x0000000000000002L});
	public static final BitSet FOLLOW_add_in_update2079 = new BitSet(new long[]{0x0100500000000042L,0x8000000100000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_move_in_update2082 = new BitSet(new long[]{0x0100500000000002L,0x8000000100000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_copy_in_update2085 = new BitSet(new long[]{0x0100500000000002L,0x8000000100000000L});
	public static final BitSet FOLLOW_create_in_update2088 = new BitSet(new long[]{0x0100400000000002L,0x8000000100000000L});
	public static final BitSet FOLLOW_insert_in_update2091 = new BitSet(new long[]{0x0100000000000002L,0x8000000100000000L});
	public static final BitSet FOLLOW_delete_in_update2094 = new BitSet(new long[]{0x0100000000000002L,0x8000000000000000L});
	public static final BitSet FOLLOW_modify_in_update2097 = new BitSet(new long[]{0x0000000000000002L,0x8000000000000000L});
	public static final BitSet FOLLOW_LOAD_in_load2116 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_SILENT_in_load2118 = new BitSet(new long[]{0x0000000000000000L,0x0000008000000000L,0x00000000C0000000L,0x0000000000000008L});
	public static final BitSet FOLLOW_iriRef_in_load2121 = new BitSet(new long[]{0x0000000000000008L,0x0000000000080000L});
	public static final BitSet FOLLOW_graphRef_in_load2123 = new BitSet(new long[]{0x0000000000000008L,0x0000000000080000L});
	public static final BitSet FOLLOW_CLEAR_in_clear2143 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_SILENT_in_clear2145 = new BitSet(new long[]{0x0040000000000200L,0x0000000000080000L,0x0000000000000008L,0x0000000000000008L});
	public static final BitSet FOLLOW_graphRefAll_in_clear2148 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_DROP_in_drop2167 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_SILENT_in_drop2169 = new BitSet(new long[]{0x0040000000000200L,0x0000000000080000L,0x0000000000000008L,0x0000000000000008L});
	public static final BitSet FOLLOW_graphRefAll_in_drop2172 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_CREATE_in_create2191 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_SILENT_in_create2193 = new BitSet(new long[]{0x0000000000000000L,0x0000000000080000L,0x0000000000000000L,0x0000000000000008L});
	public static final BitSet FOLLOW_graphRef_in_create2196 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_ADD_in_add2215 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_SILENT_in_add2217 = new BitSet(new long[]{0x0040000000000000L,0x0000008000080000L,0x00000000C0000000L,0x0000000000000008L});
	public static final BitSet FOLLOW_graphOrDefault_in_add2220 = new BitSet(new long[]{0x0040000000000000L,0x0000008000080000L,0x00000000C0000000L});
	public static final BitSet FOLLOW_graphOrDefault_in_add2222 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_MOVE_in_move2241 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_SILENT_in_move2243 = new BitSet(new long[]{0x0040000000000000L,0x0000008000080000L,0x00000000C0000000L,0x0000000000000008L});
	public static final BitSet FOLLOW_graphOrDefault_in_move2246 = new BitSet(new long[]{0x0040000000000000L,0x0000008000080000L,0x00000000C0000000L});
	public static final BitSet FOLLOW_graphOrDefault_in_move2248 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_COPY_in_copy2267 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_SILENT_in_copy2269 = new BitSet(new long[]{0x0040000000000000L,0x0000008000080000L,0x00000000C0000000L,0x0000000000000008L});
	public static final BitSet FOLLOW_graphOrDefault_in_copy2272 = new BitSet(new long[]{0x0040000000000000L,0x0000008000080000L,0x00000000C0000000L});
	public static final BitSet FOLLOW_graphOrDefault_in_copy2274 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_INSERT_in_insert2293 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_DATA_in_insert2295 = new BitSet(new long[]{0x0000000000000000L,0x0000000000100000L,0x0000000000000000L,0x0000000020000000L});
	public static final BitSet FOLLOW_quadPattern_in_insert2297 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_DELETE_in_delete2315 = new BitSet(new long[]{0x0100000000000000L});
	public static final BitSet FOLLOW_deleteData_in_delete2319 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_deleteWhere_in_delete2323 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DELETE_in_deleteData2343 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_DATA_in_deleteData2345 = new BitSet(new long[]{0x0000000000000000L,0x0000000000100000L,0x0000000000000000L,0x0000000020000000L});
	public static final BitSet FOLLOW_quadPattern_in_deleteData2347 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_DELETE_in_deleteWhere2366 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_WHERE_in_deleteWhere2368 = new BitSet(new long[]{0x0000000000000000L,0x0000000000100000L,0x0000000000000000L,0x0000000020000000L});
	public static final BitSet FOLLOW_quadPattern_in_deleteWhere2370 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_MODIFY_in_modify2389 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_WITH_in_modify2392 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_iriRef_in_modify2394 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_deleteClause_in_modify2397 = new BitSet(new long[]{0x0100000000000000L,0x0000000100000000L,0x0000000000000000L,0x0040040000000000L});
	public static final BitSet FOLLOW_insertClause_in_modify2400 = new BitSet(new long[]{0x0000000000000000L,0x0000000100000000L,0x0000000000000000L,0x0040040000000000L});
	public static final BitSet FOLLOW_usingClause_in_modify2403 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0040040000000000L});
	public static final BitSet FOLLOW_WHERE_in_modify2407 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_groupGraphPattern_in_modify2409 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_MODIFY_in_modify2420 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_deleteClause_in_modify2422 = new BitSet(new long[]{0x0100000000000000L,0x0000000100000000L,0x0000000000000000L,0x0040040000000000L});
	public static final BitSet FOLLOW_insertClause_in_modify2425 = new BitSet(new long[]{0x0000000000000000L,0x0000000100000000L,0x0000000000000000L,0x0040040000000000L});
	public static final BitSet FOLLOW_usingClause_in_modify2428 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0040040000000000L});
	public static final BitSet FOLLOW_WHERE_in_modify2432 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_groupGraphPattern_in_modify2434 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_DELETE_in_deleteClause2453 = new BitSet(new long[]{0x0000000000000000L,0x0000000000100000L,0x0000000000000000L,0x0000000020000000L});
	public static final BitSet FOLLOW_quadPattern_in_deleteClause2455 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_INSERT_in_insertClause2472 = new BitSet(new long[]{0x0000000000000000L,0x0000000000100000L,0x0000000000000000L,0x0000000020000000L});
	public static final BitSet FOLLOW_quadPattern_in_insertClause2474 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_USING_in_usingClause2492 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_NAMED_in_usingClause2494 = new BitSet(new long[]{0x0000000000000000L,0x0000008000000000L,0x00000000C0000000L});
	public static final BitSet FOLLOW_iriRef_in_usingClause2497 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_DEFAULT_in_graphOrDefault2515 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_GRAPH_in_graphOrDefault2523 = new BitSet(new long[]{0x0000000000000000L,0x0000008000000000L,0x00000000C0000000L});
	public static final BitSet FOLLOW_iriRef_in_graphOrDefault2526 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_GRAPH_in_graphRef2543 = new BitSet(new long[]{0x0000000000000000L,0x0000008000000000L,0x00000000C0000000L});
	public static final BitSet FOLLOW_iriRef_in_graphRef2545 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_graphRef_in_graphRefAll2562 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DEFAULT_in_graphRefAll2566 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NAMED_in_graphRefAll2570 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ALL_in_graphRefAll2574 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_quads_in_quadPattern2597 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_triplesTemplate_in_quads2630 = new BitSet(new long[]{0x0000000000000002L,0x0000000000100000L});
	public static final BitSet FOLLOW_quadsNotTriples_in_quads2638 = new BitSet(new long[]{0x0000000000000002L,0x0000000000100000L,0x0000000000000000L,0x0000000020000000L});
	public static final BitSet FOLLOW_triplesTemplate_in_quads2644 = new BitSet(new long[]{0x0000000000000002L,0x0000000000100000L});
	public static final BitSet FOLLOW_GRAPH_TOKEN_in_quadsNotTriples2677 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_varOrIRIref_in_quadsNotTriples2681 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0000000000000000L,0x0000000020000000L});
	public static final BitSet FOLLOW_triplesTemplate_in_quadsNotTriples2685 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_TRIPLES_TEMPLATE_in_triplesTemplate2714 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_triples_in_triplesTemplate2718 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_GROUP_GRAPH_PATTERN_in_groupGraphPattern2739 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_subSelect_in_groupGraphPattern2741 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_GROUP_GRAPH_PATTERN_in_groupGraphPattern2751 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_groupGraphPatternSub_in_groupGraphPattern2753 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_triplesBlock_in_groupGraphPatternSub2771 = new BitSet(new long[]{0x0000000000080002L,0x2000000004080800L,0x0800000000020000L,0x0000008000000000L});
	public static final BitSet FOLLOW_groupGraphPatternSubCache_in_groupGraphPatternSub2774 = new BitSet(new long[]{0x0000000000080002L,0x2000000004080800L,0x0800000000020000L,0x0000008000000000L});
	public static final BitSet FOLLOW_graphPatternNotTriples_in_groupGraphPatternSubCache2793 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000000L,0x0000000010000000L});
	public static final BitSet FOLLOW_triplesBlock_in_groupGraphPatternSubCache2795 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_TRIPLES_BLOCK_in_triplesBlock2814 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_triplesSameSubjectPath_in_triplesBlock2816 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_groupOrUnionGraphPattern_in_graphPatternNotTriples2836 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_optionalGraphPattern_in_graphPatternNotTriples2840 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_minusGraphPattern_in_graphPatternNotTriples2844 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_graphGraphPattern_in_graphPatternNotTriples2848 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_serviceGraphPattern_in_graphPatternNotTriples2852 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_filter_in_graphPatternNotTriples2856 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_bind_in_graphPatternNotTriples2860 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OPTIONAL_in_optionalGraphPattern2878 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_groupGraphPattern_in_optionalGraphPattern2880 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_GRAPH_in_graphGraphPattern2899 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_varOrIRIref_in_graphGraphPattern2901 = new BitSet(new long[]{0x0000000000000000L,0x0000000004000000L});
	public static final BitSet FOLLOW_groupGraphPattern_in_graphGraphPattern2903 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_SERVICE_in_serviceGraphPattern2922 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_SILENT_in_serviceGraphPattern2924 = new BitSet(new long[]{0x0000000000000000L,0x0000008000000000L,0x00000000C0000000L,0x0000080000000000L});
	public static final BitSet FOLLOW_varOrIRIref_in_serviceGraphPattern2927 = new BitSet(new long[]{0x0000000000000000L,0x0000000004000000L});
	public static final BitSet FOLLOW_groupGraphPattern_in_serviceGraphPattern2929 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_BIND_in_bind2948 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_bind2950 = new BitSet(new long[]{0x0000000000002000L});
	public static final BitSet FOLLOW_AS_in_bind2953 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_var_in_bind2955 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_MINUS_KEYWORD_in_minusGraphPattern2975 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_groupGraphPattern_in_minusGraphPattern2977 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_UNION_in_groupOrUnionGraphPattern2996 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_groupGraphPattern_in_groupOrUnionGraphPattern2998 = new BitSet(new long[]{0x0000000000000000L,0x0000000004000000L});
	public static final BitSet FOLLOW_groupGraphPattern_in_groupOrUnionGraphPattern3000 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_groupGraphPattern_in_groupOrUnionGraphPattern3009 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_FILTER_in_filter3027 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_constraint_in_filter3029 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_expression_in_constraint3047 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_builtInCall_in_constraint3055 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_functionCall_in_constraint3063 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_FUNCTION_in_functionCall3085 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_iriRef_in_functionCall3089 = new BitSet(new long[]{0x0000000000001000L});
	public static final BitSet FOLLOW_ARG_LIST_in_functionCall3092 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_argList_in_functionCall3096 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_nil_in_argList3131 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DISTINCT_in_argList3139 = new BitSet(new long[]{0x2000000000010402L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_expression_in_argList3145 = new BitSet(new long[]{0x2000000000010402L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_EXPRESSION_LIST_in_expressionList3180 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_expressionList3185 = new BitSet(new long[]{0x2000000000010408L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_EXPRESSION_LIST_in_expressionList3199 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_nil_in_expressionList3201 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_CONSTRUCT_QUADS_in_constructTemplateQuads3227 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_quadPattern_in_constructTemplateQuads3231 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_CONSTRUCT_TRIPLES_in_constructTemplate3261 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_constructTriples_in_constructTemplate3265 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_triples_in_constructTriples3292 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_triple_in_triples3326 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_TRIPLE_in_triple3347 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_SUBJECT_in_triple3350 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_varOrTerm_in_triple3354 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_PREDICATE_in_triple3358 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_verb_in_triple3362 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_OBJECT_in_triple3366 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_graphNode_in_triple3370 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_TODO_in_triplesSameSubject3395 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SUBJECT_in_objectList3419 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_varOrTerm_in_objectList3423 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_PREDICATE_in_objectList3427 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_verb_in_objectList3431 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_OBJECT_in_objectList3435 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_graphNode_in_objectList3439 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_varOrIRIref_in_verb3473 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_A_in_verb3483 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_path_in_verb3503 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_TRIPLE_in_triplesSameSubjectPath3528 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_objectList_in_triplesSameSubjectPath3530 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_TRIPLE_in_triplesSameSubjectPath3541 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_triplesSameSubjectPath_in_triplesSameSubjectPath3543 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_PATH_in_path3562 = new BitSet(new long[]{0x0000000000000000L,0x0000002000000000L,0x0000000004000000L});
	public static final BitSet FOLLOW_pathSequence_in_path3564 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_PIPE_in_path3568 = new BitSet(new long[]{0x0000000000000000L,0x0000002000000000L,0x0000000004000000L});
	public static final BitSet FOLLOW_pathSequence_in_path3570 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_pathEltOrInverse_in_pathSequence3590 = new BitSet(new long[]{0x2000000000000002L});
	public static final BitSet FOLLOW_DIVIDE_in_pathSequence3594 = new BitSet(new long[]{0x0000000000000000L,0x0000002000000000L,0x0000000004000000L});
	public static final BitSet FOLLOW_pathEltOrInverse_in_pathSequence3596 = new BitSet(new long[]{0x2000000000000002L});
	public static final BitSet FOLLOW_pathPrimary_in_pathElt3616 = new BitSet(new long[]{0x0000000000010002L,0x0000000000000000L,0x0000100020008000L});
	public static final BitSet FOLLOW_pathMod_in_pathElt3618 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_pathElt_in_pathEltOrInverse3636 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_INVERSE_in_pathEltOrInverse3640 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000004000000L});
	public static final BitSet FOLLOW_pathElt_in_pathEltOrInverse3642 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ASTERISK_in_pathMod3661 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QUESTION_MARK_in_pathMod3665 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_PLUS_in_pathMod3669 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OPEN_CURLY_BRACE_in_pathMod3673 = new BitSet(new long[]{0x0000000400000000L,0x0000000200000000L});
	public static final BitSet FOLLOW_INTEGER_in_pathMod3677 = new BitSet(new long[]{0x0000000440000000L});
	public static final BitSet FOLLOW_COMMA_in_pathMod3681 = new BitSet(new long[]{0x0000000040000000L,0x0000000200000000L});
	public static final BitSet FOLLOW_CLOSE_CURLY_BRACE_in_pathMod3685 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_INTEGER_in_pathMod3689 = new BitSet(new long[]{0x0000000040000000L});
	public static final BitSet FOLLOW_CLOSE_CURLY_BRACE_in_pathMod3691 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CLOSE_CURLY_BRACE_in_pathMod3697 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_COMMA_in_pathMod3703 = new BitSet(new long[]{0x0000000000000000L,0x0000000200000000L});
	public static final BitSet FOLLOW_INTEGER_in_pathMod3705 = new BitSet(new long[]{0x0000000040000000L});
	public static final BitSet FOLLOW_CLOSE_CURLY_BRACE_in_pathMod3707 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_PATH_PRIMARY_in_pathPrimary3729 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_iriRef_in_pathPrimary3731 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_PATH_PRIMARY_in_pathPrimary3741 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_A_in_pathPrimary3743 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_PATH_PRIMARY_in_pathPrimary3753 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_NEGATION_in_pathPrimary3755 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000002000000L});
	public static final BitSet FOLLOW_pathNegatedPropertySet_in_pathPrimary3757 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_PATH_PRIMARY_in_pathPrimary3767 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_path_in_pathPrimary3769 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_PATH_NEGATED_in_pathNegatedPropertySet3788 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_pathOneInPropertySet_in_pathNegatedPropertySet3790 = new BitSet(new long[]{0x0000000000000018L,0x000000A000000000L,0x00000000C0000000L});
	public static final BitSet FOLLOW_INVERSE_in_pathOneInPropertySet3809 = new BitSet(new long[]{0x0000000000000010L,0x0000008000000000L,0x00000000C0000000L});
	public static final BitSet FOLLOW_iriRef_in_pathOneInPropertySet3814 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_A_in_pathOneInPropertySet3818 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_COLLECTION_in_triplesNode3843 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_graphNode_in_triplesNode3845 = new BitSet(new long[]{0x801C000200800008L,0x0000008E00000403L,0x00000000D0014000L,0x00000800C8000000L});
	public static final BitSet FOLLOW_TRIPLE_in_triplesNode3857 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_objectList_in_triplesNode3859 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_varOrTerm_in_graphNode3887 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_triplesNode_in_graphNode3897 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_var_in_varOrTerm3921 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_graphTerm_in_varOrTerm3939 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_var_in_varOrIRIref3964 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_iriRef_in_varOrIRIref3979 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_VAR_in_var4004 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_iriRef_in_graphTerm4029 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_rdfLiteral_in_graphTerm4049 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_numericLiteral_in_graphTerm4067 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_booleanLiteral_in_graphTerm4079 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_blankNode_in_graphTerm4091 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_nil_in_graphTerm4106 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_nil4123 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_nil4125 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OR_in_expression4147 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_expression4151 = new BitSet(new long[]{0x2000000000010400L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_expression_in_expression4155 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_AND_in_expression4178 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_expression4182 = new BitSet(new long[]{0x2000000000010400L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_expression_in_expression4186 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_EQUAL_in_expression4208 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_expression4212 = new BitSet(new long[]{0x2000000000010400L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_expression_in_expression4216 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_NOT_EQUAL_in_expression4236 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_expression4240 = new BitSet(new long[]{0x2000000000010400L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_expression_in_expression4244 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_LESS_in_expression4260 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_expression4264 = new BitSet(new long[]{0x2000000000010400L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_expression_in_expression4268 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_GREATER_in_expression4289 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_expression4293 = new BitSet(new long[]{0x2000000000010400L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_expression_in_expression4297 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_LESS_EQUAL_in_expression4315 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_expression4319 = new BitSet(new long[]{0x2000000000010400L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_expression_in_expression4323 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_GREATER_EQUAL_in_expression4338 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_expression4342 = new BitSet(new long[]{0x2000000000010400L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_expression_in_expression4346 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_IN_in_expression4358 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_expression4362 = new BitSet(new long[]{0x2000000000010400L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_expression_in_expression4366 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_NOT_in_expression4389 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_IN_in_expression4391 = new BitSet(new long[]{0x2000000000010400L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_expression_in_expression4395 = new BitSet(new long[]{0x2000000000010400L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_expression_in_expression4399 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_PLUS_in_expression4418 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_expression4422 = new BitSet(new long[]{0x2000000000010400L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_expression_in_expression4426 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_MINUS_in_expression4447 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_expression4451 = new BitSet(new long[]{0x2000000000010400L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_expression_in_expression4455 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_ASTERISK_in_expression4475 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_expression4479 = new BitSet(new long[]{0x2000000000010400L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_expression_in_expression4483 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_DIVIDE_in_expression4500 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_expression4504 = new BitSet(new long[]{0x2000000000010400L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_expression_in_expression4508 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_unaryExpression_in_expression4528 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_UNARY_NOT_in_unaryExpression4577 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_primaryExpression_in_unaryExpression4581 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_UNARY_PLUS_in_unaryExpression4601 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_primaryExpression_in_unaryExpression4605 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_UNARY_MINUS_in_unaryExpression4624 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_primaryExpression_in_unaryExpression4628 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_UNARY_in_unaryExpression4646 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_primaryExpression_in_unaryExpression4650 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_builtInCall_in_primaryExpression4688 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_iriRefOrFunction_in_primaryExpression4706 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_expression_in_primaryExpression4719 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_rdfLiteral_in_primaryExpression4739 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_numericLiteral_in_primaryExpression4758 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_booleanLiteral_in_primaryExpression4773 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_var_in_primaryExpression4788 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_aggregate_in_primaryExpression4812 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STR_in_builtInCall4834 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall4838 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_LANG_in_builtInCall4862 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall4866 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_LANGMATCHES_in_builtInCall4889 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall4893 = new BitSet(new long[]{0x2000000000010400L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_expression_in_builtInCall4897 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_DATATYPE_in_builtInCall4912 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall4916 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_BOUND_in_builtInCall4926 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_var_in_builtInCall4930 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_IRI_in_builtInCall4959 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall4963 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_URI_in_builtInCall4973 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall4977 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_BNODE_in_builtInCall4987 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall4989 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_RAND_in_builtInCall4998 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ABS_in_builtInCall5007 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5011 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_CEIL_in_builtInCall5021 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5025 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_FLOOR_in_builtInCall5035 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5039 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_ROUND_in_builtInCall5049 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5051 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_CONCAT_in_builtInCall5061 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expressionList_in_builtInCall5065 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_subStringExpression_in_builtInCall5081 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRLEN_in_builtInCall5090 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5092 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_UCASE_in_builtInCall5102 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5104 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_LCASE_in_builtInCall5114 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5116 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_ENCODE_FOR_URI_in_builtInCall5126 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5128 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_CONTAINS_in_builtInCall5138 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5140 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_STRSTARTS_in_builtInCall5150 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5152 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_STRENDS_in_builtInCall5162 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5164 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_YEAR_in_builtInCall5174 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5176 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_MONTH_in_builtInCall5186 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5188 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_DAY_in_builtInCall5198 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5200 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_HOURS_in_builtInCall5210 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5212 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_MINUTES_in_builtInCall5222 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5224 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_SECONDS_in_builtInCall5234 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5236 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_TIMEZONE_in_builtInCall5246 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5248 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_TZ_in_builtInCall5258 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5260 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_NOW_in_builtInCall5269 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_MD5_in_builtInCall5278 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5280 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_SHA1_in_builtInCall5290 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5292 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_SHA224_in_builtInCall5302 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5304 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_SHA256_in_builtInCall5314 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5316 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_SHA384_in_builtInCall5326 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5328 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_SHA512_in_builtInCall5338 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5340 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_COALESCE_in_builtInCall5350 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expressionList_in_builtInCall5352 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_IF_in_builtInCall5362 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5364 = new BitSet(new long[]{0x2000000000010400L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_expression_in_builtInCall5366 = new BitSet(new long[]{0x2000000000010400L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_expression_in_builtInCall5368 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_STRLANG_in_builtInCall5378 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5380 = new BitSet(new long[]{0x2000000000010400L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_expression_in_builtInCall5382 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_STRDT_in_builtInCall5392 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5394 = new BitSet(new long[]{0x2000000000010400L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_expression_in_builtInCall5396 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_SAMETERM_in_builtInCall5406 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5408 = new BitSet(new long[]{0x2000000000010400L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_expression_in_builtInCall5410 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_ISIRI_in_builtInCall5420 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5422 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_ISURI_in_builtInCall5432 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5434 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_ISBLANK_in_builtInCall5444 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5446 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_ISLITERAL_in_builtInCall5456 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5458 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_ISNUMERIC_in_builtInCall5468 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_builtInCall5470 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_regexExpression_in_builtInCall5479 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_existsFunction_in_builtInCall5487 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_notExistsFunction_in_builtInCall5495 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_REGEX_in_regexExpression5513 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_regexExpression5515 = new BitSet(new long[]{0x2000000000010408L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_SUBSTR_in_subStringExpression5535 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_expression_in_subStringExpression5537 = new BitSet(new long[]{0x2000000000010408L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_EXISTS_in_existsFunction5557 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_groupGraphPattern_in_existsFunction5559 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_NOT_EXISTS_in_notExistsFunction5578 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_groupGraphPattern_in_notExistsFunction5580 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_COUNT_in_aggregate5599 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_DISTINCT_in_aggregate5601 = new BitSet(new long[]{0x3000000000010408L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_ASTERISK_in_aggregate5604 = new BitSet(new long[]{0x2000000000010408L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_expression_in_aggregate5607 = new BitSet(new long[]{0x2000000000010408L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_SUM_in_aggregate5618 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_DISTINCT_in_aggregate5620 = new BitSet(new long[]{0x3000000000010400L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_expression_in_aggregate5623 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_MIN_in_aggregate5633 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_DISTINCT_in_aggregate5635 = new BitSet(new long[]{0x3000000000010400L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_expression_in_aggregate5638 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_MAX_in_aggregate5648 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_DISTINCT_in_aggregate5650 = new BitSet(new long[]{0x3000000000010400L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_expression_in_aggregate5653 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_AVG_in_aggregate5663 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_DISTINCT_in_aggregate5665 = new BitSet(new long[]{0x3000000000010400L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_expression_in_aggregate5668 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_SAMPLE_in_aggregate5678 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_DISTINCT_in_aggregate5680 = new BitSet(new long[]{0x2000000000010400L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_expression_in_aggregate5683 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_GROUP_CONCAT_in_aggregate5693 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_DISTINCT_in_aggregate5695 = new BitSet(new long[]{0x3000000000010400L,0x1030000080600040L,0x0000000020040300L,0x0000003C00000000L});
	public static final BitSet FOLLOW_expression_in_aggregate5698 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0000000000000000L,0x000000000000F000L});
	public static final BitSet FOLLOW_string_in_aggregate5700 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_iriRef_in_iriRefOrFunction5725 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_FUNCTION_in_iriRefOrFunction5770 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_iriRef_in_iriRefOrFunction5774 = new BitSet(new long[]{0x0000000000001000L});
	public static final BitSet FOLLOW_ARG_LIST_in_iriRefOrFunction5777 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_argList_in_iriRefOrFunction5781 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_PLAIN_LITERAL_in_rdfLiteral5807 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_string_in_rdfLiteral5811 = new BitSet(new long[]{0x0000000000000008L,0x0002000000000000L});
	public static final BitSet FOLLOW_LANGTAG_in_rdfLiteral5815 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_TYPED_LITERAL_in_rdfLiteral5828 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_string_in_rdfLiteral5832 = new BitSet(new long[]{0x0000000000000000L,0x0000008000000000L,0x00000000C0000000L});
	public static final BitSet FOLLOW_iriRef_in_rdfLiteral5836 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_numericLiteralUnsigned_in_numericLiteral5868 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_numericLiteralPositive_in_numericLiteral5880 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_numericLiteralNegative_in_numericLiteral5892 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_INTEGER_in_numericLiteralUnsigned5917 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DECIMAL_in_numericLiteralUnsigned5929 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DOUBLE_in_numericLiteralUnsigned5941 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_INTEGER_POSITIVE_in_numericLiteralPositive5967 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DECIMAL_POSITIVE_in_numericLiteralPositive5979 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DOUBLE_POSITIVE_in_numericLiteralPositive5991 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_INTEGER_NEGATIVE_in_numericLiteralNegative6017 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DECIMAL_NEGATIVE_in_numericLiteralNegative6029 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DOUBLE_NEGATIVE_in_numericLiteralNegative6041 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_TRUE_in_booleanLiteral6065 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_FALSE_in_booleanLiteral6076 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRING_LITERAL1_in_string6101 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRING_LITERAL2_in_string6118 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRING_LITERAL_LONG1_in_string6135 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRING_LITERAL_LONG2_in_string6147 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IRI_REF_in_iriRef6172 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_prefixedName_in_iriRef6189 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_PNAME_LN_in_prefixedName6214 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_PNAME_NS_in_prefixedName6227 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_BLANK_NODE_LABEL_in_blankNode6253 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_anon_in_blankNode6263 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OPEN_SQUARE_BRACKET_in_anon6282 = new BitSet(new long[]{0x0000000080000000L});
	public static final BitSet FOLLOW_CLOSE_SQUARE_BRACKET_in_anon6284 = new BitSet(new long[]{0x0000000000000002L});
}
