/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.csv;

import au.com.bytecode.opencsv.CSVReader;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import org.aksw.sparqlify.csv.CsvParserConfig;

public class InputSupplierCSVReader
implements InputSupplier<CSVReader> {
    private CsvParserConfig config;
    private InputSupplier<? extends Reader> readerSupplier;

    public InputSupplierCSVReader(File file, CsvParserConfig config) {
        this((InputSupplier<? extends Reader>)Files.newReaderSupplier((File)file, (Charset)Charset.defaultCharset()), config);
    }

    public InputSupplierCSVReader(InputSupplier<? extends Reader> readerSupplier, CsvParserConfig config) {
        this.readerSupplier = readerSupplier;
        this.config = config;
    }

    public CSVReader getInput() throws IOException {
        char fieldSep = this.config.getFieldSeparator() == null ? (char)',' : (char)this.config.getFieldSeparator().charValue();
        char quoteChar = this.config.getFieldDelimiter() == null ? (char)'\"' : (char)this.config.getFieldDelimiter().charValue();
        char escapeChar = this.config.getEscapeCharacter() == null ? (char)'\\' : (char)this.config.getEscapeCharacter().charValue();
        Reader reader = (Reader)this.readerSupplier.getInput();
        CSVReader result = new CSVReader(reader, fieldSep, quoteChar, escapeChar, 0, false);
        return result;
    }
}

