/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.jena.functions;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.function.FunctionBase4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RdfTerm
extends FunctionBase4 {
    private static final Logger logger = LoggerFactory.getLogger(RdfTerm.class);

    public static String toLexicalForm(NodeValue nodeValue) {
        return nodeValue.asUnquotedString();
    }

    public NodeValue exec(NodeValue type, NodeValue node, NodeValue langTag, NodeValue datatype) {
        return RdfTerm.eval(type, node, langTag, datatype);
    }

    public static NodeValue eval(NodeValue type, NodeValue node, NodeValue langTag, NodeValue datatype) {
        String lexicalForm = RdfTerm.toLexicalForm(node);
        int typeValue = type.getDecimal().intValue();
        switch (typeValue) {
            case 0: {
                NodeValue result = NodeValue.makeNode((Node)Node.createAnon((AnonId)new AnonId(RdfTerm.toLexicalForm(node))));
                return result;
            }
            case 1: {
                return NodeValue.makeNode((Node)Node.createURI((String)RdfTerm.toLexicalForm(node)));
            }
            case 2: {
                String dt = RdfTerm.toLexicalForm(datatype);
                if (dt != null && !dt.isEmpty()) {
                    logger.warn("Language tag should be null or empty, was '" + dt + "'");
                }
                return NodeValue.makeNode((String)lexicalForm, (String)RdfTerm.toLexicalForm(langTag), (String)null);
            }
            case 3: {
                String lang = RdfTerm.toLexicalForm(langTag);
                if (lang != null && !lang.isEmpty()) {
                    logger.warn("Language tag should be null or empty, was '" + lang + "'");
                }
                return NodeValue.makeNode((String)lexicalForm, null, (String)RdfTerm.toLexicalForm(datatype));
            }
        }
        throw new RuntimeException("Invalid type-value for RdfTerm: " + typeValue);
    }
}

