/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.datatypes;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.aksw.sparqlify.algebra.sql.exprs.evaluators.SqlFunctionSerializer;
import org.aksw.sparqlify.algebra.sql.exprs.evaluators.SqlFunctionSerializerDefault;
import org.aksw.sparqlify.core.TypeToken;
import org.aksw.sparqlify.core.datatypes.Invocable;
import org.aksw.sparqlify.core.datatypes.InvocableMethod;
import org.aksw.sparqlify.core.datatypes.TypeSystem;
import org.aksw.sparqlify.core.datatypes.XClass;
import org.aksw.sparqlify.core.datatypes.XMethod;
import org.aksw.sparqlify.type_system.MethodSignature;

public class XMethodImpl
implements XMethod {
    private String name;
    private MethodSignature<XClass> signature;
    private Invocable invocable;
    private SqlFunctionSerializer serializer;

    public XMethodImpl(String name, MethodSignature<XClass> signature, Invocable invocable) {
        this(name, signature, invocable, new SqlFunctionSerializerDefault(name));
    }

    public XMethodImpl(String name, MethodSignature<XClass> signature, Invocable invocable, SqlFunctionSerializer serializer) {
        this.name = name;
        this.signature = signature;
        this.invocable = invocable;
        this.serializer = serializer;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public MethodSignature<XClass> getSignature() {
        return this.signature;
    }

    @Override
    public Invocable getInvocable() {
        return this.invocable;
    }

    @Override
    public SqlFunctionSerializer getSerializer() {
        return this.serializer;
    }

    public String toString() {
        return "XMethodImpl [name=" + this.name + ", signature=" + this.signature + ", invocable=" + this.invocable + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.invocable == null ? 0 : this.invocable.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.signature == null ? 0 : this.signature.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XMethodImpl other = (XMethodImpl)obj;
        if (this.invocable == null ? other.invocable != null : !this.invocable.equals(other.invocable)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.signature == null ? other.signature != null : !this.signature.equals(other.signature));
    }

    public static List<XClass> resolveList(TypeSystem datatypeSystem, Class<?>[] classes) {
        ArrayList<XClass> result = new ArrayList<XClass>(classes.length);
        for (Class<?> clazz : classes) {
            XClass tmp = XMethodImpl.resolveClass(clazz, datatypeSystem);
            result.add(tmp);
        }
        return result;
    }

    public static XClass resolveClass(Class<?> clazz, TypeSystem datatypeSystem) {
        XClass result = datatypeSystem.getByClass(clazz);
        if (result == null) {
            throw new RuntimeException("No appropriate XClass for " + clazz);
        }
        return result;
    }

    public static XClass resolveClass(TypeToken typeName, TypeSystem datatypeSystem) {
        XClass result = datatypeSystem.getByName(typeName);
        if (result == null) {
            throw new RuntimeException("No appropriate XClass for " + typeName);
        }
        return result;
    }

    public static List<XClass> resolveList(TypeSystem datatypeSystem, List<TypeToken> typeNames) {
        ArrayList<XClass> result = new ArrayList<XClass>(typeNames.size());
        for (TypeToken typeName : typeNames) {
            XClass tmp = XMethodImpl.resolveClass(typeName, datatypeSystem);
            result.add(tmp);
        }
        return result;
    }

    public static XMethod create(TypeSystem datatypeSystem, String name, MethodSignature<TypeToken> signature) {
        XClass returnType = XMethodImpl.resolveClass((TypeToken)signature.getReturnType(), datatypeSystem);
        List<XClass> argTypes = XMethodImpl.resolveList(datatypeSystem, signature.getParameterTypes());
        MethodSignature resolvedSignature = new MethodSignature((Object)returnType, argTypes, null);
        Invocable invocable = null;
        XMethodImpl result = new XMethodImpl(name, (MethodSignature<XClass>)resolvedSignature, invocable);
        return result;
    }

    public static XMethod createFromMethod(String name, TypeSystem datatypeSystem, Object object, Method method) {
        XClass returnType = XMethodImpl.resolveClass(method.getReturnType(), datatypeSystem);
        List<XClass> argTypes = XMethodImpl.resolveList(datatypeSystem, method.getParameterTypes());
        MethodSignature resolvedSignature = new MethodSignature((Object)returnType, argTypes, null);
        InvocableMethod invocable = new InvocableMethod(object, method);
        XMethodImpl result = new XMethodImpl(name, (MethodSignature<XClass>)resolvedSignature, invocable);
        return result;
    }
}

