/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.cast;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import org.aksw.commons.util.reflect.Caster;
import org.aksw.sparqlify.core.cast.CastException;
import org.aksw.sparqlify.core.cast.NodeValueTransformer;
import org.aksw.sparqlify.expr.util.NodeValueUtils;

class CoercionWrapper
implements NodeValueTransformer {
    private TypeMapper typeMapper;
    private String targetTypeName;

    public CoercionWrapper(TypeMapper typeMapper, String targetTypeName) {
        this.typeMapper = typeMapper;
        this.targetTypeName = targetTypeName;
    }

    public static CoercionWrapper create(TypeMapper typeMapper, String targetTypeName) {
        CoercionWrapper result = new CoercionWrapper(typeMapper, targetTypeName);
        return result;
    }

    @Override
    public NodeValue transform(NodeValue nodeValue) throws CastException {
        NodeValue result = CoercionWrapper.cast(this.typeMapper, nodeValue, this.targetTypeName);
        return result;
    }

    public static NodeValue cast(TypeMapper typeMapper, NodeValue source, String targetTypeName) throws CastException {
        RDFDatatype targetType = typeMapper.getTypeByName(targetTypeName);
        if (targetType == null) {
            throw new CastException();
        }
        Class targetClass = targetType.getJavaClass();
        if (targetClass == null) {
            throw new CastException();
        }
        Object value = NodeValueUtils.getValue(source);
        Object targetValue = Caster.tryCast((Object)value, (Class)targetClass);
        String targetForm = targetType.unparse(targetValue);
        Node node = Node.createLiteral((String)targetForm, (RDFDatatype)targetType);
        NodeValue result = NodeValue.makeNode((Node)node);
        return result;
    }
}

