/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.cast;

import java.util.HashMap;
import java.util.Map;
import org.aksw.sparqlify.core.TypeToken;
import org.aksw.sparqlify.core.cast.CoercionSystem;
import org.aksw.sparqlify.core.cast.NodeValueTransformer;
import org.aksw.sparqlify.core.cast.TypeSystem;

public class CoercionSystemImpl2
implements CoercionSystem<TypeToken, NodeValueTransformer> {
    private TypeSystem typeSystem;
    private Map<TypeToken, Map<TypeToken, NodeValueTransformer>> sourceToTargetToTransform = new HashMap<TypeToken, Map<TypeToken, NodeValueTransformer>>();

    public CoercionSystemImpl2(TypeSystem typeSystem) {
        this.typeSystem = typeSystem;
    }

    @Override
    public NodeValueTransformer lookup(TypeToken sourceTypeName, TypeToken targetTypeName) {
        Map<TypeToken, NodeValueTransformer> targetToDecl = this.sourceToTargetToTransform.get(sourceTypeName);
        if (targetToDecl == null) {
            return null;
        }
        NodeValueTransformer result = targetToDecl.get(targetTypeName);
        return result;
    }

    public void registerCoercion(TypeToken sourceTypeName, TypeToken targetTypeName, NodeValueTransformer transformer) {
        if (this.typeSystem.isSuperClassOf(targetTypeName, sourceTypeName)) {
            throw new RuntimeException("The return type must not be a subtype of the argument.");
        }
        Map<TypeToken, NodeValueTransformer> targetToDecl = this.sourceToTargetToTransform.get(sourceTypeName);
        NodeValueTransformer priorDecl = null;
        if (targetToDecl == null) {
            targetToDecl = new HashMap<TypeToken, NodeValueTransformer>();
            this.sourceToTargetToTransform.put(sourceTypeName, targetToDecl);
        } else {
            priorDecl = targetToDecl.get(targetTypeName);
        }
        if (priorDecl != null) {
            throw new RuntimeException("Coercion " + transformer + " from " + sourceTypeName + " to " + targetTypeName + " already defined with " + priorDecl);
        }
        targetToDecl.put(targetTypeName, transformer);
    }
}

