/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.algorithms;

import com.hp.hpl.jena.sparql.expr.E_Cast;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import java.util.ArrayList;
import java.util.List;
import org.aksw.commons.util.reflect.MultiMethod;
import org.aksw.sparqlify.algebra.sql.exprs2.S_Agg;
import org.aksw.sparqlify.algebra.sql.exprs2.S_ColumnRef;
import org.aksw.sparqlify.algebra.sql.exprs2.S_Constant;
import org.aksw.sparqlify.algebra.sql.exprs2.S_Serialize;
import org.aksw.sparqlify.algebra.sql.exprs2.SqlExpr;
import org.aksw.sparqlify.core.TypeToken;
import org.aksw.sparqlify.core.algorithms.DatatypeToString;
import org.aksw.sparqlify.core.interfaces.SqlExprSerializer;

public abstract class SqlExprSerializerDefault
implements SqlExprSerializer {
    protected DatatypeToString datatypeSerializer;

    public SqlExprSerializerDefault(DatatypeToString datatypeSerializer) {
        this.datatypeSerializer = datatypeSerializer;
    }

    public String _serialize(NodeValue nodeValue) {
        if (nodeValue.equals((Object)NodeValue.nvNothing)) {
            return "NULL ";
        }
        String result = nodeValue.asUnquotedString();
        return result;
    }

    @Override
    public String serialize(SqlExpr expr) {
        try {
            String result = (String)MultiMethod.invoke((Object)this, (String)"_serialize", (Object[])new Object[]{expr});
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("Error serializing expression" + expr, e);
        }
    }

    public String _serialize(S_Agg expr) {
        System.err.println("Hack used for serializing aggregators.");
        String result = expr.getAggregator().toString();
        return result;
    }

    public String _serialize(S_Serialize expr) {
        List<String> argStrs = this.serializeArgs(expr.getArgs());
        String result = expr.getSerializer().serialize(argStrs);
        return result;
    }

    public List<String> serializeArgs(List<SqlExpr> exprs) {
        ArrayList<String> result = new ArrayList<String>();
        for (SqlExpr expr : exprs) {
            String tmp = this.serialize(expr);
            result.add(tmp);
        }
        return result;
    }

    public String _serialize(E_Cast expr) {
        throw new RuntimeException("fix this");
    }

    public String _serialize(S_Constant expr) {
        return this.serializeConstant(expr.getValue(), expr.getDatatype());
    }

    public abstract String serializeConstant(Object var1, TypeToken var2);

    public String _serialize(S_ColumnRef expr) {
        String result = expr.getRelationAlias() == null ? "\"" + expr.getColumnName() + "\"" : expr.getRelationAlias() + ".\"" + expr.getColumnName() + "\"";
        return result;
    }
}

