/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.algorithms;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.SortCondition;
import com.hp.hpl.jena.sdb.core.Generator;
import com.hp.hpl.jena.sdb.core.Gensym;
import com.hp.hpl.jena.sdb.core.JoinType;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.core.VarExprList;
import com.hp.hpl.jena.sparql.expr.E_Function;
import com.hp.hpl.jena.sparql.expr.E_LogicalNot;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprAggregator;
import com.hp.hpl.jena.sparql.expr.ExprFunction;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.expr.ExprVar;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.aggregate.AggCount;
import com.hp.hpl.jena.sparql.expr.aggregate.Aggregator;
import com.hp.hpl.jena.vocabulary.XSD;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.commons.collections.CartesianProduct;
import org.aksw.sparqlify.algebra.sparql.expr.E_RdfTerm;
import org.aksw.sparqlify.algebra.sparql.transform.NodeExprSubstitutor;
import org.aksw.sparqlify.algebra.sql.exprs.SqlExprAggregator;
import org.aksw.sparqlify.algebra.sql.exprs2.S_Agg;
import org.aksw.sparqlify.algebra.sql.exprs2.S_AggCount;
import org.aksw.sparqlify.algebra.sql.exprs2.S_Case;
import org.aksw.sparqlify.algebra.sql.exprs2.S_Coalesce;
import org.aksw.sparqlify.algebra.sql.exprs2.S_ColumnRef;
import org.aksw.sparqlify.algebra.sql.exprs2.S_Constant;
import org.aksw.sparqlify.algebra.sql.exprs2.S_IsNotNull;
import org.aksw.sparqlify.algebra.sql.exprs2.S_When;
import org.aksw.sparqlify.algebra.sql.exprs2.SqlExpr;
import org.aksw.sparqlify.algebra.sql.nodes.Projection;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOp;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOpBase;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOpDistinct;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOpEmpty;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOpExtend;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOpFilter;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOpGroupBy;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOpJoin;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOpOrder;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOpProject;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOpRename;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOpSlice;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOpUnionN;
import org.aksw.sparqlify.algebra.sql.nodes.SqlSortCondition;
import org.aksw.sparqlify.core.ArgExpr;
import org.aksw.sparqlify.core.TypeToken;
import org.aksw.sparqlify.core.algorithms.AggCandidate;
import org.aksw.sparqlify.core.algorithms.ExprDatatypeNorm;
import org.aksw.sparqlify.core.algorithms.ExprSqlRewrite;
import org.aksw.sparqlify.core.algorithms.GeneratorBlacklist;
import org.aksw.sparqlify.core.algorithms.MappingRefactor;
import org.aksw.sparqlify.core.algorithms.SqlExprContext;
import org.aksw.sparqlify.core.algorithms.SqlExprUtils;
import org.aksw.sparqlify.core.algorithms.VarDefKey;
import org.aksw.sparqlify.core.algorithms.VariableDefinitionOps;
import org.aksw.sparqlify.core.algorithms.ViewInstance;
import org.aksw.sparqlify.core.cast.SqlValue;
import org.aksw.sparqlify.core.cast.TypeSystem;
import org.aksw.sparqlify.core.cast.TypedExprTransformerImpl;
import org.aksw.sparqlify.core.domain.input.Mapping;
import org.aksw.sparqlify.core.domain.input.MappingUnion;
import org.aksw.sparqlify.core.domain.input.RestrictedExpr;
import org.aksw.sparqlify.core.domain.input.VarDefinition;
import org.aksw.sparqlify.core.domain.input.ViewDefinition;
import org.aksw.sparqlify.core.interfaces.MappingOps;
import org.aksw.sparqlify.core.interfaces.SqlTranslator;
import org.aksw.sparqlify.core.transformations.SqlTranslationUtils;
import org.aksw.sparqlify.expr.util.ExprUtils;
import org.aksw.sparqlify.expr.util.NodeValueUtils;
import org.aksw.sparqlify.restriction.RestrictionSetImpl;
import org.aksw.sparqlify.trash.ExprCommonFactor;
import org.aksw.sparqlify.trash.ExprCopy;
import org.aksw.sparqlify.type_system.CandidateMethod;
import org.aksw.sparqlify.type_system.FunctionModel;
import org.aksw.sparqlify.type_system.MethodEntry;
import org.aksw.sparqlify.type_system.TypeSystemUtils;
import org.aksw.sparqlify.util.SqlTranslatorImpl2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappingOpsImpl
implements MappingOps {
    private static final Logger logger = LoggerFactory.getLogger(MappingOpsImpl.class);
    private SqlTranslator sqlTranslator;
    private ExprDatatypeNorm exprNormalizer;
    static Generator genSymJoin = Gensym.create((String)"h");

    public MappingOpsImpl(SqlTranslator sqlTranslator, ExprDatatypeNorm exprNormalizer) {
        this.sqlTranslator = sqlTranslator;
        this.exprNormalizer = exprNormalizer;
    }

    public SqlTranslator getSqlTranslator() {
        return this.sqlTranslator;
    }

    public ExprDatatypeNorm exprNormalizer() {
        return this.exprNormalizer;
    }

    @Override
    public Mapping rename(Mapping a, Map<String, String> rename) {
        if (rename.isEmpty()) {
            return a;
        }
        VarDefinition renamedVarDef = VarDefinition.copyRename(a.getVarDefinition(), rename);
        SqlOpRename sqlOpRename = SqlOpRename.create(a.getSqlOp(), rename);
        Mapping result = new Mapping(renamedVarDef, sqlOpRename);
        return result;
    }

    public static SqlExpr translateSql(RestrictedExpr restExpr, Map<String, TypeToken> typeMap, SqlTranslator sqlTranslator) {
        if (restExpr.getRestrictions().isUnsatisfiable()) {
            return S_Constant.FALSE;
        }
        Expr expr = restExpr.getExpr();
        SqlExpr result = MappingOpsImpl.translateSql(expr, typeMap, sqlTranslator);
        return result;
    }

    public static SqlExpr translateSql(Expr expr, Map<String, TypeToken> typeMap, SqlTranslator sqlTranslator) {
        ExprSqlRewrite exprRewrite = sqlTranslator.translate(expr, null, typeMap);
        SqlExpr result = SqlTranslatorImpl2.asSqlExpr(exprRewrite);
        return result;
    }

    public static List<SqlExprContext> createExprSqlRewrites(Expr condition, VarDefinition varDef, Map<String, TypeToken> typeMap, SqlTranslator sqlTranslator) {
        Set conditionVars;
        ArrayList<SqlExprContext> result = new ArrayList<SqlExprContext>();
        Set cVars = conditionVars = condition.getVarsMentioned();
        cVars.retainAll(varDef.getMap().keySet());
        ArrayList commonVars = new ArrayList(cVars);
        if (commonVars.isEmpty()) {
            ExprSqlRewrite exprRewrite = sqlTranslator.translate(condition, null, typeMap);
            HashMap<Var, Expr> assignment = new HashMap<Var, Expr>();
            SqlExprContext tmp = new SqlExprContext(assignment, exprRewrite);
            result.add(tmp);
            return result;
        }
        final Map map = varDef.getMap().asMap();
        Collections.sort(commonVars, new Comparator<Var>(){

            @Override
            public int compare(Var a, Var b) {
                return ((Collection)map.get(a)).size() - ((Collection)map.get(b)).size();
            }
        });
        ArrayList assignments = new ArrayList(commonVars.size());
        for (Var var : commonVars) {
            assignments.add(map.get(var));
        }
        CartesianProduct cart = CartesianProduct.create(assignments);
        for (List item : cart) {
            HashMap<Var, Expr> assignment = new HashMap<Var, Expr>(commonVars.size());
            for (int i = 0; i < commonVars.size(); ++i) {
                Var var = (Var)commonVars.get(i);
                Expr expr = ((RestrictedExpr)item.get(i)).getExpr();
                assignment.put(var, expr);
            }
            ExprSqlRewrite exprRewrite = sqlTranslator.translate(condition, assignment, typeMap);
            SqlExprContext tmp = new SqlExprContext(assignment, exprRewrite);
            result.add(tmp);
        }
        return result;
    }

    public static List<SqlExprContext> createExprSqlRewrites(Expr condition, Mapping m, SqlTranslator sqlTranslator) {
        List<SqlExprContext> result = MappingOpsImpl.createExprSqlRewrites(condition, m.getVarDefinition(), m.getSqlOp().getSchema().getTypeMap(), sqlTranslator);
        return result;
    }

    public static List<SqlExpr> createSqlConditionItems(Expr condition, VarDefinition varDef, Map<String, TypeToken> typeMap, SqlTranslator sqlTranslator) {
        List<SqlExprContext> items = MappingOpsImpl.createExprSqlRewrites(condition, varDef, typeMap, sqlTranslator);
        ArrayList<SqlExpr> result = new ArrayList<SqlExpr>();
        for (SqlExprContext item : items) {
            SqlExpr sqlExpr = item.getSqlExpr();
            result.add(sqlExpr);
        }
        return result;
    }

    public static SqlExpr createSqlCondition(Expr condition, VarDefinition varDef, Map<String, TypeToken> typeMap, SqlTranslator sqlTranslator) {
        List<SqlExpr> combines = MappingOpsImpl.createSqlConditionItems(condition, varDef, typeMap, sqlTranslator);
        boolean isNegated = condition instanceof E_LogicalNot;
        SqlExpr result = isNegated ? SqlExprUtils.andifyBalanced(combines) : SqlExprUtils.orifyBalanced(combines);
        if (result == null) {
            result = S_Constant.FALSE;
        }
        assert (result != null) : "Null Pointer Exception";
        return result;
    }

    @Deprecated
    public static SqlExpr createSqlConditionOld(Expr condition, VarDefinition varDef, Map<String, TypeToken> typeMap, SqlTranslator sqlTranslator) {
        Set conditionVars;
        Set cVars = conditionVars = condition.getVarsMentioned();
        cVars.retainAll(varDef.getMap().keySet());
        ArrayList commonVars = new ArrayList(cVars);
        if (commonVars.isEmpty()) {
            ExprSqlRewrite exprRewrite = sqlTranslator.translate(condition, null, typeMap);
            SqlExpr sqlExpr = SqlTranslatorImpl2.asSqlExpr(exprRewrite);
            return sqlExpr;
        }
        final Map map = varDef.getMap().asMap();
        Collections.sort(commonVars, new Comparator<Var>(){

            @Override
            public int compare(Var a, Var b) {
                return ((Collection)map.get(a)).size() - ((Collection)map.get(b)).size();
            }
        });
        ArrayList assignments = new ArrayList(commonVars.size());
        for (Var var : commonVars) {
            assignments.add(map.get(var));
        }
        CartesianProduct cart = CartesianProduct.create(assignments);
        ArrayList<SqlExpr> ors = new ArrayList<SqlExpr>();
        HashMap<Var, Expr> assignment = new HashMap<Var, Expr>(commonVars.size());
        for (List item : cart) {
            for (int i = 0; i < commonVars.size(); ++i) {
                Var var = (Var)commonVars.get(i);
                Expr expr = ((RestrictedExpr)item.get(i)).getExpr();
                assignment.put(var, expr);
            }
            ExprSqlRewrite exprRewrite = sqlTranslator.translate(condition, assignment, typeMap);
            SqlExpr sqlExpr = SqlTranslatorImpl2.asSqlExpr(exprRewrite);
            if (sqlExpr.equals(S_Constant.TRUE)) {
                return S_Constant.TRUE;
            }
            if (sqlExpr.equals(S_Constant.FALSE)) continue;
            ors.add(sqlExpr);
        }
        SqlExpr result = SqlExprUtils.orifyBalanced(ors);
        if (result == null) {
            result = S_Constant.FALSE;
        }
        assert (result != null) : "Null Pointer Exception";
        return result;
    }

    public static VarDefKey joinDefinitionsOnEquals(Collection<RestrictedExpr> a, Collection<RestrictedExpr> b, Map<String, TypeToken> typeMap, SqlTranslator sqlTranslator) {
        VarDefKey result = new VarDefKey();
        result.definitionExprs.addAll(a);
        HashSet<RestrictedExpr> newRexprsA = new HashSet<RestrictedExpr>();
        for (RestrictedExpr rexprA : result.definitionExprs) {
            RestrictionSetImpl varRestrictions = b.isEmpty() ? new RestrictionSetImpl() : null;
            for (RestrictedExpr rexprB : b) {
                RestrictedExpr vdEquals = VariableDefinitionOps.equals(rexprA, rexprB);
                SqlExpr sqlExpr = MappingOpsImpl.translateSql(vdEquals, typeMap, sqlTranslator);
                if (sqlExpr.equals(S_Constant.FALSE)) continue;
                if (varRestrictions == null) {
                    varRestrictions = new RestrictionSetImpl();
                }
                varRestrictions.addAlternatives(vdEquals.getRestrictions());
                result.constraintExpr.add(sqlExpr);
            }
            if (varRestrictions == null) continue;
            RestrictedExpr newRestrictedExpr = new RestrictedExpr(rexprA.getExpr(), varRestrictions);
            newRexprsA.add(newRestrictedExpr);
        }
        result.definitionExprs = newRexprsA;
        if (result.definitionExprs.isEmpty()) {
            return null;
        }
        return result;
    }

    public static VarDefKey joinDefinitionsOnEquals(Var queryVar, ViewInstance<ViewDefinition> viewInstance, SqlTranslator sqlTranslator) {
        Map<String, TypeToken> typeMap = viewInstance.getViewDefinition().getMapping().getSqlOp().getSchema().getTypeMap();
        VarDefKey result = new VarDefKey();
        Set<Var> viewVars = viewInstance.getBinding().getViewVars(queryVar);
        if (viewVars.isEmpty()) {
            return result;
        }
        VarDefinition varDefinition = viewInstance.getVarDefinition();
        Var pickViewVar = viewVars.iterator().next();
        result.definitionExprs.addAll(viewInstance.getDefinitionsForViewVariable(pickViewVar));
        for (Var viewVar : viewVars) {
            if (viewVar.equals((Object)pickViewVar)) continue;
            Collection<RestrictedExpr> defs = varDefinition.getDefinitions(viewVar);
            VarDefKey tmp = MappingOpsImpl.joinDefinitionsOnEquals(result.definitionExprs, defs, typeMap, sqlTranslator);
            if (tmp == null) {
                return null;
            }
            result.definitionExprs = tmp.definitionExprs;
            result.constraintExpr.addAll(tmp.constraintExpr);
        }
        if (result.definitionExprs.isEmpty()) {
            return null;
        }
        return result;
    }

    public static Mapping createEmptyMapping() {
        SqlOpEmpty empty = SqlOpEmpty.create();
        Mapping result = new Mapping(empty);
        return result;
    }

    public static Mapping createEmptyMapping(ViewInstance<ViewDefinition> viewInstance) {
        SqlOpEmpty empty = SqlOpEmpty.create(viewInstance.getViewDefinition().getMapping().getSqlOp().getSchema());
        Mapping result = new Mapping(empty);
        return result;
    }

    @Override
    public Mapping createMapping(ViewInstance<ViewDefinition> viewInstance) {
        Set<Var> queryVars = viewInstance.getBinding().getQueryVars();
        HashMultimap newVarDefMap = HashMultimap.create();
        ArrayList<SqlExpr> ands = null;
        for (Var queryVar : queryVars) {
            Node constant = viewInstance.getBinding().getConstant(queryVar);
            if (constant != null) {
                NodeValue nv = NodeValue.makeNode((Node)constant);
                newVarDefMap.put((Object)queryVar, (Object)new RestrictedExpr((Expr)nv));
                continue;
            }
            VarDefKey ors = MappingOpsImpl.joinDefinitionsOnEquals(queryVar, viewInstance, this.sqlTranslator);
            if (ors == null) {
                return MappingOpsImpl.createEmptyMapping(viewInstance);
            }
            newVarDefMap.putAll((Object)queryVar, ors.definitionExprs);
            SqlExpr or = SqlExprUtils.orifyBalanced(ors.constraintExpr);
            if (or == null || or.equals(S_Constant.TRUE)) continue;
            if (ands == null) {
                ands = new ArrayList<SqlExpr>();
            }
            if (or.equals(S_Constant.FALSE)) continue;
            ands.add(or);
        }
        VarDefinition tmpVarDefinition = new VarDefinition((Multimap<Var, RestrictedExpr>)newVarDefMap);
        VarDefinition varDefinition = tmpVarDefinition.copyExpandConstants();
        Mapping result = null;
        SqlOp op = viewInstance.getViewDefinition().getMapping().getSqlOp();
        if (ands == null) {
            result = new Mapping(varDefinition, op);
        } else if (ands.isEmpty()) {
            result = MappingOpsImpl.createEmptyMapping(viewInstance);
        } else {
            SqlOpFilter filterOp = SqlOpFilter.create(op, (List<SqlExpr>)ands);
            result = new Mapping(varDefinition, filterOp);
        }
        return result;
    }

    public Mapping doJoinRename(Mapping a, Mapping b, Generator gen) {
        List<String> namesA = a.getSqlOp().getSchema().getColumnNames();
        List<String> namesB = b.getSqlOp().getSchema().getColumnNames();
        ArrayList<String> commonNames = new ArrayList<String>(namesB);
        commonNames.retainAll(namesA);
        if (commonNames.isEmpty()) {
            return b;
        }
        HashMap<String, String> rename = new HashMap<String, String>();
        for (String oldName : commonNames) {
            String newName = null;
            while (namesA.contains(newName = gen.next()) || namesB.contains(newName)) {
                logger.warn("FIXME Have to generate another column name - should be prevented");
            }
            rename.put(oldName, newName);
        }
        VarDefinition renamedVarDef = VarDefinition.copyRename(b.getVarDefinition(), rename);
        SqlOpRename renamedOp = SqlOpRename.create(b.getSqlOp(), rename);
        Mapping result = new Mapping(renamedVarDef, renamedOp);
        return result;
    }

    @Override
    public Mapping join(Mapping a, Mapping b) {
        Mapping result = this.joinCommon(a, b, false, null);
        return result;
    }

    @Override
    public Mapping leftJoin(Mapping a, Mapping b, ExprList exprs) {
        Mapping result = this.joinCommon(a, b, true, exprs);
        return result;
    }

    public Mapping joinCommon(Mapping a, Mapping initB, boolean isLeftJoin, ExprList joinExprs) {
        SqlOp resultSqlOp;
        Collection exprs;
        Mapping b = this.doJoinRename(a, initB, genSymJoin);
        JoinType joinType = isLeftJoin ? JoinType.LEFT : JoinType.INNER;
        SqlOpJoin opJoin = SqlOpJoin.create(joinType, a.getSqlOp(), b.getSqlOp());
        Map<String, TypeToken> typeMap = opJoin.getSchema().getTypeMap();
        SqlOpBase opResult = opJoin;
        if (opJoin.getLeft().isEmpty() || joinType.equals((Object)JoinType.INNER) && opJoin.getRight().isEmpty()) {
            opResult = SqlOpEmpty.create(opJoin.getSchema());
        }
        VarDefinition vdA = a.getVarDefinition();
        VarDefinition vdB = b.getVarDefinition();
        Set varsA = vdA.getMap().keySet();
        Set varsB = vdB.getMap().keySet();
        HashSet commonVars = new HashSet(varsA);
        commonVars.retainAll(varsB);
        Sets.SetView varsAOnly = Sets.difference((Set)varsA, commonVars);
        Sets.SetView varsBOnly = Sets.difference((Set)varsB, commonVars);
        Sets.SetView varsAll = Sets.union((Set)varsA, (Set)varsB);
        HashMultimap commonVarDef = HashMultimap.create();
        HashSet<SqlExpr> joinCondition = new HashSet<SqlExpr>();
        boolean isJoinConditionSatisfiable = true;
        for (Var commonVar : commonVars) {
            Collection<RestrictedExpr> defsB;
            Collection<RestrictedExpr> defsA = a.getVarDefinition().getDefinitions(commonVar);
            VarDefKey ors = MappingOpsImpl.joinDefinitionsOnEquals(defsA, defsB = b.getVarDefinition().getDefinitions(commonVar), typeMap, this.sqlTranslator);
            if (ors == null) {
                isJoinConditionSatisfiable = false;
                break;
            }
            commonVarDef.putAll((Object)commonVar, ors.definitionExprs);
            SqlExpr or = SqlExprUtils.orifyBalanced(ors.constraintExpr);
            if (or == null || or.equals(S_Constant.TRUE)) continue;
            joinCondition.add(or);
        }
        HashMultimap newVarDef = HashMultimap.create();
        VarDefinition newVarDefinition = new VarDefinition((Multimap<Var, RestrictedExpr>)newVarDef);
        ArrayList<SqlExpr> jc = new ArrayList<SqlExpr>(joinCondition);
        if (isLeftJoin) {
            for (Var varA : varsA) {
                exprs = vdA.getMap().get((Object)varA);
                newVarDef.putAll((Object)varA, (Iterable)exprs);
            }
            if (isJoinConditionSatisfiable) {
                for (Var varB : varsBOnly) {
                    exprs = vdB.getMap().get((Object)varB);
                    newVarDef.putAll((Object)varB, (Iterable)exprs);
                }
            } else {
                for (Var varB : varsBOnly) {
                    newVarDef.put((Object)varB, (Object)new RestrictedExpr((Expr)E_RdfTerm.TYPE_ERROR));
                }
            }
        } else if (isJoinConditionSatisfiable) {
            newVarDef.putAll((Multimap)commonVarDef);
            for (Var varA : varsAOnly) {
                exprs = vdA.getMap().get((Object)varA);
                newVarDef.putAll((Object)varA, (Iterable)exprs);
            }
            for (Var varB : varsBOnly) {
                exprs = vdB.getMap().get((Object)varB);
                newVarDef.putAll((Object)varB, (Iterable)exprs);
            }
        } else {
            for (Var var : varsAll) {
                newVarDef.put((Object)var, (Object)new RestrictedExpr((Expr)E_RdfTerm.TYPE_ERROR));
            }
        }
        if (isLeftJoin && isJoinConditionSatisfiable) {
            for (Expr expr : joinExprs) {
                SqlExpr sqlExpr = MappingOpsImpl.createSqlCondition(expr, newVarDefinition, typeMap, this.sqlTranslator);
                if (sqlExpr.equals(S_Constant.TRUE)) continue;
                if (sqlExpr.equals(S_Constant.TRUE)) {
                    isJoinConditionSatisfiable = false;
                    break;
                }
                jc.add(sqlExpr);
            }
        }
        if (isLeftJoin) {
            if (isJoinConditionSatisfiable) {
                opJoin.getConditions().addAll(jc);
                resultSqlOp = opResult;
            } else {
                resultSqlOp = a.getSqlOp();
            }
        } else {
            resultSqlOp = isJoinConditionSatisfiable ? SqlOpFilter.create(opResult, jc) : SqlOpEmpty.create(opJoin.getSchema());
        }
        Mapping result = new Mapping(newVarDefinition, resultSqlOp);
        return result;
    }

    @Override
    public Mapping slice(Mapping a, Long limit, Long offset) {
        SqlOpSlice opSlice = SqlOpSlice.create(a.getSqlOp(), offset, limit);
        Mapping result = new Mapping(a.getVarDefinition(), opSlice);
        return result;
    }

    @Override
    public Mapping distinct(Mapping a) {
        SqlOpDistinct newOp = SqlOpDistinct.create(a.getSqlOp());
        Mapping result = new Mapping(a.getVarDefinition(), newOp);
        return result;
    }

    @Override
    public Mapping project(Mapping a, List<Var> vars) {
        List referencedColumns = a.getVarDefinition().getReferencedVarNames(new ArrayList(), vars);
        SqlOpProject sqlOp = SqlOpProject.create(a.getSqlOp(), referencedColumns);
        VarDefinition newVarDef = a.getVarDefinition().copyProject(vars);
        Mapping result = new Mapping(newVarDef, sqlOp);
        return result;
    }

    public ExprList compactConjuction(ExprList exprs) {
        ExprList result = new ExprList();
        for (Expr expr : exprs) {
            if (!expr.isConstant()) continue;
            NodeValue nv = expr.getConstant();
            if (NodeValue.FALSE.equals((Object)nv)) {
                result = new ExprList();
                result.add((Expr)NodeValue.FALSE);
                return result;
            }
            if (NodeValue.TRUE.equals((Object)nv)) continue;
            result.add(expr);
        }
        return result;
    }

    @Override
    public Mapping filter(Mapping a, ExprList exprs) {
        Map<String, TypeToken> typeMap = a.getSqlOp().getSchema().getTypeMap();
        ArrayList<SqlExpr> sqlExprs = new ArrayList<SqlExpr>();
        for (Expr expr : exprs) {
            SqlExpr sqlExpr = MappingOpsImpl.createSqlCondition(expr, a.getVarDefinition(), typeMap, this.sqlTranslator);
            if (sqlExpr.equals(S_Constant.TRUE)) continue;
            sqlExprs.add(sqlExpr);
        }
        SqlOp op = SqlOpFilter.createIfNeeded(a.getSqlOp(), sqlExprs);
        Mapping result = new Mapping(a.getVarDefinition(), op);
        return result;
    }

    public Mapping unionIfNeeded(List<Mapping> members) {
        Mapping result = members.size() == 1 ? members.iterator().next() : this.union(members);
        return result;
    }

    public static List<Mapping> removeEmptyMembers(List<Mapping> mappings) {
        ArrayList<Mapping> result = new ArrayList<Mapping>(mappings.size());
        for (Mapping mapping : mappings) {
            if (mapping.isEmpty()) continue;
            result.add(mapping);
        }
        return result;
    }

    public static List<Mapping> pushConstants(List<Mapping> mappings) {
        ArrayList<Mapping> result = new ArrayList<Mapping>(mappings.size());
        for (Mapping mapping : mappings) {
            Mapping newMapping = MappingOpsImpl.pushConstants(mapping);
            result.add(newMapping);
        }
        return result;
    }

    public static Mapping pushConstants(Mapping mapping) {
        Mapping result;
        VarDefinition varDef = mapping.getVarDefinition();
        HashSet<String> columnNameBlacklist = new HashSet<String>(mapping.getSqlOp().getSchema().getColumnNames());
        GeneratorBlacklist aliasGen = GeneratorBlacklist.create("C", columnNameBlacklist);
        Projection projection = new Projection();
        VarDefinition newVarDef = new VarDefinition();
        for (Map.Entry entry : varDef.getMap().asMap().entrySet()) {
            Var var = (Var)entry.getKey();
            Collection restExprs = (Collection)entry.getValue();
            for (RestrictedExpr restExpr : restExprs) {
                Expr newExpr;
                Expr expr = restExpr.getExpr();
                E_RdfTerm rdfTerm = expr.isConstant() ? SqlTranslationUtils.expandConstant(expr) : SqlTranslationUtils.expandRdfTerm(expr);
                boolean isConstantArgsOnly = ExprUtils.isConstantArgsOnly((ExprFunction)rdfTerm);
                if (isConstantArgsOnly) {
                    NodeValue constant = expr.eval(null, null);
                    String alias = aliasGen.next();
                    String str = "" + NodeValueUtils.getValue(constant);
                    S_Constant sqlExpr = new S_Constant(new SqlValue(TypeToken.String, str));
                    projection.put(alias, sqlExpr);
                    ExprVar exprVar = new ExprVar(alias);
                    ExprList exprs = new ExprList();
                    List args = rdfTerm.getArgs();
                    for (int j = 0; j < args.size(); ++j) {
                        Object e = j == 1 ? exprVar : (Expr)args.get(j);
                        exprs.add((Expr)e);
                    }
                    newExpr = ExprCopy.getInstance().copy((Expr)rdfTerm, exprs);
                } else {
                    newExpr = expr;
                }
                RestrictedExpr newRestExpr = new RestrictedExpr(newExpr, restExpr.getRestrictions());
                newVarDef.getMap().put((Object)var, (Object)newRestExpr);
            }
        }
        if (projection.isEmpty()) {
            result = mapping;
        } else {
            SqlOp sqlOp = mapping.getSqlOp();
            SqlOpExtend newSqlOp = SqlOpExtend.create(sqlOp, projection);
            result = new Mapping(newVarDef, newSqlOp);
        }
        return result;
    }

    public static Set<String> getReferencedColumnNames(List<Mapping> mappings) {
        HashSet<String> result = new HashSet<String>();
        for (Mapping member : mappings) {
            List<String> memberColumnNames = member.getSqlOp().getSchema().getColumnNames();
            result.addAll(memberColumnNames);
        }
        return result;
    }

    @Override
    public Mapping union(List<Mapping> members) {
        Mapping member;
        if ((members = MappingOpsImpl.removeEmptyMembers(members)).isEmpty()) {
            Mapping result = MappingOpsImpl.createEmptyMapping();
            return result;
        }
        members = MappingOpsImpl.pushConstants(members);
        Set<String> columnNameBlacklist = MappingOpsImpl.getReferencedColumnNames(members);
        GeneratorBlacklist aliasGenUnion = GeneratorBlacklist.create("C", columnNameBlacklist);
        if (members.size() == 1) {
            logger.warn("Single member union - should be avoided");
            Mapping result = members.get(0);
            return result;
        }
        HashMultimap unionVarDefs = HashMultimap.create();
        ArrayList unionMemberProjections = new ArrayList();
        for (int i = 0; i < members.size(); ++i) {
            HashMap tmp = new HashMap();
            unionMemberProjections.add(tmp);
        }
        HashMultimap varToMembers = HashMultimap.create();
        for (int i = 0; i < members.size(); ++i) {
            Mapping mapping = members.get(i);
            for (Var var : mapping.getVarDefinition().getMap().keySet()) {
                varToMembers.put((Object)var, (Object)i);
            }
        }
        HashSet<Var> constantVars = new HashSet<Var>();
        for (Map.Entry entry : varToMembers.asMap().entrySet()) {
            Var var;
            var = (Var)entry.getKey();
            Iterator i$ = ((Collection)entry.getValue()).iterator();
            while (i$.hasNext()) {
                int index = (Integer)i$.next();
                member = members.get(index);
                Collection<RestrictedExpr> exprsForVar = member.getVarDefinition().getDefinitions(var);
                for (RestrictedExpr restrictedExpr : exprsForVar) {
                    if (!restrictedExpr.getExpr().isConstant()) continue;
                    constantVars.add(var);
                }
            }
        }
        ExprCommonFactor factorizer = new ExprCommonFactor(aliasGenUnion);
        HashMap<String, TypeToken> unionTypeMap = new HashMap<String, TypeToken>();
        for (Map.Entry entry : varToMembers.asMap().entrySet()) {
            Var var = (Var)entry.getKey();
            Collection memberIndexes = (Collection)entry.getValue();
            ArrayListMultimap cluster = ArrayListMultimap.create();
            Iterator<Object> i$ = memberIndexes.iterator();
            while (i$.hasNext()) {
                int n = (Integer)((Object)i$.next());
                Mapping member2 = members.get(n);
                Collection<RestrictedExpr> exprsForVar = member2.getVarDefinition().getDefinitions(var);
                boolean singleSizeCluster = false;
                if (exprsForVar.size() > 1) {
                    singleSizeCluster = true;
                }
                int j = 0;
                for (RestrictedExpr def : exprsForVar) {
                    Map<String, TypeToken> typeMap = member2.getSqlOp().getSchema().getTypeMap();
                    Expr expr = def.getExpr();
                    if (!(expr instanceof E_RdfTerm)) {
                        throw new RuntimeException("Type E_RdfTerm expected, but got: " + expr);
                    }
                    E_RdfTerm e = (E_RdfTerm)expr;
                    Expr valueType = this.exprNormalizer.normalize(e.getLexicalValue(), typeMap);
                    String hash = "" + e.getType() + valueType + e.getDatatype();
                    if (singleSizeCluster) {
                        hash = "m" + n + "e" + j + hash;
                    }
                    logger.trace("Cluster for [" + expr + "] is [" + hash + "]");
                    cluster.put((Object)hash, (Object)new ArgExpr(expr, n));
                    ++j;
                }
            }
            for (Map.Entry entry2 : cluster.asMap().entrySet()) {
                int j;
                Collection argExprs = (Collection)entry2.getValue();
                ArrayList<Expr> exprs = new ArrayList<Expr>();
                HashMap<Integer, Integer> exprToOp = new HashMap<Integer, Integer>();
                int i = 0;
                for (ArgExpr argExpr : argExprs) {
                    Expr expr = argExpr.getExpr();
                    exprs.add(expr);
                    exprToOp.put(i, argExpr.getIndex());
                    ++i;
                }
                ArrayList<Map<Var, Expr>> tmpPartialProjections = new ArrayList<Map<Var, Expr>>();
                Expr common = factorizer.transform(exprs, tmpPartialProjections);
                ArrayList partialProjections = new ArrayList();
                for (j = 0; j < tmpPartialProjections.size(); ++j) {
                    int memberIndex = (Integer)exprToOp.get(j);
                    Mapping member3 = members.get(memberIndex);
                    Map<String, TypeToken> typeMap = member3.getSqlOp().getSchema().getTypeMap();
                    Map tmpMap = (Map)tmpPartialProjections.get(j);
                    HashMap<String, SqlExpr> map = new HashMap<String, SqlExpr>();
                    for (Map.Entry e : tmpMap.entrySet()) {
                        String columnName = ((Var)e.getKey()).getVarName();
                        Expr expr = (Expr)e.getValue();
                        ExprSqlRewrite exprRewrite = this.sqlTranslator.translate(expr, null, typeMap);
                        SqlExpr sqlExpr = SqlTranslatorImpl2.asSqlExpr(exprRewrite);
                        map.put(columnName, sqlExpr);
                        unionTypeMap.put(columnName, sqlExpr.getDatatype());
                    }
                    partialProjections.add(map);
                }
                unionVarDefs.put((Object)var, (Object)new RestrictedExpr(common));
                for (j = 0; j < partialProjections.size(); ++j) {
                    int originalIndex = (Integer)exprToOp.get(j);
                    Map projection = (Map)unionMemberProjections.get(originalIndex);
                    Map partialProjection = (Map)partialProjections.get(j);
                    for (Map.Entry ppEntry : partialProjection.entrySet()) {
                        projection.put(ppEntry.getKey(), ppEntry.getValue());
                    }
                }
            }
        }
        ArrayList<String> unionColumnOrder = new ArrayList<String>(unionTypeMap.keySet());
        ArrayList<SqlOp> extended = new ArrayList<SqlOp>();
        for (int i = 0; i < members.size(); ++i) {
            member = members.get(i);
            Map unionMemberProjection = (Map)unionMemberProjections.get(i);
            HashSet names = new HashSet(unionMemberProjection.keySet());
            Sets.SetView setView = Sets.difference(unionTypeMap.keySet(), names);
            for (String columnName : setView) {
                TypeToken datatype = (TypeToken)unionTypeMap.get(columnName);
                S_Constant nullValue = new S_Constant(datatype);
                unionMemberProjection.put(columnName, nullValue);
            }
            Projection finalMemberProjection = new Projection(unionColumnOrder, unionMemberProjection);
            SqlOpExtend extend = SqlOpExtend.create(member.getSqlOp(), finalMemberProjection);
            SqlOpProject opProject = SqlOpProject.create(extend, unionColumnOrder);
            extended.add(opProject);
        }
        SqlOpUnionN newUnion = SqlOpUnionN.create(extended);
        VarDefinition varDefinition = new VarDefinition((Multimap<Var, RestrictedExpr>)unionVarDefs);
        Mapping result = new Mapping(varDefinition, newUnion);
        logger.info("Union of mappings:\n" + result);
        return result;
    }

    public static List<Map<Var, Expr>> createBindingProduct(VarDefinition varDef, Collection<Var> vars) {
        Multimap<Var, RestrictedExpr> map = varDef.getMap();
        ArrayList<Collection> assignments = new ArrayList<Collection>(vars.size());
        for (Var var : vars) {
            assignments.add(map.get((Object)var));
        }
        CartesianProduct cart = CartesianProduct.create(assignments);
        ArrayList<Map<Var, Expr>> result = new ArrayList<Map<Var, Expr>>();
        for (List item : cart) {
            Iterator<Var> itVar = vars.iterator();
            Iterator itRestExpr = item.iterator();
            HashMap<Var, Expr> binding = new HashMap<Var, Expr>();
            for (int i = 0; i < vars.size(); ++i) {
                Var var = itVar.next();
                RestrictedExpr restExpr = (RestrictedExpr)itRestExpr.next();
                Expr expr = restExpr.getExpr();
                binding.put(var, expr);
                result.add(binding);
            }
        }
        return result;
    }

    @Override
    public Mapping extend(Mapping a, VarDefinition varDef) {
        HashMultimap newMap = HashMultimap.create();
        Multimap<Var, RestrictedExpr> map = varDef.getMap();
        for (Map.Entry entry : map.asMap().entrySet()) {
            Var var = (Var)entry.getKey();
            Collection restExprs = (Collection)entry.getValue();
            for (RestrictedExpr restExpr : restExprs) {
                Expr expr = restExpr.getExpr();
                Set vars = expr.getVarsMentioned();
                if (vars.isEmpty()) {
                    newMap.put((Object)var, (Object)restExpr);
                    continue;
                }
                List<Map<Var, Expr>> bindings = MappingOpsImpl.createBindingProduct(a.getVarDefinition(), vars);
                for (Map<Var, Expr> binding : bindings) {
                    NodeExprSubstitutor substitutor = new NodeExprSubstitutor(binding);
                    Expr newExpr = substitutor.transformMM(expr);
                    newMap.put((Object)var, (Object)new RestrictedExpr(newExpr, restExpr.getRestrictions()));
                }
            }
        }
        VarDefinition tmpVarDef = new VarDefinition((Multimap<Var, RestrictedExpr>)newMap);
        VarDefinition newVarDef = a.getVarDefinition().extend(tmpVarDef);
        Mapping result = new Mapping(newVarDef, a.getSqlOp());
        return result;
    }

    @Override
    public Mapping groupBy(Mapping a, VarExprList groupVars, List<ExprAggregator> aggregators) {
        MappingUnion mu = MappingRefactor.groupBy(a, groupVars, aggregators, this.sqlTranslator, this.getTypeSystem(), this.exprNormalizer);
        List<Mapping> mappings = mu.getMappings();
        Mapping result = this.unionIfNeeded(mappings);
        return result;
    }

    public Mapping groupByOld(Mapping a, VarExprList groupVars, List<ExprAggregator> aggregators) {
        ArrayList<Var> vars = new ArrayList<Var>(groupVars.getVars());
        List<Mapping> ms = MappingRefactor.refactorToUnion(a, vars);
        ListMultimap<String, Mapping> groups = MappingRefactor.groupByOld(this.exprNormalizer, ms, vars);
        ArrayList<Mapping> gg = new ArrayList<Mapping>();
        for (Collection group : groups.asMap().values()) {
            ArrayList<Mapping> list = new ArrayList<Mapping>(group);
            Mapping u = this.union(list);
            ArrayList<String> columnNames = new ArrayList<String>();
            for (Var var : vars) {
                Collection<RestrictedExpr> defs = u.getVarDefinition().getDefinitions(var);
                if (defs.size() > 1) {
                    throw new RuntimeException("Should not happen");
                }
                if (defs.isEmpty()) continue;
                RestrictedExpr restExpr = defs.iterator().next();
                Expr expr = restExpr.getExpr();
                Set mentionedVars = expr.getVarsMentioned();
                for (Var mv : mentionedVars) {
                    String varName = mv.getVarName();
                    if (columnNames.contains(varName)) continue;
                    columnNames.add(varName);
                }
            }
            Map<String, TypeToken> typeMap = u.getSqlOp().getSchema().getTypeMap();
            ArrayList<SqlExpr> columnRefs = new ArrayList<SqlExpr>();
            for (String columnName : columnNames) {
                TypeToken type = typeMap.get(columnName);
                S_ColumnRef expr = new S_ColumnRef(type, columnName);
                columnRefs.add(expr);
            }
            ArrayList<SqlExprAggregator> sqlAggregators = new ArrayList<SqlExprAggregator>();
            SqlOpGroupBy sqlOpGroupBy = SqlOpGroupBy.create(u.getSqlOp(), columnRefs, sqlAggregators);
            Mapping tmp = new Mapping(u.getVarDefinition(), sqlOpGroupBy);
            gg.add(tmp);
        }
        Mapping result = this.unionIfNeeded(gg);
        Gensym varsym = Gensym.create((String)"v");
        Gensym aggSym = Gensym.create((String)"G");
        for (ExprAggregator ea : aggregators) {
            Aggregator agg = ea.getAggregator();
            ExprSqlRewrite rewrite = MappingOpsImpl.rewrite(a, agg, (Generator)aggSym, this.getTypeSystem(), this.sqlTranslator);
            Projection ex = new Projection();
            ex.add(rewrite.getProjection());
            SqlOpExtend newOp = SqlOpExtend.create(result.getSqlOp(), ex);
            Var var = ea.getVar();
            HashMultimap map = HashMultimap.create(result.getVarDefinition().getMap());
            map.put((Object)var, (Object)new RestrictedExpr(rewrite.getExpr()));
            VarDefinition newVd = new VarDefinition((Multimap<Var, RestrictedExpr>)map);
            result = new Mapping(newVd, newOp);
        }
        return result;
    }

    public static E_Function aggregatorToFunction(Aggregator agg) {
        Expr arg = agg.getExpr();
        ExprList args = new ExprList();
        if (arg != null) {
            args.add(arg);
        }
        String fnName = agg.getClass().getSimpleName();
        E_Function result = new E_Function(fnName, args);
        return result;
    }

    public TypeSystem getTypeSystem() {
        SqlTranslatorImpl2 tmp = (SqlTranslatorImpl2)this.sqlTranslator;
        TypedExprTransformerImpl tet = (TypedExprTransformerImpl)tmp.getTypedExprTransformer();
        TypeSystem result = tet.getTypeSystem();
        return result;
    }

    public static ExprSqlRewrite rewrite(Mapping mapping, Aggregator agg, Generator generator, TypeSystem typeSystem, SqlTranslator sqlTranslator) {
        SqlExpr sqlCoalesce;
        E_Function fn = MappingOpsImpl.aggregatorToFunction(agg);
        String sparqlFnName = ExprUtils.getFunctionId((ExprFunction)fn);
        List args = fn.getArgs();
        Map<String, TypeToken> typeMap = mapping.getSqlOp().getSchema().getTypeMap();
        VarDefinition varDef = mapping.getVarDefinition();
        FunctionModel<TypeToken> functionModel = typeSystem.getSqlFunctionModel();
        Multimap<String, String> sparqlSqlDecls = typeSystem.getSparqlSqlDecls();
        if (!args.isEmpty()) {
            int i;
            ArrayList<List<SqlExprContext>> argContexts = new ArrayList<List<SqlExprContext>>(args.size());
            for (Expr arg : args) {
                List<SqlExprContext> contexts = MappingOpsImpl.createExprSqlRewrites(arg, varDef, typeMap, sqlTranslator);
                argContexts.add(contexts);
            }
            CartesianProduct cartContexts = CartesianProduct.create(argContexts);
            ArrayList<AggCandidate> aggCandidates = new ArrayList<AggCandidate>(cartContexts.size());
            for (ArrayList<SqlExprContext> cartContext : cartContexts) {
                cartContext = new ArrayList<SqlExprContext>(cartContext);
                AggCandidate aggCandidate = AggCandidate.create(cartContext);
                aggCandidates.add(aggCandidate);
            }
            ArrayList<AggCandidate> survivors = new ArrayList<AggCandidate>(aggCandidates.size());
            HashSet<MethodEntry> overloads = new HashSet<MethodEntry>();
            for (AggCandidate cand : aggCandidates) {
                List<TypeToken> argTypes = cand.getArgTypes();
                CandidateMethod candidateMethod = TypeSystemUtils.lookupSqlCandidate(functionModel, sparqlSqlDecls, (String)sparqlFnName, argTypes);
                if (candidateMethod == null) continue;
                survivors.add(cand);
                overloads.add(candidateMethod.getMethod());
            }
            MethodEntry bestMatch = null;
            ArrayList<CandidateMethod> bestMethods = new ArrayList<CandidateMethod>(survivors.size());
            for (MethodEntry methodEntry : overloads) {
                boolean isBestMatch = true;
                for (AggCandidate survivor : survivors) {
                    List<TypeToken> argTypes = survivor.getArgTypes();
                    CandidateMethod methodCand = TypeSystemUtils.lookupSqlCandidate(functionModel, (MethodEntry)methodEntry, argTypes, (String)("Candidates for SPARQL aggregate " + sparqlFnName));
                    if (methodCand == null) {
                        isBestMatch = false;
                        bestMethods.clear();
                        break;
                    }
                    bestMethods.add(methodCand);
                }
                if (!isBestMatch) continue;
                if (bestMatch != null) {
                    throw new RuntimeException("Multiple matches for aggregate function");
                }
                bestMatch = methodEntry;
            }
            if (bestMatch == null) {
                throw new RuntimeException("Could not decide on a best match from a set of candidates: " + overloads);
            }
            int n = survivors.size();
            ArrayList arrayList = new ArrayList(args.size());
            for (i = 0; i < args.size(); ++i) {
                arrayList.add(new ArrayList(n));
            }
            for (i = 0; i < n; ++i) {
                AggCandidate survivor = (AggCandidate)survivors.get(i);
                CandidateMethod method = (CandidateMethod)bestMethods.get(i);
                List<SqlExpr> sqlArgs = survivor.getArgs();
                List coercions = method.getCoercions();
                for (int j = 0; j < sqlArgs.size(); ++j) {
                    SqlExpr sqlArg = sqlArgs.get(j);
                    CandidateMethod coercion = (CandidateMethod)coercions.get(j);
                    SqlExpr sqlExpr = coercion != null ? TypedExprTransformerImpl.createSqlExpr((CandidateMethod<TypeToken>)coercion, sqlArg) : sqlArg;
                    List coalesceArgs = (List)arrayList.get(j);
                    coalesceArgs.add(sqlExpr);
                }
            }
            ArrayList<SqlExpr> finalArgs = new ArrayList<SqlExpr>(args.size());
            for (int i2 = 0; i2 < args.size(); ++i2) {
                List coalesceArgs = (List)arrayList.get(i2);
                SqlExpr finalArg = S_Coalesce.create(coalesceArgs);
                finalArgs.add(finalArg);
            }
            CandidateMethod cm = new CandidateMethod(bestMatch, null, null);
            sqlCoalesce = TypedExprTransformerImpl.createSqlExpr((CandidateMethod<TypeToken>)cm, finalArgs);
        } else {
            List noArgTypes = Collections.emptyList();
            CandidateMethod overload = TypeSystemUtils.lookupSqlCandidate(functionModel, sparqlSqlDecls, (String)sparqlFnName, noArgTypes);
            List<SqlExpr> noArgs = Collections.emptyList();
            sqlCoalesce = TypedExprTransformerImpl.createSqlExpr((CandidateMethod<TypeToken>)overload, noArgs);
        }
        String columnAlias = generator.next();
        Projection p = new Projection();
        p.put(columnAlias, sqlCoalesce);
        ExprVar columnRef = new ExprVar(columnAlias);
        ArrayList rdfTermExprs = new ArrayList();
        String sqlTypeName = sqlCoalesce.getDatatype().getName();
        String typeUri = typeSystem.getNormSqlTypeToUri().get(sqlTypeName);
        if (typeUri == null) {
            throw new RuntimeException("No mapping from sql type " + sqlTypeName + " to a uri for an RDF literal");
        }
        E_RdfTerm e = E_RdfTerm.createTypedLiteral((Expr)columnRef, (Expr)NodeValue.makeString((String)typeUri));
        ExprSqlRewrite result = new ExprSqlRewrite((Expr)e, p);
        return result;
    }

    public ExprSqlRewrite rewriteOld(Gensym gensym, Aggregator agg) {
        if (!(agg instanceof AggCount)) {
            throw new RuntimeException("Unsupported aggregator: " + agg);
        }
        ExprSqlRewrite result = this.rewrite(gensym, (AggCount)agg);
        return result;
    }

    public ExprSqlRewrite rewrite(Gensym gensym, AggCount agg) {
        String columnAlias = gensym.next();
        S_AggCount count = new S_AggCount();
        S_Agg sagg = new S_Agg(count);
        Projection p = new Projection();
        p.put(columnAlias, sagg);
        ExprVar columnRef = new ExprVar(columnAlias);
        ExprList args = new ExprList();
        args.add((Expr)columnRef);
        args.add((Expr)NodeValue.makeString((String)XSD.integer.getURI()));
        E_Function e = new E_Function("http://aksw.org/sparqlify/typedLiteral", args);
        ExprSqlRewrite result = new ExprSqlRewrite((Expr)e, p);
        return result;
    }

    public List<SqlExprContext> createExprContexts(Expr e, Mapping source) {
        Map<String, TypeToken> typeMap = source.getSqlOp().getSchema().getTypeMap();
        VarDefinition varDef = source.getVarDefinition();
        Set refVars = e.getVarsMentioned();
        Set definedVars = source.getVarDefinition().getMap().keySet();
        boolean allDefined = definedVars.containsAll(refVars);
        if (!allDefined) {
            return null;
        }
        List<SqlExprContext> result = MappingOpsImpl.createExprSqlRewrites(e, varDef, typeMap, this.sqlTranslator);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public ExprSqlRewrite unifyAlternatives(Expr e, Mapping source) {
        List<SqlExprContext> contexts = this.createExprContexts(e, source);
        if (contexts == null) {
            return null;
        }
        ArrayList whens = new ArrayList(4);
        for (int i = 0; i < 4; ++i) {
            whens.add(new ArrayList());
        }
        for (SqlExprContext context : contexts) {
            void var12_15;
            ExprSqlRewrite rewrite = context.getRewrite();
            E_RdfTerm rdfTerm = rewrite.getRdfTermExpr();
            Set<S_ColumnRef> colRefs = rewrite.getInvolvedColumns();
            ArrayList<SqlExpr> conditionParts = new ArrayList<SqlExpr>();
            for (S_ColumnRef s_ColumnRef : colRefs) {
                S_IsNotNull expr = new S_IsNotNull(s_ColumnRef);
                conditionParts.add(expr);
            }
            SqlExpr condition = SqlExprUtils.andifyBalanced(conditionParts);
            boolean bl = false;
            while (var12_15 < 4) {
                SqlExpr tmp;
                List cs = (List)whens.get((int)var12_15);
                Expr field = rdfTerm.getArg((int)(var12_15 + true));
                if (!field.isVariable()) {
                    throw new RuntimeException("Should not happen");
                }
                String varName = field.getVarName();
                SqlExpr sqlExpr = tmp = rewrite.getProjection().getNameToExpr().get(varName);
                S_When caze = new S_When(sqlExpr.getDatatype(), condition, sqlExpr);
                cs.add(caze);
                ++var12_15;
            }
        }
        Gensym generator = Gensym.create((String)"o");
        ArrayList<Expr> resultVars = new ArrayList<Expr>(4);
        Projection resultProjection = new Projection();
        for (int i = 0; i < 4; ++i) {
            List cs = (List)whens.get(i);
            HashMultimap typeToWhen = HashMultimap.create();
            for (S_When s_When : cs) {
                typeToWhen.put((Object)s_When.getDatatype(), (Object)s_When);
            }
            for (Map.Entry entry : typeToWhen.asMap().entrySet()) {
                SqlExpr expr;
                TypeToken groupType = (TypeToken)entry.getKey();
                if (groupType.getName().equals("object")) {
                    throw new RuntimeException("Should not happen");
                }
                ArrayList<S_When> groupWhens = new ArrayList<S_When>((Collection)entry.getValue());
                String varName = generator.next();
                Var v = Var.alloc((String)varName);
                ExprVar exprVar = new ExprVar(v);
                HashSet<SqlExpr> resultExprs = new HashSet<SqlExpr>();
                for (S_When when : groupWhens) {
                    resultExprs.add(when.getRight());
                }
                if (resultExprs.size() == 1) {
                    expr = (SqlExpr)resultExprs.iterator().next();
                } else {
                    S_Constant nullExpr = S_Constant.create(new SqlValue(groupType, null));
                    expr = S_Case.create(groupType, groupWhens, nullExpr);
                }
                resultVars.add((Expr)exprVar);
                resultProjection.put(varName, expr);
            }
        }
        E_RdfTerm resultTerm = new E_RdfTerm(resultVars);
        ExprSqlRewrite result = new ExprSqlRewrite((Expr)resultTerm, resultProjection);
        return result;
    }

    @Override
    public Mapping order(Mapping a, List<SortCondition> sortConditions) {
        boolean disableOrderBy = false;
        if (disableOrderBy) {
            return a;
        }
        ArrayList<SqlSortCondition> sqlConds = new ArrayList<SqlSortCondition>(sortConditions.size() * 4);
        for (SortCondition sc : sortConditions) {
            Expr expr = sc.getExpression();
            ExprSqlRewrite rewrite = this.unifyAlternatives(expr, a);
            if (rewrite == null) continue;
            List<SqlExpr> sqlExprs = rewrite.getSqlExprs();
            for (SqlExpr sqlExpr : sqlExprs) {
                if (sqlExpr.isConstant()) continue;
                SqlSortCondition sqlCond = new SqlSortCondition(sqlExpr, sc.getDirection());
                sqlConds.add(sqlCond);
            }
        }
        SqlOp subOp = a.getSqlOp();
        SqlOpOrder sqlOp = SqlOpOrder.create(subOp, sqlConds);
        VarDefinition varDef = a.getVarDefinition();
        Mapping result = new Mapping(varDef, sqlOp);
        return result;
    }
}

