/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.algorithms;

import java.util.ArrayList;
import java.util.List;
import org.aksw.sparqlify.algebra.sql.exprs2.SqlExpr;
import org.aksw.sparqlify.core.TypeToken;
import org.aksw.sparqlify.core.algorithms.SqlExprContext;
import org.aksw.sparqlify.expr.util.SqlExprUtils;

class AggCandidate {
    private List<SqlExprContext> contexts;
    private List<SqlExpr> args;
    private List<TypeToken> argTypes;

    public AggCandidate(List<SqlExprContext> contexts, List<SqlExpr> args, List<TypeToken> argTypes) {
        this.contexts = contexts;
        this.args = args;
        this.argTypes = argTypes;
    }

    public List<SqlExprContext> getContexts() {
        return this.contexts;
    }

    public List<SqlExpr> getArgs() {
        return this.args;
    }

    public List<TypeToken> getArgTypes() {
        return this.argTypes;
    }

    public static AggCandidate create(List<SqlExprContext> contexts) {
        ArrayList<SqlExpr> args = new ArrayList<SqlExpr>(contexts.size());
        for (SqlExprContext context : contexts) {
            args.add(context.getSqlExpr());
        }
        List<TypeToken> argTypes = SqlExprUtils.getTypes(args);
        AggCandidate result = new AggCandidate(contexts, args, argTypes);
        return result;
    }

    public String toString() {
        return "AggCandidate [contexts=" + this.contexts + ", args=" + this.args + ", argTypes=" + this.argTypes + "]";
    }
}

