/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.compile.sparql;

import com.hp.hpl.jena.sparql.expr.E_Add;
import com.hp.hpl.jena.sparql.expr.E_Bound;
import com.hp.hpl.jena.sparql.expr.E_Equals;
import com.hp.hpl.jena.sparql.expr.E_GreaterThan;
import com.hp.hpl.jena.sparql.expr.E_GreaterThanOrEqual;
import com.hp.hpl.jena.sparql.expr.E_LangMatches;
import com.hp.hpl.jena.sparql.expr.E_LessThan;
import com.hp.hpl.jena.sparql.expr.E_LessThanOrEqual;
import com.hp.hpl.jena.sparql.expr.E_LogicalAnd;
import com.hp.hpl.jena.sparql.expr.E_LogicalNot;
import com.hp.hpl.jena.sparql.expr.E_LogicalOr;
import com.hp.hpl.jena.sparql.expr.E_OneOf;
import com.hp.hpl.jena.sparql.expr.E_Regex;
import com.hp.hpl.jena.sparql.expr.E_StrConcat;
import com.hp.hpl.jena.sparql.expr.E_StrDatatype;
import com.hp.hpl.jena.sparql.expr.E_Subtract;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprFunction;
import java.util.ArrayList;
import org.aksw.sparqlify.algebra.sparql.expr.E_StrConcatPermissive;
import org.aksw.sparqlify.algebra.sparql.expr.old.E_GenericSqlExpr;
import org.aksw.sparqlify.algebra.sparql.expr.old.E_GeographyFromText;
import org.aksw.sparqlify.algebra.sparql.expr.old.E_GeomFromText;
import org.aksw.sparqlify.algebra.sparql.expr.old.E_Intersects;
import org.aksw.sparqlify.algebra.sql.exprs.S_Add;
import org.aksw.sparqlify.algebra.sql.exprs.S_Cast;
import org.aksw.sparqlify.algebra.sql.exprs.S_Concat;
import org.aksw.sparqlify.algebra.sql.exprs.S_Equals;
import org.aksw.sparqlify.algebra.sql.exprs.S_GeographyFromText;
import org.aksw.sparqlify.algebra.sql.exprs.S_GeometryFromText;
import org.aksw.sparqlify.algebra.sql.exprs.S_GreaterThan;
import org.aksw.sparqlify.algebra.sql.exprs.S_GreaterThanOrEqual;
import org.aksw.sparqlify.algebra.sql.exprs.S_Intersects;
import org.aksw.sparqlify.algebra.sql.exprs.S_IsNotNull;
import org.aksw.sparqlify.algebra.sql.exprs.S_LessThan;
import org.aksw.sparqlify.algebra.sql.exprs.S_LessThanOrEqual;
import org.aksw.sparqlify.algebra.sql.exprs.S_LogicalAnd;
import org.aksw.sparqlify.algebra.sql.exprs.S_LogicalNot;
import org.aksw.sparqlify.algebra.sql.exprs.S_LogicalOr;
import org.aksw.sparqlify.algebra.sql.exprs.S_Regex;
import org.aksw.sparqlify.algebra.sql.exprs.S_Substract;
import org.aksw.sparqlify.algebra.sql.exprs.SqlExpr;
import org.aksw.sparqlify.algebra.sql.exprs.SqlExprList;
import org.aksw.sparqlify.algebra.sql.exprs.SqlExprValue;
import org.aksw.sparqlify.core.DatatypeSystemDefault;
import org.aksw.sparqlify.core.DatatypeSystemOld;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SqlPusher {
    private static final Logger logger = LoggerFactory.getLogger(SqlPusher.class);
    private static DatatypeSystemOld datatypeSystem = new DatatypeSystemDefault();

    SqlPusher() {
    }

    public static SqlExpr push(Expr expr, SqlExprList args) {
        ExprFunction func;
        String funcIri;
        if (expr.isFunction() && (funcIri = (func = expr.getFunction()).getFunctionIRI()) != null && funcIri.equals("http://aksw.org/sparqlify/urlEncode")) {
            logger.warn("HACK USED: IGNORING URLENCODE");
            return args.get(0);
        }
        throw new RuntimeException("Should not happen: " + expr + "; " + args);
    }

    public static SqlExpr push(E_StrConcatPermissive expr, SqlExprList args) {
        return new S_Concat(args);
    }

    public static SqlExpr push(E_Bound expr, SqlExprList args) {
        return new S_IsNotNull(args.get(0));
    }

    public static SqlExpr push(E_StrConcat expr, SqlExprList args) {
        return new S_Concat(args);
    }

    public static SqlExpr push(E_Equals expr, SqlExprList args) {
        return S_Equals.create(args.get(0), args.get(1), datatypeSystem);
    }

    public static SqlExpr push(E_LangMatches expr, SqlExprList args) {
        return S_Equals.create(args.get(0), args.get(1), datatypeSystem);
    }

    public static SqlExpr push(E_Add expr, SqlExprList args) {
        return S_Add.create(args.get(0), args.get(1), datatypeSystem);
    }

    public static SqlExpr push(E_Subtract expr, SqlExprList args) {
        return S_Substract.create(args.get(0), args.get(1), datatypeSystem);
    }

    public static SqlExpr push(E_LogicalAnd expr, SqlExprList args) {
        return new S_LogicalAnd(args.get(0), args.get(1));
    }

    public static SqlExpr push(E_LogicalOr expr, SqlExprList args) {
        return new S_LogicalOr(args.get(0), args.get(1));
    }

    public static SqlExpr push(E_LogicalNot expr, SqlExprList args) {
        return new S_LogicalNot(args.get(0));
    }

    public static SqlExpr push(E_LessThan expr, SqlExprList args) {
        return S_LessThan.create(args.get(0), args.get(1), datatypeSystem);
    }

    public static SqlExpr push(E_GreaterThan expr, SqlExprList args) {
        return S_GreaterThan.create(args.get(0), args.get(1), datatypeSystem);
    }

    public static SqlExpr push(E_GreaterThanOrEqual expr, SqlExprList args) {
        return S_GreaterThanOrEqual.create(args.get(0), args.get(1), datatypeSystem);
    }

    public static SqlExpr push(E_LessThanOrEqual expr, SqlExprList args) {
        return S_LessThanOrEqual.create(args.get(0), args.get(1), datatypeSystem);
    }

    public static SqlExpr push(E_OneOf expr, SqlExprList args) {
        ArrayList<SqlExpr> equals = new ArrayList<SqlExpr>();
        SqlExpr first = args.get(0);
        for (int i = 1; i < args.size(); ++i) {
            SqlExpr second = args.get(i);
            equals.add(S_Equals.create(first, second, datatypeSystem));
        }
        if (equals.size() == 1) {
            return (SqlExpr)equals.get(0);
        }
        ArrayList current = new ArrayList();
        ArrayList<SqlExpr> next = equals;
        while (next.size() > 1) {
            ArrayList<SqlExpr> tmp = next;
            next = current;
            current = tmp;
            next.clear();
            for (int i = 0; i < current.size(); i += 2) {
                SqlExpr a = (SqlExpr)current.get(i);
                if (i + 1 >= current.size()) {
                    next.add(a);
                    continue;
                }
                SqlExpr b = (SqlExpr)current.get(i + 1);
                next.add(new S_LogicalOr(a, b));
            }
        }
        SqlExpr result = (SqlExpr)next.get(0);
        return result;
    }

    public static SqlExpr push(E_Intersects expr, SqlExprList args) {
        return S_Intersects.create(args.get(0), args.get(1));
    }

    public static SqlExpr push(E_GenericSqlExpr expr, SqlExprList args) {
        return expr.getFuncDef().create(args);
    }

    public static SqlExpr push(E_GeographyFromText expr, SqlExprList args) {
        return new S_GeographyFromText(args.get(0));
    }

    public static SqlExpr push(E_GeomFromText expr, SqlExprList args) {
        return new S_GeometryFromText(args.get(0));
    }

    public static SqlExpr push(E_StrDatatype expr, SqlExprList args) {
        if (!(args.get(1) instanceof SqlExprValue)) {
            throw new RuntimeException("Only constants supported for casts");
        }
        return S_Cast.create(args.get(0), ((SqlExprValue)args.get(1)).getObject().toString(), datatypeSystem);
    }

    public static SqlExpr push(E_Regex expr, SqlExprList args) {
        String flags = args.size() == 3 ? args.get(2).toString() : "";
        String pattern = args.get(1).toString();
        return new S_Regex(args.get(0), pattern, flags);
    }
}

