/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.compile.sparql;

import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.BindingRoot;
import com.hp.hpl.jena.sparql.expr.E_Equals;
import com.hp.hpl.jena.sparql.expr.E_Function;
import com.hp.hpl.jena.sparql.expr.E_GreaterThan;
import com.hp.hpl.jena.sparql.expr.E_GreaterThanOrEqual;
import com.hp.hpl.jena.sparql.expr.E_LessThan;
import com.hp.hpl.jena.sparql.expr.E_LessThanOrEqual;
import com.hp.hpl.jena.sparql.expr.E_NotEquals;
import com.hp.hpl.jena.sparql.expr.E_Regex;
import com.hp.hpl.jena.sparql.expr.E_StrConcat;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprFunction;
import com.hp.hpl.jena.sparql.expr.ExprFunction2;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.expr.ExprVar;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.commons.factory.Factory1;
import org.aksw.commons.factory.Factory2;
import org.aksw.commons.util.Pair;
import org.aksw.commons.util.reflect.MultiMethod;
import org.aksw.sparqlify.algebra.sparql.expr.E_RdfTerm;
import org.aksw.sparqlify.algebra.sparql.expr.E_StrConcatPermissive;
import org.aksw.sparqlify.algebra.sql.exprs.S_Concat;
import org.aksw.sparqlify.algebra.sql.exprs.S_Equals;
import org.aksw.sparqlify.algebra.sql.exprs.S_Function;
import org.aksw.sparqlify.algebra.sql.exprs.S_LogicalNot;
import org.aksw.sparqlify.algebra.sql.exprs.S_Regex;
import org.aksw.sparqlify.algebra.sql.exprs.SqlExpr;
import org.aksw.sparqlify.algebra.sql.exprs.SqlExprColumn;
import org.aksw.sparqlify.algebra.sql.exprs.SqlExprValue;
import org.aksw.sparqlify.compile.sparql.Alignment;
import org.aksw.sparqlify.compile.sparql.InverseFunctionManager;
import org.aksw.sparqlify.compile.sparql.InverseFunctionManagerImpl;
import org.aksw.sparqlify.compile.sparql.SqlPrePusher;
import org.aksw.sparqlify.core.DatatypeSystemDefault;
import org.aksw.sparqlify.core.DatatypeSystemOld;
import org.aksw.sparqlify.core.transformations.SqlTranslationUtils;
import org.aksw.sparqlify.expr.util.ExprUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sparql.DnfUtils;

@Deprecated
public class SqlExprOptimizer {
    public static Logger logger = LoggerFactory.getLogger(SqlExprOptimizer.class);
    public static Map<Class, Class> functionToInverse;
    private static DatatypeSystemOld datatypeSystem;
    private static InverseFunctionManager<Expr> inverseFunctionManager;

    public static Expr optimizeMM(Expr expr) {
        Expr result = (Expr)MultiMethod.invokeStatic(SqlExprOptimizer.class, (String)"optimize", (Object[])new Object[]{expr});
        result = result.copySubstitute(BindingRoot.create(), true);
        Set<Set<Expr>> dnf = DnfUtils.toSetDnf(result);
        result = DnfUtils.dnfToExpr(dnf, true);
        return result;
    }

    public static Expr optimize(Expr expr) {
        return expr;
    }

    public static Expr optimize(ExprFunction expr) {
        return expr;
    }

    public static List<Expr> optimizeList(List<Expr> exprs) {
        ArrayList<Expr> result = new ArrayList<Expr>();
        for (Expr expr : exprs) {
            result.add(expr == null ? null : SqlExprOptimizer.optimize(expr));
        }
        return result;
    }

    public static Expr optimize(ExprFunction2 expr) {
        return expr.copy(SqlExprOptimizer.optimizeMM(expr.getArg1()), SqlExprOptimizer.optimizeMM(expr.getArg2()));
    }

    public static Expr optimize(E_LessThan expr) {
        return SqlExprOptimizer.optimizeCompare((ExprFunction2)expr);
    }

    public static Expr optimize(E_LessThanOrEqual expr) {
        return SqlExprOptimizer.optimizeCompare((ExprFunction2)expr);
    }

    public static Expr optimize(E_GreaterThan expr) {
        return SqlExprOptimizer.optimizeCompare((ExprFunction2)expr);
    }

    public static Expr optimize(E_GreaterThanOrEqual expr) {
        return SqlExprOptimizer.optimizeCompare((ExprFunction2)expr);
    }

    public static Expr optimizeCompare(ExprFunction2 expr) {
        return SqlExprOptimizer.optimizeCompare(expr.getArg1(), expr.getArg2(), expr.getClass());
    }

    public static Expr optimizeCompare(Expr a, Expr b, final Class<?> clazz) {
        Factory2<Expr> factory = new Factory2<Expr>(){

            @Override
            public Expr create(Expr a, Expr b) {
                try {
                    Constructor<?> ctor = clazz.getConstructors()[0];
                    return (Expr)ctor.newInstance(a, b);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
        return SqlExprOptimizer.optimizeCompare(a, b, factory);
    }

    public static Expr optimizeCompare(Expr ea, Expr eb, Factory2<Expr> factory) {
        Expr oa = SqlExprOptimizer.optimizeMM(ea);
        Expr ob = SqlExprOptimizer.optimizeMM(eb);
        E_RdfTerm a = SqlPrePusher.asRdfTerm(oa);
        E_RdfTerm b = SqlPrePusher.asRdfTerm(ob);
        if (a == null || b == null) {
            logger.warn("Arguments are no ExprRdfTerms");
            return factory.create(oa, ob);
        }
        NodeValue zero = NodeValue.makeInteger((long)0L);
        NodeValue one = NodeValue.makeInteger((long)1L);
        NodeValue two = NodeValue.makeInteger((long)2L);
        NodeValue three = NodeValue.makeInteger((long)3L);
        Expr result = ExprUtils.andifyBalanced(factory.create(a.getLexicalValue(), b.getLexicalValue()));
        return result;
    }

    public static <T> Pair<T, T> createPair(T a, T b, boolean swapArgs) {
        return swapArgs ? new Pair(b, a) : new Pair(a, b);
    }

    public static Pair<Expr, Expr> optimizeFunctionOpConstant(Expr a, Expr b) {
        NodeValue constant = null;
        ExprFunction function = null;
        boolean swapArgs = false;
        if (a.isConstant() && b.isFunction()) {
            constant = a.getConstant();
            function = b.getFunction();
        } else if (a.isFunction() && b.isConstant()) {
            function = a.getFunction();
            constant = b.getConstant();
            swapArgs = true;
        } else {
            return Pair.create((Object)a, (Object)b);
        }
        Factory1<Expr> factory = inverseFunctionManager.getInverse(b.getFunction().getFunctionIRI());
        if (factory == null) {
            return Pair.create((Object)a, (Object)b);
        }
        Expr invConst = factory.create((Expr)constant);
        NodeValue resultConst = com.hp.hpl.jena.sparql.util.ExprUtils.eval((Expr)invConst);
        Expr resultFunc = function.getArg(1);
        return SqlExprOptimizer.createPair(resultConst, resultFunc, swapArgs);
    }

    public static Expr optimize(E_Equals expr) {
        Expr expr2 = SqlTranslationUtils.optimizeRdfTerm(expr = new E_Equals(SqlExprOptimizer.optimizeMM(expr.getArg1()), SqlExprOptimizer.optimizeMM(expr.getArg2())));
        if (expr2 != expr) {
            return SqlExprOptimizer.optimizeMM(expr2);
        }
        Expr result = SqlTranslationUtils.optimizeOpConcat((ExprFunction2)expr);
        if (result instanceof E_Equals) {
            result = SqlTranslationUtils.optimizeRdfTerm((E_Equals)result);
        }
        if (!result.equals(expr)) {
            result = SqlExprOptimizer.optimizeMM(result);
        }
        return result;
    }

    public static List<Alignment> toAlignment(List<Expr> a, List<List<Expr>> bs) {
        ArrayList<Alignment> result = new ArrayList<Alignment>();
        for (List<Expr> b : bs) {
            result.add(new Alignment(a, b));
        }
        return result;
    }

    public static List<Alignment> align(List<Expr> a, List<Expr> b) {
        List<Alignment> result;
        ArrayList<List<Expr>> tmp = new ArrayList<List<Expr>>();
        if (a.size() > b.size()) {
            SqlExprOptimizer.alignRec(a, 0, b, 0, tmp);
            result = SqlExprOptimizer.toAlignment(a, tmp);
        } else if (a.size() < b.size()) {
            SqlExprOptimizer.alignRec(b, 0, a, 0, tmp);
            result = SqlExprOptimizer.toAlignment(b, tmp);
        } else {
            result = Collections.singletonList(new Alignment(a, b));
        }
        return result;
    }

    public static int indexOfFirstConstant(List<Expr> a, int offset) {
        for (int i = offset; i < a.size(); ++i) {
            Expr ea = a.get(i);
            if (!ea.isConstant()) continue;
            return i;
        }
        return -1;
    }

    public static List<Expr> copyReplace(List<Expr> a, int itemIndex, String[] parts) {
        int i;
        ArrayList<Expr> result = new ArrayList<Expr>(a.size() + parts.length - 1);
        for (i = 0; i < itemIndex; ++i) {
            result.add(a.get(i));
        }
        for (i = 0; i < parts.length; ++i) {
            result.add((Expr)NodeValue.makeString((String)parts[i]));
        }
        for (i = itemIndex + 1; i < a.size(); ++i) {
            result.add(a.get(i));
        }
        return result;
    }

    public static String[] split(String str, int i, int l) {
        int n = 1;
        if (i > 0) {
            ++n;
        }
        if (i + l < str.length()) {
            ++n;
        }
        String[] result = new String[n];
        int j = 0;
        if (i > 0) {
            result[j++] = str.substring(0, i);
        }
        result[j++] = str.substring(i, i + l);
        if (i + l < str.length()) {
            result[j++] = str.substring(i + l, str.length());
        }
        return result;
    }

    public static void alignRec(List<Expr> a, int oa, List<Expr> b, int ob, List<List<Expr>> result) {
        int i = SqlExprOptimizer.indexOfFirstConstant(a, oa);
        if (i < 0) {
            result.add(b);
            return;
        }
        Expr ea = a.get(i);
        String sa = ea.getConstant().asUnquotedString();
        block0: for (int j = ob; j < b.size(); ++j) {
            Expr eb = b.get(j);
            if (!eb.isConstant()) continue;
            String sb = eb.getConstant().asUnquotedString();
            int k = 0;
            while ((k = sb.indexOf(sa, k)) >= 0) {
                if (i == 0 && k != 0) continue;
                if (i == a.size() - 1 && k + sa.length() != sb.length()) continue block0;
                String[] parts = SqlExprOptimizer.split(sb, k, sa.length());
                List<Expr> subB = SqlExprOptimizer.copyReplace(b, j, parts);
                SqlExprOptimizer.alignRec(a, i + 1, subB, j + parts.length - 1, result);
                k += sa.length();
            }
        }
    }

    public static Expr optimizeEqualsConcat2(List<Expr> la, List<Expr> lb) {
        int i;
        Expr b;
        Expr a;
        int c;
        Expr b2;
        Expr a2 = la.get(0);
        if (a2.equals(b2 = lb.get(0))) {
            la.remove(0);
            lb.remove(0);
        } else if (a2.isConstant() && b2.isConstant()) {
            String delta;
            String sb;
            String sa = a2.getConstant().asUnquotedString();
            if (sa.startsWith(sb = b2.getConstant().asUnquotedString())) {
                delta = sa.substring(sb.length());
                if (delta.isEmpty()) {
                    la.remove(0);
                } else {
                    la.set(0, (Expr)NodeValue.makeString((String)delta));
                }
                lb.remove(0);
            } else if (sb.startsWith(sa)) {
                delta = sb.substring(sa.length());
                if (delta.isEmpty()) {
                    lb.remove(0);
                } else {
                    lb.set(0, (Expr)NodeValue.makeString((String)delta));
                }
                la.remove(0);
                lb.set(0, (Expr)NodeValue.makeString((String)delta));
            }
        }
        int n = Math.min(la.size(), lb.size());
        boolean sameLength = la.size() == lb.size();
        for (c = 0; c < n && (a = la.get(c)).equals(b = lb.get(c)); ++c) {
        }
        if (sameLength) {
            if (c == n) {
                return NodeValue.TRUE;
            }
            if (c + 1 == n) {
                return new E_Equals(la.get(c), lb.get(c));
            }
        }
        if (c == 0) {
            if (lb.size() == 0) {
                throw new IndexOutOfBoundsException();
            }
            a = la.get(0);
            b = lb.get(0);
            if (a.isConstant() && b.isConstant()) {
                return NodeValue.FALSE;
            }
            return null;
        }
        ExprList na = new ExprList();
        ExprList nb = new ExprList();
        for (i = c; i < la.size(); ++i) {
            na.add(la.get(i));
        }
        for (i = c; i < lb.size(); ++i) {
            nb.add(lb.get(i));
        }
        return new E_Equals((Expr)new E_StrConcat(na), (Expr)new E_StrConcat(nb));
    }

    public static SqlExpr translateMM(Expr expr) {
        return (SqlExpr)MultiMethod.invokeStatic(SqlExprOptimizer.class, (String)"translate", (Object[])new Object[]{expr});
    }

    public static List<SqlExpr> translateArgs(Iterable<Expr> exprs) {
        ArrayList<SqlExpr> result = new ArrayList<SqlExpr>();
        for (Expr arg : exprs) {
            SqlExpr sqlArg = SqlExprOptimizer.translateMM(arg);
            result.add(sqlArg);
        }
        return result;
    }

    public static SqlExpr translate(E_Regex expr) {
        List<SqlExpr> sqlExprs = SqlExprOptimizer.translateArgs(expr.getArgs());
        String flags = sqlExprs.size() == 3 ? sqlExprs.get(2).toString() : "";
        String pattern = sqlExprs.get(1).toString();
        return new S_Regex(sqlExprs.get(0), pattern, flags);
    }

    public static SqlExpr translate(E_StrConcatPermissive expr) {
        return new S_Concat(SqlExprOptimizer.translateArgs(expr.getArgs()));
    }

    public static SqlExpr translate(ExprFunction expr) {
        ArrayList<SqlExpr> list = new ArrayList<SqlExpr>();
        for (Expr arg : expr.getArgs()) {
            SqlExpr sqlArg = SqlExprOptimizer.translateMM(arg);
            list.add(sqlArg);
        }
        System.err.println("Warning: 1 No datatype handling - using String");
        return new S_Function(expr.getFunctionSymbol().getSymbol(), list, DatatypeSystemDefault._STRING);
    }

    public static SqlExpr translate(E_Function expr) {
        ArrayList<SqlExpr> list = new ArrayList<SqlExpr>();
        for (Expr arg : expr.getArgs()) {
            SqlExpr sqlArg = SqlExprOptimizer.translateMM(arg);
            list.add(sqlArg);
        }
        System.err.println("Warning: 2 No datatype handling - using String");
        return new S_Function(expr.getFunctionIRI(), list, DatatypeSystemDefault._STRING);
    }

    public static SqlExprColumn translateVar(Var var) {
        String[] parts = var.getName().split("\\.", 2);
        String tableName = parts.length == 1 ? null : parts[0];
        String colName = parts[parts.length - 1];
        System.err.println("Warning: 3 No datatype handling - using String");
        return new SqlExprColumn(tableName, colName, DatatypeSystemDefault._STRING);
    }

    public static SqlExpr translate(ExprVar expr) {
        return SqlExprOptimizer.translateVar(expr.asVar());
    }

    public static SqlExpr translate(NodeValue expr) {
        if (expr.isNumber()) {
            return new SqlExprValue(expr.getDecimal());
        }
        if (expr.isBoolean()) {
            return new SqlExprValue(expr.getBoolean());
        }
        if (expr.isString()) {
            return new SqlExprValue(expr.asString());
        }
        throw new RuntimeException("Unsupported datatype");
    }

    public static SqlExpr translate(E_NotEquals expr) {
        return new S_LogicalNot(SqlExprOptimizer.translateMM((Expr)new E_Equals(expr.getArg1(), expr.getArg2())));
    }

    public static SqlExpr translate(E_StrConcat expr) {
        return new S_Concat(SqlExprOptimizer.translateList(expr.getArgs()));
    }

    public static SqlExpr translate(E_Equals expr) {
        SqlExpr a = SqlExprOptimizer.translateMM(expr.getArg1());
        SqlExpr b = SqlExprOptimizer.translateMM(expr.getArg2());
        return S_Equals.create(a, b, datatypeSystem);
    }

    public static List<SqlExpr> translateList(List<Expr> exprs) {
        ArrayList<SqlExpr> result = new ArrayList<SqlExpr>();
        for (Expr item : exprs) {
            result.add(item == null ? null : SqlExprOptimizer.translateMM(item));
        }
        return result;
    }

    static {
        datatypeSystem = new DatatypeSystemDefault();
        inverseFunctionManager = InverseFunctionManagerImpl.getInstance();
    }
}

