/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.algebra.sql.exprs;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.aksw.sparqlify.algebra.sql.exprs.SqlExpr;
import org.aksw.sparqlify.algebra.sql.exprs.SqlExprColumn;
import org.aksw.sparqlify.core.SqlDatatype;
import org.apache.jena.atlas.io.IndentedWriter;

public abstract class SqlExprBase
implements SqlExpr {
    private SqlDatatype datatype;

    public SqlExprBase(SqlDatatype datatype) {
        this.datatype = datatype;
        if (datatype == null) {
            throw new NullPointerException();
        }
    }

    @Override
    public SqlDatatype getDatatype() {
        return this.datatype;
    }

    public String toString() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IndentedWriter writer = new IndentedWriter((OutputStream)out);
        this.asString(writer);
        return out.toString();
    }

    @Override
    public void asString(IndentedWriter writer) {
        SqlExprBase.asString(writer, this.getClass().getSimpleName(), this.getArgs());
    }

    public static void asString(IndentedWriter writer, String nodeName, SqlExpr ... args) {
        SqlExprBase.asString(writer, nodeName, Arrays.asList(args));
    }

    public static void asString(IndentedWriter writer, String nodeName, List<SqlExpr> args) {
        writer.println("(" + nodeName);
        writer.incIndent();
        for (SqlExpr arg : args) {
            arg.asString(writer);
        }
        writer.decIndent();
        writer.println(")");
    }

    public static Set<SqlExprColumn> getColumnsMentioned(SqlExpr expr) {
        HashSet<SqlExprColumn> result = new HashSet<SqlExprColumn>();
        SqlExprBase._getColumnsMentioned(result, expr);
        return result;
    }

    public static void _getColumnsMentioned(Set<SqlExprColumn> result, SqlExpr expr) {
        if (expr instanceof SqlExprColumn) {
            result.add((SqlExprColumn)expr);
            return;
        }
        for (SqlExpr arg : expr.getArgs()) {
            SqlExprBase._getColumnsMentioned(result, arg);
        }
    }
}

