// $ANTLR 3.5 org/aksw/sparqlify/config/lang/SparqlifyConfig.g 2014-05-31 16:27:58

    package org.aksw.sparqlify.config.lang;
    
    import org.slf4j.Logger;


import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;

import org.antlr.runtime.tree.*;


/**
 * @author Simone Tripodi   (simone.tripodi)
 * @author Michele Mostarda (michele.mostarda)
 * @author Juergen Pfundt   (Juergen.Pfundt)
 * @version $Id$
 */
@SuppressWarnings("all")
public class SparqlifyConfigParser extends Parser {
	public static final String[] tokenNames = new String[] {
		"<invalid>", "<EOR>", "<DOWN>", "<UP>", "A", "ABS", "ADD", "ALIASED_LOGICAL_TABLE", 
		"ALIASED_VAR", "ALL", "AND", "ANY", "ARG_LIST", "AS", "ASC", "ASK", "ASTERISK", 
		"AVG", "BASE", "BIND", "BINDINGS", "BINDING_VALUE", "BLANK_NODE", "BLANK_NODE_LABEL", 
		"BNODE", "BOUND", "BY", "CEIL", "CLEAR", "CLOSE_BRACE", "CLOSE_CURLY_BRACE", 
		"CLOSE_SQUARE_BRACKET", "COALESCE", "COLLECTION", "COMMA", "COMMENT", 
		"CONCAT", "CONSTRAIN", "CONSTRAINTS", "CONSTRUCT", "CONSTRUCT_QUADS", 
		"CONSTRUCT_TRIPLES", "CONSTRUCT_VIEW_DEFINITION", "CONTAINS", "COPY", 
		"COUNT", "CREATE", "DATA", "DATATYPE", "DAY", "DECIMAL", "DECIMAL_NEGATIVE", 
		"DECIMAL_POSITIVE", "DECLARE", "DEFAULT", "DEFINE", "DELETE", "DESC", 
		"DESCRIBE", "DIGIT", "DISTINCT", "DIVIDE", "DOT", "DOUBLE", "DOUBLE_NEGATIVE", 
		"DOUBLE_POSITIVE", "DROP", "ECHAR", "ENCODE_FOR_URI", "EOL", "EQUAL", 
		"EXISTS", "EXPONENT", "EXPRESSION_LIST", "FALSE", "FILTER", "FLOOR", "FROM", 
		"FULL_JOIN", "FUNCTION", "FUNCTION_DECLARATION", "FUNCTION_SIGNATURE", 
		"FUNCTION_TEMPLATE", "GRAPH", "GRAPH_TOKEN", "GREATER", "GREATER_EQUAL", 
		"GROUP", "GROUP_BY", "GROUP_CONCAT", "GROUP_GRAPH_PATTERN", "HAVING", 
		"HOURS", "IF", "IMPORT", "IN", "INSERT", "INTEGER", "INTEGER_NEGATIVE", 
		"INTEGER_POSITIVE", "INTO", "INVERSE", "IRI", "IRI_REF", "IRI_REF_CHARACTERS", 
		"ISBLANK", "ISIRI", "ISLITERAL", "ISNUMERIC", "ISURI", "JOIN_MEMBER", 
		"LANG", "LANGMATCHES", "LANGTAG", "LANGTAG_STR", "LCASE", "LESS", "LESS_EQUAL", 
		"LIMIT", "LOAD", "MACRO_DEF", "MAX", "MD5", "MIN", "MINUS", "MINUS_KEYWORD", 
		"MINUTES", "MODIFY", "MONTH", "MOVE", "NAME", "NAMED", "NAMED_VIEW_TEMPLATE_DEFINITION", 
		"NAME_SUFFIX", "NEGATION", "NESTED_ML_COMMENT", "NOT", "NOT_EQUAL", "NOT_EXISTS", 
		"NOW", "OBJECT", "OFFSET", "OPEN_BRACE", "OPEN_CURLY_BRACE", "OPEN_SQUARE_BRACKET", 
		"OPTIONAL", "OR", "ORDER", "ORDER_BY", "ORDER_CONDITION", "PARAM_TYPE", 
		"PARAM_TYPE_LIST", "PATH", "PATH_NEGATED", "PATH_PRIMARY", "PIPE", "PLAIN_LITERAL", 
		"PLUS", "PNAME_LN", "PNAME_NS", "PN_CHARS", "PN_CHARS_BASE", "PN_CHARS_U", 
		"PN_LOCAL", "PN_PREFIX", "PREDICATE", "PREFIX", "PREFIX_CONSTRAINT", "PREFIX_DECL", 
		"PROLOGUE", "PROPERTY_LIST", "QUERY", "QUESTION_MARK", "RAND", "REDUCED", 
		"REFERENCE", "REGEX", "REGEX_CONSTRAINT", "RELATION_REF", "ROUND", "SAMETERM", 
		"SAMPLE", "SECONDS", "SELECT", "SELECT_CLAUSE", "SEMICOLON", "SEPARATOR", 
		"SERVICE", "SET", "SHA1", "SHA224", "SHA256", "SHA384", "SHA512", "SIGN", 
		"SILENT", "SINGLE_LINE_COMMENT", "SQL_QUERY", "SQL_RELATION", "SQL_TABLE", 
		"STR", "STRDT", "STRENDS", "STRING_LIST", "STRING_LITERAL1", "STRING_LITERAL2", 
		"STRING_LITERAL_LONG1", "STRING_LITERAL_LONG2", "STRLANG", "STRLEN", "STRSTARTS", 
		"SUBJECT", "SUBSELECT", "SUBSTR", "SUM", "TEMPLATE", "TIMEZONE", "TO", 
		"TODO", "TRIPLE", "TRIPLES_BLOCK", "TRIPLES_TEMPLATE", "TRUE", "TYPED_LITERAL", 
		"TZ", "UCASE", "UNARY", "UNARY_MINUS", "UNARY_NOT", "UNARY_PLUS", "UNDEF", 
		"UNION", "UPDATE", "URI", "USING", "VAR", "VAR1", "VAR2", "VAR3", "VARNAME", 
		"VAR_BINDING", "VAR_BINDINGS", "VAR_HEAD", "VIEW", "VIEW_DEFINITION", 
		"VIEW_TEMPLATE_DEFINITION", "WHERE", "WHERE_CLAUSE", "WITH", "WS", "YEAR"
	};
	public static final int EOF=-1;
	public static final int A=4;
	public static final int ABS=5;
	public static final int ADD=6;
	public static final int ALIASED_LOGICAL_TABLE=7;
	public static final int ALIASED_VAR=8;
	public static final int ALL=9;
	public static final int AND=10;
	public static final int ANY=11;
	public static final int ARG_LIST=12;
	public static final int AS=13;
	public static final int ASC=14;
	public static final int ASK=15;
	public static final int ASTERISK=16;
	public static final int AVG=17;
	public static final int BASE=18;
	public static final int BIND=19;
	public static final int BINDINGS=20;
	public static final int BINDING_VALUE=21;
	public static final int BLANK_NODE=22;
	public static final int BLANK_NODE_LABEL=23;
	public static final int BNODE=24;
	public static final int BOUND=25;
	public static final int BY=26;
	public static final int CEIL=27;
	public static final int CLEAR=28;
	public static final int CLOSE_BRACE=29;
	public static final int CLOSE_CURLY_BRACE=30;
	public static final int CLOSE_SQUARE_BRACKET=31;
	public static final int COALESCE=32;
	public static final int COLLECTION=33;
	public static final int COMMA=34;
	public static final int COMMENT=35;
	public static final int CONCAT=36;
	public static final int CONSTRAIN=37;
	public static final int CONSTRAINTS=38;
	public static final int CONSTRUCT=39;
	public static final int CONSTRUCT_QUADS=40;
	public static final int CONSTRUCT_TRIPLES=41;
	public static final int CONSTRUCT_VIEW_DEFINITION=42;
	public static final int CONTAINS=43;
	public static final int COPY=44;
	public static final int COUNT=45;
	public static final int CREATE=46;
	public static final int DATA=47;
	public static final int DATATYPE=48;
	public static final int DAY=49;
	public static final int DECIMAL=50;
	public static final int DECIMAL_NEGATIVE=51;
	public static final int DECIMAL_POSITIVE=52;
	public static final int DECLARE=53;
	public static final int DEFAULT=54;
	public static final int DEFINE=55;
	public static final int DELETE=56;
	public static final int DESC=57;
	public static final int DESCRIBE=58;
	public static final int DIGIT=59;
	public static final int DISTINCT=60;
	public static final int DIVIDE=61;
	public static final int DOT=62;
	public static final int DOUBLE=63;
	public static final int DOUBLE_NEGATIVE=64;
	public static final int DOUBLE_POSITIVE=65;
	public static final int DROP=66;
	public static final int ECHAR=67;
	public static final int ENCODE_FOR_URI=68;
	public static final int EOL=69;
	public static final int EQUAL=70;
	public static final int EXISTS=71;
	public static final int EXPONENT=72;
	public static final int EXPRESSION_LIST=73;
	public static final int FALSE=74;
	public static final int FILTER=75;
	public static final int FLOOR=76;
	public static final int FROM=77;
	public static final int FULL_JOIN=78;
	public static final int FUNCTION=79;
	public static final int FUNCTION_DECLARATION=80;
	public static final int FUNCTION_SIGNATURE=81;
	public static final int FUNCTION_TEMPLATE=82;
	public static final int GRAPH=83;
	public static final int GRAPH_TOKEN=84;
	public static final int GREATER=85;
	public static final int GREATER_EQUAL=86;
	public static final int GROUP=87;
	public static final int GROUP_BY=88;
	public static final int GROUP_CONCAT=89;
	public static final int GROUP_GRAPH_PATTERN=90;
	public static final int HAVING=91;
	public static final int HOURS=92;
	public static final int IF=93;
	public static final int IMPORT=94;
	public static final int IN=95;
	public static final int INSERT=96;
	public static final int INTEGER=97;
	public static final int INTEGER_NEGATIVE=98;
	public static final int INTEGER_POSITIVE=99;
	public static final int INTO=100;
	public static final int INVERSE=101;
	public static final int IRI=102;
	public static final int IRI_REF=103;
	public static final int IRI_REF_CHARACTERS=104;
	public static final int ISBLANK=105;
	public static final int ISIRI=106;
	public static final int ISLITERAL=107;
	public static final int ISNUMERIC=108;
	public static final int ISURI=109;
	public static final int JOIN_MEMBER=110;
	public static final int LANG=111;
	public static final int LANGMATCHES=112;
	public static final int LANGTAG=113;
	public static final int LANGTAG_STR=114;
	public static final int LCASE=115;
	public static final int LESS=116;
	public static final int LESS_EQUAL=117;
	public static final int LIMIT=118;
	public static final int LOAD=119;
	public static final int MACRO_DEF=120;
	public static final int MAX=121;
	public static final int MD5=122;
	public static final int MIN=123;
	public static final int MINUS=124;
	public static final int MINUS_KEYWORD=125;
	public static final int MINUTES=126;
	public static final int MODIFY=127;
	public static final int MONTH=128;
	public static final int MOVE=129;
	public static final int NAME=130;
	public static final int NAMED=131;
	public static final int NAMED_VIEW_TEMPLATE_DEFINITION=132;
	public static final int NAME_SUFFIX=133;
	public static final int NEGATION=134;
	public static final int NESTED_ML_COMMENT=135;
	public static final int NOT=136;
	public static final int NOT_EQUAL=137;
	public static final int NOT_EXISTS=138;
	public static final int NOW=139;
	public static final int OBJECT=140;
	public static final int OFFSET=141;
	public static final int OPEN_BRACE=142;
	public static final int OPEN_CURLY_BRACE=143;
	public static final int OPEN_SQUARE_BRACKET=144;
	public static final int OPTIONAL=145;
	public static final int OR=146;
	public static final int ORDER=147;
	public static final int ORDER_BY=148;
	public static final int ORDER_CONDITION=149;
	public static final int PARAM_TYPE=150;
	public static final int PARAM_TYPE_LIST=151;
	public static final int PATH=152;
	public static final int PATH_NEGATED=153;
	public static final int PATH_PRIMARY=154;
	public static final int PIPE=155;
	public static final int PLAIN_LITERAL=156;
	public static final int PLUS=157;
	public static final int PNAME_LN=158;
	public static final int PNAME_NS=159;
	public static final int PN_CHARS=160;
	public static final int PN_CHARS_BASE=161;
	public static final int PN_CHARS_U=162;
	public static final int PN_LOCAL=163;
	public static final int PN_PREFIX=164;
	public static final int PREDICATE=165;
	public static final int PREFIX=166;
	public static final int PREFIX_CONSTRAINT=167;
	public static final int PREFIX_DECL=168;
	public static final int PROLOGUE=169;
	public static final int PROPERTY_LIST=170;
	public static final int QUERY=171;
	public static final int QUESTION_MARK=172;
	public static final int RAND=173;
	public static final int REDUCED=174;
	public static final int REFERENCE=175;
	public static final int REGEX=176;
	public static final int REGEX_CONSTRAINT=177;
	public static final int RELATION_REF=178;
	public static final int ROUND=179;
	public static final int SAMETERM=180;
	public static final int SAMPLE=181;
	public static final int SECONDS=182;
	public static final int SELECT=183;
	public static final int SELECT_CLAUSE=184;
	public static final int SEMICOLON=185;
	public static final int SEPARATOR=186;
	public static final int SERVICE=187;
	public static final int SET=188;
	public static final int SHA1=189;
	public static final int SHA224=190;
	public static final int SHA256=191;
	public static final int SHA384=192;
	public static final int SHA512=193;
	public static final int SIGN=194;
	public static final int SILENT=195;
	public static final int SINGLE_LINE_COMMENT=196;
	public static final int SQL_QUERY=197;
	public static final int SQL_RELATION=198;
	public static final int SQL_TABLE=199;
	public static final int STR=200;
	public static final int STRDT=201;
	public static final int STRENDS=202;
	public static final int STRING_LIST=203;
	public static final int STRING_LITERAL1=204;
	public static final int STRING_LITERAL2=205;
	public static final int STRING_LITERAL_LONG1=206;
	public static final int STRING_LITERAL_LONG2=207;
	public static final int STRLANG=208;
	public static final int STRLEN=209;
	public static final int STRSTARTS=210;
	public static final int SUBJECT=211;
	public static final int SUBSELECT=212;
	public static final int SUBSTR=213;
	public static final int SUM=214;
	public static final int TEMPLATE=215;
	public static final int TIMEZONE=216;
	public static final int TO=217;
	public static final int TODO=218;
	public static final int TRIPLE=219;
	public static final int TRIPLES_BLOCK=220;
	public static final int TRIPLES_TEMPLATE=221;
	public static final int TRUE=222;
	public static final int TYPED_LITERAL=223;
	public static final int TZ=224;
	public static final int UCASE=225;
	public static final int UNARY=226;
	public static final int UNARY_MINUS=227;
	public static final int UNARY_NOT=228;
	public static final int UNARY_PLUS=229;
	public static final int UNDEF=230;
	public static final int UNION=231;
	public static final int UPDATE=232;
	public static final int URI=233;
	public static final int USING=234;
	public static final int VAR=235;
	public static final int VAR1=236;
	public static final int VAR2=237;
	public static final int VAR3=238;
	public static final int VARNAME=239;
	public static final int VAR_BINDING=240;
	public static final int VAR_BINDINGS=241;
	public static final int VAR_HEAD=242;
	public static final int VIEW=243;
	public static final int VIEW_DEFINITION=244;
	public static final int VIEW_TEMPLATE_DEFINITION=245;
	public static final int WHERE=246;
	public static final int WHERE_CLAUSE=247;
	public static final int WITH=248;
	public static final int WS=249;
	public static final int YEAR=250;

	// delegates
	public Parser[] getDelegates() {
		return new Parser[] {};
	}

	// delegators


	public SparqlifyConfigParser(TokenStream input) {
		this(input, new RecognizerSharedState());
	}
	public SparqlifyConfigParser(TokenStream input, RecognizerSharedState state) {
		super(input, state);
	}

	protected TreeAdaptor adaptor = new CommonTreeAdaptor();

	public void setTreeAdaptor(TreeAdaptor adaptor) {
		this.adaptor = adaptor;
	}
	public TreeAdaptor getTreeAdaptor() {
		return adaptor;
	}
	@Override public String[] getTokenNames() { return SparqlifyConfigParser.tokenNames; }
	@Override public String getGrammarFileName() { return "org/aksw/sparqlify/config/lang/SparqlifyConfig.g"; }


	    private Logger logger = null;

	    public void setLogger(Logger logger) {
	        this.logger = logger;
	    }

	    public void emitErrorMessage(String msg) {
	        if(this.logger != null) {
	        	this.logger.error(msg);
	        } else {
	        	System.err.println(msg);
	        }
	    }

		public String getErrorMessage(RecognitionException e, String[] tokenNames)
		{
		    List stack = getRuleInvocationStack(e, this.getClass().getName());
		    String msg = null;
		    if ( e instanceof NoViableAltException ) {
		       NoViableAltException nvae = (NoViableAltException)e;
		       msg = " no viable alt; token="+e.token+
		          " (decision="+nvae.decisionNumber+
		          " state "+nvae.stateNumber+")"+
		          " decision=<<"+nvae.grammarDecisionDescription+">>";
		    }
		    else if(  e instanceof FailedPredicateException  ) {
		       FailedPredicateException fpe = (FailedPredicateException)e;
		       msg = "failed predicate; token="+fpe.token+
		              " (rule="+fpe.ruleName+" predicate="+fpe.predicateText+")";
		    }
		    else {
		       msg = super.getErrorMessage(e, tokenNames);
		    }
		    return stack+" "+msg;
		}
		public String getTokenErrorDisplay(Token t) {
		    return t.toString();
		}   


	public static class sparqlifyConfig_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "sparqlifyConfig"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:166:1: sparqlifyConfig : ( sparqlifyConfigStmt )+ EOF !;
	public final SparqlifyConfigParser.sparqlifyConfig_return sparqlifyConfig() throws RecognitionException {
		SparqlifyConfigParser.sparqlifyConfig_return retval = new SparqlifyConfigParser.sparqlifyConfig_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token EOF2=null;
		ParserRuleReturnScope sparqlifyConfigStmt1 =null;

		CommonTree EOF2_tree=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:167:5: ( ( sparqlifyConfigStmt )+ EOF !)
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:167:7: ( sparqlifyConfigStmt )+ EOF !
			{
			root_0 = (CommonTree)adaptor.nil();


			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:167:7: ( sparqlifyConfigStmt )+
			int cnt1=0;
			loop1:
			while (true) {
				int alt1=2;
				int LA1_0 = input.LA(1);
				if ( (LA1_0==CREATE||LA1_0==DECLARE||LA1_0==DEFINE||LA1_0==PREFIX||LA1_0==SET) ) {
					alt1=1;
				}

				switch (alt1) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:167:7: sparqlifyConfigStmt
					{
					pushFollow(FOLLOW_sparqlifyConfigStmt_in_sparqlifyConfig272);
					sparqlifyConfigStmt1=sparqlifyConfigStmt();
					state._fsp--;

					adaptor.addChild(root_0, sparqlifyConfigStmt1.getTree());

					}
					break;

				default :
					if ( cnt1 >= 1 ) break loop1;
					EarlyExitException eee = new EarlyExitException(1, input);
					throw eee;
				}
				cnt1++;
			}

			EOF2=(Token)match(input,EOF,FOLLOW_EOF_in_sparqlifyConfig275); 
			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "sparqlifyConfig"


	public static class constructViewConfig_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "constructViewConfig"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:171:1: constructViewConfig : ( constructViewConfigStmt )+ EOF !;
	public final SparqlifyConfigParser.constructViewConfig_return constructViewConfig() throws RecognitionException {
		SparqlifyConfigParser.constructViewConfig_return retval = new SparqlifyConfigParser.constructViewConfig_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token EOF4=null;
		ParserRuleReturnScope constructViewConfigStmt3 =null;

		CommonTree EOF4_tree=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:172:5: ( ( constructViewConfigStmt )+ EOF !)
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:172:7: ( constructViewConfigStmt )+ EOF !
			{
			root_0 = (CommonTree)adaptor.nil();


			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:172:7: ( constructViewConfigStmt )+
			int cnt2=0;
			loop2:
			while (true) {
				int alt2=2;
				int LA2_0 = input.LA(1);
				if ( (LA2_0==CREATE||LA2_0==PREFIX) ) {
					alt2=1;
				}

				switch (alt2) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:172:7: constructViewConfigStmt
					{
					pushFollow(FOLLOW_constructViewConfigStmt_in_constructViewConfig294);
					constructViewConfigStmt3=constructViewConfigStmt();
					state._fsp--;

					adaptor.addChild(root_0, constructViewConfigStmt3.getTree());

					}
					break;

				default :
					if ( cnt2 >= 1 ) break loop2;
					EarlyExitException eee = new EarlyExitException(2, input);
					throw eee;
				}
				cnt2++;
			}

			EOF4=(Token)match(input,EOF,FOLLOW_EOF_in_constructViewConfig297); 
			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "constructViewConfig"


	public static class constructViewConfigStmt_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "constructViewConfigStmt"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:175:1: constructViewConfigStmt : ( viewDefStmtConstruct | prefixDefStmt );
	public final SparqlifyConfigParser.constructViewConfigStmt_return constructViewConfigStmt() throws RecognitionException {
		SparqlifyConfigParser.constructViewConfigStmt_return retval = new SparqlifyConfigParser.constructViewConfigStmt_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		ParserRuleReturnScope viewDefStmtConstruct5 =null;
		ParserRuleReturnScope prefixDefStmt6 =null;


		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:176:5: ( viewDefStmtConstruct | prefixDefStmt )
			int alt3=2;
			int LA3_0 = input.LA(1);
			if ( (LA3_0==CREATE) ) {
				alt3=1;
			}
			else if ( (LA3_0==PREFIX) ) {
				alt3=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 3, 0, input);
				throw nvae;
			}

			switch (alt3) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:176:7: viewDefStmtConstruct
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_viewDefStmtConstruct_in_constructViewConfigStmt316);
					viewDefStmtConstruct5=viewDefStmtConstruct();
					state._fsp--;

					adaptor.addChild(root_0, viewDefStmtConstruct5.getTree());

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:177:7: prefixDefStmt
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_prefixDefStmt_in_constructViewConfigStmt324);
					prefixDefStmt6=prefixDefStmt();
					state._fsp--;

					adaptor.addChild(root_0, prefixDefStmt6.getTree());

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "constructViewConfigStmt"


	public static class sparqlifyConfigStmt_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "sparqlifyConfigStmt"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:183:1: sparqlifyConfigStmt : ( viewDefStmt | prefixDefStmt | macroStmt | functionDeclarationStmt | setStmt );
	public final SparqlifyConfigParser.sparqlifyConfigStmt_return sparqlifyConfigStmt() throws RecognitionException {
		SparqlifyConfigParser.sparqlifyConfigStmt_return retval = new SparqlifyConfigParser.sparqlifyConfigStmt_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		ParserRuleReturnScope viewDefStmt7 =null;
		ParserRuleReturnScope prefixDefStmt8 =null;
		ParserRuleReturnScope macroStmt9 =null;
		ParserRuleReturnScope functionDeclarationStmt10 =null;
		ParserRuleReturnScope setStmt11 =null;


		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:184:5: ( viewDefStmt | prefixDefStmt | macroStmt | functionDeclarationStmt | setStmt )
			int alt4=5;
			switch ( input.LA(1) ) {
			case CREATE:
				{
				alt4=1;
				}
				break;
			case PREFIX:
				{
				alt4=2;
				}
				break;
			case DEFINE:
				{
				alt4=3;
				}
				break;
			case DECLARE:
				{
				alt4=4;
				}
				break;
			case SET:
				{
				alt4=5;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 4, 0, input);
				throw nvae;
			}
			switch (alt4) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:184:7: viewDefStmt
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_viewDefStmt_in_sparqlifyConfigStmt345);
					viewDefStmt7=viewDefStmt();
					state._fsp--;

					adaptor.addChild(root_0, viewDefStmt7.getTree());

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:185:7: prefixDefStmt
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_prefixDefStmt_in_sparqlifyConfigStmt353);
					prefixDefStmt8=prefixDefStmt();
					state._fsp--;

					adaptor.addChild(root_0, prefixDefStmt8.getTree());

					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:186:7: macroStmt
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_macroStmt_in_sparqlifyConfigStmt361);
					macroStmt9=macroStmt();
					state._fsp--;

					adaptor.addChild(root_0, macroStmt9.getTree());

					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:187:7: functionDeclarationStmt
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_functionDeclarationStmt_in_sparqlifyConfigStmt369);
					functionDeclarationStmt10=functionDeclarationStmt();
					state._fsp--;

					adaptor.addChild(root_0, functionDeclarationStmt10.getTree());

					}
					break;
				case 5 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:188:7: setStmt
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_setStmt_in_sparqlifyConfigStmt377);
					setStmt11=setStmt();
					state._fsp--;

					adaptor.addChild(root_0, setStmt11.getTree());

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "sparqlifyConfigStmt"


	public static class setStmt_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "setStmt"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:193:1: setStmt : SET NAME '=' string ( ';' )? -> ^( SET NAME string ) ;
	public final SparqlifyConfigParser.setStmt_return setStmt() throws RecognitionException {
		SparqlifyConfigParser.setStmt_return retval = new SparqlifyConfigParser.setStmt_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token SET12=null;
		Token NAME13=null;
		Token char_literal14=null;
		Token char_literal16=null;
		ParserRuleReturnScope string15 =null;

		CommonTree SET12_tree=null;
		CommonTree NAME13_tree=null;
		CommonTree char_literal14_tree=null;
		CommonTree char_literal16_tree=null;
		RewriteRuleTokenStream stream_SET=new RewriteRuleTokenStream(adaptor,"token SET");
		RewriteRuleTokenStream stream_NAME=new RewriteRuleTokenStream(adaptor,"token NAME");
		RewriteRuleTokenStream stream_SEMICOLON=new RewriteRuleTokenStream(adaptor,"token SEMICOLON");
		RewriteRuleTokenStream stream_EQUAL=new RewriteRuleTokenStream(adaptor,"token EQUAL");
		RewriteRuleSubtreeStream stream_string=new RewriteRuleSubtreeStream(adaptor,"rule string");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:194:5: ( SET NAME '=' string ( ';' )? -> ^( SET NAME string ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:194:7: SET NAME '=' string ( ';' )?
			{
			SET12=(Token)match(input,SET,FOLLOW_SET_in_setStmt396);  
			stream_SET.add(SET12);

			NAME13=(Token)match(input,NAME,FOLLOW_NAME_in_setStmt398);  
			stream_NAME.add(NAME13);

			char_literal14=(Token)match(input,EQUAL,FOLLOW_EQUAL_in_setStmt400);  
			stream_EQUAL.add(char_literal14);

			pushFollow(FOLLOW_string_in_setStmt402);
			string15=string();
			state._fsp--;

			stream_string.add(string15.getTree());
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:194:27: ( ';' )?
			int alt5=2;
			int LA5_0 = input.LA(1);
			if ( (LA5_0==SEMICOLON) ) {
				alt5=1;
			}
			switch (alt5) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:194:27: ';'
					{
					char_literal16=(Token)match(input,SEMICOLON,FOLLOW_SEMICOLON_in_setStmt404);  
					stream_SEMICOLON.add(char_literal16);

					}
					break;

			}

			// AST REWRITE
			// elements: string, SET, NAME
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 194:32: -> ^( SET NAME string )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:194:35: ^( SET NAME string )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot(stream_SET.nextNode(), root_1);
				adaptor.addChild(root_1, stream_NAME.nextNode());
				adaptor.addChild(root_1, stream_string.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "setStmt"


	public static class functionDeclarationStmt_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "functionDeclarationStmt"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:204:1: functionDeclarationStmt : DECLARE FUNCTION functionSignature AS functionTemplate ( ';' )? -> ^( FUNCTION_DECLARATION functionSignature functionTemplate ) ;
	public final SparqlifyConfigParser.functionDeclarationStmt_return functionDeclarationStmt() throws RecognitionException {
		SparqlifyConfigParser.functionDeclarationStmt_return retval = new SparqlifyConfigParser.functionDeclarationStmt_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token DECLARE17=null;
		Token FUNCTION18=null;
		Token AS20=null;
		Token char_literal22=null;
		ParserRuleReturnScope functionSignature19 =null;
		ParserRuleReturnScope functionTemplate21 =null;

		CommonTree DECLARE17_tree=null;
		CommonTree FUNCTION18_tree=null;
		CommonTree AS20_tree=null;
		CommonTree char_literal22_tree=null;
		RewriteRuleTokenStream stream_FUNCTION=new RewriteRuleTokenStream(adaptor,"token FUNCTION");
		RewriteRuleTokenStream stream_AS=new RewriteRuleTokenStream(adaptor,"token AS");
		RewriteRuleTokenStream stream_DECLARE=new RewriteRuleTokenStream(adaptor,"token DECLARE");
		RewriteRuleTokenStream stream_SEMICOLON=new RewriteRuleTokenStream(adaptor,"token SEMICOLON");
		RewriteRuleSubtreeStream stream_functionSignature=new RewriteRuleSubtreeStream(adaptor,"rule functionSignature");
		RewriteRuleSubtreeStream stream_functionTemplate=new RewriteRuleSubtreeStream(adaptor,"rule functionTemplate");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:205:5: ( DECLARE FUNCTION functionSignature AS functionTemplate ( ';' )? -> ^( FUNCTION_DECLARATION functionSignature functionTemplate ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:205:7: DECLARE FUNCTION functionSignature AS functionTemplate ( ';' )?
			{
			DECLARE17=(Token)match(input,DECLARE,FOLLOW_DECLARE_in_functionDeclarationStmt432);  
			stream_DECLARE.add(DECLARE17);

			FUNCTION18=(Token)match(input,FUNCTION,FOLLOW_FUNCTION_in_functionDeclarationStmt434);  
			stream_FUNCTION.add(FUNCTION18);

			pushFollow(FOLLOW_functionSignature_in_functionDeclarationStmt436);
			functionSignature19=functionSignature();
			state._fsp--;

			stream_functionSignature.add(functionSignature19.getTree());
			AS20=(Token)match(input,AS,FOLLOW_AS_in_functionDeclarationStmt438);  
			stream_AS.add(AS20);

			pushFollow(FOLLOW_functionTemplate_in_functionDeclarationStmt440);
			functionTemplate21=functionTemplate();
			state._fsp--;

			stream_functionTemplate.add(functionTemplate21.getTree());
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:205:62: ( ';' )?
			int alt6=2;
			int LA6_0 = input.LA(1);
			if ( (LA6_0==SEMICOLON) ) {
				alt6=1;
			}
			switch (alt6) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:205:62: ';'
					{
					char_literal22=(Token)match(input,SEMICOLON,FOLLOW_SEMICOLON_in_functionDeclarationStmt442);  
					stream_SEMICOLON.add(char_literal22);

					}
					break;

			}

			// AST REWRITE
			// elements: functionTemplate, functionSignature
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 206:9: -> ^( FUNCTION_DECLARATION functionSignature functionTemplate )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:206:12: ^( FUNCTION_DECLARATION functionSignature functionTemplate )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(FUNCTION_DECLARATION, "FUNCTION_DECLARATION"), root_1);
				adaptor.addChild(root_1, stream_functionSignature.nextTree());
				adaptor.addChild(root_1, stream_functionTemplate.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "functionDeclarationStmt"


	public static class functionSignature_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "functionSignature"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:209:1: functionSignature : NAME iriRef parameterTypeList -> ^( FUNCTION_SIGNATURE NAME iriRef ( parameterTypeList )? ) ;
	public final SparqlifyConfigParser.functionSignature_return functionSignature() throws RecognitionException {
		SparqlifyConfigParser.functionSignature_return retval = new SparqlifyConfigParser.functionSignature_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token NAME23=null;
		ParserRuleReturnScope iriRef24 =null;
		ParserRuleReturnScope parameterTypeList25 =null;

		CommonTree NAME23_tree=null;
		RewriteRuleTokenStream stream_NAME=new RewriteRuleTokenStream(adaptor,"token NAME");
		RewriteRuleSubtreeStream stream_iriRef=new RewriteRuleSubtreeStream(adaptor,"rule iriRef");
		RewriteRuleSubtreeStream stream_parameterTypeList=new RewriteRuleSubtreeStream(adaptor,"rule parameterTypeList");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:210:5: ( NAME iriRef parameterTypeList -> ^( FUNCTION_SIGNATURE NAME iriRef ( parameterTypeList )? ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:210:7: NAME iriRef parameterTypeList
			{
			NAME23=(Token)match(input,NAME,FOLLOW_NAME_in_functionSignature478);  
			stream_NAME.add(NAME23);

			pushFollow(FOLLOW_iriRef_in_functionSignature480);
			iriRef24=iriRef();
			state._fsp--;

			stream_iriRef.add(iriRef24.getTree());
			pushFollow(FOLLOW_parameterTypeList_in_functionSignature482);
			parameterTypeList25=parameterTypeList();
			state._fsp--;

			stream_parameterTypeList.add(parameterTypeList25.getTree());
			// AST REWRITE
			// elements: parameterTypeList, iriRef, NAME
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 211:9: -> ^( FUNCTION_SIGNATURE NAME iriRef ( parameterTypeList )? )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:211:12: ^( FUNCTION_SIGNATURE NAME iriRef ( parameterTypeList )? )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(FUNCTION_SIGNATURE, "FUNCTION_SIGNATURE"), root_1);
				adaptor.addChild(root_1, stream_NAME.nextNode());
				adaptor.addChild(root_1, stream_iriRef.nextTree());
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:211:45: ( parameterTypeList )?
				if ( stream_parameterTypeList.hasNext() ) {
					adaptor.addChild(root_1, stream_parameterTypeList.nextTree());
				}
				stream_parameterTypeList.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "functionSignature"


	public static class parameterTypeList_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "parameterTypeList"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:214:1: parameterTypeList : ( nil -> ^( PARAM_TYPE_LIST nil ) | OPEN_BRACE parameterType ( COMMA parameterType )* CLOSE_BRACE -> ^( PARAM_TYPE_LIST ( parameterType )+ ) );
	public final SparqlifyConfigParser.parameterTypeList_return parameterTypeList() throws RecognitionException {
		SparqlifyConfigParser.parameterTypeList_return retval = new SparqlifyConfigParser.parameterTypeList_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token OPEN_BRACE27=null;
		Token COMMA29=null;
		Token CLOSE_BRACE31=null;
		ParserRuleReturnScope nil26 =null;
		ParserRuleReturnScope parameterType28 =null;
		ParserRuleReturnScope parameterType30 =null;

		CommonTree OPEN_BRACE27_tree=null;
		CommonTree COMMA29_tree=null;
		CommonTree CLOSE_BRACE31_tree=null;
		RewriteRuleTokenStream stream_CLOSE_BRACE=new RewriteRuleTokenStream(adaptor,"token CLOSE_BRACE");
		RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
		RewriteRuleTokenStream stream_OPEN_BRACE=new RewriteRuleTokenStream(adaptor,"token OPEN_BRACE");
		RewriteRuleSubtreeStream stream_parameterType=new RewriteRuleSubtreeStream(adaptor,"rule parameterType");
		RewriteRuleSubtreeStream stream_nil=new RewriteRuleSubtreeStream(adaptor,"rule nil");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:215:2: ( nil -> ^( PARAM_TYPE_LIST nil ) | OPEN_BRACE parameterType ( COMMA parameterType )* CLOSE_BRACE -> ^( PARAM_TYPE_LIST ( parameterType )+ ) )
			int alt8=2;
			int LA8_0 = input.LA(1);
			if ( (LA8_0==OPEN_BRACE) ) {
				int LA8_1 = input.LA(2);
				if ( (LA8_1==CLOSE_BRACE) ) {
					alt8=1;
				}
				else if ( (LA8_1==NAME) ) {
					alt8=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 8, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 8, 0, input);
				throw nvae;
			}

			switch (alt8) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:215:4: nil
					{
					pushFollow(FOLLOW_nil_in_parameterTypeList517);
					nil26=nil();
					state._fsp--;

					stream_nil.add(nil26.getTree());
					// AST REWRITE
					// elements: nil
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 216:6: -> ^( PARAM_TYPE_LIST nil )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:216:9: ^( PARAM_TYPE_LIST nil )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(PARAM_TYPE_LIST, "PARAM_TYPE_LIST"), root_1);
						adaptor.addChild(root_1, stream_nil.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:217:7: OPEN_BRACE parameterType ( COMMA parameterType )* CLOSE_BRACE
					{
					OPEN_BRACE27=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_parameterTypeList539);  
					stream_OPEN_BRACE.add(OPEN_BRACE27);

					pushFollow(FOLLOW_parameterType_in_parameterTypeList541);
					parameterType28=parameterType();
					state._fsp--;

					stream_parameterType.add(parameterType28.getTree());
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:217:32: ( COMMA parameterType )*
					loop7:
					while (true) {
						int alt7=2;
						int LA7_0 = input.LA(1);
						if ( (LA7_0==COMMA) ) {
							alt7=1;
						}

						switch (alt7) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:217:33: COMMA parameterType
							{
							COMMA29=(Token)match(input,COMMA,FOLLOW_COMMA_in_parameterTypeList544);  
							stream_COMMA.add(COMMA29);

							pushFollow(FOLLOW_parameterType_in_parameterTypeList546);
							parameterType30=parameterType();
							state._fsp--;

							stream_parameterType.add(parameterType30.getTree());
							}
							break;

						default :
							break loop7;
						}
					}

					CLOSE_BRACE31=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_parameterTypeList550);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE31);

					// AST REWRITE
					// elements: parameterType
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 218:9: -> ^( PARAM_TYPE_LIST ( parameterType )+ )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:218:12: ^( PARAM_TYPE_LIST ( parameterType )+ )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(PARAM_TYPE_LIST, "PARAM_TYPE_LIST"), root_1);
						if ( !(stream_parameterType.hasNext()) ) {
							throw new RewriteEarlyExitException();
						}
						while ( stream_parameterType.hasNext() ) {
							adaptor.addChild(root_1, stream_parameterType.nextTree());
						}
						stream_parameterType.reset();

						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "parameterTypeList"


	public static class parameterType_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "parameterType"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:221:1: parameterType : NAME var -> ^( PARAM_TYPE NAME var ) ;
	public final SparqlifyConfigParser.parameterType_return parameterType() throws RecognitionException {
		SparqlifyConfigParser.parameterType_return retval = new SparqlifyConfigParser.parameterType_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token NAME32=null;
		ParserRuleReturnScope var33 =null;

		CommonTree NAME32_tree=null;
		RewriteRuleTokenStream stream_NAME=new RewriteRuleTokenStream(adaptor,"token NAME");
		RewriteRuleSubtreeStream stream_var=new RewriteRuleSubtreeStream(adaptor,"rule var");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:222:5: ( NAME var -> ^( PARAM_TYPE NAME var ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:222:7: NAME var
			{
			NAME32=(Token)match(input,NAME,FOLLOW_NAME_in_parameterType584);  
			stream_NAME.add(NAME32);

			pushFollow(FOLLOW_var_in_parameterType586);
			var33=var();
			state._fsp--;

			stream_var.add(var33.getTree());
			// AST REWRITE
			// elements: var, NAME
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 223:9: -> ^( PARAM_TYPE NAME var )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:223:12: ^( PARAM_TYPE NAME var )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(PARAM_TYPE, "PARAM_TYPE"), root_1);
				adaptor.addChild(root_1, stream_NAME.nextNode());
				adaptor.addChild(root_1, stream_var.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "parameterType"


	public static class functionTemplate_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "functionTemplate"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:226:1: functionTemplate : NAME expressionList -> ^( FUNCTION_TEMPLATE NAME expressionList ) ;
	public final SparqlifyConfigParser.functionTemplate_return functionTemplate() throws RecognitionException {
		SparqlifyConfigParser.functionTemplate_return retval = new SparqlifyConfigParser.functionTemplate_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token NAME34=null;
		ParserRuleReturnScope expressionList35 =null;

		CommonTree NAME34_tree=null;
		RewriteRuleTokenStream stream_NAME=new RewriteRuleTokenStream(adaptor,"token NAME");
		RewriteRuleSubtreeStream stream_expressionList=new RewriteRuleSubtreeStream(adaptor,"rule expressionList");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:227:5: ( NAME expressionList -> ^( FUNCTION_TEMPLATE NAME expressionList ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:227:7: NAME expressionList
			{
			NAME34=(Token)match(input,NAME,FOLLOW_NAME_in_functionTemplate622);  
			stream_NAME.add(NAME34);

			pushFollow(FOLLOW_expressionList_in_functionTemplate624);
			expressionList35=expressionList();
			state._fsp--;

			stream_expressionList.add(expressionList35.getTree());
			// AST REWRITE
			// elements: expressionList, NAME
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 228:9: -> ^( FUNCTION_TEMPLATE NAME expressionList )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:228:12: ^( FUNCTION_TEMPLATE NAME expressionList )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(FUNCTION_TEMPLATE, "FUNCTION_TEMPLATE"), root_1);
				adaptor.addChild(root_1, stream_NAME.nextNode());
				adaptor.addChild(root_1, stream_expressionList.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "functionTemplate"


	public static class templateConfig_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "templateConfig"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:238:1: templateConfig : ( templateConfigStmt )+ EOF !;
	public final SparqlifyConfigParser.templateConfig_return templateConfig() throws RecognitionException {
		SparqlifyConfigParser.templateConfig_return retval = new SparqlifyConfigParser.templateConfig_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token EOF37=null;
		ParserRuleReturnScope templateConfigStmt36 =null;

		CommonTree EOF37_tree=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:239:2: ( ( templateConfigStmt )+ EOF !)
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:239:4: ( templateConfigStmt )+ EOF !
			{
			root_0 = (CommonTree)adaptor.nil();


			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:239:4: ( templateConfigStmt )+
			int cnt9=0;
			loop9:
			while (true) {
				int alt9=2;
				int LA9_0 = input.LA(1);
				if ( (LA9_0==CREATE||LA9_0==PREFIX) ) {
					alt9=1;
				}

				switch (alt9) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:239:4: templateConfigStmt
					{
					pushFollow(FOLLOW_templateConfigStmt_in_templateConfig659);
					templateConfigStmt36=templateConfigStmt();
					state._fsp--;

					adaptor.addChild(root_0, templateConfigStmt36.getTree());

					}
					break;

				default :
					if ( cnt9 >= 1 ) break loop9;
					EarlyExitException eee = new EarlyExitException(9, input);
					throw eee;
				}
				cnt9++;
			}

			EOF37=(Token)match(input,EOF,FOLLOW_EOF_in_templateConfig662); 
			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "templateConfig"


	public static class templateConfigStmt_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "templateConfigStmt"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:242:1: templateConfigStmt : ( viewTemplateDefStmt | prefixDefStmt );
	public final SparqlifyConfigParser.templateConfigStmt_return templateConfigStmt() throws RecognitionException {
		SparqlifyConfigParser.templateConfigStmt_return retval = new SparqlifyConfigParser.templateConfigStmt_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		ParserRuleReturnScope viewTemplateDefStmt38 =null;
		ParserRuleReturnScope prefixDefStmt39 =null;


		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:243:2: ( viewTemplateDefStmt | prefixDefStmt )
			int alt10=2;
			int LA10_0 = input.LA(1);
			if ( (LA10_0==CREATE) ) {
				alt10=1;
			}
			else if ( (LA10_0==PREFIX) ) {
				alt10=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 10, 0, input);
				throw nvae;
			}

			switch (alt10) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:243:4: viewTemplateDefStmt
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_viewTemplateDefStmt_in_templateConfigStmt675);
					viewTemplateDefStmt38=viewTemplateDefStmt();
					state._fsp--;

					adaptor.addChild(root_0, viewTemplateDefStmt38.getTree());

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:244:4: prefixDefStmt
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_prefixDefStmt_in_templateConfigStmt680);
					prefixDefStmt39=prefixDefStmt();
					state._fsp--;

					adaptor.addChild(root_0, prefixDefStmt39.getTree());

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "templateConfigStmt"


	public static class importStmt_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "importStmt"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:247:1: importStmt : IMPORT iriOrFileRef ;
	public final SparqlifyConfigParser.importStmt_return importStmt() throws RecognitionException {
		SparqlifyConfigParser.importStmt_return retval = new SparqlifyConfigParser.importStmt_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token IMPORT40=null;
		ParserRuleReturnScope iriOrFileRef41 =null;

		CommonTree IMPORT40_tree=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:248:5: ( IMPORT iriOrFileRef )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:248:7: IMPORT iriOrFileRef
			{
			root_0 = (CommonTree)adaptor.nil();


			IMPORT40=(Token)match(input,IMPORT,FOLLOW_IMPORT_in_importStmt694); 
			IMPORT40_tree = (CommonTree)adaptor.create(IMPORT40);
			adaptor.addChild(root_0, IMPORT40_tree);

			pushFollow(FOLLOW_iriOrFileRef_in_importStmt696);
			iriOrFileRef41=iriOrFileRef();
			state._fsp--;

			adaptor.addChild(root_0, iriOrFileRef41.getTree());

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "importStmt"


	public static class iriOrFileRef_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "iriOrFileRef"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:251:1: iriOrFileRef : iriRef ;
	public final SparqlifyConfigParser.iriOrFileRef_return iriOrFileRef() throws RecognitionException {
		SparqlifyConfigParser.iriOrFileRef_return retval = new SparqlifyConfigParser.iriOrFileRef_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		ParserRuleReturnScope iriRef42 =null;


		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:252:5: ( iriRef )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:252:7: iriRef
			{
			root_0 = (CommonTree)adaptor.nil();


			pushFollow(FOLLOW_iriRef_in_iriOrFileRef713);
			iriRef42=iriRef();
			state._fsp--;

			adaptor.addChild(root_0, iriRef42.getTree());

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "iriOrFileRef"


	public static class viewDefStmt_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "viewDefStmt"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:255:1: viewDefStmt : CREATE VIEW NAME AS CONSTRUCT viewTemplateDef ( varConstraintsClause )? ( FROM relationRef )? ( ';' )? -> ^( VIEW_DEFINITION NAME viewTemplateDef ( varConstraintsClause )? ( relationRef )? ) ;
	public final SparqlifyConfigParser.viewDefStmt_return viewDefStmt() throws RecognitionException {
		SparqlifyConfigParser.viewDefStmt_return retval = new SparqlifyConfigParser.viewDefStmt_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token CREATE43=null;
		Token VIEW44=null;
		Token NAME45=null;
		Token AS46=null;
		Token CONSTRUCT47=null;
		Token FROM50=null;
		Token char_literal52=null;
		ParserRuleReturnScope viewTemplateDef48 =null;
		ParserRuleReturnScope varConstraintsClause49 =null;
		ParserRuleReturnScope relationRef51 =null;

		CommonTree CREATE43_tree=null;
		CommonTree VIEW44_tree=null;
		CommonTree NAME45_tree=null;
		CommonTree AS46_tree=null;
		CommonTree CONSTRUCT47_tree=null;
		CommonTree FROM50_tree=null;
		CommonTree char_literal52_tree=null;
		RewriteRuleTokenStream stream_AS=new RewriteRuleTokenStream(adaptor,"token AS");
		RewriteRuleTokenStream stream_CREATE=new RewriteRuleTokenStream(adaptor,"token CREATE");
		RewriteRuleTokenStream stream_NAME=new RewriteRuleTokenStream(adaptor,"token NAME");
		RewriteRuleTokenStream stream_CONSTRUCT=new RewriteRuleTokenStream(adaptor,"token CONSTRUCT");
		RewriteRuleTokenStream stream_SEMICOLON=new RewriteRuleTokenStream(adaptor,"token SEMICOLON");
		RewriteRuleTokenStream stream_VIEW=new RewriteRuleTokenStream(adaptor,"token VIEW");
		RewriteRuleTokenStream stream_FROM=new RewriteRuleTokenStream(adaptor,"token FROM");
		RewriteRuleSubtreeStream stream_relationRef=new RewriteRuleSubtreeStream(adaptor,"rule relationRef");
		RewriteRuleSubtreeStream stream_viewTemplateDef=new RewriteRuleSubtreeStream(adaptor,"rule viewTemplateDef");
		RewriteRuleSubtreeStream stream_varConstraintsClause=new RewriteRuleSubtreeStream(adaptor,"rule varConstraintsClause");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:256:5: ( CREATE VIEW NAME AS CONSTRUCT viewTemplateDef ( varConstraintsClause )? ( FROM relationRef )? ( ';' )? -> ^( VIEW_DEFINITION NAME viewTemplateDef ( varConstraintsClause )? ( relationRef )? ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:256:7: CREATE VIEW NAME AS CONSTRUCT viewTemplateDef ( varConstraintsClause )? ( FROM relationRef )? ( ';' )?
			{
			CREATE43=(Token)match(input,CREATE,FOLLOW_CREATE_in_viewDefStmt730);  
			stream_CREATE.add(CREATE43);

			VIEW44=(Token)match(input,VIEW,FOLLOW_VIEW_in_viewDefStmt732);  
			stream_VIEW.add(VIEW44);

			NAME45=(Token)match(input,NAME,FOLLOW_NAME_in_viewDefStmt734);  
			stream_NAME.add(NAME45);

			AS46=(Token)match(input,AS,FOLLOW_AS_in_viewDefStmt736);  
			stream_AS.add(AS46);

			CONSTRUCT47=(Token)match(input,CONSTRUCT,FOLLOW_CONSTRUCT_in_viewDefStmt738);  
			stream_CONSTRUCT.add(CONSTRUCT47);

			pushFollow(FOLLOW_viewTemplateDef_in_viewDefStmt740);
			viewTemplateDef48=viewTemplateDef();
			state._fsp--;

			stream_viewTemplateDef.add(viewTemplateDef48.getTree());
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:256:53: ( varConstraintsClause )?
			int alt11=2;
			int LA11_0 = input.LA(1);
			if ( (LA11_0==CONSTRAIN) ) {
				alt11=1;
			}
			switch (alt11) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:256:53: varConstraintsClause
					{
					pushFollow(FOLLOW_varConstraintsClause_in_viewDefStmt742);
					varConstraintsClause49=varConstraintsClause();
					state._fsp--;

					stream_varConstraintsClause.add(varConstraintsClause49.getTree());
					}
					break;

			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:256:75: ( FROM relationRef )?
			int alt12=2;
			int LA12_0 = input.LA(1);
			if ( (LA12_0==FROM) ) {
				alt12=1;
			}
			switch (alt12) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:256:76: FROM relationRef
					{
					FROM50=(Token)match(input,FROM,FOLLOW_FROM_in_viewDefStmt746);  
					stream_FROM.add(FROM50);

					pushFollow(FOLLOW_relationRef_in_viewDefStmt748);
					relationRef51=relationRef();
					state._fsp--;

					stream_relationRef.add(relationRef51.getTree());
					}
					break;

			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:256:95: ( ';' )?
			int alt13=2;
			int LA13_0 = input.LA(1);
			if ( (LA13_0==SEMICOLON) ) {
				alt13=1;
			}
			switch (alt13) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:256:95: ';'
					{
					char_literal52=(Token)match(input,SEMICOLON,FOLLOW_SEMICOLON_in_viewDefStmt752);  
					stream_SEMICOLON.add(char_literal52);

					}
					break;

			}

			// AST REWRITE
			// elements: relationRef, NAME, varConstraintsClause, viewTemplateDef
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 257:6: -> ^( VIEW_DEFINITION NAME viewTemplateDef ( varConstraintsClause )? ( relationRef )? )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:257:9: ^( VIEW_DEFINITION NAME viewTemplateDef ( varConstraintsClause )? ( relationRef )? )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(VIEW_DEFINITION, "VIEW_DEFINITION"), root_1);
				adaptor.addChild(root_1, stream_NAME.nextNode());
				adaptor.addChild(root_1, stream_viewTemplateDef.nextTree());
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:257:48: ( varConstraintsClause )?
				if ( stream_varConstraintsClause.hasNext() ) {
					adaptor.addChild(root_1, stream_varConstraintsClause.nextTree());
				}
				stream_varConstraintsClause.reset();

				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:257:70: ( relationRef )?
				if ( stream_relationRef.hasNext() ) {
					adaptor.addChild(root_1, stream_relationRef.nextTree());
				}
				stream_relationRef.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "viewDefStmt"


	public static class viewDefStmtConstruct_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "viewDefStmtConstruct"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:260:1: viewDefStmtConstruct : CREATE CONSTRUCT VIEW NAME AS SQL_QUERY ( ';' )? -> ^( CONSTRUCT_VIEW_DEFINITION NAME SQL_QUERY ) ;
	public final SparqlifyConfigParser.viewDefStmtConstruct_return viewDefStmtConstruct() throws RecognitionException {
		SparqlifyConfigParser.viewDefStmtConstruct_return retval = new SparqlifyConfigParser.viewDefStmtConstruct_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token CREATE53=null;
		Token CONSTRUCT54=null;
		Token VIEW55=null;
		Token NAME56=null;
		Token AS57=null;
		Token SQL_QUERY58=null;
		Token char_literal59=null;

		CommonTree CREATE53_tree=null;
		CommonTree CONSTRUCT54_tree=null;
		CommonTree VIEW55_tree=null;
		CommonTree NAME56_tree=null;
		CommonTree AS57_tree=null;
		CommonTree SQL_QUERY58_tree=null;
		CommonTree char_literal59_tree=null;
		RewriteRuleTokenStream stream_AS=new RewriteRuleTokenStream(adaptor,"token AS");
		RewriteRuleTokenStream stream_CREATE=new RewriteRuleTokenStream(adaptor,"token CREATE");
		RewriteRuleTokenStream stream_NAME=new RewriteRuleTokenStream(adaptor,"token NAME");
		RewriteRuleTokenStream stream_SQL_QUERY=new RewriteRuleTokenStream(adaptor,"token SQL_QUERY");
		RewriteRuleTokenStream stream_CONSTRUCT=new RewriteRuleTokenStream(adaptor,"token CONSTRUCT");
		RewriteRuleTokenStream stream_SEMICOLON=new RewriteRuleTokenStream(adaptor,"token SEMICOLON");
		RewriteRuleTokenStream stream_VIEW=new RewriteRuleTokenStream(adaptor,"token VIEW");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:261:5: ( CREATE CONSTRUCT VIEW NAME AS SQL_QUERY ( ';' )? -> ^( CONSTRUCT_VIEW_DEFINITION NAME SQL_QUERY ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:261:7: CREATE CONSTRUCT VIEW NAME AS SQL_QUERY ( ';' )?
			{
			CREATE53=(Token)match(input,CREATE,FOLLOW_CREATE_in_viewDefStmtConstruct791);  
			stream_CREATE.add(CREATE53);

			CONSTRUCT54=(Token)match(input,CONSTRUCT,FOLLOW_CONSTRUCT_in_viewDefStmtConstruct793);  
			stream_CONSTRUCT.add(CONSTRUCT54);

			VIEW55=(Token)match(input,VIEW,FOLLOW_VIEW_in_viewDefStmtConstruct795);  
			stream_VIEW.add(VIEW55);

			NAME56=(Token)match(input,NAME,FOLLOW_NAME_in_viewDefStmtConstruct797);  
			stream_NAME.add(NAME56);

			AS57=(Token)match(input,AS,FOLLOW_AS_in_viewDefStmtConstruct799);  
			stream_AS.add(AS57);

			SQL_QUERY58=(Token)match(input,SQL_QUERY,FOLLOW_SQL_QUERY_in_viewDefStmtConstruct801);  
			stream_SQL_QUERY.add(SQL_QUERY58);

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:261:47: ( ';' )?
			int alt14=2;
			int LA14_0 = input.LA(1);
			if ( (LA14_0==SEMICOLON) ) {
				alt14=1;
			}
			switch (alt14) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:261:47: ';'
					{
					char_literal59=(Token)match(input,SEMICOLON,FOLLOW_SEMICOLON_in_viewDefStmtConstruct803);  
					stream_SEMICOLON.add(char_literal59);

					}
					break;

			}

			// AST REWRITE
			// elements: NAME, SQL_QUERY
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 262:6: -> ^( CONSTRUCT_VIEW_DEFINITION NAME SQL_QUERY )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:262:9: ^( CONSTRUCT_VIEW_DEFINITION NAME SQL_QUERY )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(CONSTRUCT_VIEW_DEFINITION, "CONSTRUCT_VIEW_DEFINITION"), root_1);
				adaptor.addChild(root_1, stream_NAME.nextNode());
				adaptor.addChild(root_1, stream_SQL_QUERY.nextNode());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "viewDefStmtConstruct"


	public static class varConstraintsClause_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "varConstraintsClause"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:268:1: varConstraintsClause : CONSTRAIN ( varConstraint )+ -> ^( CONSTRAINTS ( varConstraint )* ) ;
	public final SparqlifyConfigParser.varConstraintsClause_return varConstraintsClause() throws RecognitionException {
		SparqlifyConfigParser.varConstraintsClause_return retval = new SparqlifyConfigParser.varConstraintsClause_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token CONSTRAIN60=null;
		ParserRuleReturnScope varConstraint61 =null;

		CommonTree CONSTRAIN60_tree=null;
		RewriteRuleTokenStream stream_CONSTRAIN=new RewriteRuleTokenStream(adaptor,"token CONSTRAIN");
		RewriteRuleSubtreeStream stream_varConstraint=new RewriteRuleSubtreeStream(adaptor,"rule varConstraint");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:269:5: ( CONSTRAIN ( varConstraint )+ -> ^( CONSTRAINTS ( varConstraint )* ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:269:7: CONSTRAIN ( varConstraint )+
			{
			CONSTRAIN60=(Token)match(input,CONSTRAIN,FOLLOW_CONSTRAIN_in_varConstraintsClause839);  
			stream_CONSTRAIN.add(CONSTRAIN60);

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:269:17: ( varConstraint )+
			int cnt15=0;
			loop15:
			while (true) {
				int alt15=2;
				int LA15_0 = input.LA(1);
				if ( ((LA15_0 >= VAR1 && LA15_0 <= VAR3)) ) {
					alt15=1;
				}

				switch (alt15) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:269:17: varConstraint
					{
					pushFollow(FOLLOW_varConstraint_in_varConstraintsClause841);
					varConstraint61=varConstraint();
					state._fsp--;

					stream_varConstraint.add(varConstraint61.getTree());
					}
					break;

				default :
					if ( cnt15 >= 1 ) break loop15;
					EarlyExitException eee = new EarlyExitException(15, input);
					throw eee;
				}
				cnt15++;
			}

			// AST REWRITE
			// elements: varConstraint
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 270:6: -> ^( CONSTRAINTS ( varConstraint )* )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:270:9: ^( CONSTRAINTS ( varConstraint )* )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(CONSTRAINTS, "CONSTRAINTS"), root_1);
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:270:23: ( varConstraint )*
				while ( stream_varConstraint.hasNext() ) {
					adaptor.addChild(root_1, stream_varConstraint.nextTree());
				}
				stream_varConstraint.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "varConstraintsClause"


	public static class varConstraint_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "varConstraint"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:273:1: varConstraint : ( regexValueConstraint | prefixValueConstraint );
	public final SparqlifyConfigParser.varConstraint_return varConstraint() throws RecognitionException {
		SparqlifyConfigParser.varConstraint_return retval = new SparqlifyConfigParser.varConstraint_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		ParserRuleReturnScope regexValueConstraint62 =null;
		ParserRuleReturnScope prefixValueConstraint63 =null;


		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:274:5: ( regexValueConstraint | prefixValueConstraint )
			int alt16=2;
			switch ( input.LA(1) ) {
			case VAR1:
				{
				int LA16_1 = input.LA(2);
				if ( (LA16_1==REGEX) ) {
					alt16=1;
				}
				else if ( (LA16_1==PREFIX) ) {
					alt16=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 16, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case VAR2:
				{
				int LA16_2 = input.LA(2);
				if ( (LA16_2==REGEX) ) {
					alt16=1;
				}
				else if ( (LA16_2==PREFIX) ) {
					alt16=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 16, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case VAR3:
				{
				int LA16_3 = input.LA(2);
				if ( (LA16_3==REGEX) ) {
					alt16=1;
				}
				else if ( (LA16_3==PREFIX) ) {
					alt16=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 16, 3, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 16, 0, input);
				throw nvae;
			}
			switch (alt16) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:274:7: regexValueConstraint
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_regexValueConstraint_in_varConstraint873);
					regexValueConstraint62=regexValueConstraint();
					state._fsp--;

					adaptor.addChild(root_0, regexValueConstraint62.getTree());

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:275:7: prefixValueConstraint
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_prefixValueConstraint_in_varConstraint881);
					prefixValueConstraint63=prefixValueConstraint();
					state._fsp--;

					adaptor.addChild(root_0, prefixValueConstraint63.getTree());

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "varConstraint"


	public static class regexValueConstraint_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "regexValueConstraint"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:283:1: regexValueConstraint : var REGEX string -> ^( REGEX_CONSTRAINT var string ) ;
	public final SparqlifyConfigParser.regexValueConstraint_return regexValueConstraint() throws RecognitionException {
		SparqlifyConfigParser.regexValueConstraint_return retval = new SparqlifyConfigParser.regexValueConstraint_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token REGEX65=null;
		ParserRuleReturnScope var64 =null;
		ParserRuleReturnScope string66 =null;

		CommonTree REGEX65_tree=null;
		RewriteRuleTokenStream stream_REGEX=new RewriteRuleTokenStream(adaptor,"token REGEX");
		RewriteRuleSubtreeStream stream_var=new RewriteRuleSubtreeStream(adaptor,"rule var");
		RewriteRuleSubtreeStream stream_string=new RewriteRuleSubtreeStream(adaptor,"rule string");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:285:5: ( var REGEX string -> ^( REGEX_CONSTRAINT var string ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:285:7: var REGEX string
			{
			pushFollow(FOLLOW_var_in_regexValueConstraint910);
			var64=var();
			state._fsp--;

			stream_var.add(var64.getTree());
			REGEX65=(Token)match(input,REGEX,FOLLOW_REGEX_in_regexValueConstraint912);  
			stream_REGEX.add(REGEX65);

			pushFollow(FOLLOW_string_in_regexValueConstraint914);
			string66=string();
			state._fsp--;

			stream_string.add(string66.getTree());
			// AST REWRITE
			// elements: var, string
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 286:9: -> ^( REGEX_CONSTRAINT var string )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:286:12: ^( REGEX_CONSTRAINT var string )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(REGEX_CONSTRAINT, "REGEX_CONSTRAINT"), root_1);
				adaptor.addChild(root_1, stream_var.nextTree());
				adaptor.addChild(root_1, stream_string.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "regexValueConstraint"


	public static class prefixValueConstraint_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "prefixValueConstraint"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:289:1: prefixValueConstraint : var PREFIX stringList -> ^( PREFIX_CONSTRAINT var stringList ) ;
	public final SparqlifyConfigParser.prefixValueConstraint_return prefixValueConstraint() throws RecognitionException {
		SparqlifyConfigParser.prefixValueConstraint_return retval = new SparqlifyConfigParser.prefixValueConstraint_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token PREFIX68=null;
		ParserRuleReturnScope var67 =null;
		ParserRuleReturnScope stringList69 =null;

		CommonTree PREFIX68_tree=null;
		RewriteRuleTokenStream stream_PREFIX=new RewriteRuleTokenStream(adaptor,"token PREFIX");
		RewriteRuleSubtreeStream stream_var=new RewriteRuleSubtreeStream(adaptor,"rule var");
		RewriteRuleSubtreeStream stream_stringList=new RewriteRuleSubtreeStream(adaptor,"rule stringList");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:290:5: ( var PREFIX stringList -> ^( PREFIX_CONSTRAINT var stringList ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:290:7: var PREFIX stringList
			{
			pushFollow(FOLLOW_var_in_prefixValueConstraint949);
			var67=var();
			state._fsp--;

			stream_var.add(var67.getTree());
			PREFIX68=(Token)match(input,PREFIX,FOLLOW_PREFIX_in_prefixValueConstraint951);  
			stream_PREFIX.add(PREFIX68);

			pushFollow(FOLLOW_stringList_in_prefixValueConstraint953);
			stringList69=stringList();
			state._fsp--;

			stream_stringList.add(stringList69.getTree());
			// AST REWRITE
			// elements: var, stringList
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 291:9: -> ^( PREFIX_CONSTRAINT var stringList )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:291:12: ^( PREFIX_CONSTRAINT var stringList )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(PREFIX_CONSTRAINT, "PREFIX_CONSTRAINT"), root_1);
				adaptor.addChild(root_1, stream_var.nextTree());
				adaptor.addChild(root_1, stream_stringList.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "prefixValueConstraint"


	public static class stringList_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "stringList"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:294:1: stringList : string ( ( COMMA )? string )* -> ^( STRING_LIST ( string )* ) ;
	public final SparqlifyConfigParser.stringList_return stringList() throws RecognitionException {
		SparqlifyConfigParser.stringList_return retval = new SparqlifyConfigParser.stringList_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token COMMA71=null;
		ParserRuleReturnScope string70 =null;
		ParserRuleReturnScope string72 =null;

		CommonTree COMMA71_tree=null;
		RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
		RewriteRuleSubtreeStream stream_string=new RewriteRuleSubtreeStream(adaptor,"rule string");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:295:5: ( string ( ( COMMA )? string )* -> ^( STRING_LIST ( string )* ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:295:7: string ( ( COMMA )? string )*
			{
			pushFollow(FOLLOW_string_in_stringList988);
			string70=string();
			state._fsp--;

			stream_string.add(string70.getTree());
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:295:14: ( ( COMMA )? string )*
			loop18:
			while (true) {
				int alt18=2;
				int LA18_0 = input.LA(1);
				if ( (LA18_0==COMMA||(LA18_0 >= STRING_LITERAL1 && LA18_0 <= STRING_LITERAL_LONG2)) ) {
					alt18=1;
				}

				switch (alt18) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:295:15: ( COMMA )? string
					{
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:295:15: ( COMMA )?
					int alt17=2;
					int LA17_0 = input.LA(1);
					if ( (LA17_0==COMMA) ) {
						alt17=1;
					}
					switch (alt17) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:295:15: COMMA
							{
							COMMA71=(Token)match(input,COMMA,FOLLOW_COMMA_in_stringList991);  
							stream_COMMA.add(COMMA71);

							}
							break;

					}

					pushFollow(FOLLOW_string_in_stringList994);
					string72=string();
					state._fsp--;

					stream_string.add(string72.getTree());
					}
					break;

				default :
					break loop18;
				}
			}

			// AST REWRITE
			// elements: string
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 296:6: -> ^( STRING_LIST ( string )* )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:296:9: ^( STRING_LIST ( string )* )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(STRING_LIST, "STRING_LIST"), root_1);
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:296:23: ( string )*
				while ( stream_string.hasNext() ) {
					adaptor.addChild(root_1, stream_string.nextTree());
				}
				stream_string.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "stringList"


	public static class memberAccess_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "memberAccess"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:300:1: memberAccess : '.' NAME ;
	public final SparqlifyConfigParser.memberAccess_return memberAccess() throws RecognitionException {
		SparqlifyConfigParser.memberAccess_return retval = new SparqlifyConfigParser.memberAccess_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token char_literal73=null;
		Token NAME74=null;

		CommonTree char_literal73_tree=null;
		CommonTree NAME74_tree=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:301:5: ( '.' NAME )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:301:7: '.' NAME
			{
			root_0 = (CommonTree)adaptor.nil();


			char_literal73=(Token)match(input,DOT,FOLLOW_DOT_in_memberAccess1028); 
			char_literal73_tree = (CommonTree)adaptor.create(char_literal73);
			adaptor.addChild(root_0, char_literal73_tree);

			NAME74=(Token)match(input,NAME,FOLLOW_NAME_in_memberAccess1030); 
			NAME74_tree = (CommonTree)adaptor.create(NAME74);
			adaptor.addChild(root_0, NAME74_tree);

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "memberAccess"


	public static class viewTemplateDefStmt_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "viewTemplateDefStmt"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:304:1: viewTemplateDefStmt : CREATE VIEW TEMPLATE NAME AS CONSTRUCT viewTemplateDef ( ';' )? -> ^( NAMED_VIEW_TEMPLATE_DEFINITION NAME viewTemplateDef ) ;
	public final SparqlifyConfigParser.viewTemplateDefStmt_return viewTemplateDefStmt() throws RecognitionException {
		SparqlifyConfigParser.viewTemplateDefStmt_return retval = new SparqlifyConfigParser.viewTemplateDefStmt_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token CREATE75=null;
		Token VIEW76=null;
		Token TEMPLATE77=null;
		Token NAME78=null;
		Token AS79=null;
		Token CONSTRUCT80=null;
		Token char_literal82=null;
		ParserRuleReturnScope viewTemplateDef81 =null;

		CommonTree CREATE75_tree=null;
		CommonTree VIEW76_tree=null;
		CommonTree TEMPLATE77_tree=null;
		CommonTree NAME78_tree=null;
		CommonTree AS79_tree=null;
		CommonTree CONSTRUCT80_tree=null;
		CommonTree char_literal82_tree=null;
		RewriteRuleTokenStream stream_AS=new RewriteRuleTokenStream(adaptor,"token AS");
		RewriteRuleTokenStream stream_CREATE=new RewriteRuleTokenStream(adaptor,"token CREATE");
		RewriteRuleTokenStream stream_NAME=new RewriteRuleTokenStream(adaptor,"token NAME");
		RewriteRuleTokenStream stream_CONSTRUCT=new RewriteRuleTokenStream(adaptor,"token CONSTRUCT");
		RewriteRuleTokenStream stream_SEMICOLON=new RewriteRuleTokenStream(adaptor,"token SEMICOLON");
		RewriteRuleTokenStream stream_VIEW=new RewriteRuleTokenStream(adaptor,"token VIEW");
		RewriteRuleTokenStream stream_TEMPLATE=new RewriteRuleTokenStream(adaptor,"token TEMPLATE");
		RewriteRuleSubtreeStream stream_viewTemplateDef=new RewriteRuleSubtreeStream(adaptor,"rule viewTemplateDef");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:305:5: ( CREATE VIEW TEMPLATE NAME AS CONSTRUCT viewTemplateDef ( ';' )? -> ^( NAMED_VIEW_TEMPLATE_DEFINITION NAME viewTemplateDef ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:305:7: CREATE VIEW TEMPLATE NAME AS CONSTRUCT viewTemplateDef ( ';' )?
			{
			CREATE75=(Token)match(input,CREATE,FOLLOW_CREATE_in_viewTemplateDefStmt1047);  
			stream_CREATE.add(CREATE75);

			VIEW76=(Token)match(input,VIEW,FOLLOW_VIEW_in_viewTemplateDefStmt1049);  
			stream_VIEW.add(VIEW76);

			TEMPLATE77=(Token)match(input,TEMPLATE,FOLLOW_TEMPLATE_in_viewTemplateDefStmt1051);  
			stream_TEMPLATE.add(TEMPLATE77);

			NAME78=(Token)match(input,NAME,FOLLOW_NAME_in_viewTemplateDefStmt1053);  
			stream_NAME.add(NAME78);

			AS79=(Token)match(input,AS,FOLLOW_AS_in_viewTemplateDefStmt1055);  
			stream_AS.add(AS79);

			CONSTRUCT80=(Token)match(input,CONSTRUCT,FOLLOW_CONSTRUCT_in_viewTemplateDefStmt1057);  
			stream_CONSTRUCT.add(CONSTRUCT80);

			pushFollow(FOLLOW_viewTemplateDef_in_viewTemplateDefStmt1059);
			viewTemplateDef81=viewTemplateDef();
			state._fsp--;

			stream_viewTemplateDef.add(viewTemplateDef81.getTree());
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:305:62: ( ';' )?
			int alt19=2;
			int LA19_0 = input.LA(1);
			if ( (LA19_0==SEMICOLON) ) {
				alt19=1;
			}
			switch (alt19) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:305:62: ';'
					{
					char_literal82=(Token)match(input,SEMICOLON,FOLLOW_SEMICOLON_in_viewTemplateDefStmt1061);  
					stream_SEMICOLON.add(char_literal82);

					}
					break;

			}

			// AST REWRITE
			// elements: viewTemplateDef, NAME
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 306:6: -> ^( NAMED_VIEW_TEMPLATE_DEFINITION NAME viewTemplateDef )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:306:9: ^( NAMED_VIEW_TEMPLATE_DEFINITION NAME viewTemplateDef )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(NAMED_VIEW_TEMPLATE_DEFINITION, "NAMED_VIEW_TEMPLATE_DEFINITION"), root_1);
				adaptor.addChild(root_1, stream_NAME.nextNode());
				adaptor.addChild(root_1, stream_viewTemplateDef.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "viewTemplateDefStmt"


	public static class viewTemplateDef_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "viewTemplateDef"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:309:1: viewTemplateDef : constructTemplateQuads ( varBindingPart )? -> ^( VIEW_TEMPLATE_DEFINITION constructTemplateQuads ( varBindingPart )? ) ;
	public final SparqlifyConfigParser.viewTemplateDef_return viewTemplateDef() throws RecognitionException {
		SparqlifyConfigParser.viewTemplateDef_return retval = new SparqlifyConfigParser.viewTemplateDef_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		ParserRuleReturnScope constructTemplateQuads83 =null;
		ParserRuleReturnScope varBindingPart84 =null;

		RewriteRuleSubtreeStream stream_constructTemplateQuads=new RewriteRuleSubtreeStream(adaptor,"rule constructTemplateQuads");
		RewriteRuleSubtreeStream stream_varBindingPart=new RewriteRuleSubtreeStream(adaptor,"rule varBindingPart");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:310:2: ( constructTemplateQuads ( varBindingPart )? -> ^( VIEW_TEMPLATE_DEFINITION constructTemplateQuads ( varBindingPart )? ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:310:4: constructTemplateQuads ( varBindingPart )?
			{
			pushFollow(FOLLOW_constructTemplateQuads_in_viewTemplateDef1091);
			constructTemplateQuads83=constructTemplateQuads();
			state._fsp--;

			stream_constructTemplateQuads.add(constructTemplateQuads83.getTree());
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:310:27: ( varBindingPart )?
			int alt20=2;
			int LA20_0 = input.LA(1);
			if ( (LA20_0==WITH) ) {
				alt20=1;
			}
			switch (alt20) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:310:27: varBindingPart
					{
					pushFollow(FOLLOW_varBindingPart_in_viewTemplateDef1093);
					varBindingPart84=varBindingPart();
					state._fsp--;

					stream_varBindingPart.add(varBindingPart84.getTree());
					}
					break;

			}

			// AST REWRITE
			// elements: varBindingPart, constructTemplateQuads
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 311:3: -> ^( VIEW_TEMPLATE_DEFINITION constructTemplateQuads ( varBindingPart )? )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:311:6: ^( VIEW_TEMPLATE_DEFINITION constructTemplateQuads ( varBindingPart )? )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(VIEW_TEMPLATE_DEFINITION, "VIEW_TEMPLATE_DEFINITION"), root_1);
				adaptor.addChild(root_1, stream_constructTemplateQuads.nextTree());
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:311:56: ( varBindingPart )?
				if ( stream_varBindingPart.hasNext() ) {
					adaptor.addChild(root_1, stream_varBindingPart.nextTree());
				}
				stream_varBindingPart.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "viewTemplateDef"


	public static class prefixDefStmt_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "prefixDefStmt"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:315:1: prefixDefStmt : prefixDecl ;
	public final SparqlifyConfigParser.prefixDefStmt_return prefixDefStmt() throws RecognitionException {
		SparqlifyConfigParser.prefixDefStmt_return retval = new SparqlifyConfigParser.prefixDefStmt_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		ParserRuleReturnScope prefixDecl85 =null;


		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:316:5: ( prefixDecl )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:316:7: prefixDecl
			{
			root_0 = (CommonTree)adaptor.nil();


			pushFollow(FOLLOW_prefixDecl_in_prefixDefStmt1122);
			prefixDecl85=prefixDecl();
			state._fsp--;

			adaptor.addChild(root_0, prefixDecl85.getTree());

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "prefixDefStmt"


	public static class macroStmt_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "macroStmt"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:319:1: macroStmt : DEFINE expression -> ^( MACRO_DEF expression ) ;
	public final SparqlifyConfigParser.macroStmt_return macroStmt() throws RecognitionException {
		SparqlifyConfigParser.macroStmt_return retval = new SparqlifyConfigParser.macroStmt_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token DEFINE86=null;
		ParserRuleReturnScope expression87 =null;

		CommonTree DEFINE86_tree=null;
		RewriteRuleTokenStream stream_DEFINE=new RewriteRuleTokenStream(adaptor,"token DEFINE");
		RewriteRuleSubtreeStream stream_expression=new RewriteRuleSubtreeStream(adaptor,"rule expression");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:320:5: ( DEFINE expression -> ^( MACRO_DEF expression ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:320:7: DEFINE expression
			{
			DEFINE86=(Token)match(input,DEFINE,FOLLOW_DEFINE_in_macroStmt1143);  
			stream_DEFINE.add(DEFINE86);

			pushFollow(FOLLOW_expression_in_macroStmt1145);
			expression87=expression();
			state._fsp--;

			stream_expression.add(expression87.getTree());
			// AST REWRITE
			// elements: expression
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 320:25: -> ^( MACRO_DEF expression )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:320:28: ^( MACRO_DEF expression )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(MACRO_DEF, "MACRO_DEF"), root_1);
				adaptor.addChild(root_1, stream_expression.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "macroStmt"


	public static class relationRef_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "relationRef"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:323:1: relationRef : a= joinClause ( WHERE b= expression )? -> ^( RELATION_REF $a ( $b)? ) ;
	public final SparqlifyConfigParser.relationRef_return relationRef() throws RecognitionException {
		SparqlifyConfigParser.relationRef_return retval = new SparqlifyConfigParser.relationRef_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token WHERE88=null;
		ParserRuleReturnScope a =null;
		ParserRuleReturnScope b =null;

		CommonTree WHERE88_tree=null;
		RewriteRuleTokenStream stream_WHERE=new RewriteRuleTokenStream(adaptor,"token WHERE");
		RewriteRuleSubtreeStream stream_expression=new RewriteRuleSubtreeStream(adaptor,"rule expression");
		RewriteRuleSubtreeStream stream_joinClause=new RewriteRuleSubtreeStream(adaptor,"rule joinClause");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:324:5: (a= joinClause ( WHERE b= expression )? -> ^( RELATION_REF $a ( $b)? ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:324:7: a= joinClause ( WHERE b= expression )?
			{
			pushFollow(FOLLOW_joinClause_in_relationRef1172);
			a=joinClause();
			state._fsp--;

			stream_joinClause.add(a.getTree());
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:324:20: ( WHERE b= expression )?
			int alt21=2;
			int LA21_0 = input.LA(1);
			if ( (LA21_0==WHERE) ) {
				alt21=1;
			}
			switch (alt21) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:324:21: WHERE b= expression
					{
					WHERE88=(Token)match(input,WHERE,FOLLOW_WHERE_in_relationRef1175);  
					stream_WHERE.add(WHERE88);

					pushFollow(FOLLOW_expression_in_relationRef1179);
					b=expression();
					state._fsp--;

					stream_expression.add(b.getTree());
					}
					break;

			}

			// AST REWRITE
			// elements: b, a
			// token labels: 
			// rule labels: retval, b, a
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);
			RewriteRuleSubtreeStream stream_b=new RewriteRuleSubtreeStream(adaptor,"rule b",b!=null?b.getTree():null);
			RewriteRuleSubtreeStream stream_a=new RewriteRuleSubtreeStream(adaptor,"rule a",a!=null?a.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 324:42: -> ^( RELATION_REF $a ( $b)? )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:324:45: ^( RELATION_REF $a ( $b)? )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(RELATION_REF, "RELATION_REF"), root_1);
				adaptor.addChild(root_1, stream_a.nextTree());
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:324:64: ( $b)?
				if ( stream_b.hasNext() ) {
					adaptor.addChild(root_1, stream_b.nextTree());
				}
				stream_b.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "relationRef"


	public static class joinClause_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "joinClause"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:328:1: joinClause : ( joinClauseMember |a= joinClauseMember COMMA b= joinClause -> ^( FULL_JOIN $a $b) );
	public final SparqlifyConfigParser.joinClause_return joinClause() throws RecognitionException {
		SparqlifyConfigParser.joinClause_return retval = new SparqlifyConfigParser.joinClause_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token COMMA90=null;
		ParserRuleReturnScope a =null;
		ParserRuleReturnScope b =null;
		ParserRuleReturnScope joinClauseMember89 =null;

		CommonTree COMMA90_tree=null;
		RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
		RewriteRuleSubtreeStream stream_joinClauseMember=new RewriteRuleSubtreeStream(adaptor,"rule joinClauseMember");
		RewriteRuleSubtreeStream stream_joinClause=new RewriteRuleSubtreeStream(adaptor,"rule joinClause");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:329:2: ( joinClauseMember |a= joinClauseMember COMMA b= joinClause -> ^( FULL_JOIN $a $b) )
			int alt22=2;
			switch ( input.LA(1) ) {
			case SQL_QUERY:
				{
				switch ( input.LA(2) ) {
				case AS:
					{
					int LA22_4 = input.LA(3);
					if ( (LA22_4==NAME) ) {
						int LA22_5 = input.LA(4);
						if ( (LA22_5==EOF||LA22_5==CREATE||LA22_5==DECLARE||LA22_5==DEFINE||LA22_5==PREFIX||LA22_5==SEMICOLON||LA22_5==SET||LA22_5==WHERE) ) {
							alt22=1;
						}
						else if ( (LA22_5==COMMA) ) {
							alt22=2;
						}

						else {
							int nvaeMark = input.mark();
							try {
								for (int nvaeConsume = 0; nvaeConsume < 4 - 1; nvaeConsume++) {
									input.consume();
								}
								NoViableAltException nvae =
									new NoViableAltException("", 22, 5, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

					}
					else if ( (LA22_4==A) ) {
						int LA22_6 = input.LA(4);
						if ( (LA22_6==EOF||LA22_6==CREATE||LA22_6==DECLARE||LA22_6==DEFINE||LA22_6==PREFIX||LA22_6==SEMICOLON||LA22_6==SET||LA22_6==WHERE) ) {
							alt22=1;
						}
						else if ( (LA22_6==COMMA) ) {
							alt22=2;
						}

						else {
							int nvaeMark = input.mark();
							try {
								for (int nvaeConsume = 0; nvaeConsume < 4 - 1; nvaeConsume++) {
									input.consume();
								}
								NoViableAltException nvae =
									new NoViableAltException("", 22, 6, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 22, 4, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case NAME:
					{
					int LA22_5 = input.LA(3);
					if ( (LA22_5==EOF||LA22_5==CREATE||LA22_5==DECLARE||LA22_5==DEFINE||LA22_5==PREFIX||LA22_5==SEMICOLON||LA22_5==SET||LA22_5==WHERE) ) {
						alt22=1;
					}
					else if ( (LA22_5==COMMA) ) {
						alt22=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 22, 5, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case A:
					{
					int LA22_6 = input.LA(3);
					if ( (LA22_6==EOF||LA22_6==CREATE||LA22_6==DECLARE||LA22_6==DEFINE||LA22_6==PREFIX||LA22_6==SEMICOLON||LA22_6==SET||LA22_6==WHERE) ) {
						alt22=1;
					}
					else if ( (LA22_6==COMMA) ) {
						alt22=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 22, 6, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case EOF:
				case CREATE:
				case DECLARE:
				case DEFINE:
				case PREFIX:
				case SEMICOLON:
				case SET:
				case WHERE:
					{
					alt22=1;
					}
					break;
				case COMMA:
					{
					alt22=2;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 22, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case NAME:
				{
				switch ( input.LA(2) ) {
				case AS:
					{
					int LA22_4 = input.LA(3);
					if ( (LA22_4==NAME) ) {
						int LA22_5 = input.LA(4);
						if ( (LA22_5==EOF||LA22_5==CREATE||LA22_5==DECLARE||LA22_5==DEFINE||LA22_5==PREFIX||LA22_5==SEMICOLON||LA22_5==SET||LA22_5==WHERE) ) {
							alt22=1;
						}
						else if ( (LA22_5==COMMA) ) {
							alt22=2;
						}

						else {
							int nvaeMark = input.mark();
							try {
								for (int nvaeConsume = 0; nvaeConsume < 4 - 1; nvaeConsume++) {
									input.consume();
								}
								NoViableAltException nvae =
									new NoViableAltException("", 22, 5, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

					}
					else if ( (LA22_4==A) ) {
						int LA22_6 = input.LA(4);
						if ( (LA22_6==EOF||LA22_6==CREATE||LA22_6==DECLARE||LA22_6==DEFINE||LA22_6==PREFIX||LA22_6==SEMICOLON||LA22_6==SET||LA22_6==WHERE) ) {
							alt22=1;
						}
						else if ( (LA22_6==COMMA) ) {
							alt22=2;
						}

						else {
							int nvaeMark = input.mark();
							try {
								for (int nvaeConsume = 0; nvaeConsume < 4 - 1; nvaeConsume++) {
									input.consume();
								}
								NoViableAltException nvae =
									new NoViableAltException("", 22, 6, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 22, 4, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case NAME:
					{
					int LA22_5 = input.LA(3);
					if ( (LA22_5==EOF||LA22_5==CREATE||LA22_5==DECLARE||LA22_5==DEFINE||LA22_5==PREFIX||LA22_5==SEMICOLON||LA22_5==SET||LA22_5==WHERE) ) {
						alt22=1;
					}
					else if ( (LA22_5==COMMA) ) {
						alt22=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 22, 5, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case A:
					{
					int LA22_6 = input.LA(3);
					if ( (LA22_6==EOF||LA22_6==CREATE||LA22_6==DECLARE||LA22_6==DEFINE||LA22_6==PREFIX||LA22_6==SEMICOLON||LA22_6==SET||LA22_6==WHERE) ) {
						alt22=1;
					}
					else if ( (LA22_6==COMMA) ) {
						alt22=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 22, 6, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case EOF:
				case CREATE:
				case DECLARE:
				case DEFINE:
				case PREFIX:
				case SEMICOLON:
				case SET:
				case WHERE:
					{
					alt22=1;
					}
					break;
				case COMMA:
					{
					alt22=2;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 22, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case STRING_LITERAL2:
				{
				switch ( input.LA(2) ) {
				case AS:
					{
					int LA22_4 = input.LA(3);
					if ( (LA22_4==NAME) ) {
						int LA22_5 = input.LA(4);
						if ( (LA22_5==EOF||LA22_5==CREATE||LA22_5==DECLARE||LA22_5==DEFINE||LA22_5==PREFIX||LA22_5==SEMICOLON||LA22_5==SET||LA22_5==WHERE) ) {
							alt22=1;
						}
						else if ( (LA22_5==COMMA) ) {
							alt22=2;
						}

						else {
							int nvaeMark = input.mark();
							try {
								for (int nvaeConsume = 0; nvaeConsume < 4 - 1; nvaeConsume++) {
									input.consume();
								}
								NoViableAltException nvae =
									new NoViableAltException("", 22, 5, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

					}
					else if ( (LA22_4==A) ) {
						int LA22_6 = input.LA(4);
						if ( (LA22_6==EOF||LA22_6==CREATE||LA22_6==DECLARE||LA22_6==DEFINE||LA22_6==PREFIX||LA22_6==SEMICOLON||LA22_6==SET||LA22_6==WHERE) ) {
							alt22=1;
						}
						else if ( (LA22_6==COMMA) ) {
							alt22=2;
						}

						else {
							int nvaeMark = input.mark();
							try {
								for (int nvaeConsume = 0; nvaeConsume < 4 - 1; nvaeConsume++) {
									input.consume();
								}
								NoViableAltException nvae =
									new NoViableAltException("", 22, 6, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 22, 4, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case NAME:
					{
					int LA22_5 = input.LA(3);
					if ( (LA22_5==EOF||LA22_5==CREATE||LA22_5==DECLARE||LA22_5==DEFINE||LA22_5==PREFIX||LA22_5==SEMICOLON||LA22_5==SET||LA22_5==WHERE) ) {
						alt22=1;
					}
					else if ( (LA22_5==COMMA) ) {
						alt22=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 22, 5, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case A:
					{
					int LA22_6 = input.LA(3);
					if ( (LA22_6==EOF||LA22_6==CREATE||LA22_6==DECLARE||LA22_6==DEFINE||LA22_6==PREFIX||LA22_6==SEMICOLON||LA22_6==SET||LA22_6==WHERE) ) {
						alt22=1;
					}
					else if ( (LA22_6==COMMA) ) {
						alt22=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 22, 6, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case EOF:
				case CREATE:
				case DECLARE:
				case DEFINE:
				case PREFIX:
				case SEMICOLON:
				case SET:
				case WHERE:
					{
					alt22=1;
					}
					break;
				case COMMA:
					{
					alt22=2;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 22, 3, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 22, 0, input);
				throw nvae;
			}
			switch (alt22) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:329:4: joinClauseMember
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_joinClauseMember_in_joinClause1209);
					joinClauseMember89=joinClauseMember();
					state._fsp--;

					adaptor.addChild(root_0, joinClauseMember89.getTree());

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:330:4: a= joinClauseMember COMMA b= joinClause
					{
					pushFollow(FOLLOW_joinClauseMember_in_joinClause1216);
					a=joinClauseMember();
					state._fsp--;

					stream_joinClauseMember.add(a.getTree());
					COMMA90=(Token)match(input,COMMA,FOLLOW_COMMA_in_joinClause1218);  
					stream_COMMA.add(COMMA90);

					pushFollow(FOLLOW_joinClause_in_joinClause1222);
					b=joinClause();
					state._fsp--;

					stream_joinClause.add(b.getTree());
					// AST REWRITE
					// elements: b, a
					// token labels: 
					// rule labels: retval, b, a
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);
					RewriteRuleSubtreeStream stream_b=new RewriteRuleSubtreeStream(adaptor,"rule b",b!=null?b.getTree():null);
					RewriteRuleSubtreeStream stream_a=new RewriteRuleSubtreeStream(adaptor,"rule a",a!=null?a.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 330:42: -> ^( FULL_JOIN $a $b)
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:330:45: ^( FULL_JOIN $a $b)
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(FULL_JOIN, "FULL_JOIN"), root_1);
						adaptor.addChild(root_1, stream_a.nextTree());
						adaptor.addChild(root_1, stream_b.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "joinClause"


	public static class joinClauseMember_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "joinClauseMember"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:333:1: joinClauseMember : a= logicalTable ( ( AS )? b= name )? -> ^( JOIN_MEMBER $a ( $b)? ) ;
	public final SparqlifyConfigParser.joinClauseMember_return joinClauseMember() throws RecognitionException {
		SparqlifyConfigParser.joinClauseMember_return retval = new SparqlifyConfigParser.joinClauseMember_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token AS91=null;
		ParserRuleReturnScope a =null;
		ParserRuleReturnScope b =null;

		CommonTree AS91_tree=null;
		RewriteRuleTokenStream stream_AS=new RewriteRuleTokenStream(adaptor,"token AS");
		RewriteRuleSubtreeStream stream_logicalTable=new RewriteRuleSubtreeStream(adaptor,"rule logicalTable");
		RewriteRuleSubtreeStream stream_name=new RewriteRuleSubtreeStream(adaptor,"rule name");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:334:5: (a= logicalTable ( ( AS )? b= name )? -> ^( JOIN_MEMBER $a ( $b)? ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:334:7: a= logicalTable ( ( AS )? b= name )?
			{
			pushFollow(FOLLOW_logicalTable_in_joinClauseMember1255);
			a=logicalTable();
			state._fsp--;

			stream_logicalTable.add(a.getTree());
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:334:22: ( ( AS )? b= name )?
			int alt24=2;
			int LA24_0 = input.LA(1);
			if ( (LA24_0==A||LA24_0==AS||LA24_0==NAME) ) {
				alt24=1;
			}
			switch (alt24) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:334:23: ( AS )? b= name
					{
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:334:23: ( AS )?
					int alt23=2;
					int LA23_0 = input.LA(1);
					if ( (LA23_0==AS) ) {
						alt23=1;
					}
					switch (alt23) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:334:23: AS
							{
							AS91=(Token)match(input,AS,FOLLOW_AS_in_joinClauseMember1258);  
							stream_AS.add(AS91);

							}
							break;

					}

					pushFollow(FOLLOW_name_in_joinClauseMember1263);
					b=name();
					state._fsp--;

					stream_name.add(b.getTree());
					}
					break;

			}

			// AST REWRITE
			// elements: b, a
			// token labels: 
			// rule labels: retval, b, a
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);
			RewriteRuleSubtreeStream stream_b=new RewriteRuleSubtreeStream(adaptor,"rule b",b!=null?b.getTree():null);
			RewriteRuleSubtreeStream stream_a=new RewriteRuleSubtreeStream(adaptor,"rule a",a!=null?a.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 334:36: -> ^( JOIN_MEMBER $a ( $b)? )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:334:39: ^( JOIN_MEMBER $a ( $b)? )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(JOIN_MEMBER, "JOIN_MEMBER"), root_1);
				adaptor.addChild(root_1, stream_a.nextTree());
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:334:57: ( $b)?
				if ( stream_b.hasNext() ) {
					adaptor.addChild(root_1, stream_b.nextTree());
				}
				stream_b.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "joinClauseMember"


	public static class name_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "name"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:337:1: name : ( NAME |a= A -> ^( NAME[$a] ) );
	public final SparqlifyConfigParser.name_return name() throws RecognitionException {
		SparqlifyConfigParser.name_return retval = new SparqlifyConfigParser.name_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token a=null;
		Token NAME92=null;

		CommonTree a_tree=null;
		CommonTree NAME92_tree=null;
		RewriteRuleTokenStream stream_A=new RewriteRuleTokenStream(adaptor,"token A");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:338:5: ( NAME |a= A -> ^( NAME[$a] ) )
			int alt25=2;
			int LA25_0 = input.LA(1);
			if ( (LA25_0==NAME) ) {
				alt25=1;
			}
			else if ( (LA25_0==A) ) {
				alt25=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 25, 0, input);
				throw nvae;
			}

			switch (alt25) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:338:7: NAME
					{
					root_0 = (CommonTree)adaptor.nil();


					NAME92=(Token)match(input,NAME,FOLLOW_NAME_in_name1295); 
					NAME92_tree = (CommonTree)adaptor.create(NAME92);
					adaptor.addChild(root_0, NAME92_tree);

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:339:7: a= A
					{
					a=(Token)match(input,A,FOLLOW_A_in_name1305);  
					stream_A.add(a);

					// AST REWRITE
					// elements: 
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 339:11: -> ^( NAME[$a] )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:339:14: ^( NAME[$a] )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(NAME, a), root_1);
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "name"


	public static class logicalTable_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "logicalTable"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:343:1: logicalTable : (a= SQL_QUERY -> ^( SQL_RELATION SQL_QUERY[$a] ) |a= NAME -> ^( SQL_RELATION SQL_TABLE[$a] ) |a= STRING_LITERAL2 -> ^( SQL_RELATION SQL_TABLE[$a] ) );
	public final SparqlifyConfigParser.logicalTable_return logicalTable() throws RecognitionException {
		SparqlifyConfigParser.logicalTable_return retval = new SparqlifyConfigParser.logicalTable_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token a=null;

		CommonTree a_tree=null;
		RewriteRuleTokenStream stream_NAME=new RewriteRuleTokenStream(adaptor,"token NAME");
		RewriteRuleTokenStream stream_SQL_QUERY=new RewriteRuleTokenStream(adaptor,"token SQL_QUERY");
		RewriteRuleTokenStream stream_STRING_LITERAL2=new RewriteRuleTokenStream(adaptor,"token STRING_LITERAL2");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:344:5: (a= SQL_QUERY -> ^( SQL_RELATION SQL_QUERY[$a] ) |a= NAME -> ^( SQL_RELATION SQL_TABLE[$a] ) |a= STRING_LITERAL2 -> ^( SQL_RELATION SQL_TABLE[$a] ) )
			int alt26=3;
			switch ( input.LA(1) ) {
			case SQL_QUERY:
				{
				alt26=1;
				}
				break;
			case NAME:
				{
				alt26=2;
				}
				break;
			case STRING_LITERAL2:
				{
				alt26=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 26, 0, input);
				throw nvae;
			}
			switch (alt26) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:344:7: a= SQL_QUERY
					{
					a=(Token)match(input,SQL_QUERY,FOLLOW_SQL_QUERY_in_logicalTable1332);  
					stream_SQL_QUERY.add(a);

					// AST REWRITE
					// elements: SQL_QUERY
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 344:19: -> ^( SQL_RELATION SQL_QUERY[$a] )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:344:22: ^( SQL_RELATION SQL_QUERY[$a] )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(SQL_RELATION, "SQL_RELATION"), root_1);
						adaptor.addChild(root_1, (CommonTree)adaptor.create(SQL_QUERY, a));
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:345:7: a= NAME
					{
					a=(Token)match(input,NAME,FOLLOW_NAME_in_logicalTable1351);  
					stream_NAME.add(a);

					// AST REWRITE
					// elements: 
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 345:14: -> ^( SQL_RELATION SQL_TABLE[$a] )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:345:17: ^( SQL_RELATION SQL_TABLE[$a] )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(SQL_RELATION, "SQL_RELATION"), root_1);
						adaptor.addChild(root_1, (CommonTree)adaptor.create(SQL_TABLE, a));
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:346:7: a= STRING_LITERAL2
					{
					a=(Token)match(input,STRING_LITERAL2,FOLLOW_STRING_LITERAL2_in_logicalTable1370);  
					stream_STRING_LITERAL2.add(a);

					// AST REWRITE
					// elements: 
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 346:25: -> ^( SQL_RELATION SQL_TABLE[$a] )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:346:28: ^( SQL_RELATION SQL_TABLE[$a] )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(SQL_RELATION, "SQL_RELATION"), root_1);
						adaptor.addChild(root_1, (CommonTree)adaptor.create(SQL_TABLE, a));
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "logicalTable"


	public static class varBindingPart_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "varBindingPart"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:363:1: varBindingPart : WITH ( varBinding )+ -> ^( VAR_BINDINGS ( varBinding )+ ) ;
	public final SparqlifyConfigParser.varBindingPart_return varBindingPart() throws RecognitionException {
		SparqlifyConfigParser.varBindingPart_return retval = new SparqlifyConfigParser.varBindingPart_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token WITH93=null;
		ParserRuleReturnScope varBinding94 =null;

		CommonTree WITH93_tree=null;
		RewriteRuleTokenStream stream_WITH=new RewriteRuleTokenStream(adaptor,"token WITH");
		RewriteRuleSubtreeStream stream_varBinding=new RewriteRuleSubtreeStream(adaptor,"rule varBinding");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:364:5: ( WITH ( varBinding )+ -> ^( VAR_BINDINGS ( varBinding )+ ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:364:7: WITH ( varBinding )+
			{
			WITH93=(Token)match(input,WITH,FOLLOW_WITH_in_varBindingPart1403);  
			stream_WITH.add(WITH93);

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:364:12: ( varBinding )+
			int cnt27=0;
			loop27:
			while (true) {
				int alt27=2;
				int LA27_0 = input.LA(1);
				if ( ((LA27_0 >= VAR1 && LA27_0 <= VAR3)) ) {
					alt27=1;
				}

				switch (alt27) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:364:12: varBinding
					{
					pushFollow(FOLLOW_varBinding_in_varBindingPart1405);
					varBinding94=varBinding();
					state._fsp--;

					stream_varBinding.add(varBinding94.getTree());
					}
					break;

				default :
					if ( cnt27 >= 1 ) break loop27;
					EarlyExitException eee = new EarlyExitException(27, input);
					throw eee;
				}
				cnt27++;
			}

			// AST REWRITE
			// elements: varBinding
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 364:24: -> ^( VAR_BINDINGS ( varBinding )+ )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:364:27: ^( VAR_BINDINGS ( varBinding )+ )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(VAR_BINDINGS, "VAR_BINDINGS"), root_1);
				if ( !(stream_varBinding.hasNext()) ) {
					throw new RewriteEarlyExitException();
				}
				while ( stream_varBinding.hasNext() ) {
					adaptor.addChild(root_1, stream_varBinding.nextTree());
				}
				stream_varBinding.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "varBindingPart"


	public static class varBinding_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "varBinding"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:373:1: varBinding : var '=' typeCtorExpression -> ^( VAR_BINDING var typeCtorExpression ) ;
	public final SparqlifyConfigParser.varBinding_return varBinding() throws RecognitionException {
		SparqlifyConfigParser.varBinding_return retval = new SparqlifyConfigParser.varBinding_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token char_literal96=null;
		ParserRuleReturnScope var95 =null;
		ParserRuleReturnScope typeCtorExpression97 =null;

		CommonTree char_literal96_tree=null;
		RewriteRuleTokenStream stream_EQUAL=new RewriteRuleTokenStream(adaptor,"token EQUAL");
		RewriteRuleSubtreeStream stream_typeCtorExpression=new RewriteRuleSubtreeStream(adaptor,"rule typeCtorExpression");
		RewriteRuleSubtreeStream stream_var=new RewriteRuleSubtreeStream(adaptor,"rule var");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:374:5: ( var '=' typeCtorExpression -> ^( VAR_BINDING var typeCtorExpression ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:374:7: var '=' typeCtorExpression
			{
			pushFollow(FOLLOW_var_in_varBinding1435);
			var95=var();
			state._fsp--;

			stream_var.add(var95.getTree());
			char_literal96=(Token)match(input,EQUAL,FOLLOW_EQUAL_in_varBinding1437);  
			stream_EQUAL.add(char_literal96);

			pushFollow(FOLLOW_typeCtorExpression_in_varBinding1439);
			typeCtorExpression97=typeCtorExpression();
			state._fsp--;

			stream_typeCtorExpression.add(typeCtorExpression97.getTree());
			// AST REWRITE
			// elements: typeCtorExpression, var
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 374:34: -> ^( VAR_BINDING var typeCtorExpression )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:374:37: ^( VAR_BINDING var typeCtorExpression )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(VAR_BINDING, "VAR_BINDING"), root_1);
				adaptor.addChild(root_1, stream_var.nextTree());
				adaptor.addChild(root_1, stream_typeCtorExpression.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "varBinding"


	public static class typeCtorExpression_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "typeCtorExpression"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:377:1: typeCtorExpression : ( BNODE '(' expression ')' -> ^( BNODE expression ) | URI '(' expression ( COMMA expression )* ')' -> ^( URI ^( EXPRESSION_LIST ( expression )* ) ) | PLAIN_LITERAL '(' expression ( ',' expression )? ')' -> ^( PLAIN_LITERAL expression ( expression )? ) | TYPED_LITERAL '(' expression ',' expression ')' -> ^( TYPED_LITERAL expression expression ) );
	public final SparqlifyConfigParser.typeCtorExpression_return typeCtorExpression() throws RecognitionException {
		SparqlifyConfigParser.typeCtorExpression_return retval = new SparqlifyConfigParser.typeCtorExpression_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token BNODE98=null;
		Token char_literal99=null;
		Token char_literal101=null;
		Token URI102=null;
		Token char_literal103=null;
		Token COMMA105=null;
		Token char_literal107=null;
		Token PLAIN_LITERAL108=null;
		Token char_literal109=null;
		Token char_literal111=null;
		Token char_literal113=null;
		Token TYPED_LITERAL114=null;
		Token char_literal115=null;
		Token char_literal117=null;
		Token char_literal119=null;
		ParserRuleReturnScope expression100 =null;
		ParserRuleReturnScope expression104 =null;
		ParserRuleReturnScope expression106 =null;
		ParserRuleReturnScope expression110 =null;
		ParserRuleReturnScope expression112 =null;
		ParserRuleReturnScope expression116 =null;
		ParserRuleReturnScope expression118 =null;

		CommonTree BNODE98_tree=null;
		CommonTree char_literal99_tree=null;
		CommonTree char_literal101_tree=null;
		CommonTree URI102_tree=null;
		CommonTree char_literal103_tree=null;
		CommonTree COMMA105_tree=null;
		CommonTree char_literal107_tree=null;
		CommonTree PLAIN_LITERAL108_tree=null;
		CommonTree char_literal109_tree=null;
		CommonTree char_literal111_tree=null;
		CommonTree char_literal113_tree=null;
		CommonTree TYPED_LITERAL114_tree=null;
		CommonTree char_literal115_tree=null;
		CommonTree char_literal117_tree=null;
		CommonTree char_literal119_tree=null;
		RewriteRuleTokenStream stream_BNODE=new RewriteRuleTokenStream(adaptor,"token BNODE");
		RewriteRuleTokenStream stream_TYPED_LITERAL=new RewriteRuleTokenStream(adaptor,"token TYPED_LITERAL");
		RewriteRuleTokenStream stream_CLOSE_BRACE=new RewriteRuleTokenStream(adaptor,"token CLOSE_BRACE");
		RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
		RewriteRuleTokenStream stream_OPEN_BRACE=new RewriteRuleTokenStream(adaptor,"token OPEN_BRACE");
		RewriteRuleTokenStream stream_PLAIN_LITERAL=new RewriteRuleTokenStream(adaptor,"token PLAIN_LITERAL");
		RewriteRuleTokenStream stream_URI=new RewriteRuleTokenStream(adaptor,"token URI");
		RewriteRuleSubtreeStream stream_expression=new RewriteRuleSubtreeStream(adaptor,"rule expression");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:378:5: ( BNODE '(' expression ')' -> ^( BNODE expression ) | URI '(' expression ( COMMA expression )* ')' -> ^( URI ^( EXPRESSION_LIST ( expression )* ) ) | PLAIN_LITERAL '(' expression ( ',' expression )? ')' -> ^( PLAIN_LITERAL expression ( expression )? ) | TYPED_LITERAL '(' expression ',' expression ')' -> ^( TYPED_LITERAL expression expression ) )
			int alt30=4;
			switch ( input.LA(1) ) {
			case BNODE:
				{
				alt30=1;
				}
				break;
			case URI:
				{
				alt30=2;
				}
				break;
			case PLAIN_LITERAL:
				{
				alt30=3;
				}
				break;
			case TYPED_LITERAL:
				{
				alt30=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 30, 0, input);
				throw nvae;
			}
			switch (alt30) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:378:7: BNODE '(' expression ')'
					{
					BNODE98=(Token)match(input,BNODE,FOLLOW_BNODE_in_typeCtorExpression1467);  
					stream_BNODE.add(BNODE98);

					char_literal99=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_typeCtorExpression1469);  
					stream_OPEN_BRACE.add(char_literal99);

					pushFollow(FOLLOW_expression_in_typeCtorExpression1471);
					expression100=expression();
					state._fsp--;

					stream_expression.add(expression100.getTree());
					char_literal101=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_typeCtorExpression1473);  
					stream_CLOSE_BRACE.add(char_literal101);

					// AST REWRITE
					// elements: BNODE, expression
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 378:32: -> ^( BNODE expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:378:35: ^( BNODE expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_BNODE.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:379:7: URI '(' expression ( COMMA expression )* ')'
					{
					URI102=(Token)match(input,URI,FOLLOW_URI_in_typeCtorExpression1489);  
					stream_URI.add(URI102);

					char_literal103=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_typeCtorExpression1491);  
					stream_OPEN_BRACE.add(char_literal103);

					pushFollow(FOLLOW_expression_in_typeCtorExpression1493);
					expression104=expression();
					state._fsp--;

					stream_expression.add(expression104.getTree());
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:379:26: ( COMMA expression )*
					loop28:
					while (true) {
						int alt28=2;
						int LA28_0 = input.LA(1);
						if ( (LA28_0==COMMA) ) {
							alt28=1;
						}

						switch (alt28) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:379:27: COMMA expression
							{
							COMMA105=(Token)match(input,COMMA,FOLLOW_COMMA_in_typeCtorExpression1496);  
							stream_COMMA.add(COMMA105);

							pushFollow(FOLLOW_expression_in_typeCtorExpression1498);
							expression106=expression();
							state._fsp--;

							stream_expression.add(expression106.getTree());
							}
							break;

						default :
							break loop28;
						}
					}

					char_literal107=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_typeCtorExpression1502);  
					stream_CLOSE_BRACE.add(char_literal107);

					// AST REWRITE
					// elements: URI, expression
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 379:50: -> ^( URI ^( EXPRESSION_LIST ( expression )* ) )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:379:53: ^( URI ^( EXPRESSION_LIST ( expression )* ) )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_URI.nextNode(), root_1);
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:379:59: ^( EXPRESSION_LIST ( expression )* )
						{
						CommonTree root_2 = (CommonTree)adaptor.nil();
						root_2 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(EXPRESSION_LIST, "EXPRESSION_LIST"), root_2);
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:379:77: ( expression )*
						while ( stream_expression.hasNext() ) {
							adaptor.addChild(root_2, stream_expression.nextTree());
						}
						stream_expression.reset();

						adaptor.addChild(root_1, root_2);
						}

						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:380:7: PLAIN_LITERAL '(' expression ( ',' expression )? ')'
					{
					PLAIN_LITERAL108=(Token)match(input,PLAIN_LITERAL,FOLLOW_PLAIN_LITERAL_in_typeCtorExpression1523);  
					stream_PLAIN_LITERAL.add(PLAIN_LITERAL108);

					char_literal109=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_typeCtorExpression1525);  
					stream_OPEN_BRACE.add(char_literal109);

					pushFollow(FOLLOW_expression_in_typeCtorExpression1527);
					expression110=expression();
					state._fsp--;

					stream_expression.add(expression110.getTree());
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:380:36: ( ',' expression )?
					int alt29=2;
					int LA29_0 = input.LA(1);
					if ( (LA29_0==COMMA) ) {
						alt29=1;
					}
					switch (alt29) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:380:37: ',' expression
							{
							char_literal111=(Token)match(input,COMMA,FOLLOW_COMMA_in_typeCtorExpression1530);  
							stream_COMMA.add(char_literal111);

							pushFollow(FOLLOW_expression_in_typeCtorExpression1532);
							expression112=expression();
							state._fsp--;

							stream_expression.add(expression112.getTree());
							}
							break;

					}

					char_literal113=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_typeCtorExpression1536);  
					stream_CLOSE_BRACE.add(char_literal113);

					// AST REWRITE
					// elements: PLAIN_LITERAL, expression, expression
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 380:58: -> ^( PLAIN_LITERAL expression ( expression )? )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:380:61: ^( PLAIN_LITERAL expression ( expression )? )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_PLAIN_LITERAL.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:380:88: ( expression )?
						if ( stream_expression.hasNext() ) {
							adaptor.addChild(root_1, stream_expression.nextTree());
						}
						stream_expression.reset();

						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:381:7: TYPED_LITERAL '(' expression ',' expression ')'
					{
					TYPED_LITERAL114=(Token)match(input,TYPED_LITERAL,FOLLOW_TYPED_LITERAL_in_typeCtorExpression1555);  
					stream_TYPED_LITERAL.add(TYPED_LITERAL114);

					char_literal115=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_typeCtorExpression1557);  
					stream_OPEN_BRACE.add(char_literal115);

					pushFollow(FOLLOW_expression_in_typeCtorExpression1559);
					expression116=expression();
					state._fsp--;

					stream_expression.add(expression116.getTree());
					char_literal117=(Token)match(input,COMMA,FOLLOW_COMMA_in_typeCtorExpression1561);  
					stream_COMMA.add(char_literal117);

					pushFollow(FOLLOW_expression_in_typeCtorExpression1563);
					expression118=expression();
					state._fsp--;

					stream_expression.add(expression118.getTree());
					char_literal119=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_typeCtorExpression1565);  
					stream_CLOSE_BRACE.add(char_literal119);

					// AST REWRITE
					// elements: TYPED_LITERAL, expression, expression
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 381:55: -> ^( TYPED_LITERAL expression expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:381:58: ^( TYPED_LITERAL expression expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_TYPED_LITERAL.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "typeCtorExpression"


	public static class query_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "query"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:388:1: query : ( prologue ( selectQuery | constructQuery | describeQuery | askQuery ) bindingsClause EOF -> ^( QUERY prologue ( selectQuery )* ( constructQuery )* ( describeQuery )* ( askQuery )* ) ( bindingsClause )* | update ( SEMICOLON update )* EOF -> ^( UPDATE ( update )+ ) );
	public final SparqlifyConfigParser.query_return query() throws RecognitionException {
		SparqlifyConfigParser.query_return retval = new SparqlifyConfigParser.query_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token EOF126=null;
		Token SEMICOLON128=null;
		Token EOF130=null;
		ParserRuleReturnScope prologue120 =null;
		ParserRuleReturnScope selectQuery121 =null;
		ParserRuleReturnScope constructQuery122 =null;
		ParserRuleReturnScope describeQuery123 =null;
		ParserRuleReturnScope askQuery124 =null;
		ParserRuleReturnScope bindingsClause125 =null;
		ParserRuleReturnScope update127 =null;
		ParserRuleReturnScope update129 =null;

		CommonTree EOF126_tree=null;
		CommonTree SEMICOLON128_tree=null;
		CommonTree EOF130_tree=null;
		RewriteRuleTokenStream stream_SEMICOLON=new RewriteRuleTokenStream(adaptor,"token SEMICOLON");
		RewriteRuleTokenStream stream_EOF=new RewriteRuleTokenStream(adaptor,"token EOF");
		RewriteRuleSubtreeStream stream_update=new RewriteRuleSubtreeStream(adaptor,"rule update");
		RewriteRuleSubtreeStream stream_describeQuery=new RewriteRuleSubtreeStream(adaptor,"rule describeQuery");
		RewriteRuleSubtreeStream stream_bindingsClause=new RewriteRuleSubtreeStream(adaptor,"rule bindingsClause");
		RewriteRuleSubtreeStream stream_constructQuery=new RewriteRuleSubtreeStream(adaptor,"rule constructQuery");
		RewriteRuleSubtreeStream stream_askQuery=new RewriteRuleSubtreeStream(adaptor,"rule askQuery");
		RewriteRuleSubtreeStream stream_prologue=new RewriteRuleSubtreeStream(adaptor,"rule prologue");
		RewriteRuleSubtreeStream stream_selectQuery=new RewriteRuleSubtreeStream(adaptor,"rule selectQuery");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:389:5: ( prologue ( selectQuery | constructQuery | describeQuery | askQuery ) bindingsClause EOF -> ^( QUERY prologue ( selectQuery )* ( constructQuery )* ( describeQuery )* ( askQuery )* ) ( bindingsClause )* | update ( SEMICOLON update )* EOF -> ^( UPDATE ( update )+ ) )
			int alt33=2;
			alt33 = dfa33.predict(input);
			switch (alt33) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:389:7: prologue ( selectQuery | constructQuery | describeQuery | askQuery ) bindingsClause EOF
					{
					pushFollow(FOLLOW_prologue_in_query1596);
					prologue120=prologue();
					state._fsp--;

					stream_prologue.add(prologue120.getTree());
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:389:16: ( selectQuery | constructQuery | describeQuery | askQuery )
					int alt31=4;
					switch ( input.LA(1) ) {
					case SELECT:
						{
						alt31=1;
						}
						break;
					case CONSTRUCT:
						{
						alt31=2;
						}
						break;
					case DESCRIBE:
						{
						alt31=3;
						}
						break;
					case ASK:
						{
						alt31=4;
						}
						break;
					default:
						NoViableAltException nvae =
							new NoViableAltException("", 31, 0, input);
						throw nvae;
					}
					switch (alt31) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:389:18: selectQuery
							{
							pushFollow(FOLLOW_selectQuery_in_query1600);
							selectQuery121=selectQuery();
							state._fsp--;

							stream_selectQuery.add(selectQuery121.getTree());
							}
							break;
						case 2 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:389:32: constructQuery
							{
							pushFollow(FOLLOW_constructQuery_in_query1604);
							constructQuery122=constructQuery();
							state._fsp--;

							stream_constructQuery.add(constructQuery122.getTree());
							}
							break;
						case 3 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:389:49: describeQuery
							{
							pushFollow(FOLLOW_describeQuery_in_query1608);
							describeQuery123=describeQuery();
							state._fsp--;

							stream_describeQuery.add(describeQuery123.getTree());
							}
							break;
						case 4 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:389:65: askQuery
							{
							pushFollow(FOLLOW_askQuery_in_query1612);
							askQuery124=askQuery();
							state._fsp--;

							stream_askQuery.add(askQuery124.getTree());
							}
							break;

					}

					pushFollow(FOLLOW_bindingsClause_in_query1616);
					bindingsClause125=bindingsClause();
					state._fsp--;

					stream_bindingsClause.add(bindingsClause125.getTree());
					EOF126=(Token)match(input,EOF,FOLLOW_EOF_in_query1618);  
					stream_EOF.add(EOF126);

					// AST REWRITE
					// elements: constructQuery, selectQuery, bindingsClause, prologue, describeQuery, askQuery
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 389:95: -> ^( QUERY prologue ( selectQuery )* ( constructQuery )* ( describeQuery )* ( askQuery )* ) ( bindingsClause )*
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:389:98: ^( QUERY prologue ( selectQuery )* ( constructQuery )* ( describeQuery )* ( askQuery )* )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(QUERY, "QUERY"), root_1);
						adaptor.addChild(root_1, stream_prologue.nextTree());
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:389:115: ( selectQuery )*
						while ( stream_selectQuery.hasNext() ) {
							adaptor.addChild(root_1, stream_selectQuery.nextTree());
						}
						stream_selectQuery.reset();

						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:389:128: ( constructQuery )*
						while ( stream_constructQuery.hasNext() ) {
							adaptor.addChild(root_1, stream_constructQuery.nextTree());
						}
						stream_constructQuery.reset();

						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:389:144: ( describeQuery )*
						while ( stream_describeQuery.hasNext() ) {
							adaptor.addChild(root_1, stream_describeQuery.nextTree());
						}
						stream_describeQuery.reset();

						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:389:159: ( askQuery )*
						while ( stream_askQuery.hasNext() ) {
							adaptor.addChild(root_1, stream_askQuery.nextTree());
						}
						stream_askQuery.reset();

						adaptor.addChild(root_0, root_1);
						}

						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:389:170: ( bindingsClause )*
						while ( stream_bindingsClause.hasNext() ) {
							adaptor.addChild(root_0, stream_bindingsClause.nextTree());
						}
						stream_bindingsClause.reset();

					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:390:7: update ( SEMICOLON update )* EOF
					{
					pushFollow(FOLLOW_update_in_query1649);
					update127=update();
					state._fsp--;

					stream_update.add(update127.getTree());
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:390:14: ( SEMICOLON update )*
					loop32:
					while (true) {
						int alt32=2;
						int LA32_0 = input.LA(1);
						if ( (LA32_0==SEMICOLON) ) {
							alt32=1;
						}

						switch (alt32) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:390:16: SEMICOLON update
							{
							SEMICOLON128=(Token)match(input,SEMICOLON,FOLLOW_SEMICOLON_in_query1653);  
							stream_SEMICOLON.add(SEMICOLON128);

							pushFollow(FOLLOW_update_in_query1655);
							update129=update();
							state._fsp--;

							stream_update.add(update129.getTree());
							}
							break;

						default :
							break loop32;
						}
					}

					EOF130=(Token)match(input,EOF,FOLLOW_EOF_in_query1659);  
					stream_EOF.add(EOF130);

					// AST REWRITE
					// elements: update
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 390:39: -> ^( UPDATE ( update )+ )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:390:42: ^( UPDATE ( update )+ )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(UPDATE, "UPDATE"), root_1);
						if ( !(stream_update.hasNext()) ) {
							throw new RewriteEarlyExitException();
						}
						while ( stream_update.hasNext() ) {
							adaptor.addChild(root_1, stream_update.nextTree());
						}
						stream_update.reset();

						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "query"


	public static class prologue_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "prologue"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:393:1: prologue : ( baseDecl | prefixDecl )* -> ^( PROLOGUE ( baseDecl )* ( prefixDecl )* ) ;
	public final SparqlifyConfigParser.prologue_return prologue() throws RecognitionException {
		SparqlifyConfigParser.prologue_return retval = new SparqlifyConfigParser.prologue_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		ParserRuleReturnScope baseDecl131 =null;
		ParserRuleReturnScope prefixDecl132 =null;

		RewriteRuleSubtreeStream stream_prefixDecl=new RewriteRuleSubtreeStream(adaptor,"rule prefixDecl");
		RewriteRuleSubtreeStream stream_baseDecl=new RewriteRuleSubtreeStream(adaptor,"rule baseDecl");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:394:5: ( ( baseDecl | prefixDecl )* -> ^( PROLOGUE ( baseDecl )* ( prefixDecl )* ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:394:7: ( baseDecl | prefixDecl )*
			{
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:394:7: ( baseDecl | prefixDecl )*
			loop34:
			while (true) {
				int alt34=3;
				int LA34_0 = input.LA(1);
				if ( (LA34_0==BASE) ) {
					alt34=1;
				}
				else if ( (LA34_0==PREFIX) ) {
					alt34=2;
				}

				switch (alt34) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:394:8: baseDecl
					{
					pushFollow(FOLLOW_baseDecl_in_prologue1686);
					baseDecl131=baseDecl();
					state._fsp--;

					stream_baseDecl.add(baseDecl131.getTree());
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:394:19: prefixDecl
					{
					pushFollow(FOLLOW_prefixDecl_in_prologue1690);
					prefixDecl132=prefixDecl();
					state._fsp--;

					stream_prefixDecl.add(prefixDecl132.getTree());
					}
					break;

				default :
					break loop34;
				}
			}

			// AST REWRITE
			// elements: prefixDecl, baseDecl
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 394:32: -> ^( PROLOGUE ( baseDecl )* ( prefixDecl )* )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:394:35: ^( PROLOGUE ( baseDecl )* ( prefixDecl )* )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(PROLOGUE, "PROLOGUE"), root_1);
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:394:46: ( baseDecl )*
				while ( stream_baseDecl.hasNext() ) {
					adaptor.addChild(root_1, stream_baseDecl.nextTree());
				}
				stream_baseDecl.reset();

				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:394:56: ( prefixDecl )*
				while ( stream_prefixDecl.hasNext() ) {
					adaptor.addChild(root_1, stream_prefixDecl.nextTree());
				}
				stream_prefixDecl.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "prologue"


	public static class baseDecl_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "baseDecl"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:397:1: baseDecl : BASE IRI_REF -> ^( BASE IRI_REF ) ;
	public final SparqlifyConfigParser.baseDecl_return baseDecl() throws RecognitionException {
		SparqlifyConfigParser.baseDecl_return retval = new SparqlifyConfigParser.baseDecl_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token BASE133=null;
		Token IRI_REF134=null;

		CommonTree BASE133_tree=null;
		CommonTree IRI_REF134_tree=null;
		RewriteRuleTokenStream stream_BASE=new RewriteRuleTokenStream(adaptor,"token BASE");
		RewriteRuleTokenStream stream_IRI_REF=new RewriteRuleTokenStream(adaptor,"token IRI_REF");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:398:5: ( BASE IRI_REF -> ^( BASE IRI_REF ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:398:7: BASE IRI_REF
			{
			BASE133=(Token)match(input,BASE,FOLLOW_BASE_in_baseDecl1721);  
			stream_BASE.add(BASE133);

			IRI_REF134=(Token)match(input,IRI_REF,FOLLOW_IRI_REF_in_baseDecl1723);  
			stream_IRI_REF.add(IRI_REF134);

			// AST REWRITE
			// elements: BASE, IRI_REF
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 398:20: -> ^( BASE IRI_REF )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:398:23: ^( BASE IRI_REF )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot(stream_BASE.nextNode(), root_1);
				adaptor.addChild(root_1, stream_IRI_REF.nextNode());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "baseDecl"


	public static class prefixDecl_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "prefixDecl"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:401:1: prefixDecl : PREFIX PNAME_NS IRI_REF -> ^( PREFIX PNAME_NS IRI_REF ) ;
	public final SparqlifyConfigParser.prefixDecl_return prefixDecl() throws RecognitionException {
		SparqlifyConfigParser.prefixDecl_return retval = new SparqlifyConfigParser.prefixDecl_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token PREFIX135=null;
		Token PNAME_NS136=null;
		Token IRI_REF137=null;

		CommonTree PREFIX135_tree=null;
		CommonTree PNAME_NS136_tree=null;
		CommonTree IRI_REF137_tree=null;
		RewriteRuleTokenStream stream_PREFIX=new RewriteRuleTokenStream(adaptor,"token PREFIX");
		RewriteRuleTokenStream stream_PNAME_NS=new RewriteRuleTokenStream(adaptor,"token PNAME_NS");
		RewriteRuleTokenStream stream_IRI_REF=new RewriteRuleTokenStream(adaptor,"token IRI_REF");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:402:5: ( PREFIX PNAME_NS IRI_REF -> ^( PREFIX PNAME_NS IRI_REF ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:402:7: PREFIX PNAME_NS IRI_REF
			{
			PREFIX135=(Token)match(input,PREFIX,FOLLOW_PREFIX_in_prefixDecl1748);  
			stream_PREFIX.add(PREFIX135);

			PNAME_NS136=(Token)match(input,PNAME_NS,FOLLOW_PNAME_NS_in_prefixDecl1750);  
			stream_PNAME_NS.add(PNAME_NS136);

			IRI_REF137=(Token)match(input,IRI_REF,FOLLOW_IRI_REF_in_prefixDecl1752);  
			stream_IRI_REF.add(IRI_REF137);

			// AST REWRITE
			// elements: IRI_REF, PNAME_NS, PREFIX
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 402:31: -> ^( PREFIX PNAME_NS IRI_REF )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:402:34: ^( PREFIX PNAME_NS IRI_REF )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot(stream_PREFIX.nextNode(), root_1);
				adaptor.addChild(root_1, stream_PNAME_NS.nextNode());
				adaptor.addChild(root_1, stream_IRI_REF.nextNode());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "prefixDecl"


	public static class selectQuery_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "selectQuery"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:405:1: selectQuery : selectClause ( datasetClause )* whereClause solutionModifier -> ^( SELECT selectClause ( datasetClause )* ( whereClause )* ( solutionModifier )* ) ;
	public final SparqlifyConfigParser.selectQuery_return selectQuery() throws RecognitionException {
		SparqlifyConfigParser.selectQuery_return retval = new SparqlifyConfigParser.selectQuery_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		ParserRuleReturnScope selectClause138 =null;
		ParserRuleReturnScope datasetClause139 =null;
		ParserRuleReturnScope whereClause140 =null;
		ParserRuleReturnScope solutionModifier141 =null;

		RewriteRuleSubtreeStream stream_whereClause=new RewriteRuleSubtreeStream(adaptor,"rule whereClause");
		RewriteRuleSubtreeStream stream_datasetClause=new RewriteRuleSubtreeStream(adaptor,"rule datasetClause");
		RewriteRuleSubtreeStream stream_solutionModifier=new RewriteRuleSubtreeStream(adaptor,"rule solutionModifier");
		RewriteRuleSubtreeStream stream_selectClause=new RewriteRuleSubtreeStream(adaptor,"rule selectClause");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:406:5: ( selectClause ( datasetClause )* whereClause solutionModifier -> ^( SELECT selectClause ( datasetClause )* ( whereClause )* ( solutionModifier )* ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:406:7: selectClause ( datasetClause )* whereClause solutionModifier
			{
			pushFollow(FOLLOW_selectClause_in_selectQuery1779);
			selectClause138=selectClause();
			state._fsp--;

			stream_selectClause.add(selectClause138.getTree());
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:406:20: ( datasetClause )*
			loop35:
			while (true) {
				int alt35=2;
				int LA35_0 = input.LA(1);
				if ( (LA35_0==FROM) ) {
					alt35=1;
				}

				switch (alt35) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:406:20: datasetClause
					{
					pushFollow(FOLLOW_datasetClause_in_selectQuery1781);
					datasetClause139=datasetClause();
					state._fsp--;

					stream_datasetClause.add(datasetClause139.getTree());
					}
					break;

				default :
					break loop35;
				}
			}

			pushFollow(FOLLOW_whereClause_in_selectQuery1784);
			whereClause140=whereClause();
			state._fsp--;

			stream_whereClause.add(whereClause140.getTree());
			pushFollow(FOLLOW_solutionModifier_in_selectQuery1786);
			solutionModifier141=solutionModifier();
			state._fsp--;

			stream_solutionModifier.add(solutionModifier141.getTree());
			// AST REWRITE
			// elements: solutionModifier, whereClause, selectClause, datasetClause
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 406:64: -> ^( SELECT selectClause ( datasetClause )* ( whereClause )* ( solutionModifier )* )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:406:67: ^( SELECT selectClause ( datasetClause )* ( whereClause )* ( solutionModifier )* )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(SELECT, "SELECT"), root_1);
				adaptor.addChild(root_1, stream_selectClause.nextTree());
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:406:89: ( datasetClause )*
				while ( stream_datasetClause.hasNext() ) {
					adaptor.addChild(root_1, stream_datasetClause.nextTree());
				}
				stream_datasetClause.reset();

				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:406:104: ( whereClause )*
				while ( stream_whereClause.hasNext() ) {
					adaptor.addChild(root_1, stream_whereClause.nextTree());
				}
				stream_whereClause.reset();

				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:406:117: ( solutionModifier )*
				while ( stream_solutionModifier.hasNext() ) {
					adaptor.addChild(root_1, stream_solutionModifier.nextTree());
				}
				stream_solutionModifier.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "selectQuery"


	public static class subSelect_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "subSelect"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:409:1: subSelect : selectClause whereClause solutionModifier -> ^( SUBSELECT ( whereClause )* solutionModifier ) ;
	public final SparqlifyConfigParser.subSelect_return subSelect() throws RecognitionException {
		SparqlifyConfigParser.subSelect_return retval = new SparqlifyConfigParser.subSelect_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		ParserRuleReturnScope selectClause142 =null;
		ParserRuleReturnScope whereClause143 =null;
		ParserRuleReturnScope solutionModifier144 =null;

		RewriteRuleSubtreeStream stream_whereClause=new RewriteRuleSubtreeStream(adaptor,"rule whereClause");
		RewriteRuleSubtreeStream stream_solutionModifier=new RewriteRuleSubtreeStream(adaptor,"rule solutionModifier");
		RewriteRuleSubtreeStream stream_selectClause=new RewriteRuleSubtreeStream(adaptor,"rule selectClause");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:410:5: ( selectClause whereClause solutionModifier -> ^( SUBSELECT ( whereClause )* solutionModifier ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:410:7: selectClause whereClause solutionModifier
			{
			pushFollow(FOLLOW_selectClause_in_subSelect1820);
			selectClause142=selectClause();
			state._fsp--;

			stream_selectClause.add(selectClause142.getTree());
			pushFollow(FOLLOW_whereClause_in_subSelect1822);
			whereClause143=whereClause();
			state._fsp--;

			stream_whereClause.add(whereClause143.getTree());
			pushFollow(FOLLOW_solutionModifier_in_subSelect1824);
			solutionModifier144=solutionModifier();
			state._fsp--;

			stream_solutionModifier.add(solutionModifier144.getTree());
			// AST REWRITE
			// elements: solutionModifier, whereClause
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 410:49: -> ^( SUBSELECT ( whereClause )* solutionModifier )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:410:52: ^( SUBSELECT ( whereClause )* solutionModifier )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(SUBSELECT, "SUBSELECT"), root_1);
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:410:64: ( whereClause )*
				while ( stream_whereClause.hasNext() ) {
					adaptor.addChild(root_1, stream_whereClause.nextTree());
				}
				stream_whereClause.reset();

				adaptor.addChild(root_1, stream_solutionModifier.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "subSelect"


	public static class selectClause_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "selectClause"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:413:1: selectClause : ( SELECT ( DISTINCT | REDUCED )? ASTERISK -> ^( SELECT_CLAUSE ( DISTINCT )* ( REDUCED )* ASTERISK ) | SELECT ( DISTINCT | REDUCED )? (v+= selectVariables )+ -> ^( SELECT_CLAUSE ( DISTINCT )* ( REDUCED )* ( $v)* ) );
	public final SparqlifyConfigParser.selectClause_return selectClause() throws RecognitionException {
		SparqlifyConfigParser.selectClause_return retval = new SparqlifyConfigParser.selectClause_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token SELECT145=null;
		Token DISTINCT146=null;
		Token REDUCED147=null;
		Token ASTERISK148=null;
		Token SELECT149=null;
		Token DISTINCT150=null;
		Token REDUCED151=null;
		List<Object> list_v=null;
		RuleReturnScope v = null;
		CommonTree SELECT145_tree=null;
		CommonTree DISTINCT146_tree=null;
		CommonTree REDUCED147_tree=null;
		CommonTree ASTERISK148_tree=null;
		CommonTree SELECT149_tree=null;
		CommonTree DISTINCT150_tree=null;
		CommonTree REDUCED151_tree=null;
		RewriteRuleTokenStream stream_SELECT=new RewriteRuleTokenStream(adaptor,"token SELECT");
		RewriteRuleTokenStream stream_DISTINCT=new RewriteRuleTokenStream(adaptor,"token DISTINCT");
		RewriteRuleTokenStream stream_REDUCED=new RewriteRuleTokenStream(adaptor,"token REDUCED");
		RewriteRuleTokenStream stream_ASTERISK=new RewriteRuleTokenStream(adaptor,"token ASTERISK");
		RewriteRuleSubtreeStream stream_selectVariables=new RewriteRuleSubtreeStream(adaptor,"rule selectVariables");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:414:5: ( SELECT ( DISTINCT | REDUCED )? ASTERISK -> ^( SELECT_CLAUSE ( DISTINCT )* ( REDUCED )* ASTERISK ) | SELECT ( DISTINCT | REDUCED )? (v+= selectVariables )+ -> ^( SELECT_CLAUSE ( DISTINCT )* ( REDUCED )* ( $v)* ) )
			int alt39=2;
			int LA39_0 = input.LA(1);
			if ( (LA39_0==SELECT) ) {
				switch ( input.LA(2) ) {
				case DISTINCT:
					{
					int LA39_2 = input.LA(3);
					if ( (LA39_2==ASTERISK) ) {
						alt39=1;
					}
					else if ( (LA39_2==OPEN_BRACE||(LA39_2 >= VAR1 && LA39_2 <= VAR3)) ) {
						alt39=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 39, 2, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case REDUCED:
					{
					int LA39_3 = input.LA(3);
					if ( (LA39_3==ASTERISK) ) {
						alt39=1;
					}
					else if ( (LA39_3==OPEN_BRACE||(LA39_3 >= VAR1 && LA39_3 <= VAR3)) ) {
						alt39=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 39, 3, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case ASTERISK:
					{
					alt39=1;
					}
					break;
				case OPEN_BRACE:
				case VAR1:
				case VAR2:
				case VAR3:
					{
					alt39=2;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 39, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 39, 0, input);
				throw nvae;
			}

			switch (alt39) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:414:7: SELECT ( DISTINCT | REDUCED )? ASTERISK
					{
					SELECT145=(Token)match(input,SELECT,FOLLOW_SELECT_in_selectClause1857);  
					stream_SELECT.add(SELECT145);

					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:414:14: ( DISTINCT | REDUCED )?
					int alt36=3;
					int LA36_0 = input.LA(1);
					if ( (LA36_0==DISTINCT) ) {
						alt36=1;
					}
					else if ( (LA36_0==REDUCED) ) {
						alt36=2;
					}
					switch (alt36) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:414:16: DISTINCT
							{
							DISTINCT146=(Token)match(input,DISTINCT,FOLLOW_DISTINCT_in_selectClause1861);  
							stream_DISTINCT.add(DISTINCT146);

							}
							break;
						case 2 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:414:27: REDUCED
							{
							REDUCED147=(Token)match(input,REDUCED,FOLLOW_REDUCED_in_selectClause1865);  
							stream_REDUCED.add(REDUCED147);

							}
							break;

					}

					ASTERISK148=(Token)match(input,ASTERISK,FOLLOW_ASTERISK_in_selectClause1870);  
					stream_ASTERISK.add(ASTERISK148);

					// AST REWRITE
					// elements: ASTERISK, REDUCED, DISTINCT
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 414:47: -> ^( SELECT_CLAUSE ( DISTINCT )* ( REDUCED )* ASTERISK )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:414:50: ^( SELECT_CLAUSE ( DISTINCT )* ( REDUCED )* ASTERISK )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(SELECT_CLAUSE, "SELECT_CLAUSE"), root_1);
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:414:66: ( DISTINCT )*
						while ( stream_DISTINCT.hasNext() ) {
							adaptor.addChild(root_1, stream_DISTINCT.nextNode());
						}
						stream_DISTINCT.reset();

						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:414:76: ( REDUCED )*
						while ( stream_REDUCED.hasNext() ) {
							adaptor.addChild(root_1, stream_REDUCED.nextNode());
						}
						stream_REDUCED.reset();

						adaptor.addChild(root_1, stream_ASTERISK.nextNode());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:415:7: SELECT ( DISTINCT | REDUCED )? (v+= selectVariables )+
					{
					SELECT149=(Token)match(input,SELECT,FOLLOW_SELECT_in_selectClause1892);  
					stream_SELECT.add(SELECT149);

					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:415:14: ( DISTINCT | REDUCED )?
					int alt37=3;
					int LA37_0 = input.LA(1);
					if ( (LA37_0==DISTINCT) ) {
						alt37=1;
					}
					else if ( (LA37_0==REDUCED) ) {
						alt37=2;
					}
					switch (alt37) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:415:16: DISTINCT
							{
							DISTINCT150=(Token)match(input,DISTINCT,FOLLOW_DISTINCT_in_selectClause1896);  
							stream_DISTINCT.add(DISTINCT150);

							}
							break;
						case 2 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:415:27: REDUCED
							{
							REDUCED151=(Token)match(input,REDUCED,FOLLOW_REDUCED_in_selectClause1900);  
							stream_REDUCED.add(REDUCED151);

							}
							break;

					}

					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:415:38: (v+= selectVariables )+
					int cnt38=0;
					loop38:
					while (true) {
						int alt38=2;
						int LA38_0 = input.LA(1);
						if ( (LA38_0==OPEN_BRACE||(LA38_0 >= VAR1 && LA38_0 <= VAR3)) ) {
							alt38=1;
						}

						switch (alt38) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:415:39: v+= selectVariables
							{
							pushFollow(FOLLOW_selectVariables_in_selectClause1908);
							v=selectVariables();
							state._fsp--;

							stream_selectVariables.add(v.getTree());
							if (list_v==null) list_v=new ArrayList<Object>();
							list_v.add(v.getTree());
							}
							break;

						default :
							if ( cnt38 >= 1 ) break loop38;
							EarlyExitException eee = new EarlyExitException(38, input);
							throw eee;
						}
						cnt38++;
					}

					// AST REWRITE
					// elements: v, DISTINCT, REDUCED
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: v
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);
					RewriteRuleSubtreeStream stream_v=new RewriteRuleSubtreeStream(adaptor,"token v",list_v);
					root_0 = (CommonTree)adaptor.nil();
					// 415:60: -> ^( SELECT_CLAUSE ( DISTINCT )* ( REDUCED )* ( $v)* )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:415:63: ^( SELECT_CLAUSE ( DISTINCT )* ( REDUCED )* ( $v)* )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(SELECT_CLAUSE, "SELECT_CLAUSE"), root_1);
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:415:79: ( DISTINCT )*
						while ( stream_DISTINCT.hasNext() ) {
							adaptor.addChild(root_1, stream_DISTINCT.nextNode());
						}
						stream_DISTINCT.reset();

						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:415:89: ( REDUCED )*
						while ( stream_REDUCED.hasNext() ) {
							adaptor.addChild(root_1, stream_REDUCED.nextNode());
						}
						stream_REDUCED.reset();

						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:415:99: ( $v)*
						while ( stream_v.hasNext() ) {
							adaptor.addChild(root_1, stream_v.nextTree());
						}
						stream_v.reset();

						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "selectClause"


	public static class selectVariables_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "selectVariables"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:418:1: selectVariables : (v= var -> ^( VAR $v) | OPEN_BRACE e= expression AS v= var CLOSE_BRACE -> ^( AS $e $v) );
	public final SparqlifyConfigParser.selectVariables_return selectVariables() throws RecognitionException {
		SparqlifyConfigParser.selectVariables_return retval = new SparqlifyConfigParser.selectVariables_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token OPEN_BRACE152=null;
		Token AS153=null;
		Token CLOSE_BRACE154=null;
		ParserRuleReturnScope v =null;
		ParserRuleReturnScope e =null;

		CommonTree OPEN_BRACE152_tree=null;
		CommonTree AS153_tree=null;
		CommonTree CLOSE_BRACE154_tree=null;
		RewriteRuleTokenStream stream_AS=new RewriteRuleTokenStream(adaptor,"token AS");
		RewriteRuleTokenStream stream_CLOSE_BRACE=new RewriteRuleTokenStream(adaptor,"token CLOSE_BRACE");
		RewriteRuleTokenStream stream_OPEN_BRACE=new RewriteRuleTokenStream(adaptor,"token OPEN_BRACE");
		RewriteRuleSubtreeStream stream_expression=new RewriteRuleSubtreeStream(adaptor,"rule expression");
		RewriteRuleSubtreeStream stream_var=new RewriteRuleSubtreeStream(adaptor,"rule var");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:419:5: (v= var -> ^( VAR $v) | OPEN_BRACE e= expression AS v= var CLOSE_BRACE -> ^( AS $e $v) )
			int alt40=2;
			int LA40_0 = input.LA(1);
			if ( ((LA40_0 >= VAR1 && LA40_0 <= VAR3)) ) {
				alt40=1;
			}
			else if ( (LA40_0==OPEN_BRACE) ) {
				alt40=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 40, 0, input);
				throw nvae;
			}

			switch (alt40) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:419:7: v= var
					{
					pushFollow(FOLLOW_var_in_selectVariables1945);
					v=var();
					state._fsp--;

					stream_var.add(v.getTree());
					// AST REWRITE
					// elements: v
					// token labels: 
					// rule labels: v, retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_v=new RewriteRuleSubtreeStream(adaptor,"rule v",v!=null?v.getTree():null);
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 419:13: -> ^( VAR $v)
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:419:16: ^( VAR $v)
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(VAR, "VAR"), root_1);
						adaptor.addChild(root_1, stream_v.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:420:7: OPEN_BRACE e= expression AS v= var CLOSE_BRACE
					{
					OPEN_BRACE152=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_selectVariables1963);  
					stream_OPEN_BRACE.add(OPEN_BRACE152);

					pushFollow(FOLLOW_expression_in_selectVariables1967);
					e=expression();
					state._fsp--;

					stream_expression.add(e.getTree());
					AS153=(Token)match(input,AS,FOLLOW_AS_in_selectVariables1969);  
					stream_AS.add(AS153);

					pushFollow(FOLLOW_var_in_selectVariables1973);
					v=var();
					state._fsp--;

					stream_var.add(v.getTree());
					CLOSE_BRACE154=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_selectVariables1975);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE154);

					// AST REWRITE
					// elements: v, AS, e
					// token labels: 
					// rule labels: v, retval, e
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_v=new RewriteRuleSubtreeStream(adaptor,"rule v",v!=null?v.getTree():null);
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);
					RewriteRuleSubtreeStream stream_e=new RewriteRuleSubtreeStream(adaptor,"rule e",e!=null?e.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 420:52: -> ^( AS $e $v)
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:420:55: ^( AS $e $v)
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_AS.nextNode(), root_1);
						adaptor.addChild(root_1, stream_e.nextTree());
						adaptor.addChild(root_1, stream_v.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "selectVariables"


	public static class constructQuery_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "constructQuery"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:423:1: constructQuery : ( CONSTRUCT constructTemplate ( datasetClause )* whereClause solutionModifier -> ^( CONSTRUCT ( constructTemplate )* ( datasetClause )* ( whereClause )* ( solutionModifier )* ) | CONSTRUCT ( datasetClause )* WHERE OPEN_CURLY_BRACE ( triplesTemplate )? CLOSE_CURLY_BRACE solutionModifier -> ^( CONSTRUCT ( datasetClause )* ^( WHERE ( triplesTemplate )* ) ( solutionModifier )* ) );
	public final SparqlifyConfigParser.constructQuery_return constructQuery() throws RecognitionException {
		SparqlifyConfigParser.constructQuery_return retval = new SparqlifyConfigParser.constructQuery_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token CONSTRUCT155=null;
		Token CONSTRUCT160=null;
		Token WHERE162=null;
		Token OPEN_CURLY_BRACE163=null;
		Token CLOSE_CURLY_BRACE165=null;
		ParserRuleReturnScope constructTemplate156 =null;
		ParserRuleReturnScope datasetClause157 =null;
		ParserRuleReturnScope whereClause158 =null;
		ParserRuleReturnScope solutionModifier159 =null;
		ParserRuleReturnScope datasetClause161 =null;
		ParserRuleReturnScope triplesTemplate164 =null;
		ParserRuleReturnScope solutionModifier166 =null;

		CommonTree CONSTRUCT155_tree=null;
		CommonTree CONSTRUCT160_tree=null;
		CommonTree WHERE162_tree=null;
		CommonTree OPEN_CURLY_BRACE163_tree=null;
		CommonTree CLOSE_CURLY_BRACE165_tree=null;
		RewriteRuleTokenStream stream_WHERE=new RewriteRuleTokenStream(adaptor,"token WHERE");
		RewriteRuleTokenStream stream_CONSTRUCT=new RewriteRuleTokenStream(adaptor,"token CONSTRUCT");
		RewriteRuleTokenStream stream_OPEN_CURLY_BRACE=new RewriteRuleTokenStream(adaptor,"token OPEN_CURLY_BRACE");
		RewriteRuleTokenStream stream_CLOSE_CURLY_BRACE=new RewriteRuleTokenStream(adaptor,"token CLOSE_CURLY_BRACE");
		RewriteRuleSubtreeStream stream_whereClause=new RewriteRuleSubtreeStream(adaptor,"rule whereClause");
		RewriteRuleSubtreeStream stream_triplesTemplate=new RewriteRuleSubtreeStream(adaptor,"rule triplesTemplate");
		RewriteRuleSubtreeStream stream_datasetClause=new RewriteRuleSubtreeStream(adaptor,"rule datasetClause");
		RewriteRuleSubtreeStream stream_solutionModifier=new RewriteRuleSubtreeStream(adaptor,"rule solutionModifier");
		RewriteRuleSubtreeStream stream_constructTemplate=new RewriteRuleSubtreeStream(adaptor,"rule constructTemplate");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:424:5: ( CONSTRUCT constructTemplate ( datasetClause )* whereClause solutionModifier -> ^( CONSTRUCT ( constructTemplate )* ( datasetClause )* ( whereClause )* ( solutionModifier )* ) | CONSTRUCT ( datasetClause )* WHERE OPEN_CURLY_BRACE ( triplesTemplate )? CLOSE_CURLY_BRACE solutionModifier -> ^( CONSTRUCT ( datasetClause )* ^( WHERE ( triplesTemplate )* ) ( solutionModifier )* ) )
			int alt44=2;
			int LA44_0 = input.LA(1);
			if ( (LA44_0==CONSTRUCT) ) {
				int LA44_1 = input.LA(2);
				if ( (LA44_1==OPEN_CURLY_BRACE) ) {
					alt44=1;
				}
				else if ( (LA44_1==FROM||LA44_1==WHERE) ) {
					alt44=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 44, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 44, 0, input);
				throw nvae;
			}

			switch (alt44) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:424:7: CONSTRUCT constructTemplate ( datasetClause )* whereClause solutionModifier
					{
					CONSTRUCT155=(Token)match(input,CONSTRUCT,FOLLOW_CONSTRUCT_in_constructQuery2006);  
					stream_CONSTRUCT.add(CONSTRUCT155);

					pushFollow(FOLLOW_constructTemplate_in_constructQuery2008);
					constructTemplate156=constructTemplate();
					state._fsp--;

					stream_constructTemplate.add(constructTemplate156.getTree());
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:424:35: ( datasetClause )*
					loop41:
					while (true) {
						int alt41=2;
						int LA41_0 = input.LA(1);
						if ( (LA41_0==FROM) ) {
							alt41=1;
						}

						switch (alt41) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:424:35: datasetClause
							{
							pushFollow(FOLLOW_datasetClause_in_constructQuery2010);
							datasetClause157=datasetClause();
							state._fsp--;

							stream_datasetClause.add(datasetClause157.getTree());
							}
							break;

						default :
							break loop41;
						}
					}

					pushFollow(FOLLOW_whereClause_in_constructQuery2013);
					whereClause158=whereClause();
					state._fsp--;

					stream_whereClause.add(whereClause158.getTree());
					pushFollow(FOLLOW_solutionModifier_in_constructQuery2015);
					solutionModifier159=solutionModifier();
					state._fsp--;

					stream_solutionModifier.add(solutionModifier159.getTree());
					// AST REWRITE
					// elements: solutionModifier, whereClause, CONSTRUCT, datasetClause, constructTemplate
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 424:79: -> ^( CONSTRUCT ( constructTemplate )* ( datasetClause )* ( whereClause )* ( solutionModifier )* )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:424:82: ^( CONSTRUCT ( constructTemplate )* ( datasetClause )* ( whereClause )* ( solutionModifier )* )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_CONSTRUCT.nextNode(), root_1);
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:424:94: ( constructTemplate )*
						while ( stream_constructTemplate.hasNext() ) {
							adaptor.addChild(root_1, stream_constructTemplate.nextTree());
						}
						stream_constructTemplate.reset();

						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:424:113: ( datasetClause )*
						while ( stream_datasetClause.hasNext() ) {
							adaptor.addChild(root_1, stream_datasetClause.nextTree());
						}
						stream_datasetClause.reset();

						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:424:128: ( whereClause )*
						while ( stream_whereClause.hasNext() ) {
							adaptor.addChild(root_1, stream_whereClause.nextTree());
						}
						stream_whereClause.reset();

						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:424:141: ( solutionModifier )*
						while ( stream_solutionModifier.hasNext() ) {
							adaptor.addChild(root_1, stream_solutionModifier.nextTree());
						}
						stream_solutionModifier.reset();

						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:425:7: CONSTRUCT ( datasetClause )* WHERE OPEN_CURLY_BRACE ( triplesTemplate )? CLOSE_CURLY_BRACE solutionModifier
					{
					CONSTRUCT160=(Token)match(input,CONSTRUCT,FOLLOW_CONSTRUCT_in_constructQuery2041);  
					stream_CONSTRUCT.add(CONSTRUCT160);

					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:425:17: ( datasetClause )*
					loop42:
					while (true) {
						int alt42=2;
						int LA42_0 = input.LA(1);
						if ( (LA42_0==FROM) ) {
							alt42=1;
						}

						switch (alt42) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:425:17: datasetClause
							{
							pushFollow(FOLLOW_datasetClause_in_constructQuery2043);
							datasetClause161=datasetClause();
							state._fsp--;

							stream_datasetClause.add(datasetClause161.getTree());
							}
							break;

						default :
							break loop42;
						}
					}

					WHERE162=(Token)match(input,WHERE,FOLLOW_WHERE_in_constructQuery2046);  
					stream_WHERE.add(WHERE162);

					OPEN_CURLY_BRACE163=(Token)match(input,OPEN_CURLY_BRACE,FOLLOW_OPEN_CURLY_BRACE_in_constructQuery2048);  
					stream_OPEN_CURLY_BRACE.add(OPEN_CURLY_BRACE163);

					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:425:55: ( triplesTemplate )?
					int alt43=2;
					int LA43_0 = input.LA(1);
					if ( (LA43_0==BLANK_NODE_LABEL||(LA43_0 >= DECIMAL && LA43_0 <= DECIMAL_POSITIVE)||(LA43_0 >= DOUBLE && LA43_0 <= DOUBLE_POSITIVE)||LA43_0==FALSE||(LA43_0 >= INTEGER && LA43_0 <= INTEGER_POSITIVE)||LA43_0==IRI_REF||LA43_0==OPEN_BRACE||LA43_0==OPEN_SQUARE_BRACKET||(LA43_0 >= PNAME_LN && LA43_0 <= PNAME_NS)||(LA43_0 >= STRING_LITERAL1 && LA43_0 <= STRING_LITERAL_LONG2)||LA43_0==TRUE||(LA43_0 >= VAR1 && LA43_0 <= VAR3)) ) {
						alt43=1;
					}
					switch (alt43) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:425:55: triplesTemplate
							{
							pushFollow(FOLLOW_triplesTemplate_in_constructQuery2050);
							triplesTemplate164=triplesTemplate();
							state._fsp--;

							stream_triplesTemplate.add(triplesTemplate164.getTree());
							}
							break;

					}

					CLOSE_CURLY_BRACE165=(Token)match(input,CLOSE_CURLY_BRACE,FOLLOW_CLOSE_CURLY_BRACE_in_constructQuery2053);  
					stream_CLOSE_CURLY_BRACE.add(CLOSE_CURLY_BRACE165);

					pushFollow(FOLLOW_solutionModifier_in_constructQuery2055);
					solutionModifier166=solutionModifier();
					state._fsp--;

					stream_solutionModifier.add(solutionModifier166.getTree());
					// AST REWRITE
					// elements: datasetClause, solutionModifier, WHERE, CONSTRUCT, triplesTemplate
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 425:107: -> ^( CONSTRUCT ( datasetClause )* ^( WHERE ( triplesTemplate )* ) ( solutionModifier )* )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:425:110: ^( CONSTRUCT ( datasetClause )* ^( WHERE ( triplesTemplate )* ) ( solutionModifier )* )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_CONSTRUCT.nextNode(), root_1);
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:425:122: ( datasetClause )*
						while ( stream_datasetClause.hasNext() ) {
							adaptor.addChild(root_1, stream_datasetClause.nextTree());
						}
						stream_datasetClause.reset();

						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:425:137: ^( WHERE ( triplesTemplate )* )
						{
						CommonTree root_2 = (CommonTree)adaptor.nil();
						root_2 = (CommonTree)adaptor.becomeRoot(stream_WHERE.nextNode(), root_2);
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:425:145: ( triplesTemplate )*
						while ( stream_triplesTemplate.hasNext() ) {
							adaptor.addChild(root_2, stream_triplesTemplate.nextTree());
						}
						stream_triplesTemplate.reset();

						adaptor.addChild(root_1, root_2);
						}

						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:425:163: ( solutionModifier )*
						while ( stream_solutionModifier.hasNext() ) {
							adaptor.addChild(root_1, stream_solutionModifier.nextTree());
						}
						stream_solutionModifier.reset();

						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "constructQuery"


	public static class describeQuery_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "describeQuery"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:428:1: describeQuery : DESCRIBE ( (v+= varOrIRIref )+ | ASTERISK ) ( datasetClause )* ( whereClause )? solutionModifier -> ^( DESCRIBE ( $v)* ( ASTERISK )* ( datasetClause )* ( whereClause )? ( solutionModifier )* ) ;
	public final SparqlifyConfigParser.describeQuery_return describeQuery() throws RecognitionException {
		SparqlifyConfigParser.describeQuery_return retval = new SparqlifyConfigParser.describeQuery_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token DESCRIBE167=null;
		Token ASTERISK168=null;
		List<Object> list_v=null;
		ParserRuleReturnScope datasetClause169 =null;
		ParserRuleReturnScope whereClause170 =null;
		ParserRuleReturnScope solutionModifier171 =null;
		RuleReturnScope v = null;
		CommonTree DESCRIBE167_tree=null;
		CommonTree ASTERISK168_tree=null;
		RewriteRuleTokenStream stream_ASTERISK=new RewriteRuleTokenStream(adaptor,"token ASTERISK");
		RewriteRuleTokenStream stream_DESCRIBE=new RewriteRuleTokenStream(adaptor,"token DESCRIBE");
		RewriteRuleSubtreeStream stream_varOrIRIref=new RewriteRuleSubtreeStream(adaptor,"rule varOrIRIref");
		RewriteRuleSubtreeStream stream_whereClause=new RewriteRuleSubtreeStream(adaptor,"rule whereClause");
		RewriteRuleSubtreeStream stream_datasetClause=new RewriteRuleSubtreeStream(adaptor,"rule datasetClause");
		RewriteRuleSubtreeStream stream_solutionModifier=new RewriteRuleSubtreeStream(adaptor,"rule solutionModifier");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:429:5: ( DESCRIBE ( (v+= varOrIRIref )+ | ASTERISK ) ( datasetClause )* ( whereClause )? solutionModifier -> ^( DESCRIBE ( $v)* ( ASTERISK )* ( datasetClause )* ( whereClause )? ( solutionModifier )* ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:429:7: DESCRIBE ( (v+= varOrIRIref )+ | ASTERISK ) ( datasetClause )* ( whereClause )? solutionModifier
			{
			DESCRIBE167=(Token)match(input,DESCRIBE,FOLLOW_DESCRIBE_in_describeQuery2091);  
			stream_DESCRIBE.add(DESCRIBE167);

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:429:16: ( (v+= varOrIRIref )+ | ASTERISK )
			int alt46=2;
			int LA46_0 = input.LA(1);
			if ( (LA46_0==IRI_REF||(LA46_0 >= PNAME_LN && LA46_0 <= PNAME_NS)||(LA46_0 >= VAR1 && LA46_0 <= VAR3)) ) {
				alt46=1;
			}
			else if ( (LA46_0==ASTERISK) ) {
				alt46=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 46, 0, input);
				throw nvae;
			}

			switch (alt46) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:429:18: (v+= varOrIRIref )+
					{
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:429:18: (v+= varOrIRIref )+
					int cnt45=0;
					loop45:
					while (true) {
						int alt45=2;
						int LA45_0 = input.LA(1);
						if ( (LA45_0==IRI_REF||(LA45_0 >= PNAME_LN && LA45_0 <= PNAME_NS)||(LA45_0 >= VAR1 && LA45_0 <= VAR3)) ) {
							alt45=1;
						}

						switch (alt45) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:429:19: v+= varOrIRIref
							{
							pushFollow(FOLLOW_varOrIRIref_in_describeQuery2098);
							v=varOrIRIref();
							state._fsp--;

							stream_varOrIRIref.add(v.getTree());
							if (list_v==null) list_v=new ArrayList<Object>();
							list_v.add(v.getTree());
							}
							break;

						default :
							if ( cnt45 >= 1 ) break loop45;
							EarlyExitException eee = new EarlyExitException(45, input);
							throw eee;
						}
						cnt45++;
					}

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:429:38: ASTERISK
					{
					ASTERISK168=(Token)match(input,ASTERISK,FOLLOW_ASTERISK_in_describeQuery2104);  
					stream_ASTERISK.add(ASTERISK168);

					}
					break;

			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:429:49: ( datasetClause )*
			loop47:
			while (true) {
				int alt47=2;
				int LA47_0 = input.LA(1);
				if ( (LA47_0==FROM) ) {
					alt47=1;
				}

				switch (alt47) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:429:49: datasetClause
					{
					pushFollow(FOLLOW_datasetClause_in_describeQuery2108);
					datasetClause169=datasetClause();
					state._fsp--;

					stream_datasetClause.add(datasetClause169.getTree());
					}
					break;

				default :
					break loop47;
				}
			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:429:64: ( whereClause )?
			int alt48=2;
			int LA48_0 = input.LA(1);
			if ( (LA48_0==OPEN_CURLY_BRACE||LA48_0==WHERE) ) {
				alt48=1;
			}
			switch (alt48) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:429:64: whereClause
					{
					pushFollow(FOLLOW_whereClause_in_describeQuery2111);
					whereClause170=whereClause();
					state._fsp--;

					stream_whereClause.add(whereClause170.getTree());
					}
					break;

			}

			pushFollow(FOLLOW_solutionModifier_in_describeQuery2114);
			solutionModifier171=solutionModifier();
			state._fsp--;

			stream_solutionModifier.add(solutionModifier171.getTree());
			// AST REWRITE
			// elements: datasetClause, DESCRIBE, solutionModifier, whereClause, ASTERISK, v
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: v
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);
			RewriteRuleSubtreeStream stream_v=new RewriteRuleSubtreeStream(adaptor,"token v",list_v);
			root_0 = (CommonTree)adaptor.nil();
			// 429:94: -> ^( DESCRIBE ( $v)* ( ASTERISK )* ( datasetClause )* ( whereClause )? ( solutionModifier )* )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:429:97: ^( DESCRIBE ( $v)* ( ASTERISK )* ( datasetClause )* ( whereClause )? ( solutionModifier )* )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot(stream_DESCRIBE.nextNode(), root_1);
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:429:109: ( $v)*
				while ( stream_v.hasNext() ) {
					adaptor.addChild(root_1, stream_v.nextTree());
				}
				stream_v.reset();

				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:429:112: ( ASTERISK )*
				while ( stream_ASTERISK.hasNext() ) {
					adaptor.addChild(root_1, stream_ASTERISK.nextNode());
				}
				stream_ASTERISK.reset();

				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:429:122: ( datasetClause )*
				while ( stream_datasetClause.hasNext() ) {
					adaptor.addChild(root_1, stream_datasetClause.nextTree());
				}
				stream_datasetClause.reset();

				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:429:137: ( whereClause )?
				if ( stream_whereClause.hasNext() ) {
					adaptor.addChild(root_1, stream_whereClause.nextTree());
				}
				stream_whereClause.reset();

				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:429:150: ( solutionModifier )*
				while ( stream_solutionModifier.hasNext() ) {
					adaptor.addChild(root_1, stream_solutionModifier.nextTree());
				}
				stream_solutionModifier.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "describeQuery"


	public static class askQuery_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "askQuery"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:432:1: askQuery : ASK ( datasetClause )* whereClause -> ^( ASK ( datasetClause )* whereClause ) ;
	public final SparqlifyConfigParser.askQuery_return askQuery() throws RecognitionException {
		SparqlifyConfigParser.askQuery_return retval = new SparqlifyConfigParser.askQuery_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token ASK172=null;
		ParserRuleReturnScope datasetClause173 =null;
		ParserRuleReturnScope whereClause174 =null;

		CommonTree ASK172_tree=null;
		RewriteRuleTokenStream stream_ASK=new RewriteRuleTokenStream(adaptor,"token ASK");
		RewriteRuleSubtreeStream stream_whereClause=new RewriteRuleSubtreeStream(adaptor,"rule whereClause");
		RewriteRuleSubtreeStream stream_datasetClause=new RewriteRuleSubtreeStream(adaptor,"rule datasetClause");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:433:5: ( ASK ( datasetClause )* whereClause -> ^( ASK ( datasetClause )* whereClause ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:433:7: ASK ( datasetClause )* whereClause
			{
			ASK172=(Token)match(input,ASK,FOLLOW_ASK_in_askQuery2153);  
			stream_ASK.add(ASK172);

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:433:11: ( datasetClause )*
			loop49:
			while (true) {
				int alt49=2;
				int LA49_0 = input.LA(1);
				if ( (LA49_0==FROM) ) {
					alt49=1;
				}

				switch (alt49) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:433:11: datasetClause
					{
					pushFollow(FOLLOW_datasetClause_in_askQuery2155);
					datasetClause173=datasetClause();
					state._fsp--;

					stream_datasetClause.add(datasetClause173.getTree());
					}
					break;

				default :
					break loop49;
				}
			}

			pushFollow(FOLLOW_whereClause_in_askQuery2158);
			whereClause174=whereClause();
			state._fsp--;

			stream_whereClause.add(whereClause174.getTree());
			// AST REWRITE
			// elements: whereClause, ASK, datasetClause
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 433:38: -> ^( ASK ( datasetClause )* whereClause )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:433:41: ^( ASK ( datasetClause )* whereClause )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot(stream_ASK.nextNode(), root_1);
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:433:47: ( datasetClause )*
				while ( stream_datasetClause.hasNext() ) {
					adaptor.addChild(root_1, stream_datasetClause.nextTree());
				}
				stream_datasetClause.reset();

				adaptor.addChild(root_1, stream_whereClause.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "askQuery"


	public static class datasetClause_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "datasetClause"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:436:1: datasetClause : FROM ( NAMED )? iriRef -> ^( FROM ( NAMED )? iriRef ) ;
	public final SparqlifyConfigParser.datasetClause_return datasetClause() throws RecognitionException {
		SparqlifyConfigParser.datasetClause_return retval = new SparqlifyConfigParser.datasetClause_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token FROM175=null;
		Token NAMED176=null;
		ParserRuleReturnScope iriRef177 =null;

		CommonTree FROM175_tree=null;
		CommonTree NAMED176_tree=null;
		RewriteRuleTokenStream stream_FROM=new RewriteRuleTokenStream(adaptor,"token FROM");
		RewriteRuleTokenStream stream_NAMED=new RewriteRuleTokenStream(adaptor,"token NAMED");
		RewriteRuleSubtreeStream stream_iriRef=new RewriteRuleSubtreeStream(adaptor,"rule iriRef");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:437:5: ( FROM ( NAMED )? iriRef -> ^( FROM ( NAMED )? iriRef ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:437:7: FROM ( NAMED )? iriRef
			{
			FROM175=(Token)match(input,FROM,FOLLOW_FROM_in_datasetClause2186);  
			stream_FROM.add(FROM175);

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:437:12: ( NAMED )?
			int alt50=2;
			int LA50_0 = input.LA(1);
			if ( (LA50_0==NAMED) ) {
				alt50=1;
			}
			switch (alt50) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:437:12: NAMED
					{
					NAMED176=(Token)match(input,NAMED,FOLLOW_NAMED_in_datasetClause2188);  
					stream_NAMED.add(NAMED176);

					}
					break;

			}

			pushFollow(FOLLOW_iriRef_in_datasetClause2191);
			iriRef177=iriRef();
			state._fsp--;

			stream_iriRef.add(iriRef177.getTree());
			// AST REWRITE
			// elements: iriRef, FROM, NAMED
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 437:26: -> ^( FROM ( NAMED )? iriRef )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:437:29: ^( FROM ( NAMED )? iriRef )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot(stream_FROM.nextNode(), root_1);
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:437:36: ( NAMED )?
				if ( stream_NAMED.hasNext() ) {
					adaptor.addChild(root_1, stream_NAMED.nextNode());
				}
				stream_NAMED.reset();

				adaptor.addChild(root_1, stream_iriRef.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "datasetClause"


	public static class whereClause_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "whereClause"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:440:1: whereClause : ( WHERE )? groupGraphPattern -> ^( WHERE_CLAUSE groupGraphPattern ) ;
	public final SparqlifyConfigParser.whereClause_return whereClause() throws RecognitionException {
		SparqlifyConfigParser.whereClause_return retval = new SparqlifyConfigParser.whereClause_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token WHERE178=null;
		ParserRuleReturnScope groupGraphPattern179 =null;

		CommonTree WHERE178_tree=null;
		RewriteRuleTokenStream stream_WHERE=new RewriteRuleTokenStream(adaptor,"token WHERE");
		RewriteRuleSubtreeStream stream_groupGraphPattern=new RewriteRuleSubtreeStream(adaptor,"rule groupGraphPattern");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:441:5: ( ( WHERE )? groupGraphPattern -> ^( WHERE_CLAUSE groupGraphPattern ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:441:7: ( WHERE )? groupGraphPattern
			{
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:441:7: ( WHERE )?
			int alt51=2;
			int LA51_0 = input.LA(1);
			if ( (LA51_0==WHERE) ) {
				alt51=1;
			}
			switch (alt51) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:441:7: WHERE
					{
					WHERE178=(Token)match(input,WHERE,FOLLOW_WHERE_in_whereClause2219);  
					stream_WHERE.add(WHERE178);

					}
					break;

			}

			pushFollow(FOLLOW_groupGraphPattern_in_whereClause2222);
			groupGraphPattern179=groupGraphPattern();
			state._fsp--;

			stream_groupGraphPattern.add(groupGraphPattern179.getTree());
			// AST REWRITE
			// elements: groupGraphPattern
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 441:32: -> ^( WHERE_CLAUSE groupGraphPattern )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:441:35: ^( WHERE_CLAUSE groupGraphPattern )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(WHERE_CLAUSE, "WHERE_CLAUSE"), root_1);
				adaptor.addChild(root_1, stream_groupGraphPattern.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "whereClause"


	public static class solutionModifier_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "solutionModifier"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:444:1: solutionModifier : ( groupClause )? ( havingClause )? ( orderClause )? ( limitOffsetClauses )? -> ( groupClause )* ( havingClause )* ( orderClause )* ( limitOffsetClauses )* ;
	public final SparqlifyConfigParser.solutionModifier_return solutionModifier() throws RecognitionException {
		SparqlifyConfigParser.solutionModifier_return retval = new SparqlifyConfigParser.solutionModifier_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		ParserRuleReturnScope groupClause180 =null;
		ParserRuleReturnScope havingClause181 =null;
		ParserRuleReturnScope orderClause182 =null;
		ParserRuleReturnScope limitOffsetClauses183 =null;

		RewriteRuleSubtreeStream stream_limitOffsetClauses=new RewriteRuleSubtreeStream(adaptor,"rule limitOffsetClauses");
		RewriteRuleSubtreeStream stream_orderClause=new RewriteRuleSubtreeStream(adaptor,"rule orderClause");
		RewriteRuleSubtreeStream stream_groupClause=new RewriteRuleSubtreeStream(adaptor,"rule groupClause");
		RewriteRuleSubtreeStream stream_havingClause=new RewriteRuleSubtreeStream(adaptor,"rule havingClause");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:445:5: ( ( groupClause )? ( havingClause )? ( orderClause )? ( limitOffsetClauses )? -> ( groupClause )* ( havingClause )* ( orderClause )* ( limitOffsetClauses )* )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:445:7: ( groupClause )? ( havingClause )? ( orderClause )? ( limitOffsetClauses )?
			{
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:445:7: ( groupClause )?
			int alt52=2;
			int LA52_0 = input.LA(1);
			if ( (LA52_0==GROUP) ) {
				alt52=1;
			}
			switch (alt52) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:445:7: groupClause
					{
					pushFollow(FOLLOW_groupClause_in_solutionModifier2247);
					groupClause180=groupClause();
					state._fsp--;

					stream_groupClause.add(groupClause180.getTree());
					}
					break;

			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:445:20: ( havingClause )?
			int alt53=2;
			int LA53_0 = input.LA(1);
			if ( (LA53_0==HAVING) ) {
				alt53=1;
			}
			switch (alt53) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:445:20: havingClause
					{
					pushFollow(FOLLOW_havingClause_in_solutionModifier2250);
					havingClause181=havingClause();
					state._fsp--;

					stream_havingClause.add(havingClause181.getTree());
					}
					break;

			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:445:34: ( orderClause )?
			int alt54=2;
			int LA54_0 = input.LA(1);
			if ( (LA54_0==ORDER) ) {
				alt54=1;
			}
			switch (alt54) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:445:34: orderClause
					{
					pushFollow(FOLLOW_orderClause_in_solutionModifier2253);
					orderClause182=orderClause();
					state._fsp--;

					stream_orderClause.add(orderClause182.getTree());
					}
					break;

			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:445:47: ( limitOffsetClauses )?
			int alt55=2;
			int LA55_0 = input.LA(1);
			if ( (LA55_0==LIMIT||LA55_0==OFFSET) ) {
				alt55=1;
			}
			switch (alt55) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:445:47: limitOffsetClauses
					{
					pushFollow(FOLLOW_limitOffsetClauses_in_solutionModifier2256);
					limitOffsetClauses183=limitOffsetClauses();
					state._fsp--;

					stream_limitOffsetClauses.add(limitOffsetClauses183.getTree());
					}
					break;

			}

			// AST REWRITE
			// elements: limitOffsetClauses, orderClause, havingClause, groupClause
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 445:67: -> ( groupClause )* ( havingClause )* ( orderClause )* ( limitOffsetClauses )*
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:445:70: ( groupClause )*
				while ( stream_groupClause.hasNext() ) {
					adaptor.addChild(root_0, stream_groupClause.nextTree());
				}
				stream_groupClause.reset();

				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:445:83: ( havingClause )*
				while ( stream_havingClause.hasNext() ) {
					adaptor.addChild(root_0, stream_havingClause.nextTree());
				}
				stream_havingClause.reset();

				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:445:97: ( orderClause )*
				while ( stream_orderClause.hasNext() ) {
					adaptor.addChild(root_0, stream_orderClause.nextTree());
				}
				stream_orderClause.reset();

				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:445:110: ( limitOffsetClauses )*
				while ( stream_limitOffsetClauses.hasNext() ) {
					adaptor.addChild(root_0, stream_limitOffsetClauses.nextTree());
				}
				stream_limitOffsetClauses.reset();

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "solutionModifier"


	public static class groupClause_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "groupClause"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:448:1: groupClause : GROUP BY ( groupCondition )+ -> ^( GROUP_BY ( groupCondition )+ ) ;
	public final SparqlifyConfigParser.groupClause_return groupClause() throws RecognitionException {
		SparqlifyConfigParser.groupClause_return retval = new SparqlifyConfigParser.groupClause_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token GROUP184=null;
		Token BY185=null;
		ParserRuleReturnScope groupCondition186 =null;

		CommonTree GROUP184_tree=null;
		CommonTree BY185_tree=null;
		RewriteRuleTokenStream stream_GROUP=new RewriteRuleTokenStream(adaptor,"token GROUP");
		RewriteRuleTokenStream stream_BY=new RewriteRuleTokenStream(adaptor,"token BY");
		RewriteRuleSubtreeStream stream_groupCondition=new RewriteRuleSubtreeStream(adaptor,"rule groupCondition");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:449:5: ( GROUP BY ( groupCondition )+ -> ^( GROUP_BY ( groupCondition )+ ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:449:7: GROUP BY ( groupCondition )+
			{
			GROUP184=(Token)match(input,GROUP,FOLLOW_GROUP_in_groupClause2288);  
			stream_GROUP.add(GROUP184);

			BY185=(Token)match(input,BY,FOLLOW_BY_in_groupClause2290);  
			stream_BY.add(BY185);

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:449:16: ( groupCondition )+
			int cnt56=0;
			loop56:
			while (true) {
				int alt56=2;
				int LA56_0 = input.LA(1);
				if ( (LA56_0==ABS||(LA56_0 >= BNODE && LA56_0 <= BOUND)||LA56_0==CEIL||LA56_0==COALESCE||LA56_0==CONCAT||LA56_0==CONTAINS||(LA56_0 >= DATATYPE && LA56_0 <= DAY)||LA56_0==ENCODE_FOR_URI||LA56_0==EXISTS||LA56_0==FLOOR||(LA56_0 >= HOURS && LA56_0 <= IF)||(LA56_0 >= IRI && LA56_0 <= IRI_REF)||(LA56_0 >= ISBLANK && LA56_0 <= ISURI)||(LA56_0 >= LANG && LA56_0 <= LANGMATCHES)||LA56_0==LCASE||LA56_0==MD5||LA56_0==MINUTES||LA56_0==MONTH||LA56_0==NOT||LA56_0==NOW||LA56_0==OPEN_BRACE||(LA56_0 >= PNAME_LN && LA56_0 <= PNAME_NS)||LA56_0==RAND||LA56_0==REGEX||(LA56_0 >= ROUND && LA56_0 <= SAMETERM)||LA56_0==SECONDS||(LA56_0 >= SHA1 && LA56_0 <= SHA512)||(LA56_0 >= STR && LA56_0 <= STRENDS)||(LA56_0 >= STRLANG && LA56_0 <= STRSTARTS)||LA56_0==SUBSTR||LA56_0==TIMEZONE||(LA56_0 >= TZ && LA56_0 <= UCASE)||LA56_0==URI||(LA56_0 >= VAR1 && LA56_0 <= VAR3)||LA56_0==YEAR) ) {
					alt56=1;
				}

				switch (alt56) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:449:16: groupCondition
					{
					pushFollow(FOLLOW_groupCondition_in_groupClause2292);
					groupCondition186=groupCondition();
					state._fsp--;

					stream_groupCondition.add(groupCondition186.getTree());
					}
					break;

				default :
					if ( cnt56 >= 1 ) break loop56;
					EarlyExitException eee = new EarlyExitException(56, input);
					throw eee;
				}
				cnt56++;
			}

			// AST REWRITE
			// elements: groupCondition
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 449:32: -> ^( GROUP_BY ( groupCondition )+ )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:449:35: ^( GROUP_BY ( groupCondition )+ )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(GROUP_BY, "GROUP_BY"), root_1);
				if ( !(stream_groupCondition.hasNext()) ) {
					throw new RewriteEarlyExitException();
				}
				while ( stream_groupCondition.hasNext() ) {
					adaptor.addChild(root_1, stream_groupCondition.nextTree());
				}
				stream_groupCondition.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "groupClause"


	public static class groupCondition_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "groupCondition"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:452:1: groupCondition : ( builtInCall | functionCall | OPEN_BRACE expression ( AS var )? CLOSE_BRACE -> ^( AS expression ( var )* ) | var );
	public final SparqlifyConfigParser.groupCondition_return groupCondition() throws RecognitionException {
		SparqlifyConfigParser.groupCondition_return retval = new SparqlifyConfigParser.groupCondition_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token OPEN_BRACE189=null;
		Token AS191=null;
		Token CLOSE_BRACE193=null;
		ParserRuleReturnScope builtInCall187 =null;
		ParserRuleReturnScope functionCall188 =null;
		ParserRuleReturnScope expression190 =null;
		ParserRuleReturnScope var192 =null;
		ParserRuleReturnScope var194 =null;

		CommonTree OPEN_BRACE189_tree=null;
		CommonTree AS191_tree=null;
		CommonTree CLOSE_BRACE193_tree=null;
		RewriteRuleTokenStream stream_AS=new RewriteRuleTokenStream(adaptor,"token AS");
		RewriteRuleTokenStream stream_CLOSE_BRACE=new RewriteRuleTokenStream(adaptor,"token CLOSE_BRACE");
		RewriteRuleTokenStream stream_OPEN_BRACE=new RewriteRuleTokenStream(adaptor,"token OPEN_BRACE");
		RewriteRuleSubtreeStream stream_expression=new RewriteRuleSubtreeStream(adaptor,"rule expression");
		RewriteRuleSubtreeStream stream_var=new RewriteRuleSubtreeStream(adaptor,"rule var");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:453:5: ( builtInCall | functionCall | OPEN_BRACE expression ( AS var )? CLOSE_BRACE -> ^( AS expression ( var )* ) | var )
			int alt58=4;
			switch ( input.LA(1) ) {
			case ABS:
			case BNODE:
			case BOUND:
			case CEIL:
			case COALESCE:
			case CONCAT:
			case CONTAINS:
			case DATATYPE:
			case DAY:
			case ENCODE_FOR_URI:
			case EXISTS:
			case FLOOR:
			case HOURS:
			case IF:
			case IRI:
			case ISBLANK:
			case ISIRI:
			case ISLITERAL:
			case ISNUMERIC:
			case ISURI:
			case LANG:
			case LANGMATCHES:
			case LCASE:
			case MD5:
			case MINUTES:
			case MONTH:
			case NOT:
			case NOW:
			case RAND:
			case REGEX:
			case ROUND:
			case SAMETERM:
			case SECONDS:
			case SHA1:
			case SHA224:
			case SHA256:
			case SHA384:
			case SHA512:
			case STR:
			case STRDT:
			case STRENDS:
			case STRLANG:
			case STRLEN:
			case STRSTARTS:
			case SUBSTR:
			case TIMEZONE:
			case TZ:
			case UCASE:
			case URI:
			case YEAR:
				{
				alt58=1;
				}
				break;
			case IRI_REF:
			case PNAME_LN:
			case PNAME_NS:
				{
				alt58=2;
				}
				break;
			case OPEN_BRACE:
				{
				alt58=3;
				}
				break;
			case VAR1:
			case VAR2:
			case VAR3:
				{
				alt58=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 58, 0, input);
				throw nvae;
			}
			switch (alt58) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:453:7: builtInCall
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_builtInCall_in_groupCondition2326);
					builtInCall187=builtInCall();
					state._fsp--;

					adaptor.addChild(root_0, builtInCall187.getTree());

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:454:7: functionCall
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_functionCall_in_groupCondition2334);
					functionCall188=functionCall();
					state._fsp--;

					adaptor.addChild(root_0, functionCall188.getTree());

					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:455:7: OPEN_BRACE expression ( AS var )? CLOSE_BRACE
					{
					OPEN_BRACE189=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_groupCondition2342);  
					stream_OPEN_BRACE.add(OPEN_BRACE189);

					pushFollow(FOLLOW_expression_in_groupCondition2344);
					expression190=expression();
					state._fsp--;

					stream_expression.add(expression190.getTree());
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:455:29: ( AS var )?
					int alt57=2;
					int LA57_0 = input.LA(1);
					if ( (LA57_0==AS) ) {
						alt57=1;
					}
					switch (alt57) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:455:30: AS var
							{
							AS191=(Token)match(input,AS,FOLLOW_AS_in_groupCondition2347);  
							stream_AS.add(AS191);

							pushFollow(FOLLOW_var_in_groupCondition2349);
							var192=var();
							state._fsp--;

							stream_var.add(var192.getTree());
							}
							break;

					}

					CLOSE_BRACE193=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_groupCondition2353);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE193);

					// AST REWRITE
					// elements: var, expression, AS
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 455:51: -> ^( AS expression ( var )* )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:455:54: ^( AS expression ( var )* )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_AS.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:455:70: ( var )*
						while ( stream_var.hasNext() ) {
							adaptor.addChild(root_1, stream_var.nextTree());
						}
						stream_var.reset();

						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:456:7: var
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_var_in_groupCondition2372);
					var194=var();
					state._fsp--;

					adaptor.addChild(root_0, var194.getTree());

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "groupCondition"


	public static class havingClause_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "havingClause"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:459:1: havingClause : HAVING ( constraint )+ -> ^( HAVING ( constraint )+ ) ;
	public final SparqlifyConfigParser.havingClause_return havingClause() throws RecognitionException {
		SparqlifyConfigParser.havingClause_return retval = new SparqlifyConfigParser.havingClause_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token HAVING195=null;
		ParserRuleReturnScope constraint196 =null;

		CommonTree HAVING195_tree=null;
		RewriteRuleTokenStream stream_HAVING=new RewriteRuleTokenStream(adaptor,"token HAVING");
		RewriteRuleSubtreeStream stream_constraint=new RewriteRuleSubtreeStream(adaptor,"rule constraint");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:460:5: ( HAVING ( constraint )+ -> ^( HAVING ( constraint )+ ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:460:7: HAVING ( constraint )+
			{
			HAVING195=(Token)match(input,HAVING,FOLLOW_HAVING_in_havingClause2393);  
			stream_HAVING.add(HAVING195);

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:460:14: ( constraint )+
			int cnt59=0;
			loop59:
			while (true) {
				int alt59=2;
				int LA59_0 = input.LA(1);
				if ( (LA59_0==ABS||(LA59_0 >= BNODE && LA59_0 <= BOUND)||LA59_0==CEIL||LA59_0==COALESCE||LA59_0==CONCAT||LA59_0==CONTAINS||(LA59_0 >= DATATYPE && LA59_0 <= DAY)||LA59_0==ENCODE_FOR_URI||LA59_0==EXISTS||LA59_0==FLOOR||(LA59_0 >= HOURS && LA59_0 <= IF)||(LA59_0 >= IRI && LA59_0 <= IRI_REF)||(LA59_0 >= ISBLANK && LA59_0 <= ISURI)||(LA59_0 >= LANG && LA59_0 <= LANGMATCHES)||LA59_0==LCASE||LA59_0==MD5||LA59_0==MINUTES||LA59_0==MONTH||LA59_0==NOT||LA59_0==NOW||LA59_0==OPEN_BRACE||(LA59_0 >= PNAME_LN && LA59_0 <= PNAME_NS)||LA59_0==RAND||LA59_0==REGEX||(LA59_0 >= ROUND && LA59_0 <= SAMETERM)||LA59_0==SECONDS||(LA59_0 >= SHA1 && LA59_0 <= SHA512)||(LA59_0 >= STR && LA59_0 <= STRENDS)||(LA59_0 >= STRLANG && LA59_0 <= STRSTARTS)||LA59_0==SUBSTR||LA59_0==TIMEZONE||(LA59_0 >= TZ && LA59_0 <= UCASE)||LA59_0==URI||LA59_0==YEAR) ) {
					alt59=1;
				}

				switch (alt59) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:460:14: constraint
					{
					pushFollow(FOLLOW_constraint_in_havingClause2395);
					constraint196=constraint();
					state._fsp--;

					stream_constraint.add(constraint196.getTree());
					}
					break;

				default :
					if ( cnt59 >= 1 ) break loop59;
					EarlyExitException eee = new EarlyExitException(59, input);
					throw eee;
				}
				cnt59++;
			}

			// AST REWRITE
			// elements: constraint, HAVING
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 460:26: -> ^( HAVING ( constraint )+ )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:460:29: ^( HAVING ( constraint )+ )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot(stream_HAVING.nextNode(), root_1);
				if ( !(stream_constraint.hasNext()) ) {
					throw new RewriteEarlyExitException();
				}
				while ( stream_constraint.hasNext() ) {
					adaptor.addChild(root_1, stream_constraint.nextTree());
				}
				stream_constraint.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "havingClause"


	public static class orderClause_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "orderClause"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:463:1: orderClause : ORDER BY ( orderCondition )+ -> ^( ORDER_BY ( orderCondition )+ ) ;
	public final SparqlifyConfigParser.orderClause_return orderClause() throws RecognitionException {
		SparqlifyConfigParser.orderClause_return retval = new SparqlifyConfigParser.orderClause_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token ORDER197=null;
		Token BY198=null;
		ParserRuleReturnScope orderCondition199 =null;

		CommonTree ORDER197_tree=null;
		CommonTree BY198_tree=null;
		RewriteRuleTokenStream stream_BY=new RewriteRuleTokenStream(adaptor,"token BY");
		RewriteRuleTokenStream stream_ORDER=new RewriteRuleTokenStream(adaptor,"token ORDER");
		RewriteRuleSubtreeStream stream_orderCondition=new RewriteRuleSubtreeStream(adaptor,"rule orderCondition");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:464:5: ( ORDER BY ( orderCondition )+ -> ^( ORDER_BY ( orderCondition )+ ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:464:7: ORDER BY ( orderCondition )+
			{
			ORDER197=(Token)match(input,ORDER,FOLLOW_ORDER_in_orderClause2427);  
			stream_ORDER.add(ORDER197);

			BY198=(Token)match(input,BY,FOLLOW_BY_in_orderClause2429);  
			stream_BY.add(BY198);

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:464:16: ( orderCondition )+
			int cnt60=0;
			loop60:
			while (true) {
				int alt60=2;
				int LA60_0 = input.LA(1);
				if ( (LA60_0==ABS||LA60_0==ASC||(LA60_0 >= BNODE && LA60_0 <= BOUND)||LA60_0==CEIL||LA60_0==COALESCE||LA60_0==CONCAT||LA60_0==CONTAINS||(LA60_0 >= DATATYPE && LA60_0 <= DAY)||LA60_0==DESC||LA60_0==ENCODE_FOR_URI||LA60_0==EXISTS||LA60_0==FLOOR||(LA60_0 >= HOURS && LA60_0 <= IF)||(LA60_0 >= IRI && LA60_0 <= IRI_REF)||(LA60_0 >= ISBLANK && LA60_0 <= ISURI)||(LA60_0 >= LANG && LA60_0 <= LANGMATCHES)||LA60_0==LCASE||LA60_0==MD5||LA60_0==MINUTES||LA60_0==MONTH||LA60_0==NOT||LA60_0==NOW||LA60_0==OPEN_BRACE||(LA60_0 >= PNAME_LN && LA60_0 <= PNAME_NS)||LA60_0==RAND||LA60_0==REGEX||(LA60_0 >= ROUND && LA60_0 <= SAMETERM)||LA60_0==SECONDS||(LA60_0 >= SHA1 && LA60_0 <= SHA512)||(LA60_0 >= STR && LA60_0 <= STRENDS)||(LA60_0 >= STRLANG && LA60_0 <= STRSTARTS)||LA60_0==SUBSTR||LA60_0==TIMEZONE||(LA60_0 >= TZ && LA60_0 <= UCASE)||LA60_0==URI||(LA60_0 >= VAR1 && LA60_0 <= VAR3)||LA60_0==YEAR) ) {
					alt60=1;
				}

				switch (alt60) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:464:16: orderCondition
					{
					pushFollow(FOLLOW_orderCondition_in_orderClause2431);
					orderCondition199=orderCondition();
					state._fsp--;

					stream_orderCondition.add(orderCondition199.getTree());
					}
					break;

				default :
					if ( cnt60 >= 1 ) break loop60;
					EarlyExitException eee = new EarlyExitException(60, input);
					throw eee;
				}
				cnt60++;
			}

			// AST REWRITE
			// elements: orderCondition
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 464:32: -> ^( ORDER_BY ( orderCondition )+ )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:464:35: ^( ORDER_BY ( orderCondition )+ )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(ORDER_BY, "ORDER_BY"), root_1);
				if ( !(stream_orderCondition.hasNext()) ) {
					throw new RewriteEarlyExitException();
				}
				while ( stream_orderCondition.hasNext() ) {
					adaptor.addChild(root_1, stream_orderCondition.nextTree());
				}
				stream_orderCondition.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "orderClause"


	public static class orderCondition_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "orderCondition"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:467:1: orderCondition : ( ASC brackettedExpression -> ^( ORDER_CONDITION ASC brackettedExpression ) | DESC brackettedExpression -> ^( ORDER_CONDITION DESC brackettedExpression ) | constraint -> ^( ORDER_CONDITION constraint ) | var -> ^( ORDER_CONDITION var ) );
	public final SparqlifyConfigParser.orderCondition_return orderCondition() throws RecognitionException {
		SparqlifyConfigParser.orderCondition_return retval = new SparqlifyConfigParser.orderCondition_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token ASC200=null;
		Token DESC202=null;
		ParserRuleReturnScope brackettedExpression201 =null;
		ParserRuleReturnScope brackettedExpression203 =null;
		ParserRuleReturnScope constraint204 =null;
		ParserRuleReturnScope var205 =null;

		CommonTree ASC200_tree=null;
		CommonTree DESC202_tree=null;
		RewriteRuleTokenStream stream_DESC=new RewriteRuleTokenStream(adaptor,"token DESC");
		RewriteRuleTokenStream stream_ASC=new RewriteRuleTokenStream(adaptor,"token ASC");
		RewriteRuleSubtreeStream stream_var=new RewriteRuleSubtreeStream(adaptor,"rule var");
		RewriteRuleSubtreeStream stream_constraint=new RewriteRuleSubtreeStream(adaptor,"rule constraint");
		RewriteRuleSubtreeStream stream_brackettedExpression=new RewriteRuleSubtreeStream(adaptor,"rule brackettedExpression");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:468:5: ( ASC brackettedExpression -> ^( ORDER_CONDITION ASC brackettedExpression ) | DESC brackettedExpression -> ^( ORDER_CONDITION DESC brackettedExpression ) | constraint -> ^( ORDER_CONDITION constraint ) | var -> ^( ORDER_CONDITION var ) )
			int alt61=4;
			switch ( input.LA(1) ) {
			case ASC:
				{
				alt61=1;
				}
				break;
			case DESC:
				{
				alt61=2;
				}
				break;
			case ABS:
			case BNODE:
			case BOUND:
			case CEIL:
			case COALESCE:
			case CONCAT:
			case CONTAINS:
			case DATATYPE:
			case DAY:
			case ENCODE_FOR_URI:
			case EXISTS:
			case FLOOR:
			case HOURS:
			case IF:
			case IRI:
			case IRI_REF:
			case ISBLANK:
			case ISIRI:
			case ISLITERAL:
			case ISNUMERIC:
			case ISURI:
			case LANG:
			case LANGMATCHES:
			case LCASE:
			case MD5:
			case MINUTES:
			case MONTH:
			case NOT:
			case NOW:
			case OPEN_BRACE:
			case PNAME_LN:
			case PNAME_NS:
			case RAND:
			case REGEX:
			case ROUND:
			case SAMETERM:
			case SECONDS:
			case SHA1:
			case SHA224:
			case SHA256:
			case SHA384:
			case SHA512:
			case STR:
			case STRDT:
			case STRENDS:
			case STRLANG:
			case STRLEN:
			case STRSTARTS:
			case SUBSTR:
			case TIMEZONE:
			case TZ:
			case UCASE:
			case URI:
			case YEAR:
				{
				alt61=3;
				}
				break;
			case VAR1:
			case VAR2:
			case VAR3:
				{
				alt61=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 61, 0, input);
				throw nvae;
			}
			switch (alt61) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:468:7: ASC brackettedExpression
					{
					ASC200=(Token)match(input,ASC,FOLLOW_ASC_in_orderCondition2458);  
					stream_ASC.add(ASC200);

					pushFollow(FOLLOW_brackettedExpression_in_orderCondition2460);
					brackettedExpression201=brackettedExpression();
					state._fsp--;

					stream_brackettedExpression.add(brackettedExpression201.getTree());
					// AST REWRITE
					// elements: brackettedExpression, ASC
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 468:32: -> ^( ORDER_CONDITION ASC brackettedExpression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:468:35: ^( ORDER_CONDITION ASC brackettedExpression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(ORDER_CONDITION, "ORDER_CONDITION"), root_1);
						adaptor.addChild(root_1, stream_ASC.nextNode());
						adaptor.addChild(root_1, stream_brackettedExpression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:469:7: DESC brackettedExpression
					{
					DESC202=(Token)match(input,DESC,FOLLOW_DESC_in_orderCondition2478);  
					stream_DESC.add(DESC202);

					pushFollow(FOLLOW_brackettedExpression_in_orderCondition2480);
					brackettedExpression203=brackettedExpression();
					state._fsp--;

					stream_brackettedExpression.add(brackettedExpression203.getTree());
					// AST REWRITE
					// elements: DESC, brackettedExpression
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 469:33: -> ^( ORDER_CONDITION DESC brackettedExpression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:469:36: ^( ORDER_CONDITION DESC brackettedExpression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(ORDER_CONDITION, "ORDER_CONDITION"), root_1);
						adaptor.addChild(root_1, stream_DESC.nextNode());
						adaptor.addChild(root_1, stream_brackettedExpression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:470:7: constraint
					{
					pushFollow(FOLLOW_constraint_in_orderCondition2498);
					constraint204=constraint();
					state._fsp--;

					stream_constraint.add(constraint204.getTree());
					// AST REWRITE
					// elements: constraint
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 470:18: -> ^( ORDER_CONDITION constraint )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:470:21: ^( ORDER_CONDITION constraint )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(ORDER_CONDITION, "ORDER_CONDITION"), root_1);
						adaptor.addChild(root_1, stream_constraint.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:471:7: var
					{
					pushFollow(FOLLOW_var_in_orderCondition2514);
					var205=var();
					state._fsp--;

					stream_var.add(var205.getTree());
					// AST REWRITE
					// elements: var
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 471:11: -> ^( ORDER_CONDITION var )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:471:14: ^( ORDER_CONDITION var )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(ORDER_CONDITION, "ORDER_CONDITION"), root_1);
						adaptor.addChild(root_1, stream_var.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "orderCondition"


	public static class limitOffsetClauses_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "limitOffsetClauses"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:474:1: limitOffsetClauses : ( limitClause ( offsetClause )? -> limitClause ( offsetClause )* | offsetClause ( limitClause )? -> offsetClause ( limitClause )* );
	public final SparqlifyConfigParser.limitOffsetClauses_return limitOffsetClauses() throws RecognitionException {
		SparqlifyConfigParser.limitOffsetClauses_return retval = new SparqlifyConfigParser.limitOffsetClauses_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		ParserRuleReturnScope limitClause206 =null;
		ParserRuleReturnScope offsetClause207 =null;
		ParserRuleReturnScope offsetClause208 =null;
		ParserRuleReturnScope limitClause209 =null;

		RewriteRuleSubtreeStream stream_offsetClause=new RewriteRuleSubtreeStream(adaptor,"rule offsetClause");
		RewriteRuleSubtreeStream stream_limitClause=new RewriteRuleSubtreeStream(adaptor,"rule limitClause");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:475:5: ( limitClause ( offsetClause )? -> limitClause ( offsetClause )* | offsetClause ( limitClause )? -> offsetClause ( limitClause )* )
			int alt64=2;
			int LA64_0 = input.LA(1);
			if ( (LA64_0==LIMIT) ) {
				alt64=1;
			}
			else if ( (LA64_0==OFFSET) ) {
				alt64=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 64, 0, input);
				throw nvae;
			}

			switch (alt64) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:475:7: limitClause ( offsetClause )?
					{
					pushFollow(FOLLOW_limitClause_in_limitOffsetClauses2544);
					limitClause206=limitClause();
					state._fsp--;

					stream_limitClause.add(limitClause206.getTree());
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:475:19: ( offsetClause )?
					int alt62=2;
					int LA62_0 = input.LA(1);
					if ( (LA62_0==OFFSET) ) {
						alt62=1;
					}
					switch (alt62) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:475:19: offsetClause
							{
							pushFollow(FOLLOW_offsetClause_in_limitOffsetClauses2546);
							offsetClause207=offsetClause();
							state._fsp--;

							stream_offsetClause.add(offsetClause207.getTree());
							}
							break;

					}

					// AST REWRITE
					// elements: offsetClause, limitClause
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 475:33: -> limitClause ( offsetClause )*
					{
						adaptor.addChild(root_0, stream_limitClause.nextTree());
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:475:48: ( offsetClause )*
						while ( stream_offsetClause.hasNext() ) {
							adaptor.addChild(root_0, stream_offsetClause.nextTree());
						}
						stream_offsetClause.reset();

					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:476:7: offsetClause ( limitClause )?
					{
					pushFollow(FOLLOW_offsetClause_in_limitOffsetClauses2562);
					offsetClause208=offsetClause();
					state._fsp--;

					stream_offsetClause.add(offsetClause208.getTree());
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:476:20: ( limitClause )?
					int alt63=2;
					int LA63_0 = input.LA(1);
					if ( (LA63_0==LIMIT) ) {
						alt63=1;
					}
					switch (alt63) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:476:20: limitClause
							{
							pushFollow(FOLLOW_limitClause_in_limitOffsetClauses2564);
							limitClause209=limitClause();
							state._fsp--;

							stream_limitClause.add(limitClause209.getTree());
							}
							break;

					}

					// AST REWRITE
					// elements: limitClause, offsetClause
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 476:33: -> offsetClause ( limitClause )*
					{
						adaptor.addChild(root_0, stream_offsetClause.nextTree());
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:476:49: ( limitClause )*
						while ( stream_limitClause.hasNext() ) {
							adaptor.addChild(root_0, stream_limitClause.nextTree());
						}
						stream_limitClause.reset();

					}


					retval.tree = root_0;

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "limitOffsetClauses"


	public static class limitClause_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "limitClause"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:479:1: limitClause : LIMIT INTEGER -> ^( LIMIT INTEGER ) ;
	public final SparqlifyConfigParser.limitClause_return limitClause() throws RecognitionException {
		SparqlifyConfigParser.limitClause_return retval = new SparqlifyConfigParser.limitClause_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token LIMIT210=null;
		Token INTEGER211=null;

		CommonTree LIMIT210_tree=null;
		CommonTree INTEGER211_tree=null;
		RewriteRuleTokenStream stream_INTEGER=new RewriteRuleTokenStream(adaptor,"token INTEGER");
		RewriteRuleTokenStream stream_LIMIT=new RewriteRuleTokenStream(adaptor,"token LIMIT");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:480:5: ( LIMIT INTEGER -> ^( LIMIT INTEGER ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:480:7: LIMIT INTEGER
			{
			LIMIT210=(Token)match(input,LIMIT,FOLLOW_LIMIT_in_limitClause2589);  
			stream_LIMIT.add(LIMIT210);

			INTEGER211=(Token)match(input,INTEGER,FOLLOW_INTEGER_in_limitClause2591);  
			stream_INTEGER.add(INTEGER211);

			// AST REWRITE
			// elements: INTEGER, LIMIT
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 480:21: -> ^( LIMIT INTEGER )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:480:24: ^( LIMIT INTEGER )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot(stream_LIMIT.nextNode(), root_1);
				adaptor.addChild(root_1, stream_INTEGER.nextNode());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "limitClause"


	public static class offsetClause_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "offsetClause"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:483:1: offsetClause : OFFSET INTEGER -> ^( OFFSET INTEGER ) ;
	public final SparqlifyConfigParser.offsetClause_return offsetClause() throws RecognitionException {
		SparqlifyConfigParser.offsetClause_return retval = new SparqlifyConfigParser.offsetClause_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token OFFSET212=null;
		Token INTEGER213=null;

		CommonTree OFFSET212_tree=null;
		CommonTree INTEGER213_tree=null;
		RewriteRuleTokenStream stream_INTEGER=new RewriteRuleTokenStream(adaptor,"token INTEGER");
		RewriteRuleTokenStream stream_OFFSET=new RewriteRuleTokenStream(adaptor,"token OFFSET");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:484:5: ( OFFSET INTEGER -> ^( OFFSET INTEGER ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:484:7: OFFSET INTEGER
			{
			OFFSET212=(Token)match(input,OFFSET,FOLLOW_OFFSET_in_offsetClause2616);  
			stream_OFFSET.add(OFFSET212);

			INTEGER213=(Token)match(input,INTEGER,FOLLOW_INTEGER_in_offsetClause2618);  
			stream_INTEGER.add(INTEGER213);

			// AST REWRITE
			// elements: INTEGER, OFFSET
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 484:22: -> ^( OFFSET INTEGER )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:484:25: ^( OFFSET INTEGER )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot(stream_OFFSET.nextNode(), root_1);
				adaptor.addChild(root_1, stream_INTEGER.nextNode());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "offsetClause"


	public static class bindingsClause_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "bindingsClause"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:487:1: bindingsClause : ( BINDINGS ( var )* OPEN_CURLY_BRACE ( bindingValueList )* CLOSE_CURLY_BRACE )? -> ( ^( BINDINGS ( var )* ( bindingValueList )* ) )? ;
	public final SparqlifyConfigParser.bindingsClause_return bindingsClause() throws RecognitionException {
		SparqlifyConfigParser.bindingsClause_return retval = new SparqlifyConfigParser.bindingsClause_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token BINDINGS214=null;
		Token OPEN_CURLY_BRACE216=null;
		Token CLOSE_CURLY_BRACE218=null;
		ParserRuleReturnScope var215 =null;
		ParserRuleReturnScope bindingValueList217 =null;

		CommonTree BINDINGS214_tree=null;
		CommonTree OPEN_CURLY_BRACE216_tree=null;
		CommonTree CLOSE_CURLY_BRACE218_tree=null;
		RewriteRuleTokenStream stream_BINDINGS=new RewriteRuleTokenStream(adaptor,"token BINDINGS");
		RewriteRuleTokenStream stream_OPEN_CURLY_BRACE=new RewriteRuleTokenStream(adaptor,"token OPEN_CURLY_BRACE");
		RewriteRuleTokenStream stream_CLOSE_CURLY_BRACE=new RewriteRuleTokenStream(adaptor,"token CLOSE_CURLY_BRACE");
		RewriteRuleSubtreeStream stream_var=new RewriteRuleSubtreeStream(adaptor,"rule var");
		RewriteRuleSubtreeStream stream_bindingValueList=new RewriteRuleSubtreeStream(adaptor,"rule bindingValueList");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:488:5: ( ( BINDINGS ( var )* OPEN_CURLY_BRACE ( bindingValueList )* CLOSE_CURLY_BRACE )? -> ( ^( BINDINGS ( var )* ( bindingValueList )* ) )? )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:488:7: ( BINDINGS ( var )* OPEN_CURLY_BRACE ( bindingValueList )* CLOSE_CURLY_BRACE )?
			{
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:488:7: ( BINDINGS ( var )* OPEN_CURLY_BRACE ( bindingValueList )* CLOSE_CURLY_BRACE )?
			int alt67=2;
			int LA67_0 = input.LA(1);
			if ( (LA67_0==BINDINGS) ) {
				alt67=1;
			}
			switch (alt67) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:488:8: BINDINGS ( var )* OPEN_CURLY_BRACE ( bindingValueList )* CLOSE_CURLY_BRACE
					{
					BINDINGS214=(Token)match(input,BINDINGS,FOLLOW_BINDINGS_in_bindingsClause2644);  
					stream_BINDINGS.add(BINDINGS214);

					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:488:17: ( var )*
					loop65:
					while (true) {
						int alt65=2;
						int LA65_0 = input.LA(1);
						if ( ((LA65_0 >= VAR1 && LA65_0 <= VAR3)) ) {
							alt65=1;
						}

						switch (alt65) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:488:17: var
							{
							pushFollow(FOLLOW_var_in_bindingsClause2646);
							var215=var();
							state._fsp--;

							stream_var.add(var215.getTree());
							}
							break;

						default :
							break loop65;
						}
					}

					OPEN_CURLY_BRACE216=(Token)match(input,OPEN_CURLY_BRACE,FOLLOW_OPEN_CURLY_BRACE_in_bindingsClause2649);  
					stream_OPEN_CURLY_BRACE.add(OPEN_CURLY_BRACE216);

					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:488:39: ( bindingValueList )*
					loop66:
					while (true) {
						int alt66=2;
						int LA66_0 = input.LA(1);
						if ( (LA66_0==OPEN_BRACE) ) {
							alt66=1;
						}

						switch (alt66) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:488:39: bindingValueList
							{
							pushFollow(FOLLOW_bindingValueList_in_bindingsClause2651);
							bindingValueList217=bindingValueList();
							state._fsp--;

							stream_bindingValueList.add(bindingValueList217.getTree());
							}
							break;

						default :
							break loop66;
						}
					}

					CLOSE_CURLY_BRACE218=(Token)match(input,CLOSE_CURLY_BRACE,FOLLOW_CLOSE_CURLY_BRACE_in_bindingsClause2654);  
					stream_CLOSE_CURLY_BRACE.add(CLOSE_CURLY_BRACE218);

					}
					break;

			}

			// AST REWRITE
			// elements: bindingValueList, BINDINGS, var
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 488:77: -> ( ^( BINDINGS ( var )* ( bindingValueList )* ) )?
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:488:80: ( ^( BINDINGS ( var )* ( bindingValueList )* ) )?
				if ( stream_bindingValueList.hasNext()||stream_BINDINGS.hasNext()||stream_var.hasNext() ) {
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:488:80: ^( BINDINGS ( var )* ( bindingValueList )* )
					{
					CommonTree root_1 = (CommonTree)adaptor.nil();
					root_1 = (CommonTree)adaptor.becomeRoot(stream_BINDINGS.nextNode(), root_1);
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:488:91: ( var )*
					while ( stream_var.hasNext() ) {
						adaptor.addChild(root_1, stream_var.nextTree());
					}
					stream_var.reset();

					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:488:96: ( bindingValueList )*
					while ( stream_bindingValueList.hasNext() ) {
						adaptor.addChild(root_1, stream_bindingValueList.nextTree());
					}
					stream_bindingValueList.reset();

					adaptor.addChild(root_0, root_1);
					}

				}
				stream_bindingValueList.reset();
				stream_BINDINGS.reset();
				stream_var.reset();

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "bindingsClause"


	public static class bindingValueList_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "bindingValueList"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:491:1: bindingValueList : OPEN_BRACE ( bindingValue )* CLOSE_BRACE -> ^( BINDING_VALUE ( bindingValue )* ) ;
	public final SparqlifyConfigParser.bindingValueList_return bindingValueList() throws RecognitionException {
		SparqlifyConfigParser.bindingValueList_return retval = new SparqlifyConfigParser.bindingValueList_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token OPEN_BRACE219=null;
		Token CLOSE_BRACE221=null;
		ParserRuleReturnScope bindingValue220 =null;

		CommonTree OPEN_BRACE219_tree=null;
		CommonTree CLOSE_BRACE221_tree=null;
		RewriteRuleTokenStream stream_CLOSE_BRACE=new RewriteRuleTokenStream(adaptor,"token CLOSE_BRACE");
		RewriteRuleTokenStream stream_OPEN_BRACE=new RewriteRuleTokenStream(adaptor,"token OPEN_BRACE");
		RewriteRuleSubtreeStream stream_bindingValue=new RewriteRuleSubtreeStream(adaptor,"rule bindingValue");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:492:5: ( OPEN_BRACE ( bindingValue )* CLOSE_BRACE -> ^( BINDING_VALUE ( bindingValue )* ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:492:7: OPEN_BRACE ( bindingValue )* CLOSE_BRACE
			{
			OPEN_BRACE219=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_bindingValueList2690);  
			stream_OPEN_BRACE.add(OPEN_BRACE219);

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:492:18: ( bindingValue )*
			loop68:
			while (true) {
				int alt68=2;
				int LA68_0 = input.LA(1);
				if ( ((LA68_0 >= DECIMAL && LA68_0 <= DECIMAL_POSITIVE)||(LA68_0 >= DOUBLE && LA68_0 <= DOUBLE_POSITIVE)||LA68_0==FALSE||(LA68_0 >= INTEGER && LA68_0 <= INTEGER_POSITIVE)||LA68_0==IRI_REF||(LA68_0 >= PNAME_LN && LA68_0 <= PNAME_NS)||(LA68_0 >= STRING_LITERAL1 && LA68_0 <= STRING_LITERAL_LONG2)||LA68_0==TRUE||LA68_0==UNDEF) ) {
					alt68=1;
				}

				switch (alt68) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:492:18: bindingValue
					{
					pushFollow(FOLLOW_bindingValue_in_bindingValueList2692);
					bindingValue220=bindingValue();
					state._fsp--;

					stream_bindingValue.add(bindingValue220.getTree());
					}
					break;

				default :
					break loop68;
				}
			}

			CLOSE_BRACE221=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_bindingValueList2695);  
			stream_CLOSE_BRACE.add(CLOSE_BRACE221);

			// AST REWRITE
			// elements: bindingValue
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 492:44: -> ^( BINDING_VALUE ( bindingValue )* )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:492:47: ^( BINDING_VALUE ( bindingValue )* )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(BINDING_VALUE, "BINDING_VALUE"), root_1);
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:492:63: ( bindingValue )*
				while ( stream_bindingValue.hasNext() ) {
					adaptor.addChild(root_1, stream_bindingValue.nextTree());
				}
				stream_bindingValue.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "bindingValueList"


	public static class bindingValue_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "bindingValue"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:495:1: bindingValue : ( iriRef | rdfLiteral | numericLiteral | booleanLiteral | UNDEF );
	public final SparqlifyConfigParser.bindingValue_return bindingValue() throws RecognitionException {
		SparqlifyConfigParser.bindingValue_return retval = new SparqlifyConfigParser.bindingValue_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token UNDEF226=null;
		ParserRuleReturnScope iriRef222 =null;
		ParserRuleReturnScope rdfLiteral223 =null;
		ParserRuleReturnScope numericLiteral224 =null;
		ParserRuleReturnScope booleanLiteral225 =null;

		CommonTree UNDEF226_tree=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:496:5: ( iriRef | rdfLiteral | numericLiteral | booleanLiteral | UNDEF )
			int alt69=5;
			switch ( input.LA(1) ) {
			case IRI_REF:
			case PNAME_LN:
			case PNAME_NS:
				{
				alt69=1;
				}
				break;
			case STRING_LITERAL1:
			case STRING_LITERAL2:
			case STRING_LITERAL_LONG1:
			case STRING_LITERAL_LONG2:
				{
				alt69=2;
				}
				break;
			case DECIMAL:
			case DECIMAL_NEGATIVE:
			case DECIMAL_POSITIVE:
			case DOUBLE:
			case DOUBLE_NEGATIVE:
			case DOUBLE_POSITIVE:
			case INTEGER:
			case INTEGER_NEGATIVE:
			case INTEGER_POSITIVE:
				{
				alt69=3;
				}
				break;
			case FALSE:
			case TRUE:
				{
				alt69=4;
				}
				break;
			case UNDEF:
				{
				alt69=5;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 69, 0, input);
				throw nvae;
			}
			switch (alt69) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:496:7: iriRef
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_iriRef_in_bindingValue2726);
					iriRef222=iriRef();
					state._fsp--;

					adaptor.addChild(root_0, iriRef222.getTree());

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:496:16: rdfLiteral
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_rdfLiteral_in_bindingValue2730);
					rdfLiteral223=rdfLiteral();
					state._fsp--;

					adaptor.addChild(root_0, rdfLiteral223.getTree());

					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:496:29: numericLiteral
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_numericLiteral_in_bindingValue2734);
					numericLiteral224=numericLiteral();
					state._fsp--;

					adaptor.addChild(root_0, numericLiteral224.getTree());

					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:496:46: booleanLiteral
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_booleanLiteral_in_bindingValue2738);
					booleanLiteral225=booleanLiteral();
					state._fsp--;

					adaptor.addChild(root_0, booleanLiteral225.getTree());

					}
					break;
				case 5 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:496:63: UNDEF
					{
					root_0 = (CommonTree)adaptor.nil();


					UNDEF226=(Token)match(input,UNDEF,FOLLOW_UNDEF_in_bindingValue2742); 
					UNDEF226_tree = (CommonTree)adaptor.create(UNDEF226);
					adaptor.addChild(root_0, UNDEF226_tree);

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "bindingValue"


	public static class update_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "update"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:499:1: update : prologue ( load | clear | drop | add | move | copy | create | insert | delete | modify ) -> prologue ( load )* ( clear )* ( drop )* ( add )* ( move )* ( copy )* ( create )* ( insert )* ( delete )* ( modify )* ;
	public final SparqlifyConfigParser.update_return update() throws RecognitionException {
		SparqlifyConfigParser.update_return retval = new SparqlifyConfigParser.update_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		ParserRuleReturnScope prologue227 =null;
		ParserRuleReturnScope load228 =null;
		ParserRuleReturnScope clear229 =null;
		ParserRuleReturnScope drop230 =null;
		ParserRuleReturnScope add231 =null;
		ParserRuleReturnScope move232 =null;
		ParserRuleReturnScope copy233 =null;
		ParserRuleReturnScope create234 =null;
		ParserRuleReturnScope insert235 =null;
		ParserRuleReturnScope delete236 =null;
		ParserRuleReturnScope modify237 =null;

		RewriteRuleSubtreeStream stream_clear=new RewriteRuleSubtreeStream(adaptor,"rule clear");
		RewriteRuleSubtreeStream stream_prologue=new RewriteRuleSubtreeStream(adaptor,"rule prologue");
		RewriteRuleSubtreeStream stream_drop=new RewriteRuleSubtreeStream(adaptor,"rule drop");
		RewriteRuleSubtreeStream stream_delete=new RewriteRuleSubtreeStream(adaptor,"rule delete");
		RewriteRuleSubtreeStream stream_modify=new RewriteRuleSubtreeStream(adaptor,"rule modify");
		RewriteRuleSubtreeStream stream_load=new RewriteRuleSubtreeStream(adaptor,"rule load");
		RewriteRuleSubtreeStream stream_add=new RewriteRuleSubtreeStream(adaptor,"rule add");
		RewriteRuleSubtreeStream stream_insert=new RewriteRuleSubtreeStream(adaptor,"rule insert");
		RewriteRuleSubtreeStream stream_create=new RewriteRuleSubtreeStream(adaptor,"rule create");
		RewriteRuleSubtreeStream stream_move=new RewriteRuleSubtreeStream(adaptor,"rule move");
		RewriteRuleSubtreeStream stream_copy=new RewriteRuleSubtreeStream(adaptor,"rule copy");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:500:5: ( prologue ( load | clear | drop | add | move | copy | create | insert | delete | modify ) -> prologue ( load )* ( clear )* ( drop )* ( add )* ( move )* ( copy )* ( create )* ( insert )* ( delete )* ( modify )* )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:500:7: prologue ( load | clear | drop | add | move | copy | create | insert | delete | modify )
			{
			pushFollow(FOLLOW_prologue_in_update2763);
			prologue227=prologue();
			state._fsp--;

			stream_prologue.add(prologue227.getTree());
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:500:16: ( load | clear | drop | add | move | copy | create | insert | delete | modify )
			int alt70=10;
			switch ( input.LA(1) ) {
			case LOAD:
				{
				alt70=1;
				}
				break;
			case CLEAR:
				{
				alt70=2;
				}
				break;
			case DROP:
				{
				alt70=3;
				}
				break;
			case ADD:
				{
				alt70=4;
				}
				break;
			case MOVE:
				{
				alt70=5;
				}
				break;
			case COPY:
				{
				alt70=6;
				}
				break;
			case CREATE:
				{
				alt70=7;
				}
				break;
			case INSERT:
				{
				int LA70_8 = input.LA(2);
				if ( (LA70_8==DATA) ) {
					alt70=8;
				}
				else if ( (LA70_8==OPEN_CURLY_BRACE) ) {
					alt70=10;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 70, 8, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case DELETE:
				{
				int LA70_9 = input.LA(2);
				if ( (LA70_9==DATA||LA70_9==WHERE) ) {
					alt70=9;
				}
				else if ( (LA70_9==OPEN_CURLY_BRACE) ) {
					alt70=10;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 70, 9, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case WITH:
				{
				alt70=10;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 70, 0, input);
				throw nvae;
			}
			switch (alt70) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:500:17: load
					{
					pushFollow(FOLLOW_load_in_update2766);
					load228=load();
					state._fsp--;

					stream_load.add(load228.getTree());
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:500:24: clear
					{
					pushFollow(FOLLOW_clear_in_update2770);
					clear229=clear();
					state._fsp--;

					stream_clear.add(clear229.getTree());
					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:500:32: drop
					{
					pushFollow(FOLLOW_drop_in_update2774);
					drop230=drop();
					state._fsp--;

					stream_drop.add(drop230.getTree());
					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:500:39: add
					{
					pushFollow(FOLLOW_add_in_update2778);
					add231=add();
					state._fsp--;

					stream_add.add(add231.getTree());
					}
					break;
				case 5 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:500:45: move
					{
					pushFollow(FOLLOW_move_in_update2782);
					move232=move();
					state._fsp--;

					stream_move.add(move232.getTree());
					}
					break;
				case 6 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:500:52: copy
					{
					pushFollow(FOLLOW_copy_in_update2786);
					copy233=copy();
					state._fsp--;

					stream_copy.add(copy233.getTree());
					}
					break;
				case 7 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:500:59: create
					{
					pushFollow(FOLLOW_create_in_update2790);
					create234=create();
					state._fsp--;

					stream_create.add(create234.getTree());
					}
					break;
				case 8 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:500:68: insert
					{
					pushFollow(FOLLOW_insert_in_update2794);
					insert235=insert();
					state._fsp--;

					stream_insert.add(insert235.getTree());
					}
					break;
				case 9 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:500:77: delete
					{
					pushFollow(FOLLOW_delete_in_update2798);
					delete236=delete();
					state._fsp--;

					stream_delete.add(delete236.getTree());
					}
					break;
				case 10 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:500:86: modify
					{
					pushFollow(FOLLOW_modify_in_update2802);
					modify237=modify();
					state._fsp--;

					stream_modify.add(modify237.getTree());
					}
					break;

			}

			// AST REWRITE
			// elements: insert, add, prologue, copy, create, load, move, drop, delete, modify, clear
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 500:94: -> prologue ( load )* ( clear )* ( drop )* ( add )* ( move )* ( copy )* ( create )* ( insert )* ( delete )* ( modify )*
			{
				adaptor.addChild(root_0, stream_prologue.nextTree());
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:500:106: ( load )*
				while ( stream_load.hasNext() ) {
					adaptor.addChild(root_0, stream_load.nextTree());
				}
				stream_load.reset();

				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:500:112: ( clear )*
				while ( stream_clear.hasNext() ) {
					adaptor.addChild(root_0, stream_clear.nextTree());
				}
				stream_clear.reset();

				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:500:119: ( drop )*
				while ( stream_drop.hasNext() ) {
					adaptor.addChild(root_0, stream_drop.nextTree());
				}
				stream_drop.reset();

				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:500:125: ( add )*
				while ( stream_add.hasNext() ) {
					adaptor.addChild(root_0, stream_add.nextTree());
				}
				stream_add.reset();

				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:500:130: ( move )*
				while ( stream_move.hasNext() ) {
					adaptor.addChild(root_0, stream_move.nextTree());
				}
				stream_move.reset();

				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:500:136: ( copy )*
				while ( stream_copy.hasNext() ) {
					adaptor.addChild(root_0, stream_copy.nextTree());
				}
				stream_copy.reset();

				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:500:142: ( create )*
				while ( stream_create.hasNext() ) {
					adaptor.addChild(root_0, stream_create.nextTree());
				}
				stream_create.reset();

				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:500:150: ( insert )*
				while ( stream_insert.hasNext() ) {
					adaptor.addChild(root_0, stream_insert.nextTree());
				}
				stream_insert.reset();

				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:500:158: ( delete )*
				while ( stream_delete.hasNext() ) {
					adaptor.addChild(root_0, stream_delete.nextTree());
				}
				stream_delete.reset();

				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:500:166: ( modify )*
				while ( stream_modify.hasNext() ) {
					adaptor.addChild(root_0, stream_modify.nextTree());
				}
				stream_modify.reset();

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "update"


	public static class load_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "load"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:503:1: load : LOAD ( SILENT )? iriRef ( INTO graphRef )? -> ^( LOAD ( SILENT )* iriRef ( graphRef )* ) ;
	public final SparqlifyConfigParser.load_return load() throws RecognitionException {
		SparqlifyConfigParser.load_return retval = new SparqlifyConfigParser.load_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token LOAD238=null;
		Token SILENT239=null;
		Token INTO241=null;
		ParserRuleReturnScope iriRef240 =null;
		ParserRuleReturnScope graphRef242 =null;

		CommonTree LOAD238_tree=null;
		CommonTree SILENT239_tree=null;
		CommonTree INTO241_tree=null;
		RewriteRuleTokenStream stream_SILENT=new RewriteRuleTokenStream(adaptor,"token SILENT");
		RewriteRuleTokenStream stream_INTO=new RewriteRuleTokenStream(adaptor,"token INTO");
		RewriteRuleTokenStream stream_LOAD=new RewriteRuleTokenStream(adaptor,"token LOAD");
		RewriteRuleSubtreeStream stream_graphRef=new RewriteRuleSubtreeStream(adaptor,"rule graphRef");
		RewriteRuleSubtreeStream stream_iriRef=new RewriteRuleSubtreeStream(adaptor,"rule iriRef");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:504:5: ( LOAD ( SILENT )? iriRef ( INTO graphRef )? -> ^( LOAD ( SILENT )* iriRef ( graphRef )* ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:504:7: LOAD ( SILENT )? iriRef ( INTO graphRef )?
			{
			LOAD238=(Token)match(input,LOAD,FOLLOW_LOAD_in_load2865);  
			stream_LOAD.add(LOAD238);

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:504:12: ( SILENT )?
			int alt71=2;
			int LA71_0 = input.LA(1);
			if ( (LA71_0==SILENT) ) {
				alt71=1;
			}
			switch (alt71) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:504:12: SILENT
					{
					SILENT239=(Token)match(input,SILENT,FOLLOW_SILENT_in_load2867);  
					stream_SILENT.add(SILENT239);

					}
					break;

			}

			pushFollow(FOLLOW_iriRef_in_load2870);
			iriRef240=iriRef();
			state._fsp--;

			stream_iriRef.add(iriRef240.getTree());
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:504:27: ( INTO graphRef )?
			int alt72=2;
			int LA72_0 = input.LA(1);
			if ( (LA72_0==INTO) ) {
				alt72=1;
			}
			switch (alt72) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:504:29: INTO graphRef
					{
					INTO241=(Token)match(input,INTO,FOLLOW_INTO_in_load2874);  
					stream_INTO.add(INTO241);

					pushFollow(FOLLOW_graphRef_in_load2876);
					graphRef242=graphRef();
					state._fsp--;

					stream_graphRef.add(graphRef242.getTree());
					}
					break;

			}

			// AST REWRITE
			// elements: LOAD, SILENT, iriRef, graphRef
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 504:46: -> ^( LOAD ( SILENT )* iriRef ( graphRef )* )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:504:49: ^( LOAD ( SILENT )* iriRef ( graphRef )* )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot(stream_LOAD.nextNode(), root_1);
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:504:56: ( SILENT )*
				while ( stream_SILENT.hasNext() ) {
					adaptor.addChild(root_1, stream_SILENT.nextNode());
				}
				stream_SILENT.reset();

				adaptor.addChild(root_1, stream_iriRef.nextTree());
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:504:71: ( graphRef )*
				while ( stream_graphRef.hasNext() ) {
					adaptor.addChild(root_1, stream_graphRef.nextTree());
				}
				stream_graphRef.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "load"


	public static class clear_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "clear"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:507:1: clear : CLEAR ( SILENT )? graphRefAll -> ^( CLEAR ( SILENT )* graphRefAll ) ;
	public final SparqlifyConfigParser.clear_return clear() throws RecognitionException {
		SparqlifyConfigParser.clear_return retval = new SparqlifyConfigParser.clear_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token CLEAR243=null;
		Token SILENT244=null;
		ParserRuleReturnScope graphRefAll245 =null;

		CommonTree CLEAR243_tree=null;
		CommonTree SILENT244_tree=null;
		RewriteRuleTokenStream stream_SILENT=new RewriteRuleTokenStream(adaptor,"token SILENT");
		RewriteRuleTokenStream stream_CLEAR=new RewriteRuleTokenStream(adaptor,"token CLEAR");
		RewriteRuleSubtreeStream stream_graphRefAll=new RewriteRuleSubtreeStream(adaptor,"rule graphRefAll");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:508:5: ( CLEAR ( SILENT )? graphRefAll -> ^( CLEAR ( SILENT )* graphRefAll ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:508:7: CLEAR ( SILENT )? graphRefAll
			{
			CLEAR243=(Token)match(input,CLEAR,FOLLOW_CLEAR_in_clear2914);  
			stream_CLEAR.add(CLEAR243);

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:508:14: ( SILENT )?
			int alt73=2;
			int LA73_0 = input.LA(1);
			if ( (LA73_0==SILENT) ) {
				alt73=1;
			}
			switch (alt73) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:508:14: SILENT
					{
					SILENT244=(Token)match(input,SILENT,FOLLOW_SILENT_in_clear2917);  
					stream_SILENT.add(SILENT244);

					}
					break;

			}

			pushFollow(FOLLOW_graphRefAll_in_clear2920);
			graphRefAll245=graphRefAll();
			state._fsp--;

			stream_graphRefAll.add(graphRefAll245.getTree());
			// AST REWRITE
			// elements: CLEAR, SILENT, graphRefAll
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 508:34: -> ^( CLEAR ( SILENT )* graphRefAll )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:508:37: ^( CLEAR ( SILENT )* graphRefAll )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot(stream_CLEAR.nextNode(), root_1);
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:508:45: ( SILENT )*
				while ( stream_SILENT.hasNext() ) {
					adaptor.addChild(root_1, stream_SILENT.nextNode());
				}
				stream_SILENT.reset();

				adaptor.addChild(root_1, stream_graphRefAll.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "clear"


	public static class drop_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "drop"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:511:1: drop : DROP ( SILENT )? graphRefAll -> ^( DROP ( SILENT )* graphRefAll ) ;
	public final SparqlifyConfigParser.drop_return drop() throws RecognitionException {
		SparqlifyConfigParser.drop_return retval = new SparqlifyConfigParser.drop_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token DROP246=null;
		Token SILENT247=null;
		ParserRuleReturnScope graphRefAll248 =null;

		CommonTree DROP246_tree=null;
		CommonTree SILENT247_tree=null;
		RewriteRuleTokenStream stream_SILENT=new RewriteRuleTokenStream(adaptor,"token SILENT");
		RewriteRuleTokenStream stream_DROP=new RewriteRuleTokenStream(adaptor,"token DROP");
		RewriteRuleSubtreeStream stream_graphRefAll=new RewriteRuleSubtreeStream(adaptor,"rule graphRefAll");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:512:5: ( DROP ( SILENT )? graphRefAll -> ^( DROP ( SILENT )* graphRefAll ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:512:7: DROP ( SILENT )? graphRefAll
			{
			DROP246=(Token)match(input,DROP,FOLLOW_DROP_in_drop2952);  
			stream_DROP.add(DROP246);

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:512:12: ( SILENT )?
			int alt74=2;
			int LA74_0 = input.LA(1);
			if ( (LA74_0==SILENT) ) {
				alt74=1;
			}
			switch (alt74) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:512:12: SILENT
					{
					SILENT247=(Token)match(input,SILENT,FOLLOW_SILENT_in_drop2954);  
					stream_SILENT.add(SILENT247);

					}
					break;

			}

			pushFollow(FOLLOW_graphRefAll_in_drop2957);
			graphRefAll248=graphRefAll();
			state._fsp--;

			stream_graphRefAll.add(graphRefAll248.getTree());
			// AST REWRITE
			// elements: SILENT, DROP, graphRefAll
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 512:32: -> ^( DROP ( SILENT )* graphRefAll )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:512:35: ^( DROP ( SILENT )* graphRefAll )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot(stream_DROP.nextNode(), root_1);
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:512:42: ( SILENT )*
				while ( stream_SILENT.hasNext() ) {
					adaptor.addChild(root_1, stream_SILENT.nextNode());
				}
				stream_SILENT.reset();

				adaptor.addChild(root_1, stream_graphRefAll.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "drop"


	public static class create_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "create"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:515:1: create : CREATE ( SILENT )? graphRef -> ^( CREATE ( SILENT )* graphRef ) ;
	public final SparqlifyConfigParser.create_return create() throws RecognitionException {
		SparqlifyConfigParser.create_return retval = new SparqlifyConfigParser.create_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token CREATE249=null;
		Token SILENT250=null;
		ParserRuleReturnScope graphRef251 =null;

		CommonTree CREATE249_tree=null;
		CommonTree SILENT250_tree=null;
		RewriteRuleTokenStream stream_CREATE=new RewriteRuleTokenStream(adaptor,"token CREATE");
		RewriteRuleTokenStream stream_SILENT=new RewriteRuleTokenStream(adaptor,"token SILENT");
		RewriteRuleSubtreeStream stream_graphRef=new RewriteRuleSubtreeStream(adaptor,"rule graphRef");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:516:5: ( CREATE ( SILENT )? graphRef -> ^( CREATE ( SILENT )* graphRef ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:516:7: CREATE ( SILENT )? graphRef
			{
			CREATE249=(Token)match(input,CREATE,FOLLOW_CREATE_in_create2986);  
			stream_CREATE.add(CREATE249);

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:516:14: ( SILENT )?
			int alt75=2;
			int LA75_0 = input.LA(1);
			if ( (LA75_0==SILENT) ) {
				alt75=1;
			}
			switch (alt75) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:516:14: SILENT
					{
					SILENT250=(Token)match(input,SILENT,FOLLOW_SILENT_in_create2988);  
					stream_SILENT.add(SILENT250);

					}
					break;

			}

			pushFollow(FOLLOW_graphRef_in_create2991);
			graphRef251=graphRef();
			state._fsp--;

			stream_graphRef.add(graphRef251.getTree());
			// AST REWRITE
			// elements: CREATE, graphRef, SILENT
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 516:31: -> ^( CREATE ( SILENT )* graphRef )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:516:34: ^( CREATE ( SILENT )* graphRef )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot(stream_CREATE.nextNode(), root_1);
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:516:43: ( SILENT )*
				while ( stream_SILENT.hasNext() ) {
					adaptor.addChild(root_1, stream_SILENT.nextNode());
				}
				stream_SILENT.reset();

				adaptor.addChild(root_1, stream_graphRef.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "create"


	public static class add_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "add"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:519:1: add : ADD ( SILENT )? from= graphOrDefault TO to= graphOrDefault -> ^( ADD ( SILENT )* $from $to) ;
	public final SparqlifyConfigParser.add_return add() throws RecognitionException {
		SparqlifyConfigParser.add_return retval = new SparqlifyConfigParser.add_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token ADD252=null;
		Token SILENT253=null;
		Token TO254=null;
		ParserRuleReturnScope from =null;
		ParserRuleReturnScope to =null;

		CommonTree ADD252_tree=null;
		CommonTree SILENT253_tree=null;
		CommonTree TO254_tree=null;
		RewriteRuleTokenStream stream_SILENT=new RewriteRuleTokenStream(adaptor,"token SILENT");
		RewriteRuleTokenStream stream_TO=new RewriteRuleTokenStream(adaptor,"token TO");
		RewriteRuleTokenStream stream_ADD=new RewriteRuleTokenStream(adaptor,"token ADD");
		RewriteRuleSubtreeStream stream_graphOrDefault=new RewriteRuleSubtreeStream(adaptor,"rule graphOrDefault");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:520:5: ( ADD ( SILENT )? from= graphOrDefault TO to= graphOrDefault -> ^( ADD ( SILENT )* $from $to) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:520:7: ADD ( SILENT )? from= graphOrDefault TO to= graphOrDefault
			{
			ADD252=(Token)match(input,ADD,FOLLOW_ADD_in_add3023);  
			stream_ADD.add(ADD252);

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:520:11: ( SILENT )?
			int alt76=2;
			int LA76_0 = input.LA(1);
			if ( (LA76_0==SILENT) ) {
				alt76=1;
			}
			switch (alt76) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:520:11: SILENT
					{
					SILENT253=(Token)match(input,SILENT,FOLLOW_SILENT_in_add3025);  
					stream_SILENT.add(SILENT253);

					}
					break;

			}

			pushFollow(FOLLOW_graphOrDefault_in_add3030);
			from=graphOrDefault();
			state._fsp--;

			stream_graphOrDefault.add(from.getTree());
			TO254=(Token)match(input,TO,FOLLOW_TO_in_add3032);  
			stream_TO.add(TO254);

			pushFollow(FOLLOW_graphOrDefault_in_add3036);
			to=graphOrDefault();
			state._fsp--;

			stream_graphOrDefault.add(to.getTree());
			// AST REWRITE
			// elements: to, from, SILENT, ADD
			// token labels: 
			// rule labels: to, retval, from
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_to=new RewriteRuleSubtreeStream(adaptor,"rule to",to!=null?to.getTree():null);
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);
			RewriteRuleSubtreeStream stream_from=new RewriteRuleSubtreeStream(adaptor,"rule from",from!=null?from.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 520:60: -> ^( ADD ( SILENT )* $from $to)
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:520:63: ^( ADD ( SILENT )* $from $to)
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot(stream_ADD.nextNode(), root_1);
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:520:69: ( SILENT )*
				while ( stream_SILENT.hasNext() ) {
					adaptor.addChild(root_1, stream_SILENT.nextNode());
				}
				stream_SILENT.reset();

				adaptor.addChild(root_1, stream_from.nextTree());
				adaptor.addChild(root_1, stream_to.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "add"


	public static class move_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "move"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:523:1: move : MOVE ( SILENT )? from= graphOrDefault TO to= graphOrDefault -> ^( MOVE ( SILENT )* $from $to) ;
	public final SparqlifyConfigParser.move_return move() throws RecognitionException {
		SparqlifyConfigParser.move_return retval = new SparqlifyConfigParser.move_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token MOVE255=null;
		Token SILENT256=null;
		Token TO257=null;
		ParserRuleReturnScope from =null;
		ParserRuleReturnScope to =null;

		CommonTree MOVE255_tree=null;
		CommonTree SILENT256_tree=null;
		CommonTree TO257_tree=null;
		RewriteRuleTokenStream stream_SILENT=new RewriteRuleTokenStream(adaptor,"token SILENT");
		RewriteRuleTokenStream stream_TO=new RewriteRuleTokenStream(adaptor,"token TO");
		RewriteRuleTokenStream stream_MOVE=new RewriteRuleTokenStream(adaptor,"token MOVE");
		RewriteRuleSubtreeStream stream_graphOrDefault=new RewriteRuleSubtreeStream(adaptor,"rule graphOrDefault");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:524:5: ( MOVE ( SILENT )? from= graphOrDefault TO to= graphOrDefault -> ^( MOVE ( SILENT )* $from $to) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:524:7: MOVE ( SILENT )? from= graphOrDefault TO to= graphOrDefault
			{
			MOVE255=(Token)match(input,MOVE,FOLLOW_MOVE_in_move3072);  
			stream_MOVE.add(MOVE255);

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:524:12: ( SILENT )?
			int alt77=2;
			int LA77_0 = input.LA(1);
			if ( (LA77_0==SILENT) ) {
				alt77=1;
			}
			switch (alt77) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:524:12: SILENT
					{
					SILENT256=(Token)match(input,SILENT,FOLLOW_SILENT_in_move3074);  
					stream_SILENT.add(SILENT256);

					}
					break;

			}

			pushFollow(FOLLOW_graphOrDefault_in_move3079);
			from=graphOrDefault();
			state._fsp--;

			stream_graphOrDefault.add(from.getTree());
			TO257=(Token)match(input,TO,FOLLOW_TO_in_move3081);  
			stream_TO.add(TO257);

			pushFollow(FOLLOW_graphOrDefault_in_move3085);
			to=graphOrDefault();
			state._fsp--;

			stream_graphOrDefault.add(to.getTree());
			// AST REWRITE
			// elements: MOVE, to, SILENT, from
			// token labels: 
			// rule labels: to, retval, from
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_to=new RewriteRuleSubtreeStream(adaptor,"rule to",to!=null?to.getTree():null);
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);
			RewriteRuleSubtreeStream stream_from=new RewriteRuleSubtreeStream(adaptor,"rule from",from!=null?from.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 524:61: -> ^( MOVE ( SILENT )* $from $to)
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:524:64: ^( MOVE ( SILENT )* $from $to)
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot(stream_MOVE.nextNode(), root_1);
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:524:71: ( SILENT )*
				while ( stream_SILENT.hasNext() ) {
					adaptor.addChild(root_1, stream_SILENT.nextNode());
				}
				stream_SILENT.reset();

				adaptor.addChild(root_1, stream_from.nextTree());
				adaptor.addChild(root_1, stream_to.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "move"


	public static class copy_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "copy"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:527:1: copy : COPY ( SILENT )? from= graphOrDefault TO to= graphOrDefault -> ^( COPY ( SILENT )* $from $to) ;
	public final SparqlifyConfigParser.copy_return copy() throws RecognitionException {
		SparqlifyConfigParser.copy_return retval = new SparqlifyConfigParser.copy_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token COPY258=null;
		Token SILENT259=null;
		Token TO260=null;
		ParserRuleReturnScope from =null;
		ParserRuleReturnScope to =null;

		CommonTree COPY258_tree=null;
		CommonTree SILENT259_tree=null;
		CommonTree TO260_tree=null;
		RewriteRuleTokenStream stream_SILENT=new RewriteRuleTokenStream(adaptor,"token SILENT");
		RewriteRuleTokenStream stream_TO=new RewriteRuleTokenStream(adaptor,"token TO");
		RewriteRuleTokenStream stream_COPY=new RewriteRuleTokenStream(adaptor,"token COPY");
		RewriteRuleSubtreeStream stream_graphOrDefault=new RewriteRuleSubtreeStream(adaptor,"rule graphOrDefault");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:528:5: ( COPY ( SILENT )? from= graphOrDefault TO to= graphOrDefault -> ^( COPY ( SILENT )* $from $to) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:528:7: COPY ( SILENT )? from= graphOrDefault TO to= graphOrDefault
			{
			COPY258=(Token)match(input,COPY,FOLLOW_COPY_in_copy3121);  
			stream_COPY.add(COPY258);

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:528:12: ( SILENT )?
			int alt78=2;
			int LA78_0 = input.LA(1);
			if ( (LA78_0==SILENT) ) {
				alt78=1;
			}
			switch (alt78) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:528:12: SILENT
					{
					SILENT259=(Token)match(input,SILENT,FOLLOW_SILENT_in_copy3123);  
					stream_SILENT.add(SILENT259);

					}
					break;

			}

			pushFollow(FOLLOW_graphOrDefault_in_copy3128);
			from=graphOrDefault();
			state._fsp--;

			stream_graphOrDefault.add(from.getTree());
			TO260=(Token)match(input,TO,FOLLOW_TO_in_copy3130);  
			stream_TO.add(TO260);

			pushFollow(FOLLOW_graphOrDefault_in_copy3134);
			to=graphOrDefault();
			state._fsp--;

			stream_graphOrDefault.add(to.getTree());
			// AST REWRITE
			// elements: SILENT, from, to, COPY
			// token labels: 
			// rule labels: to, retval, from
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_to=new RewriteRuleSubtreeStream(adaptor,"rule to",to!=null?to.getTree():null);
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);
			RewriteRuleSubtreeStream stream_from=new RewriteRuleSubtreeStream(adaptor,"rule from",from!=null?from.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 528:61: -> ^( COPY ( SILENT )* $from $to)
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:528:64: ^( COPY ( SILENT )* $from $to)
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot(stream_COPY.nextNode(), root_1);
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:528:71: ( SILENT )*
				while ( stream_SILENT.hasNext() ) {
					adaptor.addChild(root_1, stream_SILENT.nextNode());
				}
				stream_SILENT.reset();

				adaptor.addChild(root_1, stream_from.nextTree());
				adaptor.addChild(root_1, stream_to.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "copy"


	public static class insert_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "insert"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:531:1: insert : INSERT DATA quadPattern -> ^( INSERT DATA quadPattern ) ;
	public final SparqlifyConfigParser.insert_return insert() throws RecognitionException {
		SparqlifyConfigParser.insert_return retval = new SparqlifyConfigParser.insert_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token INSERT261=null;
		Token DATA262=null;
		ParserRuleReturnScope quadPattern263 =null;

		CommonTree INSERT261_tree=null;
		CommonTree DATA262_tree=null;
		RewriteRuleTokenStream stream_INSERT=new RewriteRuleTokenStream(adaptor,"token INSERT");
		RewriteRuleTokenStream stream_DATA=new RewriteRuleTokenStream(adaptor,"token DATA");
		RewriteRuleSubtreeStream stream_quadPattern=new RewriteRuleSubtreeStream(adaptor,"rule quadPattern");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:532:5: ( INSERT DATA quadPattern -> ^( INSERT DATA quadPattern ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:532:7: INSERT DATA quadPattern
			{
			INSERT261=(Token)match(input,INSERT,FOLLOW_INSERT_in_insert3166);  
			stream_INSERT.add(INSERT261);

			DATA262=(Token)match(input,DATA,FOLLOW_DATA_in_insert3168);  
			stream_DATA.add(DATA262);

			pushFollow(FOLLOW_quadPattern_in_insert3170);
			quadPattern263=quadPattern();
			state._fsp--;

			stream_quadPattern.add(quadPattern263.getTree());
			// AST REWRITE
			// elements: DATA, quadPattern, INSERT
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 532:31: -> ^( INSERT DATA quadPattern )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:532:34: ^( INSERT DATA quadPattern )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot(stream_INSERT.nextNode(), root_1);
				adaptor.addChild(root_1, stream_DATA.nextNode());
				adaptor.addChild(root_1, stream_quadPattern.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "insert"


	public static class delete_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "delete"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:535:1: delete : DELETE ( deleteData | deleteWhere ) ;
	public final SparqlifyConfigParser.delete_return delete() throws RecognitionException {
		SparqlifyConfigParser.delete_return retval = new SparqlifyConfigParser.delete_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token DELETE264=null;
		ParserRuleReturnScope deleteData265 =null;
		ParserRuleReturnScope deleteWhere266 =null;

		CommonTree DELETE264_tree=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:536:5: ( DELETE ( deleteData | deleteWhere ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:536:7: DELETE ( deleteData | deleteWhere )
			{
			root_0 = (CommonTree)adaptor.nil();


			DELETE264=(Token)match(input,DELETE,FOLLOW_DELETE_in_delete3204); 
			DELETE264_tree = (CommonTree)adaptor.create(DELETE264);
			adaptor.addChild(root_0, DELETE264_tree);

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:536:14: ( deleteData | deleteWhere )
			int alt79=2;
			int LA79_0 = input.LA(1);
			if ( (LA79_0==DATA) ) {
				alt79=1;
			}
			else if ( (LA79_0==WHERE) ) {
				alt79=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 79, 0, input);
				throw nvae;
			}

			switch (alt79) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:536:16: deleteData
					{
					pushFollow(FOLLOW_deleteData_in_delete3208);
					deleteData265=deleteData();
					state._fsp--;

					adaptor.addChild(root_0, deleteData265.getTree());

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:536:29: deleteWhere
					{
					pushFollow(FOLLOW_deleteWhere_in_delete3212);
					deleteWhere266=deleteWhere();
					state._fsp--;

					adaptor.addChild(root_0, deleteWhere266.getTree());

					}
					break;

			}

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "delete"


	public static class deleteData_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "deleteData"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:539:1: deleteData : DATA quadPattern -> ^( DELETE DATA quadPattern ) ;
	public final SparqlifyConfigParser.deleteData_return deleteData() throws RecognitionException {
		SparqlifyConfigParser.deleteData_return retval = new SparqlifyConfigParser.deleteData_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token DATA267=null;
		ParserRuleReturnScope quadPattern268 =null;

		CommonTree DATA267_tree=null;
		RewriteRuleTokenStream stream_DATA=new RewriteRuleTokenStream(adaptor,"token DATA");
		RewriteRuleSubtreeStream stream_quadPattern=new RewriteRuleSubtreeStream(adaptor,"rule quadPattern");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:540:5: ( DATA quadPattern -> ^( DELETE DATA quadPattern ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:540:7: DATA quadPattern
			{
			DATA267=(Token)match(input,DATA,FOLLOW_DATA_in_deleteData3231);  
			stream_DATA.add(DATA267);

			pushFollow(FOLLOW_quadPattern_in_deleteData3233);
			quadPattern268=quadPattern();
			state._fsp--;

			stream_quadPattern.add(quadPattern268.getTree());
			// AST REWRITE
			// elements: DATA, quadPattern
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 540:24: -> ^( DELETE DATA quadPattern )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:540:27: ^( DELETE DATA quadPattern )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(DELETE, "DELETE"), root_1);
				adaptor.addChild(root_1, stream_DATA.nextNode());
				adaptor.addChild(root_1, stream_quadPattern.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "deleteData"


	public static class deleteWhere_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "deleteWhere"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:543:1: deleteWhere : WHERE quadPattern -> ^( DELETE WHERE quadPattern ) ;
	public final SparqlifyConfigParser.deleteWhere_return deleteWhere() throws RecognitionException {
		SparqlifyConfigParser.deleteWhere_return retval = new SparqlifyConfigParser.deleteWhere_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token WHERE269=null;
		ParserRuleReturnScope quadPattern270 =null;

		CommonTree WHERE269_tree=null;
		RewriteRuleTokenStream stream_WHERE=new RewriteRuleTokenStream(adaptor,"token WHERE");
		RewriteRuleSubtreeStream stream_quadPattern=new RewriteRuleSubtreeStream(adaptor,"rule quadPattern");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:544:5: ( WHERE quadPattern -> ^( DELETE WHERE quadPattern ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:544:7: WHERE quadPattern
			{
			WHERE269=(Token)match(input,WHERE,FOLLOW_WHERE_in_deleteWhere3260);  
			stream_WHERE.add(WHERE269);

			pushFollow(FOLLOW_quadPattern_in_deleteWhere3262);
			quadPattern270=quadPattern();
			state._fsp--;

			stream_quadPattern.add(quadPattern270.getTree());
			// AST REWRITE
			// elements: quadPattern, WHERE
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 544:25: -> ^( DELETE WHERE quadPattern )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:544:28: ^( DELETE WHERE quadPattern )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(DELETE, "DELETE"), root_1);
				adaptor.addChild(root_1, stream_WHERE.nextNode());
				adaptor.addChild(root_1, stream_quadPattern.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "deleteWhere"


	public static class modify_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "modify"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:547:1: modify : ( WITH i= iriRef )? ( deleteClause ( insertClause )? | insertClause ) ( usingClause )* WHERE groupGraphPattern -> ^( MODIFY ( ^( WITH $i) )? ( deleteClause )* ( insertClause )* ( usingClause )* ^( WHERE groupGraphPattern ) ) ;
	public final SparqlifyConfigParser.modify_return modify() throws RecognitionException {
		SparqlifyConfigParser.modify_return retval = new SparqlifyConfigParser.modify_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token WITH271=null;
		Token WHERE276=null;
		ParserRuleReturnScope i =null;
		ParserRuleReturnScope deleteClause272 =null;
		ParserRuleReturnScope insertClause273 =null;
		ParserRuleReturnScope insertClause274 =null;
		ParserRuleReturnScope usingClause275 =null;
		ParserRuleReturnScope groupGraphPattern277 =null;

		CommonTree WITH271_tree=null;
		CommonTree WHERE276_tree=null;
		RewriteRuleTokenStream stream_WHERE=new RewriteRuleTokenStream(adaptor,"token WHERE");
		RewriteRuleTokenStream stream_WITH=new RewriteRuleTokenStream(adaptor,"token WITH");
		RewriteRuleSubtreeStream stream_deleteClause=new RewriteRuleSubtreeStream(adaptor,"rule deleteClause");
		RewriteRuleSubtreeStream stream_groupGraphPattern=new RewriteRuleSubtreeStream(adaptor,"rule groupGraphPattern");
		RewriteRuleSubtreeStream stream_iriRef=new RewriteRuleSubtreeStream(adaptor,"rule iriRef");
		RewriteRuleSubtreeStream stream_insertClause=new RewriteRuleSubtreeStream(adaptor,"rule insertClause");
		RewriteRuleSubtreeStream stream_usingClause=new RewriteRuleSubtreeStream(adaptor,"rule usingClause");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:548:5: ( ( WITH i= iriRef )? ( deleteClause ( insertClause )? | insertClause ) ( usingClause )* WHERE groupGraphPattern -> ^( MODIFY ( ^( WITH $i) )? ( deleteClause )* ( insertClause )* ( usingClause )* ^( WHERE groupGraphPattern ) ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:548:7: ( WITH i= iriRef )? ( deleteClause ( insertClause )? | insertClause ) ( usingClause )* WHERE groupGraphPattern
			{
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:548:7: ( WITH i= iriRef )?
			int alt80=2;
			int LA80_0 = input.LA(1);
			if ( (LA80_0==WITH) ) {
				alt80=1;
			}
			switch (alt80) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:548:9: WITH i= iriRef
					{
					WITH271=(Token)match(input,WITH,FOLLOW_WITH_in_modify3295);  
					stream_WITH.add(WITH271);

					pushFollow(FOLLOW_iriRef_in_modify3299);
					i=iriRef();
					state._fsp--;

					stream_iriRef.add(i.getTree());
					}
					break;

			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:548:26: ( deleteClause ( insertClause )? | insertClause )
			int alt82=2;
			int LA82_0 = input.LA(1);
			if ( (LA82_0==DELETE) ) {
				alt82=1;
			}
			else if ( (LA82_0==INSERT) ) {
				alt82=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 82, 0, input);
				throw nvae;
			}

			switch (alt82) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:548:27: deleteClause ( insertClause )?
					{
					pushFollow(FOLLOW_deleteClause_in_modify3305);
					deleteClause272=deleteClause();
					state._fsp--;

					stream_deleteClause.add(deleteClause272.getTree());
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:548:40: ( insertClause )?
					int alt81=2;
					int LA81_0 = input.LA(1);
					if ( (LA81_0==INSERT) ) {
						alt81=1;
					}
					switch (alt81) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:548:40: insertClause
							{
							pushFollow(FOLLOW_insertClause_in_modify3307);
							insertClause273=insertClause();
							state._fsp--;

							stream_insertClause.add(insertClause273.getTree());
							}
							break;

					}

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:548:56: insertClause
					{
					pushFollow(FOLLOW_insertClause_in_modify3312);
					insertClause274=insertClause();
					state._fsp--;

					stream_insertClause.add(insertClause274.getTree());
					}
					break;

			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:548:70: ( usingClause )*
			loop83:
			while (true) {
				int alt83=2;
				int LA83_0 = input.LA(1);
				if ( (LA83_0==USING) ) {
					alt83=1;
				}

				switch (alt83) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:548:70: usingClause
					{
					pushFollow(FOLLOW_usingClause_in_modify3315);
					usingClause275=usingClause();
					state._fsp--;

					stream_usingClause.add(usingClause275.getTree());
					}
					break;

				default :
					break loop83;
				}
			}

			WHERE276=(Token)match(input,WHERE,FOLLOW_WHERE_in_modify3318);  
			stream_WHERE.add(WHERE276);

			pushFollow(FOLLOW_groupGraphPattern_in_modify3320);
			groupGraphPattern277=groupGraphPattern();
			state._fsp--;

			stream_groupGraphPattern.add(groupGraphPattern277.getTree());
			// AST REWRITE
			// elements: usingClause, insertClause, groupGraphPattern, WHERE, deleteClause, i, WITH
			// token labels: 
			// rule labels: retval, i
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);
			RewriteRuleSubtreeStream stream_i=new RewriteRuleSubtreeStream(adaptor,"rule i",i!=null?i.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 548:107: -> ^( MODIFY ( ^( WITH $i) )? ( deleteClause )* ( insertClause )* ( usingClause )* ^( WHERE groupGraphPattern ) )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:548:110: ^( MODIFY ( ^( WITH $i) )? ( deleteClause )* ( insertClause )* ( usingClause )* ^( WHERE groupGraphPattern ) )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(MODIFY, "MODIFY"), root_1);
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:548:119: ( ^( WITH $i) )?
				if ( stream_i.hasNext()||stream_WITH.hasNext() ) {
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:548:119: ^( WITH $i)
					{
					CommonTree root_2 = (CommonTree)adaptor.nil();
					root_2 = (CommonTree)adaptor.becomeRoot(stream_WITH.nextNode(), root_2);
					adaptor.addChild(root_2, stream_i.nextTree());
					adaptor.addChild(root_1, root_2);
					}

				}
				stream_i.reset();
				stream_WITH.reset();

				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:548:131: ( deleteClause )*
				while ( stream_deleteClause.hasNext() ) {
					adaptor.addChild(root_1, stream_deleteClause.nextTree());
				}
				stream_deleteClause.reset();

				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:548:145: ( insertClause )*
				while ( stream_insertClause.hasNext() ) {
					adaptor.addChild(root_1, stream_insertClause.nextTree());
				}
				stream_insertClause.reset();

				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:548:159: ( usingClause )*
				while ( stream_usingClause.hasNext() ) {
					adaptor.addChild(root_1, stream_usingClause.nextTree());
				}
				stream_usingClause.reset();

				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:548:172: ^( WHERE groupGraphPattern )
				{
				CommonTree root_2 = (CommonTree)adaptor.nil();
				root_2 = (CommonTree)adaptor.becomeRoot(stream_WHERE.nextNode(), root_2);
				adaptor.addChild(root_2, stream_groupGraphPattern.nextTree());
				adaptor.addChild(root_1, root_2);
				}

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "modify"


	public static class deleteClause_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "deleteClause"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:551:1: deleteClause : DELETE quadPattern -> DELETE quadPattern ;
	public final SparqlifyConfigParser.deleteClause_return deleteClause() throws RecognitionException {
		SparqlifyConfigParser.deleteClause_return retval = new SparqlifyConfigParser.deleteClause_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token DELETE278=null;
		ParserRuleReturnScope quadPattern279 =null;

		CommonTree DELETE278_tree=null;
		RewriteRuleTokenStream stream_DELETE=new RewriteRuleTokenStream(adaptor,"token DELETE");
		RewriteRuleSubtreeStream stream_quadPattern=new RewriteRuleSubtreeStream(adaptor,"rule quadPattern");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:552:5: ( DELETE quadPattern -> DELETE quadPattern )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:552:7: DELETE quadPattern
			{
			DELETE278=(Token)match(input,DELETE,FOLLOW_DELETE_in_deleteClause3368);  
			stream_DELETE.add(DELETE278);

			pushFollow(FOLLOW_quadPattern_in_deleteClause3370);
			quadPattern279=quadPattern();
			state._fsp--;

			stream_quadPattern.add(quadPattern279.getTree());
			// AST REWRITE
			// elements: quadPattern, DELETE
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 552:26: -> DELETE quadPattern
			{
				adaptor.addChild(root_0, stream_DELETE.nextNode());
				adaptor.addChild(root_0, stream_quadPattern.nextTree());
			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "deleteClause"


	public static class insertClause_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "insertClause"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:555:1: insertClause : INSERT quadPattern -> INSERT quadPattern ;
	public final SparqlifyConfigParser.insertClause_return insertClause() throws RecognitionException {
		SparqlifyConfigParser.insertClause_return retval = new SparqlifyConfigParser.insertClause_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token INSERT280=null;
		ParserRuleReturnScope quadPattern281 =null;

		CommonTree INSERT280_tree=null;
		RewriteRuleTokenStream stream_INSERT=new RewriteRuleTokenStream(adaptor,"token INSERT");
		RewriteRuleSubtreeStream stream_quadPattern=new RewriteRuleSubtreeStream(adaptor,"rule quadPattern");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:556:5: ( INSERT quadPattern -> INSERT quadPattern )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:556:7: INSERT quadPattern
			{
			INSERT280=(Token)match(input,INSERT,FOLLOW_INSERT_in_insertClause3399);  
			stream_INSERT.add(INSERT280);

			pushFollow(FOLLOW_quadPattern_in_insertClause3401);
			quadPattern281=quadPattern();
			state._fsp--;

			stream_quadPattern.add(quadPattern281.getTree());
			// AST REWRITE
			// elements: quadPattern, INSERT
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 556:26: -> INSERT quadPattern
			{
				adaptor.addChild(root_0, stream_INSERT.nextNode());
				adaptor.addChild(root_0, stream_quadPattern.nextTree());
			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "insertClause"


	public static class usingClause_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "usingClause"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:559:1: usingClause : USING ( NAMED )? iriRef -> ^( USING ( NAMED )? iriRef ) ;
	public final SparqlifyConfigParser.usingClause_return usingClause() throws RecognitionException {
		SparqlifyConfigParser.usingClause_return retval = new SparqlifyConfigParser.usingClause_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token USING282=null;
		Token NAMED283=null;
		ParserRuleReturnScope iriRef284 =null;

		CommonTree USING282_tree=null;
		CommonTree NAMED283_tree=null;
		RewriteRuleTokenStream stream_USING=new RewriteRuleTokenStream(adaptor,"token USING");
		RewriteRuleTokenStream stream_NAMED=new RewriteRuleTokenStream(adaptor,"token NAMED");
		RewriteRuleSubtreeStream stream_iriRef=new RewriteRuleSubtreeStream(adaptor,"rule iriRef");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:560:5: ( USING ( NAMED )? iriRef -> ^( USING ( NAMED )? iriRef ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:560:7: USING ( NAMED )? iriRef
			{
			USING282=(Token)match(input,USING,FOLLOW_USING_in_usingClause3424);  
			stream_USING.add(USING282);

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:560:13: ( NAMED )?
			int alt84=2;
			int LA84_0 = input.LA(1);
			if ( (LA84_0==NAMED) ) {
				alt84=1;
			}
			switch (alt84) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:560:13: NAMED
					{
					NAMED283=(Token)match(input,NAMED,FOLLOW_NAMED_in_usingClause3426);  
					stream_NAMED.add(NAMED283);

					}
					break;

			}

			pushFollow(FOLLOW_iriRef_in_usingClause3429);
			iriRef284=iriRef();
			state._fsp--;

			stream_iriRef.add(iriRef284.getTree());
			// AST REWRITE
			// elements: NAMED, USING, iriRef
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 560:27: -> ^( USING ( NAMED )? iriRef )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:560:30: ^( USING ( NAMED )? iriRef )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot(stream_USING.nextNode(), root_1);
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:560:38: ( NAMED )?
				if ( stream_NAMED.hasNext() ) {
					adaptor.addChild(root_1, stream_NAMED.nextNode());
				}
				stream_NAMED.reset();

				adaptor.addChild(root_1, stream_iriRef.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "usingClause"


	public static class graphOrDefault_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "graphOrDefault"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:563:1: graphOrDefault : ( DEFAULT | ( GRAPH )? iriRef );
	public final SparqlifyConfigParser.graphOrDefault_return graphOrDefault() throws RecognitionException {
		SparqlifyConfigParser.graphOrDefault_return retval = new SparqlifyConfigParser.graphOrDefault_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token DEFAULT285=null;
		Token GRAPH286=null;
		ParserRuleReturnScope iriRef287 =null;

		CommonTree DEFAULT285_tree=null;
		CommonTree GRAPH286_tree=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:564:5: ( DEFAULT | ( GRAPH )? iriRef )
			int alt86=2;
			int LA86_0 = input.LA(1);
			if ( (LA86_0==DEFAULT) ) {
				alt86=1;
			}
			else if ( (LA86_0==GRAPH||LA86_0==IRI_REF||(LA86_0 >= PNAME_LN && LA86_0 <= PNAME_NS)) ) {
				alt86=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 86, 0, input);
				throw nvae;
			}

			switch (alt86) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:564:7: DEFAULT
					{
					root_0 = (CommonTree)adaptor.nil();


					DEFAULT285=(Token)match(input,DEFAULT,FOLLOW_DEFAULT_in_graphOrDefault3460); 
					DEFAULT285_tree = (CommonTree)adaptor.create(DEFAULT285);
					adaptor.addChild(root_0, DEFAULT285_tree);

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:565:7: ( GRAPH )? iriRef
					{
					root_0 = (CommonTree)adaptor.nil();


					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:565:7: ( GRAPH )?
					int alt85=2;
					int LA85_0 = input.LA(1);
					if ( (LA85_0==GRAPH) ) {
						alt85=1;
					}
					switch (alt85) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:565:7: GRAPH
							{
							GRAPH286=(Token)match(input,GRAPH,FOLLOW_GRAPH_in_graphOrDefault3469); 
							GRAPH286_tree = (CommonTree)adaptor.create(GRAPH286);
							adaptor.addChild(root_0, GRAPH286_tree);

							}
							break;

					}

					pushFollow(FOLLOW_iriRef_in_graphOrDefault3472);
					iriRef287=iriRef();
					state._fsp--;

					adaptor.addChild(root_0, iriRef287.getTree());

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "graphOrDefault"


	public static class graphRef_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "graphRef"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:568:1: graphRef : GRAPH iriRef ;
	public final SparqlifyConfigParser.graphRef_return graphRef() throws RecognitionException {
		SparqlifyConfigParser.graphRef_return retval = new SparqlifyConfigParser.graphRef_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token GRAPH288=null;
		ParserRuleReturnScope iriRef289 =null;

		CommonTree GRAPH288_tree=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:569:5: ( GRAPH iriRef )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:569:7: GRAPH iriRef
			{
			root_0 = (CommonTree)adaptor.nil();


			GRAPH288=(Token)match(input,GRAPH,FOLLOW_GRAPH_in_graphRef3499); 
			GRAPH288_tree = (CommonTree)adaptor.create(GRAPH288);
			adaptor.addChild(root_0, GRAPH288_tree);

			pushFollow(FOLLOW_iriRef_in_graphRef3501);
			iriRef289=iriRef();
			state._fsp--;

			adaptor.addChild(root_0, iriRef289.getTree());

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "graphRef"


	public static class graphRefAll_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "graphRefAll"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:572:1: graphRefAll : ( graphRef | DEFAULT | NAMED | ALL );
	public final SparqlifyConfigParser.graphRefAll_return graphRefAll() throws RecognitionException {
		SparqlifyConfigParser.graphRefAll_return retval = new SparqlifyConfigParser.graphRefAll_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token DEFAULT291=null;
		Token NAMED292=null;
		Token ALL293=null;
		ParserRuleReturnScope graphRef290 =null;

		CommonTree DEFAULT291_tree=null;
		CommonTree NAMED292_tree=null;
		CommonTree ALL293_tree=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:573:5: ( graphRef | DEFAULT | NAMED | ALL )
			int alt87=4;
			switch ( input.LA(1) ) {
			case GRAPH:
				{
				alt87=1;
				}
				break;
			case DEFAULT:
				{
				alt87=2;
				}
				break;
			case NAMED:
				{
				alt87=3;
				}
				break;
			case ALL:
				{
				alt87=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 87, 0, input);
				throw nvae;
			}
			switch (alt87) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:573:7: graphRef
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_graphRef_in_graphRefAll3518);
					graphRef290=graphRef();
					state._fsp--;

					adaptor.addChild(root_0, graphRef290.getTree());

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:573:18: DEFAULT
					{
					root_0 = (CommonTree)adaptor.nil();


					DEFAULT291=(Token)match(input,DEFAULT,FOLLOW_DEFAULT_in_graphRefAll3522); 
					DEFAULT291_tree = (CommonTree)adaptor.create(DEFAULT291);
					adaptor.addChild(root_0, DEFAULT291_tree);

					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:573:28: NAMED
					{
					root_0 = (CommonTree)adaptor.nil();


					NAMED292=(Token)match(input,NAMED,FOLLOW_NAMED_in_graphRefAll3526); 
					NAMED292_tree = (CommonTree)adaptor.create(NAMED292);
					adaptor.addChild(root_0, NAMED292_tree);

					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:573:36: ALL
					{
					root_0 = (CommonTree)adaptor.nil();


					ALL293=(Token)match(input,ALL,FOLLOW_ALL_in_graphRefAll3530); 
					ALL293_tree = (CommonTree)adaptor.create(ALL293);
					adaptor.addChild(root_0, ALL293_tree);

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "graphRefAll"


	public static class quadPattern_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "quadPattern"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:576:1: quadPattern : OPEN_CURLY_BRACE quads CLOSE_CURLY_BRACE -> quads ;
	public final SparqlifyConfigParser.quadPattern_return quadPattern() throws RecognitionException {
		SparqlifyConfigParser.quadPattern_return retval = new SparqlifyConfigParser.quadPattern_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token OPEN_CURLY_BRACE294=null;
		Token CLOSE_CURLY_BRACE296=null;
		ParserRuleReturnScope quads295 =null;

		CommonTree OPEN_CURLY_BRACE294_tree=null;
		CommonTree CLOSE_CURLY_BRACE296_tree=null;
		RewriteRuleTokenStream stream_OPEN_CURLY_BRACE=new RewriteRuleTokenStream(adaptor,"token OPEN_CURLY_BRACE");
		RewriteRuleTokenStream stream_CLOSE_CURLY_BRACE=new RewriteRuleTokenStream(adaptor,"token CLOSE_CURLY_BRACE");
		RewriteRuleSubtreeStream stream_quads=new RewriteRuleSubtreeStream(adaptor,"rule quads");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:577:5: ( OPEN_CURLY_BRACE quads CLOSE_CURLY_BRACE -> quads )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:577:7: OPEN_CURLY_BRACE quads CLOSE_CURLY_BRACE
			{
			OPEN_CURLY_BRACE294=(Token)match(input,OPEN_CURLY_BRACE,FOLLOW_OPEN_CURLY_BRACE_in_quadPattern3547);  
			stream_OPEN_CURLY_BRACE.add(OPEN_CURLY_BRACE294);

			pushFollow(FOLLOW_quads_in_quadPattern3549);
			quads295=quads();
			state._fsp--;

			stream_quads.add(quads295.getTree());
			CLOSE_CURLY_BRACE296=(Token)match(input,CLOSE_CURLY_BRACE,FOLLOW_CLOSE_CURLY_BRACE_in_quadPattern3551);  
			stream_CLOSE_CURLY_BRACE.add(CLOSE_CURLY_BRACE296);

			// AST REWRITE
			// elements: quads
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 577:48: -> quads
			{
				adaptor.addChild(root_0, stream_quads.nextTree());
			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "quadPattern"


	public static class quads_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "quads"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:580:1: quads : (a= triplesTemplate )? ( quadsNotTriples ( DOT )? (b= triplesTemplate )? )* -> ( $a)? ( quadsNotTriples ( $b)? )* ;
	public final SparqlifyConfigParser.quads_return quads() throws RecognitionException {
		SparqlifyConfigParser.quads_return retval = new SparqlifyConfigParser.quads_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token DOT298=null;
		ParserRuleReturnScope a =null;
		ParserRuleReturnScope b =null;
		ParserRuleReturnScope quadsNotTriples297 =null;

		CommonTree DOT298_tree=null;
		RewriteRuleTokenStream stream_DOT=new RewriteRuleTokenStream(adaptor,"token DOT");
		RewriteRuleSubtreeStream stream_triplesTemplate=new RewriteRuleSubtreeStream(adaptor,"rule triplesTemplate");
		RewriteRuleSubtreeStream stream_quadsNotTriples=new RewriteRuleSubtreeStream(adaptor,"rule quadsNotTriples");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:581:5: ( (a= triplesTemplate )? ( quadsNotTriples ( DOT )? (b= triplesTemplate )? )* -> ( $a)? ( quadsNotTriples ( $b)? )* )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:581:7: (a= triplesTemplate )? ( quadsNotTriples ( DOT )? (b= triplesTemplate )? )*
			{
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:581:8: (a= triplesTemplate )?
			int alt88=2;
			int LA88_0 = input.LA(1);
			if ( (LA88_0==BLANK_NODE_LABEL||(LA88_0 >= DECIMAL && LA88_0 <= DECIMAL_POSITIVE)||(LA88_0 >= DOUBLE && LA88_0 <= DOUBLE_POSITIVE)||LA88_0==FALSE||(LA88_0 >= INTEGER && LA88_0 <= INTEGER_POSITIVE)||LA88_0==IRI_REF||LA88_0==OPEN_BRACE||LA88_0==OPEN_SQUARE_BRACKET||(LA88_0 >= PNAME_LN && LA88_0 <= PNAME_NS)||(LA88_0 >= STRING_LITERAL1 && LA88_0 <= STRING_LITERAL_LONG2)||LA88_0==TRUE||(LA88_0 >= VAR1 && LA88_0 <= VAR3)) ) {
				alt88=1;
			}
			switch (alt88) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:581:8: a= triplesTemplate
					{
					pushFollow(FOLLOW_triplesTemplate_in_quads3578);
					a=triplesTemplate();
					state._fsp--;

					stream_triplesTemplate.add(a.getTree());
					}
					break;

			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:581:26: ( quadsNotTriples ( DOT )? (b= triplesTemplate )? )*
			loop91:
			while (true) {
				int alt91=2;
				int LA91_0 = input.LA(1);
				if ( (LA91_0==GRAPH) ) {
					alt91=1;
				}

				switch (alt91) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:581:28: quadsNotTriples ( DOT )? (b= triplesTemplate )?
					{
					pushFollow(FOLLOW_quadsNotTriples_in_quads3583);
					quadsNotTriples297=quadsNotTriples();
					state._fsp--;

					stream_quadsNotTriples.add(quadsNotTriples297.getTree());
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:581:44: ( DOT )?
					int alt89=2;
					int LA89_0 = input.LA(1);
					if ( (LA89_0==DOT) ) {
						alt89=1;
					}
					switch (alt89) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:581:44: DOT
							{
							DOT298=(Token)match(input,DOT,FOLLOW_DOT_in_quads3585);  
							stream_DOT.add(DOT298);

							}
							break;

					}

					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:581:50: (b= triplesTemplate )?
					int alt90=2;
					int LA90_0 = input.LA(1);
					if ( (LA90_0==BLANK_NODE_LABEL||(LA90_0 >= DECIMAL && LA90_0 <= DECIMAL_POSITIVE)||(LA90_0 >= DOUBLE && LA90_0 <= DOUBLE_POSITIVE)||LA90_0==FALSE||(LA90_0 >= INTEGER && LA90_0 <= INTEGER_POSITIVE)||LA90_0==IRI_REF||LA90_0==OPEN_BRACE||LA90_0==OPEN_SQUARE_BRACKET||(LA90_0 >= PNAME_LN && LA90_0 <= PNAME_NS)||(LA90_0 >= STRING_LITERAL1 && LA90_0 <= STRING_LITERAL_LONG2)||LA90_0==TRUE||(LA90_0 >= VAR1 && LA90_0 <= VAR3)) ) {
						alt90=1;
					}
					switch (alt90) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:581:50: b= triplesTemplate
							{
							pushFollow(FOLLOW_triplesTemplate_in_quads3590);
							b=triplesTemplate();
							state._fsp--;

							stream_triplesTemplate.add(b.getTree());
							}
							break;

					}

					}
					break;

				default :
					break loop91;
				}
			}

			// AST REWRITE
			// elements: quadsNotTriples, a, b
			// token labels: 
			// rule labels: retval, b, a
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);
			RewriteRuleSubtreeStream stream_b=new RewriteRuleSubtreeStream(adaptor,"rule b",b!=null?b.getTree():null);
			RewriteRuleSubtreeStream stream_a=new RewriteRuleSubtreeStream(adaptor,"rule a",a!=null?a.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 581:71: -> ( $a)? ( quadsNotTriples ( $b)? )*
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:581:75: ( $a)?
				if ( stream_a.hasNext() ) {
					adaptor.addChild(root_0, stream_a.nextTree());
				}
				stream_a.reset();

				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:581:78: ( quadsNotTriples ( $b)? )*
				while ( stream_quadsNotTriples.hasNext() ) {
					adaptor.addChild(root_0, stream_quadsNotTriples.nextTree());
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:581:97: ( $b)?
					if ( stream_b.hasNext() ) {
						adaptor.addChild(root_0, stream_b.nextTree());
					}
					stream_b.reset();

				}
				stream_quadsNotTriples.reset();

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "quads"


	public static class quadsNotTriples_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "quadsNotTriples"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:584:1: quadsNotTriples : GRAPH varOrIRIref OPEN_CURLY_BRACE ( triplesTemplate )? CLOSE_CURLY_BRACE -> ^( GRAPH_TOKEN varOrIRIref ( triplesTemplate )? ) ;
	public final SparqlifyConfigParser.quadsNotTriples_return quadsNotTriples() throws RecognitionException {
		SparqlifyConfigParser.quadsNotTriples_return retval = new SparqlifyConfigParser.quadsNotTriples_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token GRAPH299=null;
		Token OPEN_CURLY_BRACE301=null;
		Token CLOSE_CURLY_BRACE303=null;
		ParserRuleReturnScope varOrIRIref300 =null;
		ParserRuleReturnScope triplesTemplate302 =null;

		CommonTree GRAPH299_tree=null;
		CommonTree OPEN_CURLY_BRACE301_tree=null;
		CommonTree CLOSE_CURLY_BRACE303_tree=null;
		RewriteRuleTokenStream stream_GRAPH=new RewriteRuleTokenStream(adaptor,"token GRAPH");
		RewriteRuleTokenStream stream_OPEN_CURLY_BRACE=new RewriteRuleTokenStream(adaptor,"token OPEN_CURLY_BRACE");
		RewriteRuleTokenStream stream_CLOSE_CURLY_BRACE=new RewriteRuleTokenStream(adaptor,"token CLOSE_CURLY_BRACE");
		RewriteRuleSubtreeStream stream_varOrIRIref=new RewriteRuleSubtreeStream(adaptor,"rule varOrIRIref");
		RewriteRuleSubtreeStream stream_triplesTemplate=new RewriteRuleSubtreeStream(adaptor,"rule triplesTemplate");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:585:5: ( GRAPH varOrIRIref OPEN_CURLY_BRACE ( triplesTemplate )? CLOSE_CURLY_BRACE -> ^( GRAPH_TOKEN varOrIRIref ( triplesTemplate )? ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:585:7: GRAPH varOrIRIref OPEN_CURLY_BRACE ( triplesTemplate )? CLOSE_CURLY_BRACE
			{
			GRAPH299=(Token)match(input,GRAPH,FOLLOW_GRAPH_in_quadsNotTriples3633);  
			stream_GRAPH.add(GRAPH299);

			pushFollow(FOLLOW_varOrIRIref_in_quadsNotTriples3635);
			varOrIRIref300=varOrIRIref();
			state._fsp--;

			stream_varOrIRIref.add(varOrIRIref300.getTree());
			OPEN_CURLY_BRACE301=(Token)match(input,OPEN_CURLY_BRACE,FOLLOW_OPEN_CURLY_BRACE_in_quadsNotTriples3637);  
			stream_OPEN_CURLY_BRACE.add(OPEN_CURLY_BRACE301);

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:585:42: ( triplesTemplate )?
			int alt92=2;
			int LA92_0 = input.LA(1);
			if ( (LA92_0==BLANK_NODE_LABEL||(LA92_0 >= DECIMAL && LA92_0 <= DECIMAL_POSITIVE)||(LA92_0 >= DOUBLE && LA92_0 <= DOUBLE_POSITIVE)||LA92_0==FALSE||(LA92_0 >= INTEGER && LA92_0 <= INTEGER_POSITIVE)||LA92_0==IRI_REF||LA92_0==OPEN_BRACE||LA92_0==OPEN_SQUARE_BRACKET||(LA92_0 >= PNAME_LN && LA92_0 <= PNAME_NS)||(LA92_0 >= STRING_LITERAL1 && LA92_0 <= STRING_LITERAL_LONG2)||LA92_0==TRUE||(LA92_0 >= VAR1 && LA92_0 <= VAR3)) ) {
				alt92=1;
			}
			switch (alt92) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:585:42: triplesTemplate
					{
					pushFollow(FOLLOW_triplesTemplate_in_quadsNotTriples3639);
					triplesTemplate302=triplesTemplate();
					state._fsp--;

					stream_triplesTemplate.add(triplesTemplate302.getTree());
					}
					break;

			}

			CLOSE_CURLY_BRACE303=(Token)match(input,CLOSE_CURLY_BRACE,FOLLOW_CLOSE_CURLY_BRACE_in_quadsNotTriples3642);  
			stream_CLOSE_CURLY_BRACE.add(CLOSE_CURLY_BRACE303);

			// AST REWRITE
			// elements: triplesTemplate, varOrIRIref
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 585:77: -> ^( GRAPH_TOKEN varOrIRIref ( triplesTemplate )? )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:585:80: ^( GRAPH_TOKEN varOrIRIref ( triplesTemplate )? )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(GRAPH_TOKEN, "GRAPH_TOKEN"), root_1);
				adaptor.addChild(root_1, stream_varOrIRIref.nextTree());
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:585:106: ( triplesTemplate )?
				if ( stream_triplesTemplate.hasNext() ) {
					adaptor.addChild(root_1, stream_triplesTemplate.nextTree());
				}
				stream_triplesTemplate.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "quadsNotTriples"


	public static class triplesTemplate_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "triplesTemplate"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:588:1: triplesTemplate : triplesSameSubject ( DOT triplesSameSubject )* ( DOT )? -> ^( TRIPLES_TEMPLATE ( triplesSameSubject )* ) ;
	public final SparqlifyConfigParser.triplesTemplate_return triplesTemplate() throws RecognitionException {
		SparqlifyConfigParser.triplesTemplate_return retval = new SparqlifyConfigParser.triplesTemplate_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token DOT305=null;
		Token DOT307=null;
		ParserRuleReturnScope triplesSameSubject304 =null;
		ParserRuleReturnScope triplesSameSubject306 =null;

		CommonTree DOT305_tree=null;
		CommonTree DOT307_tree=null;
		RewriteRuleTokenStream stream_DOT=new RewriteRuleTokenStream(adaptor,"token DOT");
		RewriteRuleSubtreeStream stream_triplesSameSubject=new RewriteRuleSubtreeStream(adaptor,"rule triplesSameSubject");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:589:5: ( triplesSameSubject ( DOT triplesSameSubject )* ( DOT )? -> ^( TRIPLES_TEMPLATE ( triplesSameSubject )* ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:589:7: triplesSameSubject ( DOT triplesSameSubject )* ( DOT )?
			{
			pushFollow(FOLLOW_triplesSameSubject_in_triplesTemplate3674);
			triplesSameSubject304=triplesSameSubject();
			state._fsp--;

			stream_triplesSameSubject.add(triplesSameSubject304.getTree());
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:589:26: ( DOT triplesSameSubject )*
			loop93:
			while (true) {
				int alt93=2;
				int LA93_0 = input.LA(1);
				if ( (LA93_0==DOT) ) {
					int LA93_1 = input.LA(2);
					if ( (LA93_1==BLANK_NODE_LABEL||(LA93_1 >= DECIMAL && LA93_1 <= DECIMAL_POSITIVE)||(LA93_1 >= DOUBLE && LA93_1 <= DOUBLE_POSITIVE)||LA93_1==FALSE||(LA93_1 >= INTEGER && LA93_1 <= INTEGER_POSITIVE)||LA93_1==IRI_REF||LA93_1==OPEN_BRACE||LA93_1==OPEN_SQUARE_BRACKET||(LA93_1 >= PNAME_LN && LA93_1 <= PNAME_NS)||(LA93_1 >= STRING_LITERAL1 && LA93_1 <= STRING_LITERAL_LONG2)||LA93_1==TRUE||(LA93_1 >= VAR1 && LA93_1 <= VAR3)) ) {
						alt93=1;
					}

				}

				switch (alt93) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:589:28: DOT triplesSameSubject
					{
					DOT305=(Token)match(input,DOT,FOLLOW_DOT_in_triplesTemplate3678);  
					stream_DOT.add(DOT305);

					pushFollow(FOLLOW_triplesSameSubject_in_triplesTemplate3680);
					triplesSameSubject306=triplesSameSubject();
					state._fsp--;

					stream_triplesSameSubject.add(triplesSameSubject306.getTree());
					}
					break;

				default :
					break loop93;
				}
			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:589:54: ( DOT )?
			int alt94=2;
			int LA94_0 = input.LA(1);
			if ( (LA94_0==DOT) ) {
				alt94=1;
			}
			switch (alt94) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:589:54: DOT
					{
					DOT307=(Token)match(input,DOT,FOLLOW_DOT_in_triplesTemplate3685);  
					stream_DOT.add(DOT307);

					}
					break;

			}

			// AST REWRITE
			// elements: triplesSameSubject
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 589:59: -> ^( TRIPLES_TEMPLATE ( triplesSameSubject )* )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:589:62: ^( TRIPLES_TEMPLATE ( triplesSameSubject )* )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(TRIPLES_TEMPLATE, "TRIPLES_TEMPLATE"), root_1);
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:589:81: ( triplesSameSubject )*
				while ( stream_triplesSameSubject.hasNext() ) {
					adaptor.addChild(root_1, stream_triplesSameSubject.nextTree());
				}
				stream_triplesSameSubject.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "triplesTemplate"


	public static class groupGraphPattern_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "groupGraphPattern"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:592:1: groupGraphPattern : OPEN_CURLY_BRACE ( subSelect | groupGraphPatternSub ) CLOSE_CURLY_BRACE -> ^( GROUP_GRAPH_PATTERN ( subSelect )* ( groupGraphPatternSub )* ) ;
	public final SparqlifyConfigParser.groupGraphPattern_return groupGraphPattern() throws RecognitionException {
		SparqlifyConfigParser.groupGraphPattern_return retval = new SparqlifyConfigParser.groupGraphPattern_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token OPEN_CURLY_BRACE308=null;
		Token CLOSE_CURLY_BRACE311=null;
		ParserRuleReturnScope subSelect309 =null;
		ParserRuleReturnScope groupGraphPatternSub310 =null;

		CommonTree OPEN_CURLY_BRACE308_tree=null;
		CommonTree CLOSE_CURLY_BRACE311_tree=null;
		RewriteRuleTokenStream stream_OPEN_CURLY_BRACE=new RewriteRuleTokenStream(adaptor,"token OPEN_CURLY_BRACE");
		RewriteRuleTokenStream stream_CLOSE_CURLY_BRACE=new RewriteRuleTokenStream(adaptor,"token CLOSE_CURLY_BRACE");
		RewriteRuleSubtreeStream stream_groupGraphPatternSub=new RewriteRuleSubtreeStream(adaptor,"rule groupGraphPatternSub");
		RewriteRuleSubtreeStream stream_subSelect=new RewriteRuleSubtreeStream(adaptor,"rule subSelect");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:593:5: ( OPEN_CURLY_BRACE ( subSelect | groupGraphPatternSub ) CLOSE_CURLY_BRACE -> ^( GROUP_GRAPH_PATTERN ( subSelect )* ( groupGraphPatternSub )* ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:593:7: OPEN_CURLY_BRACE ( subSelect | groupGraphPatternSub ) CLOSE_CURLY_BRACE
			{
			OPEN_CURLY_BRACE308=(Token)match(input,OPEN_CURLY_BRACE,FOLLOW_OPEN_CURLY_BRACE_in_groupGraphPattern3717);  
			stream_OPEN_CURLY_BRACE.add(OPEN_CURLY_BRACE308);

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:593:24: ( subSelect | groupGraphPatternSub )
			int alt95=2;
			int LA95_0 = input.LA(1);
			if ( (LA95_0==SELECT) ) {
				alt95=1;
			}
			else if ( (LA95_0==BIND||LA95_0==BLANK_NODE_LABEL||LA95_0==CLOSE_CURLY_BRACE||(LA95_0 >= DECIMAL && LA95_0 <= DECIMAL_POSITIVE)||(LA95_0 >= DOUBLE && LA95_0 <= DOUBLE_POSITIVE)||(LA95_0 >= FALSE && LA95_0 <= FILTER)||LA95_0==GRAPH||(LA95_0 >= INTEGER && LA95_0 <= INTEGER_POSITIVE)||LA95_0==IRI_REF||LA95_0==MINUS_KEYWORD||(LA95_0 >= OPEN_BRACE && LA95_0 <= OPTIONAL)||(LA95_0 >= PNAME_LN && LA95_0 <= PNAME_NS)||LA95_0==SERVICE||(LA95_0 >= STRING_LITERAL1 && LA95_0 <= STRING_LITERAL_LONG2)||LA95_0==TRUE||(LA95_0 >= VAR1 && LA95_0 <= VAR3)) ) {
				alt95=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 95, 0, input);
				throw nvae;
			}

			switch (alt95) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:593:26: subSelect
					{
					pushFollow(FOLLOW_subSelect_in_groupGraphPattern3721);
					subSelect309=subSelect();
					state._fsp--;

					stream_subSelect.add(subSelect309.getTree());
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:593:38: groupGraphPatternSub
					{
					pushFollow(FOLLOW_groupGraphPatternSub_in_groupGraphPattern3725);
					groupGraphPatternSub310=groupGraphPatternSub();
					state._fsp--;

					stream_groupGraphPatternSub.add(groupGraphPatternSub310.getTree());
					}
					break;

			}

			CLOSE_CURLY_BRACE311=(Token)match(input,CLOSE_CURLY_BRACE,FOLLOW_CLOSE_CURLY_BRACE_in_groupGraphPattern3729);  
			stream_CLOSE_CURLY_BRACE.add(CLOSE_CURLY_BRACE311);

			// AST REWRITE
			// elements: subSelect, groupGraphPatternSub
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 593:79: -> ^( GROUP_GRAPH_PATTERN ( subSelect )* ( groupGraphPatternSub )* )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:593:82: ^( GROUP_GRAPH_PATTERN ( subSelect )* ( groupGraphPatternSub )* )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(GROUP_GRAPH_PATTERN, "GROUP_GRAPH_PATTERN"), root_1);
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:593:104: ( subSelect )*
				while ( stream_subSelect.hasNext() ) {
					adaptor.addChild(root_1, stream_subSelect.nextTree());
				}
				stream_subSelect.reset();

				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:593:115: ( groupGraphPatternSub )*
				while ( stream_groupGraphPatternSub.hasNext() ) {
					adaptor.addChild(root_1, stream_groupGraphPatternSub.nextTree());
				}
				stream_groupGraphPatternSub.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "groupGraphPattern"


	public static class groupGraphPatternSub_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "groupGraphPatternSub"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:596:1: groupGraphPatternSub : ( triplesBlock )? ( groupGraphPatternSubCache )* -> ( triplesBlock )? ( groupGraphPatternSubCache )* ;
	public final SparqlifyConfigParser.groupGraphPatternSub_return groupGraphPatternSub() throws RecognitionException {
		SparqlifyConfigParser.groupGraphPatternSub_return retval = new SparqlifyConfigParser.groupGraphPatternSub_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		ParserRuleReturnScope triplesBlock312 =null;
		ParserRuleReturnScope groupGraphPatternSubCache313 =null;

		RewriteRuleSubtreeStream stream_triplesBlock=new RewriteRuleSubtreeStream(adaptor,"rule triplesBlock");
		RewriteRuleSubtreeStream stream_groupGraphPatternSubCache=new RewriteRuleSubtreeStream(adaptor,"rule groupGraphPatternSubCache");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:597:5: ( ( triplesBlock )? ( groupGraphPatternSubCache )* -> ( triplesBlock )? ( groupGraphPatternSubCache )* )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:597:7: ( triplesBlock )? ( groupGraphPatternSubCache )*
			{
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:597:7: ( triplesBlock )?
			int alt96=2;
			int LA96_0 = input.LA(1);
			if ( (LA96_0==BLANK_NODE_LABEL||(LA96_0 >= DECIMAL && LA96_0 <= DECIMAL_POSITIVE)||(LA96_0 >= DOUBLE && LA96_0 <= DOUBLE_POSITIVE)||LA96_0==FALSE||(LA96_0 >= INTEGER && LA96_0 <= INTEGER_POSITIVE)||LA96_0==IRI_REF||LA96_0==OPEN_BRACE||LA96_0==OPEN_SQUARE_BRACKET||(LA96_0 >= PNAME_LN && LA96_0 <= PNAME_NS)||(LA96_0 >= STRING_LITERAL1 && LA96_0 <= STRING_LITERAL_LONG2)||LA96_0==TRUE||(LA96_0 >= VAR1 && LA96_0 <= VAR3)) ) {
				alt96=1;
			}
			switch (alt96) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:597:7: triplesBlock
					{
					pushFollow(FOLLOW_triplesBlock_in_groupGraphPatternSub3762);
					triplesBlock312=triplesBlock();
					state._fsp--;

					stream_triplesBlock.add(triplesBlock312.getTree());
					}
					break;

			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:597:21: ( groupGraphPatternSubCache )*
			loop97:
			while (true) {
				int alt97=2;
				int LA97_0 = input.LA(1);
				if ( (LA97_0==BIND||LA97_0==FILTER||LA97_0==GRAPH||LA97_0==MINUS_KEYWORD||LA97_0==OPEN_CURLY_BRACE||LA97_0==OPTIONAL||LA97_0==SERVICE) ) {
					alt97=1;
				}

				switch (alt97) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:597:23: groupGraphPatternSubCache
					{
					pushFollow(FOLLOW_groupGraphPatternSubCache_in_groupGraphPatternSub3767);
					groupGraphPatternSubCache313=groupGraphPatternSubCache();
					state._fsp--;

					stream_groupGraphPatternSubCache.add(groupGraphPatternSubCache313.getTree());
					}
					break;

				default :
					break loop97;
				}
			}

			// AST REWRITE
			// elements: triplesBlock, groupGraphPatternSubCache
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 597:52: -> ( triplesBlock )? ( groupGraphPatternSubCache )*
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:597:55: ( triplesBlock )?
				if ( stream_triplesBlock.hasNext() ) {
					adaptor.addChild(root_0, stream_triplesBlock.nextTree());
				}
				stream_triplesBlock.reset();

				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:597:69: ( groupGraphPatternSubCache )*
				while ( stream_groupGraphPatternSubCache.hasNext() ) {
					adaptor.addChild(root_0, stream_groupGraphPatternSubCache.nextTree());
				}
				stream_groupGraphPatternSubCache.reset();

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "groupGraphPatternSub"


	public static class groupGraphPatternSubCache_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "groupGraphPatternSubCache"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:600:1: groupGraphPatternSubCache : graphPatternNotTriples ( DOT )? ( triplesBlock )? -> graphPatternNotTriples ( triplesBlock )? ;
	public final SparqlifyConfigParser.groupGraphPatternSubCache_return groupGraphPatternSubCache() throws RecognitionException {
		SparqlifyConfigParser.groupGraphPatternSubCache_return retval = new SparqlifyConfigParser.groupGraphPatternSubCache_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token DOT315=null;
		ParserRuleReturnScope graphPatternNotTriples314 =null;
		ParserRuleReturnScope triplesBlock316 =null;

		CommonTree DOT315_tree=null;
		RewriteRuleTokenStream stream_DOT=new RewriteRuleTokenStream(adaptor,"token DOT");
		RewriteRuleSubtreeStream stream_triplesBlock=new RewriteRuleSubtreeStream(adaptor,"rule triplesBlock");
		RewriteRuleSubtreeStream stream_graphPatternNotTriples=new RewriteRuleSubtreeStream(adaptor,"rule graphPatternNotTriples");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:601:5: ( graphPatternNotTriples ( DOT )? ( triplesBlock )? -> graphPatternNotTriples ( triplesBlock )? )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:601:8: graphPatternNotTriples ( DOT )? ( triplesBlock )?
			{
			pushFollow(FOLLOW_graphPatternNotTriples_in_groupGraphPatternSubCache3796);
			graphPatternNotTriples314=graphPatternNotTriples();
			state._fsp--;

			stream_graphPatternNotTriples.add(graphPatternNotTriples314.getTree());
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:601:31: ( DOT )?
			int alt98=2;
			int LA98_0 = input.LA(1);
			if ( (LA98_0==DOT) ) {
				alt98=1;
			}
			switch (alt98) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:601:31: DOT
					{
					DOT315=(Token)match(input,DOT,FOLLOW_DOT_in_groupGraphPatternSubCache3798);  
					stream_DOT.add(DOT315);

					}
					break;

			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:601:36: ( triplesBlock )?
			int alt99=2;
			int LA99_0 = input.LA(1);
			if ( (LA99_0==BLANK_NODE_LABEL||(LA99_0 >= DECIMAL && LA99_0 <= DECIMAL_POSITIVE)||(LA99_0 >= DOUBLE && LA99_0 <= DOUBLE_POSITIVE)||LA99_0==FALSE||(LA99_0 >= INTEGER && LA99_0 <= INTEGER_POSITIVE)||LA99_0==IRI_REF||LA99_0==OPEN_BRACE||LA99_0==OPEN_SQUARE_BRACKET||(LA99_0 >= PNAME_LN && LA99_0 <= PNAME_NS)||(LA99_0 >= STRING_LITERAL1 && LA99_0 <= STRING_LITERAL_LONG2)||LA99_0==TRUE||(LA99_0 >= VAR1 && LA99_0 <= VAR3)) ) {
				alt99=1;
			}
			switch (alt99) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:601:36: triplesBlock
					{
					pushFollow(FOLLOW_triplesBlock_in_groupGraphPatternSubCache3801);
					triplesBlock316=triplesBlock();
					state._fsp--;

					stream_triplesBlock.add(triplesBlock316.getTree());
					}
					break;

			}

			// AST REWRITE
			// elements: triplesBlock, graphPatternNotTriples
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 601:50: -> graphPatternNotTriples ( triplesBlock )?
			{
				adaptor.addChild(root_0, stream_graphPatternNotTriples.nextTree());
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:601:76: ( triplesBlock )?
				if ( stream_triplesBlock.hasNext() ) {
					adaptor.addChild(root_0, stream_triplesBlock.nextTree());
				}
				stream_triplesBlock.reset();

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "groupGraphPatternSubCache"


	public static class triplesBlock_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "triplesBlock"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:604:1: triplesBlock : triplesSameSubjectPath ( DOT triplesSameSubjectPath )* ( DOT )? -> ^( TRIPLES_BLOCK ( triplesSameSubjectPath )+ ) ;
	public final SparqlifyConfigParser.triplesBlock_return triplesBlock() throws RecognitionException {
		SparqlifyConfigParser.triplesBlock_return retval = new SparqlifyConfigParser.triplesBlock_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token DOT318=null;
		Token DOT320=null;
		ParserRuleReturnScope triplesSameSubjectPath317 =null;
		ParserRuleReturnScope triplesSameSubjectPath319 =null;

		CommonTree DOT318_tree=null;
		CommonTree DOT320_tree=null;
		RewriteRuleTokenStream stream_DOT=new RewriteRuleTokenStream(adaptor,"token DOT");
		RewriteRuleSubtreeStream stream_triplesSameSubjectPath=new RewriteRuleSubtreeStream(adaptor,"rule triplesSameSubjectPath");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:605:5: ( triplesSameSubjectPath ( DOT triplesSameSubjectPath )* ( DOT )? -> ^( TRIPLES_BLOCK ( triplesSameSubjectPath )+ ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:605:7: triplesSameSubjectPath ( DOT triplesSameSubjectPath )* ( DOT )?
			{
			pushFollow(FOLLOW_triplesSameSubjectPath_in_triplesBlock3828);
			triplesSameSubjectPath317=triplesSameSubjectPath();
			state._fsp--;

			stream_triplesSameSubjectPath.add(triplesSameSubjectPath317.getTree());
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:605:30: ( DOT triplesSameSubjectPath )*
			loop100:
			while (true) {
				int alt100=2;
				int LA100_0 = input.LA(1);
				if ( (LA100_0==DOT) ) {
					int LA100_1 = input.LA(2);
					if ( (LA100_1==BLANK_NODE_LABEL||(LA100_1 >= DECIMAL && LA100_1 <= DECIMAL_POSITIVE)||(LA100_1 >= DOUBLE && LA100_1 <= DOUBLE_POSITIVE)||LA100_1==FALSE||(LA100_1 >= INTEGER && LA100_1 <= INTEGER_POSITIVE)||LA100_1==IRI_REF||LA100_1==OPEN_BRACE||LA100_1==OPEN_SQUARE_BRACKET||(LA100_1 >= PNAME_LN && LA100_1 <= PNAME_NS)||(LA100_1 >= STRING_LITERAL1 && LA100_1 <= STRING_LITERAL_LONG2)||LA100_1==TRUE||(LA100_1 >= VAR1 && LA100_1 <= VAR3)) ) {
						alt100=1;
					}

				}

				switch (alt100) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:605:32: DOT triplesSameSubjectPath
					{
					DOT318=(Token)match(input,DOT,FOLLOW_DOT_in_triplesBlock3832);  
					stream_DOT.add(DOT318);

					pushFollow(FOLLOW_triplesSameSubjectPath_in_triplesBlock3834);
					triplesSameSubjectPath319=triplesSameSubjectPath();
					state._fsp--;

					stream_triplesSameSubjectPath.add(triplesSameSubjectPath319.getTree());
					}
					break;

				default :
					break loop100;
				}
			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:605:61: ( DOT )?
			int alt101=2;
			int LA101_0 = input.LA(1);
			if ( (LA101_0==DOT) ) {
				alt101=1;
			}
			switch (alt101) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:605:61: DOT
					{
					DOT320=(Token)match(input,DOT,FOLLOW_DOT_in_triplesBlock3838);  
					stream_DOT.add(DOT320);

					}
					break;

			}

			// AST REWRITE
			// elements: triplesSameSubjectPath
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 605:66: -> ^( TRIPLES_BLOCK ( triplesSameSubjectPath )+ )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:605:69: ^( TRIPLES_BLOCK ( triplesSameSubjectPath )+ )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(TRIPLES_BLOCK, "TRIPLES_BLOCK"), root_1);
				if ( !(stream_triplesSameSubjectPath.hasNext()) ) {
					throw new RewriteEarlyExitException();
				}
				while ( stream_triplesSameSubjectPath.hasNext() ) {
					adaptor.addChild(root_1, stream_triplesSameSubjectPath.nextTree());
				}
				stream_triplesSameSubjectPath.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "triplesBlock"


	public static class graphPatternNotTriples_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "graphPatternNotTriples"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:608:1: graphPatternNotTriples : ( groupOrUnionGraphPattern | optionalGraphPattern | minusGraphPattern | graphGraphPattern | serviceGraphPattern | filter | bind );
	public final SparqlifyConfigParser.graphPatternNotTriples_return graphPatternNotTriples() throws RecognitionException {
		SparqlifyConfigParser.graphPatternNotTriples_return retval = new SparqlifyConfigParser.graphPatternNotTriples_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		ParserRuleReturnScope groupOrUnionGraphPattern321 =null;
		ParserRuleReturnScope optionalGraphPattern322 =null;
		ParserRuleReturnScope minusGraphPattern323 =null;
		ParserRuleReturnScope graphGraphPattern324 =null;
		ParserRuleReturnScope serviceGraphPattern325 =null;
		ParserRuleReturnScope filter326 =null;
		ParserRuleReturnScope bind327 =null;


		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:609:5: ( groupOrUnionGraphPattern | optionalGraphPattern | minusGraphPattern | graphGraphPattern | serviceGraphPattern | filter | bind )
			int alt102=7;
			switch ( input.LA(1) ) {
			case OPEN_CURLY_BRACE:
				{
				alt102=1;
				}
				break;
			case OPTIONAL:
				{
				alt102=2;
				}
				break;
			case MINUS_KEYWORD:
				{
				alt102=3;
				}
				break;
			case GRAPH:
				{
				alt102=4;
				}
				break;
			case SERVICE:
				{
				alt102=5;
				}
				break;
			case FILTER:
				{
				alt102=6;
				}
				break;
			case BIND:
				{
				alt102=7;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 102, 0, input);
				throw nvae;
			}
			switch (alt102) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:609:7: groupOrUnionGraphPattern
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_groupOrUnionGraphPattern_in_graphPatternNotTriples3865);
					groupOrUnionGraphPattern321=groupOrUnionGraphPattern();
					state._fsp--;

					adaptor.addChild(root_0, groupOrUnionGraphPattern321.getTree());

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:609:34: optionalGraphPattern
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_optionalGraphPattern_in_graphPatternNotTriples3869);
					optionalGraphPattern322=optionalGraphPattern();
					state._fsp--;

					adaptor.addChild(root_0, optionalGraphPattern322.getTree());

					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:609:57: minusGraphPattern
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_minusGraphPattern_in_graphPatternNotTriples3873);
					minusGraphPattern323=minusGraphPattern();
					state._fsp--;

					adaptor.addChild(root_0, minusGraphPattern323.getTree());

					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:609:77: graphGraphPattern
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_graphGraphPattern_in_graphPatternNotTriples3877);
					graphGraphPattern324=graphGraphPattern();
					state._fsp--;

					adaptor.addChild(root_0, graphGraphPattern324.getTree());

					}
					break;
				case 5 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:609:97: serviceGraphPattern
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_serviceGraphPattern_in_graphPatternNotTriples3881);
					serviceGraphPattern325=serviceGraphPattern();
					state._fsp--;

					adaptor.addChild(root_0, serviceGraphPattern325.getTree());

					}
					break;
				case 6 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:609:119: filter
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_filter_in_graphPatternNotTriples3885);
					filter326=filter();
					state._fsp--;

					adaptor.addChild(root_0, filter326.getTree());

					}
					break;
				case 7 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:609:128: bind
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_bind_in_graphPatternNotTriples3889);
					bind327=bind();
					state._fsp--;

					adaptor.addChild(root_0, bind327.getTree());

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "graphPatternNotTriples"


	public static class optionalGraphPattern_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "optionalGraphPattern"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:612:1: optionalGraphPattern : OPTIONAL groupGraphPattern -> ^( OPTIONAL groupGraphPattern ) ;
	public final SparqlifyConfigParser.optionalGraphPattern_return optionalGraphPattern() throws RecognitionException {
		SparqlifyConfigParser.optionalGraphPattern_return retval = new SparqlifyConfigParser.optionalGraphPattern_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token OPTIONAL328=null;
		ParserRuleReturnScope groupGraphPattern329 =null;

		CommonTree OPTIONAL328_tree=null;
		RewriteRuleTokenStream stream_OPTIONAL=new RewriteRuleTokenStream(adaptor,"token OPTIONAL");
		RewriteRuleSubtreeStream stream_groupGraphPattern=new RewriteRuleSubtreeStream(adaptor,"rule groupGraphPattern");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:613:5: ( OPTIONAL groupGraphPattern -> ^( OPTIONAL groupGraphPattern ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:613:7: OPTIONAL groupGraphPattern
			{
			OPTIONAL328=(Token)match(input,OPTIONAL,FOLLOW_OPTIONAL_in_optionalGraphPattern3906);  
			stream_OPTIONAL.add(OPTIONAL328);

			pushFollow(FOLLOW_groupGraphPattern_in_optionalGraphPattern3908);
			groupGraphPattern329=groupGraphPattern();
			state._fsp--;

			stream_groupGraphPattern.add(groupGraphPattern329.getTree());
			// AST REWRITE
			// elements: OPTIONAL, groupGraphPattern
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 613:34: -> ^( OPTIONAL groupGraphPattern )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:613:37: ^( OPTIONAL groupGraphPattern )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot(stream_OPTIONAL.nextNode(), root_1);
				adaptor.addChild(root_1, stream_groupGraphPattern.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "optionalGraphPattern"


	public static class graphGraphPattern_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "graphGraphPattern"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:616:1: graphGraphPattern : GRAPH varOrIRIref groupGraphPattern -> ^( GRAPH varOrIRIref groupGraphPattern ) ;
	public final SparqlifyConfigParser.graphGraphPattern_return graphGraphPattern() throws RecognitionException {
		SparqlifyConfigParser.graphGraphPattern_return retval = new SparqlifyConfigParser.graphGraphPattern_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token GRAPH330=null;
		ParserRuleReturnScope varOrIRIref331 =null;
		ParserRuleReturnScope groupGraphPattern332 =null;

		CommonTree GRAPH330_tree=null;
		RewriteRuleTokenStream stream_GRAPH=new RewriteRuleTokenStream(adaptor,"token GRAPH");
		RewriteRuleSubtreeStream stream_varOrIRIref=new RewriteRuleSubtreeStream(adaptor,"rule varOrIRIref");
		RewriteRuleSubtreeStream stream_groupGraphPattern=new RewriteRuleSubtreeStream(adaptor,"rule groupGraphPattern");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:617:5: ( GRAPH varOrIRIref groupGraphPattern -> ^( GRAPH varOrIRIref groupGraphPattern ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:617:7: GRAPH varOrIRIref groupGraphPattern
			{
			GRAPH330=(Token)match(input,GRAPH,FOLLOW_GRAPH_in_graphGraphPattern3933);  
			stream_GRAPH.add(GRAPH330);

			pushFollow(FOLLOW_varOrIRIref_in_graphGraphPattern3935);
			varOrIRIref331=varOrIRIref();
			state._fsp--;

			stream_varOrIRIref.add(varOrIRIref331.getTree());
			pushFollow(FOLLOW_groupGraphPattern_in_graphGraphPattern3937);
			groupGraphPattern332=groupGraphPattern();
			state._fsp--;

			stream_groupGraphPattern.add(groupGraphPattern332.getTree());
			// AST REWRITE
			// elements: GRAPH, varOrIRIref, groupGraphPattern
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 617:43: -> ^( GRAPH varOrIRIref groupGraphPattern )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:617:46: ^( GRAPH varOrIRIref groupGraphPattern )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot(stream_GRAPH.nextNode(), root_1);
				adaptor.addChild(root_1, stream_varOrIRIref.nextTree());
				adaptor.addChild(root_1, stream_groupGraphPattern.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "graphGraphPattern"


	public static class serviceGraphPattern_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "serviceGraphPattern"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:620:1: serviceGraphPattern : SERVICE ( SILENT )? varOrIRIref groupGraphPattern -> ^( SERVICE ( SILENT )? varOrIRIref groupGraphPattern ) ;
	public final SparqlifyConfigParser.serviceGraphPattern_return serviceGraphPattern() throws RecognitionException {
		SparqlifyConfigParser.serviceGraphPattern_return retval = new SparqlifyConfigParser.serviceGraphPattern_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token SERVICE333=null;
		Token SILENT334=null;
		ParserRuleReturnScope varOrIRIref335 =null;
		ParserRuleReturnScope groupGraphPattern336 =null;

		CommonTree SERVICE333_tree=null;
		CommonTree SILENT334_tree=null;
		RewriteRuleTokenStream stream_SILENT=new RewriteRuleTokenStream(adaptor,"token SILENT");
		RewriteRuleTokenStream stream_SERVICE=new RewriteRuleTokenStream(adaptor,"token SERVICE");
		RewriteRuleSubtreeStream stream_varOrIRIref=new RewriteRuleSubtreeStream(adaptor,"rule varOrIRIref");
		RewriteRuleSubtreeStream stream_groupGraphPattern=new RewriteRuleSubtreeStream(adaptor,"rule groupGraphPattern");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:621:5: ( SERVICE ( SILENT )? varOrIRIref groupGraphPattern -> ^( SERVICE ( SILENT )? varOrIRIref groupGraphPattern ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:621:7: SERVICE ( SILENT )? varOrIRIref groupGraphPattern
			{
			SERVICE333=(Token)match(input,SERVICE,FOLLOW_SERVICE_in_serviceGraphPattern3964);  
			stream_SERVICE.add(SERVICE333);

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:621:15: ( SILENT )?
			int alt103=2;
			int LA103_0 = input.LA(1);
			if ( (LA103_0==SILENT) ) {
				alt103=1;
			}
			switch (alt103) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:621:15: SILENT
					{
					SILENT334=(Token)match(input,SILENT,FOLLOW_SILENT_in_serviceGraphPattern3966);  
					stream_SILENT.add(SILENT334);

					}
					break;

			}

			pushFollow(FOLLOW_varOrIRIref_in_serviceGraphPattern3969);
			varOrIRIref335=varOrIRIref();
			state._fsp--;

			stream_varOrIRIref.add(varOrIRIref335.getTree());
			pushFollow(FOLLOW_groupGraphPattern_in_serviceGraphPattern3971);
			groupGraphPattern336=groupGraphPattern();
			state._fsp--;

			stream_groupGraphPattern.add(groupGraphPattern336.getTree());
			// AST REWRITE
			// elements: varOrIRIref, groupGraphPattern, SERVICE, SILENT
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 621:53: -> ^( SERVICE ( SILENT )? varOrIRIref groupGraphPattern )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:621:56: ^( SERVICE ( SILENT )? varOrIRIref groupGraphPattern )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot(stream_SERVICE.nextNode(), root_1);
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:621:66: ( SILENT )?
				if ( stream_SILENT.hasNext() ) {
					adaptor.addChild(root_1, stream_SILENT.nextNode());
				}
				stream_SILENT.reset();

				adaptor.addChild(root_1, stream_varOrIRIref.nextTree());
				adaptor.addChild(root_1, stream_groupGraphPattern.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "serviceGraphPattern"


	public static class bind_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "bind"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:624:1: bind : BIND OPEN_BRACE expression AS var CLOSE_BRACE -> ^( BIND expression ^( AS var ) ) ;
	public final SparqlifyConfigParser.bind_return bind() throws RecognitionException {
		SparqlifyConfigParser.bind_return retval = new SparqlifyConfigParser.bind_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token BIND337=null;
		Token OPEN_BRACE338=null;
		Token AS340=null;
		Token CLOSE_BRACE342=null;
		ParserRuleReturnScope expression339 =null;
		ParserRuleReturnScope var341 =null;

		CommonTree BIND337_tree=null;
		CommonTree OPEN_BRACE338_tree=null;
		CommonTree AS340_tree=null;
		CommonTree CLOSE_BRACE342_tree=null;
		RewriteRuleTokenStream stream_AS=new RewriteRuleTokenStream(adaptor,"token AS");
		RewriteRuleTokenStream stream_CLOSE_BRACE=new RewriteRuleTokenStream(adaptor,"token CLOSE_BRACE");
		RewriteRuleTokenStream stream_BIND=new RewriteRuleTokenStream(adaptor,"token BIND");
		RewriteRuleTokenStream stream_OPEN_BRACE=new RewriteRuleTokenStream(adaptor,"token OPEN_BRACE");
		RewriteRuleSubtreeStream stream_expression=new RewriteRuleSubtreeStream(adaptor,"rule expression");
		RewriteRuleSubtreeStream stream_var=new RewriteRuleSubtreeStream(adaptor,"rule var");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:625:5: ( BIND OPEN_BRACE expression AS var CLOSE_BRACE -> ^( BIND expression ^( AS var ) ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:625:7: BIND OPEN_BRACE expression AS var CLOSE_BRACE
			{
			BIND337=(Token)match(input,BIND,FOLLOW_BIND_in_bind4005);  
			stream_BIND.add(BIND337);

			OPEN_BRACE338=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_bind4007);  
			stream_OPEN_BRACE.add(OPEN_BRACE338);

			pushFollow(FOLLOW_expression_in_bind4009);
			expression339=expression();
			state._fsp--;

			stream_expression.add(expression339.getTree());
			AS340=(Token)match(input,AS,FOLLOW_AS_in_bind4011);  
			stream_AS.add(AS340);

			pushFollow(FOLLOW_var_in_bind4013);
			var341=var();
			state._fsp--;

			stream_var.add(var341.getTree());
			CLOSE_BRACE342=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_bind4015);  
			stream_CLOSE_BRACE.add(CLOSE_BRACE342);

			// AST REWRITE
			// elements: BIND, var, AS, expression
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 625:53: -> ^( BIND expression ^( AS var ) )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:625:56: ^( BIND expression ^( AS var ) )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot(stream_BIND.nextNode(), root_1);
				adaptor.addChild(root_1, stream_expression.nextTree());
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:625:74: ^( AS var )
				{
				CommonTree root_2 = (CommonTree)adaptor.nil();
				root_2 = (CommonTree)adaptor.becomeRoot(stream_AS.nextNode(), root_2);
				adaptor.addChild(root_2, stream_var.nextTree());
				adaptor.addChild(root_1, root_2);
				}

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "bind"


	public static class minusGraphPattern_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "minusGraphPattern"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:628:1: minusGraphPattern : MINUS_KEYWORD groupGraphPattern -> ^( MINUS_KEYWORD groupGraphPattern ) ;
	public final SparqlifyConfigParser.minusGraphPattern_return minusGraphPattern() throws RecognitionException {
		SparqlifyConfigParser.minusGraphPattern_return retval = new SparqlifyConfigParser.minusGraphPattern_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token MINUS_KEYWORD343=null;
		ParserRuleReturnScope groupGraphPattern344 =null;

		CommonTree MINUS_KEYWORD343_tree=null;
		RewriteRuleTokenStream stream_MINUS_KEYWORD=new RewriteRuleTokenStream(adaptor,"token MINUS_KEYWORD");
		RewriteRuleSubtreeStream stream_groupGraphPattern=new RewriteRuleSubtreeStream(adaptor,"rule groupGraphPattern");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:629:5: ( MINUS_KEYWORD groupGraphPattern -> ^( MINUS_KEYWORD groupGraphPattern ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:629:7: MINUS_KEYWORD groupGraphPattern
			{
			MINUS_KEYWORD343=(Token)match(input,MINUS_KEYWORD,FOLLOW_MINUS_KEYWORD_in_minusGraphPattern4052);  
			stream_MINUS_KEYWORD.add(MINUS_KEYWORD343);

			pushFollow(FOLLOW_groupGraphPattern_in_minusGraphPattern4054);
			groupGraphPattern344=groupGraphPattern();
			state._fsp--;

			stream_groupGraphPattern.add(groupGraphPattern344.getTree());
			// AST REWRITE
			// elements: MINUS_KEYWORD, groupGraphPattern
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 629:39: -> ^( MINUS_KEYWORD groupGraphPattern )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:629:42: ^( MINUS_KEYWORD groupGraphPattern )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot(stream_MINUS_KEYWORD.nextNode(), root_1);
				adaptor.addChild(root_1, stream_groupGraphPattern.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "minusGraphPattern"


	public static class groupOrUnionGraphPattern_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "groupOrUnionGraphPattern"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:632:1: groupOrUnionGraphPattern : (g1= groupGraphPattern -> $g1) ( ( UNION g2= groupGraphPattern ) -> ^( UNION $groupOrUnionGraphPattern $g2) )* ;
	public final SparqlifyConfigParser.groupOrUnionGraphPattern_return groupOrUnionGraphPattern() throws RecognitionException {
		SparqlifyConfigParser.groupOrUnionGraphPattern_return retval = new SparqlifyConfigParser.groupOrUnionGraphPattern_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token UNION345=null;
		ParserRuleReturnScope g1 =null;
		ParserRuleReturnScope g2 =null;

		CommonTree UNION345_tree=null;
		RewriteRuleTokenStream stream_UNION=new RewriteRuleTokenStream(adaptor,"token UNION");
		RewriteRuleSubtreeStream stream_groupGraphPattern=new RewriteRuleSubtreeStream(adaptor,"rule groupGraphPattern");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:633:5: ( (g1= groupGraphPattern -> $g1) ( ( UNION g2= groupGraphPattern ) -> ^( UNION $groupOrUnionGraphPattern $g2) )* )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:633:7: (g1= groupGraphPattern -> $g1) ( ( UNION g2= groupGraphPattern ) -> ^( UNION $groupOrUnionGraphPattern $g2) )*
			{
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:633:7: (g1= groupGraphPattern -> $g1)
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:633:8: g1= groupGraphPattern
			{
			pushFollow(FOLLOW_groupGraphPattern_in_groupOrUnionGraphPattern4082);
			g1=groupGraphPattern();
			state._fsp--;

			stream_groupGraphPattern.add(g1.getTree());
			// AST REWRITE
			// elements: g1
			// token labels: 
			// rule labels: retval, g1
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);
			RewriteRuleSubtreeStream stream_g1=new RewriteRuleSubtreeStream(adaptor,"rule g1",g1!=null?g1.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 633:28: -> $g1
			{
				adaptor.addChild(root_0, stream_g1.nextTree());
			}


			retval.tree = root_0;

			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:633:35: ( ( UNION g2= groupGraphPattern ) -> ^( UNION $groupOrUnionGraphPattern $g2) )*
			loop104:
			while (true) {
				int alt104=2;
				int LA104_0 = input.LA(1);
				if ( (LA104_0==UNION) ) {
					alt104=1;
				}

				switch (alt104) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:633:36: ( UNION g2= groupGraphPattern )
					{
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:633:36: ( UNION g2= groupGraphPattern )
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:633:37: UNION g2= groupGraphPattern
					{
					UNION345=(Token)match(input,UNION,FOLLOW_UNION_in_groupOrUnionGraphPattern4090);  
					stream_UNION.add(UNION345);

					pushFollow(FOLLOW_groupGraphPattern_in_groupOrUnionGraphPattern4094);
					g2=groupGraphPattern();
					state._fsp--;

					stream_groupGraphPattern.add(g2.getTree());
					}

					// AST REWRITE
					// elements: groupOrUnionGraphPattern, g2, UNION
					// token labels: 
					// rule labels: retval, g2
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);
					RewriteRuleSubtreeStream stream_g2=new RewriteRuleSubtreeStream(adaptor,"rule g2",g2!=null?g2.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 633:65: -> ^( UNION $groupOrUnionGraphPattern $g2)
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:633:68: ^( UNION $groupOrUnionGraphPattern $g2)
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_UNION.nextNode(), root_1);
						adaptor.addChild(root_1, stream_retval.nextTree());
						adaptor.addChild(root_1, stream_g2.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;

				default :
					break loop104;
				}
			}

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "groupOrUnionGraphPattern"


	public static class filter_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "filter"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:636:1: filter : FILTER constraint -> ^( FILTER constraint ) ;
	public final SparqlifyConfigParser.filter_return filter() throws RecognitionException {
		SparqlifyConfigParser.filter_return retval = new SparqlifyConfigParser.filter_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token FILTER346=null;
		ParserRuleReturnScope constraint347 =null;

		CommonTree FILTER346_tree=null;
		RewriteRuleTokenStream stream_FILTER=new RewriteRuleTokenStream(adaptor,"token FILTER");
		RewriteRuleSubtreeStream stream_constraint=new RewriteRuleSubtreeStream(adaptor,"rule constraint");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:637:5: ( FILTER constraint -> ^( FILTER constraint ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:637:7: FILTER constraint
			{
			FILTER346=(Token)match(input,FILTER,FOLLOW_FILTER_in_filter4126);  
			stream_FILTER.add(FILTER346);

			pushFollow(FOLLOW_constraint_in_filter4128);
			constraint347=constraint();
			state._fsp--;

			stream_constraint.add(constraint347.getTree());
			// AST REWRITE
			// elements: constraint, FILTER
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 637:25: -> ^( FILTER constraint )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:637:28: ^( FILTER constraint )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot(stream_FILTER.nextNode(), root_1);
				adaptor.addChild(root_1, stream_constraint.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "filter"


	public static class constraint_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "constraint"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:640:1: constraint : ( brackettedExpression | builtInCall | functionCall );
	public final SparqlifyConfigParser.constraint_return constraint() throws RecognitionException {
		SparqlifyConfigParser.constraint_return retval = new SparqlifyConfigParser.constraint_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		ParserRuleReturnScope brackettedExpression348 =null;
		ParserRuleReturnScope builtInCall349 =null;
		ParserRuleReturnScope functionCall350 =null;


		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:641:5: ( brackettedExpression | builtInCall | functionCall )
			int alt105=3;
			switch ( input.LA(1) ) {
			case OPEN_BRACE:
				{
				alt105=1;
				}
				break;
			case ABS:
			case BNODE:
			case BOUND:
			case CEIL:
			case COALESCE:
			case CONCAT:
			case CONTAINS:
			case DATATYPE:
			case DAY:
			case ENCODE_FOR_URI:
			case EXISTS:
			case FLOOR:
			case HOURS:
			case IF:
			case IRI:
			case ISBLANK:
			case ISIRI:
			case ISLITERAL:
			case ISNUMERIC:
			case ISURI:
			case LANG:
			case LANGMATCHES:
			case LCASE:
			case MD5:
			case MINUTES:
			case MONTH:
			case NOT:
			case NOW:
			case RAND:
			case REGEX:
			case ROUND:
			case SAMETERM:
			case SECONDS:
			case SHA1:
			case SHA224:
			case SHA256:
			case SHA384:
			case SHA512:
			case STR:
			case STRDT:
			case STRENDS:
			case STRLANG:
			case STRLEN:
			case STRSTARTS:
			case SUBSTR:
			case TIMEZONE:
			case TZ:
			case UCASE:
			case URI:
			case YEAR:
				{
				alt105=2;
				}
				break;
			case IRI_REF:
			case PNAME_LN:
			case PNAME_NS:
				{
				alt105=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 105, 0, input);
				throw nvae;
			}
			switch (alt105) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:641:7: brackettedExpression
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_brackettedExpression_in_constraint4153);
					brackettedExpression348=brackettedExpression();
					state._fsp--;

					adaptor.addChild(root_0, brackettedExpression348.getTree());

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:642:7: builtInCall
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_builtInCall_in_constraint4161);
					builtInCall349=builtInCall();
					state._fsp--;

					adaptor.addChild(root_0, builtInCall349.getTree());

					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:643:7: functionCall
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_functionCall_in_constraint4169);
					functionCall350=functionCall();
					state._fsp--;

					adaptor.addChild(root_0, functionCall350.getTree());

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "constraint"


	public static class functionCall_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "functionCall"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:646:1: functionCall : iriRef argList -> ^( FUNCTION iriRef ^( ARG_LIST argList ) ) ;
	public final SparqlifyConfigParser.functionCall_return functionCall() throws RecognitionException {
		SparqlifyConfigParser.functionCall_return retval = new SparqlifyConfigParser.functionCall_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		ParserRuleReturnScope iriRef351 =null;
		ParserRuleReturnScope argList352 =null;

		RewriteRuleSubtreeStream stream_argList=new RewriteRuleSubtreeStream(adaptor,"rule argList");
		RewriteRuleSubtreeStream stream_iriRef=new RewriteRuleSubtreeStream(adaptor,"rule iriRef");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:647:5: ( iriRef argList -> ^( FUNCTION iriRef ^( ARG_LIST argList ) ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:647:7: iriRef argList
			{
			pushFollow(FOLLOW_iriRef_in_functionCall4186);
			iriRef351=iriRef();
			state._fsp--;

			stream_iriRef.add(iriRef351.getTree());
			pushFollow(FOLLOW_argList_in_functionCall4188);
			argList352=argList();
			state._fsp--;

			stream_argList.add(argList352.getTree());
			// AST REWRITE
			// elements: iriRef, argList
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 647:22: -> ^( FUNCTION iriRef ^( ARG_LIST argList ) )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:647:25: ^( FUNCTION iriRef ^( ARG_LIST argList ) )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(FUNCTION, "FUNCTION"), root_1);
				adaptor.addChild(root_1, stream_iriRef.nextTree());
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:647:43: ^( ARG_LIST argList )
				{
				CommonTree root_2 = (CommonTree)adaptor.nil();
				root_2 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(ARG_LIST, "ARG_LIST"), root_2);
				adaptor.addChild(root_2, stream_argList.nextTree());
				adaptor.addChild(root_1, root_2);
				}

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "functionCall"


	public static class argList_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "argList"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:650:1: argList : ( nil -> nil | OPEN_BRACE ( DISTINCT )? expression ( COMMA expression )* CLOSE_BRACE -> ( DISTINCT )? ( expression )* );
	public final SparqlifyConfigParser.argList_return argList() throws RecognitionException {
		SparqlifyConfigParser.argList_return retval = new SparqlifyConfigParser.argList_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token OPEN_BRACE354=null;
		Token DISTINCT355=null;
		Token COMMA357=null;
		Token CLOSE_BRACE359=null;
		ParserRuleReturnScope nil353 =null;
		ParserRuleReturnScope expression356 =null;
		ParserRuleReturnScope expression358 =null;

		CommonTree OPEN_BRACE354_tree=null;
		CommonTree DISTINCT355_tree=null;
		CommonTree COMMA357_tree=null;
		CommonTree CLOSE_BRACE359_tree=null;
		RewriteRuleTokenStream stream_CLOSE_BRACE=new RewriteRuleTokenStream(adaptor,"token CLOSE_BRACE");
		RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
		RewriteRuleTokenStream stream_OPEN_BRACE=new RewriteRuleTokenStream(adaptor,"token OPEN_BRACE");
		RewriteRuleTokenStream stream_DISTINCT=new RewriteRuleTokenStream(adaptor,"token DISTINCT");
		RewriteRuleSubtreeStream stream_expression=new RewriteRuleSubtreeStream(adaptor,"rule expression");
		RewriteRuleSubtreeStream stream_nil=new RewriteRuleSubtreeStream(adaptor,"rule nil");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:651:5: ( nil -> nil | OPEN_BRACE ( DISTINCT )? expression ( COMMA expression )* CLOSE_BRACE -> ( DISTINCT )? ( expression )* )
			int alt108=2;
			int LA108_0 = input.LA(1);
			if ( (LA108_0==OPEN_BRACE) ) {
				int LA108_1 = input.LA(2);
				if ( (LA108_1==CLOSE_BRACE) ) {
					alt108=1;
				}
				else if ( (LA108_1==ABS||LA108_1==AVG||(LA108_1 >= BNODE && LA108_1 <= BOUND)||LA108_1==CEIL||LA108_1==COALESCE||LA108_1==CONCAT||LA108_1==CONTAINS||LA108_1==COUNT||(LA108_1 >= DATATYPE && LA108_1 <= DECIMAL_POSITIVE)||LA108_1==DISTINCT||(LA108_1 >= DOUBLE && LA108_1 <= DOUBLE_POSITIVE)||LA108_1==ENCODE_FOR_URI||LA108_1==EXISTS||LA108_1==FALSE||LA108_1==FLOOR||LA108_1==GROUP_CONCAT||(LA108_1 >= HOURS && LA108_1 <= IF)||(LA108_1 >= INTEGER && LA108_1 <= INTEGER_POSITIVE)||(LA108_1 >= IRI && LA108_1 <= IRI_REF)||(LA108_1 >= ISBLANK && LA108_1 <= ISURI)||(LA108_1 >= LANG && LA108_1 <= LANGMATCHES)||LA108_1==LCASE||(LA108_1 >= MAX && LA108_1 <= MINUS)||LA108_1==MINUTES||LA108_1==MONTH||LA108_1==NAME||LA108_1==NEGATION||LA108_1==NOT||LA108_1==NOW||LA108_1==OPEN_BRACE||(LA108_1 >= PLUS && LA108_1 <= PNAME_NS)||LA108_1==RAND||LA108_1==REGEX||(LA108_1 >= ROUND && LA108_1 <= SECONDS)||(LA108_1 >= SHA1 && LA108_1 <= SHA512)||(LA108_1 >= STR && LA108_1 <= STRENDS)||(LA108_1 >= STRING_LITERAL1 && LA108_1 <= STRSTARTS)||(LA108_1 >= SUBSTR && LA108_1 <= SUM)||LA108_1==TIMEZONE||LA108_1==TRUE||(LA108_1 >= TZ && LA108_1 <= UCASE)||LA108_1==URI||(LA108_1 >= VAR1 && LA108_1 <= VAR3)||LA108_1==YEAR) ) {
					alt108=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 108, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 108, 0, input);
				throw nvae;
			}

			switch (alt108) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:651:7: nil
					{
					pushFollow(FOLLOW_nil_in_argList4219);
					nil353=nil();
					state._fsp--;

					stream_nil.add(nil353.getTree());
					// AST REWRITE
					// elements: nil
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 651:11: -> nil
					{
						adaptor.addChild(root_0, stream_nil.nextTree());
					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:652:7: OPEN_BRACE ( DISTINCT )? expression ( COMMA expression )* CLOSE_BRACE
					{
					OPEN_BRACE354=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_argList4231);  
					stream_OPEN_BRACE.add(OPEN_BRACE354);

					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:652:18: ( DISTINCT )?
					int alt106=2;
					int LA106_0 = input.LA(1);
					if ( (LA106_0==DISTINCT) ) {
						alt106=1;
					}
					switch (alt106) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:652:18: DISTINCT
							{
							DISTINCT355=(Token)match(input,DISTINCT,FOLLOW_DISTINCT_in_argList4233);  
							stream_DISTINCT.add(DISTINCT355);

							}
							break;

					}

					pushFollow(FOLLOW_expression_in_argList4236);
					expression356=expression();
					state._fsp--;

					stream_expression.add(expression356.getTree());
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:652:39: ( COMMA expression )*
					loop107:
					while (true) {
						int alt107=2;
						int LA107_0 = input.LA(1);
						if ( (LA107_0==COMMA) ) {
							alt107=1;
						}

						switch (alt107) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:652:41: COMMA expression
							{
							COMMA357=(Token)match(input,COMMA,FOLLOW_COMMA_in_argList4240);  
							stream_COMMA.add(COMMA357);

							pushFollow(FOLLOW_expression_in_argList4242);
							expression358=expression();
							state._fsp--;

							stream_expression.add(expression358.getTree());
							}
							break;

						default :
							break loop107;
						}
					}

					CLOSE_BRACE359=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_argList4247);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE359);

					// AST REWRITE
					// elements: DISTINCT, expression
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 652:73: -> ( DISTINCT )? ( expression )*
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:652:76: ( DISTINCT )?
						if ( stream_DISTINCT.hasNext() ) {
							adaptor.addChild(root_0, stream_DISTINCT.nextNode());
						}
						stream_DISTINCT.reset();

						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:652:86: ( expression )*
						while ( stream_expression.hasNext() ) {
							adaptor.addChild(root_0, stream_expression.nextTree());
						}
						stream_expression.reset();

					}


					retval.tree = root_0;

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "argList"


	public static class expressionList_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "expressionList"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:656:1: expressionList : ( nil | OPEN_BRACE expression ( COMMA expression )* CLOSE_BRACE ) -> ^( EXPRESSION_LIST ( nil )* ( expression )* ) ;
	public final SparqlifyConfigParser.expressionList_return expressionList() throws RecognitionException {
		SparqlifyConfigParser.expressionList_return retval = new SparqlifyConfigParser.expressionList_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token OPEN_BRACE361=null;
		Token COMMA363=null;
		Token CLOSE_BRACE365=null;
		ParserRuleReturnScope nil360 =null;
		ParserRuleReturnScope expression362 =null;
		ParserRuleReturnScope expression364 =null;

		CommonTree OPEN_BRACE361_tree=null;
		CommonTree COMMA363_tree=null;
		CommonTree CLOSE_BRACE365_tree=null;
		RewriteRuleTokenStream stream_CLOSE_BRACE=new RewriteRuleTokenStream(adaptor,"token CLOSE_BRACE");
		RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
		RewriteRuleTokenStream stream_OPEN_BRACE=new RewriteRuleTokenStream(adaptor,"token OPEN_BRACE");
		RewriteRuleSubtreeStream stream_expression=new RewriteRuleSubtreeStream(adaptor,"rule expression");
		RewriteRuleSubtreeStream stream_nil=new RewriteRuleSubtreeStream(adaptor,"rule nil");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:657:5: ( ( nil | OPEN_BRACE expression ( COMMA expression )* CLOSE_BRACE ) -> ^( EXPRESSION_LIST ( nil )* ( expression )* ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:657:7: ( nil | OPEN_BRACE expression ( COMMA expression )* CLOSE_BRACE )
			{
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:657:7: ( nil | OPEN_BRACE expression ( COMMA expression )* CLOSE_BRACE )
			int alt110=2;
			int LA110_0 = input.LA(1);
			if ( (LA110_0==OPEN_BRACE) ) {
				int LA110_1 = input.LA(2);
				if ( (LA110_1==CLOSE_BRACE) ) {
					alt110=1;
				}
				else if ( (LA110_1==ABS||LA110_1==AVG||(LA110_1 >= BNODE && LA110_1 <= BOUND)||LA110_1==CEIL||LA110_1==COALESCE||LA110_1==CONCAT||LA110_1==CONTAINS||LA110_1==COUNT||(LA110_1 >= DATATYPE && LA110_1 <= DECIMAL_POSITIVE)||(LA110_1 >= DOUBLE && LA110_1 <= DOUBLE_POSITIVE)||LA110_1==ENCODE_FOR_URI||LA110_1==EXISTS||LA110_1==FALSE||LA110_1==FLOOR||LA110_1==GROUP_CONCAT||(LA110_1 >= HOURS && LA110_1 <= IF)||(LA110_1 >= INTEGER && LA110_1 <= INTEGER_POSITIVE)||(LA110_1 >= IRI && LA110_1 <= IRI_REF)||(LA110_1 >= ISBLANK && LA110_1 <= ISURI)||(LA110_1 >= LANG && LA110_1 <= LANGMATCHES)||LA110_1==LCASE||(LA110_1 >= MAX && LA110_1 <= MINUS)||LA110_1==MINUTES||LA110_1==MONTH||LA110_1==NAME||LA110_1==NEGATION||LA110_1==NOT||LA110_1==NOW||LA110_1==OPEN_BRACE||(LA110_1 >= PLUS && LA110_1 <= PNAME_NS)||LA110_1==RAND||LA110_1==REGEX||(LA110_1 >= ROUND && LA110_1 <= SECONDS)||(LA110_1 >= SHA1 && LA110_1 <= SHA512)||(LA110_1 >= STR && LA110_1 <= STRENDS)||(LA110_1 >= STRING_LITERAL1 && LA110_1 <= STRSTARTS)||(LA110_1 >= SUBSTR && LA110_1 <= SUM)||LA110_1==TIMEZONE||LA110_1==TRUE||(LA110_1 >= TZ && LA110_1 <= UCASE)||LA110_1==URI||(LA110_1 >= VAR1 && LA110_1 <= VAR3)||LA110_1==YEAR) ) {
					alt110=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 110, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 110, 0, input);
				throw nvae;
			}

			switch (alt110) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:657:9: nil
					{
					pushFollow(FOLLOW_nil_in_expressionList4275);
					nil360=nil();
					state._fsp--;

					stream_nil.add(nil360.getTree());
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:657:15: OPEN_BRACE expression ( COMMA expression )* CLOSE_BRACE
					{
					OPEN_BRACE361=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_expressionList4279);  
					stream_OPEN_BRACE.add(OPEN_BRACE361);

					pushFollow(FOLLOW_expression_in_expressionList4281);
					expression362=expression();
					state._fsp--;

					stream_expression.add(expression362.getTree());
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:657:37: ( COMMA expression )*
					loop109:
					while (true) {
						int alt109=2;
						int LA109_0 = input.LA(1);
						if ( (LA109_0==COMMA) ) {
							alt109=1;
						}

						switch (alt109) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:657:39: COMMA expression
							{
							COMMA363=(Token)match(input,COMMA,FOLLOW_COMMA_in_expressionList4285);  
							stream_COMMA.add(COMMA363);

							pushFollow(FOLLOW_expression_in_expressionList4287);
							expression364=expression();
							state._fsp--;

							stream_expression.add(expression364.getTree());
							}
							break;

						default :
							break loop109;
						}
					}

					CLOSE_BRACE365=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_expressionList4292);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE365);

					}
					break;

			}

			// AST REWRITE
			// elements: nil, expression
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 657:73: -> ^( EXPRESSION_LIST ( nil )* ( expression )* )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:657:76: ^( EXPRESSION_LIST ( nil )* ( expression )* )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(EXPRESSION_LIST, "EXPRESSION_LIST"), root_1);
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:657:94: ( nil )*
				while ( stream_nil.hasNext() ) {
					adaptor.addChild(root_1, stream_nil.nextTree());
				}
				stream_nil.reset();

				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:657:99: ( expression )*
				while ( stream_expression.hasNext() ) {
					adaptor.addChild(root_1, stream_expression.nextTree());
				}
				stream_expression.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "expressionList"


	public static class constructTemplateQuads_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "constructTemplateQuads"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:667:1: constructTemplateQuads : quadPattern -> ^( CONSTRUCT_QUADS quadPattern ) ;
	public final SparqlifyConfigParser.constructTemplateQuads_return constructTemplateQuads() throws RecognitionException {
		SparqlifyConfigParser.constructTemplateQuads_return retval = new SparqlifyConfigParser.constructTemplateQuads_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		ParserRuleReturnScope quadPattern366 =null;

		RewriteRuleSubtreeStream stream_quadPattern=new RewriteRuleSubtreeStream(adaptor,"rule quadPattern");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:668:5: ( quadPattern -> ^( CONSTRUCT_QUADS quadPattern ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:668:7: quadPattern
			{
			pushFollow(FOLLOW_quadPattern_in_constructTemplateQuads4328);
			quadPattern366=quadPattern();
			state._fsp--;

			stream_quadPattern.add(quadPattern366.getTree());
			// AST REWRITE
			// elements: quadPattern
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 668:19: -> ^( CONSTRUCT_QUADS quadPattern )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:668:22: ^( CONSTRUCT_QUADS quadPattern )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(CONSTRUCT_QUADS, "CONSTRUCT_QUADS"), root_1);
				adaptor.addChild(root_1, stream_quadPattern.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "constructTemplateQuads"


	public static class constructTemplate_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "constructTemplate"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:672:1: constructTemplate : OPEN_CURLY_BRACE ( constructTriples )? CLOSE_CURLY_BRACE -> ^( CONSTRUCT_TRIPLES ( constructTriples )? ) ;
	public final SparqlifyConfigParser.constructTemplate_return constructTemplate() throws RecognitionException {
		SparqlifyConfigParser.constructTemplate_return retval = new SparqlifyConfigParser.constructTemplate_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token OPEN_CURLY_BRACE367=null;
		Token CLOSE_CURLY_BRACE369=null;
		ParserRuleReturnScope constructTriples368 =null;

		CommonTree OPEN_CURLY_BRACE367_tree=null;
		CommonTree CLOSE_CURLY_BRACE369_tree=null;
		RewriteRuleTokenStream stream_OPEN_CURLY_BRACE=new RewriteRuleTokenStream(adaptor,"token OPEN_CURLY_BRACE");
		RewriteRuleTokenStream stream_CLOSE_CURLY_BRACE=new RewriteRuleTokenStream(adaptor,"token CLOSE_CURLY_BRACE");
		RewriteRuleSubtreeStream stream_constructTriples=new RewriteRuleSubtreeStream(adaptor,"rule constructTriples");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:673:5: ( OPEN_CURLY_BRACE ( constructTriples )? CLOSE_CURLY_BRACE -> ^( CONSTRUCT_TRIPLES ( constructTriples )? ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:673:7: OPEN_CURLY_BRACE ( constructTriples )? CLOSE_CURLY_BRACE
			{
			OPEN_CURLY_BRACE367=(Token)match(input,OPEN_CURLY_BRACE,FOLLOW_OPEN_CURLY_BRACE_in_constructTemplate4354);  
			stream_OPEN_CURLY_BRACE.add(OPEN_CURLY_BRACE367);

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:673:24: ( constructTriples )?
			int alt111=2;
			int LA111_0 = input.LA(1);
			if ( (LA111_0==BLANK_NODE_LABEL||(LA111_0 >= DECIMAL && LA111_0 <= DECIMAL_POSITIVE)||(LA111_0 >= DOUBLE && LA111_0 <= DOUBLE_POSITIVE)||LA111_0==FALSE||(LA111_0 >= INTEGER && LA111_0 <= INTEGER_POSITIVE)||LA111_0==IRI_REF||LA111_0==OPEN_BRACE||LA111_0==OPEN_SQUARE_BRACKET||(LA111_0 >= PNAME_LN && LA111_0 <= PNAME_NS)||(LA111_0 >= STRING_LITERAL1 && LA111_0 <= STRING_LITERAL_LONG2)||LA111_0==TRUE||(LA111_0 >= VAR1 && LA111_0 <= VAR3)) ) {
				alt111=1;
			}
			switch (alt111) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:673:24: constructTriples
					{
					pushFollow(FOLLOW_constructTriples_in_constructTemplate4356);
					constructTriples368=constructTriples();
					state._fsp--;

					stream_constructTriples.add(constructTriples368.getTree());
					}
					break;

			}

			CLOSE_CURLY_BRACE369=(Token)match(input,CLOSE_CURLY_BRACE,FOLLOW_CLOSE_CURLY_BRACE_in_constructTemplate4359);  
			stream_CLOSE_CURLY_BRACE.add(CLOSE_CURLY_BRACE369);

			// AST REWRITE
			// elements: constructTriples
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 673:60: -> ^( CONSTRUCT_TRIPLES ( constructTriples )? )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:673:63: ^( CONSTRUCT_TRIPLES ( constructTriples )? )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(CONSTRUCT_TRIPLES, "CONSTRUCT_TRIPLES"), root_1);
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:673:83: ( constructTriples )?
				if ( stream_constructTriples.hasNext() ) {
					adaptor.addChild(root_1, stream_constructTriples.nextTree());
				}
				stream_constructTriples.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "constructTemplate"


	public static class constructTriples_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "constructTriples"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:676:1: constructTriples : triplesSameSubject ( DOT triplesSameSubject )* ( DOT )? -> ( triplesSameSubject )+ ;
	public final SparqlifyConfigParser.constructTriples_return constructTriples() throws RecognitionException {
		SparqlifyConfigParser.constructTriples_return retval = new SparqlifyConfigParser.constructTriples_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token DOT371=null;
		Token DOT373=null;
		ParserRuleReturnScope triplesSameSubject370 =null;
		ParserRuleReturnScope triplesSameSubject372 =null;

		CommonTree DOT371_tree=null;
		CommonTree DOT373_tree=null;
		RewriteRuleTokenStream stream_DOT=new RewriteRuleTokenStream(adaptor,"token DOT");
		RewriteRuleSubtreeStream stream_triplesSameSubject=new RewriteRuleSubtreeStream(adaptor,"rule triplesSameSubject");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:677:5: ( triplesSameSubject ( DOT triplesSameSubject )* ( DOT )? -> ( triplesSameSubject )+ )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:677:7: triplesSameSubject ( DOT triplesSameSubject )* ( DOT )?
			{
			pushFollow(FOLLOW_triplesSameSubject_in_constructTriples4385);
			triplesSameSubject370=triplesSameSubject();
			state._fsp--;

			stream_triplesSameSubject.add(triplesSameSubject370.getTree());
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:677:26: ( DOT triplesSameSubject )*
			loop112:
			while (true) {
				int alt112=2;
				int LA112_0 = input.LA(1);
				if ( (LA112_0==DOT) ) {
					int LA112_1 = input.LA(2);
					if ( (LA112_1==BLANK_NODE_LABEL||(LA112_1 >= DECIMAL && LA112_1 <= DECIMAL_POSITIVE)||(LA112_1 >= DOUBLE && LA112_1 <= DOUBLE_POSITIVE)||LA112_1==FALSE||(LA112_1 >= INTEGER && LA112_1 <= INTEGER_POSITIVE)||LA112_1==IRI_REF||LA112_1==OPEN_BRACE||LA112_1==OPEN_SQUARE_BRACKET||(LA112_1 >= PNAME_LN && LA112_1 <= PNAME_NS)||(LA112_1 >= STRING_LITERAL1 && LA112_1 <= STRING_LITERAL_LONG2)||LA112_1==TRUE||(LA112_1 >= VAR1 && LA112_1 <= VAR3)) ) {
						alt112=1;
					}

				}

				switch (alt112) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:677:28: DOT triplesSameSubject
					{
					DOT371=(Token)match(input,DOT,FOLLOW_DOT_in_constructTriples4389);  
					stream_DOT.add(DOT371);

					pushFollow(FOLLOW_triplesSameSubject_in_constructTriples4391);
					triplesSameSubject372=triplesSameSubject();
					state._fsp--;

					stream_triplesSameSubject.add(triplesSameSubject372.getTree());
					}
					break;

				default :
					break loop112;
				}
			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:677:54: ( DOT )?
			int alt113=2;
			int LA113_0 = input.LA(1);
			if ( (LA113_0==DOT) ) {
				alt113=1;
			}
			switch (alt113) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:677:54: DOT
					{
					DOT373=(Token)match(input,DOT,FOLLOW_DOT_in_constructTriples4396);  
					stream_DOT.add(DOT373);

					}
					break;

			}

			// AST REWRITE
			// elements: triplesSameSubject
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 677:59: -> ( triplesSameSubject )+
			{
				if ( !(stream_triplesSameSubject.hasNext()) ) {
					throw new RewriteEarlyExitException();
				}
				while ( stream_triplesSameSubject.hasNext() ) {
					adaptor.addChild(root_0, stream_triplesSameSubject.nextTree());
				}
				stream_triplesSameSubject.reset();

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "constructTriples"


	public static class triplesSameSubject_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "triplesSameSubject"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:684:1: triplesSameSubject : ( varOrTerm propertyListNotEmpty[(CommonTree) $varOrTerm.tree] -> propertyListNotEmpty | (t= triplesNode -> $t) ( (p= propertyListNotEmpty[(CommonTree) $t.tree] )? -> ^( TRIPLE $triplesSameSubject ( $p)? ) ) );
	public final SparqlifyConfigParser.triplesSameSubject_return triplesSameSubject() throws RecognitionException {
		SparqlifyConfigParser.triplesSameSubject_return retval = new SparqlifyConfigParser.triplesSameSubject_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		ParserRuleReturnScope t =null;
		ParserRuleReturnScope p =null;
		ParserRuleReturnScope varOrTerm374 =null;
		ParserRuleReturnScope propertyListNotEmpty375 =null;

		RewriteRuleSubtreeStream stream_varOrTerm=new RewriteRuleSubtreeStream(adaptor,"rule varOrTerm");
		RewriteRuleSubtreeStream stream_propertyListNotEmpty=new RewriteRuleSubtreeStream(adaptor,"rule propertyListNotEmpty");
		RewriteRuleSubtreeStream stream_triplesNode=new RewriteRuleSubtreeStream(adaptor,"rule triplesNode");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:685:5: ( varOrTerm propertyListNotEmpty[(CommonTree) $varOrTerm.tree] -> propertyListNotEmpty | (t= triplesNode -> $t) ( (p= propertyListNotEmpty[(CommonTree) $t.tree] )? -> ^( TRIPLE $triplesSameSubject ( $p)? ) ) )
			int alt115=2;
			switch ( input.LA(1) ) {
			case BLANK_NODE_LABEL:
			case DECIMAL:
			case DECIMAL_NEGATIVE:
			case DECIMAL_POSITIVE:
			case DOUBLE:
			case DOUBLE_NEGATIVE:
			case DOUBLE_POSITIVE:
			case FALSE:
			case INTEGER:
			case INTEGER_NEGATIVE:
			case INTEGER_POSITIVE:
			case IRI_REF:
			case PNAME_LN:
			case PNAME_NS:
			case STRING_LITERAL1:
			case STRING_LITERAL2:
			case STRING_LITERAL_LONG1:
			case STRING_LITERAL_LONG2:
			case TRUE:
			case VAR1:
			case VAR2:
			case VAR3:
				{
				alt115=1;
				}
				break;
			case OPEN_SQUARE_BRACKET:
				{
				int LA115_2 = input.LA(2);
				if ( (LA115_2==CLOSE_SQUARE_BRACKET) ) {
					alt115=1;
				}
				else if ( (LA115_2==A||LA115_2==IRI_REF||(LA115_2 >= PNAME_LN && LA115_2 <= PNAME_NS)||(LA115_2 >= VAR1 && LA115_2 <= VAR3)) ) {
					alt115=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 115, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case OPEN_BRACE:
				{
				int LA115_3 = input.LA(2);
				if ( (LA115_3==CLOSE_BRACE) ) {
					alt115=1;
				}
				else if ( (LA115_3==BLANK_NODE_LABEL||(LA115_3 >= DECIMAL && LA115_3 <= DECIMAL_POSITIVE)||(LA115_3 >= DOUBLE && LA115_3 <= DOUBLE_POSITIVE)||LA115_3==FALSE||(LA115_3 >= INTEGER && LA115_3 <= INTEGER_POSITIVE)||LA115_3==IRI_REF||LA115_3==OPEN_BRACE||LA115_3==OPEN_SQUARE_BRACKET||(LA115_3 >= PNAME_LN && LA115_3 <= PNAME_NS)||(LA115_3 >= STRING_LITERAL1 && LA115_3 <= STRING_LITERAL_LONG2)||LA115_3==TRUE||(LA115_3 >= VAR1 && LA115_3 <= VAR3)) ) {
					alt115=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 115, 3, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 115, 0, input);
				throw nvae;
			}
			switch (alt115) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:685:7: varOrTerm propertyListNotEmpty[(CommonTree) $varOrTerm.tree]
					{
					pushFollow(FOLLOW_varOrTerm_in_triplesSameSubject4421);
					varOrTerm374=varOrTerm();
					state._fsp--;

					stream_varOrTerm.add(varOrTerm374.getTree());
					pushFollow(FOLLOW_propertyListNotEmpty_in_triplesSameSubject4423);
					propertyListNotEmpty375=propertyListNotEmpty((CommonTree) (varOrTerm374!=null?((CommonTree)varOrTerm374.getTree()):null));
					state._fsp--;

					stream_propertyListNotEmpty.add(propertyListNotEmpty375.getTree());
					// AST REWRITE
					// elements: propertyListNotEmpty
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 685:68: -> propertyListNotEmpty
					{
						adaptor.addChild(root_0, stream_propertyListNotEmpty.nextTree());
					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:686:7: (t= triplesNode -> $t) ( (p= propertyListNotEmpty[(CommonTree) $t.tree] )? -> ^( TRIPLE $triplesSameSubject ( $p)? ) )
					{
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:686:7: (t= triplesNode -> $t)
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:686:8: t= triplesNode
					{
					pushFollow(FOLLOW_triplesNode_in_triplesSameSubject4439);
					t=triplesNode();
					state._fsp--;

					stream_triplesNode.add(t.getTree());
					// AST REWRITE
					// elements: t
					// token labels: 
					// rule labels: retval, t
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);
					RewriteRuleSubtreeStream stream_t=new RewriteRuleSubtreeStream(adaptor,"rule t",t!=null?t.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 686:22: -> $t
					{
						adaptor.addChild(root_0, stream_t.nextTree());
					}


					retval.tree = root_0;

					}

					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:686:29: ( (p= propertyListNotEmpty[(CommonTree) $t.tree] )? -> ^( TRIPLE $triplesSameSubject ( $p)? ) )
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:686:30: (p= propertyListNotEmpty[(CommonTree) $t.tree] )?
					{
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:686:31: (p= propertyListNotEmpty[(CommonTree) $t.tree] )?
					int alt114=2;
					int LA114_0 = input.LA(1);
					if ( (LA114_0==A||LA114_0==IRI_REF||(LA114_0 >= PNAME_LN && LA114_0 <= PNAME_NS)||(LA114_0 >= VAR1 && LA114_0 <= VAR3)) ) {
						alt114=1;
					}
					switch (alt114) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:686:31: p= propertyListNotEmpty[(CommonTree) $t.tree]
							{
							pushFollow(FOLLOW_propertyListNotEmpty_in_triplesSameSubject4450);
							p=propertyListNotEmpty((CommonTree) (t!=null?((CommonTree)t.getTree()):null));
							state._fsp--;

							stream_propertyListNotEmpty.add(p.getTree());
							}
							break;

					}

					// AST REWRITE
					// elements: p, triplesSameSubject
					// token labels: 
					// rule labels: retval, p
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);
					RewriteRuleSubtreeStream stream_p=new RewriteRuleSubtreeStream(adaptor,"rule p",p!=null?p.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 686:76: -> ^( TRIPLE $triplesSameSubject ( $p)? )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:686:79: ^( TRIPLE $triplesSameSubject ( $p)? )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(TRIPLE, "TRIPLE"), root_1);
						adaptor.addChild(root_1, stream_retval.nextTree());
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:686:109: ( $p)?
						if ( stream_p.hasNext() ) {
							adaptor.addChild(root_1, stream_p.nextTree());
						}
						stream_p.reset();

						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "triplesSameSubject"


	public static class propertyListNotEmpty_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "propertyListNotEmpty"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:689:1: propertyListNotEmpty[CommonTree subject] : v= verb objectList[subject, (CommonTree) $v.tree] ( SEMICOLON (v= verb objectList[subject, (CommonTree) $v.tree] )? )* -> ( objectList )+ ;
	public final SparqlifyConfigParser.propertyListNotEmpty_return propertyListNotEmpty(CommonTree subject) throws RecognitionException {
		SparqlifyConfigParser.propertyListNotEmpty_return retval = new SparqlifyConfigParser.propertyListNotEmpty_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token SEMICOLON377=null;
		ParserRuleReturnScope v =null;
		ParserRuleReturnScope objectList376 =null;
		ParserRuleReturnScope objectList378 =null;

		CommonTree SEMICOLON377_tree=null;
		RewriteRuleTokenStream stream_SEMICOLON=new RewriteRuleTokenStream(adaptor,"token SEMICOLON");
		RewriteRuleSubtreeStream stream_verb=new RewriteRuleSubtreeStream(adaptor,"rule verb");
		RewriteRuleSubtreeStream stream_objectList=new RewriteRuleSubtreeStream(adaptor,"rule objectList");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:690:5: (v= verb objectList[subject, (CommonTree) $v.tree] ( SEMICOLON (v= verb objectList[subject, (CommonTree) $v.tree] )? )* -> ( objectList )+ )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:690:7: v= verb objectList[subject, (CommonTree) $v.tree] ( SEMICOLON (v= verb objectList[subject, (CommonTree) $v.tree] )? )*
			{
			pushFollow(FOLLOW_verb_in_propertyListNotEmpty4486);
			v=verb();
			state._fsp--;

			stream_verb.add(v.getTree());
			pushFollow(FOLLOW_objectList_in_propertyListNotEmpty4488);
			objectList376=objectList(subject, (CommonTree) (v!=null?((CommonTree)v.getTree()):null));
			state._fsp--;

			stream_objectList.add(objectList376.getTree());
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:690:56: ( SEMICOLON (v= verb objectList[subject, (CommonTree) $v.tree] )? )*
			loop117:
			while (true) {
				int alt117=2;
				int LA117_0 = input.LA(1);
				if ( (LA117_0==SEMICOLON) ) {
					alt117=1;
				}

				switch (alt117) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:690:57: SEMICOLON (v= verb objectList[subject, (CommonTree) $v.tree] )?
					{
					SEMICOLON377=(Token)match(input,SEMICOLON,FOLLOW_SEMICOLON_in_propertyListNotEmpty4492);  
					stream_SEMICOLON.add(SEMICOLON377);

					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:690:67: (v= verb objectList[subject, (CommonTree) $v.tree] )?
					int alt116=2;
					int LA116_0 = input.LA(1);
					if ( (LA116_0==A||LA116_0==IRI_REF||(LA116_0 >= PNAME_LN && LA116_0 <= PNAME_NS)||(LA116_0 >= VAR1 && LA116_0 <= VAR3)) ) {
						alt116=1;
					}
					switch (alt116) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:690:68: v= verb objectList[subject, (CommonTree) $v.tree]
							{
							pushFollow(FOLLOW_verb_in_propertyListNotEmpty4497);
							v=verb();
							state._fsp--;

							stream_verb.add(v.getTree());
							pushFollow(FOLLOW_objectList_in_propertyListNotEmpty4499);
							objectList378=objectList(subject, (CommonTree) (v!=null?((CommonTree)v.getTree()):null));
							state._fsp--;

							stream_objectList.add(objectList378.getTree());
							}
							break;

					}

					}
					break;

				default :
					break loop117;
				}
			}

			// AST REWRITE
			// elements: objectList
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 690:121: -> ( objectList )+
			{
				if ( !(stream_objectList.hasNext()) ) {
					throw new RewriteEarlyExitException();
				}
				while ( stream_objectList.hasNext() ) {
					adaptor.addChild(root_0, stream_objectList.nextTree());
				}
				stream_objectList.reset();

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "propertyListNotEmpty"


	public static class objectList_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "objectList"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:693:1: objectList[CommonTree subject, CommonTree predicate] : graphNode ( COMMA graphNode )* -> ( ^( TRIPLE ^( SUBJECT ) ^( PREDICATE ) ^( OBJECT graphNode ) ) )+ ;
	public final SparqlifyConfigParser.objectList_return objectList(CommonTree subject, CommonTree predicate) throws RecognitionException {
		SparqlifyConfigParser.objectList_return retval = new SparqlifyConfigParser.objectList_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token COMMA380=null;
		ParserRuleReturnScope graphNode379 =null;
		ParserRuleReturnScope graphNode381 =null;

		CommonTree COMMA380_tree=null;
		RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
		RewriteRuleSubtreeStream stream_graphNode=new RewriteRuleSubtreeStream(adaptor,"rule graphNode");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:694:5: ( graphNode ( COMMA graphNode )* -> ( ^( TRIPLE ^( SUBJECT ) ^( PREDICATE ) ^( OBJECT graphNode ) ) )+ )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:694:7: graphNode ( COMMA graphNode )*
			{
			pushFollow(FOLLOW_graphNode_in_objectList4528);
			graphNode379=graphNode();
			state._fsp--;

			stream_graphNode.add(graphNode379.getTree());
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:694:17: ( COMMA graphNode )*
			loop118:
			while (true) {
				int alt118=2;
				int LA118_0 = input.LA(1);
				if ( (LA118_0==COMMA) ) {
					alt118=1;
				}

				switch (alt118) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:694:19: COMMA graphNode
					{
					COMMA380=(Token)match(input,COMMA,FOLLOW_COMMA_in_objectList4532);  
					stream_COMMA.add(COMMA380);

					pushFollow(FOLLOW_graphNode_in_objectList4534);
					graphNode381=graphNode();
					state._fsp--;

					stream_graphNode.add(graphNode381.getTree());
					}
					break;

				default :
					break loop118;
				}
			}

			// AST REWRITE
			// elements: graphNode
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 694:38: -> ( ^( TRIPLE ^( SUBJECT ) ^( PREDICATE ) ^( OBJECT graphNode ) ) )+
			{
				if ( !(stream_graphNode.hasNext()) ) {
					throw new RewriteEarlyExitException();
				}
				while ( stream_graphNode.hasNext() ) {
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:694:41: ^( TRIPLE ^( SUBJECT ) ^( PREDICATE ) ^( OBJECT graphNode ) )
					{
					CommonTree root_1 = (CommonTree)adaptor.nil();
					root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(TRIPLE, "TRIPLE"), root_1);
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:694:50: ^( SUBJECT )
					{
					CommonTree root_2 = (CommonTree)adaptor.nil();
					root_2 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(SUBJECT, "SUBJECT"), root_2);
					adaptor.addChild(root_2, subject.dupNode());
					adaptor.addChild(root_1, root_2);
					}

					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:694:81: ^( PREDICATE )
					{
					CommonTree root_2 = (CommonTree)adaptor.nil();
					root_2 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(PREDICATE, "PREDICATE"), root_2);
					adaptor.addChild(root_2, predicate.dupNode());
					adaptor.addChild(root_1, root_2);
					}

					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:694:116: ^( OBJECT graphNode )
					{
					CommonTree root_2 = (CommonTree)adaptor.nil();
					root_2 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(OBJECT, "OBJECT"), root_2);
					adaptor.addChild(root_2, stream_graphNode.nextTree());
					adaptor.addChild(root_1, root_2);
					}

					adaptor.addChild(root_0, root_1);
					}

				}
				stream_graphNode.reset();

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "objectList"


	public static class verb_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "verb"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:708:1: verb : ( varOrIRIref | A );
	public final SparqlifyConfigParser.verb_return verb() throws RecognitionException {
		SparqlifyConfigParser.verb_return retval = new SparqlifyConfigParser.verb_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token A383=null;
		ParserRuleReturnScope varOrIRIref382 =null;

		CommonTree A383_tree=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:709:5: ( varOrIRIref | A )
			int alt119=2;
			int LA119_0 = input.LA(1);
			if ( (LA119_0==IRI_REF||(LA119_0 >= PNAME_LN && LA119_0 <= PNAME_NS)||(LA119_0 >= VAR1 && LA119_0 <= VAR3)) ) {
				alt119=1;
			}
			else if ( (LA119_0==A) ) {
				alt119=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 119, 0, input);
				throw nvae;
			}

			switch (alt119) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:709:7: varOrIRIref
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_varOrIRIref_in_verb4584);
					varOrIRIref382=varOrIRIref();
					state._fsp--;

					adaptor.addChild(root_0, varOrIRIref382.getTree());

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:710:7: A
					{
					root_0 = (CommonTree)adaptor.nil();


					A383=(Token)match(input,A,FOLLOW_A_in_verb4592); 
					A383_tree = (CommonTree)adaptor.create(A383);
					adaptor.addChild(root_0, A383_tree);

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "verb"


	public static class triplesSameSubjectPath_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "triplesSameSubjectPath"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:713:1: triplesSameSubjectPath : ( varOrTerm propertyListNotEmptyPath[(CommonTree) $varOrTerm.tree] -> ^( TRIPLE propertyListNotEmptyPath ) | (t= triplesNode -> $t) ( (p= propertyListNotEmpty[(CommonTree) $t.tree] )? -> ^( TRIPLE $triplesSameSubjectPath ( $p)? ) ) );
	public final SparqlifyConfigParser.triplesSameSubjectPath_return triplesSameSubjectPath() throws RecognitionException {
		SparqlifyConfigParser.triplesSameSubjectPath_return retval = new SparqlifyConfigParser.triplesSameSubjectPath_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		ParserRuleReturnScope t =null;
		ParserRuleReturnScope p =null;
		ParserRuleReturnScope varOrTerm384 =null;
		ParserRuleReturnScope propertyListNotEmptyPath385 =null;

		RewriteRuleSubtreeStream stream_propertyListNotEmpty=new RewriteRuleSubtreeStream(adaptor,"rule propertyListNotEmpty");
		RewriteRuleSubtreeStream stream_varOrTerm=new RewriteRuleSubtreeStream(adaptor,"rule varOrTerm");
		RewriteRuleSubtreeStream stream_triplesNode=new RewriteRuleSubtreeStream(adaptor,"rule triplesNode");
		RewriteRuleSubtreeStream stream_propertyListNotEmptyPath=new RewriteRuleSubtreeStream(adaptor,"rule propertyListNotEmptyPath");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:714:5: ( varOrTerm propertyListNotEmptyPath[(CommonTree) $varOrTerm.tree] -> ^( TRIPLE propertyListNotEmptyPath ) | (t= triplesNode -> $t) ( (p= propertyListNotEmpty[(CommonTree) $t.tree] )? -> ^( TRIPLE $triplesSameSubjectPath ( $p)? ) ) )
			int alt121=2;
			switch ( input.LA(1) ) {
			case BLANK_NODE_LABEL:
			case DECIMAL:
			case DECIMAL_NEGATIVE:
			case DECIMAL_POSITIVE:
			case DOUBLE:
			case DOUBLE_NEGATIVE:
			case DOUBLE_POSITIVE:
			case FALSE:
			case INTEGER:
			case INTEGER_NEGATIVE:
			case INTEGER_POSITIVE:
			case IRI_REF:
			case PNAME_LN:
			case PNAME_NS:
			case STRING_LITERAL1:
			case STRING_LITERAL2:
			case STRING_LITERAL_LONG1:
			case STRING_LITERAL_LONG2:
			case TRUE:
			case VAR1:
			case VAR2:
			case VAR3:
				{
				alt121=1;
				}
				break;
			case OPEN_SQUARE_BRACKET:
				{
				int LA121_2 = input.LA(2);
				if ( (LA121_2==CLOSE_SQUARE_BRACKET) ) {
					alt121=1;
				}
				else if ( (LA121_2==A||LA121_2==IRI_REF||(LA121_2 >= PNAME_LN && LA121_2 <= PNAME_NS)||(LA121_2 >= VAR1 && LA121_2 <= VAR3)) ) {
					alt121=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 121, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case OPEN_BRACE:
				{
				int LA121_3 = input.LA(2);
				if ( (LA121_3==CLOSE_BRACE) ) {
					alt121=1;
				}
				else if ( (LA121_3==BLANK_NODE_LABEL||(LA121_3 >= DECIMAL && LA121_3 <= DECIMAL_POSITIVE)||(LA121_3 >= DOUBLE && LA121_3 <= DOUBLE_POSITIVE)||LA121_3==FALSE||(LA121_3 >= INTEGER && LA121_3 <= INTEGER_POSITIVE)||LA121_3==IRI_REF||LA121_3==OPEN_BRACE||LA121_3==OPEN_SQUARE_BRACKET||(LA121_3 >= PNAME_LN && LA121_3 <= PNAME_NS)||(LA121_3 >= STRING_LITERAL1 && LA121_3 <= STRING_LITERAL_LONG2)||LA121_3==TRUE||(LA121_3 >= VAR1 && LA121_3 <= VAR3)) ) {
					alt121=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 121, 3, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 121, 0, input);
				throw nvae;
			}
			switch (alt121) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:714:7: varOrTerm propertyListNotEmptyPath[(CommonTree) $varOrTerm.tree]
					{
					pushFollow(FOLLOW_varOrTerm_in_triplesSameSubjectPath4609);
					varOrTerm384=varOrTerm();
					state._fsp--;

					stream_varOrTerm.add(varOrTerm384.getTree());
					pushFollow(FOLLOW_propertyListNotEmptyPath_in_triplesSameSubjectPath4611);
					propertyListNotEmptyPath385=propertyListNotEmptyPath((CommonTree) (varOrTerm384!=null?((CommonTree)varOrTerm384.getTree()):null));
					state._fsp--;

					stream_propertyListNotEmptyPath.add(propertyListNotEmptyPath385.getTree());
					// AST REWRITE
					// elements: propertyListNotEmptyPath
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 714:72: -> ^( TRIPLE propertyListNotEmptyPath )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:714:75: ^( TRIPLE propertyListNotEmptyPath )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(TRIPLE, "TRIPLE"), root_1);
						adaptor.addChild(root_1, stream_propertyListNotEmptyPath.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:715:7: (t= triplesNode -> $t) ( (p= propertyListNotEmpty[(CommonTree) $t.tree] )? -> ^( TRIPLE $triplesSameSubjectPath ( $p)? ) )
					{
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:715:7: (t= triplesNode -> $t)
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:715:8: t= triplesNode
					{
					pushFollow(FOLLOW_triplesNode_in_triplesSameSubjectPath4631);
					t=triplesNode();
					state._fsp--;

					stream_triplesNode.add(t.getTree());
					// AST REWRITE
					// elements: t
					// token labels: 
					// rule labels: retval, t
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);
					RewriteRuleSubtreeStream stream_t=new RewriteRuleSubtreeStream(adaptor,"rule t",t!=null?t.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 715:22: -> $t
					{
						adaptor.addChild(root_0, stream_t.nextTree());
					}


					retval.tree = root_0;

					}

					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:715:29: ( (p= propertyListNotEmpty[(CommonTree) $t.tree] )? -> ^( TRIPLE $triplesSameSubjectPath ( $p)? ) )
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:715:30: (p= propertyListNotEmpty[(CommonTree) $t.tree] )?
					{
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:715:31: (p= propertyListNotEmpty[(CommonTree) $t.tree] )?
					int alt120=2;
					int LA120_0 = input.LA(1);
					if ( (LA120_0==A||LA120_0==IRI_REF||(LA120_0 >= PNAME_LN && LA120_0 <= PNAME_NS)||(LA120_0 >= VAR1 && LA120_0 <= VAR3)) ) {
						alt120=1;
					}
					switch (alt120) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:715:31: p= propertyListNotEmpty[(CommonTree) $t.tree]
							{
							pushFollow(FOLLOW_propertyListNotEmpty_in_triplesSameSubjectPath4642);
							p=propertyListNotEmpty((CommonTree) (t!=null?((CommonTree)t.getTree()):null));
							state._fsp--;

							stream_propertyListNotEmpty.add(p.getTree());
							}
							break;

					}

					// AST REWRITE
					// elements: p, triplesSameSubjectPath
					// token labels: 
					// rule labels: retval, p
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);
					RewriteRuleSubtreeStream stream_p=new RewriteRuleSubtreeStream(adaptor,"rule p",p!=null?p.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 715:76: -> ^( TRIPLE $triplesSameSubjectPath ( $p)? )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:715:79: ^( TRIPLE $triplesSameSubjectPath ( $p)? )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(TRIPLE, "TRIPLE"), root_1);
						adaptor.addChild(root_1, stream_retval.nextTree());
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:715:113: ( $p)?
						if ( stream_p.hasNext() ) {
							adaptor.addChild(root_1, stream_p.nextTree());
						}
						stream_p.reset();

						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "triplesSameSubjectPath"


	public static class propertyListNotEmptyPath_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "propertyListNotEmptyPath"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:718:1: propertyListNotEmptyPath[CommonTree subject] : (p= verbPath objectList[subject, (CommonTree) $p.tree] |v= verbSimple objectList[subject, (CommonTree) $v.tree] ) ( SEMICOLON (p= verbPath objectList[subject, (CommonTree) $p.tree] |v= verbSimple objectList[subject, (CommonTree) $v.tree] )? )* -> ( objectList )+ ;
	public final SparqlifyConfigParser.propertyListNotEmptyPath_return propertyListNotEmptyPath(CommonTree subject) throws RecognitionException {
		SparqlifyConfigParser.propertyListNotEmptyPath_return retval = new SparqlifyConfigParser.propertyListNotEmptyPath_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token SEMICOLON388=null;
		ParserRuleReturnScope p =null;
		ParserRuleReturnScope v =null;
		ParserRuleReturnScope objectList386 =null;
		ParserRuleReturnScope objectList387 =null;
		ParserRuleReturnScope objectList389 =null;
		ParserRuleReturnScope objectList390 =null;

		CommonTree SEMICOLON388_tree=null;
		RewriteRuleTokenStream stream_SEMICOLON=new RewriteRuleTokenStream(adaptor,"token SEMICOLON");
		RewriteRuleSubtreeStream stream_verbPath=new RewriteRuleSubtreeStream(adaptor,"rule verbPath");
		RewriteRuleSubtreeStream stream_objectList=new RewriteRuleSubtreeStream(adaptor,"rule objectList");
		RewriteRuleSubtreeStream stream_verbSimple=new RewriteRuleSubtreeStream(adaptor,"rule verbSimple");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:719:5: ( (p= verbPath objectList[subject, (CommonTree) $p.tree] |v= verbSimple objectList[subject, (CommonTree) $v.tree] ) ( SEMICOLON (p= verbPath objectList[subject, (CommonTree) $p.tree] |v= verbSimple objectList[subject, (CommonTree) $v.tree] )? )* -> ( objectList )+ )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:719:7: (p= verbPath objectList[subject, (CommonTree) $p.tree] |v= verbSimple objectList[subject, (CommonTree) $v.tree] ) ( SEMICOLON (p= verbPath objectList[subject, (CommonTree) $p.tree] |v= verbSimple objectList[subject, (CommonTree) $v.tree] )? )*
			{
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:719:7: (p= verbPath objectList[subject, (CommonTree) $p.tree] |v= verbSimple objectList[subject, (CommonTree) $v.tree] )
			int alt122=2;
			int LA122_0 = input.LA(1);
			if ( (LA122_0==A||LA122_0==INVERSE||LA122_0==IRI_REF||LA122_0==NEGATION||LA122_0==OPEN_BRACE||(LA122_0 >= PNAME_LN && LA122_0 <= PNAME_NS)) ) {
				alt122=1;
			}
			else if ( ((LA122_0 >= VAR1 && LA122_0 <= VAR3)) ) {
				alt122=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 122, 0, input);
				throw nvae;
			}

			switch (alt122) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:719:8: p= verbPath objectList[subject, (CommonTree) $p.tree]
					{
					pushFollow(FOLLOW_verbPath_in_propertyListNotEmptyPath4681);
					p=verbPath();
					state._fsp--;

					stream_verbPath.add(p.getTree());
					pushFollow(FOLLOW_objectList_in_propertyListNotEmptyPath4684);
					objectList386=objectList(subject, (CommonTree) (p!=null?((CommonTree)p.getTree()):null));
					state._fsp--;

					stream_objectList.add(objectList386.getTree());
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:719:63: v= verbSimple objectList[subject, (CommonTree) $v.tree]
					{
					pushFollow(FOLLOW_verbSimple_in_propertyListNotEmptyPath4690);
					v=verbSimple();
					state._fsp--;

					stream_verbSimple.add(v.getTree());
					pushFollow(FOLLOW_objectList_in_propertyListNotEmptyPath4692);
					objectList387=objectList(subject, (CommonTree) (v!=null?((CommonTree)v.getTree()):null));
					state._fsp--;

					stream_objectList.add(objectList387.getTree());
					}
					break;

			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:719:119: ( SEMICOLON (p= verbPath objectList[subject, (CommonTree) $p.tree] |v= verbSimple objectList[subject, (CommonTree) $v.tree] )? )*
			loop124:
			while (true) {
				int alt124=2;
				int LA124_0 = input.LA(1);
				if ( (LA124_0==SEMICOLON) ) {
					alt124=1;
				}

				switch (alt124) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:719:120: SEMICOLON (p= verbPath objectList[subject, (CommonTree) $p.tree] |v= verbSimple objectList[subject, (CommonTree) $v.tree] )?
					{
					SEMICOLON388=(Token)match(input,SEMICOLON,FOLLOW_SEMICOLON_in_propertyListNotEmptyPath4697);  
					stream_SEMICOLON.add(SEMICOLON388);

					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:719:130: (p= verbPath objectList[subject, (CommonTree) $p.tree] |v= verbSimple objectList[subject, (CommonTree) $v.tree] )?
					int alt123=3;
					int LA123_0 = input.LA(1);
					if ( (LA123_0==A||LA123_0==INVERSE||LA123_0==IRI_REF||LA123_0==NEGATION||LA123_0==OPEN_BRACE||(LA123_0 >= PNAME_LN && LA123_0 <= PNAME_NS)) ) {
						alt123=1;
					}
					else if ( ((LA123_0 >= VAR1 && LA123_0 <= VAR3)) ) {
						alt123=2;
					}
					switch (alt123) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:719:131: p= verbPath objectList[subject, (CommonTree) $p.tree]
							{
							pushFollow(FOLLOW_verbPath_in_propertyListNotEmptyPath4702);
							p=verbPath();
							state._fsp--;

							stream_verbPath.add(p.getTree());
							pushFollow(FOLLOW_objectList_in_propertyListNotEmptyPath4704);
							objectList389=objectList(subject, (CommonTree) (p!=null?((CommonTree)p.getTree()):null));
							state._fsp--;

							stream_objectList.add(objectList389.getTree());
							}
							break;
						case 2 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:719:187: v= verbSimple objectList[subject, (CommonTree) $v.tree]
							{
							pushFollow(FOLLOW_verbSimple_in_propertyListNotEmptyPath4712);
							v=verbSimple();
							state._fsp--;

							stream_verbSimple.add(v.getTree());
							pushFollow(FOLLOW_objectList_in_propertyListNotEmptyPath4715);
							objectList390=objectList(subject, (CommonTree) (v!=null?((CommonTree)v.getTree()):null));
							state._fsp--;

							stream_objectList.add(objectList390.getTree());
							}
							break;

					}

					}
					break;

				default :
					break loop124;
				}
			}

			// AST REWRITE
			// elements: objectList
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 719:248: -> ( objectList )+
			{
				if ( !(stream_objectList.hasNext()) ) {
					throw new RewriteEarlyExitException();
				}
				while ( stream_objectList.hasNext() ) {
					adaptor.addChild(root_0, stream_objectList.nextTree());
				}
				stream_objectList.reset();

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "propertyListNotEmptyPath"


	public static class verbPath_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "verbPath"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:722:1: verbPath : path ;
	public final SparqlifyConfigParser.verbPath_return verbPath() throws RecognitionException {
		SparqlifyConfigParser.verbPath_return retval = new SparqlifyConfigParser.verbPath_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		ParserRuleReturnScope path391 =null;


		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:723:5: ( path )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:723:7: path
			{
			root_0 = (CommonTree)adaptor.nil();


			pushFollow(FOLLOW_path_in_verbPath4747);
			path391=path();
			state._fsp--;

			adaptor.addChild(root_0, path391.getTree());

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "verbPath"


	public static class verbSimple_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "verbSimple"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:726:1: verbSimple : var ;
	public final SparqlifyConfigParser.verbSimple_return verbSimple() throws RecognitionException {
		SparqlifyConfigParser.verbSimple_return retval = new SparqlifyConfigParser.verbSimple_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		ParserRuleReturnScope var392 =null;


		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:727:5: ( var )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:727:7: var
			{
			root_0 = (CommonTree)adaptor.nil();


			pushFollow(FOLLOW_var_in_verbSimple4768);
			var392=var();
			state._fsp--;

			adaptor.addChild(root_0, var392.getTree());

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "verbSimple"


	public static class path_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "path"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:730:1: path : pathSequence ( PIPE pathSequence )* -> PATH pathSequence ( PIPE pathSequence )* ;
	public final SparqlifyConfigParser.path_return path() throws RecognitionException {
		SparqlifyConfigParser.path_return retval = new SparqlifyConfigParser.path_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token PIPE394=null;
		ParserRuleReturnScope pathSequence393 =null;
		ParserRuleReturnScope pathSequence395 =null;

		CommonTree PIPE394_tree=null;
		RewriteRuleTokenStream stream_PIPE=new RewriteRuleTokenStream(adaptor,"token PIPE");
		RewriteRuleSubtreeStream stream_pathSequence=new RewriteRuleSubtreeStream(adaptor,"rule pathSequence");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:731:5: ( pathSequence ( PIPE pathSequence )* -> PATH pathSequence ( PIPE pathSequence )* )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:731:7: pathSequence ( PIPE pathSequence )*
			{
			pushFollow(FOLLOW_pathSequence_in_path4790);
			pathSequence393=pathSequence();
			state._fsp--;

			stream_pathSequence.add(pathSequence393.getTree());
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:731:20: ( PIPE pathSequence )*
			loop125:
			while (true) {
				int alt125=2;
				int LA125_0 = input.LA(1);
				if ( (LA125_0==PIPE) ) {
					alt125=1;
				}

				switch (alt125) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:731:22: PIPE pathSequence
					{
					PIPE394=(Token)match(input,PIPE,FOLLOW_PIPE_in_path4794);  
					stream_PIPE.add(PIPE394);

					pushFollow(FOLLOW_pathSequence_in_path4796);
					pathSequence395=pathSequence();
					state._fsp--;

					stream_pathSequence.add(pathSequence395.getTree());
					}
					break;

				default :
					break loop125;
				}
			}

			// AST REWRITE
			// elements: pathSequence, pathSequence, PIPE
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 731:43: -> PATH pathSequence ( PIPE pathSequence )*
			{
				adaptor.addChild(root_0, (CommonTree)adaptor.create(PATH, "PATH"));
				adaptor.addChild(root_0, stream_pathSequence.nextTree());
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:731:64: ( PIPE pathSequence )*
				while ( stream_pathSequence.hasNext()||stream_PIPE.hasNext() ) {
					adaptor.addChild(root_0, stream_PIPE.nextNode());
					adaptor.addChild(root_0, stream_pathSequence.nextTree());
				}
				stream_pathSequence.reset();
				stream_PIPE.reset();

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "path"


	public static class pathSequence_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "pathSequence"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:734:1: pathSequence : pathEltOrInverse ( DIVIDE pathEltOrInverse )* ;
	public final SparqlifyConfigParser.pathSequence_return pathSequence() throws RecognitionException {
		SparqlifyConfigParser.pathSequence_return retval = new SparqlifyConfigParser.pathSequence_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token DIVIDE397=null;
		ParserRuleReturnScope pathEltOrInverse396 =null;
		ParserRuleReturnScope pathEltOrInverse398 =null;

		CommonTree DIVIDE397_tree=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:735:5: ( pathEltOrInverse ( DIVIDE pathEltOrInverse )* )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:735:7: pathEltOrInverse ( DIVIDE pathEltOrInverse )*
			{
			root_0 = (CommonTree)adaptor.nil();


			pushFollow(FOLLOW_pathEltOrInverse_in_pathSequence4832);
			pathEltOrInverse396=pathEltOrInverse();
			state._fsp--;

			adaptor.addChild(root_0, pathEltOrInverse396.getTree());

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:735:24: ( DIVIDE pathEltOrInverse )*
			loop126:
			while (true) {
				int alt126=2;
				int LA126_0 = input.LA(1);
				if ( (LA126_0==DIVIDE) ) {
					alt126=1;
				}

				switch (alt126) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:735:26: DIVIDE pathEltOrInverse
					{
					DIVIDE397=(Token)match(input,DIVIDE,FOLLOW_DIVIDE_in_pathSequence4836); 
					DIVIDE397_tree = (CommonTree)adaptor.create(DIVIDE397);
					adaptor.addChild(root_0, DIVIDE397_tree);

					pushFollow(FOLLOW_pathEltOrInverse_in_pathSequence4838);
					pathEltOrInverse398=pathEltOrInverse();
					state._fsp--;

					adaptor.addChild(root_0, pathEltOrInverse398.getTree());

					}
					break;

				default :
					break loop126;
				}
			}

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "pathSequence"


	public static class pathElt_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "pathElt"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:738:1: pathElt : pathPrimary ( pathMod )? ;
	public final SparqlifyConfigParser.pathElt_return pathElt() throws RecognitionException {
		SparqlifyConfigParser.pathElt_return retval = new SparqlifyConfigParser.pathElt_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		ParserRuleReturnScope pathPrimary399 =null;
		ParserRuleReturnScope pathMod400 =null;


		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:739:5: ( pathPrimary ( pathMod )? )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:739:7: pathPrimary ( pathMod )?
			{
			root_0 = (CommonTree)adaptor.nil();


			pushFollow(FOLLOW_pathPrimary_in_pathElt4866);
			pathPrimary399=pathPrimary();
			state._fsp--;

			adaptor.addChild(root_0, pathPrimary399.getTree());

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:739:19: ( pathMod )?
			int alt127=2;
			int LA127_0 = input.LA(1);
			if ( (LA127_0==ASTERISK||LA127_0==OPEN_CURLY_BRACE||LA127_0==PLUS||LA127_0==QUESTION_MARK) ) {
				alt127=1;
			}
			switch (alt127) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:739:19: pathMod
					{
					pushFollow(FOLLOW_pathMod_in_pathElt4868);
					pathMod400=pathMod();
					state._fsp--;

					adaptor.addChild(root_0, pathMod400.getTree());

					}
					break;

			}

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "pathElt"


	public static class pathEltOrInverse_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "pathEltOrInverse"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:742:1: pathEltOrInverse : ( pathElt | INVERSE pathElt );
	public final SparqlifyConfigParser.pathEltOrInverse_return pathEltOrInverse() throws RecognitionException {
		SparqlifyConfigParser.pathEltOrInverse_return retval = new SparqlifyConfigParser.pathEltOrInverse_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token INVERSE402=null;
		ParserRuleReturnScope pathElt401 =null;
		ParserRuleReturnScope pathElt403 =null;

		CommonTree INVERSE402_tree=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:743:5: ( pathElt | INVERSE pathElt )
			int alt128=2;
			int LA128_0 = input.LA(1);
			if ( (LA128_0==A||LA128_0==IRI_REF||LA128_0==NEGATION||LA128_0==OPEN_BRACE||(LA128_0 >= PNAME_LN && LA128_0 <= PNAME_NS)) ) {
				alt128=1;
			}
			else if ( (LA128_0==INVERSE) ) {
				alt128=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 128, 0, input);
				throw nvae;
			}

			switch (alt128) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:743:7: pathElt
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_pathElt_in_pathEltOrInverse4890);
					pathElt401=pathElt();
					state._fsp--;

					adaptor.addChild(root_0, pathElt401.getTree());

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:743:17: INVERSE pathElt
					{
					root_0 = (CommonTree)adaptor.nil();


					INVERSE402=(Token)match(input,INVERSE,FOLLOW_INVERSE_in_pathEltOrInverse4894); 
					INVERSE402_tree = (CommonTree)adaptor.create(INVERSE402);
					adaptor.addChild(root_0, INVERSE402_tree);

					pushFollow(FOLLOW_pathElt_in_pathEltOrInverse4896);
					pathElt403=pathElt();
					state._fsp--;

					adaptor.addChild(root_0, pathElt403.getTree());

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "pathEltOrInverse"


	public static class pathMod_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "pathMod"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:746:1: pathMod : ( ASTERISK | QUESTION_MARK | PLUS | OPEN_CURLY_BRACE ( INTEGER ( COMMA ( CLOSE_CURLY_BRACE | INTEGER CLOSE_CURLY_BRACE ) | CLOSE_CURLY_BRACE ) | COMMA INTEGER CLOSE_CURLY_BRACE ) ) ;
	public final SparqlifyConfigParser.pathMod_return pathMod() throws RecognitionException {
		SparqlifyConfigParser.pathMod_return retval = new SparqlifyConfigParser.pathMod_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token ASTERISK404=null;
		Token QUESTION_MARK405=null;
		Token PLUS406=null;
		Token OPEN_CURLY_BRACE407=null;
		Token INTEGER408=null;
		Token COMMA409=null;
		Token CLOSE_CURLY_BRACE410=null;
		Token INTEGER411=null;
		Token CLOSE_CURLY_BRACE412=null;
		Token CLOSE_CURLY_BRACE413=null;
		Token COMMA414=null;
		Token INTEGER415=null;
		Token CLOSE_CURLY_BRACE416=null;

		CommonTree ASTERISK404_tree=null;
		CommonTree QUESTION_MARK405_tree=null;
		CommonTree PLUS406_tree=null;
		CommonTree OPEN_CURLY_BRACE407_tree=null;
		CommonTree INTEGER408_tree=null;
		CommonTree COMMA409_tree=null;
		CommonTree CLOSE_CURLY_BRACE410_tree=null;
		CommonTree INTEGER411_tree=null;
		CommonTree CLOSE_CURLY_BRACE412_tree=null;
		CommonTree CLOSE_CURLY_BRACE413_tree=null;
		CommonTree COMMA414_tree=null;
		CommonTree INTEGER415_tree=null;
		CommonTree CLOSE_CURLY_BRACE416_tree=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:747:5: ( ( ASTERISK | QUESTION_MARK | PLUS | OPEN_CURLY_BRACE ( INTEGER ( COMMA ( CLOSE_CURLY_BRACE | INTEGER CLOSE_CURLY_BRACE ) | CLOSE_CURLY_BRACE ) | COMMA INTEGER CLOSE_CURLY_BRACE ) ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:747:7: ( ASTERISK | QUESTION_MARK | PLUS | OPEN_CURLY_BRACE ( INTEGER ( COMMA ( CLOSE_CURLY_BRACE | INTEGER CLOSE_CURLY_BRACE ) | CLOSE_CURLY_BRACE ) | COMMA INTEGER CLOSE_CURLY_BRACE ) )
			{
			root_0 = (CommonTree)adaptor.nil();


			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:747:7: ( ASTERISK | QUESTION_MARK | PLUS | OPEN_CURLY_BRACE ( INTEGER ( COMMA ( CLOSE_CURLY_BRACE | INTEGER CLOSE_CURLY_BRACE ) | CLOSE_CURLY_BRACE ) | COMMA INTEGER CLOSE_CURLY_BRACE ) )
			int alt132=4;
			switch ( input.LA(1) ) {
			case ASTERISK:
				{
				alt132=1;
				}
				break;
			case QUESTION_MARK:
				{
				alt132=2;
				}
				break;
			case PLUS:
				{
				alt132=3;
				}
				break;
			case OPEN_CURLY_BRACE:
				{
				alt132=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 132, 0, input);
				throw nvae;
			}
			switch (alt132) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:747:9: ASTERISK
					{
					ASTERISK404=(Token)match(input,ASTERISK,FOLLOW_ASTERISK_in_pathMod4919); 
					ASTERISK404_tree = (CommonTree)adaptor.create(ASTERISK404);
					adaptor.addChild(root_0, ASTERISK404_tree);

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:747:20: QUESTION_MARK
					{
					QUESTION_MARK405=(Token)match(input,QUESTION_MARK,FOLLOW_QUESTION_MARK_in_pathMod4923); 
					QUESTION_MARK405_tree = (CommonTree)adaptor.create(QUESTION_MARK405);
					adaptor.addChild(root_0, QUESTION_MARK405_tree);

					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:747:36: PLUS
					{
					PLUS406=(Token)match(input,PLUS,FOLLOW_PLUS_in_pathMod4927); 
					PLUS406_tree = (CommonTree)adaptor.create(PLUS406);
					adaptor.addChild(root_0, PLUS406_tree);

					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:747:43: OPEN_CURLY_BRACE ( INTEGER ( COMMA ( CLOSE_CURLY_BRACE | INTEGER CLOSE_CURLY_BRACE ) | CLOSE_CURLY_BRACE ) | COMMA INTEGER CLOSE_CURLY_BRACE )
					{
					OPEN_CURLY_BRACE407=(Token)match(input,OPEN_CURLY_BRACE,FOLLOW_OPEN_CURLY_BRACE_in_pathMod4931); 
					OPEN_CURLY_BRACE407_tree = (CommonTree)adaptor.create(OPEN_CURLY_BRACE407);
					adaptor.addChild(root_0, OPEN_CURLY_BRACE407_tree);

					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:747:60: ( INTEGER ( COMMA ( CLOSE_CURLY_BRACE | INTEGER CLOSE_CURLY_BRACE ) | CLOSE_CURLY_BRACE ) | COMMA INTEGER CLOSE_CURLY_BRACE )
					int alt131=2;
					int LA131_0 = input.LA(1);
					if ( (LA131_0==INTEGER) ) {
						alt131=1;
					}
					else if ( (LA131_0==COMMA) ) {
						alt131=2;
					}

					else {
						NoViableAltException nvae =
							new NoViableAltException("", 131, 0, input);
						throw nvae;
					}

					switch (alt131) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:747:62: INTEGER ( COMMA ( CLOSE_CURLY_BRACE | INTEGER CLOSE_CURLY_BRACE ) | CLOSE_CURLY_BRACE )
							{
							INTEGER408=(Token)match(input,INTEGER,FOLLOW_INTEGER_in_pathMod4935); 
							INTEGER408_tree = (CommonTree)adaptor.create(INTEGER408);
							adaptor.addChild(root_0, INTEGER408_tree);

							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:747:70: ( COMMA ( CLOSE_CURLY_BRACE | INTEGER CLOSE_CURLY_BRACE ) | CLOSE_CURLY_BRACE )
							int alt130=2;
							int LA130_0 = input.LA(1);
							if ( (LA130_0==COMMA) ) {
								alt130=1;
							}
							else if ( (LA130_0==CLOSE_CURLY_BRACE) ) {
								alt130=2;
							}

							else {
								NoViableAltException nvae =
									new NoViableAltException("", 130, 0, input);
								throw nvae;
							}

							switch (alt130) {
								case 1 :
									// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:747:72: COMMA ( CLOSE_CURLY_BRACE | INTEGER CLOSE_CURLY_BRACE )
									{
									COMMA409=(Token)match(input,COMMA,FOLLOW_COMMA_in_pathMod4939); 
									COMMA409_tree = (CommonTree)adaptor.create(COMMA409);
									adaptor.addChild(root_0, COMMA409_tree);

									// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:747:78: ( CLOSE_CURLY_BRACE | INTEGER CLOSE_CURLY_BRACE )
									int alt129=2;
									int LA129_0 = input.LA(1);
									if ( (LA129_0==CLOSE_CURLY_BRACE) ) {
										alt129=1;
									}
									else if ( (LA129_0==INTEGER) ) {
										alt129=2;
									}

									else {
										NoViableAltException nvae =
											new NoViableAltException("", 129, 0, input);
										throw nvae;
									}

									switch (alt129) {
										case 1 :
											// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:747:80: CLOSE_CURLY_BRACE
											{
											CLOSE_CURLY_BRACE410=(Token)match(input,CLOSE_CURLY_BRACE,FOLLOW_CLOSE_CURLY_BRACE_in_pathMod4943); 
											CLOSE_CURLY_BRACE410_tree = (CommonTree)adaptor.create(CLOSE_CURLY_BRACE410);
											adaptor.addChild(root_0, CLOSE_CURLY_BRACE410_tree);

											}
											break;
										case 2 :
											// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:747:100: INTEGER CLOSE_CURLY_BRACE
											{
											INTEGER411=(Token)match(input,INTEGER,FOLLOW_INTEGER_in_pathMod4947); 
											INTEGER411_tree = (CommonTree)adaptor.create(INTEGER411);
											adaptor.addChild(root_0, INTEGER411_tree);

											CLOSE_CURLY_BRACE412=(Token)match(input,CLOSE_CURLY_BRACE,FOLLOW_CLOSE_CURLY_BRACE_in_pathMod4949); 
											CLOSE_CURLY_BRACE412_tree = (CommonTree)adaptor.create(CLOSE_CURLY_BRACE412);
											adaptor.addChild(root_0, CLOSE_CURLY_BRACE412_tree);

											}
											break;

									}

									}
									break;
								case 2 :
									// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:747:130: CLOSE_CURLY_BRACE
									{
									CLOSE_CURLY_BRACE413=(Token)match(input,CLOSE_CURLY_BRACE,FOLLOW_CLOSE_CURLY_BRACE_in_pathMod4955); 
									CLOSE_CURLY_BRACE413_tree = (CommonTree)adaptor.create(CLOSE_CURLY_BRACE413);
									adaptor.addChild(root_0, CLOSE_CURLY_BRACE413_tree);

									}
									break;

							}

							}
							break;
						case 2 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:747:152: COMMA INTEGER CLOSE_CURLY_BRACE
							{
							COMMA414=(Token)match(input,COMMA,FOLLOW_COMMA_in_pathMod4961); 
							COMMA414_tree = (CommonTree)adaptor.create(COMMA414);
							adaptor.addChild(root_0, COMMA414_tree);

							INTEGER415=(Token)match(input,INTEGER,FOLLOW_INTEGER_in_pathMod4963); 
							INTEGER415_tree = (CommonTree)adaptor.create(INTEGER415);
							adaptor.addChild(root_0, INTEGER415_tree);

							CLOSE_CURLY_BRACE416=(Token)match(input,CLOSE_CURLY_BRACE,FOLLOW_CLOSE_CURLY_BRACE_in_pathMod4965); 
							CLOSE_CURLY_BRACE416_tree = (CommonTree)adaptor.create(CLOSE_CURLY_BRACE416);
							adaptor.addChild(root_0, CLOSE_CURLY_BRACE416_tree);

							}
							break;

					}

					}
					break;

			}

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "pathMod"


	public static class pathPrimary_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "pathPrimary"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:750:1: pathPrimary : ( iriRef -> ^( PATH_PRIMARY iriRef ) | A -> ^( PATH_PRIMARY A ) | NEGATION pathNegatedPropertySet -> ^( PATH_PRIMARY NEGATION pathNegatedPropertySet ) | OPEN_BRACE path CLOSE_BRACE -> ^( PATH_PRIMARY path ) );
	public final SparqlifyConfigParser.pathPrimary_return pathPrimary() throws RecognitionException {
		SparqlifyConfigParser.pathPrimary_return retval = new SparqlifyConfigParser.pathPrimary_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token A418=null;
		Token NEGATION419=null;
		Token OPEN_BRACE421=null;
		Token CLOSE_BRACE423=null;
		ParserRuleReturnScope iriRef417 =null;
		ParserRuleReturnScope pathNegatedPropertySet420 =null;
		ParserRuleReturnScope path422 =null;

		CommonTree A418_tree=null;
		CommonTree NEGATION419_tree=null;
		CommonTree OPEN_BRACE421_tree=null;
		CommonTree CLOSE_BRACE423_tree=null;
		RewriteRuleTokenStream stream_A=new RewriteRuleTokenStream(adaptor,"token A");
		RewriteRuleTokenStream stream_CLOSE_BRACE=new RewriteRuleTokenStream(adaptor,"token CLOSE_BRACE");
		RewriteRuleTokenStream stream_NEGATION=new RewriteRuleTokenStream(adaptor,"token NEGATION");
		RewriteRuleTokenStream stream_OPEN_BRACE=new RewriteRuleTokenStream(adaptor,"token OPEN_BRACE");
		RewriteRuleSubtreeStream stream_path=new RewriteRuleSubtreeStream(adaptor,"rule path");
		RewriteRuleSubtreeStream stream_iriRef=new RewriteRuleSubtreeStream(adaptor,"rule iriRef");
		RewriteRuleSubtreeStream stream_pathNegatedPropertySet=new RewriteRuleSubtreeStream(adaptor,"rule pathNegatedPropertySet");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:751:5: ( iriRef -> ^( PATH_PRIMARY iriRef ) | A -> ^( PATH_PRIMARY A ) | NEGATION pathNegatedPropertySet -> ^( PATH_PRIMARY NEGATION pathNegatedPropertySet ) | OPEN_BRACE path CLOSE_BRACE -> ^( PATH_PRIMARY path ) )
			int alt133=4;
			switch ( input.LA(1) ) {
			case IRI_REF:
			case PNAME_LN:
			case PNAME_NS:
				{
				alt133=1;
				}
				break;
			case A:
				{
				alt133=2;
				}
				break;
			case NEGATION:
				{
				alt133=3;
				}
				break;
			case OPEN_BRACE:
				{
				alt133=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 133, 0, input);
				throw nvae;
			}
			switch (alt133) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:751:7: iriRef
					{
					pushFollow(FOLLOW_iriRef_in_pathPrimary4986);
					iriRef417=iriRef();
					state._fsp--;

					stream_iriRef.add(iriRef417.getTree());
					// AST REWRITE
					// elements: iriRef
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 751:14: -> ^( PATH_PRIMARY iriRef )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:751:17: ^( PATH_PRIMARY iriRef )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(PATH_PRIMARY, "PATH_PRIMARY"), root_1);
						adaptor.addChild(root_1, stream_iriRef.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:752:7: A
					{
					A418=(Token)match(input,A,FOLLOW_A_in_pathPrimary5002);  
					stream_A.add(A418);

					// AST REWRITE
					// elements: A
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 752:9: -> ^( PATH_PRIMARY A )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:752:12: ^( PATH_PRIMARY A )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(PATH_PRIMARY, "PATH_PRIMARY"), root_1);
						adaptor.addChild(root_1, stream_A.nextNode());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:753:7: NEGATION pathNegatedPropertySet
					{
					NEGATION419=(Token)match(input,NEGATION,FOLLOW_NEGATION_in_pathPrimary5018);  
					stream_NEGATION.add(NEGATION419);

					pushFollow(FOLLOW_pathNegatedPropertySet_in_pathPrimary5020);
					pathNegatedPropertySet420=pathNegatedPropertySet();
					state._fsp--;

					stream_pathNegatedPropertySet.add(pathNegatedPropertySet420.getTree());
					// AST REWRITE
					// elements: pathNegatedPropertySet, NEGATION
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 753:39: -> ^( PATH_PRIMARY NEGATION pathNegatedPropertySet )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:753:42: ^( PATH_PRIMARY NEGATION pathNegatedPropertySet )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(PATH_PRIMARY, "PATH_PRIMARY"), root_1);
						adaptor.addChild(root_1, stream_NEGATION.nextNode());
						adaptor.addChild(root_1, stream_pathNegatedPropertySet.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:754:7: OPEN_BRACE path CLOSE_BRACE
					{
					OPEN_BRACE421=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_pathPrimary5038);  
					stream_OPEN_BRACE.add(OPEN_BRACE421);

					pushFollow(FOLLOW_path_in_pathPrimary5040);
					path422=path();
					state._fsp--;

					stream_path.add(path422.getTree());
					CLOSE_BRACE423=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_pathPrimary5042);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE423);

					// AST REWRITE
					// elements: path
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 754:35: -> ^( PATH_PRIMARY path )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:754:38: ^( PATH_PRIMARY path )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(PATH_PRIMARY, "PATH_PRIMARY"), root_1);
						adaptor.addChild(root_1, stream_path.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "pathPrimary"


	public static class pathNegatedPropertySet_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "pathNegatedPropertySet"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:757:1: pathNegatedPropertySet : ( pathOneInPropertySet | OPEN_BRACE ( pathOneInPropertySet ( PIPE pathOneInPropertySet )* )? CLOSE_BRACE ) -> ^( PATH_NEGATED ( pathOneInPropertySet )+ ) ;
	public final SparqlifyConfigParser.pathNegatedPropertySet_return pathNegatedPropertySet() throws RecognitionException {
		SparqlifyConfigParser.pathNegatedPropertySet_return retval = new SparqlifyConfigParser.pathNegatedPropertySet_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token OPEN_BRACE425=null;
		Token PIPE427=null;
		Token CLOSE_BRACE429=null;
		ParserRuleReturnScope pathOneInPropertySet424 =null;
		ParserRuleReturnScope pathOneInPropertySet426 =null;
		ParserRuleReturnScope pathOneInPropertySet428 =null;

		CommonTree OPEN_BRACE425_tree=null;
		CommonTree PIPE427_tree=null;
		CommonTree CLOSE_BRACE429_tree=null;
		RewriteRuleTokenStream stream_PIPE=new RewriteRuleTokenStream(adaptor,"token PIPE");
		RewriteRuleTokenStream stream_CLOSE_BRACE=new RewriteRuleTokenStream(adaptor,"token CLOSE_BRACE");
		RewriteRuleTokenStream stream_OPEN_BRACE=new RewriteRuleTokenStream(adaptor,"token OPEN_BRACE");
		RewriteRuleSubtreeStream stream_pathOneInPropertySet=new RewriteRuleSubtreeStream(adaptor,"rule pathOneInPropertySet");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:758:5: ( ( pathOneInPropertySet | OPEN_BRACE ( pathOneInPropertySet ( PIPE pathOneInPropertySet )* )? CLOSE_BRACE ) -> ^( PATH_NEGATED ( pathOneInPropertySet )+ ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:758:7: ( pathOneInPropertySet | OPEN_BRACE ( pathOneInPropertySet ( PIPE pathOneInPropertySet )* )? CLOSE_BRACE )
			{
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:758:7: ( pathOneInPropertySet | OPEN_BRACE ( pathOneInPropertySet ( PIPE pathOneInPropertySet )* )? CLOSE_BRACE )
			int alt136=2;
			int LA136_0 = input.LA(1);
			if ( (LA136_0==A||LA136_0==INVERSE||LA136_0==IRI_REF||(LA136_0 >= PNAME_LN && LA136_0 <= PNAME_NS)) ) {
				alt136=1;
			}
			else if ( (LA136_0==OPEN_BRACE) ) {
				alt136=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 136, 0, input);
				throw nvae;
			}

			switch (alt136) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:758:8: pathOneInPropertySet
					{
					pushFollow(FOLLOW_pathOneInPropertySet_in_pathNegatedPropertySet5068);
					pathOneInPropertySet424=pathOneInPropertySet();
					state._fsp--;

					stream_pathOneInPropertySet.add(pathOneInPropertySet424.getTree());
					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:758:31: OPEN_BRACE ( pathOneInPropertySet ( PIPE pathOneInPropertySet )* )? CLOSE_BRACE
					{
					OPEN_BRACE425=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_pathNegatedPropertySet5072);  
					stream_OPEN_BRACE.add(OPEN_BRACE425);

					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:758:42: ( pathOneInPropertySet ( PIPE pathOneInPropertySet )* )?
					int alt135=2;
					int LA135_0 = input.LA(1);
					if ( (LA135_0==A||LA135_0==INVERSE||LA135_0==IRI_REF||(LA135_0 >= PNAME_LN && LA135_0 <= PNAME_NS)) ) {
						alt135=1;
					}
					switch (alt135) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:758:44: pathOneInPropertySet ( PIPE pathOneInPropertySet )*
							{
							pushFollow(FOLLOW_pathOneInPropertySet_in_pathNegatedPropertySet5076);
							pathOneInPropertySet426=pathOneInPropertySet();
							state._fsp--;

							stream_pathOneInPropertySet.add(pathOneInPropertySet426.getTree());
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:758:65: ( PIPE pathOneInPropertySet )*
							loop134:
							while (true) {
								int alt134=2;
								int LA134_0 = input.LA(1);
								if ( (LA134_0==PIPE) ) {
									alt134=1;
								}

								switch (alt134) {
								case 1 :
									// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:758:67: PIPE pathOneInPropertySet
									{
									PIPE427=(Token)match(input,PIPE,FOLLOW_PIPE_in_pathNegatedPropertySet5080);  
									stream_PIPE.add(PIPE427);

									pushFollow(FOLLOW_pathOneInPropertySet_in_pathNegatedPropertySet5082);
									pathOneInPropertySet428=pathOneInPropertySet();
									state._fsp--;

									stream_pathOneInPropertySet.add(pathOneInPropertySet428.getTree());
									}
									break;

								default :
									break loop134;
								}
							}

							}
							break;

					}

					CLOSE_BRACE429=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_pathNegatedPropertySet5090);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE429);

					}
					break;

			}

			// AST REWRITE
			// elements: pathOneInPropertySet
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 758:112: -> ^( PATH_NEGATED ( pathOneInPropertySet )+ )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:758:115: ^( PATH_NEGATED ( pathOneInPropertySet )+ )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(PATH_NEGATED, "PATH_NEGATED"), root_1);
				if ( !(stream_pathOneInPropertySet.hasNext()) ) {
					throw new RewriteEarlyExitException();
				}
				while ( stream_pathOneInPropertySet.hasNext() ) {
					adaptor.addChild(root_1, stream_pathOneInPropertySet.nextTree());
				}
				stream_pathOneInPropertySet.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "pathNegatedPropertySet"


	public static class pathOneInPropertySet_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "pathOneInPropertySet"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:761:1: pathOneInPropertySet : ( INVERSE )? ( iriRef | A ) ;
	public final SparqlifyConfigParser.pathOneInPropertySet_return pathOneInPropertySet() throws RecognitionException {
		SparqlifyConfigParser.pathOneInPropertySet_return retval = new SparqlifyConfigParser.pathOneInPropertySet_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token INVERSE430=null;
		Token A432=null;
		ParserRuleReturnScope iriRef431 =null;

		CommonTree INVERSE430_tree=null;
		CommonTree A432_tree=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:762:5: ( ( INVERSE )? ( iriRef | A ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:762:7: ( INVERSE )? ( iriRef | A )
			{
			root_0 = (CommonTree)adaptor.nil();


			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:762:7: ( INVERSE )?
			int alt137=2;
			int LA137_0 = input.LA(1);
			if ( (LA137_0==INVERSE) ) {
				alt137=1;
			}
			switch (alt137) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:762:7: INVERSE
					{
					INVERSE430=(Token)match(input,INVERSE,FOLLOW_INVERSE_in_pathOneInPropertySet5120); 
					INVERSE430_tree = (CommonTree)adaptor.create(INVERSE430);
					adaptor.addChild(root_0, INVERSE430_tree);

					}
					break;

			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:762:16: ( iriRef | A )
			int alt138=2;
			int LA138_0 = input.LA(1);
			if ( (LA138_0==IRI_REF||(LA138_0 >= PNAME_LN && LA138_0 <= PNAME_NS)) ) {
				alt138=1;
			}
			else if ( (LA138_0==A) ) {
				alt138=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 138, 0, input);
				throw nvae;
			}

			switch (alt138) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:762:18: iriRef
					{
					pushFollow(FOLLOW_iriRef_in_pathOneInPropertySet5125);
					iriRef431=iriRef();
					state._fsp--;

					adaptor.addChild(root_0, iriRef431.getTree());

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:762:27: A
					{
					A432=(Token)match(input,A,FOLLOW_A_in_pathOneInPropertySet5129); 
					A432_tree = (CommonTree)adaptor.create(A432);
					adaptor.addChild(root_0, A432_tree);

					}
					break;

			}

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "pathOneInPropertySet"


	public static class triplesNode_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "triplesNode"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:765:1: triplesNode : ( OPEN_BRACE ( graphNode )+ CLOSE_BRACE -> ^( COLLECTION ( graphNode )+ ) |lsb= OPEN_SQUARE_BRACKET propertyListNotEmpty[new CommonTree(new CommonToken(VAR,\"[]\"))] CLOSE_SQUARE_BRACKET -> ^( TRIPLE propertyListNotEmpty ) );
	public final SparqlifyConfigParser.triplesNode_return triplesNode() throws RecognitionException {
		SparqlifyConfigParser.triplesNode_return retval = new SparqlifyConfigParser.triplesNode_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token lsb=null;
		Token OPEN_BRACE433=null;
		Token CLOSE_BRACE435=null;
		Token CLOSE_SQUARE_BRACKET437=null;
		ParserRuleReturnScope graphNode434 =null;
		ParserRuleReturnScope propertyListNotEmpty436 =null;

		CommonTree lsb_tree=null;
		CommonTree OPEN_BRACE433_tree=null;
		CommonTree CLOSE_BRACE435_tree=null;
		CommonTree CLOSE_SQUARE_BRACKET437_tree=null;
		RewriteRuleTokenStream stream_CLOSE_BRACE=new RewriteRuleTokenStream(adaptor,"token CLOSE_BRACE");
		RewriteRuleTokenStream stream_OPEN_SQUARE_BRACKET=new RewriteRuleTokenStream(adaptor,"token OPEN_SQUARE_BRACKET");
		RewriteRuleTokenStream stream_OPEN_BRACE=new RewriteRuleTokenStream(adaptor,"token OPEN_BRACE");
		RewriteRuleTokenStream stream_CLOSE_SQUARE_BRACKET=new RewriteRuleTokenStream(adaptor,"token CLOSE_SQUARE_BRACKET");
		RewriteRuleSubtreeStream stream_graphNode=new RewriteRuleSubtreeStream(adaptor,"rule graphNode");
		RewriteRuleSubtreeStream stream_propertyListNotEmpty=new RewriteRuleSubtreeStream(adaptor,"rule propertyListNotEmpty");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:766:5: ( OPEN_BRACE ( graphNode )+ CLOSE_BRACE -> ^( COLLECTION ( graphNode )+ ) |lsb= OPEN_SQUARE_BRACKET propertyListNotEmpty[new CommonTree(new CommonToken(VAR,\"[]\"))] CLOSE_SQUARE_BRACKET -> ^( TRIPLE propertyListNotEmpty ) )
			int alt140=2;
			int LA140_0 = input.LA(1);
			if ( (LA140_0==OPEN_BRACE) ) {
				alt140=1;
			}
			else if ( (LA140_0==OPEN_SQUARE_BRACKET) ) {
				alt140=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 140, 0, input);
				throw nvae;
			}

			switch (alt140) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:766:7: OPEN_BRACE ( graphNode )+ CLOSE_BRACE
					{
					OPEN_BRACE433=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_triplesNode5149);  
					stream_OPEN_BRACE.add(OPEN_BRACE433);

					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:766:18: ( graphNode )+
					int cnt139=0;
					loop139:
					while (true) {
						int alt139=2;
						int LA139_0 = input.LA(1);
						if ( (LA139_0==BLANK_NODE_LABEL||(LA139_0 >= DECIMAL && LA139_0 <= DECIMAL_POSITIVE)||(LA139_0 >= DOUBLE && LA139_0 <= DOUBLE_POSITIVE)||LA139_0==FALSE||(LA139_0 >= INTEGER && LA139_0 <= INTEGER_POSITIVE)||LA139_0==IRI_REF||LA139_0==OPEN_BRACE||LA139_0==OPEN_SQUARE_BRACKET||(LA139_0 >= PNAME_LN && LA139_0 <= PNAME_NS)||(LA139_0 >= STRING_LITERAL1 && LA139_0 <= STRING_LITERAL_LONG2)||LA139_0==TRUE||(LA139_0 >= VAR1 && LA139_0 <= VAR3)) ) {
							alt139=1;
						}

						switch (alt139) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:766:18: graphNode
							{
							pushFollow(FOLLOW_graphNode_in_triplesNode5151);
							graphNode434=graphNode();
							state._fsp--;

							stream_graphNode.add(graphNode434.getTree());
							}
							break;

						default :
							if ( cnt139 >= 1 ) break loop139;
							EarlyExitException eee = new EarlyExitException(139, input);
							throw eee;
						}
						cnt139++;
					}

					CLOSE_BRACE435=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_triplesNode5154);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE435);

					// AST REWRITE
					// elements: graphNode
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 766:41: -> ^( COLLECTION ( graphNode )+ )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:766:44: ^( COLLECTION ( graphNode )+ )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(COLLECTION, "COLLECTION"), root_1);
						if ( !(stream_graphNode.hasNext()) ) {
							throw new RewriteEarlyExitException();
						}
						while ( stream_graphNode.hasNext() ) {
							adaptor.addChild(root_1, stream_graphNode.nextTree());
						}
						stream_graphNode.reset();

						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:767:7: lsb= OPEN_SQUARE_BRACKET propertyListNotEmpty[new CommonTree(new CommonToken(VAR,\"[]\"))] CLOSE_SQUARE_BRACKET
					{
					lsb=(Token)match(input,OPEN_SQUARE_BRACKET,FOLLOW_OPEN_SQUARE_BRACKET_in_triplesNode5173);  
					stream_OPEN_SQUARE_BRACKET.add(lsb);

					pushFollow(FOLLOW_propertyListNotEmpty_in_triplesNode5175);
					propertyListNotEmpty436=propertyListNotEmpty(new CommonTree(new CommonToken(VAR,"[]")));
					state._fsp--;

					stream_propertyListNotEmpty.add(propertyListNotEmpty436.getTree());
					CLOSE_SQUARE_BRACKET437=(Token)match(input,CLOSE_SQUARE_BRACKET,FOLLOW_CLOSE_SQUARE_BRACKET_in_triplesNode5178);  
					stream_CLOSE_SQUARE_BRACKET.add(CLOSE_SQUARE_BRACKET437);

					// AST REWRITE
					// elements: propertyListNotEmpty
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 767:116: -> ^( TRIPLE propertyListNotEmpty )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:767:119: ^( TRIPLE propertyListNotEmpty )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(TRIPLE, "TRIPLE"), root_1);
						adaptor.addChild(root_1, stream_propertyListNotEmpty.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "triplesNode"


	public static class graphNode_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "graphNode"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:770:1: graphNode : ( varOrTerm | triplesNode );
	public final SparqlifyConfigParser.graphNode_return graphNode() throws RecognitionException {
		SparqlifyConfigParser.graphNode_return retval = new SparqlifyConfigParser.graphNode_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		ParserRuleReturnScope varOrTerm438 =null;
		ParserRuleReturnScope triplesNode439 =null;


		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:771:5: ( varOrTerm | triplesNode )
			int alt141=2;
			switch ( input.LA(1) ) {
			case BLANK_NODE_LABEL:
			case DECIMAL:
			case DECIMAL_NEGATIVE:
			case DECIMAL_POSITIVE:
			case DOUBLE:
			case DOUBLE_NEGATIVE:
			case DOUBLE_POSITIVE:
			case FALSE:
			case INTEGER:
			case INTEGER_NEGATIVE:
			case INTEGER_POSITIVE:
			case IRI_REF:
			case PNAME_LN:
			case PNAME_NS:
			case STRING_LITERAL1:
			case STRING_LITERAL2:
			case STRING_LITERAL_LONG1:
			case STRING_LITERAL_LONG2:
			case TRUE:
			case VAR1:
			case VAR2:
			case VAR3:
				{
				alt141=1;
				}
				break;
			case OPEN_SQUARE_BRACKET:
				{
				int LA141_2 = input.LA(2);
				if ( (LA141_2==CLOSE_SQUARE_BRACKET) ) {
					alt141=1;
				}
				else if ( (LA141_2==A||LA141_2==IRI_REF||(LA141_2 >= PNAME_LN && LA141_2 <= PNAME_NS)||(LA141_2 >= VAR1 && LA141_2 <= VAR3)) ) {
					alt141=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 141, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case OPEN_BRACE:
				{
				int LA141_3 = input.LA(2);
				if ( (LA141_3==CLOSE_BRACE) ) {
					alt141=1;
				}
				else if ( (LA141_3==BLANK_NODE_LABEL||(LA141_3 >= DECIMAL && LA141_3 <= DECIMAL_POSITIVE)||(LA141_3 >= DOUBLE && LA141_3 <= DOUBLE_POSITIVE)||LA141_3==FALSE||(LA141_3 >= INTEGER && LA141_3 <= INTEGER_POSITIVE)||LA141_3==IRI_REF||LA141_3==OPEN_BRACE||LA141_3==OPEN_SQUARE_BRACKET||(LA141_3 >= PNAME_LN && LA141_3 <= PNAME_NS)||(LA141_3 >= STRING_LITERAL1 && LA141_3 <= STRING_LITERAL_LONG2)||LA141_3==TRUE||(LA141_3 >= VAR1 && LA141_3 <= VAR3)) ) {
					alt141=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 141, 3, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 141, 0, input);
				throw nvae;
			}
			switch (alt141) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:771:7: varOrTerm
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_varOrTerm_in_graphNode5203);
					varOrTerm438=varOrTerm();
					state._fsp--;

					adaptor.addChild(root_0, varOrTerm438.getTree());

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:771:19: triplesNode
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_triplesNode_in_graphNode5207);
					triplesNode439=triplesNode();
					state._fsp--;

					adaptor.addChild(root_0, triplesNode439.getTree());

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "graphNode"


	public static class varOrTerm_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "varOrTerm"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:774:1: varOrTerm : ( var | graphTerm );
	public final SparqlifyConfigParser.varOrTerm_return varOrTerm() throws RecognitionException {
		SparqlifyConfigParser.varOrTerm_return retval = new SparqlifyConfigParser.varOrTerm_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		ParserRuleReturnScope var440 =null;
		ParserRuleReturnScope graphTerm441 =null;


		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:775:5: ( var | graphTerm )
			int alt142=2;
			int LA142_0 = input.LA(1);
			if ( ((LA142_0 >= VAR1 && LA142_0 <= VAR3)) ) {
				alt142=1;
			}
			else if ( (LA142_0==BLANK_NODE_LABEL||(LA142_0 >= DECIMAL && LA142_0 <= DECIMAL_POSITIVE)||(LA142_0 >= DOUBLE && LA142_0 <= DOUBLE_POSITIVE)||LA142_0==FALSE||(LA142_0 >= INTEGER && LA142_0 <= INTEGER_POSITIVE)||LA142_0==IRI_REF||LA142_0==OPEN_BRACE||LA142_0==OPEN_SQUARE_BRACKET||(LA142_0 >= PNAME_LN && LA142_0 <= PNAME_NS)||(LA142_0 >= STRING_LITERAL1 && LA142_0 <= STRING_LITERAL_LONG2)||LA142_0==TRUE) ) {
				alt142=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 142, 0, input);
				throw nvae;
			}

			switch (alt142) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:775:7: var
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_var_in_varOrTerm5224);
					var440=var();
					state._fsp--;

					adaptor.addChild(root_0, var440.getTree());

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:775:13: graphTerm
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_graphTerm_in_varOrTerm5228);
					graphTerm441=graphTerm();
					state._fsp--;

					adaptor.addChild(root_0, graphTerm441.getTree());

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "varOrTerm"


	public static class varOrIRIref_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "varOrIRIref"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:778:1: varOrIRIref : ( var | iriRef );
	public final SparqlifyConfigParser.varOrIRIref_return varOrIRIref() throws RecognitionException {
		SparqlifyConfigParser.varOrIRIref_return retval = new SparqlifyConfigParser.varOrIRIref_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		ParserRuleReturnScope var442 =null;
		ParserRuleReturnScope iriRef443 =null;


		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:779:5: ( var | iriRef )
			int alt143=2;
			int LA143_0 = input.LA(1);
			if ( ((LA143_0 >= VAR1 && LA143_0 <= VAR3)) ) {
				alt143=1;
			}
			else if ( (LA143_0==IRI_REF||(LA143_0 >= PNAME_LN && LA143_0 <= PNAME_NS)) ) {
				alt143=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 143, 0, input);
				throw nvae;
			}

			switch (alt143) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:779:7: var
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_var_in_varOrIRIref5245);
					var442=var();
					state._fsp--;

					adaptor.addChild(root_0, var442.getTree());

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:779:13: iriRef
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_iriRef_in_varOrIRIref5249);
					iriRef443=iriRef();
					state._fsp--;

					adaptor.addChild(root_0, iriRef443.getTree());

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "varOrIRIref"


	public static class var_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "var"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:782:1: var : (v= VAR1 -> ^( VAR[$v] ) |v= VAR2 -> ^( VAR[$v] ) |v= VAR3 -> ^( VAR[$v] ) );
	public final SparqlifyConfigParser.var_return var() throws RecognitionException {
		SparqlifyConfigParser.var_return retval = new SparqlifyConfigParser.var_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token v=null;

		CommonTree v_tree=null;
		RewriteRuleTokenStream stream_VAR1=new RewriteRuleTokenStream(adaptor,"token VAR1");
		RewriteRuleTokenStream stream_VAR2=new RewriteRuleTokenStream(adaptor,"token VAR2");
		RewriteRuleTokenStream stream_VAR3=new RewriteRuleTokenStream(adaptor,"token VAR3");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:783:5: (v= VAR1 -> ^( VAR[$v] ) |v= VAR2 -> ^( VAR[$v] ) |v= VAR3 -> ^( VAR[$v] ) )
			int alt144=3;
			switch ( input.LA(1) ) {
			case VAR1:
				{
				alt144=1;
				}
				break;
			case VAR2:
				{
				alt144=2;
				}
				break;
			case VAR3:
				{
				alt144=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 144, 0, input);
				throw nvae;
			}
			switch (alt144) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:783:7: v= VAR1
					{
					v=(Token)match(input,VAR1,FOLLOW_VAR1_in_var5268);  
					stream_VAR1.add(v);

					// AST REWRITE
					// elements: 
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 783:14: -> ^( VAR[$v] )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:783:17: ^( VAR[$v] )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(VAR, v), root_1);
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:784:7: v= VAR2
					{
					v=(Token)match(input,VAR2,FOLLOW_VAR2_in_var5285);  
					stream_VAR2.add(v);

					// AST REWRITE
					// elements: 
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 784:14: -> ^( VAR[$v] )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:784:17: ^( VAR[$v] )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(VAR, v), root_1);
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:785:7: v= VAR3
					{
					v=(Token)match(input,VAR3,FOLLOW_VAR3_in_var5302);  
					stream_VAR3.add(v);

					// AST REWRITE
					// elements: 
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 785:14: -> ^( VAR[$v] )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:785:17: ^( VAR[$v] )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(VAR, v), root_1);
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "var"


	public static class graphTerm_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "graphTerm"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:789:1: graphTerm : ( iriRef | rdfLiteral | numericLiteral | booleanLiteral | blankNode | nil );
	public final SparqlifyConfigParser.graphTerm_return graphTerm() throws RecognitionException {
		SparqlifyConfigParser.graphTerm_return retval = new SparqlifyConfigParser.graphTerm_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		ParserRuleReturnScope iriRef444 =null;
		ParserRuleReturnScope rdfLiteral445 =null;
		ParserRuleReturnScope numericLiteral446 =null;
		ParserRuleReturnScope booleanLiteral447 =null;
		ParserRuleReturnScope blankNode448 =null;
		ParserRuleReturnScope nil449 =null;


		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:790:5: ( iriRef | rdfLiteral | numericLiteral | booleanLiteral | blankNode | nil )
			int alt145=6;
			switch ( input.LA(1) ) {
			case IRI_REF:
			case PNAME_LN:
			case PNAME_NS:
				{
				alt145=1;
				}
				break;
			case STRING_LITERAL1:
			case STRING_LITERAL2:
			case STRING_LITERAL_LONG1:
			case STRING_LITERAL_LONG2:
				{
				alt145=2;
				}
				break;
			case DECIMAL:
			case DECIMAL_NEGATIVE:
			case DECIMAL_POSITIVE:
			case DOUBLE:
			case DOUBLE_NEGATIVE:
			case DOUBLE_POSITIVE:
			case INTEGER:
			case INTEGER_NEGATIVE:
			case INTEGER_POSITIVE:
				{
				alt145=3;
				}
				break;
			case FALSE:
			case TRUE:
				{
				alt145=4;
				}
				break;
			case BLANK_NODE_LABEL:
			case OPEN_SQUARE_BRACKET:
				{
				alt145=5;
				}
				break;
			case OPEN_BRACE:
				{
				alt145=6;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 145, 0, input);
				throw nvae;
			}
			switch (alt145) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:790:7: iriRef
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_iriRef_in_graphTerm5327);
					iriRef444=iriRef();
					state._fsp--;

					adaptor.addChild(root_0, iriRef444.getTree());

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:791:7: rdfLiteral
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_rdfLiteral_in_graphTerm5335);
					rdfLiteral445=rdfLiteral();
					state._fsp--;

					adaptor.addChild(root_0, rdfLiteral445.getTree());

					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:792:7: numericLiteral
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_numericLiteral_in_graphTerm5343);
					numericLiteral446=numericLiteral();
					state._fsp--;

					adaptor.addChild(root_0, numericLiteral446.getTree());

					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:793:7: booleanLiteral
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_booleanLiteral_in_graphTerm5351);
					booleanLiteral447=booleanLiteral();
					state._fsp--;

					adaptor.addChild(root_0, booleanLiteral447.getTree());

					}
					break;
				case 5 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:794:7: blankNode
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_blankNode_in_graphTerm5359);
					blankNode448=blankNode();
					state._fsp--;

					adaptor.addChild(root_0, blankNode448.getTree());

					}
					break;
				case 6 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:795:7: nil
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_nil_in_graphTerm5367);
					nil449=nil();
					state._fsp--;

					adaptor.addChild(root_0, nil449.getTree());

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "graphTerm"


	public static class nil_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "nil"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:798:1: nil : OPEN_BRACE CLOSE_BRACE ;
	public final SparqlifyConfigParser.nil_return nil() throws RecognitionException {
		SparqlifyConfigParser.nil_return retval = new SparqlifyConfigParser.nil_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token OPEN_BRACE450=null;
		Token CLOSE_BRACE451=null;

		CommonTree OPEN_BRACE450_tree=null;
		CommonTree CLOSE_BRACE451_tree=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:799:5: ( OPEN_BRACE CLOSE_BRACE )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:799:7: OPEN_BRACE CLOSE_BRACE
			{
			root_0 = (CommonTree)adaptor.nil();


			OPEN_BRACE450=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_nil5388); 
			OPEN_BRACE450_tree = (CommonTree)adaptor.create(OPEN_BRACE450);
			adaptor.addChild(root_0, OPEN_BRACE450_tree);

			CLOSE_BRACE451=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_nil5390); 
			CLOSE_BRACE451_tree = (CommonTree)adaptor.create(CLOSE_BRACE451);
			adaptor.addChild(root_0, CLOSE_BRACE451_tree);

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "nil"


	public static class expression_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "expression"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:802:1: expression : conditionalOrExpression ;
	public final SparqlifyConfigParser.expression_return expression() throws RecognitionException {
		SparqlifyConfigParser.expression_return retval = new SparqlifyConfigParser.expression_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		ParserRuleReturnScope conditionalOrExpression452 =null;


		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:803:5: ( conditionalOrExpression )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:803:7: conditionalOrExpression
			{
			root_0 = (CommonTree)adaptor.nil();


			pushFollow(FOLLOW_conditionalOrExpression_in_expression5407);
			conditionalOrExpression452=conditionalOrExpression();
			state._fsp--;

			adaptor.addChild(root_0, conditionalOrExpression452.getTree());

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "expression"


	public static class conditionalOrExpression_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "conditionalOrExpression"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:806:1: conditionalOrExpression : (c1= conditionalAndExpression -> $c1) ( OR c2= conditionalAndExpression -> ^( OR $conditionalOrExpression $c2) )* ;
	public final SparqlifyConfigParser.conditionalOrExpression_return conditionalOrExpression() throws RecognitionException {
		SparqlifyConfigParser.conditionalOrExpression_return retval = new SparqlifyConfigParser.conditionalOrExpression_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token OR453=null;
		ParserRuleReturnScope c1 =null;
		ParserRuleReturnScope c2 =null;

		CommonTree OR453_tree=null;
		RewriteRuleTokenStream stream_OR=new RewriteRuleTokenStream(adaptor,"token OR");
		RewriteRuleSubtreeStream stream_conditionalAndExpression=new RewriteRuleSubtreeStream(adaptor,"rule conditionalAndExpression");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:807:5: ( (c1= conditionalAndExpression -> $c1) ( OR c2= conditionalAndExpression -> ^( OR $conditionalOrExpression $c2) )* )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:807:7: (c1= conditionalAndExpression -> $c1) ( OR c2= conditionalAndExpression -> ^( OR $conditionalOrExpression $c2) )*
			{
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:807:7: (c1= conditionalAndExpression -> $c1)
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:807:8: c1= conditionalAndExpression
			{
			pushFollow(FOLLOW_conditionalAndExpression_in_conditionalOrExpression5427);
			c1=conditionalAndExpression();
			state._fsp--;

			stream_conditionalAndExpression.add(c1.getTree());
			// AST REWRITE
			// elements: c1
			// token labels: 
			// rule labels: retval, c1
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);
			RewriteRuleSubtreeStream stream_c1=new RewriteRuleSubtreeStream(adaptor,"rule c1",c1!=null?c1.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 807:36: -> $c1
			{
				adaptor.addChild(root_0, stream_c1.nextTree());
			}


			retval.tree = root_0;

			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:807:44: ( OR c2= conditionalAndExpression -> ^( OR $conditionalOrExpression $c2) )*
			loop146:
			while (true) {
				int alt146=2;
				int LA146_0 = input.LA(1);
				if ( (LA146_0==OR) ) {
					alt146=1;
				}

				switch (alt146) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:807:45: OR c2= conditionalAndExpression
					{
					OR453=(Token)match(input,OR,FOLLOW_OR_in_conditionalOrExpression5436);  
					stream_OR.add(OR453);

					pushFollow(FOLLOW_conditionalAndExpression_in_conditionalOrExpression5440);
					c2=conditionalAndExpression();
					state._fsp--;

					stream_conditionalAndExpression.add(c2.getTree());
					// AST REWRITE
					// elements: conditionalOrExpression, OR, c2
					// token labels: 
					// rule labels: retval, c2
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);
					RewriteRuleSubtreeStream stream_c2=new RewriteRuleSubtreeStream(adaptor,"rule c2",c2!=null?c2.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 807:76: -> ^( OR $conditionalOrExpression $c2)
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:807:79: ^( OR $conditionalOrExpression $c2)
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_OR.nextNode(), root_1);
						adaptor.addChild(root_1, stream_retval.nextTree());
						adaptor.addChild(root_1, stream_c2.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;

				default :
					break loop146;
				}
			}

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "conditionalOrExpression"


	public static class conditionalAndExpression_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "conditionalAndExpression"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:810:1: conditionalAndExpression : (v1= valueLogical -> $v1) ( AND v2= valueLogical -> ^( AND $conditionalAndExpression $v2) )* ;
	public final SparqlifyConfigParser.conditionalAndExpression_return conditionalAndExpression() throws RecognitionException {
		SparqlifyConfigParser.conditionalAndExpression_return retval = new SparqlifyConfigParser.conditionalAndExpression_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token AND454=null;
		ParserRuleReturnScope v1 =null;
		ParserRuleReturnScope v2 =null;

		CommonTree AND454_tree=null;
		RewriteRuleTokenStream stream_AND=new RewriteRuleTokenStream(adaptor,"token AND");
		RewriteRuleSubtreeStream stream_valueLogical=new RewriteRuleSubtreeStream(adaptor,"rule valueLogical");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:811:5: ( (v1= valueLogical -> $v1) ( AND v2= valueLogical -> ^( AND $conditionalAndExpression $v2) )* )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:811:7: (v1= valueLogical -> $v1) ( AND v2= valueLogical -> ^( AND $conditionalAndExpression $v2) )*
			{
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:811:7: (v1= valueLogical -> $v1)
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:811:8: v1= valueLogical
			{
			pushFollow(FOLLOW_valueLogical_in_conditionalAndExpression5474);
			v1=valueLogical();
			state._fsp--;

			stream_valueLogical.add(v1.getTree());
			// AST REWRITE
			// elements: v1
			// token labels: 
			// rule labels: v1, retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_v1=new RewriteRuleSubtreeStream(adaptor,"rule v1",v1!=null?v1.getTree():null);
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 811:24: -> $v1
			{
				adaptor.addChild(root_0, stream_v1.nextTree());
			}


			retval.tree = root_0;

			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:811:32: ( AND v2= valueLogical -> ^( AND $conditionalAndExpression $v2) )*
			loop147:
			while (true) {
				int alt147=2;
				int LA147_0 = input.LA(1);
				if ( (LA147_0==AND) ) {
					alt147=1;
				}

				switch (alt147) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:811:33: AND v2= valueLogical
					{
					AND454=(Token)match(input,AND,FOLLOW_AND_in_conditionalAndExpression5483);  
					stream_AND.add(AND454);

					pushFollow(FOLLOW_valueLogical_in_conditionalAndExpression5487);
					v2=valueLogical();
					state._fsp--;

					stream_valueLogical.add(v2.getTree());
					// AST REWRITE
					// elements: v2, conditionalAndExpression, AND
					// token labels: 
					// rule labels: retval, v2
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);
					RewriteRuleSubtreeStream stream_v2=new RewriteRuleSubtreeStream(adaptor,"rule v2",v2!=null?v2.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 811:53: -> ^( AND $conditionalAndExpression $v2)
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:811:56: ^( AND $conditionalAndExpression $v2)
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_AND.nextNode(), root_1);
						adaptor.addChild(root_1, stream_retval.nextTree());
						adaptor.addChild(root_1, stream_v2.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;

				default :
					break loop147;
				}
			}

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "conditionalAndExpression"


	public static class valueLogical_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "valueLogical"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:814:1: valueLogical : relationalExpression ;
	public final SparqlifyConfigParser.valueLogical_return valueLogical() throws RecognitionException {
		SparqlifyConfigParser.valueLogical_return retval = new SparqlifyConfigParser.valueLogical_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		ParserRuleReturnScope relationalExpression455 =null;


		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:815:5: ( relationalExpression )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:815:7: relationalExpression
			{
			root_0 = (CommonTree)adaptor.nil();


			pushFollow(FOLLOW_relationalExpression_in_valueLogical5518);
			relationalExpression455=relationalExpression();
			state._fsp--;

			adaptor.addChild(root_0, relationalExpression455.getTree());

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "valueLogical"


	public static class relationalExpression_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "relationalExpression"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:818:1: relationalExpression : (n1= numericExpression -> $n1) ( ( EQUAL n2= numericExpression -> ^( EQUAL $relationalExpression $n2) ) | ( NOT_EQUAL n3= numericExpression -> ^( NOT_EQUAL $relationalExpression $n3) ) | ( LESS n4= numericExpression -> ^( LESS $relationalExpression $n4) ) | ( GREATER n5= numericExpression -> ^( GREATER $relationalExpression $n5) ) | ( LESS_EQUAL n6= numericExpression -> ^( LESS_EQUAL $relationalExpression $n6) ) | ( GREATER_EQUAL n7= numericExpression -> ^( GREATER_EQUAL $relationalExpression $n7) ) | ( IN l2= expressionList -> ^( IN $relationalExpression $l2) ) | ( NOT IN l3= expressionList -> ^( NOT IN $relationalExpression $l3) ) )? ;
	public final SparqlifyConfigParser.relationalExpression_return relationalExpression() throws RecognitionException {
		SparqlifyConfigParser.relationalExpression_return retval = new SparqlifyConfigParser.relationalExpression_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token EQUAL456=null;
		Token NOT_EQUAL457=null;
		Token LESS458=null;
		Token GREATER459=null;
		Token LESS_EQUAL460=null;
		Token GREATER_EQUAL461=null;
		Token IN462=null;
		Token NOT463=null;
		Token IN464=null;
		ParserRuleReturnScope n1 =null;
		ParserRuleReturnScope n2 =null;
		ParserRuleReturnScope n3 =null;
		ParserRuleReturnScope n4 =null;
		ParserRuleReturnScope n5 =null;
		ParserRuleReturnScope n6 =null;
		ParserRuleReturnScope n7 =null;
		ParserRuleReturnScope l2 =null;
		ParserRuleReturnScope l3 =null;

		CommonTree EQUAL456_tree=null;
		CommonTree NOT_EQUAL457_tree=null;
		CommonTree LESS458_tree=null;
		CommonTree GREATER459_tree=null;
		CommonTree LESS_EQUAL460_tree=null;
		CommonTree GREATER_EQUAL461_tree=null;
		CommonTree IN462_tree=null;
		CommonTree NOT463_tree=null;
		CommonTree IN464_tree=null;
		RewriteRuleTokenStream stream_GREATER=new RewriteRuleTokenStream(adaptor,"token GREATER");
		RewriteRuleTokenStream stream_LESS_EQUAL=new RewriteRuleTokenStream(adaptor,"token LESS_EQUAL");
		RewriteRuleTokenStream stream_IN=new RewriteRuleTokenStream(adaptor,"token IN");
		RewriteRuleTokenStream stream_NOT=new RewriteRuleTokenStream(adaptor,"token NOT");
		RewriteRuleTokenStream stream_NOT_EQUAL=new RewriteRuleTokenStream(adaptor,"token NOT_EQUAL");
		RewriteRuleTokenStream stream_GREATER_EQUAL=new RewriteRuleTokenStream(adaptor,"token GREATER_EQUAL");
		RewriteRuleTokenStream stream_EQUAL=new RewriteRuleTokenStream(adaptor,"token EQUAL");
		RewriteRuleTokenStream stream_LESS=new RewriteRuleTokenStream(adaptor,"token LESS");
		RewriteRuleSubtreeStream stream_expressionList=new RewriteRuleSubtreeStream(adaptor,"rule expressionList");
		RewriteRuleSubtreeStream stream_numericExpression=new RewriteRuleSubtreeStream(adaptor,"rule numericExpression");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:819:5: ( (n1= numericExpression -> $n1) ( ( EQUAL n2= numericExpression -> ^( EQUAL $relationalExpression $n2) ) | ( NOT_EQUAL n3= numericExpression -> ^( NOT_EQUAL $relationalExpression $n3) ) | ( LESS n4= numericExpression -> ^( LESS $relationalExpression $n4) ) | ( GREATER n5= numericExpression -> ^( GREATER $relationalExpression $n5) ) | ( LESS_EQUAL n6= numericExpression -> ^( LESS_EQUAL $relationalExpression $n6) ) | ( GREATER_EQUAL n7= numericExpression -> ^( GREATER_EQUAL $relationalExpression $n7) ) | ( IN l2= expressionList -> ^( IN $relationalExpression $l2) ) | ( NOT IN l3= expressionList -> ^( NOT IN $relationalExpression $l3) ) )? )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:819:7: (n1= numericExpression -> $n1) ( ( EQUAL n2= numericExpression -> ^( EQUAL $relationalExpression $n2) ) | ( NOT_EQUAL n3= numericExpression -> ^( NOT_EQUAL $relationalExpression $n3) ) | ( LESS n4= numericExpression -> ^( LESS $relationalExpression $n4) ) | ( GREATER n5= numericExpression -> ^( GREATER $relationalExpression $n5) ) | ( LESS_EQUAL n6= numericExpression -> ^( LESS_EQUAL $relationalExpression $n6) ) | ( GREATER_EQUAL n7= numericExpression -> ^( GREATER_EQUAL $relationalExpression $n7) ) | ( IN l2= expressionList -> ^( IN $relationalExpression $l2) ) | ( NOT IN l3= expressionList -> ^( NOT IN $relationalExpression $l3) ) )?
			{
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:819:7: (n1= numericExpression -> $n1)
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:819:8: n1= numericExpression
			{
			pushFollow(FOLLOW_numericExpression_in_relationalExpression5538);
			n1=numericExpression();
			state._fsp--;

			stream_numericExpression.add(n1.getTree());
			// AST REWRITE
			// elements: n1
			// token labels: 
			// rule labels: n1, retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_n1=new RewriteRuleSubtreeStream(adaptor,"rule n1",n1!=null?n1.getTree():null);
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 819:29: -> $n1
			{
				adaptor.addChild(root_0, stream_n1.nextTree());
			}


			retval.tree = root_0;

			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:819:37: ( ( EQUAL n2= numericExpression -> ^( EQUAL $relationalExpression $n2) ) | ( NOT_EQUAL n3= numericExpression -> ^( NOT_EQUAL $relationalExpression $n3) ) | ( LESS n4= numericExpression -> ^( LESS $relationalExpression $n4) ) | ( GREATER n5= numericExpression -> ^( GREATER $relationalExpression $n5) ) | ( LESS_EQUAL n6= numericExpression -> ^( LESS_EQUAL $relationalExpression $n6) ) | ( GREATER_EQUAL n7= numericExpression -> ^( GREATER_EQUAL $relationalExpression $n7) ) | ( IN l2= expressionList -> ^( IN $relationalExpression $l2) ) | ( NOT IN l3= expressionList -> ^( NOT IN $relationalExpression $l3) ) )?
			int alt148=9;
			switch ( input.LA(1) ) {
				case EQUAL:
					{
					alt148=1;
					}
					break;
				case NOT_EQUAL:
					{
					alt148=2;
					}
					break;
				case LESS:
					{
					alt148=3;
					}
					break;
				case GREATER:
					{
					alt148=4;
					}
					break;
				case LESS_EQUAL:
					{
					alt148=5;
					}
					break;
				case GREATER_EQUAL:
					{
					alt148=6;
					}
					break;
				case IN:
					{
					alt148=7;
					}
					break;
				case NOT:
					{
					alt148=8;
					}
					break;
			}
			switch (alt148) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:819:39: ( EQUAL n2= numericExpression -> ^( EQUAL $relationalExpression $n2) )
					{
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:819:39: ( EQUAL n2= numericExpression -> ^( EQUAL $relationalExpression $n2) )
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:819:40: EQUAL n2= numericExpression
					{
					EQUAL456=(Token)match(input,EQUAL,FOLLOW_EQUAL_in_relationalExpression5549);  
					stream_EQUAL.add(EQUAL456);

					pushFollow(FOLLOW_numericExpression_in_relationalExpression5553);
					n2=numericExpression();
					state._fsp--;

					stream_numericExpression.add(n2.getTree());
					// AST REWRITE
					// elements: EQUAL, n2, relationalExpression
					// token labels: 
					// rule labels: retval, n2
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);
					RewriteRuleSubtreeStream stream_n2=new RewriteRuleSubtreeStream(adaptor,"rule n2",n2!=null?n2.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 819:67: -> ^( EQUAL $relationalExpression $n2)
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:819:70: ^( EQUAL $relationalExpression $n2)
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_EQUAL.nextNode(), root_1);
						adaptor.addChild(root_1, stream_retval.nextTree());
						adaptor.addChild(root_1, stream_n2.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:820:39: ( NOT_EQUAL n3= numericExpression -> ^( NOT_EQUAL $relationalExpression $n3) )
					{
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:820:39: ( NOT_EQUAL n3= numericExpression -> ^( NOT_EQUAL $relationalExpression $n3) )
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:820:40: NOT_EQUAL n3= numericExpression
					{
					NOT_EQUAL457=(Token)match(input,NOT_EQUAL,FOLLOW_NOT_EQUAL_in_relationalExpression5610);  
					stream_NOT_EQUAL.add(NOT_EQUAL457);

					pushFollow(FOLLOW_numericExpression_in_relationalExpression5614);
					n3=numericExpression();
					state._fsp--;

					stream_numericExpression.add(n3.getTree());
					// AST REWRITE
					// elements: NOT_EQUAL, relationalExpression, n3
					// token labels: 
					// rule labels: retval, n3
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);
					RewriteRuleSubtreeStream stream_n3=new RewriteRuleSubtreeStream(adaptor,"rule n3",n3!=null?n3.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 820:71: -> ^( NOT_EQUAL $relationalExpression $n3)
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:820:74: ^( NOT_EQUAL $relationalExpression $n3)
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_NOT_EQUAL.nextNode(), root_1);
						adaptor.addChild(root_1, stream_retval.nextTree());
						adaptor.addChild(root_1, stream_n3.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}

					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:821:39: ( LESS n4= numericExpression -> ^( LESS $relationalExpression $n4) )
					{
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:821:39: ( LESS n4= numericExpression -> ^( LESS $relationalExpression $n4) )
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:821:40: LESS n4= numericExpression
					{
					LESS458=(Token)match(input,LESS,FOLLOW_LESS_in_relationalExpression5669);  
					stream_LESS.add(LESS458);

					pushFollow(FOLLOW_numericExpression_in_relationalExpression5673);
					n4=numericExpression();
					state._fsp--;

					stream_numericExpression.add(n4.getTree());
					// AST REWRITE
					// elements: n4, relationalExpression, LESS
					// token labels: 
					// rule labels: retval, n4
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);
					RewriteRuleSubtreeStream stream_n4=new RewriteRuleSubtreeStream(adaptor,"rule n4",n4!=null?n4.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 821:66: -> ^( LESS $relationalExpression $n4)
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:821:69: ^( LESS $relationalExpression $n4)
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_LESS.nextNode(), root_1);
						adaptor.addChild(root_1, stream_retval.nextTree());
						adaptor.addChild(root_1, stream_n4.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}

					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:822:39: ( GREATER n5= numericExpression -> ^( GREATER $relationalExpression $n5) )
					{
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:822:39: ( GREATER n5= numericExpression -> ^( GREATER $relationalExpression $n5) )
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:822:40: GREATER n5= numericExpression
					{
					GREATER459=(Token)match(input,GREATER,FOLLOW_GREATER_in_relationalExpression5728);  
					stream_GREATER.add(GREATER459);

					pushFollow(FOLLOW_numericExpression_in_relationalExpression5732);
					n5=numericExpression();
					state._fsp--;

					stream_numericExpression.add(n5.getTree());
					// AST REWRITE
					// elements: GREATER, n5, relationalExpression
					// token labels: 
					// rule labels: retval, n5
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);
					RewriteRuleSubtreeStream stream_n5=new RewriteRuleSubtreeStream(adaptor,"rule n5",n5!=null?n5.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 822:69: -> ^( GREATER $relationalExpression $n5)
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:822:72: ^( GREATER $relationalExpression $n5)
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_GREATER.nextNode(), root_1);
						adaptor.addChild(root_1, stream_retval.nextTree());
						adaptor.addChild(root_1, stream_n5.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}

					}
					break;
				case 5 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:823:39: ( LESS_EQUAL n6= numericExpression -> ^( LESS_EQUAL $relationalExpression $n6) )
					{
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:823:39: ( LESS_EQUAL n6= numericExpression -> ^( LESS_EQUAL $relationalExpression $n6) )
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:823:40: LESS_EQUAL n6= numericExpression
					{
					LESS_EQUAL460=(Token)match(input,LESS_EQUAL,FOLLOW_LESS_EQUAL_in_relationalExpression5786);  
					stream_LESS_EQUAL.add(LESS_EQUAL460);

					pushFollow(FOLLOW_numericExpression_in_relationalExpression5790);
					n6=numericExpression();
					state._fsp--;

					stream_numericExpression.add(n6.getTree());
					// AST REWRITE
					// elements: n6, relationalExpression, LESS_EQUAL
					// token labels: 
					// rule labels: retval, n6
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);
					RewriteRuleSubtreeStream stream_n6=new RewriteRuleSubtreeStream(adaptor,"rule n6",n6!=null?n6.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 823:72: -> ^( LESS_EQUAL $relationalExpression $n6)
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:823:75: ^( LESS_EQUAL $relationalExpression $n6)
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_LESS_EQUAL.nextNode(), root_1);
						adaptor.addChild(root_1, stream_retval.nextTree());
						adaptor.addChild(root_1, stream_n6.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}

					}
					break;
				case 6 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:824:39: ( GREATER_EQUAL n7= numericExpression -> ^( GREATER_EQUAL $relationalExpression $n7) )
					{
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:824:39: ( GREATER_EQUAL n7= numericExpression -> ^( GREATER_EQUAL $relationalExpression $n7) )
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:824:40: GREATER_EQUAL n7= numericExpression
					{
					GREATER_EQUAL461=(Token)match(input,GREATER_EQUAL,FOLLOW_GREATER_EQUAL_in_relationalExpression5844);  
					stream_GREATER_EQUAL.add(GREATER_EQUAL461);

					pushFollow(FOLLOW_numericExpression_in_relationalExpression5848);
					n7=numericExpression();
					state._fsp--;

					stream_numericExpression.add(n7.getTree());
					// AST REWRITE
					// elements: relationalExpression, GREATER_EQUAL, n7
					// token labels: 
					// rule labels: retval, n7
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);
					RewriteRuleSubtreeStream stream_n7=new RewriteRuleSubtreeStream(adaptor,"rule n7",n7!=null?n7.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 824:75: -> ^( GREATER_EQUAL $relationalExpression $n7)
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:824:78: ^( GREATER_EQUAL $relationalExpression $n7)
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_GREATER_EQUAL.nextNode(), root_1);
						adaptor.addChild(root_1, stream_retval.nextTree());
						adaptor.addChild(root_1, stream_n7.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}

					}
					break;
				case 7 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:825:39: ( IN l2= expressionList -> ^( IN $relationalExpression $l2) )
					{
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:825:39: ( IN l2= expressionList -> ^( IN $relationalExpression $l2) )
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:825:40: IN l2= expressionList
					{
					IN462=(Token)match(input,IN,FOLLOW_IN_in_relationalExpression5904);  
					stream_IN.add(IN462);

					pushFollow(FOLLOW_expressionList_in_relationalExpression5908);
					l2=expressionList();
					state._fsp--;

					stream_expressionList.add(l2.getTree());
					// AST REWRITE
					// elements: relationalExpression, l2, IN
					// token labels: 
					// rule labels: retval, l2
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);
					RewriteRuleSubtreeStream stream_l2=new RewriteRuleSubtreeStream(adaptor,"rule l2",l2!=null?l2.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 825:61: -> ^( IN $relationalExpression $l2)
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:825:64: ^( IN $relationalExpression $l2)
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_IN.nextNode(), root_1);
						adaptor.addChild(root_1, stream_retval.nextTree());
						adaptor.addChild(root_1, stream_l2.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}

					}
					break;
				case 8 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:826:39: ( NOT IN l3= expressionList -> ^( NOT IN $relationalExpression $l3) )
					{
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:826:39: ( NOT IN l3= expressionList -> ^( NOT IN $relationalExpression $l3) )
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:826:40: NOT IN l3= expressionList
					{
					NOT463=(Token)match(input,NOT,FOLLOW_NOT_in_relationalExpression5962);  
					stream_NOT.add(NOT463);

					IN464=(Token)match(input,IN,FOLLOW_IN_in_relationalExpression5964);  
					stream_IN.add(IN464);

					pushFollow(FOLLOW_expressionList_in_relationalExpression5968);
					l3=expressionList();
					state._fsp--;

					stream_expressionList.add(l3.getTree());
					// AST REWRITE
					// elements: IN, NOT, relationalExpression, l3
					// token labels: 
					// rule labels: retval, l3
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);
					RewriteRuleSubtreeStream stream_l3=new RewriteRuleSubtreeStream(adaptor,"rule l3",l3!=null?l3.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 826:65: -> ^( NOT IN $relationalExpression $l3)
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:826:68: ^( NOT IN $relationalExpression $l3)
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_NOT.nextNode(), root_1);
						adaptor.addChild(root_1, stream_IN.nextNode());
						adaptor.addChild(root_1, stream_retval.nextTree());
						adaptor.addChild(root_1, stream_l3.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}

					}
					break;

			}

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "relationalExpression"


	public static class numericExpression_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "numericExpression"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:829:1: numericExpression : additiveExpression ;
	public final SparqlifyConfigParser.numericExpression_return numericExpression() throws RecognitionException {
		SparqlifyConfigParser.numericExpression_return retval = new SparqlifyConfigParser.numericExpression_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		ParserRuleReturnScope additiveExpression465 =null;


		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:830:5: ( additiveExpression )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:830:7: additiveExpression
			{
			root_0 = (CommonTree)adaptor.nil();


			pushFollow(FOLLOW_additiveExpression_in_numericExpression6003);
			additiveExpression465=additiveExpression();
			state._fsp--;

			adaptor.addChild(root_0, additiveExpression465.getTree());

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "numericExpression"


	public static class additiveExpression_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "additiveExpression"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:833:1: additiveExpression : (m1= multiplicativeExpression -> $m1) ( ( additiveOperator m2= multiplicativeExpression -> ^( additiveOperator $additiveExpression $m2) ) | (n1= numericLiteralPositive -> ^( PLUS $additiveExpression $n1) |n2= numericLiteralNegative -> ^( PLUS $additiveExpression $n2) ) ( ( ( ASTERISK u2= unaryExpression -> ^( ASTERISK $additiveExpression $u2) ) ) | ( ( DIVIDE u2= unaryExpression -> ^( DIVIDE $additiveExpression $u2) ) ) )? )* ;
	public final SparqlifyConfigParser.additiveExpression_return additiveExpression() throws RecognitionException {
		SparqlifyConfigParser.additiveExpression_return retval = new SparqlifyConfigParser.additiveExpression_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token ASTERISK467=null;
		Token DIVIDE468=null;
		ParserRuleReturnScope m1 =null;
		ParserRuleReturnScope m2 =null;
		ParserRuleReturnScope n1 =null;
		ParserRuleReturnScope n2 =null;
		ParserRuleReturnScope u2 =null;
		ParserRuleReturnScope additiveOperator466 =null;

		CommonTree ASTERISK467_tree=null;
		CommonTree DIVIDE468_tree=null;
		RewriteRuleTokenStream stream_ASTERISK=new RewriteRuleTokenStream(adaptor,"token ASTERISK");
		RewriteRuleTokenStream stream_DIVIDE=new RewriteRuleTokenStream(adaptor,"token DIVIDE");
		RewriteRuleSubtreeStream stream_unaryExpression=new RewriteRuleSubtreeStream(adaptor,"rule unaryExpression");
		RewriteRuleSubtreeStream stream_numericLiteralNegative=new RewriteRuleSubtreeStream(adaptor,"rule numericLiteralNegative");
		RewriteRuleSubtreeStream stream_numericLiteralPositive=new RewriteRuleSubtreeStream(adaptor,"rule numericLiteralPositive");
		RewriteRuleSubtreeStream stream_additiveOperator=new RewriteRuleSubtreeStream(adaptor,"rule additiveOperator");
		RewriteRuleSubtreeStream stream_multiplicativeExpression=new RewriteRuleSubtreeStream(adaptor,"rule multiplicativeExpression");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:834:5: ( (m1= multiplicativeExpression -> $m1) ( ( additiveOperator m2= multiplicativeExpression -> ^( additiveOperator $additiveExpression $m2) ) | (n1= numericLiteralPositive -> ^( PLUS $additiveExpression $n1) |n2= numericLiteralNegative -> ^( PLUS $additiveExpression $n2) ) ( ( ( ASTERISK u2= unaryExpression -> ^( ASTERISK $additiveExpression $u2) ) ) | ( ( DIVIDE u2= unaryExpression -> ^( DIVIDE $additiveExpression $u2) ) ) )? )* )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:834:7: (m1= multiplicativeExpression -> $m1) ( ( additiveOperator m2= multiplicativeExpression -> ^( additiveOperator $additiveExpression $m2) ) | (n1= numericLiteralPositive -> ^( PLUS $additiveExpression $n1) |n2= numericLiteralNegative -> ^( PLUS $additiveExpression $n2) ) ( ( ( ASTERISK u2= unaryExpression -> ^( ASTERISK $additiveExpression $u2) ) ) | ( ( DIVIDE u2= unaryExpression -> ^( DIVIDE $additiveExpression $u2) ) ) )? )*
			{
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:834:7: (m1= multiplicativeExpression -> $m1)
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:834:8: m1= multiplicativeExpression
			{
			pushFollow(FOLLOW_multiplicativeExpression_in_additiveExpression6023);
			m1=multiplicativeExpression();
			state._fsp--;

			stream_multiplicativeExpression.add(m1.getTree());
			// AST REWRITE
			// elements: m1
			// token labels: 
			// rule labels: retval, m1
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);
			RewriteRuleSubtreeStream stream_m1=new RewriteRuleSubtreeStream(adaptor,"rule m1",m1!=null?m1.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 834:36: -> $m1
			{
				adaptor.addChild(root_0, stream_m1.nextTree());
			}


			retval.tree = root_0;

			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:834:44: ( ( additiveOperator m2= multiplicativeExpression -> ^( additiveOperator $additiveExpression $m2) ) | (n1= numericLiteralPositive -> ^( PLUS $additiveExpression $n1) |n2= numericLiteralNegative -> ^( PLUS $additiveExpression $n2) ) ( ( ( ASTERISK u2= unaryExpression -> ^( ASTERISK $additiveExpression $u2) ) ) | ( ( DIVIDE u2= unaryExpression -> ^( DIVIDE $additiveExpression $u2) ) ) )? )*
			loop151:
			while (true) {
				int alt151=3;
				int LA151_0 = input.LA(1);
				if ( (LA151_0==MINUS||LA151_0==PLUS) ) {
					alt151=1;
				}
				else if ( ((LA151_0 >= DECIMAL_NEGATIVE && LA151_0 <= DECIMAL_POSITIVE)||(LA151_0 >= DOUBLE_NEGATIVE && LA151_0 <= DOUBLE_POSITIVE)||(LA151_0 >= INTEGER_NEGATIVE && LA151_0 <= INTEGER_POSITIVE)) ) {
					alt151=2;
				}

				switch (alt151) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:834:46: ( additiveOperator m2= multiplicativeExpression -> ^( additiveOperator $additiveExpression $m2) )
					{
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:834:46: ( additiveOperator m2= multiplicativeExpression -> ^( additiveOperator $additiveExpression $m2) )
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:834:47: additiveOperator m2= multiplicativeExpression
					{
					pushFollow(FOLLOW_additiveOperator_in_additiveExpression6034);
					additiveOperator466=additiveOperator();
					state._fsp--;

					stream_additiveOperator.add(additiveOperator466.getTree());
					pushFollow(FOLLOW_multiplicativeExpression_in_additiveExpression6038);
					m2=multiplicativeExpression();
					state._fsp--;

					stream_multiplicativeExpression.add(m2.getTree());
					// AST REWRITE
					// elements: additiveExpression, additiveOperator, m2
					// token labels: 
					// rule labels: retval, m2
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);
					RewriteRuleSubtreeStream stream_m2=new RewriteRuleSubtreeStream(adaptor,"rule m2",m2!=null?m2.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 834:92: -> ^( additiveOperator $additiveExpression $m2)
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:834:95: ^( additiveOperator $additiveExpression $m2)
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_additiveOperator.nextNode(), root_1);
						adaptor.addChild(root_1, stream_retval.nextTree());
						adaptor.addChild(root_1, stream_m2.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:835:48: (n1= numericLiteralPositive -> ^( PLUS $additiveExpression $n1) |n2= numericLiteralNegative -> ^( PLUS $additiveExpression $n2) ) ( ( ( ASTERISK u2= unaryExpression -> ^( ASTERISK $additiveExpression $u2) ) ) | ( ( DIVIDE u2= unaryExpression -> ^( DIVIDE $additiveExpression $u2) ) ) )?
					{
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:835:48: (n1= numericLiteralPositive -> ^( PLUS $additiveExpression $n1) |n2= numericLiteralNegative -> ^( PLUS $additiveExpression $n2) )
					int alt149=2;
					int LA149_0 = input.LA(1);
					if ( (LA149_0==DECIMAL_POSITIVE||LA149_0==DOUBLE_POSITIVE||LA149_0==INTEGER_POSITIVE) ) {
						alt149=1;
					}
					else if ( (LA149_0==DECIMAL_NEGATIVE||LA149_0==DOUBLE_NEGATIVE||LA149_0==INTEGER_NEGATIVE) ) {
						alt149=2;
					}

					else {
						NoViableAltException nvae =
							new NoViableAltException("", 149, 0, input);
						throw nvae;
					}

					switch (alt149) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:835:49: n1= numericLiteralPositive
							{
							pushFollow(FOLLOW_numericLiteralPositive_in_additiveExpression6105);
							n1=numericLiteralPositive();
							state._fsp--;

							stream_numericLiteralPositive.add(n1.getTree());
							// AST REWRITE
							// elements: additiveExpression, n1
							// token labels: 
							// rule labels: n1, retval
							// token list labels: 
							// rule list labels: 
							// wildcard labels: 
							retval.tree = root_0;
							RewriteRuleSubtreeStream stream_n1=new RewriteRuleSubtreeStream(adaptor,"rule n1",n1!=null?n1.getTree():null);
							RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

							root_0 = (CommonTree)adaptor.nil();
							// 835:75: -> ^( PLUS $additiveExpression $n1)
							{
								// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:835:78: ^( PLUS $additiveExpression $n1)
								{
								CommonTree root_1 = (CommonTree)adaptor.nil();
								root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(PLUS, "PLUS"), root_1);
								adaptor.addChild(root_1, stream_retval.nextTree());
								adaptor.addChild(root_1, stream_n1.nextTree());
								adaptor.addChild(root_0, root_1);
								}

							}


							retval.tree = root_0;

							}
							break;
						case 2 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:835:112: n2= numericLiteralNegative
							{
							pushFollow(FOLLOW_numericLiteralNegative_in_additiveExpression6123);
							n2=numericLiteralNegative();
							state._fsp--;

							stream_numericLiteralNegative.add(n2.getTree());
							// AST REWRITE
							// elements: n2, additiveExpression
							// token labels: 
							// rule labels: retval, n2
							// token list labels: 
							// rule list labels: 
							// wildcard labels: 
							retval.tree = root_0;
							RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);
							RewriteRuleSubtreeStream stream_n2=new RewriteRuleSubtreeStream(adaptor,"rule n2",n2!=null?n2.getTree():null);

							root_0 = (CommonTree)adaptor.nil();
							// 835:138: -> ^( PLUS $additiveExpression $n2)
							{
								// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:835:141: ^( PLUS $additiveExpression $n2)
								{
								CommonTree root_1 = (CommonTree)adaptor.nil();
								root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(PLUS, "PLUS"), root_1);
								adaptor.addChild(root_1, stream_retval.nextTree());
								adaptor.addChild(root_1, stream_n2.nextTree());
								adaptor.addChild(root_0, root_1);
								}

							}


							retval.tree = root_0;

							}
							break;

					}

					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:836:46: ( ( ( ASTERISK u2= unaryExpression -> ^( ASTERISK $additiveExpression $u2) ) ) | ( ( DIVIDE u2= unaryExpression -> ^( DIVIDE $additiveExpression $u2) ) ) )?
					int alt150=3;
					int LA150_0 = input.LA(1);
					if ( (LA150_0==ASTERISK) ) {
						alt150=1;
					}
					else if ( (LA150_0==DIVIDE) ) {
						alt150=2;
					}
					switch (alt150) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:836:48: ( ( ASTERISK u2= unaryExpression -> ^( ASTERISK $additiveExpression $u2) ) )
							{
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:836:48: ( ( ASTERISK u2= unaryExpression -> ^( ASTERISK $additiveExpression $u2) ) )
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:836:50: ( ASTERISK u2= unaryExpression -> ^( ASTERISK $additiveExpression $u2) )
							{
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:836:50: ( ASTERISK u2= unaryExpression -> ^( ASTERISK $additiveExpression $u2) )
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:836:51: ASTERISK u2= unaryExpression
							{
							ASTERISK467=(Token)match(input,ASTERISK,FOLLOW_ASTERISK_in_additiveExpression6190);  
							stream_ASTERISK.add(ASTERISK467);

							pushFollow(FOLLOW_unaryExpression_in_additiveExpression6194);
							u2=unaryExpression();
							state._fsp--;

							stream_unaryExpression.add(u2.getTree());
							// AST REWRITE
							// elements: u2, additiveExpression, ASTERISK
							// token labels: 
							// rule labels: retval, u2
							// token list labels: 
							// rule list labels: 
							// wildcard labels: 
							retval.tree = root_0;
							RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);
							RewriteRuleSubtreeStream stream_u2=new RewriteRuleSubtreeStream(adaptor,"rule u2",u2!=null?u2.getTree():null);

							root_0 = (CommonTree)adaptor.nil();
							// 836:79: -> ^( ASTERISK $additiveExpression $u2)
							{
								// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:836:82: ^( ASTERISK $additiveExpression $u2)
								{
								CommonTree root_1 = (CommonTree)adaptor.nil();
								root_1 = (CommonTree)adaptor.becomeRoot(stream_ASTERISK.nextNode(), root_1);
								adaptor.addChild(root_1, stream_retval.nextTree());
								adaptor.addChild(root_1, stream_u2.nextTree());
								adaptor.addChild(root_0, root_1);
								}

							}


							retval.tree = root_0;

							}

							}

							}
							break;
						case 2 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:837:48: ( ( DIVIDE u2= unaryExpression -> ^( DIVIDE $additiveExpression $u2) ) )
							{
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:837:48: ( ( DIVIDE u2= unaryExpression -> ^( DIVIDE $additiveExpression $u2) ) )
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:837:50: ( DIVIDE u2= unaryExpression -> ^( DIVIDE $additiveExpression $u2) )
							{
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:837:50: ( DIVIDE u2= unaryExpression -> ^( DIVIDE $additiveExpression $u2) )
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:837:51: DIVIDE u2= unaryExpression
							{
							DIVIDE468=(Token)match(input,DIVIDE,FOLLOW_DIVIDE_in_additiveExpression6262);  
							stream_DIVIDE.add(DIVIDE468);

							pushFollow(FOLLOW_unaryExpression_in_additiveExpression6266);
							u2=unaryExpression();
							state._fsp--;

							stream_unaryExpression.add(u2.getTree());
							// AST REWRITE
							// elements: u2, additiveExpression, DIVIDE
							// token labels: 
							// rule labels: retval, u2
							// token list labels: 
							// rule list labels: 
							// wildcard labels: 
							retval.tree = root_0;
							RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);
							RewriteRuleSubtreeStream stream_u2=new RewriteRuleSubtreeStream(adaptor,"rule u2",u2!=null?u2.getTree():null);

							root_0 = (CommonTree)adaptor.nil();
							// 837:77: -> ^( DIVIDE $additiveExpression $u2)
							{
								// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:837:80: ^( DIVIDE $additiveExpression $u2)
								{
								CommonTree root_1 = (CommonTree)adaptor.nil();
								root_1 = (CommonTree)adaptor.becomeRoot(stream_DIVIDE.nextNode(), root_1);
								adaptor.addChild(root_1, stream_retval.nextTree());
								adaptor.addChild(root_1, stream_u2.nextTree());
								adaptor.addChild(root_0, root_1);
								}

							}


							retval.tree = root_0;

							}

							}

							}
							break;

					}

					}
					break;

				default :
					break loop151;
				}
			}

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "additiveExpression"


	public static class additiveOperator_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "additiveOperator"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:840:1: additiveOperator : ( PLUS | MINUS );
	public final SparqlifyConfigParser.additiveOperator_return additiveOperator() throws RecognitionException {
		SparqlifyConfigParser.additiveOperator_return retval = new SparqlifyConfigParser.additiveOperator_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token set469=null;

		CommonTree set469_tree=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:841:5: ( PLUS | MINUS )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:
			{
			root_0 = (CommonTree)adaptor.nil();


			set469=input.LT(1);
			if ( input.LA(1)==MINUS||input.LA(1)==PLUS ) {
				input.consume();
				adaptor.addChild(root_0, (CommonTree)adaptor.create(set469));
				state.errorRecovery=false;
			}
			else {
				MismatchedSetException mse = new MismatchedSetException(null,input);
				throw mse;
			}
			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "additiveOperator"


	public static class multiplicativeExpression_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "multiplicativeExpression"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:844:1: multiplicativeExpression : (u1= unaryExpression -> $u1) ( multiplicativeOperator u2= unaryExpression -> ^( multiplicativeOperator $multiplicativeExpression $u2) )* ;
	public final SparqlifyConfigParser.multiplicativeExpression_return multiplicativeExpression() throws RecognitionException {
		SparqlifyConfigParser.multiplicativeExpression_return retval = new SparqlifyConfigParser.multiplicativeExpression_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		ParserRuleReturnScope u1 =null;
		ParserRuleReturnScope u2 =null;
		ParserRuleReturnScope multiplicativeOperator470 =null;

		RewriteRuleSubtreeStream stream_multiplicativeOperator=new RewriteRuleSubtreeStream(adaptor,"rule multiplicativeOperator");
		RewriteRuleSubtreeStream stream_unaryExpression=new RewriteRuleSubtreeStream(adaptor,"rule unaryExpression");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:845:5: ( (u1= unaryExpression -> $u1) ( multiplicativeOperator u2= unaryExpression -> ^( multiplicativeOperator $multiplicativeExpression $u2) )* )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:845:7: (u1= unaryExpression -> $u1) ( multiplicativeOperator u2= unaryExpression -> ^( multiplicativeOperator $multiplicativeExpression $u2) )*
			{
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:845:7: (u1= unaryExpression -> $u1)
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:845:8: u1= unaryExpression
			{
			pushFollow(FOLLOW_unaryExpression_in_multiplicativeExpression6334);
			u1=unaryExpression();
			state._fsp--;

			stream_unaryExpression.add(u1.getTree());
			// AST REWRITE
			// elements: u1
			// token labels: 
			// rule labels: retval, u1
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);
			RewriteRuleSubtreeStream stream_u1=new RewriteRuleSubtreeStream(adaptor,"rule u1",u1!=null?u1.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 845:27: -> $u1
			{
				adaptor.addChild(root_0, stream_u1.nextTree());
			}


			retval.tree = root_0;

			}

			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:845:35: ( multiplicativeOperator u2= unaryExpression -> ^( multiplicativeOperator $multiplicativeExpression $u2) )*
			loop152:
			while (true) {
				int alt152=2;
				int LA152_0 = input.LA(1);
				if ( (LA152_0==ASTERISK||LA152_0==DIVIDE) ) {
					alt152=1;
				}

				switch (alt152) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:845:36: multiplicativeOperator u2= unaryExpression
					{
					pushFollow(FOLLOW_multiplicativeOperator_in_multiplicativeExpression6343);
					multiplicativeOperator470=multiplicativeOperator();
					state._fsp--;

					stream_multiplicativeOperator.add(multiplicativeOperator470.getTree());
					pushFollow(FOLLOW_unaryExpression_in_multiplicativeExpression6347);
					u2=unaryExpression();
					state._fsp--;

					stream_unaryExpression.add(u2.getTree());
					// AST REWRITE
					// elements: u2, multiplicativeOperator, multiplicativeExpression
					// token labels: 
					// rule labels: retval, u2
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);
					RewriteRuleSubtreeStream stream_u2=new RewriteRuleSubtreeStream(adaptor,"rule u2",u2!=null?u2.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 845:78: -> ^( multiplicativeOperator $multiplicativeExpression $u2)
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:845:81: ^( multiplicativeOperator $multiplicativeExpression $u2)
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_multiplicativeOperator.nextNode(), root_1);
						adaptor.addChild(root_1, stream_retval.nextTree());
						adaptor.addChild(root_1, stream_u2.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;

				default :
					break loop152;
				}
			}

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "multiplicativeExpression"


	public static class multiplicativeOperator_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "multiplicativeOperator"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:848:1: multiplicativeOperator : ( ASTERISK | DIVIDE );
	public final SparqlifyConfigParser.multiplicativeOperator_return multiplicativeOperator() throws RecognitionException {
		SparqlifyConfigParser.multiplicativeOperator_return retval = new SparqlifyConfigParser.multiplicativeOperator_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token set471=null;

		CommonTree set471_tree=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:849:5: ( ASTERISK | DIVIDE )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:
			{
			root_0 = (CommonTree)adaptor.nil();


			set471=input.LT(1);
			if ( input.LA(1)==ASTERISK||input.LA(1)==DIVIDE ) {
				input.consume();
				adaptor.addChild(root_0, (CommonTree)adaptor.create(set471));
				state.errorRecovery=false;
			}
			else {
				MismatchedSetException mse = new MismatchedSetException(null,input);
				throw mse;
			}
			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "multiplicativeOperator"


	public static class unaryExpression_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "unaryExpression"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:852:1: unaryExpression : (op= NEGATION primaryExpression -> ^( UNARY_NOT[$op] primaryExpression ) |op= PLUS primaryExpression -> ^( UNARY_PLUS[$op] primaryExpression ) |op= MINUS primaryExpression -> ^( UNARY_MINUS[$op] primaryExpression ) | primaryExpression -> ^( UNARY primaryExpression ) );
	public final SparqlifyConfigParser.unaryExpression_return unaryExpression() throws RecognitionException {
		SparqlifyConfigParser.unaryExpression_return retval = new SparqlifyConfigParser.unaryExpression_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token op=null;
		ParserRuleReturnScope primaryExpression472 =null;
		ParserRuleReturnScope primaryExpression473 =null;
		ParserRuleReturnScope primaryExpression474 =null;
		ParserRuleReturnScope primaryExpression475 =null;

		CommonTree op_tree=null;
		RewriteRuleTokenStream stream_PLUS=new RewriteRuleTokenStream(adaptor,"token PLUS");
		RewriteRuleTokenStream stream_NEGATION=new RewriteRuleTokenStream(adaptor,"token NEGATION");
		RewriteRuleTokenStream stream_MINUS=new RewriteRuleTokenStream(adaptor,"token MINUS");
		RewriteRuleSubtreeStream stream_primaryExpression=new RewriteRuleSubtreeStream(adaptor,"rule primaryExpression");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:853:5: (op= NEGATION primaryExpression -> ^( UNARY_NOT[$op] primaryExpression ) |op= PLUS primaryExpression -> ^( UNARY_PLUS[$op] primaryExpression ) |op= MINUS primaryExpression -> ^( UNARY_MINUS[$op] primaryExpression ) | primaryExpression -> ^( UNARY primaryExpression ) )
			int alt153=4;
			switch ( input.LA(1) ) {
			case NEGATION:
				{
				alt153=1;
				}
				break;
			case PLUS:
				{
				alt153=2;
				}
				break;
			case MINUS:
				{
				alt153=3;
				}
				break;
			case ABS:
			case AVG:
			case BNODE:
			case BOUND:
			case CEIL:
			case COALESCE:
			case CONCAT:
			case CONTAINS:
			case COUNT:
			case DATATYPE:
			case DAY:
			case DECIMAL:
			case DECIMAL_NEGATIVE:
			case DECIMAL_POSITIVE:
			case DOUBLE:
			case DOUBLE_NEGATIVE:
			case DOUBLE_POSITIVE:
			case ENCODE_FOR_URI:
			case EXISTS:
			case FALSE:
			case FLOOR:
			case GROUP_CONCAT:
			case HOURS:
			case IF:
			case INTEGER:
			case INTEGER_NEGATIVE:
			case INTEGER_POSITIVE:
			case IRI:
			case IRI_REF:
			case ISBLANK:
			case ISIRI:
			case ISLITERAL:
			case ISNUMERIC:
			case ISURI:
			case LANG:
			case LANGMATCHES:
			case LCASE:
			case MAX:
			case MD5:
			case MIN:
			case MINUTES:
			case MONTH:
			case NAME:
			case NOT:
			case NOW:
			case OPEN_BRACE:
			case PNAME_LN:
			case PNAME_NS:
			case RAND:
			case REGEX:
			case ROUND:
			case SAMETERM:
			case SAMPLE:
			case SECONDS:
			case SHA1:
			case SHA224:
			case SHA256:
			case SHA384:
			case SHA512:
			case STR:
			case STRDT:
			case STRENDS:
			case STRING_LITERAL1:
			case STRING_LITERAL2:
			case STRING_LITERAL_LONG1:
			case STRING_LITERAL_LONG2:
			case STRLANG:
			case STRLEN:
			case STRSTARTS:
			case SUBSTR:
			case SUM:
			case TIMEZONE:
			case TRUE:
			case TZ:
			case UCASE:
			case URI:
			case VAR1:
			case VAR2:
			case VAR3:
			case YEAR:
				{
				alt153=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 153, 0, input);
				throw nvae;
			}
			switch (alt153) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:853:7: op= NEGATION primaryExpression
					{
					op=(Token)match(input,NEGATION,FOLLOW_NEGATION_in_unaryExpression6405);  
					stream_NEGATION.add(op);

					pushFollow(FOLLOW_primaryExpression_in_unaryExpression6407);
					primaryExpression472=primaryExpression();
					state._fsp--;

					stream_primaryExpression.add(primaryExpression472.getTree());
					// AST REWRITE
					// elements: primaryExpression
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 853:37: -> ^( UNARY_NOT[$op] primaryExpression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:853:40: ^( UNARY_NOT[$op] primaryExpression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(UNARY_NOT, op), root_1);
						adaptor.addChild(root_1, stream_primaryExpression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:854:7: op= PLUS primaryExpression
					{
					op=(Token)match(input,PLUS,FOLLOW_PLUS_in_unaryExpression6426);  
					stream_PLUS.add(op);

					pushFollow(FOLLOW_primaryExpression_in_unaryExpression6428);
					primaryExpression473=primaryExpression();
					state._fsp--;

					stream_primaryExpression.add(primaryExpression473.getTree());
					// AST REWRITE
					// elements: primaryExpression
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 854:33: -> ^( UNARY_PLUS[$op] primaryExpression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:854:36: ^( UNARY_PLUS[$op] primaryExpression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(UNARY_PLUS, op), root_1);
						adaptor.addChild(root_1, stream_primaryExpression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:855:7: op= MINUS primaryExpression
					{
					op=(Token)match(input,MINUS,FOLLOW_MINUS_in_unaryExpression6447);  
					stream_MINUS.add(op);

					pushFollow(FOLLOW_primaryExpression_in_unaryExpression6449);
					primaryExpression474=primaryExpression();
					state._fsp--;

					stream_primaryExpression.add(primaryExpression474.getTree());
					// AST REWRITE
					// elements: primaryExpression
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 855:34: -> ^( UNARY_MINUS[$op] primaryExpression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:855:37: ^( UNARY_MINUS[$op] primaryExpression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(UNARY_MINUS, op), root_1);
						adaptor.addChild(root_1, stream_primaryExpression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:857:7: primaryExpression
					{
					pushFollow(FOLLOW_primaryExpression_in_unaryExpression6467);
					primaryExpression475=primaryExpression();
					state._fsp--;

					stream_primaryExpression.add(primaryExpression475.getTree());
					// AST REWRITE
					// elements: primaryExpression
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 857:25: -> ^( UNARY primaryExpression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:857:28: ^( UNARY primaryExpression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(UNARY, "UNARY"), root_1);
						adaptor.addChild(root_1, stream_primaryExpression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "unaryExpression"


	public static class primaryExpression_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "primaryExpression"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:860:1: primaryExpression : ( brackettedExpression | builtInCall | iriRefOrFunction | rdfLiteral | numericLiteral | booleanLiteral | var | aggregate | aliasedVar );
	public final SparqlifyConfigParser.primaryExpression_return primaryExpression() throws RecognitionException {
		SparqlifyConfigParser.primaryExpression_return retval = new SparqlifyConfigParser.primaryExpression_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		ParserRuleReturnScope brackettedExpression476 =null;
		ParserRuleReturnScope builtInCall477 =null;
		ParserRuleReturnScope iriRefOrFunction478 =null;
		ParserRuleReturnScope rdfLiteral479 =null;
		ParserRuleReturnScope numericLiteral480 =null;
		ParserRuleReturnScope booleanLiteral481 =null;
		ParserRuleReturnScope var482 =null;
		ParserRuleReturnScope aggregate483 =null;
		ParserRuleReturnScope aliasedVar484 =null;


		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:861:5: ( brackettedExpression | builtInCall | iriRefOrFunction | rdfLiteral | numericLiteral | booleanLiteral | var | aggregate | aliasedVar )
			int alt154=9;
			switch ( input.LA(1) ) {
			case OPEN_BRACE:
				{
				alt154=1;
				}
				break;
			case ABS:
			case BNODE:
			case BOUND:
			case CEIL:
			case COALESCE:
			case CONCAT:
			case CONTAINS:
			case DATATYPE:
			case DAY:
			case ENCODE_FOR_URI:
			case EXISTS:
			case FLOOR:
			case HOURS:
			case IF:
			case IRI:
			case ISBLANK:
			case ISIRI:
			case ISLITERAL:
			case ISNUMERIC:
			case ISURI:
			case LANG:
			case LANGMATCHES:
			case LCASE:
			case MD5:
			case MINUTES:
			case MONTH:
			case NOT:
			case NOW:
			case RAND:
			case REGEX:
			case ROUND:
			case SAMETERM:
			case SECONDS:
			case SHA1:
			case SHA224:
			case SHA256:
			case SHA384:
			case SHA512:
			case STR:
			case STRDT:
			case STRENDS:
			case STRLANG:
			case STRLEN:
			case STRSTARTS:
			case SUBSTR:
			case TIMEZONE:
			case TZ:
			case UCASE:
			case URI:
			case YEAR:
				{
				alt154=2;
				}
				break;
			case IRI_REF:
			case PNAME_LN:
			case PNAME_NS:
				{
				alt154=3;
				}
				break;
			case STRING_LITERAL1:
			case STRING_LITERAL2:
			case STRING_LITERAL_LONG1:
			case STRING_LITERAL_LONG2:
				{
				alt154=4;
				}
				break;
			case DECIMAL:
			case DECIMAL_NEGATIVE:
			case DECIMAL_POSITIVE:
			case DOUBLE:
			case DOUBLE_NEGATIVE:
			case DOUBLE_POSITIVE:
			case INTEGER:
			case INTEGER_NEGATIVE:
			case INTEGER_POSITIVE:
				{
				alt154=5;
				}
				break;
			case FALSE:
			case TRUE:
				{
				alt154=6;
				}
				break;
			case VAR1:
			case VAR2:
			case VAR3:
				{
				alt154=7;
				}
				break;
			case AVG:
			case COUNT:
			case GROUP_CONCAT:
			case MAX:
			case MIN:
			case SAMPLE:
			case SUM:
				{
				alt154=8;
				}
				break;
			case NAME:
				{
				alt154=9;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 154, 0, input);
				throw nvae;
			}
			switch (alt154) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:861:7: brackettedExpression
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_brackettedExpression_in_primaryExpression6492);
					brackettedExpression476=brackettedExpression();
					state._fsp--;

					adaptor.addChild(root_0, brackettedExpression476.getTree());

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:861:30: builtInCall
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_builtInCall_in_primaryExpression6496);
					builtInCall477=builtInCall();
					state._fsp--;

					adaptor.addChild(root_0, builtInCall477.getTree());

					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:861:44: iriRefOrFunction
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_iriRefOrFunction_in_primaryExpression6500);
					iriRefOrFunction478=iriRefOrFunction();
					state._fsp--;

					adaptor.addChild(root_0, iriRefOrFunction478.getTree());

					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:861:63: rdfLiteral
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_rdfLiteral_in_primaryExpression6504);
					rdfLiteral479=rdfLiteral();
					state._fsp--;

					adaptor.addChild(root_0, rdfLiteral479.getTree());

					}
					break;
				case 5 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:861:76: numericLiteral
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_numericLiteral_in_primaryExpression6508);
					numericLiteral480=numericLiteral();
					state._fsp--;

					adaptor.addChild(root_0, numericLiteral480.getTree());

					}
					break;
				case 6 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:861:93: booleanLiteral
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_booleanLiteral_in_primaryExpression6512);
					booleanLiteral481=booleanLiteral();
					state._fsp--;

					adaptor.addChild(root_0, booleanLiteral481.getTree());

					}
					break;
				case 7 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:861:110: var
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_var_in_primaryExpression6516);
					var482=var();
					state._fsp--;

					adaptor.addChild(root_0, var482.getTree());

					}
					break;
				case 8 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:861:116: aggregate
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_aggregate_in_primaryExpression6520);
					aggregate483=aggregate();
					state._fsp--;

					adaptor.addChild(root_0, aggregate483.getTree());

					}
					break;
				case 9 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:862:4: aliasedVar
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_aliasedVar_in_primaryExpression6525);
					aliasedVar484=aliasedVar();
					state._fsp--;

					adaptor.addChild(root_0, aliasedVar484.getTree());

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "primaryExpression"


	public static class aliasedVar_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "aliasedVar"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:866:1: aliasedVar : a= NAME DOT b= NAME -> ^( ALIASED_VAR $a $b) ;
	public final SparqlifyConfigParser.aliasedVar_return aliasedVar() throws RecognitionException {
		SparqlifyConfigParser.aliasedVar_return retval = new SparqlifyConfigParser.aliasedVar_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token a=null;
		Token b=null;
		Token DOT485=null;

		CommonTree a_tree=null;
		CommonTree b_tree=null;
		CommonTree DOT485_tree=null;
		RewriteRuleTokenStream stream_NAME=new RewriteRuleTokenStream(adaptor,"token NAME");
		RewriteRuleTokenStream stream_DOT=new RewriteRuleTokenStream(adaptor,"token DOT");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:867:5: (a= NAME DOT b= NAME -> ^( ALIASED_VAR $a $b) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:867:7: a= NAME DOT b= NAME
			{
			a=(Token)match(input,NAME,FOLLOW_NAME_in_aliasedVar6545);  
			stream_NAME.add(a);

			DOT485=(Token)match(input,DOT,FOLLOW_DOT_in_aliasedVar6547);  
			stream_DOT.add(DOT485);

			b=(Token)match(input,NAME,FOLLOW_NAME_in_aliasedVar6551);  
			stream_NAME.add(b);

			// AST REWRITE
			// elements: a, b
			// token labels: b, a
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleTokenStream stream_b=new RewriteRuleTokenStream(adaptor,"token b",b);
			RewriteRuleTokenStream stream_a=new RewriteRuleTokenStream(adaptor,"token a",a);
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 867:25: -> ^( ALIASED_VAR $a $b)
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:867:28: ^( ALIASED_VAR $a $b)
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(ALIASED_VAR, "ALIASED_VAR"), root_1);
				adaptor.addChild(root_1, stream_a.nextNode());
				adaptor.addChild(root_1, stream_b.nextNode());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "aliasedVar"


	public static class brackettedExpression_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "brackettedExpression"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:870:1: brackettedExpression : OPEN_BRACE expression CLOSE_BRACE -> expression ;
	public final SparqlifyConfigParser.brackettedExpression_return brackettedExpression() throws RecognitionException {
		SparqlifyConfigParser.brackettedExpression_return retval = new SparqlifyConfigParser.brackettedExpression_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token OPEN_BRACE486=null;
		Token CLOSE_BRACE488=null;
		ParserRuleReturnScope expression487 =null;

		CommonTree OPEN_BRACE486_tree=null;
		CommonTree CLOSE_BRACE488_tree=null;
		RewriteRuleTokenStream stream_CLOSE_BRACE=new RewriteRuleTokenStream(adaptor,"token CLOSE_BRACE");
		RewriteRuleTokenStream stream_OPEN_BRACE=new RewriteRuleTokenStream(adaptor,"token OPEN_BRACE");
		RewriteRuleSubtreeStream stream_expression=new RewriteRuleSubtreeStream(adaptor,"rule expression");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:871:5: ( OPEN_BRACE expression CLOSE_BRACE -> expression )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:871:7: OPEN_BRACE expression CLOSE_BRACE
			{
			OPEN_BRACE486=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_brackettedExpression6580);  
			stream_OPEN_BRACE.add(OPEN_BRACE486);

			pushFollow(FOLLOW_expression_in_brackettedExpression6582);
			expression487=expression();
			state._fsp--;

			stream_expression.add(expression487.getTree());
			CLOSE_BRACE488=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_brackettedExpression6584);  
			stream_CLOSE_BRACE.add(CLOSE_BRACE488);

			// AST REWRITE
			// elements: expression
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 871:41: -> expression
			{
				adaptor.addChild(root_0, stream_expression.nextTree());
			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "brackettedExpression"


	public static class builtInCall_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "builtInCall"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:874:1: builtInCall : ( STR OPEN_BRACE expression CLOSE_BRACE -> ^( STR expression ) | LANG OPEN_BRACE expression CLOSE_BRACE -> ^( LANG expression ) | LANGMATCHES OPEN_BRACE expression COMMA expression CLOSE_BRACE -> ^( LANGMATCHES ( expression )+ ) | DATATYPE OPEN_BRACE expression CLOSE_BRACE -> ^( DATATYPE expression ) | BOUND OPEN_BRACE var CLOSE_BRACE -> ^( BOUND var ) | IRI OPEN_BRACE expression CLOSE_BRACE -> ^( IRI expression ) | URI OPEN_BRACE expression CLOSE_BRACE -> ^( URI expression ) | BNODE ( OPEN_BRACE expression CLOSE_BRACE | nil ) -> ^( BNODE expression ) | RAND nil -> RAND | ABS OPEN_BRACE expression CLOSE_BRACE -> ^( ABS expression ) | CEIL OPEN_BRACE expression CLOSE_BRACE -> ^( CEIL expression ) | FLOOR OPEN_BRACE expression CLOSE_BRACE -> ^( FLOOR expression ) | ROUND OPEN_BRACE expression CLOSE_BRACE -> ^( ROUND expression ) | CONCAT expressionList -> ^( CONCAT expressionList ) | subStringExpression -> subStringExpression | STRLEN OPEN_BRACE expression CLOSE_BRACE -> ^( STRLEN expression ) | UCASE OPEN_BRACE expression CLOSE_BRACE -> ^( UCASE expression ) | LCASE OPEN_BRACE expression CLOSE_BRACE -> ^( LCASE expression ) | ENCODE_FOR_URI OPEN_BRACE expression CLOSE_BRACE -> ^( ENCODE_FOR_URI expression ) | CONTAINS OPEN_BRACE expression CLOSE_BRACE -> ^( CONTAINS expression ) | STRSTARTS OPEN_BRACE expression CLOSE_BRACE -> ^( STRSTARTS expression ) | STRENDS OPEN_BRACE expression CLOSE_BRACE -> ^( STRENDS expression ) | YEAR OPEN_BRACE expression CLOSE_BRACE -> ^( YEAR expression ) | MONTH OPEN_BRACE expression CLOSE_BRACE -> ^( MONTH expression ) | DAY OPEN_BRACE expression CLOSE_BRACE -> ^( DAY expression ) | HOURS OPEN_BRACE expression CLOSE_BRACE -> ^( HOURS expression ) | MINUTES OPEN_BRACE expression CLOSE_BRACE -> ^( MINUTES expression ) | SECONDS OPEN_BRACE expression CLOSE_BRACE -> ^( SECONDS expression ) | TIMEZONE OPEN_BRACE expression CLOSE_BRACE -> ^( TIMEZONE expression ) | TZ OPEN_BRACE expression CLOSE_BRACE -> ^( TZ expression ) | NOW nil -> NOW | MD5 OPEN_BRACE expression CLOSE_BRACE -> ^( MD5 expression ) | SHA1 OPEN_BRACE expression CLOSE_BRACE -> ^( SHA1 expression ) | SHA224 OPEN_BRACE expression CLOSE_BRACE -> ^( SHA224 expression ) | SHA256 OPEN_BRACE expression CLOSE_BRACE -> ^( SHA256 expression ) | SHA384 OPEN_BRACE expression CLOSE_BRACE -> ^( SHA384 expression ) | SHA512 OPEN_BRACE expression CLOSE_BRACE -> ^( SHA512 expression ) | COALESCE expressionList -> ^( COALESCE expressionList ) | IF OPEN_BRACE e1= expression COMMA e2= expression COMMA e3= expression CLOSE_BRACE -> ^( IF $e1 $e2 $e3) | STRLANG OPEN_BRACE expression COMMA expression CLOSE_BRACE -> ^( STRLANG expression expression ) | STRDT OPEN_BRACE expression COMMA expression CLOSE_BRACE -> ^( STRDT expression expression ) | SAMETERM OPEN_BRACE expression COMMA expression CLOSE_BRACE -> ^( SAMETERM expression expression ) | ISIRI OPEN_BRACE expression CLOSE_BRACE -> ^( ISIRI expression ) | ISURI OPEN_BRACE expression CLOSE_BRACE -> ^( ISURI expression ) | ISBLANK OPEN_BRACE expression CLOSE_BRACE -> ^( ISBLANK expression ) | ISLITERAL OPEN_BRACE expression CLOSE_BRACE -> ^( ISLITERAL expression ) | ISNUMERIC OPEN_BRACE expression CLOSE_BRACE -> ^( ISNUMERIC expression ) | regexExpression -> regexExpression | existsFunction -> existsFunction | notExistsFunction -> notExistsFunction );
	public final SparqlifyConfigParser.builtInCall_return builtInCall() throws RecognitionException {
		SparqlifyConfigParser.builtInCall_return retval = new SparqlifyConfigParser.builtInCall_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token STR489=null;
		Token OPEN_BRACE490=null;
		Token CLOSE_BRACE492=null;
		Token LANG493=null;
		Token OPEN_BRACE494=null;
		Token CLOSE_BRACE496=null;
		Token LANGMATCHES497=null;
		Token OPEN_BRACE498=null;
		Token COMMA500=null;
		Token CLOSE_BRACE502=null;
		Token DATATYPE503=null;
		Token OPEN_BRACE504=null;
		Token CLOSE_BRACE506=null;
		Token BOUND507=null;
		Token OPEN_BRACE508=null;
		Token CLOSE_BRACE510=null;
		Token IRI511=null;
		Token OPEN_BRACE512=null;
		Token CLOSE_BRACE514=null;
		Token URI515=null;
		Token OPEN_BRACE516=null;
		Token CLOSE_BRACE518=null;
		Token BNODE519=null;
		Token OPEN_BRACE520=null;
		Token CLOSE_BRACE522=null;
		Token RAND524=null;
		Token ABS526=null;
		Token OPEN_BRACE527=null;
		Token CLOSE_BRACE529=null;
		Token CEIL530=null;
		Token OPEN_BRACE531=null;
		Token CLOSE_BRACE533=null;
		Token FLOOR534=null;
		Token OPEN_BRACE535=null;
		Token CLOSE_BRACE537=null;
		Token ROUND538=null;
		Token OPEN_BRACE539=null;
		Token CLOSE_BRACE541=null;
		Token CONCAT542=null;
		Token STRLEN545=null;
		Token OPEN_BRACE546=null;
		Token CLOSE_BRACE548=null;
		Token UCASE549=null;
		Token OPEN_BRACE550=null;
		Token CLOSE_BRACE552=null;
		Token LCASE553=null;
		Token OPEN_BRACE554=null;
		Token CLOSE_BRACE556=null;
		Token ENCODE_FOR_URI557=null;
		Token OPEN_BRACE558=null;
		Token CLOSE_BRACE560=null;
		Token CONTAINS561=null;
		Token OPEN_BRACE562=null;
		Token CLOSE_BRACE564=null;
		Token STRSTARTS565=null;
		Token OPEN_BRACE566=null;
		Token CLOSE_BRACE568=null;
		Token STRENDS569=null;
		Token OPEN_BRACE570=null;
		Token CLOSE_BRACE572=null;
		Token YEAR573=null;
		Token OPEN_BRACE574=null;
		Token CLOSE_BRACE576=null;
		Token MONTH577=null;
		Token OPEN_BRACE578=null;
		Token CLOSE_BRACE580=null;
		Token DAY581=null;
		Token OPEN_BRACE582=null;
		Token CLOSE_BRACE584=null;
		Token HOURS585=null;
		Token OPEN_BRACE586=null;
		Token CLOSE_BRACE588=null;
		Token MINUTES589=null;
		Token OPEN_BRACE590=null;
		Token CLOSE_BRACE592=null;
		Token SECONDS593=null;
		Token OPEN_BRACE594=null;
		Token CLOSE_BRACE596=null;
		Token TIMEZONE597=null;
		Token OPEN_BRACE598=null;
		Token CLOSE_BRACE600=null;
		Token TZ601=null;
		Token OPEN_BRACE602=null;
		Token CLOSE_BRACE604=null;
		Token NOW605=null;
		Token MD5607=null;
		Token OPEN_BRACE608=null;
		Token CLOSE_BRACE610=null;
		Token SHA1611=null;
		Token OPEN_BRACE612=null;
		Token CLOSE_BRACE614=null;
		Token SHA224615=null;
		Token OPEN_BRACE616=null;
		Token CLOSE_BRACE618=null;
		Token SHA256619=null;
		Token OPEN_BRACE620=null;
		Token CLOSE_BRACE622=null;
		Token SHA384623=null;
		Token OPEN_BRACE624=null;
		Token CLOSE_BRACE626=null;
		Token SHA512627=null;
		Token OPEN_BRACE628=null;
		Token CLOSE_BRACE630=null;
		Token COALESCE631=null;
		Token IF633=null;
		Token OPEN_BRACE634=null;
		Token COMMA635=null;
		Token COMMA636=null;
		Token CLOSE_BRACE637=null;
		Token STRLANG638=null;
		Token OPEN_BRACE639=null;
		Token COMMA641=null;
		Token CLOSE_BRACE643=null;
		Token STRDT644=null;
		Token OPEN_BRACE645=null;
		Token COMMA647=null;
		Token CLOSE_BRACE649=null;
		Token SAMETERM650=null;
		Token OPEN_BRACE651=null;
		Token COMMA653=null;
		Token CLOSE_BRACE655=null;
		Token ISIRI656=null;
		Token OPEN_BRACE657=null;
		Token CLOSE_BRACE659=null;
		Token ISURI660=null;
		Token OPEN_BRACE661=null;
		Token CLOSE_BRACE663=null;
		Token ISBLANK664=null;
		Token OPEN_BRACE665=null;
		Token CLOSE_BRACE667=null;
		Token ISLITERAL668=null;
		Token OPEN_BRACE669=null;
		Token CLOSE_BRACE671=null;
		Token ISNUMERIC672=null;
		Token OPEN_BRACE673=null;
		Token CLOSE_BRACE675=null;
		ParserRuleReturnScope e1 =null;
		ParserRuleReturnScope e2 =null;
		ParserRuleReturnScope e3 =null;
		ParserRuleReturnScope expression491 =null;
		ParserRuleReturnScope expression495 =null;
		ParserRuleReturnScope expression499 =null;
		ParserRuleReturnScope expression501 =null;
		ParserRuleReturnScope expression505 =null;
		ParserRuleReturnScope var509 =null;
		ParserRuleReturnScope expression513 =null;
		ParserRuleReturnScope expression517 =null;
		ParserRuleReturnScope expression521 =null;
		ParserRuleReturnScope nil523 =null;
		ParserRuleReturnScope nil525 =null;
		ParserRuleReturnScope expression528 =null;
		ParserRuleReturnScope expression532 =null;
		ParserRuleReturnScope expression536 =null;
		ParserRuleReturnScope expression540 =null;
		ParserRuleReturnScope expressionList543 =null;
		ParserRuleReturnScope subStringExpression544 =null;
		ParserRuleReturnScope expression547 =null;
		ParserRuleReturnScope expression551 =null;
		ParserRuleReturnScope expression555 =null;
		ParserRuleReturnScope expression559 =null;
		ParserRuleReturnScope expression563 =null;
		ParserRuleReturnScope expression567 =null;
		ParserRuleReturnScope expression571 =null;
		ParserRuleReturnScope expression575 =null;
		ParserRuleReturnScope expression579 =null;
		ParserRuleReturnScope expression583 =null;
		ParserRuleReturnScope expression587 =null;
		ParserRuleReturnScope expression591 =null;
		ParserRuleReturnScope expression595 =null;
		ParserRuleReturnScope expression599 =null;
		ParserRuleReturnScope expression603 =null;
		ParserRuleReturnScope nil606 =null;
		ParserRuleReturnScope expression609 =null;
		ParserRuleReturnScope expression613 =null;
		ParserRuleReturnScope expression617 =null;
		ParserRuleReturnScope expression621 =null;
		ParserRuleReturnScope expression625 =null;
		ParserRuleReturnScope expression629 =null;
		ParserRuleReturnScope expressionList632 =null;
		ParserRuleReturnScope expression640 =null;
		ParserRuleReturnScope expression642 =null;
		ParserRuleReturnScope expression646 =null;
		ParserRuleReturnScope expression648 =null;
		ParserRuleReturnScope expression652 =null;
		ParserRuleReturnScope expression654 =null;
		ParserRuleReturnScope expression658 =null;
		ParserRuleReturnScope expression662 =null;
		ParserRuleReturnScope expression666 =null;
		ParserRuleReturnScope expression670 =null;
		ParserRuleReturnScope expression674 =null;
		ParserRuleReturnScope regexExpression676 =null;
		ParserRuleReturnScope existsFunction677 =null;
		ParserRuleReturnScope notExistsFunction678 =null;

		CommonTree STR489_tree=null;
		CommonTree OPEN_BRACE490_tree=null;
		CommonTree CLOSE_BRACE492_tree=null;
		CommonTree LANG493_tree=null;
		CommonTree OPEN_BRACE494_tree=null;
		CommonTree CLOSE_BRACE496_tree=null;
		CommonTree LANGMATCHES497_tree=null;
		CommonTree OPEN_BRACE498_tree=null;
		CommonTree COMMA500_tree=null;
		CommonTree CLOSE_BRACE502_tree=null;
		CommonTree DATATYPE503_tree=null;
		CommonTree OPEN_BRACE504_tree=null;
		CommonTree CLOSE_BRACE506_tree=null;
		CommonTree BOUND507_tree=null;
		CommonTree OPEN_BRACE508_tree=null;
		CommonTree CLOSE_BRACE510_tree=null;
		CommonTree IRI511_tree=null;
		CommonTree OPEN_BRACE512_tree=null;
		CommonTree CLOSE_BRACE514_tree=null;
		CommonTree URI515_tree=null;
		CommonTree OPEN_BRACE516_tree=null;
		CommonTree CLOSE_BRACE518_tree=null;
		CommonTree BNODE519_tree=null;
		CommonTree OPEN_BRACE520_tree=null;
		CommonTree CLOSE_BRACE522_tree=null;
		CommonTree RAND524_tree=null;
		CommonTree ABS526_tree=null;
		CommonTree OPEN_BRACE527_tree=null;
		CommonTree CLOSE_BRACE529_tree=null;
		CommonTree CEIL530_tree=null;
		CommonTree OPEN_BRACE531_tree=null;
		CommonTree CLOSE_BRACE533_tree=null;
		CommonTree FLOOR534_tree=null;
		CommonTree OPEN_BRACE535_tree=null;
		CommonTree CLOSE_BRACE537_tree=null;
		CommonTree ROUND538_tree=null;
		CommonTree OPEN_BRACE539_tree=null;
		CommonTree CLOSE_BRACE541_tree=null;
		CommonTree CONCAT542_tree=null;
		CommonTree STRLEN545_tree=null;
		CommonTree OPEN_BRACE546_tree=null;
		CommonTree CLOSE_BRACE548_tree=null;
		CommonTree UCASE549_tree=null;
		CommonTree OPEN_BRACE550_tree=null;
		CommonTree CLOSE_BRACE552_tree=null;
		CommonTree LCASE553_tree=null;
		CommonTree OPEN_BRACE554_tree=null;
		CommonTree CLOSE_BRACE556_tree=null;
		CommonTree ENCODE_FOR_URI557_tree=null;
		CommonTree OPEN_BRACE558_tree=null;
		CommonTree CLOSE_BRACE560_tree=null;
		CommonTree CONTAINS561_tree=null;
		CommonTree OPEN_BRACE562_tree=null;
		CommonTree CLOSE_BRACE564_tree=null;
		CommonTree STRSTARTS565_tree=null;
		CommonTree OPEN_BRACE566_tree=null;
		CommonTree CLOSE_BRACE568_tree=null;
		CommonTree STRENDS569_tree=null;
		CommonTree OPEN_BRACE570_tree=null;
		CommonTree CLOSE_BRACE572_tree=null;
		CommonTree YEAR573_tree=null;
		CommonTree OPEN_BRACE574_tree=null;
		CommonTree CLOSE_BRACE576_tree=null;
		CommonTree MONTH577_tree=null;
		CommonTree OPEN_BRACE578_tree=null;
		CommonTree CLOSE_BRACE580_tree=null;
		CommonTree DAY581_tree=null;
		CommonTree OPEN_BRACE582_tree=null;
		CommonTree CLOSE_BRACE584_tree=null;
		CommonTree HOURS585_tree=null;
		CommonTree OPEN_BRACE586_tree=null;
		CommonTree CLOSE_BRACE588_tree=null;
		CommonTree MINUTES589_tree=null;
		CommonTree OPEN_BRACE590_tree=null;
		CommonTree CLOSE_BRACE592_tree=null;
		CommonTree SECONDS593_tree=null;
		CommonTree OPEN_BRACE594_tree=null;
		CommonTree CLOSE_BRACE596_tree=null;
		CommonTree TIMEZONE597_tree=null;
		CommonTree OPEN_BRACE598_tree=null;
		CommonTree CLOSE_BRACE600_tree=null;
		CommonTree TZ601_tree=null;
		CommonTree OPEN_BRACE602_tree=null;
		CommonTree CLOSE_BRACE604_tree=null;
		CommonTree NOW605_tree=null;
		CommonTree MD5607_tree=null;
		CommonTree OPEN_BRACE608_tree=null;
		CommonTree CLOSE_BRACE610_tree=null;
		CommonTree SHA1611_tree=null;
		CommonTree OPEN_BRACE612_tree=null;
		CommonTree CLOSE_BRACE614_tree=null;
		CommonTree SHA224615_tree=null;
		CommonTree OPEN_BRACE616_tree=null;
		CommonTree CLOSE_BRACE618_tree=null;
		CommonTree SHA256619_tree=null;
		CommonTree OPEN_BRACE620_tree=null;
		CommonTree CLOSE_BRACE622_tree=null;
		CommonTree SHA384623_tree=null;
		CommonTree OPEN_BRACE624_tree=null;
		CommonTree CLOSE_BRACE626_tree=null;
		CommonTree SHA512627_tree=null;
		CommonTree OPEN_BRACE628_tree=null;
		CommonTree CLOSE_BRACE630_tree=null;
		CommonTree COALESCE631_tree=null;
		CommonTree IF633_tree=null;
		CommonTree OPEN_BRACE634_tree=null;
		CommonTree COMMA635_tree=null;
		CommonTree COMMA636_tree=null;
		CommonTree CLOSE_BRACE637_tree=null;
		CommonTree STRLANG638_tree=null;
		CommonTree OPEN_BRACE639_tree=null;
		CommonTree COMMA641_tree=null;
		CommonTree CLOSE_BRACE643_tree=null;
		CommonTree STRDT644_tree=null;
		CommonTree OPEN_BRACE645_tree=null;
		CommonTree COMMA647_tree=null;
		CommonTree CLOSE_BRACE649_tree=null;
		CommonTree SAMETERM650_tree=null;
		CommonTree OPEN_BRACE651_tree=null;
		CommonTree COMMA653_tree=null;
		CommonTree CLOSE_BRACE655_tree=null;
		CommonTree ISIRI656_tree=null;
		CommonTree OPEN_BRACE657_tree=null;
		CommonTree CLOSE_BRACE659_tree=null;
		CommonTree ISURI660_tree=null;
		CommonTree OPEN_BRACE661_tree=null;
		CommonTree CLOSE_BRACE663_tree=null;
		CommonTree ISBLANK664_tree=null;
		CommonTree OPEN_BRACE665_tree=null;
		CommonTree CLOSE_BRACE667_tree=null;
		CommonTree ISLITERAL668_tree=null;
		CommonTree OPEN_BRACE669_tree=null;
		CommonTree CLOSE_BRACE671_tree=null;
		CommonTree ISNUMERIC672_tree=null;
		CommonTree OPEN_BRACE673_tree=null;
		CommonTree CLOSE_BRACE675_tree=null;
		RewriteRuleTokenStream stream_SHA256=new RewriteRuleTokenStream(adaptor,"token SHA256");
		RewriteRuleTokenStream stream_YEAR=new RewriteRuleTokenStream(adaptor,"token YEAR");
		RewriteRuleTokenStream stream_TIMEZONE=new RewriteRuleTokenStream(adaptor,"token TIMEZONE");
		RewriteRuleTokenStream stream_CONTAINS=new RewriteRuleTokenStream(adaptor,"token CONTAINS");
		RewriteRuleTokenStream stream_STRENDS=new RewriteRuleTokenStream(adaptor,"token STRENDS");
		RewriteRuleTokenStream stream_LCASE=new RewriteRuleTokenStream(adaptor,"token LCASE");
		RewriteRuleTokenStream stream_BNODE=new RewriteRuleTokenStream(adaptor,"token BNODE");
		RewriteRuleTokenStream stream_SHA512=new RewriteRuleTokenStream(adaptor,"token SHA512");
		RewriteRuleTokenStream stream_SECONDS=new RewriteRuleTokenStream(adaptor,"token SECONDS");
		RewriteRuleTokenStream stream_NOW=new RewriteRuleTokenStream(adaptor,"token NOW");
		RewriteRuleTokenStream stream_DAY=new RewriteRuleTokenStream(adaptor,"token DAY");
		RewriteRuleTokenStream stream_SHA224=new RewriteRuleTokenStream(adaptor,"token SHA224");
		RewriteRuleTokenStream stream_STRLEN=new RewriteRuleTokenStream(adaptor,"token STRLEN");
		RewriteRuleTokenStream stream_MONTH=new RewriteRuleTokenStream(adaptor,"token MONTH");
		RewriteRuleTokenStream stream_ENCODE_FOR_URI=new RewriteRuleTokenStream(adaptor,"token ENCODE_FOR_URI");
		RewriteRuleTokenStream stream_IF=new RewriteRuleTokenStream(adaptor,"token IF");
		RewriteRuleTokenStream stream_ISURI=new RewriteRuleTokenStream(adaptor,"token ISURI");
		RewriteRuleTokenStream stream_STR=new RewriteRuleTokenStream(adaptor,"token STR");
		RewriteRuleTokenStream stream_STRDT=new RewriteRuleTokenStream(adaptor,"token STRDT");
		RewriteRuleTokenStream stream_ISLITERAL=new RewriteRuleTokenStream(adaptor,"token ISLITERAL");
		RewriteRuleTokenStream stream_SAMETERM=new RewriteRuleTokenStream(adaptor,"token SAMETERM");
		RewriteRuleTokenStream stream_MD5=new RewriteRuleTokenStream(adaptor,"token MD5");
		RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
		RewriteRuleTokenStream stream_RAND=new RewriteRuleTokenStream(adaptor,"token RAND");
		RewriteRuleTokenStream stream_IRI=new RewriteRuleTokenStream(adaptor,"token IRI");
		RewriteRuleTokenStream stream_LANGMATCHES=new RewriteRuleTokenStream(adaptor,"token LANGMATCHES");
		RewriteRuleTokenStream stream_TZ=new RewriteRuleTokenStream(adaptor,"token TZ");
		RewriteRuleTokenStream stream_STRLANG=new RewriteRuleTokenStream(adaptor,"token STRLANG");
		RewriteRuleTokenStream stream_BOUND=new RewriteRuleTokenStream(adaptor,"token BOUND");
		RewriteRuleTokenStream stream_ISIRI=new RewriteRuleTokenStream(adaptor,"token ISIRI");
		RewriteRuleTokenStream stream_COALESCE=new RewriteRuleTokenStream(adaptor,"token COALESCE");
		RewriteRuleTokenStream stream_ISNUMERIC=new RewriteRuleTokenStream(adaptor,"token ISNUMERIC");
		RewriteRuleTokenStream stream_CONCAT=new RewriteRuleTokenStream(adaptor,"token CONCAT");
		RewriteRuleTokenStream stream_STRSTARTS=new RewriteRuleTokenStream(adaptor,"token STRSTARTS");
		RewriteRuleTokenStream stream_CLOSE_BRACE=new RewriteRuleTokenStream(adaptor,"token CLOSE_BRACE");
		RewriteRuleTokenStream stream_SHA1=new RewriteRuleTokenStream(adaptor,"token SHA1");
		RewriteRuleTokenStream stream_FLOOR=new RewriteRuleTokenStream(adaptor,"token FLOOR");
		RewriteRuleTokenStream stream_ISBLANK=new RewriteRuleTokenStream(adaptor,"token ISBLANK");
		RewriteRuleTokenStream stream_UCASE=new RewriteRuleTokenStream(adaptor,"token UCASE");
		RewriteRuleTokenStream stream_URI=new RewriteRuleTokenStream(adaptor,"token URI");
		RewriteRuleTokenStream stream_ABS=new RewriteRuleTokenStream(adaptor,"token ABS");
		RewriteRuleTokenStream stream_MINUTES=new RewriteRuleTokenStream(adaptor,"token MINUTES");
		RewriteRuleTokenStream stream_ROUND=new RewriteRuleTokenStream(adaptor,"token ROUND");
		RewriteRuleTokenStream stream_CEIL=new RewriteRuleTokenStream(adaptor,"token CEIL");
		RewriteRuleTokenStream stream_DATATYPE=new RewriteRuleTokenStream(adaptor,"token DATATYPE");
		RewriteRuleTokenStream stream_OPEN_BRACE=new RewriteRuleTokenStream(adaptor,"token OPEN_BRACE");
		RewriteRuleTokenStream stream_SHA384=new RewriteRuleTokenStream(adaptor,"token SHA384");
		RewriteRuleTokenStream stream_HOURS=new RewriteRuleTokenStream(adaptor,"token HOURS");
		RewriteRuleTokenStream stream_LANG=new RewriteRuleTokenStream(adaptor,"token LANG");
		RewriteRuleSubtreeStream stream_existsFunction=new RewriteRuleSubtreeStream(adaptor,"rule existsFunction");
		RewriteRuleSubtreeStream stream_subStringExpression=new RewriteRuleSubtreeStream(adaptor,"rule subStringExpression");
		RewriteRuleSubtreeStream stream_expression=new RewriteRuleSubtreeStream(adaptor,"rule expression");
		RewriteRuleSubtreeStream stream_notExistsFunction=new RewriteRuleSubtreeStream(adaptor,"rule notExistsFunction");
		RewriteRuleSubtreeStream stream_expressionList=new RewriteRuleSubtreeStream(adaptor,"rule expressionList");
		RewriteRuleSubtreeStream stream_var=new RewriteRuleSubtreeStream(adaptor,"rule var");
		RewriteRuleSubtreeStream stream_regexExpression=new RewriteRuleSubtreeStream(adaptor,"rule regexExpression");
		RewriteRuleSubtreeStream stream_nil=new RewriteRuleSubtreeStream(adaptor,"rule nil");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:875:5: ( STR OPEN_BRACE expression CLOSE_BRACE -> ^( STR expression ) | LANG OPEN_BRACE expression CLOSE_BRACE -> ^( LANG expression ) | LANGMATCHES OPEN_BRACE expression COMMA expression CLOSE_BRACE -> ^( LANGMATCHES ( expression )+ ) | DATATYPE OPEN_BRACE expression CLOSE_BRACE -> ^( DATATYPE expression ) | BOUND OPEN_BRACE var CLOSE_BRACE -> ^( BOUND var ) | IRI OPEN_BRACE expression CLOSE_BRACE -> ^( IRI expression ) | URI OPEN_BRACE expression CLOSE_BRACE -> ^( URI expression ) | BNODE ( OPEN_BRACE expression CLOSE_BRACE | nil ) -> ^( BNODE expression ) | RAND nil -> RAND | ABS OPEN_BRACE expression CLOSE_BRACE -> ^( ABS expression ) | CEIL OPEN_BRACE expression CLOSE_BRACE -> ^( CEIL expression ) | FLOOR OPEN_BRACE expression CLOSE_BRACE -> ^( FLOOR expression ) | ROUND OPEN_BRACE expression CLOSE_BRACE -> ^( ROUND expression ) | CONCAT expressionList -> ^( CONCAT expressionList ) | subStringExpression -> subStringExpression | STRLEN OPEN_BRACE expression CLOSE_BRACE -> ^( STRLEN expression ) | UCASE OPEN_BRACE expression CLOSE_BRACE -> ^( UCASE expression ) | LCASE OPEN_BRACE expression CLOSE_BRACE -> ^( LCASE expression ) | ENCODE_FOR_URI OPEN_BRACE expression CLOSE_BRACE -> ^( ENCODE_FOR_URI expression ) | CONTAINS OPEN_BRACE expression CLOSE_BRACE -> ^( CONTAINS expression ) | STRSTARTS OPEN_BRACE expression CLOSE_BRACE -> ^( STRSTARTS expression ) | STRENDS OPEN_BRACE expression CLOSE_BRACE -> ^( STRENDS expression ) | YEAR OPEN_BRACE expression CLOSE_BRACE -> ^( YEAR expression ) | MONTH OPEN_BRACE expression CLOSE_BRACE -> ^( MONTH expression ) | DAY OPEN_BRACE expression CLOSE_BRACE -> ^( DAY expression ) | HOURS OPEN_BRACE expression CLOSE_BRACE -> ^( HOURS expression ) | MINUTES OPEN_BRACE expression CLOSE_BRACE -> ^( MINUTES expression ) | SECONDS OPEN_BRACE expression CLOSE_BRACE -> ^( SECONDS expression ) | TIMEZONE OPEN_BRACE expression CLOSE_BRACE -> ^( TIMEZONE expression ) | TZ OPEN_BRACE expression CLOSE_BRACE -> ^( TZ expression ) | NOW nil -> NOW | MD5 OPEN_BRACE expression CLOSE_BRACE -> ^( MD5 expression ) | SHA1 OPEN_BRACE expression CLOSE_BRACE -> ^( SHA1 expression ) | SHA224 OPEN_BRACE expression CLOSE_BRACE -> ^( SHA224 expression ) | SHA256 OPEN_BRACE expression CLOSE_BRACE -> ^( SHA256 expression ) | SHA384 OPEN_BRACE expression CLOSE_BRACE -> ^( SHA384 expression ) | SHA512 OPEN_BRACE expression CLOSE_BRACE -> ^( SHA512 expression ) | COALESCE expressionList -> ^( COALESCE expressionList ) | IF OPEN_BRACE e1= expression COMMA e2= expression COMMA e3= expression CLOSE_BRACE -> ^( IF $e1 $e2 $e3) | STRLANG OPEN_BRACE expression COMMA expression CLOSE_BRACE -> ^( STRLANG expression expression ) | STRDT OPEN_BRACE expression COMMA expression CLOSE_BRACE -> ^( STRDT expression expression ) | SAMETERM OPEN_BRACE expression COMMA expression CLOSE_BRACE -> ^( SAMETERM expression expression ) | ISIRI OPEN_BRACE expression CLOSE_BRACE -> ^( ISIRI expression ) | ISURI OPEN_BRACE expression CLOSE_BRACE -> ^( ISURI expression ) | ISBLANK OPEN_BRACE expression CLOSE_BRACE -> ^( ISBLANK expression ) | ISLITERAL OPEN_BRACE expression CLOSE_BRACE -> ^( ISLITERAL expression ) | ISNUMERIC OPEN_BRACE expression CLOSE_BRACE -> ^( ISNUMERIC expression ) | regexExpression -> regexExpression | existsFunction -> existsFunction | notExistsFunction -> notExistsFunction )
			int alt156=50;
			switch ( input.LA(1) ) {
			case STR:
				{
				alt156=1;
				}
				break;
			case LANG:
				{
				alt156=2;
				}
				break;
			case LANGMATCHES:
				{
				alt156=3;
				}
				break;
			case DATATYPE:
				{
				alt156=4;
				}
				break;
			case BOUND:
				{
				alt156=5;
				}
				break;
			case IRI:
				{
				alt156=6;
				}
				break;
			case URI:
				{
				alt156=7;
				}
				break;
			case BNODE:
				{
				alt156=8;
				}
				break;
			case RAND:
				{
				alt156=9;
				}
				break;
			case ABS:
				{
				alt156=10;
				}
				break;
			case CEIL:
				{
				alt156=11;
				}
				break;
			case FLOOR:
				{
				alt156=12;
				}
				break;
			case ROUND:
				{
				alt156=13;
				}
				break;
			case CONCAT:
				{
				alt156=14;
				}
				break;
			case SUBSTR:
				{
				alt156=15;
				}
				break;
			case STRLEN:
				{
				alt156=16;
				}
				break;
			case UCASE:
				{
				alt156=17;
				}
				break;
			case LCASE:
				{
				alt156=18;
				}
				break;
			case ENCODE_FOR_URI:
				{
				alt156=19;
				}
				break;
			case CONTAINS:
				{
				alt156=20;
				}
				break;
			case STRSTARTS:
				{
				alt156=21;
				}
				break;
			case STRENDS:
				{
				alt156=22;
				}
				break;
			case YEAR:
				{
				alt156=23;
				}
				break;
			case MONTH:
				{
				alt156=24;
				}
				break;
			case DAY:
				{
				alt156=25;
				}
				break;
			case HOURS:
				{
				alt156=26;
				}
				break;
			case MINUTES:
				{
				alt156=27;
				}
				break;
			case SECONDS:
				{
				alt156=28;
				}
				break;
			case TIMEZONE:
				{
				alt156=29;
				}
				break;
			case TZ:
				{
				alt156=30;
				}
				break;
			case NOW:
				{
				alt156=31;
				}
				break;
			case MD5:
				{
				alt156=32;
				}
				break;
			case SHA1:
				{
				alt156=33;
				}
				break;
			case SHA224:
				{
				alt156=34;
				}
				break;
			case SHA256:
				{
				alt156=35;
				}
				break;
			case SHA384:
				{
				alt156=36;
				}
				break;
			case SHA512:
				{
				alt156=37;
				}
				break;
			case COALESCE:
				{
				alt156=38;
				}
				break;
			case IF:
				{
				alt156=39;
				}
				break;
			case STRLANG:
				{
				alt156=40;
				}
				break;
			case STRDT:
				{
				alt156=41;
				}
				break;
			case SAMETERM:
				{
				alt156=42;
				}
				break;
			case ISIRI:
				{
				alt156=43;
				}
				break;
			case ISURI:
				{
				alt156=44;
				}
				break;
			case ISBLANK:
				{
				alt156=45;
				}
				break;
			case ISLITERAL:
				{
				alt156=46;
				}
				break;
			case ISNUMERIC:
				{
				alt156=47;
				}
				break;
			case REGEX:
				{
				alt156=48;
				}
				break;
			case EXISTS:
				{
				alt156=49;
				}
				break;
			case NOT:
				{
				alt156=50;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 156, 0, input);
				throw nvae;
			}
			switch (alt156) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:875:7: STR OPEN_BRACE expression CLOSE_BRACE
					{
					STR489=(Token)match(input,STR,FOLLOW_STR_in_builtInCall6605);  
					stream_STR.add(STR489);

					OPEN_BRACE490=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall6607);  
					stream_OPEN_BRACE.add(OPEN_BRACE490);

					pushFollow(FOLLOW_expression_in_builtInCall6609);
					expression491=expression();
					state._fsp--;

					stream_expression.add(expression491.getTree());
					CLOSE_BRACE492=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall6611);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE492);

					// AST REWRITE
					// elements: expression, STR
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 875:45: -> ^( STR expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:875:48: ^( STR expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_STR.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:876:7: LANG OPEN_BRACE expression CLOSE_BRACE
					{
					LANG493=(Token)match(input,LANG,FOLLOW_LANG_in_builtInCall6627);  
					stream_LANG.add(LANG493);

					OPEN_BRACE494=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall6629);  
					stream_OPEN_BRACE.add(OPEN_BRACE494);

					pushFollow(FOLLOW_expression_in_builtInCall6631);
					expression495=expression();
					state._fsp--;

					stream_expression.add(expression495.getTree());
					CLOSE_BRACE496=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall6633);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE496);

					// AST REWRITE
					// elements: LANG, expression
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 876:46: -> ^( LANG expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:876:49: ^( LANG expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_LANG.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:877:7: LANGMATCHES OPEN_BRACE expression COMMA expression CLOSE_BRACE
					{
					LANGMATCHES497=(Token)match(input,LANGMATCHES,FOLLOW_LANGMATCHES_in_builtInCall6649);  
					stream_LANGMATCHES.add(LANGMATCHES497);

					OPEN_BRACE498=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall6651);  
					stream_OPEN_BRACE.add(OPEN_BRACE498);

					pushFollow(FOLLOW_expression_in_builtInCall6653);
					expression499=expression();
					state._fsp--;

					stream_expression.add(expression499.getTree());
					COMMA500=(Token)match(input,COMMA,FOLLOW_COMMA_in_builtInCall6655);  
					stream_COMMA.add(COMMA500);

					pushFollow(FOLLOW_expression_in_builtInCall6657);
					expression501=expression();
					state._fsp--;

					stream_expression.add(expression501.getTree());
					CLOSE_BRACE502=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall6659);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE502);

					// AST REWRITE
					// elements: LANGMATCHES, expression
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 877:70: -> ^( LANGMATCHES ( expression )+ )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:877:73: ^( LANGMATCHES ( expression )+ )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_LANGMATCHES.nextNode(), root_1);
						if ( !(stream_expression.hasNext()) ) {
							throw new RewriteEarlyExitException();
						}
						while ( stream_expression.hasNext() ) {
							adaptor.addChild(root_1, stream_expression.nextTree());
						}
						stream_expression.reset();

						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:878:7: DATATYPE OPEN_BRACE expression CLOSE_BRACE
					{
					DATATYPE503=(Token)match(input,DATATYPE,FOLLOW_DATATYPE_in_builtInCall6676);  
					stream_DATATYPE.add(DATATYPE503);

					OPEN_BRACE504=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall6678);  
					stream_OPEN_BRACE.add(OPEN_BRACE504);

					pushFollow(FOLLOW_expression_in_builtInCall6680);
					expression505=expression();
					state._fsp--;

					stream_expression.add(expression505.getTree());
					CLOSE_BRACE506=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall6682);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE506);

					// AST REWRITE
					// elements: DATATYPE, expression
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 878:50: -> ^( DATATYPE expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:878:53: ^( DATATYPE expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_DATATYPE.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 5 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:879:7: BOUND OPEN_BRACE var CLOSE_BRACE
					{
					BOUND507=(Token)match(input,BOUND,FOLLOW_BOUND_in_builtInCall6698);  
					stream_BOUND.add(BOUND507);

					OPEN_BRACE508=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall6700);  
					stream_OPEN_BRACE.add(OPEN_BRACE508);

					pushFollow(FOLLOW_var_in_builtInCall6702);
					var509=var();
					state._fsp--;

					stream_var.add(var509.getTree());
					CLOSE_BRACE510=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall6704);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE510);

					// AST REWRITE
					// elements: var, BOUND
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 879:40: -> ^( BOUND var )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:879:43: ^( BOUND var )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_BOUND.nextNode(), root_1);
						adaptor.addChild(root_1, stream_var.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 6 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:880:7: IRI OPEN_BRACE expression CLOSE_BRACE
					{
					IRI511=(Token)match(input,IRI,FOLLOW_IRI_in_builtInCall6720);  
					stream_IRI.add(IRI511);

					OPEN_BRACE512=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall6722);  
					stream_OPEN_BRACE.add(OPEN_BRACE512);

					pushFollow(FOLLOW_expression_in_builtInCall6724);
					expression513=expression();
					state._fsp--;

					stream_expression.add(expression513.getTree());
					CLOSE_BRACE514=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall6726);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE514);

					// AST REWRITE
					// elements: expression, IRI
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 880:45: -> ^( IRI expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:880:48: ^( IRI expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_IRI.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 7 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:881:7: URI OPEN_BRACE expression CLOSE_BRACE
					{
					URI515=(Token)match(input,URI,FOLLOW_URI_in_builtInCall6742);  
					stream_URI.add(URI515);

					OPEN_BRACE516=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall6744);  
					stream_OPEN_BRACE.add(OPEN_BRACE516);

					pushFollow(FOLLOW_expression_in_builtInCall6746);
					expression517=expression();
					state._fsp--;

					stream_expression.add(expression517.getTree());
					CLOSE_BRACE518=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall6748);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE518);

					// AST REWRITE
					// elements: expression, URI
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 881:45: -> ^( URI expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:881:48: ^( URI expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_URI.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 8 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:882:7: BNODE ( OPEN_BRACE expression CLOSE_BRACE | nil )
					{
					BNODE519=(Token)match(input,BNODE,FOLLOW_BNODE_in_builtInCall6764);  
					stream_BNODE.add(BNODE519);

					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:882:13: ( OPEN_BRACE expression CLOSE_BRACE | nil )
					int alt155=2;
					int LA155_0 = input.LA(1);
					if ( (LA155_0==OPEN_BRACE) ) {
						int LA155_1 = input.LA(2);
						if ( (LA155_1==CLOSE_BRACE) ) {
							alt155=2;
						}
						else if ( (LA155_1==ABS||LA155_1==AVG||(LA155_1 >= BNODE && LA155_1 <= BOUND)||LA155_1==CEIL||LA155_1==COALESCE||LA155_1==CONCAT||LA155_1==CONTAINS||LA155_1==COUNT||(LA155_1 >= DATATYPE && LA155_1 <= DECIMAL_POSITIVE)||(LA155_1 >= DOUBLE && LA155_1 <= DOUBLE_POSITIVE)||LA155_1==ENCODE_FOR_URI||LA155_1==EXISTS||LA155_1==FALSE||LA155_1==FLOOR||LA155_1==GROUP_CONCAT||(LA155_1 >= HOURS && LA155_1 <= IF)||(LA155_1 >= INTEGER && LA155_1 <= INTEGER_POSITIVE)||(LA155_1 >= IRI && LA155_1 <= IRI_REF)||(LA155_1 >= ISBLANK && LA155_1 <= ISURI)||(LA155_1 >= LANG && LA155_1 <= LANGMATCHES)||LA155_1==LCASE||(LA155_1 >= MAX && LA155_1 <= MINUS)||LA155_1==MINUTES||LA155_1==MONTH||LA155_1==NAME||LA155_1==NEGATION||LA155_1==NOT||LA155_1==NOW||LA155_1==OPEN_BRACE||(LA155_1 >= PLUS && LA155_1 <= PNAME_NS)||LA155_1==RAND||LA155_1==REGEX||(LA155_1 >= ROUND && LA155_1 <= SECONDS)||(LA155_1 >= SHA1 && LA155_1 <= SHA512)||(LA155_1 >= STR && LA155_1 <= STRENDS)||(LA155_1 >= STRING_LITERAL1 && LA155_1 <= STRSTARTS)||(LA155_1 >= SUBSTR && LA155_1 <= SUM)||LA155_1==TIMEZONE||LA155_1==TRUE||(LA155_1 >= TZ && LA155_1 <= UCASE)||LA155_1==URI||(LA155_1 >= VAR1 && LA155_1 <= VAR3)||LA155_1==YEAR) ) {
							alt155=1;
						}

						else {
							int nvaeMark = input.mark();
							try {
								input.consume();
								NoViableAltException nvae =
									new NoViableAltException("", 155, 1, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

					}

					else {
						NoViableAltException nvae =
							new NoViableAltException("", 155, 0, input);
						throw nvae;
					}

					switch (alt155) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:882:14: OPEN_BRACE expression CLOSE_BRACE
							{
							OPEN_BRACE520=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall6767);  
							stream_OPEN_BRACE.add(OPEN_BRACE520);

							pushFollow(FOLLOW_expression_in_builtInCall6769);
							expression521=expression();
							state._fsp--;

							stream_expression.add(expression521.getTree());
							CLOSE_BRACE522=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall6771);  
							stream_CLOSE_BRACE.add(CLOSE_BRACE522);

							}
							break;
						case 2 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:882:49: nil
							{
							pushFollow(FOLLOW_nil_in_builtInCall6774);
							nil523=nil();
							state._fsp--;

							stream_nil.add(nil523.getTree());
							}
							break;

					}

					// AST REWRITE
					// elements: expression, BNODE
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 882:54: -> ^( BNODE expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:882:57: ^( BNODE expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_BNODE.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 9 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:883:7: RAND nil
					{
					RAND524=(Token)match(input,RAND,FOLLOW_RAND_in_builtInCall6791);  
					stream_RAND.add(RAND524);

					pushFollow(FOLLOW_nil_in_builtInCall6793);
					nil525=nil();
					state._fsp--;

					stream_nil.add(nil525.getTree());
					// AST REWRITE
					// elements: RAND
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 883:16: -> RAND
					{
						adaptor.addChild(root_0, stream_RAND.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 10 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:884:7: ABS OPEN_BRACE expression CLOSE_BRACE
					{
					ABS526=(Token)match(input,ABS,FOLLOW_ABS_in_builtInCall6805);  
					stream_ABS.add(ABS526);

					OPEN_BRACE527=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall6807);  
					stream_OPEN_BRACE.add(OPEN_BRACE527);

					pushFollow(FOLLOW_expression_in_builtInCall6809);
					expression528=expression();
					state._fsp--;

					stream_expression.add(expression528.getTree());
					CLOSE_BRACE529=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall6811);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE529);

					// AST REWRITE
					// elements: expression, ABS
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 884:45: -> ^( ABS expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:884:48: ^( ABS expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_ABS.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 11 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:885:7: CEIL OPEN_BRACE expression CLOSE_BRACE
					{
					CEIL530=(Token)match(input,CEIL,FOLLOW_CEIL_in_builtInCall6827);  
					stream_CEIL.add(CEIL530);

					OPEN_BRACE531=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall6829);  
					stream_OPEN_BRACE.add(OPEN_BRACE531);

					pushFollow(FOLLOW_expression_in_builtInCall6831);
					expression532=expression();
					state._fsp--;

					stream_expression.add(expression532.getTree());
					CLOSE_BRACE533=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall6833);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE533);

					// AST REWRITE
					// elements: expression, CEIL
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 885:46: -> ^( CEIL expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:885:49: ^( CEIL expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_CEIL.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 12 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:886:7: FLOOR OPEN_BRACE expression CLOSE_BRACE
					{
					FLOOR534=(Token)match(input,FLOOR,FOLLOW_FLOOR_in_builtInCall6849);  
					stream_FLOOR.add(FLOOR534);

					OPEN_BRACE535=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall6851);  
					stream_OPEN_BRACE.add(OPEN_BRACE535);

					pushFollow(FOLLOW_expression_in_builtInCall6853);
					expression536=expression();
					state._fsp--;

					stream_expression.add(expression536.getTree());
					CLOSE_BRACE537=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall6855);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE537);

					// AST REWRITE
					// elements: FLOOR, expression
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 886:47: -> ^( FLOOR expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:886:50: ^( FLOOR expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_FLOOR.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 13 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:887:7: ROUND OPEN_BRACE expression CLOSE_BRACE
					{
					ROUND538=(Token)match(input,ROUND,FOLLOW_ROUND_in_builtInCall6871);  
					stream_ROUND.add(ROUND538);

					OPEN_BRACE539=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall6873);  
					stream_OPEN_BRACE.add(OPEN_BRACE539);

					pushFollow(FOLLOW_expression_in_builtInCall6875);
					expression540=expression();
					state._fsp--;

					stream_expression.add(expression540.getTree());
					CLOSE_BRACE541=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall6877);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE541);

					// AST REWRITE
					// elements: ROUND, expression
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 887:47: -> ^( ROUND expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:887:50: ^( ROUND expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_ROUND.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 14 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:888:7: CONCAT expressionList
					{
					CONCAT542=(Token)match(input,CONCAT,FOLLOW_CONCAT_in_builtInCall6893);  
					stream_CONCAT.add(CONCAT542);

					pushFollow(FOLLOW_expressionList_in_builtInCall6895);
					expressionList543=expressionList();
					state._fsp--;

					stream_expressionList.add(expressionList543.getTree());
					// AST REWRITE
					// elements: CONCAT, expressionList
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 888:29: -> ^( CONCAT expressionList )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:888:32: ^( CONCAT expressionList )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_CONCAT.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expressionList.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 15 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:889:7: subStringExpression
					{
					pushFollow(FOLLOW_subStringExpression_in_builtInCall6911);
					subStringExpression544=subStringExpression();
					state._fsp--;

					stream_subStringExpression.add(subStringExpression544.getTree());
					// AST REWRITE
					// elements: subStringExpression
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 889:27: -> subStringExpression
					{
						adaptor.addChild(root_0, stream_subStringExpression.nextTree());
					}


					retval.tree = root_0;

					}
					break;
				case 16 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:890:7: STRLEN OPEN_BRACE expression CLOSE_BRACE
					{
					STRLEN545=(Token)match(input,STRLEN,FOLLOW_STRLEN_in_builtInCall6923);  
					stream_STRLEN.add(STRLEN545);

					OPEN_BRACE546=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall6925);  
					stream_OPEN_BRACE.add(OPEN_BRACE546);

					pushFollow(FOLLOW_expression_in_builtInCall6927);
					expression547=expression();
					state._fsp--;

					stream_expression.add(expression547.getTree());
					CLOSE_BRACE548=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall6929);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE548);

					// AST REWRITE
					// elements: STRLEN, expression
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 890:48: -> ^( STRLEN expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:890:51: ^( STRLEN expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_STRLEN.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 17 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:891:7: UCASE OPEN_BRACE expression CLOSE_BRACE
					{
					UCASE549=(Token)match(input,UCASE,FOLLOW_UCASE_in_builtInCall6945);  
					stream_UCASE.add(UCASE549);

					OPEN_BRACE550=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall6947);  
					stream_OPEN_BRACE.add(OPEN_BRACE550);

					pushFollow(FOLLOW_expression_in_builtInCall6949);
					expression551=expression();
					state._fsp--;

					stream_expression.add(expression551.getTree());
					CLOSE_BRACE552=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall6951);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE552);

					// AST REWRITE
					// elements: UCASE, expression
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 891:47: -> ^( UCASE expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:891:50: ^( UCASE expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_UCASE.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 18 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:892:7: LCASE OPEN_BRACE expression CLOSE_BRACE
					{
					LCASE553=(Token)match(input,LCASE,FOLLOW_LCASE_in_builtInCall6967);  
					stream_LCASE.add(LCASE553);

					OPEN_BRACE554=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall6969);  
					stream_OPEN_BRACE.add(OPEN_BRACE554);

					pushFollow(FOLLOW_expression_in_builtInCall6971);
					expression555=expression();
					state._fsp--;

					stream_expression.add(expression555.getTree());
					CLOSE_BRACE556=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall6973);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE556);

					// AST REWRITE
					// elements: expression, LCASE
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 892:47: -> ^( LCASE expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:892:50: ^( LCASE expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_LCASE.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 19 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:893:7: ENCODE_FOR_URI OPEN_BRACE expression CLOSE_BRACE
					{
					ENCODE_FOR_URI557=(Token)match(input,ENCODE_FOR_URI,FOLLOW_ENCODE_FOR_URI_in_builtInCall6989);  
					stream_ENCODE_FOR_URI.add(ENCODE_FOR_URI557);

					OPEN_BRACE558=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall6991);  
					stream_OPEN_BRACE.add(OPEN_BRACE558);

					pushFollow(FOLLOW_expression_in_builtInCall6993);
					expression559=expression();
					state._fsp--;

					stream_expression.add(expression559.getTree());
					CLOSE_BRACE560=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall6995);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE560);

					// AST REWRITE
					// elements: expression, ENCODE_FOR_URI
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 893:56: -> ^( ENCODE_FOR_URI expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:893:59: ^( ENCODE_FOR_URI expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_ENCODE_FOR_URI.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 20 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:894:7: CONTAINS OPEN_BRACE expression CLOSE_BRACE
					{
					CONTAINS561=(Token)match(input,CONTAINS,FOLLOW_CONTAINS_in_builtInCall7011);  
					stream_CONTAINS.add(CONTAINS561);

					OPEN_BRACE562=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall7013);  
					stream_OPEN_BRACE.add(OPEN_BRACE562);

					pushFollow(FOLLOW_expression_in_builtInCall7015);
					expression563=expression();
					state._fsp--;

					stream_expression.add(expression563.getTree());
					CLOSE_BRACE564=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall7017);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE564);

					// AST REWRITE
					// elements: CONTAINS, expression
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 894:50: -> ^( CONTAINS expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:894:53: ^( CONTAINS expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_CONTAINS.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 21 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:895:7: STRSTARTS OPEN_BRACE expression CLOSE_BRACE
					{
					STRSTARTS565=(Token)match(input,STRSTARTS,FOLLOW_STRSTARTS_in_builtInCall7033);  
					stream_STRSTARTS.add(STRSTARTS565);

					OPEN_BRACE566=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall7035);  
					stream_OPEN_BRACE.add(OPEN_BRACE566);

					pushFollow(FOLLOW_expression_in_builtInCall7037);
					expression567=expression();
					state._fsp--;

					stream_expression.add(expression567.getTree());
					CLOSE_BRACE568=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall7039);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE568);

					// AST REWRITE
					// elements: STRSTARTS, expression
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 895:51: -> ^( STRSTARTS expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:895:54: ^( STRSTARTS expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_STRSTARTS.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 22 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:896:7: STRENDS OPEN_BRACE expression CLOSE_BRACE
					{
					STRENDS569=(Token)match(input,STRENDS,FOLLOW_STRENDS_in_builtInCall7055);  
					stream_STRENDS.add(STRENDS569);

					OPEN_BRACE570=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall7057);  
					stream_OPEN_BRACE.add(OPEN_BRACE570);

					pushFollow(FOLLOW_expression_in_builtInCall7059);
					expression571=expression();
					state._fsp--;

					stream_expression.add(expression571.getTree());
					CLOSE_BRACE572=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall7061);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE572);

					// AST REWRITE
					// elements: STRENDS, expression
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 896:49: -> ^( STRENDS expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:896:52: ^( STRENDS expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_STRENDS.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 23 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:897:7: YEAR OPEN_BRACE expression CLOSE_BRACE
					{
					YEAR573=(Token)match(input,YEAR,FOLLOW_YEAR_in_builtInCall7077);  
					stream_YEAR.add(YEAR573);

					OPEN_BRACE574=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall7079);  
					stream_OPEN_BRACE.add(OPEN_BRACE574);

					pushFollow(FOLLOW_expression_in_builtInCall7081);
					expression575=expression();
					state._fsp--;

					stream_expression.add(expression575.getTree());
					CLOSE_BRACE576=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall7083);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE576);

					// AST REWRITE
					// elements: YEAR, expression
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 897:46: -> ^( YEAR expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:897:49: ^( YEAR expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_YEAR.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 24 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:898:7: MONTH OPEN_BRACE expression CLOSE_BRACE
					{
					MONTH577=(Token)match(input,MONTH,FOLLOW_MONTH_in_builtInCall7099);  
					stream_MONTH.add(MONTH577);

					OPEN_BRACE578=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall7101);  
					stream_OPEN_BRACE.add(OPEN_BRACE578);

					pushFollow(FOLLOW_expression_in_builtInCall7103);
					expression579=expression();
					state._fsp--;

					stream_expression.add(expression579.getTree());
					CLOSE_BRACE580=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall7105);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE580);

					// AST REWRITE
					// elements: expression, MONTH
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 898:47: -> ^( MONTH expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:898:50: ^( MONTH expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_MONTH.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 25 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:899:7: DAY OPEN_BRACE expression CLOSE_BRACE
					{
					DAY581=(Token)match(input,DAY,FOLLOW_DAY_in_builtInCall7121);  
					stream_DAY.add(DAY581);

					OPEN_BRACE582=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall7123);  
					stream_OPEN_BRACE.add(OPEN_BRACE582);

					pushFollow(FOLLOW_expression_in_builtInCall7125);
					expression583=expression();
					state._fsp--;

					stream_expression.add(expression583.getTree());
					CLOSE_BRACE584=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall7127);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE584);

					// AST REWRITE
					// elements: DAY, expression
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 899:45: -> ^( DAY expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:899:48: ^( DAY expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_DAY.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 26 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:900:7: HOURS OPEN_BRACE expression CLOSE_BRACE
					{
					HOURS585=(Token)match(input,HOURS,FOLLOW_HOURS_in_builtInCall7143);  
					stream_HOURS.add(HOURS585);

					OPEN_BRACE586=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall7145);  
					stream_OPEN_BRACE.add(OPEN_BRACE586);

					pushFollow(FOLLOW_expression_in_builtInCall7147);
					expression587=expression();
					state._fsp--;

					stream_expression.add(expression587.getTree());
					CLOSE_BRACE588=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall7149);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE588);

					// AST REWRITE
					// elements: expression, HOURS
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 900:47: -> ^( HOURS expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:900:50: ^( HOURS expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_HOURS.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 27 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:901:7: MINUTES OPEN_BRACE expression CLOSE_BRACE
					{
					MINUTES589=(Token)match(input,MINUTES,FOLLOW_MINUTES_in_builtInCall7165);  
					stream_MINUTES.add(MINUTES589);

					OPEN_BRACE590=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall7167);  
					stream_OPEN_BRACE.add(OPEN_BRACE590);

					pushFollow(FOLLOW_expression_in_builtInCall7169);
					expression591=expression();
					state._fsp--;

					stream_expression.add(expression591.getTree());
					CLOSE_BRACE592=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall7171);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE592);

					// AST REWRITE
					// elements: MINUTES, expression
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 901:49: -> ^( MINUTES expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:901:52: ^( MINUTES expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_MINUTES.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 28 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:902:7: SECONDS OPEN_BRACE expression CLOSE_BRACE
					{
					SECONDS593=(Token)match(input,SECONDS,FOLLOW_SECONDS_in_builtInCall7187);  
					stream_SECONDS.add(SECONDS593);

					OPEN_BRACE594=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall7189);  
					stream_OPEN_BRACE.add(OPEN_BRACE594);

					pushFollow(FOLLOW_expression_in_builtInCall7191);
					expression595=expression();
					state._fsp--;

					stream_expression.add(expression595.getTree());
					CLOSE_BRACE596=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall7193);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE596);

					// AST REWRITE
					// elements: SECONDS, expression
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 902:49: -> ^( SECONDS expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:902:52: ^( SECONDS expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_SECONDS.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 29 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:903:7: TIMEZONE OPEN_BRACE expression CLOSE_BRACE
					{
					TIMEZONE597=(Token)match(input,TIMEZONE,FOLLOW_TIMEZONE_in_builtInCall7209);  
					stream_TIMEZONE.add(TIMEZONE597);

					OPEN_BRACE598=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall7211);  
					stream_OPEN_BRACE.add(OPEN_BRACE598);

					pushFollow(FOLLOW_expression_in_builtInCall7213);
					expression599=expression();
					state._fsp--;

					stream_expression.add(expression599.getTree());
					CLOSE_BRACE600=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall7215);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE600);

					// AST REWRITE
					// elements: expression, TIMEZONE
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 903:50: -> ^( TIMEZONE expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:903:53: ^( TIMEZONE expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_TIMEZONE.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 30 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:904:7: TZ OPEN_BRACE expression CLOSE_BRACE
					{
					TZ601=(Token)match(input,TZ,FOLLOW_TZ_in_builtInCall7231);  
					stream_TZ.add(TZ601);

					OPEN_BRACE602=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall7233);  
					stream_OPEN_BRACE.add(OPEN_BRACE602);

					pushFollow(FOLLOW_expression_in_builtInCall7235);
					expression603=expression();
					state._fsp--;

					stream_expression.add(expression603.getTree());
					CLOSE_BRACE604=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall7237);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE604);

					// AST REWRITE
					// elements: expression, TZ
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 904:44: -> ^( TZ expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:904:47: ^( TZ expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_TZ.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 31 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:905:7: NOW nil
					{
					NOW605=(Token)match(input,NOW,FOLLOW_NOW_in_builtInCall7253);  
					stream_NOW.add(NOW605);

					pushFollow(FOLLOW_nil_in_builtInCall7255);
					nil606=nil();
					state._fsp--;

					stream_nil.add(nil606.getTree());
					// AST REWRITE
					// elements: NOW
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 905:15: -> NOW
					{
						adaptor.addChild(root_0, stream_NOW.nextNode());
					}


					retval.tree = root_0;

					}
					break;
				case 32 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:906:7: MD5 OPEN_BRACE expression CLOSE_BRACE
					{
					MD5607=(Token)match(input,MD5,FOLLOW_MD5_in_builtInCall7267);  
					stream_MD5.add(MD5607);

					OPEN_BRACE608=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall7269);  
					stream_OPEN_BRACE.add(OPEN_BRACE608);

					pushFollow(FOLLOW_expression_in_builtInCall7271);
					expression609=expression();
					state._fsp--;

					stream_expression.add(expression609.getTree());
					CLOSE_BRACE610=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall7273);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE610);

					// AST REWRITE
					// elements: expression, MD5
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 906:45: -> ^( MD5 expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:906:48: ^( MD5 expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_MD5.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 33 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:907:7: SHA1 OPEN_BRACE expression CLOSE_BRACE
					{
					SHA1611=(Token)match(input,SHA1,FOLLOW_SHA1_in_builtInCall7289);  
					stream_SHA1.add(SHA1611);

					OPEN_BRACE612=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall7291);  
					stream_OPEN_BRACE.add(OPEN_BRACE612);

					pushFollow(FOLLOW_expression_in_builtInCall7293);
					expression613=expression();
					state._fsp--;

					stream_expression.add(expression613.getTree());
					CLOSE_BRACE614=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall7295);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE614);

					// AST REWRITE
					// elements: SHA1, expression
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 907:46: -> ^( SHA1 expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:907:49: ^( SHA1 expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_SHA1.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 34 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:908:7: SHA224 OPEN_BRACE expression CLOSE_BRACE
					{
					SHA224615=(Token)match(input,SHA224,FOLLOW_SHA224_in_builtInCall7311);  
					stream_SHA224.add(SHA224615);

					OPEN_BRACE616=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall7313);  
					stream_OPEN_BRACE.add(OPEN_BRACE616);

					pushFollow(FOLLOW_expression_in_builtInCall7315);
					expression617=expression();
					state._fsp--;

					stream_expression.add(expression617.getTree());
					CLOSE_BRACE618=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall7317);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE618);

					// AST REWRITE
					// elements: expression, SHA224
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 908:48: -> ^( SHA224 expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:908:51: ^( SHA224 expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_SHA224.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 35 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:909:7: SHA256 OPEN_BRACE expression CLOSE_BRACE
					{
					SHA256619=(Token)match(input,SHA256,FOLLOW_SHA256_in_builtInCall7333);  
					stream_SHA256.add(SHA256619);

					OPEN_BRACE620=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall7335);  
					stream_OPEN_BRACE.add(OPEN_BRACE620);

					pushFollow(FOLLOW_expression_in_builtInCall7337);
					expression621=expression();
					state._fsp--;

					stream_expression.add(expression621.getTree());
					CLOSE_BRACE622=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall7339);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE622);

					// AST REWRITE
					// elements: expression, SHA256
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 909:48: -> ^( SHA256 expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:909:51: ^( SHA256 expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_SHA256.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 36 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:910:7: SHA384 OPEN_BRACE expression CLOSE_BRACE
					{
					SHA384623=(Token)match(input,SHA384,FOLLOW_SHA384_in_builtInCall7355);  
					stream_SHA384.add(SHA384623);

					OPEN_BRACE624=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall7357);  
					stream_OPEN_BRACE.add(OPEN_BRACE624);

					pushFollow(FOLLOW_expression_in_builtInCall7359);
					expression625=expression();
					state._fsp--;

					stream_expression.add(expression625.getTree());
					CLOSE_BRACE626=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall7361);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE626);

					// AST REWRITE
					// elements: expression, SHA384
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 910:48: -> ^( SHA384 expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:910:51: ^( SHA384 expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_SHA384.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 37 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:911:7: SHA512 OPEN_BRACE expression CLOSE_BRACE
					{
					SHA512627=(Token)match(input,SHA512,FOLLOW_SHA512_in_builtInCall7377);  
					stream_SHA512.add(SHA512627);

					OPEN_BRACE628=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall7379);  
					stream_OPEN_BRACE.add(OPEN_BRACE628);

					pushFollow(FOLLOW_expression_in_builtInCall7381);
					expression629=expression();
					state._fsp--;

					stream_expression.add(expression629.getTree());
					CLOSE_BRACE630=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall7383);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE630);

					// AST REWRITE
					// elements: expression, SHA512
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 911:48: -> ^( SHA512 expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:911:51: ^( SHA512 expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_SHA512.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 38 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:912:7: COALESCE expressionList
					{
					COALESCE631=(Token)match(input,COALESCE,FOLLOW_COALESCE_in_builtInCall7399);  
					stream_COALESCE.add(COALESCE631);

					pushFollow(FOLLOW_expressionList_in_builtInCall7401);
					expressionList632=expressionList();
					state._fsp--;

					stream_expressionList.add(expressionList632.getTree());
					// AST REWRITE
					// elements: COALESCE, expressionList
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 912:31: -> ^( COALESCE expressionList )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:912:34: ^( COALESCE expressionList )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_COALESCE.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expressionList.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 39 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:913:7: IF OPEN_BRACE e1= expression COMMA e2= expression COMMA e3= expression CLOSE_BRACE
					{
					IF633=(Token)match(input,IF,FOLLOW_IF_in_builtInCall7417);  
					stream_IF.add(IF633);

					OPEN_BRACE634=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall7419);  
					stream_OPEN_BRACE.add(OPEN_BRACE634);

					pushFollow(FOLLOW_expression_in_builtInCall7423);
					e1=expression();
					state._fsp--;

					stream_expression.add(e1.getTree());
					COMMA635=(Token)match(input,COMMA,FOLLOW_COMMA_in_builtInCall7425);  
					stream_COMMA.add(COMMA635);

					pushFollow(FOLLOW_expression_in_builtInCall7429);
					e2=expression();
					state._fsp--;

					stream_expression.add(e2.getTree());
					COMMA636=(Token)match(input,COMMA,FOLLOW_COMMA_in_builtInCall7431);  
					stream_COMMA.add(COMMA636);

					pushFollow(FOLLOW_expression_in_builtInCall7435);
					e3=expression();
					state._fsp--;

					stream_expression.add(e3.getTree());
					CLOSE_BRACE637=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall7437);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE637);

					// AST REWRITE
					// elements: IF, e1, e2, e3
					// token labels: 
					// rule labels: e3, retval, e1, e2
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_e3=new RewriteRuleSubtreeStream(adaptor,"rule e3",e3!=null?e3.getTree():null);
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);
					RewriteRuleSubtreeStream stream_e1=new RewriteRuleSubtreeStream(adaptor,"rule e1",e1!=null?e1.getTree():null);
					RewriteRuleSubtreeStream stream_e2=new RewriteRuleSubtreeStream(adaptor,"rule e2",e2!=null?e2.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 913:87: -> ^( IF $e1 $e2 $e3)
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:913:90: ^( IF $e1 $e2 $e3)
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_IF.nextNode(), root_1);
						adaptor.addChild(root_1, stream_e1.nextTree());
						adaptor.addChild(root_1, stream_e2.nextTree());
						adaptor.addChild(root_1, stream_e3.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 40 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:914:7: STRLANG OPEN_BRACE expression COMMA expression CLOSE_BRACE
					{
					STRLANG638=(Token)match(input,STRLANG,FOLLOW_STRLANG_in_builtInCall7460);  
					stream_STRLANG.add(STRLANG638);

					OPEN_BRACE639=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall7462);  
					stream_OPEN_BRACE.add(OPEN_BRACE639);

					pushFollow(FOLLOW_expression_in_builtInCall7464);
					expression640=expression();
					state._fsp--;

					stream_expression.add(expression640.getTree());
					COMMA641=(Token)match(input,COMMA,FOLLOW_COMMA_in_builtInCall7466);  
					stream_COMMA.add(COMMA641);

					pushFollow(FOLLOW_expression_in_builtInCall7468);
					expression642=expression();
					state._fsp--;

					stream_expression.add(expression642.getTree());
					CLOSE_BRACE643=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall7470);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE643);

					// AST REWRITE
					// elements: STRLANG, expression, expression
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 914:66: -> ^( STRLANG expression expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:914:69: ^( STRLANG expression expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_STRLANG.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 41 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:915:7: STRDT OPEN_BRACE expression COMMA expression CLOSE_BRACE
					{
					STRDT644=(Token)match(input,STRDT,FOLLOW_STRDT_in_builtInCall7488);  
					stream_STRDT.add(STRDT644);

					OPEN_BRACE645=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall7490);  
					stream_OPEN_BRACE.add(OPEN_BRACE645);

					pushFollow(FOLLOW_expression_in_builtInCall7492);
					expression646=expression();
					state._fsp--;

					stream_expression.add(expression646.getTree());
					COMMA647=(Token)match(input,COMMA,FOLLOW_COMMA_in_builtInCall7494);  
					stream_COMMA.add(COMMA647);

					pushFollow(FOLLOW_expression_in_builtInCall7496);
					expression648=expression();
					state._fsp--;

					stream_expression.add(expression648.getTree());
					CLOSE_BRACE649=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall7498);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE649);

					// AST REWRITE
					// elements: STRDT, expression, expression
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 915:64: -> ^( STRDT expression expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:915:67: ^( STRDT expression expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_STRDT.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 42 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:916:7: SAMETERM OPEN_BRACE expression COMMA expression CLOSE_BRACE
					{
					SAMETERM650=(Token)match(input,SAMETERM,FOLLOW_SAMETERM_in_builtInCall7516);  
					stream_SAMETERM.add(SAMETERM650);

					OPEN_BRACE651=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall7518);  
					stream_OPEN_BRACE.add(OPEN_BRACE651);

					pushFollow(FOLLOW_expression_in_builtInCall7520);
					expression652=expression();
					state._fsp--;

					stream_expression.add(expression652.getTree());
					COMMA653=(Token)match(input,COMMA,FOLLOW_COMMA_in_builtInCall7522);  
					stream_COMMA.add(COMMA653);

					pushFollow(FOLLOW_expression_in_builtInCall7524);
					expression654=expression();
					state._fsp--;

					stream_expression.add(expression654.getTree());
					CLOSE_BRACE655=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall7526);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE655);

					// AST REWRITE
					// elements: expression, expression, SAMETERM
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 916:67: -> ^( SAMETERM expression expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:916:70: ^( SAMETERM expression expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_SAMETERM.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 43 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:917:7: ISIRI OPEN_BRACE expression CLOSE_BRACE
					{
					ISIRI656=(Token)match(input,ISIRI,FOLLOW_ISIRI_in_builtInCall7544);  
					stream_ISIRI.add(ISIRI656);

					OPEN_BRACE657=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall7546);  
					stream_OPEN_BRACE.add(OPEN_BRACE657);

					pushFollow(FOLLOW_expression_in_builtInCall7548);
					expression658=expression();
					state._fsp--;

					stream_expression.add(expression658.getTree());
					CLOSE_BRACE659=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall7550);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE659);

					// AST REWRITE
					// elements: expression, ISIRI
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 917:47: -> ^( ISIRI expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:917:50: ^( ISIRI expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_ISIRI.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 44 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:918:7: ISURI OPEN_BRACE expression CLOSE_BRACE
					{
					ISURI660=(Token)match(input,ISURI,FOLLOW_ISURI_in_builtInCall7566);  
					stream_ISURI.add(ISURI660);

					OPEN_BRACE661=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall7568);  
					stream_OPEN_BRACE.add(OPEN_BRACE661);

					pushFollow(FOLLOW_expression_in_builtInCall7570);
					expression662=expression();
					state._fsp--;

					stream_expression.add(expression662.getTree());
					CLOSE_BRACE663=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall7572);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE663);

					// AST REWRITE
					// elements: expression, ISURI
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 918:47: -> ^( ISURI expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:918:50: ^( ISURI expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_ISURI.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 45 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:919:7: ISBLANK OPEN_BRACE expression CLOSE_BRACE
					{
					ISBLANK664=(Token)match(input,ISBLANK,FOLLOW_ISBLANK_in_builtInCall7588);  
					stream_ISBLANK.add(ISBLANK664);

					OPEN_BRACE665=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall7590);  
					stream_OPEN_BRACE.add(OPEN_BRACE665);

					pushFollow(FOLLOW_expression_in_builtInCall7592);
					expression666=expression();
					state._fsp--;

					stream_expression.add(expression666.getTree());
					CLOSE_BRACE667=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall7594);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE667);

					// AST REWRITE
					// elements: expression, ISBLANK
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 919:49: -> ^( ISBLANK expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:919:52: ^( ISBLANK expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_ISBLANK.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 46 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:920:7: ISLITERAL OPEN_BRACE expression CLOSE_BRACE
					{
					ISLITERAL668=(Token)match(input,ISLITERAL,FOLLOW_ISLITERAL_in_builtInCall7611);  
					stream_ISLITERAL.add(ISLITERAL668);

					OPEN_BRACE669=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall7613);  
					stream_OPEN_BRACE.add(OPEN_BRACE669);

					pushFollow(FOLLOW_expression_in_builtInCall7615);
					expression670=expression();
					state._fsp--;

					stream_expression.add(expression670.getTree());
					CLOSE_BRACE671=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall7617);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE671);

					// AST REWRITE
					// elements: ISLITERAL, expression
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 920:51: -> ^( ISLITERAL expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:920:54: ^( ISLITERAL expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_ISLITERAL.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 47 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:921:7: ISNUMERIC OPEN_BRACE expression CLOSE_BRACE
					{
					ISNUMERIC672=(Token)match(input,ISNUMERIC,FOLLOW_ISNUMERIC_in_builtInCall7633);  
					stream_ISNUMERIC.add(ISNUMERIC672);

					OPEN_BRACE673=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_builtInCall7635);  
					stream_OPEN_BRACE.add(OPEN_BRACE673);

					pushFollow(FOLLOW_expression_in_builtInCall7637);
					expression674=expression();
					state._fsp--;

					stream_expression.add(expression674.getTree());
					CLOSE_BRACE675=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_builtInCall7639);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE675);

					// AST REWRITE
					// elements: ISNUMERIC, expression
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 921:51: -> ^( ISNUMERIC expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:921:54: ^( ISNUMERIC expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_ISNUMERIC.nextNode(), root_1);
						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 48 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:922:7: regexExpression
					{
					pushFollow(FOLLOW_regexExpression_in_builtInCall7655);
					regexExpression676=regexExpression();
					state._fsp--;

					stream_regexExpression.add(regexExpression676.getTree());
					// AST REWRITE
					// elements: regexExpression
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 922:23: -> regexExpression
					{
						adaptor.addChild(root_0, stream_regexExpression.nextTree());
					}


					retval.tree = root_0;

					}
					break;
				case 49 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:923:7: existsFunction
					{
					pushFollow(FOLLOW_existsFunction_in_builtInCall7667);
					existsFunction677=existsFunction();
					state._fsp--;

					stream_existsFunction.add(existsFunction677.getTree());
					// AST REWRITE
					// elements: existsFunction
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 923:22: -> existsFunction
					{
						adaptor.addChild(root_0, stream_existsFunction.nextTree());
					}


					retval.tree = root_0;

					}
					break;
				case 50 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:924:7: notExistsFunction
					{
					pushFollow(FOLLOW_notExistsFunction_in_builtInCall7679);
					notExistsFunction678=notExistsFunction();
					state._fsp--;

					stream_notExistsFunction.add(notExistsFunction678.getTree());
					// AST REWRITE
					// elements: notExistsFunction
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 924:25: -> notExistsFunction
					{
						adaptor.addChild(root_0, stream_notExistsFunction.nextTree());
					}


					retval.tree = root_0;

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "builtInCall"


	public static class regexExpression_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "regexExpression"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:927:1: regexExpression : REGEX OPEN_BRACE expression COMMA expression ( COMMA expression )? CLOSE_BRACE -> ^( REGEX ( expression )* ) ;
	public final SparqlifyConfigParser.regexExpression_return regexExpression() throws RecognitionException {
		SparqlifyConfigParser.regexExpression_return retval = new SparqlifyConfigParser.regexExpression_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token REGEX679=null;
		Token OPEN_BRACE680=null;
		Token COMMA682=null;
		Token COMMA684=null;
		Token CLOSE_BRACE686=null;
		ParserRuleReturnScope expression681 =null;
		ParserRuleReturnScope expression683 =null;
		ParserRuleReturnScope expression685 =null;

		CommonTree REGEX679_tree=null;
		CommonTree OPEN_BRACE680_tree=null;
		CommonTree COMMA682_tree=null;
		CommonTree COMMA684_tree=null;
		CommonTree CLOSE_BRACE686_tree=null;
		RewriteRuleTokenStream stream_REGEX=new RewriteRuleTokenStream(adaptor,"token REGEX");
		RewriteRuleTokenStream stream_CLOSE_BRACE=new RewriteRuleTokenStream(adaptor,"token CLOSE_BRACE");
		RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
		RewriteRuleTokenStream stream_OPEN_BRACE=new RewriteRuleTokenStream(adaptor,"token OPEN_BRACE");
		RewriteRuleSubtreeStream stream_expression=new RewriteRuleSubtreeStream(adaptor,"rule expression");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:928:5: ( REGEX OPEN_BRACE expression COMMA expression ( COMMA expression )? CLOSE_BRACE -> ^( REGEX ( expression )* ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:928:7: REGEX OPEN_BRACE expression COMMA expression ( COMMA expression )? CLOSE_BRACE
			{
			REGEX679=(Token)match(input,REGEX,FOLLOW_REGEX_in_regexExpression7700);  
			stream_REGEX.add(REGEX679);

			OPEN_BRACE680=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_regexExpression7702);  
			stream_OPEN_BRACE.add(OPEN_BRACE680);

			pushFollow(FOLLOW_expression_in_regexExpression7704);
			expression681=expression();
			state._fsp--;

			stream_expression.add(expression681.getTree());
			COMMA682=(Token)match(input,COMMA,FOLLOW_COMMA_in_regexExpression7706);  
			stream_COMMA.add(COMMA682);

			pushFollow(FOLLOW_expression_in_regexExpression7708);
			expression683=expression();
			state._fsp--;

			stream_expression.add(expression683.getTree());
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:928:52: ( COMMA expression )?
			int alt157=2;
			int LA157_0 = input.LA(1);
			if ( (LA157_0==COMMA) ) {
				alt157=1;
			}
			switch (alt157) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:928:54: COMMA expression
					{
					COMMA684=(Token)match(input,COMMA,FOLLOW_COMMA_in_regexExpression7712);  
					stream_COMMA.add(COMMA684);

					pushFollow(FOLLOW_expression_in_regexExpression7714);
					expression685=expression();
					state._fsp--;

					stream_expression.add(expression685.getTree());
					}
					break;

			}

			CLOSE_BRACE686=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_regexExpression7719);  
			stream_CLOSE_BRACE.add(CLOSE_BRACE686);

			// AST REWRITE
			// elements: REGEX, expression
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 928:86: -> ^( REGEX ( expression )* )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:928:89: ^( REGEX ( expression )* )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot(stream_REGEX.nextNode(), root_1);
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:928:97: ( expression )*
				while ( stream_expression.hasNext() ) {
					adaptor.addChild(root_1, stream_expression.nextTree());
				}
				stream_expression.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "regexExpression"


	public static class subStringExpression_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "subStringExpression"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:931:1: subStringExpression : SUBSTR OPEN_BRACE expression COMMA expression ( COMMA expression )? CLOSE_BRACE -> ^( SUBSTR ( expression )* ) ;
	public final SparqlifyConfigParser.subStringExpression_return subStringExpression() throws RecognitionException {
		SparqlifyConfigParser.subStringExpression_return retval = new SparqlifyConfigParser.subStringExpression_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token SUBSTR687=null;
		Token OPEN_BRACE688=null;
		Token COMMA690=null;
		Token COMMA692=null;
		Token CLOSE_BRACE694=null;
		ParserRuleReturnScope expression689 =null;
		ParserRuleReturnScope expression691 =null;
		ParserRuleReturnScope expression693 =null;

		CommonTree SUBSTR687_tree=null;
		CommonTree OPEN_BRACE688_tree=null;
		CommonTree COMMA690_tree=null;
		CommonTree COMMA692_tree=null;
		CommonTree CLOSE_BRACE694_tree=null;
		RewriteRuleTokenStream stream_CLOSE_BRACE=new RewriteRuleTokenStream(adaptor,"token CLOSE_BRACE");
		RewriteRuleTokenStream stream_SUBSTR=new RewriteRuleTokenStream(adaptor,"token SUBSTR");
		RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
		RewriteRuleTokenStream stream_OPEN_BRACE=new RewriteRuleTokenStream(adaptor,"token OPEN_BRACE");
		RewriteRuleSubtreeStream stream_expression=new RewriteRuleSubtreeStream(adaptor,"rule expression");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:932:5: ( SUBSTR OPEN_BRACE expression COMMA expression ( COMMA expression )? CLOSE_BRACE -> ^( SUBSTR ( expression )* ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:932:7: SUBSTR OPEN_BRACE expression COMMA expression ( COMMA expression )? CLOSE_BRACE
			{
			SUBSTR687=(Token)match(input,SUBSTR,FOLLOW_SUBSTR_in_subStringExpression7749);  
			stream_SUBSTR.add(SUBSTR687);

			OPEN_BRACE688=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_subStringExpression7751);  
			stream_OPEN_BRACE.add(OPEN_BRACE688);

			pushFollow(FOLLOW_expression_in_subStringExpression7753);
			expression689=expression();
			state._fsp--;

			stream_expression.add(expression689.getTree());
			COMMA690=(Token)match(input,COMMA,FOLLOW_COMMA_in_subStringExpression7755);  
			stream_COMMA.add(COMMA690);

			pushFollow(FOLLOW_expression_in_subStringExpression7757);
			expression691=expression();
			state._fsp--;

			stream_expression.add(expression691.getTree());
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:932:53: ( COMMA expression )?
			int alt158=2;
			int LA158_0 = input.LA(1);
			if ( (LA158_0==COMMA) ) {
				alt158=1;
			}
			switch (alt158) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:932:55: COMMA expression
					{
					COMMA692=(Token)match(input,COMMA,FOLLOW_COMMA_in_subStringExpression7761);  
					stream_COMMA.add(COMMA692);

					pushFollow(FOLLOW_expression_in_subStringExpression7763);
					expression693=expression();
					state._fsp--;

					stream_expression.add(expression693.getTree());
					}
					break;

			}

			CLOSE_BRACE694=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_subStringExpression7768);  
			stream_CLOSE_BRACE.add(CLOSE_BRACE694);

			// AST REWRITE
			// elements: expression, SUBSTR
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 932:87: -> ^( SUBSTR ( expression )* )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:932:90: ^( SUBSTR ( expression )* )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot(stream_SUBSTR.nextNode(), root_1);
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:932:99: ( expression )*
				while ( stream_expression.hasNext() ) {
					adaptor.addChild(root_1, stream_expression.nextTree());
				}
				stream_expression.reset();

				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "subStringExpression"


	public static class existsFunction_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "existsFunction"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:935:1: existsFunction : EXISTS groupGraphPattern -> ^( EXISTS groupGraphPattern ) ;
	public final SparqlifyConfigParser.existsFunction_return existsFunction() throws RecognitionException {
		SparqlifyConfigParser.existsFunction_return retval = new SparqlifyConfigParser.existsFunction_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token EXISTS695=null;
		ParserRuleReturnScope groupGraphPattern696 =null;

		CommonTree EXISTS695_tree=null;
		RewriteRuleTokenStream stream_EXISTS=new RewriteRuleTokenStream(adaptor,"token EXISTS");
		RewriteRuleSubtreeStream stream_groupGraphPattern=new RewriteRuleSubtreeStream(adaptor,"rule groupGraphPattern");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:936:5: ( EXISTS groupGraphPattern -> ^( EXISTS groupGraphPattern ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:936:7: EXISTS groupGraphPattern
			{
			EXISTS695=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_existsFunction7798);  
			stream_EXISTS.add(EXISTS695);

			pushFollow(FOLLOW_groupGraphPattern_in_existsFunction7800);
			groupGraphPattern696=groupGraphPattern();
			state._fsp--;

			stream_groupGraphPattern.add(groupGraphPattern696.getTree());
			// AST REWRITE
			// elements: groupGraphPattern, EXISTS
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 936:32: -> ^( EXISTS groupGraphPattern )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:936:35: ^( EXISTS groupGraphPattern )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot(stream_EXISTS.nextNode(), root_1);
				adaptor.addChild(root_1, stream_groupGraphPattern.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "existsFunction"


	public static class notExistsFunction_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "notExistsFunction"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:939:1: notExistsFunction : NOT EXISTS groupGraphPattern -> ^( NOT_EXISTS groupGraphPattern ) ;
	public final SparqlifyConfigParser.notExistsFunction_return notExistsFunction() throws RecognitionException {
		SparqlifyConfigParser.notExistsFunction_return retval = new SparqlifyConfigParser.notExistsFunction_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token NOT697=null;
		Token EXISTS698=null;
		ParserRuleReturnScope groupGraphPattern699 =null;

		CommonTree NOT697_tree=null;
		CommonTree EXISTS698_tree=null;
		RewriteRuleTokenStream stream_NOT=new RewriteRuleTokenStream(adaptor,"token NOT");
		RewriteRuleTokenStream stream_EXISTS=new RewriteRuleTokenStream(adaptor,"token EXISTS");
		RewriteRuleSubtreeStream stream_groupGraphPattern=new RewriteRuleSubtreeStream(adaptor,"rule groupGraphPattern");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:940:5: ( NOT EXISTS groupGraphPattern -> ^( NOT_EXISTS groupGraphPattern ) )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:940:7: NOT EXISTS groupGraphPattern
			{
			NOT697=(Token)match(input,NOT,FOLLOW_NOT_in_notExistsFunction7825);  
			stream_NOT.add(NOT697);

			EXISTS698=(Token)match(input,EXISTS,FOLLOW_EXISTS_in_notExistsFunction7827);  
			stream_EXISTS.add(EXISTS698);

			pushFollow(FOLLOW_groupGraphPattern_in_notExistsFunction7829);
			groupGraphPattern699=groupGraphPattern();
			state._fsp--;

			stream_groupGraphPattern.add(groupGraphPattern699.getTree());
			// AST REWRITE
			// elements: groupGraphPattern
			// token labels: 
			// rule labels: retval
			// token list labels: 
			// rule list labels: 
			// wildcard labels: 
			retval.tree = root_0;
			RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

			root_0 = (CommonTree)adaptor.nil();
			// 940:36: -> ^( NOT_EXISTS groupGraphPattern )
			{
				// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:940:39: ^( NOT_EXISTS groupGraphPattern )
				{
				CommonTree root_1 = (CommonTree)adaptor.nil();
				root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(NOT_EXISTS, "NOT_EXISTS"), root_1);
				adaptor.addChild(root_1, stream_groupGraphPattern.nextTree());
				adaptor.addChild(root_0, root_1);
				}

			}


			retval.tree = root_0;

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "notExistsFunction"


	public static class aggregate_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "aggregate"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:943:1: aggregate : ( COUNT OPEN_BRACE ( DISTINCT )? ( ASTERISK | expression ) CLOSE_BRACE -> ^( COUNT ( DISTINCT )* ( ASTERISK )* ( expression )* ) | SUM OPEN_BRACE ( DISTINCT )? expression CLOSE_BRACE -> ^( SUM ( DISTINCT )* expression ) | MIN OPEN_BRACE ( DISTINCT )? expression CLOSE_BRACE -> ^( MIN ( DISTINCT )* expression ) | MAX OPEN_BRACE ( DISTINCT )? expression CLOSE_BRACE -> ^( MAX ( DISTINCT )* expression ) | AVG OPEN_BRACE ( DISTINCT )? expression CLOSE_BRACE -> ^( AVG ( DISTINCT )* expression ) | SAMPLE OPEN_BRACE ( DISTINCT )? expression CLOSE_BRACE -> ^( SAMPLE ( DISTINCT )? expression ) | GROUP_CONCAT OPEN_BRACE ( DISTINCT )? expression ( SEMICOLON SEPARATOR EQUAL string )? CLOSE_BRACE -> ^( GROUP_CONCAT ( DISTINCT )* expression ( string )* ) );
	public final SparqlifyConfigParser.aggregate_return aggregate() throws RecognitionException {
		SparqlifyConfigParser.aggregate_return retval = new SparqlifyConfigParser.aggregate_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token COUNT700=null;
		Token OPEN_BRACE701=null;
		Token DISTINCT702=null;
		Token ASTERISK703=null;
		Token CLOSE_BRACE705=null;
		Token SUM706=null;
		Token OPEN_BRACE707=null;
		Token DISTINCT708=null;
		Token CLOSE_BRACE710=null;
		Token MIN711=null;
		Token OPEN_BRACE712=null;
		Token DISTINCT713=null;
		Token CLOSE_BRACE715=null;
		Token MAX716=null;
		Token OPEN_BRACE717=null;
		Token DISTINCT718=null;
		Token CLOSE_BRACE720=null;
		Token AVG721=null;
		Token OPEN_BRACE722=null;
		Token DISTINCT723=null;
		Token CLOSE_BRACE725=null;
		Token SAMPLE726=null;
		Token OPEN_BRACE727=null;
		Token DISTINCT728=null;
		Token CLOSE_BRACE730=null;
		Token GROUP_CONCAT731=null;
		Token OPEN_BRACE732=null;
		Token DISTINCT733=null;
		Token SEMICOLON735=null;
		Token SEPARATOR736=null;
		Token EQUAL737=null;
		Token CLOSE_BRACE739=null;
		ParserRuleReturnScope expression704 =null;
		ParserRuleReturnScope expression709 =null;
		ParserRuleReturnScope expression714 =null;
		ParserRuleReturnScope expression719 =null;
		ParserRuleReturnScope expression724 =null;
		ParserRuleReturnScope expression729 =null;
		ParserRuleReturnScope expression734 =null;
		ParserRuleReturnScope string738 =null;

		CommonTree COUNT700_tree=null;
		CommonTree OPEN_BRACE701_tree=null;
		CommonTree DISTINCT702_tree=null;
		CommonTree ASTERISK703_tree=null;
		CommonTree CLOSE_BRACE705_tree=null;
		CommonTree SUM706_tree=null;
		CommonTree OPEN_BRACE707_tree=null;
		CommonTree DISTINCT708_tree=null;
		CommonTree CLOSE_BRACE710_tree=null;
		CommonTree MIN711_tree=null;
		CommonTree OPEN_BRACE712_tree=null;
		CommonTree DISTINCT713_tree=null;
		CommonTree CLOSE_BRACE715_tree=null;
		CommonTree MAX716_tree=null;
		CommonTree OPEN_BRACE717_tree=null;
		CommonTree DISTINCT718_tree=null;
		CommonTree CLOSE_BRACE720_tree=null;
		CommonTree AVG721_tree=null;
		CommonTree OPEN_BRACE722_tree=null;
		CommonTree DISTINCT723_tree=null;
		CommonTree CLOSE_BRACE725_tree=null;
		CommonTree SAMPLE726_tree=null;
		CommonTree OPEN_BRACE727_tree=null;
		CommonTree DISTINCT728_tree=null;
		CommonTree CLOSE_BRACE730_tree=null;
		CommonTree GROUP_CONCAT731_tree=null;
		CommonTree OPEN_BRACE732_tree=null;
		CommonTree DISTINCT733_tree=null;
		CommonTree SEMICOLON735_tree=null;
		CommonTree SEPARATOR736_tree=null;
		CommonTree EQUAL737_tree=null;
		CommonTree CLOSE_BRACE739_tree=null;
		RewriteRuleTokenStream stream_SAMPLE=new RewriteRuleTokenStream(adaptor,"token SAMPLE");
		RewriteRuleTokenStream stream_AVG=new RewriteRuleTokenStream(adaptor,"token AVG");
		RewriteRuleTokenStream stream_EQUAL=new RewriteRuleTokenStream(adaptor,"token EQUAL");
		RewriteRuleTokenStream stream_GROUP_CONCAT=new RewriteRuleTokenStream(adaptor,"token GROUP_CONCAT");
		RewriteRuleTokenStream stream_MAX=new RewriteRuleTokenStream(adaptor,"token MAX");
		RewriteRuleTokenStream stream_COUNT=new RewriteRuleTokenStream(adaptor,"token COUNT");
		RewriteRuleTokenStream stream_SEMICOLON=new RewriteRuleTokenStream(adaptor,"token SEMICOLON");
		RewriteRuleTokenStream stream_SEPARATOR=new RewriteRuleTokenStream(adaptor,"token SEPARATOR");
		RewriteRuleTokenStream stream_CLOSE_BRACE=new RewriteRuleTokenStream(adaptor,"token CLOSE_BRACE");
		RewriteRuleTokenStream stream_MIN=new RewriteRuleTokenStream(adaptor,"token MIN");
		RewriteRuleTokenStream stream_SUM=new RewriteRuleTokenStream(adaptor,"token SUM");
		RewriteRuleTokenStream stream_DISTINCT=new RewriteRuleTokenStream(adaptor,"token DISTINCT");
		RewriteRuleTokenStream stream_OPEN_BRACE=new RewriteRuleTokenStream(adaptor,"token OPEN_BRACE");
		RewriteRuleTokenStream stream_ASTERISK=new RewriteRuleTokenStream(adaptor,"token ASTERISK");
		RewriteRuleSubtreeStream stream_expression=new RewriteRuleSubtreeStream(adaptor,"rule expression");
		RewriteRuleSubtreeStream stream_string=new RewriteRuleSubtreeStream(adaptor,"rule string");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:944:5: ( COUNT OPEN_BRACE ( DISTINCT )? ( ASTERISK | expression ) CLOSE_BRACE -> ^( COUNT ( DISTINCT )* ( ASTERISK )* ( expression )* ) | SUM OPEN_BRACE ( DISTINCT )? expression CLOSE_BRACE -> ^( SUM ( DISTINCT )* expression ) | MIN OPEN_BRACE ( DISTINCT )? expression CLOSE_BRACE -> ^( MIN ( DISTINCT )* expression ) | MAX OPEN_BRACE ( DISTINCT )? expression CLOSE_BRACE -> ^( MAX ( DISTINCT )* expression ) | AVG OPEN_BRACE ( DISTINCT )? expression CLOSE_BRACE -> ^( AVG ( DISTINCT )* expression ) | SAMPLE OPEN_BRACE ( DISTINCT )? expression CLOSE_BRACE -> ^( SAMPLE ( DISTINCT )? expression ) | GROUP_CONCAT OPEN_BRACE ( DISTINCT )? expression ( SEMICOLON SEPARATOR EQUAL string )? CLOSE_BRACE -> ^( GROUP_CONCAT ( DISTINCT )* expression ( string )* ) )
			int alt168=7;
			switch ( input.LA(1) ) {
			case COUNT:
				{
				alt168=1;
				}
				break;
			case SUM:
				{
				alt168=2;
				}
				break;
			case MIN:
				{
				alt168=3;
				}
				break;
			case MAX:
				{
				alt168=4;
				}
				break;
			case AVG:
				{
				alt168=5;
				}
				break;
			case SAMPLE:
				{
				alt168=6;
				}
				break;
			case GROUP_CONCAT:
				{
				alt168=7;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 168, 0, input);
				throw nvae;
			}
			switch (alt168) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:944:7: COUNT OPEN_BRACE ( DISTINCT )? ( ASTERISK | expression ) CLOSE_BRACE
					{
					COUNT700=(Token)match(input,COUNT,FOLLOW_COUNT_in_aggregate7854);  
					stream_COUNT.add(COUNT700);

					OPEN_BRACE701=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_aggregate7856);  
					stream_OPEN_BRACE.add(OPEN_BRACE701);

					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:944:24: ( DISTINCT )?
					int alt159=2;
					int LA159_0 = input.LA(1);
					if ( (LA159_0==DISTINCT) ) {
						alt159=1;
					}
					switch (alt159) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:944:24: DISTINCT
							{
							DISTINCT702=(Token)match(input,DISTINCT,FOLLOW_DISTINCT_in_aggregate7858);  
							stream_DISTINCT.add(DISTINCT702);

							}
							break;

					}

					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:944:34: ( ASTERISK | expression )
					int alt160=2;
					int LA160_0 = input.LA(1);
					if ( (LA160_0==ASTERISK) ) {
						alt160=1;
					}
					else if ( (LA160_0==ABS||LA160_0==AVG||(LA160_0 >= BNODE && LA160_0 <= BOUND)||LA160_0==CEIL||LA160_0==COALESCE||LA160_0==CONCAT||LA160_0==CONTAINS||LA160_0==COUNT||(LA160_0 >= DATATYPE && LA160_0 <= DECIMAL_POSITIVE)||(LA160_0 >= DOUBLE && LA160_0 <= DOUBLE_POSITIVE)||LA160_0==ENCODE_FOR_URI||LA160_0==EXISTS||LA160_0==FALSE||LA160_0==FLOOR||LA160_0==GROUP_CONCAT||(LA160_0 >= HOURS && LA160_0 <= IF)||(LA160_0 >= INTEGER && LA160_0 <= INTEGER_POSITIVE)||(LA160_0 >= IRI && LA160_0 <= IRI_REF)||(LA160_0 >= ISBLANK && LA160_0 <= ISURI)||(LA160_0 >= LANG && LA160_0 <= LANGMATCHES)||LA160_0==LCASE||(LA160_0 >= MAX && LA160_0 <= MINUS)||LA160_0==MINUTES||LA160_0==MONTH||LA160_0==NAME||LA160_0==NEGATION||LA160_0==NOT||LA160_0==NOW||LA160_0==OPEN_BRACE||(LA160_0 >= PLUS && LA160_0 <= PNAME_NS)||LA160_0==RAND||LA160_0==REGEX||(LA160_0 >= ROUND && LA160_0 <= SECONDS)||(LA160_0 >= SHA1 && LA160_0 <= SHA512)||(LA160_0 >= STR && LA160_0 <= STRENDS)||(LA160_0 >= STRING_LITERAL1 && LA160_0 <= STRSTARTS)||(LA160_0 >= SUBSTR && LA160_0 <= SUM)||LA160_0==TIMEZONE||LA160_0==TRUE||(LA160_0 >= TZ && LA160_0 <= UCASE)||LA160_0==URI||(LA160_0 >= VAR1 && LA160_0 <= VAR3)||LA160_0==YEAR) ) {
						alt160=2;
					}

					else {
						NoViableAltException nvae =
							new NoViableAltException("", 160, 0, input);
						throw nvae;
					}

					switch (alt160) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:944:36: ASTERISK
							{
							ASTERISK703=(Token)match(input,ASTERISK,FOLLOW_ASTERISK_in_aggregate7863);  
							stream_ASTERISK.add(ASTERISK703);

							}
							break;
						case 2 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:944:47: expression
							{
							pushFollow(FOLLOW_expression_in_aggregate7867);
							expression704=expression();
							state._fsp--;

							stream_expression.add(expression704.getTree());
							}
							break;

					}

					CLOSE_BRACE705=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_aggregate7871);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE705);

					// AST REWRITE
					// elements: DISTINCT, expression, COUNT, ASTERISK
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 944:72: -> ^( COUNT ( DISTINCT )* ( ASTERISK )* ( expression )* )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:944:75: ^( COUNT ( DISTINCT )* ( ASTERISK )* ( expression )* )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_COUNT.nextNode(), root_1);
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:944:83: ( DISTINCT )*
						while ( stream_DISTINCT.hasNext() ) {
							adaptor.addChild(root_1, stream_DISTINCT.nextNode());
						}
						stream_DISTINCT.reset();

						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:944:93: ( ASTERISK )*
						while ( stream_ASTERISK.hasNext() ) {
							adaptor.addChild(root_1, stream_ASTERISK.nextNode());
						}
						stream_ASTERISK.reset();

						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:944:103: ( expression )*
						while ( stream_expression.hasNext() ) {
							adaptor.addChild(root_1, stream_expression.nextTree());
						}
						stream_expression.reset();

						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:945:7: SUM OPEN_BRACE ( DISTINCT )? expression CLOSE_BRACE
					{
					SUM706=(Token)match(input,SUM,FOLLOW_SUM_in_aggregate7894);  
					stream_SUM.add(SUM706);

					OPEN_BRACE707=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_aggregate7896);  
					stream_OPEN_BRACE.add(OPEN_BRACE707);

					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:945:22: ( DISTINCT )?
					int alt161=2;
					int LA161_0 = input.LA(1);
					if ( (LA161_0==DISTINCT) ) {
						alt161=1;
					}
					switch (alt161) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:945:22: DISTINCT
							{
							DISTINCT708=(Token)match(input,DISTINCT,FOLLOW_DISTINCT_in_aggregate7898);  
							stream_DISTINCT.add(DISTINCT708);

							}
							break;

					}

					pushFollow(FOLLOW_expression_in_aggregate7901);
					expression709=expression();
					state._fsp--;

					stream_expression.add(expression709.getTree());
					CLOSE_BRACE710=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_aggregate7903);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE710);

					// AST REWRITE
					// elements: DISTINCT, expression, SUM
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 945:55: -> ^( SUM ( DISTINCT )* expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:945:58: ^( SUM ( DISTINCT )* expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_SUM.nextNode(), root_1);
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:945:64: ( DISTINCT )*
						while ( stream_DISTINCT.hasNext() ) {
							adaptor.addChild(root_1, stream_DISTINCT.nextNode());
						}
						stream_DISTINCT.reset();

						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:946:7: MIN OPEN_BRACE ( DISTINCT )? expression CLOSE_BRACE
					{
					MIN711=(Token)match(input,MIN,FOLLOW_MIN_in_aggregate7922);  
					stream_MIN.add(MIN711);

					OPEN_BRACE712=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_aggregate7924);  
					stream_OPEN_BRACE.add(OPEN_BRACE712);

					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:946:22: ( DISTINCT )?
					int alt162=2;
					int LA162_0 = input.LA(1);
					if ( (LA162_0==DISTINCT) ) {
						alt162=1;
					}
					switch (alt162) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:946:22: DISTINCT
							{
							DISTINCT713=(Token)match(input,DISTINCT,FOLLOW_DISTINCT_in_aggregate7926);  
							stream_DISTINCT.add(DISTINCT713);

							}
							break;

					}

					pushFollow(FOLLOW_expression_in_aggregate7929);
					expression714=expression();
					state._fsp--;

					stream_expression.add(expression714.getTree());
					CLOSE_BRACE715=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_aggregate7931);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE715);

					// AST REWRITE
					// elements: expression, MIN, DISTINCT
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 946:55: -> ^( MIN ( DISTINCT )* expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:946:58: ^( MIN ( DISTINCT )* expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_MIN.nextNode(), root_1);
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:946:64: ( DISTINCT )*
						while ( stream_DISTINCT.hasNext() ) {
							adaptor.addChild(root_1, stream_DISTINCT.nextNode());
						}
						stream_DISTINCT.reset();

						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 4 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:947:7: MAX OPEN_BRACE ( DISTINCT )? expression CLOSE_BRACE
					{
					MAX716=(Token)match(input,MAX,FOLLOW_MAX_in_aggregate7950);  
					stream_MAX.add(MAX716);

					OPEN_BRACE717=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_aggregate7952);  
					stream_OPEN_BRACE.add(OPEN_BRACE717);

					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:947:22: ( DISTINCT )?
					int alt163=2;
					int LA163_0 = input.LA(1);
					if ( (LA163_0==DISTINCT) ) {
						alt163=1;
					}
					switch (alt163) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:947:22: DISTINCT
							{
							DISTINCT718=(Token)match(input,DISTINCT,FOLLOW_DISTINCT_in_aggregate7954);  
							stream_DISTINCT.add(DISTINCT718);

							}
							break;

					}

					pushFollow(FOLLOW_expression_in_aggregate7957);
					expression719=expression();
					state._fsp--;

					stream_expression.add(expression719.getTree());
					CLOSE_BRACE720=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_aggregate7959);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE720);

					// AST REWRITE
					// elements: DISTINCT, expression, MAX
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 947:55: -> ^( MAX ( DISTINCT )* expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:947:58: ^( MAX ( DISTINCT )* expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_MAX.nextNode(), root_1);
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:947:64: ( DISTINCT )*
						while ( stream_DISTINCT.hasNext() ) {
							adaptor.addChild(root_1, stream_DISTINCT.nextNode());
						}
						stream_DISTINCT.reset();

						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 5 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:948:7: AVG OPEN_BRACE ( DISTINCT )? expression CLOSE_BRACE
					{
					AVG721=(Token)match(input,AVG,FOLLOW_AVG_in_aggregate7978);  
					stream_AVG.add(AVG721);

					OPEN_BRACE722=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_aggregate7980);  
					stream_OPEN_BRACE.add(OPEN_BRACE722);

					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:948:22: ( DISTINCT )?
					int alt164=2;
					int LA164_0 = input.LA(1);
					if ( (LA164_0==DISTINCT) ) {
						alt164=1;
					}
					switch (alt164) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:948:22: DISTINCT
							{
							DISTINCT723=(Token)match(input,DISTINCT,FOLLOW_DISTINCT_in_aggregate7982);  
							stream_DISTINCT.add(DISTINCT723);

							}
							break;

					}

					pushFollow(FOLLOW_expression_in_aggregate7985);
					expression724=expression();
					state._fsp--;

					stream_expression.add(expression724.getTree());
					CLOSE_BRACE725=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_aggregate7987);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE725);

					// AST REWRITE
					// elements: DISTINCT, expression, AVG
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 948:55: -> ^( AVG ( DISTINCT )* expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:948:58: ^( AVG ( DISTINCT )* expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_AVG.nextNode(), root_1);
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:948:64: ( DISTINCT )*
						while ( stream_DISTINCT.hasNext() ) {
							adaptor.addChild(root_1, stream_DISTINCT.nextNode());
						}
						stream_DISTINCT.reset();

						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 6 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:949:7: SAMPLE OPEN_BRACE ( DISTINCT )? expression CLOSE_BRACE
					{
					SAMPLE726=(Token)match(input,SAMPLE,FOLLOW_SAMPLE_in_aggregate8006);  
					stream_SAMPLE.add(SAMPLE726);

					OPEN_BRACE727=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_aggregate8008);  
					stream_OPEN_BRACE.add(OPEN_BRACE727);

					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:949:25: ( DISTINCT )?
					int alt165=2;
					int LA165_0 = input.LA(1);
					if ( (LA165_0==DISTINCT) ) {
						alt165=1;
					}
					switch (alt165) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:949:25: DISTINCT
							{
							DISTINCT728=(Token)match(input,DISTINCT,FOLLOW_DISTINCT_in_aggregate8010);  
							stream_DISTINCT.add(DISTINCT728);

							}
							break;

					}

					pushFollow(FOLLOW_expression_in_aggregate8013);
					expression729=expression();
					state._fsp--;

					stream_expression.add(expression729.getTree());
					CLOSE_BRACE730=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_aggregate8015);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE730);

					// AST REWRITE
					// elements: DISTINCT, expression, SAMPLE
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 949:58: -> ^( SAMPLE ( DISTINCT )? expression )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:949:61: ^( SAMPLE ( DISTINCT )? expression )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_SAMPLE.nextNode(), root_1);
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:949:70: ( DISTINCT )?
						if ( stream_DISTINCT.hasNext() ) {
							adaptor.addChild(root_1, stream_DISTINCT.nextNode());
						}
						stream_DISTINCT.reset();

						adaptor.addChild(root_1, stream_expression.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 7 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:950:7: GROUP_CONCAT OPEN_BRACE ( DISTINCT )? expression ( SEMICOLON SEPARATOR EQUAL string )? CLOSE_BRACE
					{
					GROUP_CONCAT731=(Token)match(input,GROUP_CONCAT,FOLLOW_GROUP_CONCAT_in_aggregate8034);  
					stream_GROUP_CONCAT.add(GROUP_CONCAT731);

					OPEN_BRACE732=(Token)match(input,OPEN_BRACE,FOLLOW_OPEN_BRACE_in_aggregate8036);  
					stream_OPEN_BRACE.add(OPEN_BRACE732);

					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:950:31: ( DISTINCT )?
					int alt166=2;
					int LA166_0 = input.LA(1);
					if ( (LA166_0==DISTINCT) ) {
						alt166=1;
					}
					switch (alt166) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:950:31: DISTINCT
							{
							DISTINCT733=(Token)match(input,DISTINCT,FOLLOW_DISTINCT_in_aggregate8038);  
							stream_DISTINCT.add(DISTINCT733);

							}
							break;

					}

					pushFollow(FOLLOW_expression_in_aggregate8041);
					expression734=expression();
					state._fsp--;

					stream_expression.add(expression734.getTree());
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:950:52: ( SEMICOLON SEPARATOR EQUAL string )?
					int alt167=2;
					int LA167_0 = input.LA(1);
					if ( (LA167_0==SEMICOLON) ) {
						alt167=1;
					}
					switch (alt167) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:950:54: SEMICOLON SEPARATOR EQUAL string
							{
							SEMICOLON735=(Token)match(input,SEMICOLON,FOLLOW_SEMICOLON_in_aggregate8045);  
							stream_SEMICOLON.add(SEMICOLON735);

							SEPARATOR736=(Token)match(input,SEPARATOR,FOLLOW_SEPARATOR_in_aggregate8047);  
							stream_SEPARATOR.add(SEPARATOR736);

							EQUAL737=(Token)match(input,EQUAL,FOLLOW_EQUAL_in_aggregate8049);  
							stream_EQUAL.add(EQUAL737);

							pushFollow(FOLLOW_string_in_aggregate8051);
							string738=string();
							state._fsp--;

							stream_string.add(string738.getTree());
							}
							break;

					}

					CLOSE_BRACE739=(Token)match(input,CLOSE_BRACE,FOLLOW_CLOSE_BRACE_in_aggregate8056);  
					stream_CLOSE_BRACE.add(CLOSE_BRACE739);

					// AST REWRITE
					// elements: GROUP_CONCAT, expression, DISTINCT, string
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 950:102: -> ^( GROUP_CONCAT ( DISTINCT )* expression ( string )* )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:950:105: ^( GROUP_CONCAT ( DISTINCT )* expression ( string )* )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot(stream_GROUP_CONCAT.nextNode(), root_1);
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:950:120: ( DISTINCT )*
						while ( stream_DISTINCT.hasNext() ) {
							adaptor.addChild(root_1, stream_DISTINCT.nextNode());
						}
						stream_DISTINCT.reset();

						adaptor.addChild(root_1, stream_expression.nextTree());
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:950:141: ( string )*
						while ( stream_string.hasNext() ) {
							adaptor.addChild(root_1, stream_string.nextTree());
						}
						stream_string.reset();

						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "aggregate"


	public static class iriRefOrFunction_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "iriRefOrFunction"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:953:1: iriRefOrFunction : ( iriRef | iriRef argList -> ^( FUNCTION iriRef ^( ARG_LIST argList ) ) );
	public final SparqlifyConfigParser.iriRefOrFunction_return iriRefOrFunction() throws RecognitionException {
		SparqlifyConfigParser.iriRefOrFunction_return retval = new SparqlifyConfigParser.iriRefOrFunction_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		ParserRuleReturnScope iriRef740 =null;
		ParserRuleReturnScope iriRef741 =null;
		ParserRuleReturnScope argList742 =null;

		RewriteRuleSubtreeStream stream_argList=new RewriteRuleSubtreeStream(adaptor,"rule argList");
		RewriteRuleSubtreeStream stream_iriRef=new RewriteRuleSubtreeStream(adaptor,"rule iriRef");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:954:5: ( iriRef | iriRef argList -> ^( FUNCTION iriRef ^( ARG_LIST argList ) ) )
			int alt169=2;
			int LA169_0 = input.LA(1);
			if ( (LA169_0==IRI_REF) ) {
				int LA169_1 = input.LA(2);
				if ( (LA169_1==EOF||LA169_1==AND||LA169_1==AS||LA169_1==ASTERISK||LA169_1==CLOSE_BRACE||LA169_1==COMMA||LA169_1==CREATE||(LA169_1 >= DECIMAL_NEGATIVE && LA169_1 <= DECLARE)||LA169_1==DEFINE||LA169_1==DIVIDE||(LA169_1 >= DOUBLE_NEGATIVE && LA169_1 <= DOUBLE_POSITIVE)||LA169_1==EQUAL||(LA169_1 >= GREATER && LA169_1 <= GREATER_EQUAL)||LA169_1==IN||(LA169_1 >= INTEGER_NEGATIVE && LA169_1 <= INTEGER_POSITIVE)||(LA169_1 >= LESS && LA169_1 <= LESS_EQUAL)||LA169_1==MINUS||(LA169_1 >= NOT && LA169_1 <= NOT_EQUAL)||LA169_1==OR||LA169_1==PLUS||LA169_1==PREFIX||LA169_1==SEMICOLON||LA169_1==SET) ) {
					alt169=1;
				}
				else if ( (LA169_1==OPEN_BRACE) ) {
					alt169=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 169, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}
			else if ( ((LA169_0 >= PNAME_LN && LA169_0 <= PNAME_NS)) ) {
				int LA169_2 = input.LA(2);
				if ( (LA169_2==EOF||LA169_2==AND||LA169_2==AS||LA169_2==ASTERISK||LA169_2==CLOSE_BRACE||LA169_2==COMMA||LA169_2==CREATE||(LA169_2 >= DECIMAL_NEGATIVE && LA169_2 <= DECLARE)||LA169_2==DEFINE||LA169_2==DIVIDE||(LA169_2 >= DOUBLE_NEGATIVE && LA169_2 <= DOUBLE_POSITIVE)||LA169_2==EQUAL||(LA169_2 >= GREATER && LA169_2 <= GREATER_EQUAL)||LA169_2==IN||(LA169_2 >= INTEGER_NEGATIVE && LA169_2 <= INTEGER_POSITIVE)||(LA169_2 >= LESS && LA169_2 <= LESS_EQUAL)||LA169_2==MINUS||(LA169_2 >= NOT && LA169_2 <= NOT_EQUAL)||LA169_2==OR||LA169_2==PLUS||LA169_2==PREFIX||LA169_2==SEMICOLON||LA169_2==SET) ) {
					alt169=1;
				}
				else if ( (LA169_2==OPEN_BRACE) ) {
					alt169=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 169, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 169, 0, input);
				throw nvae;
			}

			switch (alt169) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:954:7: iriRef
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_iriRef_in_iriRefOrFunction8091);
					iriRef740=iriRef();
					state._fsp--;

					adaptor.addChild(root_0, iriRef740.getTree());

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:955:7: iriRef argList
					{
					pushFollow(FOLLOW_iriRef_in_iriRefOrFunction8100);
					iriRef741=iriRef();
					state._fsp--;

					stream_iriRef.add(iriRef741.getTree());
					pushFollow(FOLLOW_argList_in_iriRefOrFunction8102);
					argList742=argList();
					state._fsp--;

					stream_argList.add(argList742.getTree());
					// AST REWRITE
					// elements: iriRef, argList
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 955:22: -> ^( FUNCTION iriRef ^( ARG_LIST argList ) )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:955:25: ^( FUNCTION iriRef ^( ARG_LIST argList ) )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(FUNCTION, "FUNCTION"), root_1);
						adaptor.addChild(root_1, stream_iriRef.nextTree());
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:955:43: ^( ARG_LIST argList )
						{
						CommonTree root_2 = (CommonTree)adaptor.nil();
						root_2 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(ARG_LIST, "ARG_LIST"), root_2);
						adaptor.addChild(root_2, stream_argList.nextTree());
						adaptor.addChild(root_1, root_2);
						}

						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "iriRefOrFunction"


	public static class rdfLiteral_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "rdfLiteral"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:958:1: rdfLiteral : ( string ( LANGTAG )? -> ^( PLAIN_LITERAL string ( LANGTAG )? ) | string REFERENCE iriRef -> ^( TYPED_LITERAL string iriRef ) );
	public final SparqlifyConfigParser.rdfLiteral_return rdfLiteral() throws RecognitionException {
		SparqlifyConfigParser.rdfLiteral_return retval = new SparqlifyConfigParser.rdfLiteral_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token LANGTAG744=null;
		Token REFERENCE746=null;
		ParserRuleReturnScope string743 =null;
		ParserRuleReturnScope string745 =null;
		ParserRuleReturnScope iriRef747 =null;

		CommonTree LANGTAG744_tree=null;
		CommonTree REFERENCE746_tree=null;
		RewriteRuleTokenStream stream_REFERENCE=new RewriteRuleTokenStream(adaptor,"token REFERENCE");
		RewriteRuleTokenStream stream_LANGTAG=new RewriteRuleTokenStream(adaptor,"token LANGTAG");
		RewriteRuleSubtreeStream stream_string=new RewriteRuleSubtreeStream(adaptor,"rule string");
		RewriteRuleSubtreeStream stream_iriRef=new RewriteRuleSubtreeStream(adaptor,"rule iriRef");

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:959:5: ( string ( LANGTAG )? -> ^( PLAIN_LITERAL string ( LANGTAG )? ) | string REFERENCE iriRef -> ^( TYPED_LITERAL string iriRef ) )
			int alt171=2;
			int LA171_0 = input.LA(1);
			if ( ((LA171_0 >= STRING_LITERAL1 && LA171_0 <= STRING_LITERAL_LONG2)) ) {
				int LA171_1 = input.LA(2);
				if ( (LA171_1==EOF||LA171_1==A||LA171_1==AND||LA171_1==AS||LA171_1==ASTERISK||LA171_1==BIND||LA171_1==BLANK_NODE_LABEL||(LA171_1 >= CLOSE_BRACE && LA171_1 <= CLOSE_SQUARE_BRACKET)||LA171_1==COMMA||LA171_1==CREATE||(LA171_1 >= DECIMAL && LA171_1 <= DECLARE)||LA171_1==DEFINE||(LA171_1 >= DIVIDE && LA171_1 <= DOUBLE_POSITIVE)||LA171_1==EQUAL||(LA171_1 >= FALSE && LA171_1 <= FILTER)||LA171_1==GRAPH||(LA171_1 >= GREATER && LA171_1 <= GREATER_EQUAL)||LA171_1==IN||(LA171_1 >= INTEGER && LA171_1 <= INTEGER_POSITIVE)||LA171_1==INVERSE||LA171_1==IRI_REF||LA171_1==LANGTAG||(LA171_1 >= LESS && LA171_1 <= LESS_EQUAL)||(LA171_1 >= MINUS && LA171_1 <= MINUS_KEYWORD)||LA171_1==NEGATION||(LA171_1 >= NOT && LA171_1 <= NOT_EQUAL)||(LA171_1 >= OPEN_BRACE && LA171_1 <= OR)||(LA171_1 >= PLUS && LA171_1 <= PNAME_NS)||LA171_1==PREFIX||LA171_1==SEMICOLON||(LA171_1 >= SERVICE && LA171_1 <= SET)||(LA171_1 >= STRING_LITERAL1 && LA171_1 <= STRING_LITERAL_LONG2)||LA171_1==TRUE||LA171_1==UNDEF||(LA171_1 >= VAR1 && LA171_1 <= VAR3)) ) {
					alt171=1;
				}
				else if ( (LA171_1==REFERENCE) ) {
					alt171=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 171, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 171, 0, input);
				throw nvae;
			}

			switch (alt171) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:959:7: string ( LANGTAG )?
					{
					pushFollow(FOLLOW_string_in_rdfLiteral8133);
					string743=string();
					state._fsp--;

					stream_string.add(string743.getTree());
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:959:14: ( LANGTAG )?
					int alt170=2;
					int LA170_0 = input.LA(1);
					if ( (LA170_0==LANGTAG) ) {
						alt170=1;
					}
					switch (alt170) {
						case 1 :
							// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:959:14: LANGTAG
							{
							LANGTAG744=(Token)match(input,LANGTAG,FOLLOW_LANGTAG_in_rdfLiteral8135);  
							stream_LANGTAG.add(LANGTAG744);

							}
							break;

					}

					// AST REWRITE
					// elements: LANGTAG, string
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 959:23: -> ^( PLAIN_LITERAL string ( LANGTAG )? )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:959:26: ^( PLAIN_LITERAL string ( LANGTAG )? )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(PLAIN_LITERAL, "PLAIN_LITERAL"), root_1);
						adaptor.addChild(root_1, stream_string.nextTree());
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:959:49: ( LANGTAG )?
						if ( stream_LANGTAG.hasNext() ) {
							adaptor.addChild(root_1, stream_LANGTAG.nextNode());
						}
						stream_LANGTAG.reset();

						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:960:7: string REFERENCE iriRef
					{
					pushFollow(FOLLOW_string_in_rdfLiteral8155);
					string745=string();
					state._fsp--;

					stream_string.add(string745.getTree());
					REFERENCE746=(Token)match(input,REFERENCE,FOLLOW_REFERENCE_in_rdfLiteral8157);  
					stream_REFERENCE.add(REFERENCE746);

					pushFollow(FOLLOW_iriRef_in_rdfLiteral8159);
					iriRef747=iriRef();
					state._fsp--;

					stream_iriRef.add(iriRef747.getTree());
					// AST REWRITE
					// elements: iriRef, string
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (CommonTree)adaptor.nil();
					// 960:31: -> ^( TYPED_LITERAL string iriRef )
					{
						// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:960:34: ^( TYPED_LITERAL string iriRef )
						{
						CommonTree root_1 = (CommonTree)adaptor.nil();
						root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(TYPED_LITERAL, "TYPED_LITERAL"), root_1);
						adaptor.addChild(root_1, stream_string.nextTree());
						adaptor.addChild(root_1, stream_iriRef.nextTree());
						adaptor.addChild(root_0, root_1);
						}

					}


					retval.tree = root_0;

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "rdfLiteral"


	public static class numericLiteral_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "numericLiteral"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:963:1: numericLiteral : ( numericLiteralUnsigned | numericLiteralPositive | numericLiteralNegative );
	public final SparqlifyConfigParser.numericLiteral_return numericLiteral() throws RecognitionException {
		SparqlifyConfigParser.numericLiteral_return retval = new SparqlifyConfigParser.numericLiteral_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		ParserRuleReturnScope numericLiteralUnsigned748 =null;
		ParserRuleReturnScope numericLiteralPositive749 =null;
		ParserRuleReturnScope numericLiteralNegative750 =null;


		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:964:5: ( numericLiteralUnsigned | numericLiteralPositive | numericLiteralNegative )
			int alt172=3;
			switch ( input.LA(1) ) {
			case DECIMAL:
			case DOUBLE:
			case INTEGER:
				{
				alt172=1;
				}
				break;
			case DECIMAL_POSITIVE:
			case DOUBLE_POSITIVE:
			case INTEGER_POSITIVE:
				{
				alt172=2;
				}
				break;
			case DECIMAL_NEGATIVE:
			case DOUBLE_NEGATIVE:
			case INTEGER_NEGATIVE:
				{
				alt172=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 172, 0, input);
				throw nvae;
			}
			switch (alt172) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:964:7: numericLiteralUnsigned
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_numericLiteralUnsigned_in_numericLiteral8186);
					numericLiteralUnsigned748=numericLiteralUnsigned();
					state._fsp--;

					adaptor.addChild(root_0, numericLiteralUnsigned748.getTree());

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:965:7: numericLiteralPositive
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_numericLiteralPositive_in_numericLiteral8194);
					numericLiteralPositive749=numericLiteralPositive();
					state._fsp--;

					adaptor.addChild(root_0, numericLiteralPositive749.getTree());

					}
					break;
				case 3 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:966:7: numericLiteralNegative
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_numericLiteralNegative_in_numericLiteral8202);
					numericLiteralNegative750=numericLiteralNegative();
					state._fsp--;

					adaptor.addChild(root_0, numericLiteralNegative750.getTree());

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "numericLiteral"


	public static class numericLiteralUnsigned_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "numericLiteralUnsigned"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:969:1: numericLiteralUnsigned : ( INTEGER | DECIMAL | DOUBLE );
	public final SparqlifyConfigParser.numericLiteralUnsigned_return numericLiteralUnsigned() throws RecognitionException {
		SparqlifyConfigParser.numericLiteralUnsigned_return retval = new SparqlifyConfigParser.numericLiteralUnsigned_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token set751=null;

		CommonTree set751_tree=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:970:5: ( INTEGER | DECIMAL | DOUBLE )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:
			{
			root_0 = (CommonTree)adaptor.nil();


			set751=input.LT(1);
			if ( input.LA(1)==DECIMAL||input.LA(1)==DOUBLE||input.LA(1)==INTEGER ) {
				input.consume();
				adaptor.addChild(root_0, (CommonTree)adaptor.create(set751));
				state.errorRecovery=false;
			}
			else {
				MismatchedSetException mse = new MismatchedSetException(null,input);
				throw mse;
			}
			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "numericLiteralUnsigned"


	public static class numericLiteralPositive_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "numericLiteralPositive"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:975:1: numericLiteralPositive : ( INTEGER_POSITIVE | DECIMAL_POSITIVE | DOUBLE_POSITIVE );
	public final SparqlifyConfigParser.numericLiteralPositive_return numericLiteralPositive() throws RecognitionException {
		SparqlifyConfigParser.numericLiteralPositive_return retval = new SparqlifyConfigParser.numericLiteralPositive_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token set752=null;

		CommonTree set752_tree=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:976:5: ( INTEGER_POSITIVE | DECIMAL_POSITIVE | DOUBLE_POSITIVE )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:
			{
			root_0 = (CommonTree)adaptor.nil();


			set752=input.LT(1);
			if ( input.LA(1)==DECIMAL_POSITIVE||input.LA(1)==DOUBLE_POSITIVE||input.LA(1)==INTEGER_POSITIVE ) {
				input.consume();
				adaptor.addChild(root_0, (CommonTree)adaptor.create(set752));
				state.errorRecovery=false;
			}
			else {
				MismatchedSetException mse = new MismatchedSetException(null,input);
				throw mse;
			}
			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "numericLiteralPositive"


	public static class numericLiteralNegative_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "numericLiteralNegative"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:981:1: numericLiteralNegative : ( INTEGER_NEGATIVE | DECIMAL_NEGATIVE | DOUBLE_NEGATIVE );
	public final SparqlifyConfigParser.numericLiteralNegative_return numericLiteralNegative() throws RecognitionException {
		SparqlifyConfigParser.numericLiteralNegative_return retval = new SparqlifyConfigParser.numericLiteralNegative_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token set753=null;

		CommonTree set753_tree=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:982:5: ( INTEGER_NEGATIVE | DECIMAL_NEGATIVE | DOUBLE_NEGATIVE )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:
			{
			root_0 = (CommonTree)adaptor.nil();


			set753=input.LT(1);
			if ( input.LA(1)==DECIMAL_NEGATIVE||input.LA(1)==DOUBLE_NEGATIVE||input.LA(1)==INTEGER_NEGATIVE ) {
				input.consume();
				adaptor.addChild(root_0, (CommonTree)adaptor.create(set753));
				state.errorRecovery=false;
			}
			else {
				MismatchedSetException mse = new MismatchedSetException(null,input);
				throw mse;
			}
			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "numericLiteralNegative"


	public static class booleanLiteral_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "booleanLiteral"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:987:1: booleanLiteral : ( TRUE | FALSE );
	public final SparqlifyConfigParser.booleanLiteral_return booleanLiteral() throws RecognitionException {
		SparqlifyConfigParser.booleanLiteral_return retval = new SparqlifyConfigParser.booleanLiteral_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token set754=null;

		CommonTree set754_tree=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:988:5: ( TRUE | FALSE )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:
			{
			root_0 = (CommonTree)adaptor.nil();


			set754=input.LT(1);
			if ( input.LA(1)==FALSE||input.LA(1)==TRUE ) {
				input.consume();
				adaptor.addChild(root_0, (CommonTree)adaptor.create(set754));
				state.errorRecovery=false;
			}
			else {
				MismatchedSetException mse = new MismatchedSetException(null,input);
				throw mse;
			}
			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "booleanLiteral"


	public static class string_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "string"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:992:1: string : ( STRING_LITERAL1 | STRING_LITERAL2 | STRING_LITERAL_LONG1 | STRING_LITERAL_LONG2 );
	public final SparqlifyConfigParser.string_return string() throws RecognitionException {
		SparqlifyConfigParser.string_return retval = new SparqlifyConfigParser.string_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token set755=null;

		CommonTree set755_tree=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:993:5: ( STRING_LITERAL1 | STRING_LITERAL2 | STRING_LITERAL_LONG1 | STRING_LITERAL_LONG2 )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:
			{
			root_0 = (CommonTree)adaptor.nil();


			set755=input.LT(1);
			if ( (input.LA(1) >= STRING_LITERAL1 && input.LA(1) <= STRING_LITERAL_LONG2) ) {
				input.consume();
				adaptor.addChild(root_0, (CommonTree)adaptor.create(set755));
				state.errorRecovery=false;
			}
			else {
				MismatchedSetException mse = new MismatchedSetException(null,input);
				throw mse;
			}
			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "string"


	public static class iriRef_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "iriRef"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:999:1: iriRef : ( IRI_REF | prefixedName );
	public final SparqlifyConfigParser.iriRef_return iriRef() throws RecognitionException {
		SparqlifyConfigParser.iriRef_return retval = new SparqlifyConfigParser.iriRef_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token IRI_REF756=null;
		ParserRuleReturnScope prefixedName757 =null;

		CommonTree IRI_REF756_tree=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:1000:5: ( IRI_REF | prefixedName )
			int alt173=2;
			int LA173_0 = input.LA(1);
			if ( (LA173_0==IRI_REF) ) {
				alt173=1;
			}
			else if ( ((LA173_0 >= PNAME_LN && LA173_0 <= PNAME_NS)) ) {
				alt173=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 173, 0, input);
				throw nvae;
			}

			switch (alt173) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:1000:7: IRI_REF
					{
					root_0 = (CommonTree)adaptor.nil();


					IRI_REF756=(Token)match(input,IRI_REF,FOLLOW_IRI_REF_in_iriRef8385); 
					IRI_REF756_tree = (CommonTree)adaptor.create(IRI_REF756);
					adaptor.addChild(root_0, IRI_REF756_tree);

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:1001:7: prefixedName
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_prefixedName_in_iriRef8393);
					prefixedName757=prefixedName();
					state._fsp--;

					adaptor.addChild(root_0, prefixedName757.getTree());

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "iriRef"


	public static class prefixedName_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "prefixedName"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:1004:1: prefixedName : ( PNAME_LN | PNAME_NS );
	public final SparqlifyConfigParser.prefixedName_return prefixedName() throws RecognitionException {
		SparqlifyConfigParser.prefixedName_return retval = new SparqlifyConfigParser.prefixedName_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token set758=null;

		CommonTree set758_tree=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:1005:5: ( PNAME_LN | PNAME_NS )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:
			{
			root_0 = (CommonTree)adaptor.nil();


			set758=input.LT(1);
			if ( (input.LA(1) >= PNAME_LN && input.LA(1) <= PNAME_NS) ) {
				input.consume();
				adaptor.addChild(root_0, (CommonTree)adaptor.create(set758));
				state.errorRecovery=false;
			}
			else {
				MismatchedSetException mse = new MismatchedSetException(null,input);
				throw mse;
			}
			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "prefixedName"


	public static class blankNode_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "blankNode"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:1009:1: blankNode : ( BLANK_NODE_LABEL | anon );
	public final SparqlifyConfigParser.blankNode_return blankNode() throws RecognitionException {
		SparqlifyConfigParser.blankNode_return retval = new SparqlifyConfigParser.blankNode_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token BLANK_NODE_LABEL759=null;
		ParserRuleReturnScope anon760 =null;

		CommonTree BLANK_NODE_LABEL759_tree=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:1010:5: ( BLANK_NODE_LABEL | anon )
			int alt174=2;
			int LA174_0 = input.LA(1);
			if ( (LA174_0==BLANK_NODE_LABEL) ) {
				alt174=1;
			}
			else if ( (LA174_0==OPEN_SQUARE_BRACKET) ) {
				alt174=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 174, 0, input);
				throw nvae;
			}

			switch (alt174) {
				case 1 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:1010:7: BLANK_NODE_LABEL
					{
					root_0 = (CommonTree)adaptor.nil();


					BLANK_NODE_LABEL759=(Token)match(input,BLANK_NODE_LABEL,FOLLOW_BLANK_NODE_LABEL_in_blankNode8435); 
					BLANK_NODE_LABEL759_tree = (CommonTree)adaptor.create(BLANK_NODE_LABEL759);
					adaptor.addChild(root_0, BLANK_NODE_LABEL759_tree);

					}
					break;
				case 2 :
					// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:1011:7: anon
					{
					root_0 = (CommonTree)adaptor.nil();


					pushFollow(FOLLOW_anon_in_blankNode8443);
					anon760=anon();
					state._fsp--;

					adaptor.addChild(root_0, anon760.getTree());

					}
					break;

			}
			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "blankNode"


	public static class anon_return extends ParserRuleReturnScope {
		CommonTree tree;
		@Override
		public CommonTree getTree() { return tree; }
	};


	// $ANTLR start "anon"
	// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:1014:1: anon : OPEN_SQUARE_BRACKET CLOSE_SQUARE_BRACKET ;
	public final SparqlifyConfigParser.anon_return anon() throws RecognitionException {
		SparqlifyConfigParser.anon_return retval = new SparqlifyConfigParser.anon_return();
		retval.start = input.LT(1);

		CommonTree root_0 = null;

		Token OPEN_SQUARE_BRACKET761=null;
		Token CLOSE_SQUARE_BRACKET762=null;

		CommonTree OPEN_SQUARE_BRACKET761_tree=null;
		CommonTree CLOSE_SQUARE_BRACKET762_tree=null;

		try {
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:1015:5: ( OPEN_SQUARE_BRACKET CLOSE_SQUARE_BRACKET )
			// org/aksw/sparqlify/config/lang/SparqlifyConfig.g:1015:7: OPEN_SQUARE_BRACKET CLOSE_SQUARE_BRACKET
			{
			root_0 = (CommonTree)adaptor.nil();


			OPEN_SQUARE_BRACKET761=(Token)match(input,OPEN_SQUARE_BRACKET,FOLLOW_OPEN_SQUARE_BRACKET_in_anon8460); 
			OPEN_SQUARE_BRACKET761_tree = (CommonTree)adaptor.create(OPEN_SQUARE_BRACKET761);
			adaptor.addChild(root_0, OPEN_SQUARE_BRACKET761_tree);

			CLOSE_SQUARE_BRACKET762=(Token)match(input,CLOSE_SQUARE_BRACKET,FOLLOW_CLOSE_SQUARE_BRACKET_in_anon8462); 
			CLOSE_SQUARE_BRACKET762_tree = (CommonTree)adaptor.create(CLOSE_SQUARE_BRACKET762);
			adaptor.addChild(root_0, CLOSE_SQUARE_BRACKET762_tree);

			}

			retval.stop = input.LT(-1);

			retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
			retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "anon"

	// Delegated rules


	protected DFA33 dfa33 = new DFA33(this);
	static final String DFA33_eotS =
		"\10\uffff";
	static final String DFA33_eofS =
		"\10\uffff";
	static final String DFA33_minS =
		"\1\6\1\147\1\u009f\2\uffff\1\6\1\147\1\6";
	static final String DFA33_maxS =
		"\1\u00f8\1\147\1\u009f\2\uffff\1\u00f8\1\147\1\u00f8";
	static final String DFA33_acceptS =
		"\3\uffff\1\1\1\2\3\uffff";
	static final String DFA33_specialS =
		"\10\uffff}>";
	static final String[] DFA33_transitionS = {
			"\1\4\10\uffff\1\3\2\uffff\1\1\11\uffff\1\4\12\uffff\1\3\4\uffff\1\4\1"+
			"\uffff\1\4\11\uffff\1\4\1\uffff\1\3\7\uffff\1\4\35\uffff\1\4\26\uffff"+
			"\1\4\11\uffff\1\4\44\uffff\1\2\20\uffff\1\3\100\uffff\1\4",
			"\1\5",
			"\1\6",
			"",
			"",
			"\1\4\10\uffff\1\3\2\uffff\1\1\11\uffff\1\4\12\uffff\1\3\4\uffff\1\4"+
			"\1\uffff\1\4\11\uffff\1\4\1\uffff\1\3\7\uffff\1\4\35\uffff\1\4\26\uffff"+
			"\1\4\11\uffff\1\4\44\uffff\1\2\20\uffff\1\3\100\uffff\1\4",
			"\1\7",
			"\1\4\10\uffff\1\3\2\uffff\1\1\11\uffff\1\4\12\uffff\1\3\4\uffff\1\4"+
			"\1\uffff\1\4\11\uffff\1\4\1\uffff\1\3\7\uffff\1\4\35\uffff\1\4\26\uffff"+
			"\1\4\11\uffff\1\4\44\uffff\1\2\20\uffff\1\3\100\uffff\1\4"
	};

	static final short[] DFA33_eot = DFA.unpackEncodedString(DFA33_eotS);
	static final short[] DFA33_eof = DFA.unpackEncodedString(DFA33_eofS);
	static final char[] DFA33_min = DFA.unpackEncodedStringToUnsignedChars(DFA33_minS);
	static final char[] DFA33_max = DFA.unpackEncodedStringToUnsignedChars(DFA33_maxS);
	static final short[] DFA33_accept = DFA.unpackEncodedString(DFA33_acceptS);
	static final short[] DFA33_special = DFA.unpackEncodedString(DFA33_specialS);
	static final short[][] DFA33_transition;

	static {
		int numStates = DFA33_transitionS.length;
		DFA33_transition = new short[numStates][];
		for (int i=0; i<numStates; i++) {
			DFA33_transition[i] = DFA.unpackEncodedString(DFA33_transitionS[i]);
		}
	}

	protected class DFA33 extends DFA {

		public DFA33(BaseRecognizer recognizer) {
			this.recognizer = recognizer;
			this.decisionNumber = 33;
			this.eot = DFA33_eot;
			this.eof = DFA33_eof;
			this.min = DFA33_min;
			this.max = DFA33_max;
			this.accept = DFA33_accept;
			this.special = DFA33_special;
			this.transition = DFA33_transition;
		}
		@Override
		public String getDescription() {
			return "388:1: query : ( prologue ( selectQuery | constructQuery | describeQuery | askQuery ) bindingsClause EOF -> ^( QUERY prologue ( selectQuery )* ( constructQuery )* ( describeQuery )* ( askQuery )* ) ( bindingsClause )* | update ( SEMICOLON update )* EOF -> ^( UPDATE ( update )+ ) );";
		}
	}

	public static final BitSet FOLLOW_sparqlifyConfigStmt_in_sparqlifyConfig272 = new BitSet(new long[]{0x00A0400000000000L,0x0000000000000000L,0x1000004000000000L});
	public static final BitSet FOLLOW_EOF_in_sparqlifyConfig275 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_constructViewConfigStmt_in_constructViewConfig294 = new BitSet(new long[]{0x0000400000000000L,0x0000000000000000L,0x0000004000000000L});
	public static final BitSet FOLLOW_EOF_in_constructViewConfig297 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_viewDefStmtConstruct_in_constructViewConfigStmt316 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_prefixDefStmt_in_constructViewConfigStmt324 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_viewDefStmt_in_sparqlifyConfigStmt345 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_prefixDefStmt_in_sparqlifyConfigStmt353 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_macroStmt_in_sparqlifyConfigStmt361 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_functionDeclarationStmt_in_sparqlifyConfigStmt369 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_setStmt_in_sparqlifyConfigStmt377 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SET_in_setStmt396 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_NAME_in_setStmt398 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000040L});
	public static final BitSet FOLLOW_EQUAL_in_setStmt400 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x000000000000F000L});
	public static final BitSet FOLLOW_string_in_setStmt402 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0200000000000000L});
	public static final BitSet FOLLOW_SEMICOLON_in_setStmt404 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DECLARE_in_functionDeclarationStmt432 = new BitSet(new long[]{0x0000000000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_FUNCTION_in_functionDeclarationStmt434 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_functionSignature_in_functionDeclarationStmt436 = new BitSet(new long[]{0x0000000000002000L});
	public static final BitSet FOLLOW_AS_in_functionDeclarationStmt438 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_functionTemplate_in_functionDeclarationStmt440 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0200000000000000L});
	public static final BitSet FOLLOW_SEMICOLON_in_functionDeclarationStmt442 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NAME_in_functionSignature478 = new BitSet(new long[]{0x0000000000000000L,0x0000008000000000L,0x00000000C0000000L});
	public static final BitSet FOLLOW_iriRef_in_functionSignature480 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_parameterTypeList_in_functionSignature482 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_nil_in_parameterTypeList517 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_parameterTypeList539 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_parameterType_in_parameterTypeList541 = new BitSet(new long[]{0x0000000420000000L});
	public static final BitSet FOLLOW_COMMA_in_parameterTypeList544 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_parameterType_in_parameterTypeList546 = new BitSet(new long[]{0x0000000420000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_parameterTypeList550 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NAME_in_parameterType584 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000700000000000L});
	public static final BitSet FOLLOW_var_in_parameterType586 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NAME_in_functionTemplate622 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_expressionList_in_functionTemplate624 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_templateConfigStmt_in_templateConfig659 = new BitSet(new long[]{0x0000400000000000L,0x0000000000000000L,0x0000004000000000L});
	public static final BitSet FOLLOW_EOF_in_templateConfig662 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_viewTemplateDefStmt_in_templateConfigStmt675 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_prefixDefStmt_in_templateConfigStmt680 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IMPORT_in_importStmt694 = new BitSet(new long[]{0x0000000000000000L,0x0000008000000000L,0x00000000C0000000L});
	public static final BitSet FOLLOW_iriOrFileRef_in_importStmt696 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_iriRef_in_iriOrFileRef713 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CREATE_in_viewDefStmt730 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_VIEW_in_viewDefStmt732 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_NAME_in_viewDefStmt734 = new BitSet(new long[]{0x0000000000002000L});
	public static final BitSet FOLLOW_AS_in_viewDefStmt736 = new BitSet(new long[]{0x0000008000000000L});
	public static final BitSet FOLLOW_CONSTRUCT_in_viewDefStmt738 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_viewTemplateDef_in_viewDefStmt740 = new BitSet(new long[]{0x0000002000000002L,0x0000000000002000L,0x0200000000000000L});
	public static final BitSet FOLLOW_varConstraintsClause_in_viewDefStmt742 = new BitSet(new long[]{0x0000000000000002L,0x0000000000002000L,0x0200000000000000L});
	public static final BitSet FOLLOW_FROM_in_viewDefStmt746 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000004L,0x0000000000002020L});
	public static final BitSet FOLLOW_relationRef_in_viewDefStmt748 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0200000000000000L});
	public static final BitSet FOLLOW_SEMICOLON_in_viewDefStmt752 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CREATE_in_viewDefStmtConstruct791 = new BitSet(new long[]{0x0000008000000000L});
	public static final BitSet FOLLOW_CONSTRUCT_in_viewDefStmtConstruct793 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_VIEW_in_viewDefStmtConstruct795 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_NAME_in_viewDefStmtConstruct797 = new BitSet(new long[]{0x0000000000002000L});
	public static final BitSet FOLLOW_AS_in_viewDefStmtConstruct799 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000000020L});
	public static final BitSet FOLLOW_SQL_QUERY_in_viewDefStmtConstruct801 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0200000000000000L});
	public static final BitSet FOLLOW_SEMICOLON_in_viewDefStmtConstruct803 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CONSTRAIN_in_varConstraintsClause839 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000700000000000L});
	public static final BitSet FOLLOW_varConstraint_in_varConstraintsClause841 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000000L,0x0000700000000000L});
	public static final BitSet FOLLOW_regexValueConstraint_in_varConstraint873 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_prefixValueConstraint_in_varConstraint881 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_var_in_regexValueConstraint910 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0001000000000000L});
	public static final BitSet FOLLOW_REGEX_in_regexValueConstraint912 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x000000000000F000L});
	public static final BitSet FOLLOW_string_in_regexValueConstraint914 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_var_in_prefixValueConstraint949 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000004000000000L});
	public static final BitSet FOLLOW_PREFIX_in_prefixValueConstraint951 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x000000000000F000L});
	public static final BitSet FOLLOW_stringList_in_prefixValueConstraint953 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_string_in_stringList988 = new BitSet(new long[]{0x0000000400000002L,0x0000000000000000L,0x0000000000000000L,0x000000000000F000L});
	public static final BitSet FOLLOW_COMMA_in_stringList991 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x000000000000F000L});
	public static final BitSet FOLLOW_string_in_stringList994 = new BitSet(new long[]{0x0000000400000002L,0x0000000000000000L,0x0000000000000000L,0x000000000000F000L});
	public static final BitSet FOLLOW_DOT_in_memberAccess1028 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_NAME_in_memberAccess1030 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CREATE_in_viewTemplateDefStmt1047 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0008000000000000L});
	public static final BitSet FOLLOW_VIEW_in_viewTemplateDefStmt1049 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000800000L});
	public static final BitSet FOLLOW_TEMPLATE_in_viewTemplateDefStmt1051 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_NAME_in_viewTemplateDefStmt1053 = new BitSet(new long[]{0x0000000000002000L});
	public static final BitSet FOLLOW_AS_in_viewTemplateDefStmt1055 = new BitSet(new long[]{0x0000008000000000L});
	public static final BitSet FOLLOW_CONSTRUCT_in_viewTemplateDefStmt1057 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_viewTemplateDef_in_viewTemplateDefStmt1059 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0200000000000000L});
	public static final BitSet FOLLOW_SEMICOLON_in_viewTemplateDefStmt1061 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_constructTemplateQuads_in_viewTemplateDef1091 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000000L,0x0100000000000000L});
	public static final BitSet FOLLOW_varBindingPart_in_viewTemplateDef1093 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_prefixDecl_in_prefixDefStmt1122 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DEFINE_in_macroStmt1143 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_expression_in_macroStmt1145 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_joinClause_in_relationRef1172 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_WHERE_in_relationRef1175 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_expression_in_relationRef1179 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_joinClauseMember_in_joinClause1209 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_joinClauseMember_in_joinClause1216 = new BitSet(new long[]{0x0000000400000000L});
	public static final BitSet FOLLOW_COMMA_in_joinClause1218 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000004L,0x0000000000002020L});
	public static final BitSet FOLLOW_joinClause_in_joinClause1222 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_logicalTable_in_joinClauseMember1255 = new BitSet(new long[]{0x0000000000002012L,0x0000000000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_AS_in_joinClauseMember1258 = new BitSet(new long[]{0x0000000000000010L,0x0000000000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_name_in_joinClauseMember1263 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NAME_in_name1295 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_A_in_name1305 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SQL_QUERY_in_logicalTable1332 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NAME_in_logicalTable1351 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRING_LITERAL2_in_logicalTable1370 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_WITH_in_varBindingPart1403 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000700000000000L});
	public static final BitSet FOLLOW_varBinding_in_varBindingPart1405 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000000L,0x0000700000000000L});
	public static final BitSet FOLLOW_var_in_varBinding1435 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000040L});
	public static final BitSet FOLLOW_EQUAL_in_varBinding1437 = new BitSet(new long[]{0x0000000001000000L,0x0000000000000000L,0x0000000010000000L,0x0000020080000000L});
	public static final BitSet FOLLOW_typeCtorExpression_in_varBinding1439 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_BNODE_in_typeCtorExpression1467 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_typeCtorExpression1469 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_expression_in_typeCtorExpression1471 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_typeCtorExpression1473 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_URI_in_typeCtorExpression1489 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_typeCtorExpression1491 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_expression_in_typeCtorExpression1493 = new BitSet(new long[]{0x0000000420000000L});
	public static final BitSet FOLLOW_COMMA_in_typeCtorExpression1496 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_expression_in_typeCtorExpression1498 = new BitSet(new long[]{0x0000000420000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_typeCtorExpression1502 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_PLAIN_LITERAL_in_typeCtorExpression1523 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_typeCtorExpression1525 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_expression_in_typeCtorExpression1527 = new BitSet(new long[]{0x0000000420000000L});
	public static final BitSet FOLLOW_COMMA_in_typeCtorExpression1530 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_expression_in_typeCtorExpression1532 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_typeCtorExpression1536 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_TYPED_LITERAL_in_typeCtorExpression1555 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_typeCtorExpression1557 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_expression_in_typeCtorExpression1559 = new BitSet(new long[]{0x0000000400000000L});
	public static final BitSet FOLLOW_COMMA_in_typeCtorExpression1561 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_expression_in_typeCtorExpression1563 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_typeCtorExpression1565 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_prologue_in_query1596 = new BitSet(new long[]{0x0400008000008000L,0x0000000000000000L,0x0080000000000000L});
	public static final BitSet FOLLOW_selectQuery_in_query1600 = new BitSet(new long[]{0x0000000000100000L});
	public static final BitSet FOLLOW_constructQuery_in_query1604 = new BitSet(new long[]{0x0000000000100000L});
	public static final BitSet FOLLOW_describeQuery_in_query1608 = new BitSet(new long[]{0x0000000000100000L});
	public static final BitSet FOLLOW_askQuery_in_query1612 = new BitSet(new long[]{0x0000000000100000L});
	public static final BitSet FOLLOW_bindingsClause_in_query1616 = new BitSet(new long[]{0x0000000000000000L});
	public static final BitSet FOLLOW_EOF_in_query1618 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_update_in_query1649 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0200000000000000L});
	public static final BitSet FOLLOW_SEMICOLON_in_query1653 = new BitSet(new long[]{0x0100500010040040L,0x0080000100000004L,0x0000004000000002L,0x0100000000000000L});
	public static final BitSet FOLLOW_update_in_query1655 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0200000000000000L});
	public static final BitSet FOLLOW_EOF_in_query1659 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_baseDecl_in_prologue1686 = new BitSet(new long[]{0x0000000000040002L,0x0000000000000000L,0x0000004000000000L});
	public static final BitSet FOLLOW_prefixDecl_in_prologue1690 = new BitSet(new long[]{0x0000000000040002L,0x0000000000000000L,0x0000004000000000L});
	public static final BitSet FOLLOW_BASE_in_baseDecl1721 = new BitSet(new long[]{0x0000000000000000L,0x0000008000000000L});
	public static final BitSet FOLLOW_IRI_REF_in_baseDecl1723 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_PREFIX_in_prefixDecl1748 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000080000000L});
	public static final BitSet FOLLOW_PNAME_NS_in_prefixDecl1750 = new BitSet(new long[]{0x0000000000000000L,0x0000008000000000L});
	public static final BitSet FOLLOW_IRI_REF_in_prefixDecl1752 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_selectClause_in_selectQuery1779 = new BitSet(new long[]{0x0000000000000000L,0x0000000000002000L,0x0000000000008000L,0x0040000000000000L});
	public static final BitSet FOLLOW_datasetClause_in_selectQuery1781 = new BitSet(new long[]{0x0000000000000000L,0x0000000000002000L,0x0000000000008000L,0x0040000000000000L});
	public static final BitSet FOLLOW_whereClause_in_selectQuery1784 = new BitSet(new long[]{0x0000000000000000L,0x0040000008800000L,0x0000000000082000L});
	public static final BitSet FOLLOW_solutionModifier_in_selectQuery1786 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_selectClause_in_subSelect1820 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000008000L,0x0040000000000000L});
	public static final BitSet FOLLOW_whereClause_in_subSelect1822 = new BitSet(new long[]{0x0000000000000000L,0x0040000008800000L,0x0000000000082000L});
	public static final BitSet FOLLOW_solutionModifier_in_subSelect1824 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SELECT_in_selectClause1857 = new BitSet(new long[]{0x1000000000010000L,0x0000000000000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_DISTINCT_in_selectClause1861 = new BitSet(new long[]{0x0000000000010000L});
	public static final BitSet FOLLOW_REDUCED_in_selectClause1865 = new BitSet(new long[]{0x0000000000010000L});
	public static final BitSet FOLLOW_ASTERISK_in_selectClause1870 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SELECT_in_selectClause1892 = new BitSet(new long[]{0x1000000000000000L,0x0000000000000000L,0x0000400000004000L,0x0000700000000000L});
	public static final BitSet FOLLOW_DISTINCT_in_selectClause1896 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L,0x0000700000000000L});
	public static final BitSet FOLLOW_REDUCED_in_selectClause1900 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L,0x0000700000000000L});
	public static final BitSet FOLLOW_selectVariables_in_selectClause1908 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000004000L,0x0000700000000000L});
	public static final BitSet FOLLOW_var_in_selectVariables1945 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_selectVariables1963 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_expression_in_selectVariables1967 = new BitSet(new long[]{0x0000000000002000L});
	public static final BitSet FOLLOW_AS_in_selectVariables1969 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000700000000000L});
	public static final BitSet FOLLOW_var_in_selectVariables1973 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_selectVariables1975 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CONSTRUCT_in_constructQuery2006 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_constructTemplate_in_constructQuery2008 = new BitSet(new long[]{0x0000000000000000L,0x0000000000002000L,0x0000000000008000L,0x0040000000000000L});
	public static final BitSet FOLLOW_datasetClause_in_constructQuery2010 = new BitSet(new long[]{0x0000000000000000L,0x0000000000002000L,0x0000000000008000L,0x0040000000000000L});
	public static final BitSet FOLLOW_whereClause_in_constructQuery2013 = new BitSet(new long[]{0x0000000000000000L,0x0040000008800000L,0x0000000000082000L});
	public static final BitSet FOLLOW_solutionModifier_in_constructQuery2015 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CONSTRUCT_in_constructQuery2041 = new BitSet(new long[]{0x0000000000000000L,0x0000000000002000L,0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_datasetClause_in_constructQuery2043 = new BitSet(new long[]{0x0000000000000000L,0x0000000000002000L,0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_WHERE_in_constructQuery2046 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_OPEN_CURLY_BRACE_in_constructQuery2048 = new BitSet(new long[]{0x801C000040800000L,0x0000008E00000403L,0x00000000C0014000L,0x000070004000F000L});
	public static final BitSet FOLLOW_triplesTemplate_in_constructQuery2050 = new BitSet(new long[]{0x0000000040000000L});
	public static final BitSet FOLLOW_CLOSE_CURLY_BRACE_in_constructQuery2053 = new BitSet(new long[]{0x0000000000000000L,0x0040000008800000L,0x0000000000082000L});
	public static final BitSet FOLLOW_solutionModifier_in_constructQuery2055 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DESCRIBE_in_describeQuery2091 = new BitSet(new long[]{0x0000000000010000L,0x0000008000000000L,0x00000000C0000000L,0x0000700000000000L});
	public static final BitSet FOLLOW_varOrIRIref_in_describeQuery2098 = new BitSet(new long[]{0x0000000000000000L,0x0040008008802000L,0x00000000C008A000L,0x0040700000000000L});
	public static final BitSet FOLLOW_ASTERISK_in_describeQuery2104 = new BitSet(new long[]{0x0000000000000000L,0x0040000008802000L,0x000000000008A000L,0x0040000000000000L});
	public static final BitSet FOLLOW_datasetClause_in_describeQuery2108 = new BitSet(new long[]{0x0000000000000000L,0x0040000008802000L,0x000000000008A000L,0x0040000000000000L});
	public static final BitSet FOLLOW_whereClause_in_describeQuery2111 = new BitSet(new long[]{0x0000000000000000L,0x0040000008800000L,0x0000000000082000L});
	public static final BitSet FOLLOW_solutionModifier_in_describeQuery2114 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ASK_in_askQuery2153 = new BitSet(new long[]{0x0000000000000000L,0x0000000000002000L,0x0000000000008000L,0x0040000000000000L});
	public static final BitSet FOLLOW_datasetClause_in_askQuery2155 = new BitSet(new long[]{0x0000000000000000L,0x0000000000002000L,0x0000000000008000L,0x0040000000000000L});
	public static final BitSet FOLLOW_whereClause_in_askQuery2158 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_FROM_in_datasetClause2186 = new BitSet(new long[]{0x0000000000000000L,0x0000008000000000L,0x00000000C0000008L});
	public static final BitSet FOLLOW_NAMED_in_datasetClause2188 = new BitSet(new long[]{0x0000000000000000L,0x0000008000000000L,0x00000000C0000000L});
	public static final BitSet FOLLOW_iriRef_in_datasetClause2191 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_WHERE_in_whereClause2219 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_groupGraphPattern_in_whereClause2222 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_groupClause_in_solutionModifier2247 = new BitSet(new long[]{0x0000000000000002L,0x0040000008000000L,0x0000000000082000L});
	public static final BitSet FOLLOW_havingClause_in_solutionModifier2250 = new BitSet(new long[]{0x0000000000000002L,0x0040000000000000L,0x0000000000082000L});
	public static final BitSet FOLLOW_orderClause_in_solutionModifier2253 = new BitSet(new long[]{0x0000000000000002L,0x0040000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_limitOffsetClauses_in_solutionModifier2256 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_GROUP_in_groupClause2288 = new BitSet(new long[]{0x0000000004000000L});
	public static final BitSet FOLLOW_BY_in_groupClause2290 = new BitSet(new long[]{0x000308110B000020L,0x4409BEC030001090L,0xE0592000C0004901L,0x0400720301270703L});
	public static final BitSet FOLLOW_groupCondition_in_groupClause2292 = new BitSet(new long[]{0x000308110B000022L,0x4409BEC030001090L,0xE0592000C0004901L,0x0400720301270703L});
	public static final BitSet FOLLOW_builtInCall_in_groupCondition2326 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_functionCall_in_groupCondition2334 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_groupCondition2342 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_expression_in_groupCondition2344 = new BitSet(new long[]{0x0000000020002000L});
	public static final BitSet FOLLOW_AS_in_groupCondition2347 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000700000000000L});
	public static final BitSet FOLLOW_var_in_groupCondition2349 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_groupCondition2353 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_var_in_groupCondition2372 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_HAVING_in_havingClause2393 = new BitSet(new long[]{0x000308110B000020L,0x4409BEC030001090L,0xE0592000C0004901L,0x0400020301270703L});
	public static final BitSet FOLLOW_constraint_in_havingClause2395 = new BitSet(new long[]{0x000308110B000022L,0x4409BEC030001090L,0xE0592000C0004901L,0x0400020301270703L});
	public static final BitSet FOLLOW_ORDER_in_orderClause2427 = new BitSet(new long[]{0x0000000004000000L});
	public static final BitSet FOLLOW_BY_in_orderClause2429 = new BitSet(new long[]{0x020308110B004020L,0x4409BEC030001090L,0xE0592000C0004901L,0x0400720301270703L});
	public static final BitSet FOLLOW_orderCondition_in_orderClause2431 = new BitSet(new long[]{0x020308110B004022L,0x4409BEC030001090L,0xE0592000C0004901L,0x0400720301270703L});
	public static final BitSet FOLLOW_ASC_in_orderCondition2458 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_brackettedExpression_in_orderCondition2460 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DESC_in_orderCondition2478 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_brackettedExpression_in_orderCondition2480 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_constraint_in_orderCondition2498 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_var_in_orderCondition2514 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_limitClause_in_limitOffsetClauses2544 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_offsetClause_in_limitOffsetClauses2546 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_offsetClause_in_limitOffsetClauses2562 = new BitSet(new long[]{0x0000000000000002L,0x0040000000000000L});
	public static final BitSet FOLLOW_limitClause_in_limitOffsetClauses2564 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LIMIT_in_limitClause2589 = new BitSet(new long[]{0x0000000000000000L,0x0000000200000000L});
	public static final BitSet FOLLOW_INTEGER_in_limitClause2591 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OFFSET_in_offsetClause2616 = new BitSet(new long[]{0x0000000000000000L,0x0000000200000000L});
	public static final BitSet FOLLOW_INTEGER_in_offsetClause2618 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_BINDINGS_in_bindingsClause2644 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000008000L,0x0000700000000000L});
	public static final BitSet FOLLOW_var_in_bindingsClause2646 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000008000L,0x0000700000000000L});
	public static final BitSet FOLLOW_OPEN_CURLY_BRACE_in_bindingsClause2649 = new BitSet(new long[]{0x0000000040000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_bindingValueList_in_bindingsClause2651 = new BitSet(new long[]{0x0000000040000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_CLOSE_CURLY_BRACE_in_bindingsClause2654 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_bindingValueList2690 = new BitSet(new long[]{0x801C000020000000L,0x0000008E00000403L,0x00000000C0000000L,0x000000404000F000L});
	public static final BitSet FOLLOW_bindingValue_in_bindingValueList2692 = new BitSet(new long[]{0x801C000020000000L,0x0000008E00000403L,0x00000000C0000000L,0x000000404000F000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_bindingValueList2695 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_iriRef_in_bindingValue2726 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_rdfLiteral_in_bindingValue2730 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_numericLiteral_in_bindingValue2734 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_booleanLiteral_in_bindingValue2738 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_UNDEF_in_bindingValue2742 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_prologue_in_update2763 = new BitSet(new long[]{0x0100500010000040L,0x0080000100000004L,0x0000000000000002L,0x0100000000000000L});
	public static final BitSet FOLLOW_load_in_update2766 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_clear_in_update2770 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_drop_in_update2774 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_add_in_update2778 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_move_in_update2782 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_copy_in_update2786 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_create_in_update2790 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_insert_in_update2794 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_delete_in_update2798 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_modify_in_update2802 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LOAD_in_load2865 = new BitSet(new long[]{0x0000000000000000L,0x0000008000000000L,0x00000000C0000000L,0x0000000000000008L});
	public static final BitSet FOLLOW_SILENT_in_load2867 = new BitSet(new long[]{0x0000000000000000L,0x0000008000000000L,0x00000000C0000000L});
	public static final BitSet FOLLOW_iriRef_in_load2870 = new BitSet(new long[]{0x0000000000000002L,0x0000001000000000L});
	public static final BitSet FOLLOW_INTO_in_load2874 = new BitSet(new long[]{0x0000000000000000L,0x0000000000080000L});
	public static final BitSet FOLLOW_graphRef_in_load2876 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CLEAR_in_clear2914 = new BitSet(new long[]{0x0040000000000200L,0x0000000000080000L,0x0000000000000008L,0x0000000000000008L});
	public static final BitSet FOLLOW_SILENT_in_clear2917 = new BitSet(new long[]{0x0040000000000200L,0x0000000000080000L,0x0000000000000008L});
	public static final BitSet FOLLOW_graphRefAll_in_clear2920 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DROP_in_drop2952 = new BitSet(new long[]{0x0040000000000200L,0x0000000000080000L,0x0000000000000008L,0x0000000000000008L});
	public static final BitSet FOLLOW_SILENT_in_drop2954 = new BitSet(new long[]{0x0040000000000200L,0x0000000000080000L,0x0000000000000008L});
	public static final BitSet FOLLOW_graphRefAll_in_drop2957 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CREATE_in_create2986 = new BitSet(new long[]{0x0000000000000000L,0x0000000000080000L,0x0000000000000000L,0x0000000000000008L});
	public static final BitSet FOLLOW_SILENT_in_create2988 = new BitSet(new long[]{0x0000000000000000L,0x0000000000080000L});
	public static final BitSet FOLLOW_graphRef_in_create2991 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ADD_in_add3023 = new BitSet(new long[]{0x0040000000000000L,0x0000008000080000L,0x00000000C0000000L,0x0000000000000008L});
	public static final BitSet FOLLOW_SILENT_in_add3025 = new BitSet(new long[]{0x0040000000000000L,0x0000008000080000L,0x00000000C0000000L});
	public static final BitSet FOLLOW_graphOrDefault_in_add3030 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000002000000L});
	public static final BitSet FOLLOW_TO_in_add3032 = new BitSet(new long[]{0x0040000000000000L,0x0000008000080000L,0x00000000C0000000L});
	public static final BitSet FOLLOW_graphOrDefault_in_add3036 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_MOVE_in_move3072 = new BitSet(new long[]{0x0040000000000000L,0x0000008000080000L,0x00000000C0000000L,0x0000000000000008L});
	public static final BitSet FOLLOW_SILENT_in_move3074 = new BitSet(new long[]{0x0040000000000000L,0x0000008000080000L,0x00000000C0000000L});
	public static final BitSet FOLLOW_graphOrDefault_in_move3079 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000002000000L});
	public static final BitSet FOLLOW_TO_in_move3081 = new BitSet(new long[]{0x0040000000000000L,0x0000008000080000L,0x00000000C0000000L});
	public static final BitSet FOLLOW_graphOrDefault_in_move3085 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_COPY_in_copy3121 = new BitSet(new long[]{0x0040000000000000L,0x0000008000080000L,0x00000000C0000000L,0x0000000000000008L});
	public static final BitSet FOLLOW_SILENT_in_copy3123 = new BitSet(new long[]{0x0040000000000000L,0x0000008000080000L,0x00000000C0000000L});
	public static final BitSet FOLLOW_graphOrDefault_in_copy3128 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000002000000L});
	public static final BitSet FOLLOW_TO_in_copy3130 = new BitSet(new long[]{0x0040000000000000L,0x0000008000080000L,0x00000000C0000000L});
	public static final BitSet FOLLOW_graphOrDefault_in_copy3134 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_INSERT_in_insert3166 = new BitSet(new long[]{0x0000800000000000L});
	public static final BitSet FOLLOW_DATA_in_insert3168 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_quadPattern_in_insert3170 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DELETE_in_delete3204 = new BitSet(new long[]{0x0000800000000000L,0x0000000000000000L,0x0000000000000000L,0x0040000000000000L});
	public static final BitSet FOLLOW_deleteData_in_delete3208 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_deleteWhere_in_delete3212 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DATA_in_deleteData3231 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_quadPattern_in_deleteData3233 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_WHERE_in_deleteWhere3260 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_quadPattern_in_deleteWhere3262 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_WITH_in_modify3295 = new BitSet(new long[]{0x0000000000000000L,0x0000008000000000L,0x00000000C0000000L});
	public static final BitSet FOLLOW_iriRef_in_modify3299 = new BitSet(new long[]{0x0100000000000000L,0x0000000100000000L});
	public static final BitSet FOLLOW_deleteClause_in_modify3305 = new BitSet(new long[]{0x0000000000000000L,0x0000000100000000L,0x0000000000000000L,0x0040040000000000L});
	public static final BitSet FOLLOW_insertClause_in_modify3307 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0040040000000000L});
	public static final BitSet FOLLOW_insertClause_in_modify3312 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0040040000000000L});
	public static final BitSet FOLLOW_usingClause_in_modify3315 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0040040000000000L});
	public static final BitSet FOLLOW_WHERE_in_modify3318 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_groupGraphPattern_in_modify3320 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DELETE_in_deleteClause3368 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_quadPattern_in_deleteClause3370 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_INSERT_in_insertClause3399 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_quadPattern_in_insertClause3401 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_USING_in_usingClause3424 = new BitSet(new long[]{0x0000000000000000L,0x0000008000000000L,0x00000000C0000008L});
	public static final BitSet FOLLOW_NAMED_in_usingClause3426 = new BitSet(new long[]{0x0000000000000000L,0x0000008000000000L,0x00000000C0000000L});
	public static final BitSet FOLLOW_iriRef_in_usingClause3429 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DEFAULT_in_graphOrDefault3460 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_GRAPH_in_graphOrDefault3469 = new BitSet(new long[]{0x0000000000000000L,0x0000008000000000L,0x00000000C0000000L});
	public static final BitSet FOLLOW_iriRef_in_graphOrDefault3472 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_GRAPH_in_graphRef3499 = new BitSet(new long[]{0x0000000000000000L,0x0000008000000000L,0x00000000C0000000L});
	public static final BitSet FOLLOW_iriRef_in_graphRef3501 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_graphRef_in_graphRefAll3518 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DEFAULT_in_graphRefAll3522 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NAMED_in_graphRefAll3526 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ALL_in_graphRefAll3530 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OPEN_CURLY_BRACE_in_quadPattern3547 = new BitSet(new long[]{0x801C000040800000L,0x0000008E00080403L,0x00000000C0014000L,0x000070004000F000L});
	public static final BitSet FOLLOW_quads_in_quadPattern3549 = new BitSet(new long[]{0x0000000040000000L});
	public static final BitSet FOLLOW_CLOSE_CURLY_BRACE_in_quadPattern3551 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_triplesTemplate_in_quads3578 = new BitSet(new long[]{0x0000000000000002L,0x0000000000080000L});
	public static final BitSet FOLLOW_quadsNotTriples_in_quads3583 = new BitSet(new long[]{0xC01C000000800002L,0x0000008E00080403L,0x00000000C0014000L,0x000070004000F000L});
	public static final BitSet FOLLOW_DOT_in_quads3585 = new BitSet(new long[]{0x801C000000800002L,0x0000008E00080403L,0x00000000C0014000L,0x000070004000F000L});
	public static final BitSet FOLLOW_triplesTemplate_in_quads3590 = new BitSet(new long[]{0x0000000000000002L,0x0000000000080000L});
	public static final BitSet FOLLOW_GRAPH_in_quadsNotTriples3633 = new BitSet(new long[]{0x0000000000000000L,0x0000008000000000L,0x00000000C0000000L,0x0000700000000000L});
	public static final BitSet FOLLOW_varOrIRIref_in_quadsNotTriples3635 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_OPEN_CURLY_BRACE_in_quadsNotTriples3637 = new BitSet(new long[]{0x801C000040800000L,0x0000008E00000403L,0x00000000C0014000L,0x000070004000F000L});
	public static final BitSet FOLLOW_triplesTemplate_in_quadsNotTriples3639 = new BitSet(new long[]{0x0000000040000000L});
	public static final BitSet FOLLOW_CLOSE_CURLY_BRACE_in_quadsNotTriples3642 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_triplesSameSubject_in_triplesTemplate3674 = new BitSet(new long[]{0x4000000000000002L});
	public static final BitSet FOLLOW_DOT_in_triplesTemplate3678 = new BitSet(new long[]{0x801C000000800000L,0x0000008E00000403L,0x00000000C0014000L,0x000070004000F000L});
	public static final BitSet FOLLOW_triplesSameSubject_in_triplesTemplate3680 = new BitSet(new long[]{0x4000000000000002L});
	public static final BitSet FOLLOW_DOT_in_triplesTemplate3685 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OPEN_CURLY_BRACE_in_groupGraphPattern3717 = new BitSet(new long[]{0x801C000040880000L,0x2000008E00080C03L,0x08800000C003C000L,0x000070004000F000L});
	public static final BitSet FOLLOW_subSelect_in_groupGraphPattern3721 = new BitSet(new long[]{0x0000000040000000L});
	public static final BitSet FOLLOW_groupGraphPatternSub_in_groupGraphPattern3725 = new BitSet(new long[]{0x0000000040000000L});
	public static final BitSet FOLLOW_CLOSE_CURLY_BRACE_in_groupGraphPattern3729 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_triplesBlock_in_groupGraphPatternSub3762 = new BitSet(new long[]{0x0000000000080002L,0x2000000000080800L,0x0800000000028000L});
	public static final BitSet FOLLOW_groupGraphPatternSubCache_in_groupGraphPatternSub3767 = new BitSet(new long[]{0x0000000000080002L,0x2000000000080800L,0x0800000000028000L});
	public static final BitSet FOLLOW_graphPatternNotTriples_in_groupGraphPatternSubCache3796 = new BitSet(new long[]{0xC01C000000800002L,0x0000008E00000403L,0x00000000C0014000L,0x000070004000F000L});
	public static final BitSet FOLLOW_DOT_in_groupGraphPatternSubCache3798 = new BitSet(new long[]{0x801C000000800002L,0x0000008E00000403L,0x00000000C0014000L,0x000070004000F000L});
	public static final BitSet FOLLOW_triplesBlock_in_groupGraphPatternSubCache3801 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_triplesSameSubjectPath_in_triplesBlock3828 = new BitSet(new long[]{0x4000000000000002L});
	public static final BitSet FOLLOW_DOT_in_triplesBlock3832 = new BitSet(new long[]{0x801C000000800000L,0x0000008E00000403L,0x00000000C0014000L,0x000070004000F000L});
	public static final BitSet FOLLOW_triplesSameSubjectPath_in_triplesBlock3834 = new BitSet(new long[]{0x4000000000000002L});
	public static final BitSet FOLLOW_DOT_in_triplesBlock3838 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_groupOrUnionGraphPattern_in_graphPatternNotTriples3865 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_optionalGraphPattern_in_graphPatternNotTriples3869 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_minusGraphPattern_in_graphPatternNotTriples3873 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_graphGraphPattern_in_graphPatternNotTriples3877 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_serviceGraphPattern_in_graphPatternNotTriples3881 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_filter_in_graphPatternNotTriples3885 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_bind_in_graphPatternNotTriples3889 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OPTIONAL_in_optionalGraphPattern3906 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_groupGraphPattern_in_optionalGraphPattern3908 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_GRAPH_in_graphGraphPattern3933 = new BitSet(new long[]{0x0000000000000000L,0x0000008000000000L,0x00000000C0000000L,0x0000700000000000L});
	public static final BitSet FOLLOW_varOrIRIref_in_graphGraphPattern3935 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_groupGraphPattern_in_graphGraphPattern3937 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SERVICE_in_serviceGraphPattern3964 = new BitSet(new long[]{0x0000000000000000L,0x0000008000000000L,0x00000000C0000000L,0x0000700000000008L});
	public static final BitSet FOLLOW_SILENT_in_serviceGraphPattern3966 = new BitSet(new long[]{0x0000000000000000L,0x0000008000000000L,0x00000000C0000000L,0x0000700000000000L});
	public static final BitSet FOLLOW_varOrIRIref_in_serviceGraphPattern3969 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_groupGraphPattern_in_serviceGraphPattern3971 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_BIND_in_bind4005 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_bind4007 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_expression_in_bind4009 = new BitSet(new long[]{0x0000000000002000L});
	public static final BitSet FOLLOW_AS_in_bind4011 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000700000000000L});
	public static final BitSet FOLLOW_var_in_bind4013 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_bind4015 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_MINUS_KEYWORD_in_minusGraphPattern4052 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_groupGraphPattern_in_minusGraphPattern4054 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_groupGraphPattern_in_groupOrUnionGraphPattern4082 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000000L,0x0000008000000000L});
	public static final BitSet FOLLOW_UNION_in_groupOrUnionGraphPattern4090 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_groupGraphPattern_in_groupOrUnionGraphPattern4094 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000000L,0x0000008000000000L});
	public static final BitSet FOLLOW_FILTER_in_filter4126 = new BitSet(new long[]{0x000308110B000020L,0x4409BEC030001090L,0xE0592000C0004901L,0x0400020301270703L});
	public static final BitSet FOLLOW_constraint_in_filter4128 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_brackettedExpression_in_constraint4153 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_builtInCall_in_constraint4161 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_functionCall_in_constraint4169 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_iriRef_in_functionCall4186 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_argList_in_functionCall4188 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_nil_in_argList4219 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_argList4231 = new BitSet(new long[]{0x901F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_DISTINCT_in_argList4233 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_expression_in_argList4236 = new BitSet(new long[]{0x0000000420000000L});
	public static final BitSet FOLLOW_COMMA_in_argList4240 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_expression_in_argList4242 = new BitSet(new long[]{0x0000000420000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_argList4247 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_nil_in_expressionList4275 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_expressionList4279 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_expression_in_expressionList4281 = new BitSet(new long[]{0x0000000420000000L});
	public static final BitSet FOLLOW_COMMA_in_expressionList4285 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_expression_in_expressionList4287 = new BitSet(new long[]{0x0000000420000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_expressionList4292 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_quadPattern_in_constructTemplateQuads4328 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OPEN_CURLY_BRACE_in_constructTemplate4354 = new BitSet(new long[]{0x801C000040800000L,0x0000008E00000403L,0x00000000C0014000L,0x000070004000F000L});
	public static final BitSet FOLLOW_constructTriples_in_constructTemplate4356 = new BitSet(new long[]{0x0000000040000000L});
	public static final BitSet FOLLOW_CLOSE_CURLY_BRACE_in_constructTemplate4359 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_triplesSameSubject_in_constructTriples4385 = new BitSet(new long[]{0x4000000000000002L});
	public static final BitSet FOLLOW_DOT_in_constructTriples4389 = new BitSet(new long[]{0x801C000000800000L,0x0000008E00000403L,0x00000000C0014000L,0x000070004000F000L});
	public static final BitSet FOLLOW_triplesSameSubject_in_constructTriples4391 = new BitSet(new long[]{0x4000000000000002L});
	public static final BitSet FOLLOW_DOT_in_constructTriples4396 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_varOrTerm_in_triplesSameSubject4421 = new BitSet(new long[]{0x0000000000000010L,0x0000008000000000L,0x00000000C0000000L,0x0000700000000000L});
	public static final BitSet FOLLOW_propertyListNotEmpty_in_triplesSameSubject4423 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_triplesNode_in_triplesSameSubject4439 = new BitSet(new long[]{0x0000000000000012L,0x0000008000000000L,0x00000000C0000000L,0x0000700000000000L});
	public static final BitSet FOLLOW_propertyListNotEmpty_in_triplesSameSubject4450 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_verb_in_propertyListNotEmpty4486 = new BitSet(new long[]{0x801C000000800000L,0x0000008E00000403L,0x00000000C0014000L,0x000070004000F000L});
	public static final BitSet FOLLOW_objectList_in_propertyListNotEmpty4488 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0200000000000000L});
	public static final BitSet FOLLOW_SEMICOLON_in_propertyListNotEmpty4492 = new BitSet(new long[]{0x0000000000000012L,0x0000008000000000L,0x02000000C0000000L,0x0000700000000000L});
	public static final BitSet FOLLOW_verb_in_propertyListNotEmpty4497 = new BitSet(new long[]{0x801C000000800000L,0x0000008E00000403L,0x00000000C0014000L,0x000070004000F000L});
	public static final BitSet FOLLOW_objectList_in_propertyListNotEmpty4499 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0200000000000000L});
	public static final BitSet FOLLOW_graphNode_in_objectList4528 = new BitSet(new long[]{0x0000000400000002L});
	public static final BitSet FOLLOW_COMMA_in_objectList4532 = new BitSet(new long[]{0x801C000000800000L,0x0000008E00000403L,0x00000000C0014000L,0x000070004000F000L});
	public static final BitSet FOLLOW_graphNode_in_objectList4534 = new BitSet(new long[]{0x0000000400000002L});
	public static final BitSet FOLLOW_varOrIRIref_in_verb4584 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_A_in_verb4592 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_varOrTerm_in_triplesSameSubjectPath4609 = new BitSet(new long[]{0x0000000000000010L,0x000000A000000000L,0x00000000C0004040L,0x0000700000000000L});
	public static final BitSet FOLLOW_propertyListNotEmptyPath_in_triplesSameSubjectPath4611 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_triplesNode_in_triplesSameSubjectPath4631 = new BitSet(new long[]{0x0000000000000012L,0x0000008000000000L,0x00000000C0000000L,0x0000700000000000L});
	public static final BitSet FOLLOW_propertyListNotEmpty_in_triplesSameSubjectPath4642 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_verbPath_in_propertyListNotEmptyPath4681 = new BitSet(new long[]{0x801C000000800000L,0x0000008E00000403L,0x00000000C0014000L,0x000070004000F000L});
	public static final BitSet FOLLOW_objectList_in_propertyListNotEmptyPath4684 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0200000000000000L});
	public static final BitSet FOLLOW_verbSimple_in_propertyListNotEmptyPath4690 = new BitSet(new long[]{0x801C000000800000L,0x0000008E00000403L,0x00000000C0014000L,0x000070004000F000L});
	public static final BitSet FOLLOW_objectList_in_propertyListNotEmptyPath4692 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0200000000000000L});
	public static final BitSet FOLLOW_SEMICOLON_in_propertyListNotEmptyPath4697 = new BitSet(new long[]{0x0000000000000012L,0x000000A000000000L,0x02000000C0004040L,0x0000700000000000L});
	public static final BitSet FOLLOW_verbPath_in_propertyListNotEmptyPath4702 = new BitSet(new long[]{0x801C000000800000L,0x0000008E00000403L,0x00000000C0014000L,0x000070004000F000L});
	public static final BitSet FOLLOW_objectList_in_propertyListNotEmptyPath4704 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0200000000000000L});
	public static final BitSet FOLLOW_verbSimple_in_propertyListNotEmptyPath4712 = new BitSet(new long[]{0x801C000000800000L,0x0000008E00000403L,0x00000000C0014000L,0x000070004000F000L});
	public static final BitSet FOLLOW_objectList_in_propertyListNotEmptyPath4715 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0200000000000000L});
	public static final BitSet FOLLOW_path_in_verbPath4747 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_var_in_verbSimple4768 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_pathSequence_in_path4790 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_PIPE_in_path4794 = new BitSet(new long[]{0x0000000000000010L,0x000000A000000000L,0x00000000C0004040L});
	public static final BitSet FOLLOW_pathSequence_in_path4796 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_pathEltOrInverse_in_pathSequence4832 = new BitSet(new long[]{0x2000000000000002L});
	public static final BitSet FOLLOW_DIVIDE_in_pathSequence4836 = new BitSet(new long[]{0x0000000000000010L,0x000000A000000000L,0x00000000C0004040L});
	public static final BitSet FOLLOW_pathEltOrInverse_in_pathSequence4838 = new BitSet(new long[]{0x2000000000000002L});
	public static final BitSet FOLLOW_pathPrimary_in_pathElt4866 = new BitSet(new long[]{0x0000000000010002L,0x0000000000000000L,0x0000100020008000L});
	public static final BitSet FOLLOW_pathMod_in_pathElt4868 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_pathElt_in_pathEltOrInverse4890 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_INVERSE_in_pathEltOrInverse4894 = new BitSet(new long[]{0x0000000000000010L,0x0000008000000000L,0x00000000C0004040L});
	public static final BitSet FOLLOW_pathElt_in_pathEltOrInverse4896 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ASTERISK_in_pathMod4919 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QUESTION_MARK_in_pathMod4923 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_PLUS_in_pathMod4927 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OPEN_CURLY_BRACE_in_pathMod4931 = new BitSet(new long[]{0x0000000400000000L,0x0000000200000000L});
	public static final BitSet FOLLOW_INTEGER_in_pathMod4935 = new BitSet(new long[]{0x0000000440000000L});
	public static final BitSet FOLLOW_COMMA_in_pathMod4939 = new BitSet(new long[]{0x0000000040000000L,0x0000000200000000L});
	public static final BitSet FOLLOW_CLOSE_CURLY_BRACE_in_pathMod4943 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_INTEGER_in_pathMod4947 = new BitSet(new long[]{0x0000000040000000L});
	public static final BitSet FOLLOW_CLOSE_CURLY_BRACE_in_pathMod4949 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CLOSE_CURLY_BRACE_in_pathMod4955 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_COMMA_in_pathMod4961 = new BitSet(new long[]{0x0000000000000000L,0x0000000200000000L});
	public static final BitSet FOLLOW_INTEGER_in_pathMod4963 = new BitSet(new long[]{0x0000000040000000L});
	public static final BitSet FOLLOW_CLOSE_CURLY_BRACE_in_pathMod4965 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_iriRef_in_pathPrimary4986 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_A_in_pathPrimary5002 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NEGATION_in_pathPrimary5018 = new BitSet(new long[]{0x0000000000000010L,0x000000A000000000L,0x00000000C0004000L});
	public static final BitSet FOLLOW_pathNegatedPropertySet_in_pathPrimary5020 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_pathPrimary5038 = new BitSet(new long[]{0x0000000000000010L,0x000000A000000000L,0x00000000C0004040L});
	public static final BitSet FOLLOW_path_in_pathPrimary5040 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_pathPrimary5042 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_pathOneInPropertySet_in_pathNegatedPropertySet5068 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_pathNegatedPropertySet5072 = new BitSet(new long[]{0x0000000020000010L,0x000000A000000000L,0x00000000C0000000L});
	public static final BitSet FOLLOW_pathOneInPropertySet_in_pathNegatedPropertySet5076 = new BitSet(new long[]{0x0000000020000000L,0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_PIPE_in_pathNegatedPropertySet5080 = new BitSet(new long[]{0x0000000000000010L,0x000000A000000000L,0x00000000C0000000L});
	public static final BitSet FOLLOW_pathOneInPropertySet_in_pathNegatedPropertySet5082 = new BitSet(new long[]{0x0000000020000000L,0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_pathNegatedPropertySet5090 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_INVERSE_in_pathOneInPropertySet5120 = new BitSet(new long[]{0x0000000000000010L,0x0000008000000000L,0x00000000C0000000L});
	public static final BitSet FOLLOW_iriRef_in_pathOneInPropertySet5125 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_A_in_pathOneInPropertySet5129 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_triplesNode5149 = new BitSet(new long[]{0x801C000000800000L,0x0000008E00000403L,0x00000000C0014000L,0x000070004000F000L});
	public static final BitSet FOLLOW_graphNode_in_triplesNode5151 = new BitSet(new long[]{0x801C000020800000L,0x0000008E00000403L,0x00000000C0014000L,0x000070004000F000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_triplesNode5154 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OPEN_SQUARE_BRACKET_in_triplesNode5173 = new BitSet(new long[]{0x0000000000000010L,0x0000008000000000L,0x00000000C0000000L,0x0000700000000000L});
	public static final BitSet FOLLOW_propertyListNotEmpty_in_triplesNode5175 = new BitSet(new long[]{0x0000000080000000L});
	public static final BitSet FOLLOW_CLOSE_SQUARE_BRACKET_in_triplesNode5178 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_varOrTerm_in_graphNode5203 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_triplesNode_in_graphNode5207 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_var_in_varOrTerm5224 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_graphTerm_in_varOrTerm5228 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_var_in_varOrIRIref5245 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_iriRef_in_varOrIRIref5249 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_VAR1_in_var5268 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_VAR2_in_var5285 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_VAR3_in_var5302 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_iriRef_in_graphTerm5327 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_rdfLiteral_in_graphTerm5335 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_numericLiteral_in_graphTerm5343 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_booleanLiteral_in_graphTerm5351 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_blankNode_in_graphTerm5359 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_nil_in_graphTerm5367 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_nil5388 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_nil5390 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_conditionalOrExpression_in_expression5407 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_conditionalAndExpression_in_conditionalOrExpression5427 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_OR_in_conditionalOrExpression5436 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_conditionalAndExpression_in_conditionalOrExpression5440 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000040000L});
	public static final BitSet FOLLOW_valueLogical_in_conditionalAndExpression5474 = new BitSet(new long[]{0x0000000000000402L});
	public static final BitSet FOLLOW_AND_in_conditionalAndExpression5483 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_valueLogical_in_conditionalAndExpression5487 = new BitSet(new long[]{0x0000000000000402L});
	public static final BitSet FOLLOW_relationalExpression_in_valueLogical5518 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_numericExpression_in_relationalExpression5538 = new BitSet(new long[]{0x0000000000000002L,0x0030000080600040L,0x0000000000000300L});
	public static final BitSet FOLLOW_EQUAL_in_relationalExpression5549 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_numericExpression_in_relationalExpression5553 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NOT_EQUAL_in_relationalExpression5610 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_numericExpression_in_relationalExpression5614 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LESS_in_relationalExpression5669 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_numericExpression_in_relationalExpression5673 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_GREATER_in_relationalExpression5728 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_numericExpression_in_relationalExpression5732 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LESS_EQUAL_in_relationalExpression5786 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_numericExpression_in_relationalExpression5790 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_GREATER_EQUAL_in_relationalExpression5844 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_numericExpression_in_relationalExpression5848 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IN_in_relationalExpression5904 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_expressionList_in_relationalExpression5908 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NOT_in_relationalExpression5962 = new BitSet(new long[]{0x0000000000000000L,0x0000000080000000L});
	public static final BitSet FOLLOW_IN_in_relationalExpression5964 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_expressionList_in_relationalExpression5968 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_additiveExpression_in_numericExpression6003 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_multiplicativeExpression_in_additiveExpression6023 = new BitSet(new long[]{0x0018000000000002L,0x1000000C00000003L,0x0000000020000000L});
	public static final BitSet FOLLOW_additiveOperator_in_additiveExpression6034 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_multiplicativeExpression_in_additiveExpression6038 = new BitSet(new long[]{0x0018000000000002L,0x1000000C00000003L,0x0000000020000000L});
	public static final BitSet FOLLOW_numericLiteralPositive_in_additiveExpression6105 = new BitSet(new long[]{0x2018000000010002L,0x1000000C00000003L,0x0000000020000000L});
	public static final BitSet FOLLOW_numericLiteralNegative_in_additiveExpression6123 = new BitSet(new long[]{0x2018000000010002L,0x1000000C00000003L,0x0000000020000000L});
	public static final BitSet FOLLOW_ASTERISK_in_additiveExpression6190 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_unaryExpression_in_additiveExpression6194 = new BitSet(new long[]{0x0018000000000002L,0x1000000C00000003L,0x0000000020000000L});
	public static final BitSet FOLLOW_DIVIDE_in_additiveExpression6262 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_unaryExpression_in_additiveExpression6266 = new BitSet(new long[]{0x0018000000000002L,0x1000000C00000003L,0x0000000020000000L});
	public static final BitSet FOLLOW_unaryExpression_in_multiplicativeExpression6334 = new BitSet(new long[]{0x2000000000010002L});
	public static final BitSet FOLLOW_multiplicativeOperator_in_multiplicativeExpression6343 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_unaryExpression_in_multiplicativeExpression6347 = new BitSet(new long[]{0x2000000000010002L});
	public static final BitSet FOLLOW_NEGATION_in_unaryExpression6405 = new BitSet(new long[]{0x801F28110B020020L,0x4E09BECE32001493L,0xE0792000C0004905L,0x040072034167F703L});
	public static final BitSet FOLLOW_primaryExpression_in_unaryExpression6407 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_PLUS_in_unaryExpression6426 = new BitSet(new long[]{0x801F28110B020020L,0x4E09BECE32001493L,0xE0792000C0004905L,0x040072034167F703L});
	public static final BitSet FOLLOW_primaryExpression_in_unaryExpression6428 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_MINUS_in_unaryExpression6447 = new BitSet(new long[]{0x801F28110B020020L,0x4E09BECE32001493L,0xE0792000C0004905L,0x040072034167F703L});
	public static final BitSet FOLLOW_primaryExpression_in_unaryExpression6449 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_primaryExpression_in_unaryExpression6467 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_brackettedExpression_in_primaryExpression6492 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_builtInCall_in_primaryExpression6496 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_iriRefOrFunction_in_primaryExpression6500 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_rdfLiteral_in_primaryExpression6504 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_numericLiteral_in_primaryExpression6508 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_booleanLiteral_in_primaryExpression6512 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_var_in_primaryExpression6516 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_aggregate_in_primaryExpression6520 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_aliasedVar_in_primaryExpression6525 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NAME_in_aliasedVar6545 = new BitSet(new long[]{0x4000000000000000L});
	public static final BitSet FOLLOW_DOT_in_aliasedVar6547 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000004L});
	public static final BitSet FOLLOW_NAME_in_aliasedVar6551 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_brackettedExpression6580 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_expression_in_brackettedExpression6582 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_brackettedExpression6584 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STR_in_builtInCall6605 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall6607 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_expression_in_builtInCall6609 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall6611 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LANG_in_builtInCall6627 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall6629 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_expression_in_builtInCall6631 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall6633 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LANGMATCHES_in_builtInCall6649 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall6651 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_expression_in_builtInCall6653 = new BitSet(new long[]{0x0000000400000000L});
	public static final BitSet FOLLOW_COMMA_in_builtInCall6655 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_expression_in_builtInCall6657 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall6659 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DATATYPE_in_builtInCall6676 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall6678 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_expression_in_builtInCall6680 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall6682 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_BOUND_in_builtInCall6698 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall6700 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000700000000000L});
	public static final BitSet FOLLOW_var_in_builtInCall6702 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall6704 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IRI_in_builtInCall6720 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall6722 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_expression_in_builtInCall6724 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall6726 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_URI_in_builtInCall6742 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall6744 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_expression_in_builtInCall6746 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall6748 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_BNODE_in_builtInCall6764 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall6767 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_expression_in_builtInCall6769 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall6771 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_nil_in_builtInCall6774 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_RAND_in_builtInCall6791 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_nil_in_builtInCall6793 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ABS_in_builtInCall6805 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall6807 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_expression_in_builtInCall6809 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall6811 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CEIL_in_builtInCall6827 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall6829 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_expression_in_builtInCall6831 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall6833 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_FLOOR_in_builtInCall6849 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall6851 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_expression_in_builtInCall6853 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall6855 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ROUND_in_builtInCall6871 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall6873 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_expression_in_builtInCall6875 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall6877 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CONCAT_in_builtInCall6893 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_expressionList_in_builtInCall6895 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_subStringExpression_in_builtInCall6911 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRLEN_in_builtInCall6923 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall6925 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_expression_in_builtInCall6927 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall6929 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_UCASE_in_builtInCall6945 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall6947 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_expression_in_builtInCall6949 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall6951 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LCASE_in_builtInCall6967 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall6969 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_expression_in_builtInCall6971 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall6973 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ENCODE_FOR_URI_in_builtInCall6989 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall6991 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_expression_in_builtInCall6993 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall6995 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CONTAINS_in_builtInCall7011 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall7013 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_expression_in_builtInCall7015 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall7017 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRSTARTS_in_builtInCall7033 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall7035 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_expression_in_builtInCall7037 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall7039 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRENDS_in_builtInCall7055 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall7057 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_expression_in_builtInCall7059 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall7061 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_YEAR_in_builtInCall7077 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall7079 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_expression_in_builtInCall7081 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall7083 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_MONTH_in_builtInCall7099 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall7101 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_expression_in_builtInCall7103 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall7105 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DAY_in_builtInCall7121 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall7123 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_expression_in_builtInCall7125 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall7127 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_HOURS_in_builtInCall7143 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall7145 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_expression_in_builtInCall7147 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall7149 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_MINUTES_in_builtInCall7165 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall7167 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_expression_in_builtInCall7169 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall7171 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SECONDS_in_builtInCall7187 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall7189 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_expression_in_builtInCall7191 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall7193 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_TIMEZONE_in_builtInCall7209 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall7211 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_expression_in_builtInCall7213 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall7215 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_TZ_in_builtInCall7231 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall7233 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_expression_in_builtInCall7235 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall7237 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NOW_in_builtInCall7253 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_nil_in_builtInCall7255 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_MD5_in_builtInCall7267 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall7269 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_expression_in_builtInCall7271 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall7273 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SHA1_in_builtInCall7289 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall7291 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_expression_in_builtInCall7293 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall7295 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SHA224_in_builtInCall7311 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall7313 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_expression_in_builtInCall7315 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall7317 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SHA256_in_builtInCall7333 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall7335 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_expression_in_builtInCall7337 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall7339 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SHA384_in_builtInCall7355 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall7357 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_expression_in_builtInCall7359 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall7361 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SHA512_in_builtInCall7377 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall7379 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_expression_in_builtInCall7381 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall7383 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_COALESCE_in_builtInCall7399 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_expressionList_in_builtInCall7401 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IF_in_builtInCall7417 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall7419 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_expression_in_builtInCall7423 = new BitSet(new long[]{0x0000000400000000L});
	public static final BitSet FOLLOW_COMMA_in_builtInCall7425 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_expression_in_builtInCall7429 = new BitSet(new long[]{0x0000000400000000L});
	public static final BitSet FOLLOW_COMMA_in_builtInCall7431 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_expression_in_builtInCall7435 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall7437 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRLANG_in_builtInCall7460 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall7462 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_expression_in_builtInCall7464 = new BitSet(new long[]{0x0000000400000000L});
	public static final BitSet FOLLOW_COMMA_in_builtInCall7466 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_expression_in_builtInCall7468 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall7470 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRDT_in_builtInCall7488 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall7490 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_expression_in_builtInCall7492 = new BitSet(new long[]{0x0000000400000000L});
	public static final BitSet FOLLOW_COMMA_in_builtInCall7494 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_expression_in_builtInCall7496 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall7498 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SAMETERM_in_builtInCall7516 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall7518 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_expression_in_builtInCall7520 = new BitSet(new long[]{0x0000000400000000L});
	public static final BitSet FOLLOW_COMMA_in_builtInCall7522 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_expression_in_builtInCall7524 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall7526 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ISIRI_in_builtInCall7544 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall7546 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_expression_in_builtInCall7548 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall7550 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ISURI_in_builtInCall7566 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall7568 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_expression_in_builtInCall7570 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall7572 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ISBLANK_in_builtInCall7588 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall7590 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_expression_in_builtInCall7592 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall7594 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ISLITERAL_in_builtInCall7611 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall7613 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_expression_in_builtInCall7615 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall7617 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ISNUMERIC_in_builtInCall7633 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_builtInCall7635 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_expression_in_builtInCall7637 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_builtInCall7639 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_regexExpression_in_builtInCall7655 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_existsFunction_in_builtInCall7667 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_notExistsFunction_in_builtInCall7679 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_REGEX_in_regexExpression7700 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_regexExpression7702 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_expression_in_regexExpression7704 = new BitSet(new long[]{0x0000000400000000L});
	public static final BitSet FOLLOW_COMMA_in_regexExpression7706 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_expression_in_regexExpression7708 = new BitSet(new long[]{0x0000000420000000L});
	public static final BitSet FOLLOW_COMMA_in_regexExpression7712 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_expression_in_regexExpression7714 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_regexExpression7719 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SUBSTR_in_subStringExpression7749 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_subStringExpression7751 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_expression_in_subStringExpression7753 = new BitSet(new long[]{0x0000000400000000L});
	public static final BitSet FOLLOW_COMMA_in_subStringExpression7755 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_expression_in_subStringExpression7757 = new BitSet(new long[]{0x0000000420000000L});
	public static final BitSet FOLLOW_COMMA_in_subStringExpression7761 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_expression_in_subStringExpression7763 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_subStringExpression7768 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_EXISTS_in_existsFunction7798 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_groupGraphPattern_in_existsFunction7800 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NOT_in_notExistsFunction7825 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000080L});
	public static final BitSet FOLLOW_EXISTS_in_notExistsFunction7827 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_groupGraphPattern_in_notExistsFunction7829 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_COUNT_in_aggregate7854 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_aggregate7856 = new BitSet(new long[]{0x901F28110B030020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_DISTINCT_in_aggregate7858 = new BitSet(new long[]{0x801F28110B030020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_ASTERISK_in_aggregate7863 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_expression_in_aggregate7867 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_aggregate7871 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SUM_in_aggregate7894 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_aggregate7896 = new BitSet(new long[]{0x901F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_DISTINCT_in_aggregate7898 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_expression_in_aggregate7901 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_aggregate7903 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_MIN_in_aggregate7922 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_aggregate7924 = new BitSet(new long[]{0x901F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_DISTINCT_in_aggregate7926 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_expression_in_aggregate7929 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_aggregate7931 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_MAX_in_aggregate7950 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_aggregate7952 = new BitSet(new long[]{0x901F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_DISTINCT_in_aggregate7954 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_expression_in_aggregate7957 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_aggregate7959 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_AVG_in_aggregate7978 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_aggregate7980 = new BitSet(new long[]{0x901F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_DISTINCT_in_aggregate7982 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_expression_in_aggregate7985 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_aggregate7987 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SAMPLE_in_aggregate8006 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_aggregate8008 = new BitSet(new long[]{0x901F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_DISTINCT_in_aggregate8010 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_expression_in_aggregate8013 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_aggregate8015 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_GROUP_CONCAT_in_aggregate8034 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_OPEN_BRACE_in_aggregate8036 = new BitSet(new long[]{0x901F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_DISTINCT_in_aggregate8038 = new BitSet(new long[]{0x801F28110B020020L,0x5E09BECE32001493L,0xE0792000E0004945L,0x040072034167F703L});
	public static final BitSet FOLLOW_expression_in_aggregate8041 = new BitSet(new long[]{0x0000000020000000L,0x0000000000000000L,0x0200000000000000L});
	public static final BitSet FOLLOW_SEMICOLON_in_aggregate8045 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0400000000000000L});
	public static final BitSet FOLLOW_SEPARATOR_in_aggregate8047 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000040L});
	public static final BitSet FOLLOW_EQUAL_in_aggregate8049 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x000000000000F000L});
	public static final BitSet FOLLOW_string_in_aggregate8051 = new BitSet(new long[]{0x0000000020000000L});
	public static final BitSet FOLLOW_CLOSE_BRACE_in_aggregate8056 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_iriRef_in_iriRefOrFunction8091 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_iriRef_in_iriRefOrFunction8100 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_argList_in_iriRefOrFunction8102 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_string_in_rdfLiteral8133 = new BitSet(new long[]{0x0000000000000002L,0x0002000000000000L});
	public static final BitSet FOLLOW_LANGTAG_in_rdfLiteral8135 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_string_in_rdfLiteral8155 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000800000000000L});
	public static final BitSet FOLLOW_REFERENCE_in_rdfLiteral8157 = new BitSet(new long[]{0x0000000000000000L,0x0000008000000000L,0x00000000C0000000L});
	public static final BitSet FOLLOW_iriRef_in_rdfLiteral8159 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_numericLiteralUnsigned_in_numericLiteral8186 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_numericLiteralPositive_in_numericLiteral8194 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_numericLiteralNegative_in_numericLiteral8202 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IRI_REF_in_iriRef8385 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_prefixedName_in_iriRef8393 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_BLANK_NODE_LABEL_in_blankNode8435 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_anon_in_blankNode8443 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_OPEN_SQUARE_BRACKET_in_anon8460 = new BitSet(new long[]{0x0000000080000000L});
	public static final BitSet FOLLOW_CLOSE_SQUARE_BRACKET_in_anon8462 = new BitSet(new long[]{0x0000000000000002L});
}
