/*
 * Decompiled with CFR 0.152.
 */
package sparql;

import com.google.common.collect.Lists;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.sparql.algebra.Algebra;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.op.OpFilter;
import com.hp.hpl.jena.sparql.algebra.op.OpJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpLeftJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpQuadPattern;
import com.hp.hpl.jena.sparql.algebra.op.OpTable;
import com.hp.hpl.jena.sparql.algebra.op.OpUnion;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.core.QuadPattern;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.commons.collections.MapUtils;
import org.aksw.commons.util.Pair;
import org.aksw.jena_sparql_api.utils.QuadUtils;
import org.apache.commons.lang.NotImplementedException;
import sparql.IPatternSignature;
import sparql.PatternSignatureIndex;
import sparql.PatternTypeComparator;
import sparql.QuadSignature;

public class Equivalence {
    public static Set<Pair<QuadPattern, QuadPattern>> findIsomorphy(Op opA, Op opB, Map<Node, Node> state, Map<Node, Node> constraint) {
        HashSet<Pair<QuadPattern, QuadPattern>> result = new HashSet<Pair<QuadPattern, QuadPattern>>();
        if (!opA.getClass().equals(opB.getClass())) {
            return Collections.emptySet();
        }
        if (opA instanceof OpLeftJoin) {
            Set<Pair<QuadPattern, QuadPattern>> resultPartLeft = Equivalence.findIsomorphy(((OpLeftJoin)opA).getLeft(), ((OpLeftJoin)opB).getLeft(), state, constraint);
            Set<Pair<QuadPattern, QuadPattern>> resultPartRight = Equivalence.findIsomorphy(((OpLeftJoin)opA).getRight(), ((OpLeftJoin)opB).getRight(), state, constraint);
            result.addAll(resultPartLeft);
            result.addAll(resultPartRight);
            return result;
        }
        if (opA instanceof OpQuadPattern) {
            QuadPattern a = ((OpQuadPattern)opA).getPattern();
            QuadPattern b = ((OpQuadPattern)opB).getPattern();
            return Collections.singleton(Pair.create((Object)a, (Object)b));
        }
        if (opA instanceof OpJoin) {
            Set<Pair<QuadPattern, QuadPattern>> resultPartLeft = Equivalence.findIsomorphy(((OpJoin)opA).getLeft(), ((OpJoin)opB).getLeft(), state, constraint);
            Set<Pair<QuadPattern, QuadPattern>> resultPartRight = Equivalence.findIsomorphy(((OpJoin)opA).getRight(), ((OpJoin)opB).getRight(), state, constraint);
            result.addAll(resultPartLeft);
            result.addAll(resultPartRight);
            return result;
        }
        if (opA instanceof OpFilter) {
            Op a = ((OpFilter)opA).getSubOp();
            Op b = ((OpFilter)opB).getSubOp();
            return Equivalence.findIsomorphy(a, b, state, constraint);
        }
        if (opA instanceof OpUnion) {
            Set<Pair<QuadPattern, QuadPattern>> resultPartLeft = Equivalence.findIsomorphy(((OpUnion)opA).getLeft(), ((OpUnion)opB).getLeft(), state, constraint);
            Set<Pair<QuadPattern, QuadPattern>> resultPartRight = Equivalence.findIsomorphy(((OpUnion)opA).getRight(), ((OpUnion)opB).getRight(), state, constraint);
            result.addAll(resultPartLeft);
            result.addAll(resultPartRight);
            return result;
        }
        if (opA instanceof OpTable) {
            return result;
        }
        throw new NotImplementedException(opA.getClass());
    }

    public static Set<Map<Node, Node>> findIsomorphy(Query a, Query b) {
        Op opA = Algebra.compile((Query)a);
        opA = Algebra.toQuadForm((Op)opA);
        Op opB = Algebra.compile((Query)b);
        opB = Algebra.toQuadForm((Op)opB);
        return Equivalence.findIsomorphy(opA, opB);
    }

    public static Set<Map<Node, Node>> findIsomorphy(Op a, Op b) {
        HashMap<Node, Node> xstate = new HashMap<Node, Node>();
        HashMap<Node, Node> constraint = new HashMap<Node, Node>();
        Set<Pair<QuadPattern, QuadPattern>> pairs = Equivalence.findIsomorphy(a, b, xstate, constraint);
        ArrayList<Pair<Set<Quad>, Set<Quad>>> blockPairs = new ArrayList<Pair<Set<Quad>, Set<Quad>>>();
        for (Pair<QuadPattern, QuadPattern> pair : pairs) {
            PatternSignatureIndex qA = new PatternSignatureIndex((QuadPattern)pair.getKey());
            PatternSignatureIndex qB = new PatternSignatureIndex((QuadPattern)pair.getValue());
            ArrayList<IPatternSignature> patternOrder = new ArrayList<IPatternSignature>(qA.getTypeToPattern().keySet());
            Collections.sort(patternOrder, new PatternTypeComparator());
            for (IPatternSignature signature : patternOrder) {
                Set<Quad> qAs = qA.getTypeToPattern().get(signature);
                Set<Quad> qBs = qB.getTypeToPattern().get(signature);
                if (qBs == null) {
                    return Collections.emptySet();
                }
                blockPairs.add((Pair<Set<Quad>, Set<Quad>>)Pair.create(qAs, qBs));
            }
        }
        return Equivalence.findIsomorphy(new HashMap<Node, Node>(), blockPairs, 0);
    }

    public static Set<Map<Node, Node>> findIsomorphy(Map<Node, Node> in, List<Pair<Set<Quad>, Set<Quad>>> order, int index) {
        HashSet<Map<Node, Node>> result = new HashSet<Map<Node, Node>>();
        if (index >= order.size()) {
            if (in.isEmpty()) {
                return Collections.emptySet();
            }
            return Collections.singleton(in);
        }
        Pair<Set<Quad>, Set<Quad>> block = order.get(index);
        Set qAs = (Set)block.getKey();
        Set qBs = (Set)block.getValue();
        HashMap<Node, Node> state = new HashMap<Node, Node>();
        Set<Map<Node, Node>> mappings = Equivalence.getCompatibleMappings(qAs, qBs, state, in);
        for (Map<Node, Node> mapping : mappings) {
            HashMap<Node, Node> union = new HashMap<Node, Node>(in);
            union.putAll(mapping);
            result.addAll(Equivalence.findIsomorphy(union, order, index + 1));
        }
        return result;
    }

    public static Set<Map<Node, Node>> getCompatibleMappings(QuadPattern a, QuadPattern b, Map<Node, Node> state, Map<Node, Node> constraint) {
        return Equivalence.getCompatibleMappings(Lists.newArrayList((Iterable)a), Lists.newArrayList((Iterable)b), state, constraint);
    }

    public static Set<Map<Node, Node>> getCompatibleMappings(Collection<Quad> as, Collection<Quad> bs, Map<Node, Node> state, Map<Node, Node> constraint) {
        HashSet<Map<Node, Node>> result = new HashSet<Map<Node, Node>>();
        if (as.size() != bs.size()) {
            return result;
        }
        if (bs.isEmpty()) {
            result.add(state);
            return result;
        }
        for (Quad a : as) {
            ArrayList<Quad> remainingAs = new ArrayList<Quad>(as);
            remainingAs.remove(a);
            for (Quad b : bs) {
                ArrayList<Quad> remainingBs = new ArrayList<Quad>(bs);
                remainingBs.remove(b);
                Map<Node, Node> nodeMap = Equivalence.getVarMappingSpecialized(a, b);
                if (nodeMap == null || !MapUtils.isCompatible(state, nodeMap)) continue;
                HashMap<Node, Node> newState = new HashMap<Node, Node>(state);
                newState.putAll(nodeMap);
                if (!MapUtils.isCompatible(constraint, newState)) continue;
                Set<Map<Node, Node>> resultPart = Equivalence.getCompatibleMappings(remainingAs, remainingBs, newState, constraint);
                result.addAll(resultPart);
            }
        }
        return result;
    }

    public static Map<Node, Node> getVarMappingSpecialized(Quad a, Quad b) {
        List nAs = QuadUtils.quadToList((Quad)a);
        List nBs = QuadUtils.quadToList((Quad)b);
        HashMap<Node, Node> result = new HashMap<Node, Node>();
        for (int i = 0; i < 4; ++i) {
            Node nA = (Node)nAs.get(i);
            Node nB = (Node)nBs.get(i);
            assert (nA.isVariable() == nB.isVariable()) : "Should not happen, since the indexing by pattern type should prevent this case";
            if (nA.isVariable()) {
                Map<Node, Node> newEntry = Collections.singletonMap(nA, nB);
                assert (MapUtils.isCompatible(result, newEntry)) : "Should not happen, since the indexing by pattern type should prevent this case";
                result.putAll(newEntry);
                continue;
            }
            assert (nA.equals((Object)nB)) : "Should not happen, since the indexing by pattern type should prevent this case";
        }
        return result;
    }

    public static QuadSignature getSignature(Quad quad) {
        ArrayList<Node> result = new ArrayList<Node>();
        HashMap<Node, Integer> variableToId = new HashMap<Node, Integer>();
        for (Node node : QuadUtils.quadToList((Quad)quad)) {
            if (node.isVariable()) {
                Integer id = (Integer)variableToId.get(node);
                if (id == null) {
                    id = variableToId.size();
                    variableToId.put(node, id);
                }
                result.add(Node.createURI((String)("http://var.xxx/" + id)));
                continue;
            }
            result.add(node);
        }
        return new QuadSignature(result);
    }
}

