/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.web;

import com.jolbox.bonecp.BoneCPConfig;
import com.jolbox.bonecp.BoneCPDataSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.aksw.sparqlify.config.syntax.Config;
import org.aksw.sparqlify.config.v0_2.bridge.SchemaProviderImpl;
import org.aksw.sparqlify.config.v0_2.bridge.SyntaxBridge;
import org.aksw.sparqlify.core.cast.TypeSystem;
import org.aksw.sparqlify.core.domain.input.ViewDefinition;
import org.aksw.sparqlify.util.SparqlifyUtils;
import org.antlr.runtime.RecognitionException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.postgresql.ds.PGSimpleDataSource;
import org.slf4j.Logger;

public class SparqlifyCliHelper {
    public static void addDatabaseOptions(Options cliOptions) {
        cliOptions.addOption("t", "type", true, "Database type (posgres, mysql,...)");
        cliOptions.addOption("d", "database", true, "Database name");
        cliOptions.addOption("u", "username", true, "");
        cliOptions.addOption("p", "password", true, "");
        cliOptions.addOption("h", "hostname", true, "");
        cliOptions.addOption("c", "class", true, "JDBC driver class");
        cliOptions.addOption("j", "jdbcurl", true, "JDBC URL");
    }

    public static DataSource parseDataSource(CommandLine commandLine, Logger logger) {
        String hostName = commandLine.getOptionValue("h", "");
        String dbName = commandLine.getOptionValue("d", "");
        String userName = commandLine.getOptionValue("u", "");
        String passWord = commandLine.getOptionValue("p", "");
        String jdbcUrl = commandLine.getOptionValue("j", "");
        if (!(jdbcUrl.isEmpty() || hostName.isEmpty() && dbName.isEmpty())) {
            logger.error("Option 'j' is mutually exclusive with 'h' and 'd'");
            return null;
        }
        if (jdbcUrl.isEmpty() && hostName.isEmpty()) {
            hostName = "localhost";
        }
        PGSimpleDataSource dataSourceBean = null;
        if (jdbcUrl.isEmpty()) {
            dataSourceBean = new PGSimpleDataSource();
            dataSourceBean.setDatabaseName(dbName);
            dataSourceBean.setServerName(hostName);
            dataSourceBean.setUser(userName);
            dataSourceBean.setPassword(passWord);
        }
        BoneCPConfig cpConfig = new BoneCPConfig();
        if (jdbcUrl.isEmpty()) {
            cpConfig.setDatasourceBean((DataSource)dataSourceBean);
        } else {
            cpConfig.setJdbcUrl(jdbcUrl);
            cpConfig.setUsername(userName);
            cpConfig.setPassword(passWord);
        }
        cpConfig.setMinConnectionsPerPartition(2);
        cpConfig.setMaxConnectionsPerPartition(8);
        cpConfig.setConnectionTimeoutInMs(5000L);
        cpConfig.setPartitionCount(1);
        BoneCPDataSource dataSource = new BoneCPDataSource(cpConfig);
        return dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ViewDefinition> extractViewDefinitions(List<org.aksw.sparqlify.config.syntax.ViewDefinition> viewDefinitions, DataSource dataSource, TypeSystem typeSystem, Map<String, String> typeAlias, Logger logger) throws SQLException {
        List<ViewDefinition> result;
        Connection conn = dataSource.getConnection();
        try {
            SchemaProviderImpl schemaProvider = new SchemaProviderImpl(conn, typeSystem, typeAlias);
            SyntaxBridge syntaxBridge = new SyntaxBridge(schemaProvider);
            result = SyntaxBridge.bridge(syntaxBridge, viewDefinitions, logger);
        }
        finally {
            conn.close();
        }
        return result;
    }

    public static Integer parseInt(CommandLine commandLine, String optName, boolean mustExist, Logger logger) {
        String valueStr = commandLine.getOptionValue(optName);
        Integer result = null;
        if (valueStr == null) {
            if (mustExist) {
                logger.error("Argument required for option '" + optName + "'");
            }
        } else {
            try {
                result = Integer.parseInt(valueStr);
            }
            catch (Exception e) {
                logger.error("Integer value expected for argument '" + optName + "', got '" + valueStr + "' instead.");
            }
        }
        return result;
    }

    public static List<File> parseFiles(CommandLine commandLine, String optName, boolean mustExist, Logger logger) {
        String[] fileNames = commandLine.getOptionValues(optName);
        if (fileNames == null || fileNames.length == 0) {
            logger.error("File or folder name required for option '" + optName + "'");
            return null;
        }
        ArrayList<File> result = new ArrayList<File>();
        for (String fileName : fileNames) {
            File file = new File(fileName);
            if (mustExist && !file.exists()) {
                logger.error("File does not exist: " + fileName);
                return null;
            }
            result.add(file);
        }
        return result;
    }

    public static File parseFile(CommandLine commandLine, String optName, boolean mustExist, Logger logger) {
        String fileName = commandLine.getOptionValue(optName);
        if (fileName == null) {
            logger.error("File or folder name required for option '" + optName + "'");
            return null;
        }
        File file = new File(fileName);
        if (mustExist && !file.exists()) {
            logger.error("File does not exist: " + fileName);
            return null;
        }
        return file;
    }

    public static Config parseSmlConfigs(CommandLine commandLine, Logger logger) throws IOException, RecognitionException {
        List<File> configFiles = SparqlifyCliHelper.parseFiles(commandLine, "m", true, logger);
        if (configFiles == null) {
            return null;
        }
        Config result = null;
        for (File configFile : configFiles) {
            FileInputStream in = new FileInputStream(configFile);
            Config tmp = SparqlifyUtils.parseSmlConfig(in, logger);
            if (result == null) {
                result = tmp;
                continue;
            }
            result.merge(tmp);
        }
        return result;
    }

    public static Config parseSmlConfig(CommandLine commandLine, Logger logger) throws IOException, RecognitionException {
        File configFile = SparqlifyCliHelper.parseFile(commandLine, "m", true, logger);
        if (configFile == null) {
            return null;
        }
        FileInputStream in = new FileInputStream(configFile);
        Config result = SparqlifyUtils.parseSmlConfig(in, logger);
        return result;
    }
}

