/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.csv;

import au.com.bytecode.opencsv.CSVReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import org.aksw.commons.collections.SinglePrefetchIterator;

class CsvRowIterator
extends SinglePrefetchIterator<List<String>> {
    private CSVReader reader;
    private boolean isReaderClosable = true;

    public CsvRowIterator(File file) throws FileNotFoundException {
        this(new CSVReader((Reader)new FileReader(file)));
    }

    public CsvRowIterator(CSVReader reader) {
        this.reader = reader;
    }

    protected List<String> prefetch() throws Exception {
        String[] cells = this.reader.readNext();
        if (cells == null) {
            return (List)this.finish();
        }
        List<String> result = Arrays.asList(cells);
        return result;
    }

    public void close() {
        if (this.isReaderClosable) {
            try {
                this.reader.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

