/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.csv;

import au.com.bytecode.opencsv.CSVReader;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.io.InputSupplier;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.QuadPattern;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.core.VarExprList;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.syntax.Template;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import jxl.Sheet;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.read.biff.BiffException;
import org.aksw.jena_sparql_api.core.ConstructIterator;
import org.aksw.jena_sparql_api.core.ResultSetClosable;
import org.aksw.jena_sparql_api.utils.QuadPatternUtils;
import org.aksw.sparqlify.algebra.sparql.transform.SparqlSubstitute;
import org.aksw.sparqlify.config.lang.TemplateConfigParser;
import org.aksw.sparqlify.config.syntax.NamedViewTemplateDefinition;
import org.aksw.sparqlify.config.syntax.TemplateConfig;
import org.aksw.sparqlify.config.syntax.ViewTemplateDefinition;
import org.aksw.sparqlify.core.RdfViewSystemOld;
import org.aksw.sparqlify.core.ResultSetSparqlify;
import org.aksw.sparqlify.core.domain.input.RestrictedExpr;
import org.aksw.sparqlify.core.sparql.IteratorResultSetSparqlifyBinding;
import org.aksw.sparqlify.csv.CellToStringTransformer;
import org.aksw.sparqlify.csv.CsvParserConfig;
import org.aksw.sparqlify.csv.CsvRowIterator;
import org.aksw.sparqlify.csv.InputSupplierCSVReader;
import org.aksw.sparqlify.csv.ReaderCSVReader;
import org.aksw.sparqlify.csv.TripleIteratorState;
import org.aksw.sparqlify.csv.TripleIteratorTracking;
import org.aksw.sparqlify.csv.XlsRowIterator;
import org.aksw.sparqlify.validation.LoggerCount;
import org.aksw.sparqlify.web.HttpSparqlEndpoint;
import org.aksw.sparqlify.web.SparqlFormatterUtils;
import org.antlr.runtime.RecognitionException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.lang.StringUtils;
import org.apache.jena.atlas.lib.MapUtils;
import org.h2.tools.Csv;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvMapperCliMain {
    private static final Logger logger = LoggerFactory.getLogger(CsvMapperCliMain.class);
    private static final Options cliOptions = new Options();

    public static void printHelpAndExit(int exitCode) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(HttpSparqlEndpoint.class.getName(), cliOptions);
        System.exit(exitCode);
    }

    public static File extractFile(CommandLine commandLine, String optionName) {
        File file;
        String filename = commandLine.getOptionValue(optionName);
        String optionLabel = optionName;
        if (filename == null) {
            logger.error("No file given for option: " + optionLabel);
            CsvMapperCliMain.printHelpAndExit(-1);
        }
        if (!(file = new File(filename)).exists()) {
            logger.error("File given as argument for option " + optionLabel + " does not exist: " + file.getAbsolutePath());
            CsvMapperCliMain.printHelpAndExit(-1);
        }
        return file;
    }

    public static boolean isNullOrVar(Node node) {
        return node == null || node.isVariable();
    }

    public static boolean containsNullOrVar(Triple triple) {
        boolean s = CsvMapperCliMain.isNullOrVar(triple.getSubject());
        boolean p = CsvMapperCliMain.isNullOrVar(triple.getPredicate());
        boolean o = CsvMapperCliMain.isNullOrVar(triple.getObject());
        boolean result = s || p || o;
        return result;
    }

    public static void countVariable(Node node, Map<Var, Integer> countMap) {
        if (node == null) {
            MapUtils.increment(countMap, null);
        } else if (node.isVariable()) {
            MapUtils.increment(countMap, (Object)((Var)node));
        }
    }

    public static void show(Reader reader) {
        BufferedReader br = new BufferedReader(reader);
        try {
            String line;
            while ((line = br.readLine()) != null) {
                System.out.println(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TemplateConfig readTemplateConfig(InputStream in, Logger loggerCount) throws IOException, RecognitionException {
        TemplateConfig config;
        TemplateConfigParser parser = new TemplateConfigParser();
        try {
            config = parser.parse(in, loggerCount);
        }
        finally {
            in.close();
        }
        return config;
    }

    public static Character parseChar(String str) {
        Character result;
        if ((str = str.trim()).startsWith("\\")) {
            String charValue = str.substring(1);
            int val = Integer.parseInt(charValue);
            if (val < 0 || val > 65535) {
                throw new RuntimeException("Character value must be in the range 0-65535");
            }
            result = Character.valueOf((char)val);
        } else if (str.startsWith("0x")) {
            String hex = str.substring(2);
            int val = 0;
            for (int i = 0; i < hex.length(); ++i) {
                String s = hex.substring(i, i + 1);
                char part = (char)Integer.parseInt(s, 16);
                val <<= 4;
                if ((val |= part) >= 0 && val <= 65535) continue;
                throw new RuntimeException("Character must be in the range 0x0-0x" + Integer.toHexString(65535));
            }
            result = Character.valueOf((char)val);
        } else {
            if (str.length() > 1) {
                throw new RuntimeException("Only a singe character allowed.");
            }
            result = Character.valueOf(str.charAt(0));
        }
        return result;
    }

    public static Character getChar(Logger logger, CommandLine commandLine, String opt) {
        Character result = null;
        String resultStr = commandLine.getOptionValue(opt, null);
        if (!StringUtils.isEmpty((String)resultStr)) {
            try {
                result = CsvMapperCliMain.parseChar(resultStr);
            }
            catch (Exception e) {
                logger.error("Error parsing command line argument -" + opt + " " + resultStr + ": " + e.getClass().getSimpleName() + " for " + e.getMessage());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        TemplateConfig config;
        GnuParser cliParser = new GnuParser();
        cliOptions.addOption("c", "config", true, "Sparqlify config file");
        cliOptions.addOption("f", "config", true, "Input data file");
        cliOptions.addOption("v", "config", true, "View name (only needed if config contains more than one view)");
        cliOptions.addOption("h", "config", false, "Use first row as headers");
        cliOptions.addOption("s", "config", true, "CSV field separator (default is ',')");
        cliOptions.addOption("d", "config", true, "CSV field delimiter (default is '\"')");
        cliOptions.addOption("e", "config", true, "CSV field escape delimiter (escapes the field delimiter) (default is '\\')");
        CommandLine commandLine = cliParser.parse(cliOptions, args);
        File configFile = CsvMapperCliMain.extractFile(commandLine, "c");
        File dataFile = CsvMapperCliMain.extractFile(commandLine, "f");
        String viewName = StringUtils.trim((String)commandLine.getOptionValue("v"));
        LoggerCount loggerCount = new LoggerCount(logger);
        CsvParserConfig csvConfig = new CsvParserConfig();
        csvConfig.setFieldDelimiter(CsvMapperCliMain.getChar((Logger)loggerCount, commandLine, "d"));
        csvConfig.setEscapeCharacter(CsvMapperCliMain.getChar((Logger)loggerCount, commandLine, "e"));
        csvConfig.setFieldSeparator(CsvMapperCliMain.getChar((Logger)loggerCount, commandLine, "s"));
        boolean useFirstRowAsHeaderNames = commandLine.hasOption("h");
        FileInputStream in = new FileInputStream(configFile);
        try {
            config = CsvMapperCliMain.readTemplateConfig(in, (Logger)loggerCount);
        }
        finally {
            ((InputStream)in).close();
        }
        logger.info("Errors: " + loggerCount.getErrorCount() + ", Warnings: " + loggerCount.getWarningCount());
        if (loggerCount.getErrorCount() > 0) {
            throw new RuntimeException("Encountered " + loggerCount.getErrorCount() + " errors that need to be fixed first.");
        }
        List<NamedViewTemplateDefinition> views = config.getDefinitions();
        if (views.isEmpty()) {
            logger.warn("No view definitions found");
        }
        Map<String, NamedViewTemplateDefinition> viewIndex = CsvMapperCliMain.indexViews(views, (Logger)loggerCount);
        ViewTemplateDefinition view = CsvMapperCliMain.pickView(viewIndex, viewName);
        FileReader fileReader = new FileReader(dataFile);
        InputSupplierCSVReader csvReaderSupplier = new InputSupplierCSVReader(dataFile, csvConfig);
        java.sql.ResultSet resultSet = CsvMapperCliMain.createResultSetFromCsv(csvReaderSupplier, useFirstRowAsHeaderNames, 100);
        TripleIteratorTracking trackingIt = CsvMapperCliMain.createTripleIterator(resultSet, view);
        SparqlFormatterUtils.writeText((OutputStream)System.out, (Iterator<Triple>)((Object)trackingIt));
        CsvMapperCliMain.writeSummary(System.err, trackingIt.getState());
    }

    public static Map<String, NamedViewTemplateDefinition> indexViews(List<NamedViewTemplateDefinition> views, Logger loggerCount) {
        HashMap<String, NamedViewTemplateDefinition> nameToView = new HashMap<String, NamedViewTemplateDefinition>();
        for (NamedViewTemplateDefinition view : views) {
            String name = view.getName();
            if (nameToView.containsKey(name)) {
                loggerCount.warn("Omitting duplicate view definition: " + name);
            }
            nameToView.put(name, view);
        }
        return nameToView;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ViewTemplateDefinition pickView(Map<String, NamedViewTemplateDefinition> index, String viewName) {
        ViewTemplateDefinition view = null;
        if (StringUtils.isEmpty((String)viewName)) {
            if (index.size() != 1) throw new RuntimeException("Multiple views exist. Please specify which one to use");
            return index.values().iterator().next();
        }
        view = index.get(viewName);
        if (view != null) return view;
        throw new RuntimeException("View '" + viewName + "' not found");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static java.sql.ResultSet createResultSetFromCsv(InputSupplier<? extends CSVReader> csvReaderSupplier, boolean useHeaders, Integer sampleSize) throws IOException {
        sampleSize = sampleSize == null ? 100 : sampleSize;
        CSVReader headerReader = (CSVReader)csvReaderSupplier.getInput();
        ArrayList<String> columnNames = new ArrayList<String>();
        try {
            String[] row;
            for (int i = 0; (row = headerReader.readNext()) != null && i < sampleSize; ++i) {
                if (i == 0 && useHeaders) {
                    columnNames.addAll(Arrays.asList(row));
                }
                int delta = row.length - columnNames.size();
                for (int j = 0; j < delta; ++j) {
                    columnNames.add("" + (i + j));
                }
            }
        }
        finally {
            headerReader.close();
        }
        CSVReader dataReader = (CSVReader)csvReaderSupplier.getInput();
        if (useHeaders) {
            dataReader.readNext();
        }
        ReaderCSVReader reader = new ReaderCSVReader(dataReader);
        Csv csv = new Csv();
        csv.setEscapeCharacter('\\');
        String[] colNames = columnNames.toArray(new String[0]);
        java.sql.ResultSet result = csv.read((Reader)reader, colNames);
        logger.debug("Detected column names: " + columnNames);
        return result;
    }

    public static TripleIteratorTracking createTripleIterator(java.sql.ResultSet rs, ViewTemplateDefinition view) {
        RdfViewSystemOld.initSparqlifyFunctions();
        VarExprList varExprs = view.getVarExprList();
        ArrayList<String> vars = new ArrayList<String>();
        for (Var var : varExprs.getVars()) {
            vars.add(var.getName());
        }
        HashMultimap sparqlVarMap = HashMultimap.create();
        for (Map.Entry entry : varExprs.getExprs().entrySet()) {
            Expr e = SparqlSubstitute.substituteExpr((Expr)entry.getValue());
            sparqlVarMap.put(entry.getKey(), (Object)new RestrictedExpr(e));
        }
        IteratorResultSetSparqlifyBinding itBinding = new IteratorResultSetSparqlifyBinding(null, rs, (Multimap<Var, RestrictedExpr>)sparqlVarMap, 1L, "rowId");
        ResultSetSparqlify rss = new ResultSetSparqlify((Iterator<Binding>)((Object)itBinding), vars, 0);
        QuadPattern quadPattern = view.getConstructTemplate();
        BasicPattern bgp = QuadPatternUtils.toBasicPattern((QuadPattern)quadPattern);
        Template template = new Template(bgp);
        ResultSetClosable closableRs = new ResultSetClosable((ResultSet)rss);
        ConstructIterator it = new ConstructIterator(template, (ResultSet)closableRs);
        TripleIteratorTracking result = new TripleIteratorTracking((Iterator<Triple>)it);
        return result;
    }

    public static void writeSummary(PrintStream out, TripleIteratorState state) {
        int totalTripleCount = state.getTotalTripleCount();
        int tripleGenCount = state.getTripleGenCount();
        Map<Var, Integer> varCountMap = state.getVarCountMap();
        int omittedTripleCount = totalTripleCount - tripleGenCount;
        System.err.println("Variable\t#Unbound");
        for (Map.Entry<Var, Integer> entry : varCountMap.entrySet()) {
            Var var = entry.getKey();
            Integer count = entry.getValue();
            System.err.println(var + ":\t" + count);
        }
        System.err.println("Triples generated:\t" + tripleGenCount);
        System.err.println("Potential triples omitted:\t" + omittedTripleCount);
        System.err.println("Triples total:\t" + totalTripleCount);
    }

    public static Iterator<List<String>> getCsvIterator(File file, String columnSeparator) throws FileNotFoundException {
        CsvRowIterator result = new CsvRowIterator(file);
        return result;
    }

    public static Iterator<List<String>> getXlsCsvIterator(File file, int sheetIndex) throws BiffException, IOException {
        WorkbookSettings ws = new WorkbookSettings();
        ws.setLocale(new Locale("en", "EN"));
        Workbook w = Workbook.getWorkbook((File)file, (WorkbookSettings)ws);
        if (sheetIndex >= w.getNumberOfSheets()) {
            throw new IndexOutOfBoundsException("Attemp to access sheet " + sheetIndex + "/" + w.getNumberOfSheets());
        }
        Sheet s = w.getSheet(sheetIndex);
        XlsRowIterator<String> result = new XlsRowIterator<String>(s, 0, CellToStringTransformer.getInstance(), w);
        return result;
    }
}

