/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.transformations;

import com.hp.hpl.jena.sparql.expr.E_Function;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprFunction;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.vocabulary.XSD;
import java.util.ArrayList;
import java.util.List;
import org.aksw.sparqlify.algebra.sparql.expr.E_RdfTerm;
import org.aksw.sparqlify.core.SparqlifyConstants;
import org.aksw.sparqlify.core.transformations.ExprTransformer;
import org.aksw.sparqlify.expr.util.ExprUtils;
import org.aksw.sparqlify.type_system.CandidateMethod;
import org.aksw.sparqlify.type_system.FunctionModel;
import org.aksw.sparqlify.type_system.MethodDeclaration;
import org.aksw.sparqlify.type_system.TypeSystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExprTransformerSparqlFunctionModel
implements ExprTransformer {
    private static final Logger logger = LoggerFactory.getLogger(ExprTransformerSparqlFunctionModel.class);
    private static E_RdfTerm typeError = E_RdfTerm.createTypedLiteral((Expr)SparqlifyConstants.nvTypeError, (Expr)SparqlifyConstants.nvTypeError);
    private FunctionModel<String> sparqlModel;

    public ExprTransformerSparqlFunctionModel(FunctionModel<String> sparqlModel) {
        this.sparqlModel = sparqlModel;
    }

    public static List<Expr> getTermValues(List<E_RdfTerm> rdfTerms) {
        ArrayList<Expr> result = new ArrayList<Expr>(rdfTerms.size());
        for (E_RdfTerm rdfTerm : rdfTerms) {
            Expr item = rdfTerm.getLexicalValue();
            result.add(item);
        }
        return result;
    }

    @Override
    public E_RdfTerm transform(Expr orig, List<E_RdfTerm> exprs) {
        ExprFunction fn = orig.getFunction();
        String fnName = ExprUtils.getFunctionId(fn);
        ArrayList<String> argTypes = new ArrayList<String>(exprs.size());
        for (E_RdfTerm rdfTerm : exprs) {
            Expr termType = rdfTerm.getType();
            Expr datatype = rdfTerm.getDatatype();
            if (!termType.isConstant()) {
                logger.debug("Yielding type error because termType is not a contant in: " + (Object)((Object)rdfTerm) + " from " + orig + " with " + exprs);
                return typeError;
            }
            int termTypeVal = termType.getConstant().getDecimal().intValue();
            if (!datatype.isConstant()) {
                logger.debug("Yielding type error because datatype is not a contant in: " + (Object)((Object)rdfTerm) + " from " + orig + " with " + exprs);
                return typeError;
            }
            NodeValue nodeValue = datatype.getConstant();
            if (nodeValue.equals((Object)SparqlifyConstants.nvTypeError)) {
                logger.debug("Passing on type error for: " + fnName + " " + exprs);
                return typeError;
            }
            if (!nodeValue.isString()) {
                logger.debug("Yielding type error because datatype is not a string for: " + fnName + " " + exprs);
                return typeError;
            }
            String datatypeStr = nodeValue.asUnquotedString();
            if (termTypeVal == 2) {
                if (!datatypeStr.trim().isEmpty()) {
                    logger.debug("Yielding type error because termType has a language tag in : " + (Object)((Object)rdfTerm) + " from " + orig + " with " + exprs);
                    return typeError;
                }
                datatypeStr = XSD.xstring.toString();
            } else if (termTypeVal != 3) {
                logger.debug("Yielding type error because termType is not 3 (typed literal) in: " + (Object)((Object)rdfTerm) + " from " + orig + " with " + exprs);
                return typeError;
            }
            argTypes.add(datatypeStr);
        }
        CandidateMethod candidate = TypeSystemUtils.lookupCandidate(this.sparqlModel, (String)fnName, argTypes);
        if (candidate == null) {
            logger.debug("Yielding type error because no suitable candidate found for " + fnName + " with " + argTypes);
            return typeError;
        }
        MethodDeclaration dec = candidate.getMethod().getDeclaration();
        String name = dec.getName();
        String returnType = (String)dec.getSignature().getReturnType();
        NodeValue nvReturnType = NodeValue.makeString((String)returnType);
        ExprList newArgs = new ExprList(ExprTransformerSparqlFunctionModel.getTermValues(exprs));
        E_Function exprFn = new E_Function(name, newArgs);
        E_RdfTerm result = E_RdfTerm.createTypedLiteral((Expr)exprFn, (Expr)nvReturnType);
        return result;
    }
}

