/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.transformations;

import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.sparql.expr.E_Conditional;
import com.hp.hpl.jena.sparql.expr.E_Equals;
import com.hp.hpl.jena.sparql.expr.E_LogicalAnd;
import com.hp.hpl.jena.sparql.expr.E_LogicalOr;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprFunction;
import com.hp.hpl.jena.sparql.expr.ExprFunction2;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import org.aksw.commons.factory.Factory2;
import org.aksw.sparqlify.algebra.sparql.expr.E_RdfTerm;
import org.aksw.sparqlify.core.SparqlifyConstants;
import org.aksw.sparqlify.core.algorithms.ExprFactoryUtils;
import org.aksw.sparqlify.core.transformations.ExprTransformerBase2;
import org.aksw.sparqlify.core.transformations.SqlTranslationUtils;
import org.aksw.sparqlify.trash.ExprCopy;

public class ExprTransformerRdfTermComparator
extends ExprTransformerBase2 {
    private Resource resultType;
    public static final NodeValue two = NodeValue.makeDecimal((long)2L);
    public static final NodeValue three = NodeValue.makeDecimal((long)3L);

    public ExprTransformerRdfTermComparator(Resource resultType) {
        this.resultType = resultType;
    }

    public Expr handleConcat(ExprFunction fn) {
        Expr result = SqlTranslationUtils.optimizeOpConcat(fn);
        return result;
    }

    @Override
    public E_RdfTerm transform(Expr orig, E_RdfTerm a, E_RdfTerm b) {
        Expr innerExpr;
        Expr va = a.getLexicalValue();
        Expr vb = b.getLexicalValue();
        Expr test = ExprCopy.getInstance().copy(orig, va, vb);
        Expr testResult = this.handleConcat((ExprFunction)test);
        if (testResult == null) {
            Factory2<Expr> exprFactory = ExprFactoryUtils.createCopyFactory2((ExprFunction2)orig);
            Expr tmpEqV = exprFactory.create(a.getLexicalValue(), b.getLexicalValue());
            innerExpr = (ExprFunction2)tmpEqV;
        } else {
            innerExpr = testResult;
        }
        E_RdfTerm result = ExprTransformerRdfTermComparator.processOpRdfTerm(a, b, innerExpr, this.resultType);
        return result;
    }

    public static Expr createTypeCheck(E_RdfTerm a, E_RdfTerm b) {
        NodeValue result;
        Expr at = a.getType();
        Expr bt = b.getType();
        if (at.isConstant() && bt.isConstant()) {
            boolean isCompatibleTypes;
            NodeValue x = at.getConstant();
            NodeValue y = at.getConstant();
            boolean isSameValue = NodeValue.sameAs((NodeValue)x, (NodeValue)y);
            boolean isBothLiterals = !(!NodeValue.sameAs((NodeValue)x, (NodeValue)two) && !NodeValue.sameAs((NodeValue)x, (NodeValue)three) || !NodeValue.sameAs((NodeValue)y, (NodeValue)two) && !NodeValue.sameAs((NodeValue)y, (NodeValue)three));
            boolean bl = isCompatibleTypes = isSameValue || isBothLiterals;
            result = isCompatibleTypes ? NodeValue.TRUE : SparqlifyConstants.nvTypeError;
        } else {
            E_Equals eqTmpA = new E_Equals(a.getType(), b.getType());
            E_LogicalAnd e = new E_LogicalAnd((Expr)new E_LogicalOr((Expr)new E_Equals(a.getType(), (Expr)NodeValue.makeDecimal((long)2L)), (Expr)new E_Equals(a.getType(), (Expr)NodeValue.makeDecimal((long)3L))), (Expr)new E_LogicalOr((Expr)new E_Equals(b.getType(), (Expr)NodeValue.makeDecimal((long)2L)), (Expr)new E_Equals(b.getType(), (Expr)NodeValue.makeDecimal((long)3L))));
            result = new E_LogicalOr((Expr)eqTmpA, (Expr)e);
        }
        return result;
    }

    public static E_RdfTerm processOpRdfTerm(E_RdfTerm a, E_RdfTerm b, Expr innerExpr, Resource resultType) {
        Expr eqTA = ExprTransformerRdfTermComparator.createTypeCheck(a, b);
        E_Conditional eqT = new E_Conditional(eqTA, (Expr)NodeValue.TRUE, (Expr)SparqlifyConstants.nvTypeError);
        Expr eqV = innerExpr;
        NodeValue eqD = NodeValue.TRUE;
        E_Equals eqL = new E_Equals(a.getLanguageTag(), b.getLanguageTag());
        E_LogicalAnd tmp = new E_LogicalAnd((Expr)new E_LogicalAnd((Expr)eqT, eqV), (Expr)new E_LogicalAnd((Expr)eqD, (Expr)eqL));
        E_RdfTerm result = E_RdfTerm.createTypedLiteral((Expr)tmp, resultType);
        return result;
    }
}

