/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.transformations;

import com.hp.hpl.jena.sparql.expr.E_Equals;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.vocabulary.XSD;
import java.util.ArrayList;
import java.util.List;
import org.aksw.jena_sparql_api.utils.ExprUtils;
import org.aksw.sparqlify.algebra.sparql.expr.E_RdfTerm;
import org.aksw.sparqlify.core.transformations.ExprTransformer;

public class ExprTransformerOneOf
implements ExprTransformer {
    @Override
    public E_RdfTerm transform(Expr orig, List<E_RdfTerm> exprs) {
        E_RdfTerm a = exprs.get(0);
        ArrayList<E_RdfTerm> bs = new ArrayList<E_RdfTerm>(exprs.size() - 1);
        for (int i = 1; i < exprs.size(); ++i) {
            E_RdfTerm tmp = exprs.get(i);
            bs.add(tmp);
        }
        Expr termTypeA = a.getType();
        if (!termTypeA.isConstant()) {
            throw new RuntimeException("Term type is expected to be a constant: " + termTypeA + " in expression " + orig + " as " + exprs);
        }
        ArrayList<E_Equals> es = new ArrayList<E_Equals>(exprs.size());
        for (E_RdfTerm b : bs) {
            Expr termTypeB = b.getType();
            if (!termTypeB.isConstant()) {
                throw new RuntimeException("Term type is expected to be a constant: " + termTypeB + " in expression " + orig + " as " + exprs);
            }
            boolean isEqual = termTypeA.getConstant().equals((Object)termTypeB.getConstant());
            if (!isEqual) continue;
            E_Equals e = new E_Equals(a.getLexicalValue(), b.getLexicalValue());
            es.add(e);
        }
        Object or = es.isEmpty() ? NodeValue.FALSE : ExprUtils.orifyBalanced(es);
        E_RdfTerm result = E_RdfTerm.createTypedLiteral((Expr)or, XSD.xboolean);
        return result;
    }
}

