/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.sparql;

import com.google.common.base.Function;
import com.google.common.collect.Multimap;
import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingHashMap;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.util.ExprUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.aksw.sparqlify.core.MakeExprPermissive;
import org.aksw.sparqlify.core.domain.input.RestrictedExpr;
import org.aksw.sparqlify.core.sparql.IteratorResultSetSparqlifyBinding;
import org.apache.jena.riot.process.normalize.CanonicalizeLiteral;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemProcessorSparqlify
implements Function<Binding, Binding> {
    private static final Logger logger = LoggerFactory.getLogger(IteratorResultSetSparqlifyBinding.class);
    private static CanonicalizeLiteral canonicalizer = CanonicalizeLiteral.get();
    private Multimap<Var, RestrictedExpr> sparqlVarMap;

    public static boolean isCharType(String typeName) {
        String tmp = typeName.toLowerCase();
        HashSet<String> charNames = new HashSet<String>(Arrays.asList("char"));
        boolean result = charNames.contains(tmp);
        return result;
    }

    public ItemProcessorSparqlify(Multimap<Var, RestrictedExpr> sparqlVarMap) {
        this.sparqlVarMap = sparqlVarMap;
    }

    public Binding apply(@Nullable Binding binding) {
        Binding result = ItemProcessorSparqlify.process(this.sparqlVarMap, binding);
        return result;
    }

    public static Binding process(Multimap<Var, RestrictedExpr> sparqlVarMap, Binding binding) {
        boolean debugMode = true;
        BindingHashMap result = new BindingHashMap();
        for (Map.Entry entry : sparqlVarMap.asMap().entrySet()) {
            Node resultValue;
            Var bindingVar = (Var)entry.getKey();
            Collection candidateExprs = (Collection)entry.getValue();
            NodeValue value = null;
            HashSet usedVars = new HashSet();
            for (RestrictedExpr def : candidateExprs) {
                Expr expr = def.getExpr();
                boolean allBound = true;
                Set exprVars = expr.getVarsMentioned();
                for (Var var : exprVars) {
                    if (binding.contains(var)) continue;
                    allBound = false;
                    break;
                }
                if (!allBound) continue;
                if (value != null) {
                    if (usedVars.containsAll(expr.getVarsMentioned())) continue;
                    if (usedVars.equals(expr.getVarsMentioned())) {
                        throw new RuntimeException("Multiple expressions binding the variable (ambiguity) " + bindingVar + ": " + entry.getValue());
                    }
                    if (!expr.getVarsMentioned().containsAll(usedVars)) {
                        throw new RuntimeException("Multiple expressions binding the variable (overlap) " + bindingVar + ": " + entry.getValue());
                    }
                }
                expr = MakeExprPermissive.getInstance().deepCopy(expr);
                value = ExprUtils.eval((Expr)expr, (Binding)binding);
                if (debugMode) continue;
                break;
            }
            Node node = resultValue = value == null ? null : value.asNode();
            if (resultValue == null) {
                logger.trace("Null node for variable " + bindingVar + " - Might be undesired.");
                continue;
            }
            boolean isDatatypeCanonicalization = false;
            Node canonResultValue = canonicalizer.convert(resultValue);
            if (!isDatatypeCanonicalization && canonResultValue.isLiteral()) {
                String lex = canonResultValue.getLiteralLexicalForm();
                if (resultValue.isLiteral()) {
                    RDFDatatype originalType = resultValue.getLiteralDatatype();
                    if (originalType != null) {
                        canonResultValue = Node.createLiteral((String)lex, (RDFDatatype)originalType);
                    }
                } else {
                    throw new RuntimeException("Should not happen: Non-literal canonicalized to literal: " + resultValue + " became " + canonResultValue);
                }
            }
            result.add(bindingVar, canonResultValue);
        }
        return result;
    }
}

