/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.core.algorithms;

import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprFunction;
import com.hp.hpl.jena.sparql.expr.ExprList;
import java.util.ArrayList;
import org.aksw.sparqlify.core.algorithms.ExprTransformer;
import org.aksw.sparqlify.core.transformations.SqlTranslationUtils;
import org.aksw.sparqlify.trash.ExprCopy;

public class ExprTransformerConcatNested
implements ExprTransformer {
    @Override
    public Expr transform(ExprFunction fn) {
        ArrayList<Expr> newArgs = new ArrayList<Expr>();
        for (Expr arg : fn.getArgs()) {
            if (SqlTranslationUtils.isConcatExpr(arg)) {
                ExprFunction fnArg = arg.getFunction();
                for (Expr a : fnArg.getArgs()) {
                    newArgs.add(a);
                }
                continue;
            }
            newArgs.add(arg);
        }
        ExprList merged = SqlTranslationUtils.mergeConsecutiveConstants(newArgs);
        Expr result = ExprCopy.getInstance().copy((Expr)fn, merged);
        return result;
    }
}

