/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.algebra.sql.nodes;

import java.util.List;
import org.aksw.sparqlify.algebra.sql.nodes.Schema;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOp;
import org.aksw.sparqlify.algebra.sql.nodes.SqlOpLeaf;
import org.apache.jena.atlas.io.IndentedWriter;

public class SqlOpTable
extends SqlOpLeaf {
    private String tableName;

    public SqlOpTable(Schema schema, String tableName) {
        this(schema, tableName, null);
    }

    public SqlOpTable(Schema schema, String tableName, String aliasName) {
        this(schema, tableName, aliasName, false);
    }

    public SqlOpTable(Schema schema, String tableName, String aliasName, boolean isEmpty) {
        super(schema, isEmpty, aliasName);
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    @Override
    public void write(IndentedWriter writer) {
        String aliasPart = this.aliasName == null ? " AS anonymous" : " AS " + this.aliasName;
        writer.print("SqlOpTable[" + this.tableName + aliasPart + "]");
    }

    @Override
    public String toString() {
        return "SqlOpTable [tableName=" + this.tableName + ", aliasName=" + this.aliasName + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.aliasName == null ? 0 : this.aliasName.hashCode());
        result = 31 * result + (this.tableName == null ? 0 : this.tableName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SqlOpTable other = (SqlOpTable)obj;
        if (this.aliasName == null ? other.aliasName != null : !this.aliasName.equals(other.aliasName)) {
            return false;
        }
        return !(this.tableName == null ? other.tableName != null : !this.tableName.equals(other.tableName));
    }

    @Override
    public String getId() {
        return this.tableName;
    }

    @Override
    public SqlOp copy(Schema schema, List<SqlOp> newArgs) {
        SqlOpTable result = new SqlOpTable(schema, this.tableName, this.aliasName, this.isEmpty);
        return result;
    }
}

